SELECT *
FROM
(
  SELECT mydt10.nr01, 
         mydt10.uid as uid,
         mydt10.mark as mark,

         mydt12.nr01 as nr01_1, 
         mydt12.linenumber as lineNumber,
         mydt12.mydt61_p00 as classificationType,
         mydt12.mydt57_p00 as classificationCategory,
         mydt12.netvalue + mydt12.wthhld_am + mydt12.fees_am + mydt12.otax_am as amount,

         ifnull( (select sum(if(mydt12_in.mydt57_p00='' || mydt12_in.mydt61_p00='', 1, 0))
                  from mydt12 as mydt12_in
                  where mydt12_in.mydt10=mydt10.nr01
                  group by mydt12_in.mydt10), 0) as nomarked, 
         ifnull( (select sum(if(mydt12_in.mydt57_p00='' || mydt12_in.mydt61_p00='', 0, 1))
                  from mydt12 as mydt12_in
                  where mydt12_in.mydt10=mydt10.nr01
                  group by mydt12_in.mydt10), 0) as marked
                  
         
   FROM mydt10, mydt12
   WHERE mydt12.mydt10=mydt10.nr01
      && mydt10.mark<>''
      && mydt10.entuid=''
      && mydt10.p00=1
      && mydt10.p01=2
      && mydt10.nr01 in (##mydt10_nr01s##)
   ORDER BY mydt10.issueDate, mydt10.nr01, mydt12.linenumber
) as tbl01
WHERE nomarked=0
   && marked<>0;
