/*****************************************************
       update old records 
*****************************************************/
update mydt10, {p_mydt10tbl1} as tbl1
set mydt10.is_vat         = tbl1.is_vat     ,
    mydt10.is_country     = tbl1.is_country ,
    mydt10.is_branch      = tbl1.is_branch  ,
    mydt10.is_name        = tbl1.is_name    ,
    mydt10.is_address     = tbl1.is_address ,
    mydt10.is_city        = tbl1.is_city    ,
    mydt10.is_zip         = tbl1.is_zip     ,

    mydt10.is_tbl         = tbl1.is_tbl     ,
    mydt10.is_nr01        = tbl1.is_nr01    ,

    mydt10.cp_vat         = tbl1.cp_vat     ,
    mydt10.cp_country     = tbl1.cp_country ,
    mydt10.cp_branch      = tbl1.cp_branch  ,
    mydt10.cp_name        = tbl1.cp_name    ,
    mydt10.cp_address     = tbl1.cp_address ,
    mydt10.cp_city        = tbl1.cp_city    ,
    mydt10.cp_zip         = tbl1.cp_zip     ,

    mydt10.cp_tbl         = tbl1.cp_tbl     ,
    mydt10.cp_nr01        = tbl1.cp_nr01    ,
    mydt10.series         = tbl1.series     ,
    mydt10.aa             = tbl1.aa         ,
    mydt10.issuedate      = tbl1.issuedate  ,
    mydt10.issuetime      = tbl1.issuetime  ,
    mydt10.invtype        = tbl1.invtype    ,
    mydt10.cinvtype       = tbl1.cinvtype    ,
    mydt10.vatpaysusp     = tbl1.vatpaysusp ,
    mydt10.currency       = tbl1.currency   ,
    mydt10.exchrate       = tbl1.exchrate   ,
    mydt10.pcor           = ifnull(tbl1.pcor, ''),
    mydt10.correlinv      = ifnull(tbl1.correlinv, ''),
    mydt10.slfpricing     = tbl1.slfpricing ,
    mydt10.dispdate       = tbl1.dispdate   ,
    mydt10.disptime       = tbl1.disptime   ,
    mydt10.vehiclenum     = tbl1.vehiclenum ,
    mydt10.spinvcat       = tbl1.spinvcat   ,
    mydt10.invvarty       = tbl1.invvarty   ,
    mydt10.mvpurpose      = tbl1.mvpurpose  ,
    mydt10.paytype        = tbl1.paytype    ,
    mydt10.tnetvalue      = tbl1.tnetvalue  ,
    mydt10.tvat_am        = tbl1.tvat_am    ,
    mydt10.twthhld_am     = tbl1.twthhld_am ,
    mydt10.tfees_am       = tbl1.tfees_am   ,
    mydt10.tstamp_am      = tbl1.tstamp_am  ,
    mydt10.ttax_am        = tbl1.ttax_am    ,
    mydt10.tdeduction     = tbl1.tdeduction ,
    mydt10.tgross_val     = tbl1.tgross_val ,
    /*v1.99*/
    mydt10.tgross         = tbl1.tgross     ,
    mydt10.p00            = tbl1.p00        ,
    mydt10.tbl            = tbl1.tbl        ,
    mydt10.tbl_nr01       = tbl1.tbl_nr01   ,
    mydt10.p01            = tbl1.p01        ,
    mydt10.p03            = tbl1.p03        ,
    mydt10.p06            = tbl1.p06        ,
    mydt10.p07            = tbl1.p07        ,
    mydt10.p08d           = tbl1.p08d       ,
    mydt10.p08t           = tbl1.p08t       ,
    mydt10.p30            = ''              ,
    mydt10.fuelinv        = tbl1.fuelinv    ,
    mydt10.einv           = tbl1.einv       ,
    mydt10.einv_nr        = tbl1.einv_nr    ,
    mydt10.pnr01          = tbl1.pnr01      ,
    mydt10.ldstreet       = tbl1.ldstreet   ,
    mydt10.ldzip          = tbl1.ldzip      ,
    mydt10.ldnumber       = tbl1.ldnumber   ,
    mydt10.ldcity         = tbl1.ldcity     ,
    mydt10.dlvstreet      = tbl1.dlvstreet  ,
    mydt10.dlvzip         = tbl1.dlvzip     ,
    mydt10.dlvnumber      = tbl1.dlvnumber  ,
    mydt10.dlvcity        = tbl1.dlvcity    ,
    mydt10.isdlvno        = tbl1.isdlvno    ,
    mydt10.p_notes        = tbl1.p_notes    ,
    mydt10.cp_p600        = tbl1.cp_p600    ,
    mydt10.othmvpur       = tbl1.othmvpur   ,    
    mydt10.tableaa        = tbl1.tableaa    ,
    mydt10.mconmrk        = ifnull(tbl1.mconmrk, '') ,
    mydt10.mconauth       = ifnull(tbl1.mconauth, '') ,
    mydt10.pmcon          = ifnull(tbl1.pmcon, '')  ,
    mydt10.tcdord         = tbl1.tcdord     ,
    mydt10.p103           = ifnull(tbl1.p103, '') ,
    /*v1.88*/
    mydt10.thcoll         = tbl1.thcoll,
    mydt10.ss_branch      = tbl1.ss_branch,
    mydt10.cs_branch      = tbl1.cs_branch,
    
    mydt10.remdate        =curdate(), 
    mydt10.remtime        =curtime(), 
    mydt10.remuser        =:user_pswd,
    mydt10.remguc         =:p_mydt10tot
WHERE mydt10.nr01=tbl1.nr01
   && (   mydt10.is_vat         <> tbl1.is_vat     
       || mydt10.is_country     <> tbl1.is_country 
       || mydt10.is_branch      <> tbl1.is_branch  
       || mydt10.is_name        <> tbl1.is_name    
       || mydt10.is_address     <> tbl1.is_address 
       || mydt10.is_city        <> tbl1.is_city    
       || mydt10.is_zip         <> tbl1.is_zip     
       || mydt10.is_tbl         <> tbl1.is_tbl     
       || mydt10.is_nr01        <> tbl1.is_nr01    
       || mydt10.cp_vat         <> tbl1.cp_vat     
       || mydt10.cp_country     <> tbl1.cp_country 
       || mydt10.cp_branch      <> tbl1.cp_branch  
       || mydt10.cp_name        <> tbl1.cp_name    
       || mydt10.cp_address     <> tbl1.cp_address 
       || mydt10.cp_city        <> tbl1.cp_city    
       || mydt10.cp_zip         <> tbl1.cp_zip     
       || mydt10.cp_tbl         <> tbl1.cp_tbl     
       || mydt10.cp_nr01        <> tbl1.cp_nr01    
       || mydt10.series         <> tbl1.series     
       || mydt10.aa             <> tbl1.aa         
       || mydt10.issuedate      <> tbl1.issuedate
       || mydt10.issuetime      <> tbl1.issuetime
       || mydt10.invtype        <> tbl1.invtype    
       || mydt10.cinvtype       <> tbl1.cinvtype    
       || mydt10.vatpaysusp     <> tbl1.vatpaysusp 
       || mydt10.currency       <> tbl1.currency   
       || mydt10.exchrate       <> tbl1.exchrate   
       || ifnull(mydt10.pcor, '')<> ifnull(tbl1.pcor, '')
       || ifnull(mydt10.correlinv, '')<> ifnull(tbl1.correlinv, '')
       || mydt10.slfpricing     <> tbl1.slfpricing 
       || mydt10.dispdate       <> tbl1.dispdate   
       || mydt10.disptime       <> tbl1.disptime   
       || mydt10.vehiclenum     <> tbl1.vehiclenum 
       || mydt10.spinvcat       <> tbl1.spinvcat
       || mydt10.invvarty       <> tbl1.invvarty
       || mydt10.mvpurpose      <> tbl1.mvpurpose
       || mydt10.paytype        <> tbl1.paytype  
       || mydt10.tnetvalue      <> tbl1.tnetvalue  
       || mydt10.tvat_am        <> tbl1.tvat_am    
       || mydt10.twthhld_am     <> tbl1.twthhld_am 
       || mydt10.tfees_am       <> tbl1.tfees_am   
       || mydt10.tstamp_am      <> tbl1.tstamp_am  
       || mydt10.ttax_am        <> tbl1.ttax_am    
       || mydt10.tdeduction     <> tbl1.tdeduction 
       || mydt10.tgross_val     <> tbl1.tgross_val 
       /*v1.99*/
       || mydt10.tgross         <> tbl1.tgross
       || mydt10.p00            <> tbl1.p00
       || mydt10.tbl            <> tbl1.tbl
       || mydt10.tbl_nr01       <> tbl1.tbl_nr01
       || mydt10.p01            <> tbl1.p01
       || mydt10.p03            <> tbl1.p03
       || mydt10.p06            <> tbl1.p06
       || mydt10.p07            <> tbl1.p07
       || mydt10.p08d           <> tbl1.p08d
       || mydt10.p08t           <> tbl1.p08t
       || mydt10.fuelinv        <> tbl1.fuelinv
       || mydt10.einv           <> tbl1.einv
       || mydt10.einv_nr        <> tbl1.einv_nr
       || mydt10.pnr01          <> tbl1.pnr01
       || mydt10.ldstreet       <> tbl1.ldstreet   
       || mydt10.ldzip          <> tbl1.ldzip      
       || mydt10.ldnumber       <> tbl1.ldnumber   
       || mydt10.ldcity         <> tbl1.ldcity     
       || mydt10.dlvstreet      <> tbl1.dlvstreet  
       || mydt10.dlvzip         <> tbl1.dlvzip     
       || mydt10.dlvnumber      <> tbl1.dlvnumber  
       || mydt10.dlvcity        <> tbl1.dlvcity    
       || mydt10.isdlvno        <> tbl1.isdlvno
       || mydt10.p_notes        <> tbl1.p_notes
       || mydt10.cp_p600        <> tbl1.cp_p600    
       || mydt10.othmvpur       <> tbl1.othmvpur
       || mydt10.tableaa        <> tbl1.tableaa
       || mydt10.tcdord         <> tbl1.tcdord
       || ifnull(mydt10.mconmrk, '')  <> ifnull(tbl1.mconmrk, '')
       || ifnull(mydt10.mconauth, '') <> ifnull(tbl1.mconauth, '')
       || ifnull(mydt10.pmcon, '')    <> ifnull(tbl1.pmcon, '')
       || ifnull(mydt10.p103, '')     <> ifnull(tbl1.p103, '')
       /*v1.88*/
       || mydt10.thcoll         <> tbl1.thcoll 
       || mydt10.ss_branch      <> tbl1.ss_branch
       || mydt10.cs_branch      <> tbl1.cs_branch

       
      );
/*peg_end*/          

/****************************************************
       insert new records
****************************************************/
INSERT INTO mydt10
(nr01, pnr01, 
 is_vat, is_country, is_branch, is_name, is_address, is_city, is_zip, is_tbl, is_nr01,
 cp_vat, cp_country, cp_branch, cp_name, cp_address, cp_city, cp_zip, cp_tbl, cp_nr01,
 series, aa, issuedate, issuetime, invtype, cinvtype, vatpaysusp, currency, exchrate, pcor, correlinv, slfpricing, 
 dispdate, disptime, vehiclenum, spinvcat, invvarty, 
 mvpurpose, paytype, tnetvalue, 
 tvat_am, twthhld_am, tfees_am, tstamp_am, ttax_am, tdeduction, tgross_val, /*v1.99*/ tgross, 
 p00, tbl, tbl_nr01, p01, p03, p06, p07, p08d, p08t, fuelinv, 
 einv, einv_nr, ldstreet, ldzip, ldnumber, ldcity, dlvstreet, dlvzip, dlvnumber, dlvcity,
 isdlvno, p_notes, cp_p600, othmvpur, tableaa, mconmrk, mconauth, pmcon, tcdord, p103, /*v1.88*/ thcoll, ss_branch, cs_branch, 
 remfdate, remftime, remfuser, remdate, remtime, remuser, remguc)

SELECT tbl1.nr01 as nr01,  
       tbl1.pnr01 as pnr01,
       tbl1.is_vat     ,
       tbl1.is_country ,
       tbl1.is_branch  ,
       tbl1.is_name    ,
       tbl1.is_address ,
       tbl1.is_city    ,
       tbl1.is_zip     ,
       tbl1.is_tbl     ,
       tbl1.is_nr01     ,
       tbl1.cp_vat     ,
       tbl1.cp_country ,
       tbl1.cp_branch  ,
       tbl1.cp_name    ,
       tbl1.cp_address ,
       tbl1.cp_city    ,
       tbl1.cp_zip     ,
       tbl1.cp_tbl     ,
       tbl1.cp_nr01     ,
       tbl1.series     ,
       tbl1.aa         ,
       tbl1.issuedate  ,
       tbl1.issuetime  ,
       tbl1.invtype    ,
       tbl1.cinvtype   ,
       tbl1.vatpaysusp ,
       tbl1.currency   ,
       tbl1.exchrate   ,
       ifnull(tbl1.pcor, ''),
       ifnull(tbl1.correlinv, ''),
       tbl1.slfpricing ,
       tbl1.dispdate   ,
       tbl1.disptime   ,
       tbl1.vehiclenum ,
       tbl1.spinvcat   , 
       tbl1.invvarty   , 
       tbl1.mvpurpose  ,
       tbl1.paytype    ,
       tbl1.tnetvalue  ,
       tbl1.tvat_am    ,
       tbl1.twthhld_am ,
       tbl1.tfees_am   ,
       tbl1.tstamp_am  ,
       tbl1.ttax_am    ,
       tbl1.tdeduction ,
       tbl1.tgross_val ,
       /*v1.99*/
       tbl1.tgross     ,
       tbl1.p00        ,
       tbl1.tbl        ,
       tbl1.tbl_nr01   ,
       tbl1.p01        ,
       tbl1.p03        ,
       tbl1.p06        ,
       tbl1.p07        ,
       tbl1.p08d       ,
       tbl1.p08t       ,
       tbl1.fuelinv    ,
       tbl1.einv       ,
       tbl1.einv_nr    ,
       tbl1.ldstreet   ,
       tbl1.ldzip      ,
       tbl1.ldnumber   ,
       tbl1.ldcity     ,
       tbl1.dlvstreet  ,
       tbl1.dlvzip     ,
       tbl1.dlvnumber  ,
       tbl1.dlvcity    ,
       tbl1.isdlvno    ,
       tbl1.p_notes    ,
       tbl1.cp_p600    ,
       tbl1.othmvpur   ,       
       tbl1.tableaa    ,
       ifnull(tbl1.mconmrk, '') as mconmrk,       
       ifnull(tbl1.mconauth, '') as mconauth,       
       ifnull(tbl1.pmcon, '') as pmcon,       
       tbl1.tcdord     ,
       ifnull(tbl1.p103, '') as p103, 
       /*v1.88*/ 
       tbl1.thcoll as thcoll, 
       tbl1.ss_branch as ss_branch, 
       tbl1.cs_branch as cs_branch, 
              
       curdate()     as remfdate, 
       curtime()     as remftime, 
       us0.p01       as remfuser, 
       curdate()     as remfdate, 
       curtime()     as remftime, 
       us0.p01       as remfuser,
       :p_mydt10tot as remguc
FROM {p_mydt10tbl1} as tbl1
LEFT JOIN mydt10 ON mydt10.nr01=tbl1.nr01
JOIN us0 ON us0.p01=:user_pswd
WHERE mydt10.nr01 is null;
/*peg_end*/        
       