/** 
    {p_mydt10tbl1} = mydt10 temporary
    {p_mydt10tbl2} = mydt11 temporary
**/    

/********************************************
      std διορθώσεις παραστατικών      
********************************************/


/****** Χώρες ΕΕ *****/
/*https://european-union.europa.eu/principles-countries-history/country-profiles_el */
/** deleted codes ="#UK#LI#NO#"; */
SET @peg_eecnt="#AT#BE#BG#FR#DE#DK#EE#IE#ES#IT#NL#HR#CY#LV#LT#LU#MT#HU#PL#PT#RO#SK#SI#SE#CZ#FI#"
/*peg_end*/

/*************************************
    Τιμολόγιο Πώλησης ΕΕ ή ΤΧ 
*************************************/
update {p_mydt10tbl1} as mydt10, mydt00
set mydt10.invtype='1.2'
where (    mydt10.invtype='1.1'
        ||  mydt10.invtype = '1.3'
      )        
   && mydt00.nr01=1
   && (    mydt00.p108=2
        || (mydt00.p108 in (0, 3) && mydt10.tvat_am=0)
      )  
   && locate( concat('#',mydt10.cp_country,'#'), @peg_eecnt)>0;
/*peg_end*/

update {p_mydt10tbl1} as mydt10, mydt00
set mydt10.invtype='1.3'
where (    mydt10.invtype='1.1'
        ||  mydt10.invtype = '1.2'
      )  
   && mydt00.nr01=1
   && (    mydt00.p108=2
        || (mydt00.p108 in (0, 3) && mydt10.tvat_am=0)
      )  
   && locate( concat('#',mydt10.cp_country,'#'), @peg_eecnt)=0
   && mydt10.cp_country<>'GR';
/*peg_end*/

/*************************************
   Τιμολόγιο Πώλησης Παροχής ΕΕ ή ΤΧ
*************************************/
update {p_mydt10tbl1} as mydt10, mydt00
set mydt10.invtype='2.2'
where (    mydt10.invtype='2.1'
        || mydt10.invtype = '2.3'
      )  
   && mydt00.nr01=1
   && (    mydt00.p108=2
        || (mydt00.p108 in (0, 3) && mydt10.tvat_am=0)
      )  
   && locate( concat('#',mydt10.cp_country,'#'), @peg_eecnt)>0;
/*peg_end*/

update {p_mydt10tbl1} as mydt10, mydt00
set mydt10.invtype='2.3'
where (    mydt10.invtype='2.1'
        || mydt10.invtype = '2.2'
      )  
   && mydt00.nr01=1
   && (    mydt00.p108=2
        || (mydt00.p108 in (0, 3) && mydt10.tvat_am=0)
      )  
   && locate( concat('#',mydt10.cp_country,'#'), @peg_eecnt)=0
   && mydt10.cp_country<>'GR';
/*peg_end*/


/*************************************
   Τιμολόγια Αγοράς ΕΕ ή ΤΧ
*************************************/
update {p_mydt10tbl1} as mydt10, mydt00
set mydt10.invtype='14.1'
where mydt10.invtype in ('14.2')
   && mydt00.nr01=1
   && (    mydt00.p109  in (0, 2)
        || (mydt00.p109 = 3 && mydt10.tvat_am=0)
      )  
   && locate( concat('#',mydt10.is_country,'#'), @peg_eecnt)>0;
/*peg_end*/

update {p_mydt10tbl1} as mydt10, mydt00
set mydt10.invtype='14.2'
where mydt10.invtype in ('14.1')
   && mydt00.nr01=1
   && (    mydt00.p109  in (0, 2)
        || (mydt00.p109 = 3 && mydt10.tvat_am=0)
      )  
   && locate( concat('#',mydt10.is_country,'#'), @peg_eecnt)=0
   && mydt10.is_country<>'GR';
/*peg_end*/

/*************************************
   Τιμολόγια Αγοράς Παροχής ΕΕ ή ΤΧ
*************************************/
update {p_mydt10tbl1} as mydt10, mydt00
set mydt10.invtype='14.3'
where mydt10.invtype in ('14.4')
   && mydt00.nr01=1
   && (    mydt00.p109  in (0, 2)
        || (mydt00.p109 = 3 && mydt10.tvat_am=0)
      )  
   && locate( concat('#',mydt10.is_country,'#'), @peg_eecnt)>0;
/*peg_end*/

update {p_mydt10tbl1} as mydt10, mydt00
set mydt10.invtype='14.4'
where mydt10.invtype in ('14.3')
   && mydt00.nr01=1
   && (    mydt00.p109  in (0, 2)
        || (mydt00.p109 = 3 && mydt10.tvat_am=0)
      )  
   && locate( concat('#',mydt10.is_country,'#'), @peg_eecnt)=0
   && mydt10.is_country<>'GR';
/*peg_end*/

/*************************************
   Παραστατικά με κωδικό 13.31 14.χχ  
   αν ο εκδότης είναι ΕΕ ή ΤΧ 
   τα θέτουμε προς αποστολή.
*************************************/
update {p_mydt10tbl1} as mydt10
set mydt10.p01=1
where (    substr(mydt10.invtype, 1, 3) in ('14.')
        || mydt10.invtype = '13.31'
      )  
   && mydt10.is_country<>'GR';
/*peg_end*/

/****************************************************
   Αντιγραφή στοιχείων εκδότη στον λήπτη αν το ΑΦΜ είναι ίδιο.
   Το ΑΦΜ μπορεί να γίνει ίδιο στην περίπτωση ενδοδιακίνησης από a60
****************************************************/
/*Web v1.375*/
update {p_mydt10tbl1} as mydt10
set   mydt10.cp_country = mydt10.is_country,
      mydt10.cp_name    = mydt10.is_name,
      mydt10.cp_address = mydt10.is_address,
      mydt10.cp_city    = mydt10.is_city,
      mydt10.cp_zip     = mydt10.is_zip,
      mydt10.cp_branch  = mydt10.is_branch,
      mydt10.cp_tbl     = mydt10.is_tbl,
      mydt10.cp_nr01    = mydt10.is_nr01
where mydt10.is_vat   = mydt10.cp_vat;
/*peg_end*/

/****************************************************
      Αλλαγή Εκδότη στα παραστατικά και 
      Εκδότης =>η εταιρεία 
****************************************************/
update {p_mydt10tbl1} as mydt10, 
       (  select mydt10_in.*
         from {p_mydt10tbl1} as mydt10_in
         /**start_stores**/
         left join t07 as t07_in ON t07_in.p01=mydt10_in.p03
         left join t05 as t05_in ON t05_in.p01=t07_in.p07
         left join mydt01 as mydt01_in ON mydt01_in.p100=t05_in.p01
         /**end_stores**/
         
         /**start_stores**/
         where  mydt10_in.is_vat<>if( mydt01_in.nr01 is null, '{nt_p101[1]}', if(ifnull(t05_in.p204, '')='',  '{nt_p101[1]}', ifnull(t05_in.p204, '')))
         /**end_stores**/           

         /**start_not_exists_stores**/
         where mydt10_in.is_vat<>'{nt_p101[1]}'

         /**end_not_exists_stores**/           

            && (  
                   (    substr(mydt10_in.invtype, 1, 2) in ('1.', '2.', '5.')
                     && mydt10_in.slfpricing=1
                   )  
                || substr(mydt10_in.invtype, 1, 2) in ('3.')
                || mydt10_in.invtype='1.5'
                || (mydt10_in.invtype='9.3' && mydt10_in.tbl='a56')
               )
       ) as tbl01            
set mydt10.cp_country = tbl01.is_country,
    mydt10.cp_vat     = tbl01.is_vat,
    mydt10.cp_name    = tbl01.is_name,
    mydt10.cp_address = tbl01.is_address,
    mydt10.cp_city    = tbl01.is_city,
    mydt10.cp_zip     = tbl01.is_zip,
    mydt10.cp_branch  = tbl01.is_branch,    
    mydt10.cp_tbl     = tbl01.is_tbl,    
    mydt10.cp_nr01    = tbl01.is_nr01,    
    
    mydt10.is_country = tbl01.cp_country,
    mydt10.is_vat     = tbl01.cp_vat,
    mydt10.is_name    = tbl01.cp_name,
    mydt10.is_address = tbl01.cp_address,
    mydt10.is_city    = tbl01.cp_city,
    mydt10.is_zip     = tbl01.cp_zip,
    mydt10.is_branch  = tbl01.cp_branch,
    mydt10.is_tbl     = tbl01.cp_tbl,    
    mydt10.is_nr01    = tbl01.cp_nr01
where mydt10.tbl     =tbl01.tbl
   && mydt10.tbl_nr01=tbl01.tbl_nr01; 
/*peg_end*/



/**************************************
   if mydt50.p107=1 => isdlvno=0
**************************************/
/*v1.98*/
update {p_mydt10tbl1} as mydt10, mydt50
set mydt10.isdlvno=0 
where mydt10.invtype = mydt50.p00
   && mydt50.p107=1
   && mydt10.isdlvno=1;
/*peg_end*/
   
/**************************************
      ΑΦΜ Λήπτη
**************************************/
/*v1.98*/
update {p_mydt10tbl1} as mydt10
left join mydt50 on mydt10.invtype  = mydt50.p00
set mydt10.cp_vat =if(mydt10.cp_vat='', '000000000', mydt10.cp_vat), 
    mydt10.cp_zip =if(mydt10.cp_zip='', '00', mydt10.cp_zip) 
where (    mydt10.invtype in ('1.2', '1.3', '2.2', '2.3', '3.1', '3.2', '5.1', '5.2', '6.1', '8.1', '8.2')
        || mydt10.isdlvno=1
        || ifnull(mydt50.p107, 0)=1
      )
   && (    mydt10.cp_vat=''
        || mydt10.cp_zip=''
      );  
/*peg_end*/

/**************************************
      ΑΦΜ - TK Εκδότη
**************************************/
/*v1.98*/
update {p_mydt10tbl1} as mydt10
left join mydt50 on mydt10.invtype  = mydt50.p00
set mydt10.is_vat =if(mydt10.is_vat='', '000000000', mydt10.is_vat), 
    mydt10.is_zip =if(mydt10.is_zip='', '00', mydt10.is_zip) 
where (    substr(mydt10.invtype, 1, 3) in ('14.')
        || mydt10.isdlvno=1
        || ifnull(mydt50.p107, 0)=1
      )
   && (    mydt10.is_vat=''
        || mydt10.is_zip=''
      );
/*peg_end*/

/**************************************
      ldnumber - dlvnumber 0 if empty
**************************************/
update {p_mydt10tbl1} as mydt10,
       mydt50
set mydt10.ldnumber  = if(mydt10.ldnumber  ='', '0', mydt10.ldnumber),
    mydt10.dlvnumber = if(mydt10.dlvnumber ='', '0', mydt10.dlvnumber)
where mydt10.invtype  = mydt50.p00
   && (mydt50.p107    = 1 || mydt10.isdlvno = 1);
/*peg_end*/ 

/**************************************
    Παραστατικό 8.1 8.2, 3.1, 3.2, 1
                13.30
                16.1, 17.x                
    Κατηγορία ΦΠΑ => 8
**************************************/
update {p_mydt10tbl1} as mydt10, 
       {p_mydt10tbl2} as mydt11 
set mydt11.vatcat ='8', 
    mydt11.vatexcat ='', 
    mydt11.mydt62_p01=''
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && (    mydt10.invtype in ('8.1', '8.2', '3.1', '3.2', '13.30', '14.5', '16.1')
        || substr(mydt10.invtype,1 , 3) in ('17.')
      )  
   && mydt11.vatcat='7';
/*peg_end*/

/*********************************
     Στοιχείο Αυτοπαραδοσης =>
     Δ.Φ. = 0   
**********************************/
update {p_mydt10tbl1} as mydt10, 
       {p_mydt10tbl2} as mydt11
set mydt11.p103  = 0, 
    mydt11.p103f = 0
where 
   mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && mydt10.invtype="6.1";  
/*peg_end*/

/******************************
     14.5 -> series=VAT
******************************/
update {p_mydt10tbl1} as mydt10
set series=cp_vat
where invtype='14.5';
/*peg_end*/

/*****************************************************************************
     update for invoice '9.3' set mydt10.p00=1 <- Εσοδο
******************************************************************************/
update {p_mydt10tbl1} as mydt10,
       mydt50  
set mydt10.p00=1
where mydt10.invtype = mydt50.p00
   && mydt50.p107=1
   && mydt10.p00<>1;
/*peg_end*/

/******************************************
     isinfo=0
     Αν το παραστατικό έχει μόνο isinfo=1 
     και είναι μηδενικό
******************************************/     
update {p_mydt10tbl2} as mydt11, 
       (
        select mydt10.nr01     as nr01, 
               mydt10.tbl      as tbl, 
               mydt10.tbl_nr01 as tbl_nr01, 
               ifnull( (select mydt11_in.nr01 as nr01_2
                        from {p_mydt10tbl2} as mydt11_in
                        where mydt10.tbl=mydt11_in.ptbl
                           && mydt10.tbl_nr01=mydt11_in.ptbl_nr01
                           && mydt11_in.isinfo=0
                        limit 1), 0) as nr01_2
        from {p_mydt10tbl1} as mydt10                
        where mydt10.tnetvalue=0
           && mydt10.tvat_am  =0
           && mydt10.twthhld_am =0
           && mydt10.tfees_am =0
           && mydt10.tstamp_am=0
           && mydt10.ttax_am =0
           && mydt10.tdeduction =0
           && mydt10.tgross_val=0
           && mydt10.p00=1
       ) as tbl01 
set mydt11.isinfo=0
where mydt11.ptbl=tbl01.tbl
   && mydt11.ptbl_nr01=tbl01.tbl_nr01
   && tbl01.nr01_2=0
   && mydt11.isinfo=1;
/*peg_end*/   


/*********************************************
      Μηδενικά Παραστατικά προς Αποστολή
      γίνονται λιανικής
*********************************************/
update {p_mydt10tbl1} as mydt10 
set mydt10.invtype='11.1'
where tnetvalue=0
   && tvat_am  =0
   && twthhld_am =0
   && tfees_am =0
   && tstamp_am=0
   && ttax_am =0
   && tdeduction =0
   && tgross_val=0
   && substr(invtype, 1, 2) = '1.'
   && p00=1;
/*peg_end*/

update {p_mydt10tbl1} as mydt10 
set mydt10.invtype='11.2'
where tnetvalue=0
   && tvat_am  =0
   && twthhld_am =0
   && tfees_am =0
   && tstamp_am=0
   && ttax_am =0
   && tdeduction =0
   && tgross_val=0
   && substr(invtype, 1, 2) = '2.'
   && p00=1;
/*peg_end*/

update {p_mydt10tbl1} as mydt10 
set mydt10.invtype='11.4'
where tnetvalue=0
   && tvat_am  =0
   && twthhld_am =0
   && tfees_am =0
   && tstamp_am=0
   && ttax_am =0
   && tdeduction =0
   && tgross_val=0
   && substr(invtype, 1, 2) = '5.'
   && p00=1;
/*peg_end*/
      

/*********************************************
      Μηδενικά Παραστατικά Αποστολής
      => category1_95
*********************************************/
update {p_mydt10tbl1} as mydt10, 
       {p_mydt10tbl2} as mydt11 
set mydt11.mydt57_p00='category1_95', 
    mydt11.mydt58_p00=''
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && mydt10.p00=1
   && mydt11.wthhld_am=0
   && mydt11.netvalue  =0
   && mydt11.fpavalue  =0 
   && mydt11.stampvalue=0
   && mydt11.fees_am=0
   && mydt11.otax_am=0
   && mydt11.deducvalue =0
   && mydt11.p101 =0
   && mydt11.p101f =0
   && mydt11.p102 =0
   && mydt11.p102f =0
   && mydt11.p103 =0
   && mydt11.p103f =0
   && mydt11.mydt57_p00<>'';
/*peg_end*/

/*****************************************************************************
     updtate for invoice '9.3' set category3
******************************************************************************/
update {p_mydt10tbl1} as mydt10,
       {p_mydt10tbl2} as mydt11,
       mydt50  
set 
   mydt11.mydt57_p00='category3',
   mydt11.mydt61_p00='',
   mydt11.mydt58_p00='',
   mydt11.mydt62_p00='',
   mydt11.mydt62_p01='' 
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && mydt10.invtype = mydt50.p00
   && mydt50.p107=1;
/*peg_end*/

/*****************************************************************************
     updtate for invoice '9.3' set vatcat = 8 , 
     if VAT Value is 0 (must be 0 always in those recs)
******************************************************************************/
update {p_mydt10tbl1} as mydt10,
       {p_mydt10tbl2} as mydt11,
       mydt50
set  
    mydt11.vatcat   ='8',
    mydt11.vatexcat =''

where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && mydt10.invtype = mydt50.p00
   && mydt50.p107=1
   && mydt11.fpavalue=0;
/*peg_end*/

/*********************************************
      discoption=0 if no netvalue
*********************************************/
update {p_mydt10tbl2} as mydt11 
set mydt11.discoption=0
where mydt11.discoption=1
   && mydt11.netvalue  =0
   && mydt11.fpavalue  =0;
/*peg_end*/

/************************************************
     updtate mydt11.p104
************************************************/
update {p_mydt10tbl1} as mydt10, 
       {p_mydt10tbl2} as mydt11
set mydt11.p104=mydt10.p00
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01;
/*peg_end*/


/************************************************
     update category/E3 
     for invoice 1.5      
************************************************/
update {p_mydt10tbl1} as mydt10, 
       {p_mydt10tbl2} as mydt11
set mydt11.p104=2, 
    mydt11.mydt57_p00='',
    mydt11.mydt61_p00='',
    mydt11.mydt58_p00='category2_9',
    mydt11.mydt62_p00='',
    mydt11.mydt62_p01='' 
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && mydt10.invtype='1.5'
   && mydt11.invdtype='1'
   && mydt11.mydt58_p00 not like 'category2%'
   && mydt10.slfpricing=0;
/*peg_end*/

update {p_mydt10tbl1} as mydt10, 
       {p_mydt10tbl2} as mydt11
set mydt11.p104=1, 
    mydt11.mydt57_p00='category1_1',
    mydt11.mydt61_p00='E3_561_001',
    mydt11.mydt58_p00='',
    mydt11.mydt62_p00='',
    mydt11.mydt62_p01='' 
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && mydt10.invtype='1.5'
   && mydt11.invdtype='2'
   && mydt11.mydt57_p00 not like 'category1%'
   && mydt10.slfpricing=0;
/*peg_end*/

/************************************************
     invdtype='' if invoice<>1.5
************************************************/
update {p_mydt10tbl1} as mydt10, 
       {p_mydt10tbl2} as mydt11
set mydt11.invdtype='' 
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && mydt10.invtype<>'1.5'
   && mydt11.invdtype in ('1', '2');
/*peg_end*/

/*****************************************************************************
     updtate for invoice 1.5 with slfpricing
     mydt62_p00, mydt62_p01 -> Ενημερώνονται στο mydt10p200299_902.sql 
******************************************************************************/
update {p_mydt10tbl1} as mydt10, 
       {p_mydt10tbl2} as mydt11
set mydt11.p104=2, 
    mydt11.mydt57_p00='',
    mydt11.mydt61_p00='',
    mydt11.mydt58_p00='category2_3',
    mydt11.mydt62_p00='',
    mydt11.mydt62_p01='' 
     
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && mydt10.invtype='1.5'
   && mydt11.invdtype='2'
   && mydt10.slfpricing=1;
/*peg_end*/

   
/******************************************************
      Ενημέρωση από το mydt42
      ΠΡΕΠΕΙ ΝΑ ΕΙΝΑΙ ΣΤΟ ΤΕΛΟΣ ΤΟΥ sql      
      ΠΡΙΝ Την Ενημέρωση του VAT_
******************************************************/
update {p_mydt10tbl1} as mydt10, 
       {p_mydt10tbl2} as mydt11, 
       mydt42
set mydt11.mydt57_p00=mydt42.p03,
    mydt11.mydt61_p00=if(mydt42.p04='*', '', mydt42.p04)
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && mydt10.invtype=mydt42.p01
   && mydt11.mydt57_p00=mydt42.p101
   && mydt11.mydt61_p00=mydt42.p102
   && mydt10.p00=1
   && mydt42.p300=1;
/*peg_end*/

update {p_mydt10tbl1} as mydt10, 
       {p_mydt10tbl2} as mydt11, 
       mydt42
set mydt11.mydt58_p00=mydt42.p03,
    mydt11.mydt62_p00=if(mydt42.p04='*', '', mydt42.p04), 
    mydt11.mydt62_p01=if(mydt42.p05='', mydt11.mydt62_p01, mydt42.p05)
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && mydt10.invtype=mydt42.p01
   && mydt11.mydt58_p00=mydt42.p101
   && mydt11.mydt62_p00=mydt42.p102
   && mydt10.p00=2
   && mydt42.p300=1;
/*peg_end*/

/*****************************************************************************
     spinvcat='12' μόνο αν tableaa<>'' και pmcon<>''
     εκτελείται πριν γίνει tableaa=''
******************************************************************************/
update {p_mydt10tbl1} as mydt10
set spinvcat='12'
where tableaa<>''
   /*&& pmcon<>''*/
   && spinvcat='';
/*peg_end*/

/*****************************************************************************
     tableaa μόνο αν invtype=8.6
******************************************************************************/
update {p_mydt10tbl1} as mydt10
set tableaa=''
where invtype<>'8.6';
/*peg_end*/

/*****************************************************************************
     update for invoice '8.4' , '8.5' , '8.6' 
     set category1_95 
******************************************************************************/
update {p_mydt10tbl1} as mydt10,
       {p_mydt10tbl2} as mydt11
set  
    mydt11.mydt57_p00='category1_95',
    mydt11.mydt61_p00='',
    mydt11.mydt58_p00='',
    mydt11.mydt62_p00='',
    mydt11.mydt62_p01=''
     
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && mydt10.invtype in ('8.4' , '8.5' , '8.6' )
   && mydt10.p01=1;
/*peg_end*/


/*****************************************************************************
     updtate for invoice '8.4' , '8.5' set vatcat = 8
     if VAT Value is 0 (must be 0 always in those recs) and p01=1
******************************************************************************/
update {p_mydt10tbl1} as mydt10,
       {p_mydt10tbl2} as mydt11
set  
    mydt11.vatcat='8', 
    /*v1.103*/ 
    mydt11.vatexcat =''
     
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && mydt10.invtype in ('8.4' , '8.5')
   && mydt10.p01=1
   && mydt11.fpavalue=0;
/*peg_end*/


/*v1.103*/ 
/*****************************************************************************
     vatcat=8 -> vatexcat=''
******************************************************************************/
update {p_mydt10tbl2} as mydt11
set mydt11.vatexcat =''
     
where mydt11.vatcat='8'
   && mydt11.vatexcat<>'';
/*peg_end*/


/************************************************
     update dispatchdate 
************************************************/
update {p_mydt10tbl1} as mydt10,
       mydt50
set mydt10.dispdate   = mydt10.issuedate
where mydt10.invtype  = mydt50.p00
   && (mydt50.p107    = 1 || mydt10.isdlvno = 1)
   && mydt10.dispdate <= cast('0100-01-01' as date);
/*peg_end*/ 

/************************************************
     update dispatchtime 
************************************************/
update {p_mydt10tbl1} as mydt10
set mydt10.disptime   = ''
where substr(mydt10.disptime, 1, 2) = '  ';
/*peg_end*/

update {p_mydt10tbl1} as mydt10,
       mydt50
set mydt10.disptime   = concat(mydt10.issuetime, ':00')
where mydt10.invtype  = mydt50.p00
   && (mydt50.p107    = 1 || mydt10.isdlvno = 1)
   && mydt10.disptime = '' 
   /*v1.90*/
   && mydt10.issuetime != '';
/*peg_end*/

/************************************************
     update cp_p600 
************************************************/
update {p_mydt10tbl1} as mydt10
set cp_p600 = ''     
where mydt10.fuelinv = 0 ;
/*peg_end*/

/*****************************************************************************
     update mvpurpose if it's deprecated (myDATA 1.0.11)
******************************************************************************/
/*Web v1.375*/
update {p_mydt10tbl1} as mydt10
set mydt10.mvpurpose = '19'
where mydt10.mvpurpose in ('6', '15', '16', '17');
/*peg_end*/

update {p_mydt10tbl1} as mydt10
set mydt10.mvpurpose = '8'
where mydt10.mvpurpose = '18';
/*peg_end*/

/************************************************
     update mvpurpose (1)
************************************************/
update {p_mydt10tbl1} as mydt10
set othmvpur = ''     
where mydt10.mvpurpose>0 and mydt10.mvpurpose!=19 ;
/*peg_end*/

/************************************************
     update mvpurpose (2)
************************************************/
update {p_mydt10tbl1} as mydt10
set mvpurpose = '19'     
where mydt10.mvpurpose=0 and mydt10.othmvpur!='' ;
/*peg_end*/


/************************************************
     update munit
************************************************/
update {p_mydt10tbl2} as mydt11
set munit = '1'     
where mydt11.munit = '' ;
/*peg_end*/

/************************************************
     if munit<>'7' omunit=''
************************************************/
update {p_mydt10tbl2} as mydt11
set omunit = 0, 
    omuntl =''    
where mydt11.munit <> '7' ;
/*peg_end*/

/*v1.111*/
/************************************************
     if munit='7' omunit>=1 && omunitl='Αλλη ΜΜ'
************************************************/
update {p_mydt10tbl2} as mydt11
set mydt11.omunit = 1    
where mydt11.munit = '7' 
   && mydt11.omunit <1;
/*peg_end*/

/*********************************************
   Στα Παραστατικά Αποστολής 
   βγαζουμε τους χαρακτηρισμούς στις γραμμές 
   με is_info=1 
*********************************************/
update {p_mydt10tbl1} as mydt10, 
       {p_mydt10tbl2} as mydt11 
set mydt11.mydt57_p00='' , 
    mydt11.mydt58_p00='' ,
    mydt11.mydt61_p00='' , 
    mydt11.mydt62_p00='' 
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && mydt10.p00=1
   && mydt11.isinfo = 1;
/*peg_end*/ 

/**********************************
      update payment types
**********************************/
/*** αν έχει πάρει υπογραφή πληρωμής -> type=7 EFTPOS ***/
update {p_mydt10tbl3} as mydt13 
set type='7' 
where type<>'7'
   && p_sign<>'';
/*peg_end*/ 
   
/*** αν δεν έχει πάρει υπογραφή πληρωμής και type=7 EFTPOS -> type=1 ***/
update {p_mydt10tbl3} as mydt13 
set type='1' 
where type='7'
   && p_sign='';
/*peg_end*/ 

/*************************************************
    mydt00.p111=1 => Σχόλια Γραμμής Κενά
*************************************************/
update {p_mydt10tbl2} as mydt11, mydt00
set mydt11.comments=''
where mydt00.nr01=1
   && mydt00.p111=1;
/*peg_end*/

/*v1.103*/
/*****************************************************************************
     update quantity=1 if quantity=0 and isdlvno=1 (not for 9.3)
******************************************************************************/
update {p_mydt10tbl1} as mydt10,
       {p_mydt10tbl2} as mydt11
set   mydt11.quantity=1
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && mydt10.isdlvno=1
   && mydt11.quantity=0;
/*peg_end*/

/*v1.104*/
/*****************************************************************************
     update itemdescr if empty
******************************************************************************/
update {p_mydt10tbl1} as mydt10,
       {p_mydt10tbl2} as mydt11, 
       mydt50
set mydt11.itemdescr='.'
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && mydt50.p00=mydt10.invtype
   && ( mydt10.isdlvno=1 || mydt50.p111=1 )
   && ifnull(mydt11.itemdescr, '')='';
/*peg_end*/

/**************************************
Ενημέρωση VAT_ mydt62_p01 στα έξοδα 
μεταφέρθηκαν στο mydt10p200299_902.sql
**************************************/
  
