insert into {p_mydt10tbl1}
(tbl, tbl_nr01, p00, p01, p03, p06, p07, p08d, p08t,
currency, exchrate, 
series, aa, issuedate, issuetime, invtype, paytype, 
spinvcat, invvarty,
is_country, is_vat, is_name, is_address, is_city, is_zip, is_tbl, is_nr01,
cp_country, cp_vat, cp_name, cp_address, cp_city, cp_zip, cp_tbl, cp_nr01, 
p103, thcoll, /*v1.105*/ p_notes )

SELECT tbl as tbl, 
       tbl_nr01 as tbl_nr01, 
       if(mkfs in (2, 3), 1, 2) as p00, 
       p01 as p01, 
       p03 as p03, 
       p06 as p06, 
       p07 as p07, 
       p08d as p08d, 
       p08t as p08t, 
       currency as currency, 
       exchrate as exchrate, 
       if(series='', '0', series) as series,  
       aa as aa, 
       issuedate as issuedate, 
       issuetime as issuetime, 
       invtype as invtype, 
       paytype as paytype,
       spinvcat   as spinvcat,
       invvarty   as invvarty,
       
       if( mkfs in (0, 1, 2, 3), ''            , a_country)     as is_country, 
       if( mkfs in (0, 1, 2, 3), '{nt_p101[1]}', a_vat)     as is_vat, 
       if( mkfs in (0, 1, 2, 3), '{nt_p101[2]}', a_name)    as is_name, 
       if( mkfs in (0, 1, 2, 3), '{nt_p101[3]}', a_address) as is_address, 
       if( mkfs in (0, 1, 2, 3), '{nt_p101[4]}', a_city)    as is_city, 
       if( mkfs in (0, 1, 2, 3), '{nt_p101[5]}', a_zip)     as is_zip, 
       if( mkfs in (0, 1, 2, 3), '{nt_p101[6]}', a_tbl)     as is_tbl, 
       if( mkfs in (0, 1, 2, 3), '{nt_p101[7]}', a_nr01)    as is_nr01, 

       if( mkfs not in (2, 3), '', a_country)             as cp_country, 
       if( mkfs not in (2, 3), '{nt_p101[1]}', a_vat)     as cp_vat, 
       if( mkfs not in (2, 3), '{nt_p101[2]}', a_name)    as cp_name, 
       if( mkfs not in (2, 3), '{nt_p101[3]}', a_address) as cp_address, 
       if( mkfs not in (2, 3), '{nt_p101[4]}', a_city)    as cp_city, 
       if( mkfs not in (2, 3), '{nt_p101[5]}', a_zip)     as cp_zip, 
       if( mkfs not in (2, 3), '{nt_p101[6]}', a_tbl)     as is_tbl, 
       if( mkfs not in (2, 3), '{nt_p101[7]}', a_nr01)    as is_nr01, 
       if(p103_1<>'', p103_1, p103_2) as p103, 
       thcoll as thcoll, 
       /*v1.105*/
       p_notes as p_notes
        

FROM
(
      /***********************************************
             Παραστατικά προς πρλ
             q30.nr01=620018
      ***********************************************/
      (
      /*Αν δεν συμμετέχει και αφορά σε Είσπραξη mkfs=3, αν αφορά σε πληρωμή mkfs=5*/
      SELECT if( t02.p012 in (2, 3, 4, 5), t02.p012, 0) 
             +  if( t02.p012 not in (2, 3, 4, 5) && t02.p010=1,  3, 0) 
             +  if( t02.p012 not in (2, 3, 4, 5) && t02.p010=-1, 5, 0) 
               as mkfs,   
             't08' as tbl, 
             t08.nr01 as tbl_nr01, 
             if(t02.p012 in (2, 3), 1, 2) as p00,
             2 as p01,
             t08.p0121 as p03, 
             0 as p06, 
             ifnull(t02.p01, 0) as p07, 
             t08.remdate as p08d, 
             t08.remtime as p08t,             
             /*v1.71*/
             ifnull(t12.p05, '') as currency, 
             t08.pn02 as exchrate,
       
             /**στοιχεία παραστατικού*/
             /*v1.22*/
             if( ifnull(mydt00.p103, 0)=1, 
                 concat(ifnull(t10.p00, ''), if(t08.p701='', '', '-'), t08.p701), 
                 t08.p701
                ) as series, 
             t08.p06 as aa, 
             t08.p01 as issuedate, 
             t08.p02 as issuetime, 
             ifnull(mydt50.p00, '') as invtype, 
             
             /*v1.27*/
             /**paytype**/           
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620056
                         && q31_in.p03=t08.p017
                         && q31_in.p05!='7'
                      limit 1), '') as paytype,

             /*v1.46*/ 
             /**special invoice category**/
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620065
                         && q31_in.p03=t10.p01
                      limit 1), '') as spinvcat,
             /**invoice variation type**/
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620066
                         && q31_in.p03=t10.p01
                      limit 1), '') as invvarty,

             /*αντισυμβαλλόμενος*/
             /**start_module_exists_suppliers**/
             ifnull(d23_a01.p01, ifnull(d23_a00.p01, '')) as a_country,
             ifnull(a01.p20,  ifnull(a00.p20, '')) as a_vat,
             ifnull(a01.p19,  ifnull(a00.p19, ifnull(t00.p02, ''))) as a_name, 
             ifnull(a01.p4,   ifnull(a00.p4,  ifnull(t00.p102, ''))) as a_address, 
             ifnull(concat(a01.p5, ' ', a01.p6),   ifnull(concat(a00.p5, ' ', a00.p6),  ifnull(t00.p103, ''))) a_city, 
             ifnull(a01.p7,   ifnull(a00.p7, '')) as a_zip, 

             if(a01.nr01 is null ,  if(a00.nr01 is null , 't00' , 'a00') , 'a01') as a_tbl, 
             ifnull(a01.nr01, ifnull(a00.nr01, t00.nr01)) as a_nr01,
             /**end_module_exists_suppliers**/

             /**start_module_not_exists_suppliers**/
             ifnull(d23_a01.p01, '') as a_country,
             ifnull(a01.p20,  '') as a_vat,
             ifnull(a01.p19,  '') as a_name, 
             ifnull(a01.p4,   '') as a_address, 
             ifnull(concat(a01.p5, ' ', a01.p6),   '') a_city, 
             ifnull(a01.p7,   '') as a_zip ,
             if(a01.nr01 is null ,    't00'  , 'a01') as a_tbl, 
             ifnull(a01.nr01,   t00.nr01) as a_nr01,
             /**end_module_not_exists_suppliers**/
              

            /*v1.82*/
            /*Εκτυπωτής παραστατικού αν δεν είναι χειρόγραφο*/
            if( t08.p08=0, ifnull(t10.p08, ''),  '') as p103_1,
            if( t08.p08=0, ifnull(f02.pt01, ''), '') as p103_2,
             
             /**για λογαριασμό τρίτου**/
             ifnull( (select cast(q31_in.p05 as signed)
                      from q31 as q31_in
                      where q31_in.p01=620076
                         && q31_in.p03=t10.p01
                      limit 1), 0) as thcoll, 
             /*v1.105*/
             if( ifnull(mydt00.p113, 0)=1 && ifnull(t08.p30, '')<>'', 
                        ifnull(t08.p30, ''), '') as p_notes         

      FROM q31
      LEFT JOIN t10 ON q31.p03=t10.p01
      LEFT JOIN t02 ON t02.p01=t10.p04
      LEFT JOIN t08 ON t08.p05=t10.p01
                    && t08.p01>=cast('{odbcdtos(nt_p01)}' as date)
                    && t08.p01<=cast('{odbcdtos(nt_p02)}' as date)
                    && t08.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
                    && t08.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
                    && concat(t08.remdate, t08.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
                    && concat(t08.remdate, t08.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')

                    ##start_module_exist_stores##
                    && t08.p0121 in (##store_in_sql##)                 
                    ##end_module_exist_stores##   

      LEFT JOIN mydt50 ON mydt50.p00=q31.p05
      LEFT JOIN a01 ON a01.p21=t08.p03
      LEFT JOIN d23 as d23_a01 ON d23_a01.p01=a01.p4_1
      /**start_module_exists_suppliers**/
      LEFT JOIN a00 ON a00.p21=t08.p03
      LEFT JOIN d23 as d23_a00 ON d23_a00.p01=a00.p4_1
      /**end_module_exists_suppliers**/
      LEFT JOIN t00 ON t00.p01=t08.p03
      LEFT JOIN t12 ON t12.p01=t08.pn01
      LEFT JOIN mydt00 ON mydt00.nr01=1
      /*v1.82*/
      LEFT JOIN f02 ON f02.nr01=1
      
      WHERE q31.p01=620018
         && t08.nr01 is not null
         && t02.nr01 is not null
         && {p_mydt10where} 
         && {nt_nparal}=1
      GROUP BY t08.nr01
      {p_mydt10limit}
      )

      UNION ALL
      
      /***********************************************
             Παραστατικά προς αποσ
             q30.nr01=620019
      ***********************************************/
      (
      /*v1.69*/ 
      /*Αν δεν συμμετέχει και αφορά σε Είσπραξη mkfs=3, αν αφορά σε πληρωμή mkfs=5*/
      SELECT if( t02.p012 in (2, 3, 4, 5), t02.p012, 0) 
             +  if( t02.p012 not in (2, 3, 4, 5) && t02.p010=1, 3, 0) 
             +  if( t02.p012 not in (2, 3, 4, 5) && t02.p010=-1, 5, 0) 
               as mkfs,   
             't08' as tbl, 
             t08.nr01 as tbl_nr01, 
             if(t02.p012 in (2, 3), 1, 2) as p00,
             1 as p01,
             t08.p0121 as p03, 
             0 as p06, 
             ifnull(t02.p01, 0) as p07, 
             t08.remdate as p08d, 
             t08.remtime as p08t,             
             /*v1.71*/
             ifnull(t12.p05, '') as currency, 
             t08.pn02 as exchrate,
       
             /**στοιχεία παραστατικού*/
             if( ifnull(mydt00.p103, 0)=1, 
                 concat(ifnull(t10.p00, ''), if(t08.p701='', '', '-'), t08.p701), 
                 t08.p701
                ) as series, 
             t08.p06 as aa, 
             t08.p01 as issuedate, 
             t08.p02 as issuetime, 
             ifnull(mydt50.p00, '') as invtype, 
             
             /**paytype**/           
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620056
                         && q31_in.p03=t08.p017
                         && q31_in.p05!='7'
                      limit 1), '') as paytype,

             /**special invoice category**/
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620065
                         && q31_in.p03=t10.p01
                      limit 1), '') as spinvcat,
             /**invoice variation type**/
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620066
                         && q31_in.p03=t10.p01
                      limit 1), '') as invvarty,

             
             /*αντισυμβαλλόμενος*/
             /**start_module_exists_suppliers**/
             ifnull(d23_a01.p01, ifnull(d23_a00.p01, '')) as a_country,
             ifnull(a01.p20,  ifnull(a00.p20, '')) as a_vat,
             ifnull(a01.p19,  ifnull(a00.p19, ifnull(t00.p02, ''))) as a_name, 
             ifnull(a01.p4,   ifnull(a00.p4,  ifnull(t00.p102, ''))) as a_address, 
             ifnull(concat(a01.p5, ' ', a01.p6),   ifnull(concat(a00.p5, ' ', a00.p6),  ifnull(t00.p103, ''))) a_city, 
             ifnull(a01.p7,   ifnull(a00.p7, '')) as a_zip, 
             if(a01.nr01 is null ,  if(a00.nr01 is null , 't00' , 'a00') , 'a01') as a_tbl, 
             ifnull(a01.nr01, ifnull(a00.nr01, t00.nr01)) as a_nr01,
             /**end_module_exists_suppliers**/

             /**start_module_not_exists_suppliers**/
             ifnull(d23_a01.p01, '') as a_country,
             ifnull(a01.p20,  '') as a_vat,
             ifnull(a01.p19,  '') as a_name, 
             ifnull(a01.p4,   '') as a_address, 
             ifnull(concat(a01.p5, ' ', a01.p6),   '') a_city, 
             ifnull(a01.p7,   '') as a_zip, 
             if(a01.nr01 is null ,    't00'  , 'a01') as a_tbl, 
             ifnull(a01.nr01,   t00.nr01) as a_nr01,
             /**end_module_not_exists_suppliers**/
            /*v1.82*/
            /*Εκτυπωτής παραστατικού αν δεν είναι χειρόγραφο*/
            if( t08.p08=0, ifnull(t10.p08, ''),  '') as p103_1,
            if( t08.p08=0, ifnull(f02.pt01, ''), '') as p103_2,

             /*v1.88*/ 
             /**για λογαριασμό τρίτου**/
             ifnull( (select cast(q31_in.p05 as signed)
                      from q31 as q31_in
                      where q31_in.p01=620076
                         && q31_in.p03=t10.p01
                      limit 1), 0) as thcoll, 
             /*v1.105*/
             if( ifnull(mydt00.p113, 0)=1 && ifnull(t08.p30, '')<>'', 
                        ifnull(t08.p30, ''), '') as p_notes          
      FROM q31
      LEFT JOIN t10 ON q31.p03=t10.p01
      LEFT JOIN t02 ON t02.p01=t10.p04
      LEFT JOIN t08 ON t08.p05=t10.p01
                    && t08.p01>=cast('{odbcdtos(nt_p01)}' as date)
                    && t08.p01<=cast('{odbcdtos(nt_p02)}' as date)
                    && t08.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
                    && t08.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
                    && concat(t08.remdate, t08.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
                    && concat(t08.remdate, t08.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')

                    ##start_module_exist_stores##
                    && t08.p0121 in (##store_in_sql##)                 
                    ##end_module_exist_stores##   

      LEFT JOIN mydt50 ON mydt50.p00=q31.p05
      LEFT JOIN a01 ON a01.p21=t08.p03
      LEFT JOIN d23 as d23_a01 ON d23_a01.p01=a01.p4_1
      /**start_module_exists_suppliers**/
      LEFT JOIN a00 ON a00.p21=t08.p03
      LEFT JOIN d23 as d23_a00 ON d23_a00.p01=a00.p4_1
      /**end_module_exists_suppliers**/
      LEFT JOIN t00 ON t00.p01=t08.p03
      LEFT JOIN t12 ON t12.p01=t08.pn01
      LEFT JOIN mydt00 ON mydt00.nr01=1
      /*v1.82*/
      LEFT JOIN f02 ON f02.nr01=1
      
      WHERE q31.p01=620019
         && t08.nr01 is not null
         && ( (a01.p21 is not null AND t08.p08 = 0) OR (a01.p21 is null) )
         && t02.nr01 is not null
         && {p_mydt10where} 
         && {nt_napost}=1
      /*v1.11*/
      GROUP BY t08.nr01
      {p_mydt10limit}
      )
           
) as tbl01
where tbl_nr01 is not null
   && tbl is not null   
group by tbl, tbl_nr01;   
/*peg_end*/ 

/*1.59*/         
/**************************************************
   correlates
**************************************************/
update {p_mydt10tbl1} as mydt10,

      (select ifnull(mydt10_in.tbl, '')     as tbl,
              ifnull(mydt10_in.tbl_nr01, 0) as tbl_nr01,
            concat( if(ifnull(mydt10_in.pcor, '')='','#', mydt10_in.pcor) , group_concat(DISTINCT(t08_arxiko.nr01) SEPARATOR '#') , '#') as pcor 
      from {p_mydt10tbl1} as mydt10_in 
      left join t08 on t08.nr01=mydt10_in.tbl_nr01 && mydt10_in.tbl='t08'
      left join t08 as t08_arxiko on t08_arxiko.nr01=t08.p600
                                  && t08_arxiko.nr01<>t08.nr01
                                  && t08.p600<>0

      
      ) as tbl01   
set mydt10.pcor = tbl01.pcor

where mydt10.tbl = tbl01.tbl 
   && mydt10.tbl_nr01 = tbl01.tbl_nr01 
   && tbl01.pcor is not null
   && tbl01.tbl_nr01 is not null 
   && tbl01.tbl is not null; 
/*peg_end*/       

/*v1.80*/
/***************
   mconmrk
***************/
/**start_module_exists_account01**/
update
   {p_mydt10tbl1},
   (select ifnull(group_concat(DISTINCT(mydt10.mark) SEPARATOR ','), '') as mconmrk,
           ifnull(group_concat(DISTINCT(mydt10.auth_cd) SEPARATOR ','), '') as mconauth,
           ifnull(group_concat(DISTINCT(concat(mydt10.tbl, ':', mydt10.tbl_nr01)) SEPARATOR ','), '') as pmcon,
           ifnull(mydt10_in.tbl, '') as tbl, 
           ifnull(mydt10_in.tbl_nr01, 0) as tbl_nr01
    from {p_mydt10tbl1} as mydt10_in
    LEFT JOIN t08 on t08.nr01=mydt10_in.tbl_nr01
    left join t01 on t01.p303 = 6 
                  && t01.p302 = t08.nr01 
    left join t38 on t01.nr01=t38.p02
    left join t01 as t01_00 on t01_00.nr01=t38.p01
                            && t01_00.p303 = 2  
    left join a55 on t01_00.p302 = a55.nr01
    left join mydt10 on a55.nr01 = mydt10.tbl_nr01 
                     && mydt10.tbl = 'a55'
    where mydt10_in.tbl='t08'
       && mydt10.nr01 is not null
       && mydt10_in.tbl is not null
       && mydt10_in.tbl_nr01 is not null       
   ) as tbl_t08
set {p_mydt10tbl1}.mconmrk  = ifnull(tbl_t08.mconmrk, ''),
    {p_mydt10tbl1}.mconauth = ifnull(tbl_t08.mconauth, ''),
    {p_mydt10tbl1}.pmcon    = ifnull(tbl_t08.pmcon, '') 
where {p_mydt10tbl1}.tbl = tbl_t08.tbl 
   && {p_mydt10tbl1}.tbl_nr01 = tbl_t08.tbl_nr01
   && tbl_t08.tbl_nr01 is not null
   && tbl_t08.tbl is not null;
/**end_module_exists_account01**/ 
/*peg_end*/ 

