insert into {p_mydt10tbl2}
   ( 
      tbl, tbl_nr01, ptbl, ptbl_nr01, comments, mydt57_p00, 
      vatcat, vatexcat, wthhldpcat, otaxpcat, stamppcat,
      feestype, invdtype, mydt61_p00, netvalue, fpavalue, wthhld_am, otax_am, fees_am, stampvalue, deducvalue, 
      taxunder, discoption, 
      quantity, munit, omunit, omuntl,
      p101, p101f, p102, p102f, p103, p103f, 
      p105, p106, fuelcode, itemcode, itemdescr, isinfo
   )

SELECT 
      tbl01.tbl, 
      tbl01.tbl_nr01, 
      tbl01.ptbl, 
      tbl01.ptbl_nr01, 
      comments   as comments, 
      tbl01.mydt57_p00,
      tbl01.vatcat,
      if(tbl01.vatexcat1='',tbl01.vatexcat, tbl01.vatexcat1)        as vatexcat,
      if(tbl01.wthhldpcat='', tbl01.wthhldpcat_1, tbl01.wthhldpcat) as wthhldpcat,
      tbl01.otaxpcat,
      if(tbl01.stamppcat='', tbl01.stamppcat_1, tbl01.stamppcat)    as stampcat,
      tbl01.feestype,
      tbl01.invdtype,
      tbl01.mydt61_p00,

      if(wthhldpcat=''
         and wthhldpcat_1=''
         and otaxpcat=''  
         and feestype=''  
         and stamppcat='' 
         and stamppcat_1='', i01p011, 0) as netvalue, 

      if(vatcat<>''    , i01fp011, 0)    as fpavalue, 
      if(wthhldpcat<>'' || wthhldpcat_1<>'' , i01p011, 0) + wthhld_am as wthhld_am, 
      if(otaxpcat<>''  , i01p011, 0) + otax_am          as otax_am, 
      if(feestype<>''  , i01p011, 0)                    as fees_am,
      if(stamppcat<>'' || stamppcat_1<>'', i01p011, 0)  as stampvalue, 

      deducvalue    as deducvalue, 
      taxunder      as taxunder, 
      discoption    as discoption,

      if(quantity=0, 1, quantity) as quantity, 
      munit      as munit,       
      omunit     as omunit, 
      omuntl     as omuntl,               
      p101       as p101, 
      p101f      as p101f, 
      p102       as p102, 
      p102f      as p102f, 
      p103       as p103, 
      p103f      as p103f, 

      p105       as p105,        
      p106       as p106, 
      fuelcode   as fuelcode, 
      itemcode   as itemcode, 
      if(itemdescr='', 'Κιβώτιο', itemdescr)  as itemdescr, 
      isinfo     as isinfo
       
FROM  
(
   /*********************************************************
         transactions
   *********************************************************/
   
   /******************************************************
         tran02.records
   ******************************************************/
   (
      select 
            'tran02'          as tbl, 
            tran02.nr01       as tbl_nr01,            
            mydt10.tbl        as ptbl, 
            mydt10.tbl_nr01   as ptbl_nr01,

            ''    as mydt57_p00,    /**incoming category**/
            ''    as mydt61_p00,

            '8'   as vatcat,        /**fpa category**/    
            ''    as vatexcat,	
            ''    as vatexcat1,	 
            ''    as wthhldpcat,
            ''    as wthhldpcat_1,  
            ''    as otaxpcat,
            ''    as stamppcat,
            ''    as stamppcat_1,
            ''    as feestype,
            ''    as invdtype,
            ''    as fuelcode,

            0     as otax_am, 
            0     as wthhld_am,
            0     as deducvalue,
            0     as taxunder,                   
            0     as discoption,
            0     as isinfo,

            0     as i01p011, 
            0     as i01fp011, 
            
            if(tran02.p04!='', tran02.p04, if(tran15.p01!='', tran15.p01, ''))   as itemdescr,
            if(tran02.p04!='', tran02.p04, if(tran15.p01!='', tran15.p01, ''))   as comments,
            '000000'                as itemcode,
            ifnull(tran02.p02, 0)   as quantity,
            
            ifnull( (
                        select mydt_in.p00 
                        from mydt59 as mydt_in, q31 as q31_in
                        where q31_in.p01=620060
                              and q31_in.p03=i24.p01
                              and q31_in.p05=mydt_in.p00
                        limit 1
                     ), '')         as munit, 

            /*v1.111*/
            round(ifnull(tran02.p02, 0), 0)   as omunit, 
            if(ifnull(i24.p02, '')='', ifnull(i24.p01, ''), ifnull(i24.p02, ''))  as omuntl,
            
            
            ifnull(tran02.p02, 0)   as p105,
            if(tran02.p04!='', tran02.p04, if(tran15.p01!='', tran15.p01, ''))   as p106,

          
            0     as p101,
            0     as p101f, 
            0     as p102, 
            0     as p102f, 
            0     as p103,
            0     as p103f

                     
           
      from {p_mydt10tbl1} as mydt10
      left join tran09  on tran09.nr01=mydt10.tbl_nr01
      left join tran10  on tran10.p02=tran09.nr01
      left join tran01  on tran01.nr01=tran10.p01
      left join tran02  on tran02.p00=tran01.nr01
      left join tran15  on tran15.p00=tran02.p03
      left join i24     on i24.p01=tran15.p04
      left join mydt00  on mydt00.nr01=1
      
      where tran02.nr01 is not null
            and tran01.nr01 is not null
            and tran09.nr01 is not null
      group by tran02.nr01
   )
    
) as tbl01;