<?php

    if(class_exists('PrintsData')===false){
        if(file_exists('../../pegasus_cloud_app/prints_classes/prints_data.php')){
            require_once('../../pegasus_cloud_app/prints_classes/prints_data.php');
        }else{
            return;
        }
    }

    class OrdercustA57PrintsData extends PrintsData { 

        public function __construct($p85nr01=0, $sid=0, $p85_input=array()){        
            parent::__construct($p85nr01, $sid, $p85_input);
            
            $this->setMultipleInputMode(1);
        }

        protected static function sanitizeExpressionField($field_name){
            return InvoicesPrintsClass::sanitizeExpressionField($field_name);
        }

        protected function setBodySql(){

            if(!empty($this->p85_arr['body_sql_code'])){
                $sql_code = eval($this->p85_arr['body_sql_code']);
            }

            $dias_main_nr01 = (is_array($this->p85_input["dias_main_nr01"])) ? $this->p85_input["dias_main_nr01"][0] : $this->p85_input["dias_main_nr01"];
                        
            if(empty($sql_code)){
                if(pegasus_module_exists('orders')){
                    pegasus_mysql_use("select apostpno, codpno, s_cost0pno, s_cost1pno, s_cost2pno, s_cost3pno from hero00", $costs);
                }
                $lang = (isset($this->p85_input["lang"])) ? $this->p85_input["lang"] : "GR";     
                $sql_code = InvoicesPrintsClass::getProductsQuery('a57', 2, $dias_main_nr01, $this->p85_input["cs_analysis"], $costs, $this->p85_input["disable_i71"], $lang);       
            }

            $this->body_sql = (is_array($sql_code)) ? $sql_code : array('sql'=>$sql_code, 'sqlParams'=>array());
        }  

        protected function makeGlobalData(){
            $global_data = parent::makeGlobalData();
            
            
            $lang = (isset($this->p85_input["lang"])) ? $this->p85_input["lang"] : "GR"; 
            $dias_main_nr01 = (is_array($this->p85_input["dias_main_nr01"])) ? $this->p85_input["dias_main_nr01"][0] : $this->p85_input["dias_main_nr01"];
            
            
            //Store Titles
            $a57_p0121 = pegasus_mysql_printfld('a57', 'p0121', 'nr01=:a57nr01', array('a57nr01'=>$dias_main_nr01));
            $core_titles_data = invoices_get_store_titles($a57_p0121);

            for($i=1; $i<=8; $i++){ 
                $global_data['cor000_tit_line'.$i] = $core_titles_data[$i-1];
            }
            for($i=1; $i<=8; $i++){ 
                $global_data['cor000_eng_tit_line'.$i] = $core_titles_data[$i+7];
                if(empty($global_data['cor000_eng_tit_line'.$i])){
                    $global_data['cor000_eng_tit_line'.$i] = $core_titles_data[$i-1];
                }
            }


            //Footer Titles
            $core_footer_data = invoices_get_store_footer($a57_p0121);
            for($i=1; $i<=5; $i++){ 
                $global_data['f02_ftr00'.$i] = $core_footer_data[$i-1];
            }
            for($i=1; $i<=5; $i++){ 
                $global_data['f02_eftr00'.$i] = $core_footer_data[$i+4];
                if(empty($global_data['f02_eftr00'.$i])){
                    $global_data['f02_eftr00'.$i] = $core_footer_data[$i-1];
                }
            }


            //Table Data
            $main_table_data = static::makeTableData($this->p85_arr['p50'], $dias_main_nr01);
            $counter = count($main_table_data);

            //Extra Table Data
            $ca_server_copy = isset($this->p85_input['ca_server_copy']) ? $this->p85_input['ca_server_copy'] : 0;
            
            if(isset($this->p85_input['non_zero_values'])){
                $non_zero_values = $this->p85_input['non_zero_values'];
            }else{
                $non_zero_values = array('p0112'=>true, 'p0113'=>true,'p0601'=>true,'p0600'=>true,'p0108'=>true);
            }

            if(isset($this->p85_input['hidden_values'])){
                $hidden_values = $this->p85_input['hidden_values'];
            }
            
            $i13_arr = array();
            $result  = pegasus_query("select * from i13 order by p01;");
            while($peg_i13=pegasus_fetch_assoc($result)){
                $i13_arr[$peg_i13['p01']] = $peg_i13['p03'];
            }

            if(pegasus_module_exists('orders')){
                pegasus_mysql_use('select apostpno, codpno, s_cost0pno, s_cost1pno, s_cost2pno, s_cost3pno from hero00', $costs);
            }

            for ($j=0; $j<$counter; $j++) { 

                //Logo
                $logo_path = invoices_get_store_logo_path($main_table_data[$j][static::sanitizeExpressionField('a57_nr01_a57_nr01_p0121')]);
                $main_table_data[$j]['invoices_logo'] = $logo_path;

                //Watermark Logo
                $watermark_logo_path = invoices_get_store_watermark_logo_path($main_table_data[$j][static::sanitizeExpressionField('a57_nr01_a57_nr01_p0121')]);
                $main_table_data[$j]['invoices_watermark_logo'] = $watermark_logo_path;

                
                //Ανάλυση ΦΠΑ
                $indx = 1;
                for($i=1; $i<10; $i++) {
                    if($main_table_data[$j][static::sanitizeExpressionField('a57_nr01_a57_nr01_p20'.$i)]>0) {
                        $main_table_data[$j]['fpa_'.$indx.'_net'] = $main_table_data[$j][static::sanitizeExpressionField('a57_nr01_a57_nr01_p20'.$i)];
                        $main_table_data[$j]['fpa_'.$indx.'_vat'] = $main_table_data[$j][static::sanitizeExpressionField('a57_nr01_a57_nr01_p30'.$i)];
                        $main_table_data[$j]['fpa_'.$indx.'_percent'] = $i13_arr[$i];
                        $indx++;
                    }
                }

                //Extra Χρεώσεις
                if(pegasus_module_exists('orders')){
                    $a58_query = "select v101, v102, v107 from a58 where p00=:a57nr01";
                    $a58_res   = pegasus_query($a58_query, array('a57nr01'=>$dias_main_nr01));
                    
                    while($a58 = pegasus_fetch_assoc($a58_res)) {
                        $cost_key = '';
                        if($a58['v101']==$costs['apostpno']) {
                            $cost_key = 'extras_s_cost';
                        }elseif($a58['v101']==$costs['codpno']) {
                            $cost_key = 'extras_cod';
                        }
        
                        for($i=0; $i<4; $i++) {
                            if($a58['v101']==$costs['s_cost'.$i.'pno']){
                                $cost_key = 'extras_s_cost'.$i;
                                break;
                            }
                        }
                        
                        if(!empty($cost_key)){
                            $main_table_data[$j][$cost_key] = $a58['v107'];
                            $main_table_data[$j][$cost_key . '_title'] = $a58['v102'];
                        }        
                    }
                }


                //Συνολική Ποσότητα ανά ΜΜ
                $total_quan_arr = invoices_find_product_total_quan_per_i24("a57", $dias_main_nr01);
                $main_table_data[$j]['product_total_quan_flag'] = (count($total_quan_arr)==1) ? true : false;
                
                foreach ($total_quan_arr as $i => $quan_arr) {
                    $main_table_data[$j]['product_total_quan_'.$i.'_i24_p01'] = $quan_arr['i24_p01'];
                    $main_table_data[$j]['product_total_quan_'.$i.'_i24_dek'] = $quan_arr['i24_dek'];
                    $main_table_data[$j]['product_total_quan_'.$i]            = $quan_arr['tot_quan'];
                }


                
                //Σύνολα
                $totals_arr = invoices_find_product_totals("a57", $dias_main_nr01, $non_zero_values, $hidden_values, $lang);
                foreach ($totals_arr as $key => $value) {
                    $main_table_data[$j]['product_totals_'.$key . '_title'] = $totals_arr[$key]['title'];                
                    $main_table_data[$j]['product_totals_'.$key] = $totals_arr[$key]['value'];    
                    
                    if(isset($totals_arr[$key]['percent'])){
                        $main_table_data[$j]['product_totals_'.$key.'_percent'] = $totals_arr[$key]['percent'];   
                    }         
                }
            }



            
            $global_data = array_merge($global_data, $main_table_data[0]);
            //echo "<pre>". print_r($global_data,1) . "</pre>"; 
            return  $global_data;
        }

        protected function getGlobalExpressions(){
            $global_exps = parent::getGlobalExpressions(); 
            
            //Footer Titles
            $f02_fields = array('ftr001','ftr002','ftr003','ftr004','ftr005','eftr001','eftr002','eftr003','eftr004','eftr005');
            foreach ($f02_fields as $fld) {
                if(peg_substr($fld, 0, 3)=='ftr'){   
                    $p01 = (int)peg_substr($fld, -1, 1).'η Γραμμή Footer';
                }elseif(peg_substr($fld, 0, 4)=='eftr'){
                    $p01 = (int)peg_substr($fld, -1, 1).'η Γραμμή Footer (EN)';
                }
                $p00  = 'f02_' . $fld;
                $p30  = 'return array("text"=>$pdf->printsData->getData("'.$p00.'"), "autoSizing"=>true);';
                $global_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p03'=>60); 
            }
            

            //Table Expressions
            $table_exps = static::getTableExpressions($this->p85_arr['p50']);
            //Extra Table Expressions
            $p30_fn = 'getData';

            //Logo
            $p00  = 'invoices_logo';    $p01 = 'Λογότυπο';
            $p30  = '$logo_path = $pdf->printsData->'.$p30_fn.'("'.$p00 .'");';
            $p30 .= "\n" . 'return invoices_logo_print(1140, 360, $logo_path);';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p05'=>'image'); 

            //Watermark Logo
            $p00 = 'invoices_watermark_logo';    $p01 = 'Λογότυπο Φόντου';
            $p30  = '$watermark_logo_path = $pdf->printsData->'.$p30_fn.'("'.$p00 .'");';
            $p30 .= "\n" . 'return invoices_logo_print(600, 390, $watermark_logo_path);';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p05'=>'image');
             

            //Ανάλυση ΦΠΑ
            for($i=1; $i<10; $i++){
                $p00  = 'fpa_'.$i.'_percent';   $p01  = 'Ανάλυση Φ.Π.Α.: %Φ.Π.Α.('.$i.')';
                $p30  = '$fpa_percent = $pdf->printsData->getNumber("'.$p00 .'", "2");';
                $p30 .= "\n" . 'return array("text"=>$fpa_percent);';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2'); 
               
                
                $p00  = 'fpa_'.$i.'_net';
                $p01  = 'Ανάλυση Φ.Π.Α.: Kαθαρά('.$i.')';
                $p30  = '$fpa_net = $pdf->printsData->getNumber("'.$p00 .'", "2");';
                $p30 .= "\n" . 'return array("text"=>$fpa_net);';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'N', 'p03'=>'13', 'p04'=>'2'); 
               
                
                $p00 = 'fpa_'.$i.'_vat';
                $p01 = 'Ανάλυση Φ.Π.Α.: Φ.Π.Α.('.$i.')';
                $p30  = '$fpa_vat = $pdf->printsData->getNumber("'.$p00 .'", "2");';
                $p30 .= "\n" . 'return array("text"=>$fpa_vat);';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'N', 'p03'=>'13', 'p04'=>'2'); 
            }


            //Extra Χρεώσεις
            if(pegasus_module_exists('orders')){
                $p00 = 'extras_s_cost_title';   $p01 = 'Κόστος Αποστολής (Τίτλος)';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p03'=>'100'); 
            
                $p00 = 'extras_s_cost';         $p01 = 'Κόστος Αποστολής';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'14', 'p04'=>'2'); 

                $p00 = 'extras_cod_title';      $p01 = 'Κόστος Αντικαταβολης (Τίτλος)';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p03'=>'100'); 

                $p00 = 'extras_cod';            $p01 = 'Κόστος Αντικαταβολης';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'14', 'p04'=>'2'); 

                for($i=0; $i<4; $i++) {
                    $p00 = 'extras_s_cost'.$i.'_title';     $p01 = 'Κόστος ' . ($i+2) . ' (Τίτλος)';
                    $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p03'=>'100'); 

                    $p00 = 'extras_s_cost'.$i;              $p01 = 'Κόστος ' . ($i+2);
                    $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'14', 'p04'=>'2'); 
                }
            }

            //Συνολική Ποσότητα ανά ΜΜ
            for($i=0; $i<5; $i++){
                $p00  = 'product_total_quan_'.$i.'_i24_p01';    $p01 = 'Συνολική Ποσότητα Ειδών ανά ΜΜ ('.$i.') - Περιγραφή';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C'); 

                $p00  = 'product_total_quan_'.$i;    $p01 = 'Συνολική Ποσότητα Ειδών ανά ΜΜ ('.$i.')';
                $p30  = '$total_quan = $pdf->printsData->getNumber("'.$p00 .'", $pdf->printsData->getData("product_total_quan_dec_'.$i.'"));';
                $p30 .= "\n" . 'return array("text"=>$total_quan);';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'N', 'p03'=>'14', 'p04'=>'3');
            } 


            //Σύνολα
            for($i=0; $i<=10; $i++){
                $p00 = 'product_totals_'.$i.'_title';    $p01 = 'Σύνολα ('.$i.') (Τίτλος)';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p03'=>'100'); 

                $p00 = 'product_totals_'.$i;    $p01 = 'Σύνολα ('.$i.')';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'13', 'p04'=>'2'); 
            }



            $global_exps = array_merge($global_exps, $table_exps);
            return $global_exps;
        }

        protected function getBodyExpressions(){

            $body_exps   = array();
            $p30_default = 'getBodyData';

            $body_fields = InvoicesPrintsClass::getProductsQueryFields('a57');

            $fields_query  = "select p50.p01 as p50_p01, p50.p03 as p50_p03, p51.* from p51 ";
            $fields_query .= "join p50 on p50.p02=p51.p02 ";
            $fields_query .= "join p60 on p60.p00=p51.desc16 ";
            $fields_query .= "where p50.p01 in ('a58','a90','i32','i00') and p50.p102=1 and p60.isdbfld=1 ";
            $fields_query .= "order by field(p50.p01,'a58','a90','i32','i00'), p51.desc06,p51.nr01;";
            
            $result = pegasus_query($fields_query);
            while ($p51=pegasus_fetch_assoc($result)) {

                if(in_array($p51['p50_p01'], array('i00','a90'))){
                    if(in_array($p51['p50_p01'].'_'.$p51['desc05'], array_keys($body_fields))){
                        $p00 = $body_fields[$p51['p50_p01'].'_'.$p51['desc05']];  
                    }else{
                        continue;
                    }
                }elseif(in_array($p51['desc05'], array_keys($body_fields))){
                    $p00 = $body_fields[$p51['desc05']]; 
                    if($p00=="v104"){
                        $p51['desc18'] = '$_SESSION["f01_p07"]';    
                    }elseif($p00=="v103"){
                        $p51['desc18'] = '$pdf->printsData->getBodyData("i24_dek")';
                    }
                }else{
                    continue;
                }

                $p01 = $p51['p50_p03'] . ' -> ' . $p51['desc02'];   
                $p05 = static::getExpressionType($p51['desc07']);             
                $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>$p51['desc16'], 'p03'=>$p51['desc17'], 'p04'=>$p51['desc18'], 'p05'=>$p05); 
            }
            
            $p00 = 'i24_dek';   $p01 = 'Είδη Παραγγελιών Πελατών -> Μονάδες Μέτρησης Αποθήκης -> Δεκαδικά Ποσότητας';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'N', 'p03'=>'2');
            
            $p00 = 'i71_tot';   $p01 = 'Φόροι/Κρατήσεις ανά Παραστατικό/Παραγγελια -> Σύνολο Φόρων/Κρατήσεων';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'N', 'p03'=>'13', 'p04'=>'2'); 




            //Extra Body Expressions
            //Product Price No VAT included
            $p00  = 'v104_no_vat';     $p01  = 'Extra Body -> Τιμή Μονάδας (χωρίς Φ.Π.Α.)';
            $p30  = '$prd_price = InvoicesPrintsClass::previewPrice($pdf->printsData->getBodyData("v104"), $pdf->printsData->getData("'.static::sanitizeExpressionField('a55_nr01_a55_nr01_p07').'"), $pdf->printsData->getBodyData("v105"), 0);';
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_price, $_SESSION["f01_p07"]));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'14', 'p04'=>'5');  
            
            //Product Price VAT included 
            $p00  = 'v104_vat';     $p01  = 'Extra Body -> Τιμή Μονάδας (με Φ.Π.Α.)';
            $p30  = '$prd_price = InvoicesPrintsClass::previewPrice($pdf->printsData->getBodyData("v104"), $pdf->printsData->getData("'.static::sanitizeExpressionField('a55_nr01_a55_nr01_p07').'"), $pdf->printsData->getBodyData("v105"), 1);';
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_price, $_SESSION["f01_p07"]));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'14', 'p04'=>'5');       



            //Products Total Price No VAT included
            $p00  = 'v107_no_vat';     $p01  = 'Extra Body -> Σύνολο Τιμής Είδους (χωρίς Φ.Π.Α.)';
            $p30  = '$prd_total = InvoicesPrintsClass::previewPrice($pdf->printsData->getBodyData("v107"), $pdf->printsData->getData("'.static::sanitizeExpressionField('a55_nr01_a55_nr01_p07').'"), $pdf->printsData->getBodyData("v105"), 0);';
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_total, 2));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'13', 'p04'=>'3');          
            

            //Products Total Price VAT included
            $p00  = 'v107_vat';     $p01  = 'Extra Body -> Σύνολο Τιμής Είδους (με Φ.Π.Α.)';
            $p30  = '$prd_total = InvoicesPrintsClass::previewPrice($pdf->printsData->getBodyData("v107"), $pdf->printsData->getData("'.static::sanitizeExpressionField('a55_nr01_a55_nr01_p07').'"), $pdf->printsData->getBodyData("v105"), 1);';
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_total, 2));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'13', 'p04'=>'3');          
            
            $p00 = 'perigrafi';         $p01 = 'Πλήρης Περιγραφή';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
            
            $p00 = 'color_size';        $p01 = 'Extra Body -> Χρωμα/Μέγεθος Περιγραφες x Ποσότητα';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
            
            $p00 = 'color_size_code';   $p01 = 'Extra Body -> Χρωμα/Μέγεθος Κωδικοί x Ποσότητα';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
             
            $p00 = 'serials';           $p01 = 'Extra Body -> Serial Number';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
            
            $p00 = 'serials_with_crm';   $p01 = 'Extra Body -> Serial Number (CRM)';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
            
            $p00 = 'lots';   $p01 = 'Extra Body -> Παρτίδες (LOT)';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
            


            return $body_exps;
        }

    }

?>