/**
 * @class Functions.ordercust.global
 * 
 * @member WebApp.view
 * 
 *  ##Properties
 *  
 *  The global variables of the module
 *  
 *   
 *  ##Methods
 * 
 	- General functions
 	- After draw functions
 *  
 *   
 */

//XXX Start General functions
function ordercust_change_katestos_fpa( container_id ){
	invoices_change_katestos_fpa( container_id , 'a57');
}

function ordercust_find_invoice_data( container_id_a57_d,check_or_set_p03 = ''){
	invoices_find_invoice_data( container_id_a57_d , 'a57',check_or_set_p03);
}

function ordercust_customer_change( container_id_a57_d ){
	invoices_p03_change( container_id_a57_d , 'a57');
}	

function ordercust_calculate_total( container_id_a57_d){
	 invoices_calculate_total( container_id_a57_d , 'a57'); 
}

function ordercust_change_product_vat_category(container_id, mode, i13p01){
	invoices_change_product_vat_category(container_id, mode, i13p01);
}

var ordercust_change_status_ajax='';
function ordercust_change_status( container_id ){
	
	var container_id_main     = pegGetContainer_id_d(container_id , 'a57_d'  , '' , 'a57_d' ) ;
	// var container_id_eidi     = pegGetContainer_id_d(container_id , 'a57_d2' , '' , 'a57_d' ) ;
	// var container_id_stoixeia = pegGetContainer_id_d(container_id , 'a57_d3' , '' , 'a57_d' ) ;
	// var container_id_fpa      = pegGetContainer_id_d(container_id , 'a57_d5' , '' , 'a57_d' ) ;
	
	params = {};
	params.p590  = pegGetVal('p590' , container_id_main ); 
	ordercust_change_status_ajax = pegAjaxDefer('/' + main_path + '/ordercust01/change_status.php' , params , function(json_data){
		 pegSetVal('p591' , container_id_main  , json_data.p591);
	});	
	
}
/**
 * Η συνάρτηση αυτή καλείται στα Toolbar Items save/update του a58_d
 * @param {*} parent_container_id 
 * @param {*} container_id 
 */
function ordercust_a58_d_on_save(parent_container_id, container_id){
	ordercust_calculate_total(parent_container_id); 
	var v101 = pegGetVal('v101',pegGetContainer_id_d(container_id,'a58_d',0,'a58_d')); //Ο κωδικός του είδους
	var tmp_nr01 = pegGetVal('nr01',pegGetContainer_id_d(container_id,'a58_d',0,'a58_d')); //Ο κωδικός του είδους
	var p703 = pegGetVal('p703',pegGetContainer_id_d(parent_container_id,'a57_d3',0,'a57_d')); //Αποθηκευτικός Χώρος
	invoices_show_stock_screen(parent_container_id ,v101, p703, tmp_nr01);
}

function ordercust_a57_d_update_fldcont00_title(container_id){
	fldcont00= pegGetCmp(container_id ,'fldcont00');
	let screenData=pegGetCmp(container_id).peg_getData();
	if(fldcont00.peg_isCollapsed()==true){
		let p03,p590,chars=40;
		if(peg002_IsMobileScreen()){
			chars=20;
		}
		if(screenData.dias_var_p03.length>=chars){
			p03=screenData.dias_var_p03.substr(0,chars-3)+'...';
		}else{
			p03=screenData.dias_var_p03;
		}
		if(screenData.dias_var_p590.length>=chars){
			p590=screenData.dias_var_p590.substr(0,chars-3)+'...';
		}else{
			p590=screenData.dias_var_p590;
		}
		fldcont00.setTitle(p03+'/'+p590);
	}else{
		fldcont00.setTitle(fldcont00.title00);
	}
}
//XXX After draw functions
var invcust_a57_d_afterDraw_ajax = '';
function ordercust_a57_d_afterDraw_listeners(container_id){	
	
	var p03		= pegGetCmp(container_id ,'p03');
	var p04		= pegGetCmp(container_id ,'p04');
	var p05		= pegGetCmp(container_id ,'p05');
	var p590	= pegGetCmp(container_id ,'p590');
	var fldcont00	= pegGetCmp(container_id ,'fldcont00');
	
	ordercust_a57_d_update_fldcont00_title(container_id);
	
	fldcont00.on('collapse',function(){
		ordercust_a57_d_update_fldcont00_title(container_id);
	});
	fldcont00.on('expand',function(){
		ordercust_a57_d_update_fldcont00_title(container_id);
	});

	p590.on('change', function(me, newValue, oldValue, eOpts ){ 
		if(newValue == oldValue ){
			return ;
		}  

		ordercust_change_status( container_id );
		ordercust_a57_d_update_fldcont00_title(container_id);
	});
	
	p03.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		}
		ordercust_customer_change( container_id );
		ordercust_a57_d_update_fldcont00_title(container_id);
	});
	p04.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		}

		ordercust_customer_change( container_id );
	});
	p05.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		}
		ordercust_find_invoice_data(container_id,'check_for_new_p03');
	});
	
	var fieldcont_total	= pegGetCmp(container_id ,'fieldcont_total');
	fieldcont_total.on('collapse',function(){
		ordercust_a57_d_update_fieldcont_total_title(container_id);
	});
	fieldcont_total.on('expand',function(){
		ordercust_a57_d_update_fieldcont_total_title(container_id);
	});

	var p0109	= pegGetCmp(container_id ,'p0109');
	p0109.on( 'blur', function( me, e, eOpts ){ 
		ordercust_a57_d_update_fieldcont_total_title(container_id);
	});	
	p0109.on( 'change', function( me, e, eOpts ){ 
		ordercust_a57_d_update_fieldcont_total_title(container_id);
	});		

	let params = {};
	params.nr01 = pegGetVal('nr01', container_id);
	params.mode = "a57";
	if (invcust_a57_d_afterDraw_ajax) {
		if (invcust_a57_d_afterDraw_ajax.id) {
			Ext.ux.AjaxDefer.abort(invcust_a57_d_afterDraw_ajax);
		}
	}
	invcust_a57_d_afterDraw_ajax = pegAjaxDefer(
		'/' + main_path + '/invoices01/find_invoice_p30.php',
		params,
		function (jsonData) { //jsondata.p30
			//pegAlert(jsonData.invoice_p30);
			if (jsonData.invoice_p30 !== "") {
				pegToast(jsonData.invoice_p30, 'info');
			}
		},
		'json',
		true
	);
}

function ordercust_a57_d9_afterDraw_listeners(container_id){

	var a57_d_container_id		=	pegGetContainer_id_d(container_id , 'a57_d'   , '' , 'a57_d' );
	var p0101	= pegGetCmp(container_id ,'p0101');
	var p0112	= pegGetCmp(container_id ,'p0112');
	var p0113	= pegGetCmp(container_id ,'p0113');
	var p0102_1	= pegGetCmp(container_id ,'p0102_1');
	var p0108	= pegGetCmp(container_id ,'p0108');
	var p0102_2	= pegGetCmp(container_id ,'p0102_2');
	//% Εκπτωσης   
	p0101.on( 'blur', function( me, e, eOpts ){ 
		if(me.peg_onBlurValueHasChanged()){
			pegSetVal('p0102_1' , container_id  , 0 );
			pegSetVal('p0102_2' , container_id  , 0 );
			ordercust_calculate_total( a57_d_container_id ); 			
		}
	});
	
	//%Κράτησης 
	p0112.on( 'blur', function( me, e, eOpts ){ 
		if(me.peg_onBlurValueHasChanged()){
			ordercust_calculate_total( a57_d_container_id );	
		}
	});
	//% Φόρου
	p0113.on( 'blur', function( me, e, eOpts ){ 
		if(me.peg_onBlurValueHasChanged()){
			ordercust_calculate_total( a57_d_container_id );
		}
	});
	//Έκπτ. προ ΦΠΑ
	p0102_1.on( 'blur', function( me, e, eOpts ){
		if(me.peg_onBlurValueHasChanged()){
			pegSetVal('p0101'   , container_id , 0 );
			pegSetVal('p0102_2' , container_id , 0 );
			ordercust_calculate_total( a57_d_container_id );
		}
	});
	//Επιβαρύνσεις
	p0108.on( 'blur', function( me, e, eOpts ){ 
		if(me.peg_onBlurValueHasChanged()){
			ordercust_calculate_total( a57_d_container_id );	 
		}
	});
	//Έκπτ. συνόλου
	p0102_2.on( 'blur', function( me, e, eOpts ){
		if(me.peg_onBlurValueHasChanged()){
			pegSetVal('p0101'   , container_id  , 0 );
			pegSetVal('p0102_1' , container_id  , 0 );
			ordercust_calculate_total( a57_d_container_id );
		}
	});
}
function ordercust_a57_d10_afterDraw_listeners(container_id){
	let grid = pegGetCmp(container_id,'grid');
	grid.on('edit', function (editor, context) {
		var values = {};
		values = context.record.data;
		pegSave_grid_row(
			grid.peg_view__d,
			grid.peg_view_table,
			grid.peg_view_module,
			grid.getMnr01(),
			grid.getMmnr01(),
			values,
			function (jsonData) {
				if (!jsonData.ok) {
					context.record.reject();
					pegAlert(jsonData.message);
				} else {
					context.record.commit();
				}
			}
		);

	});
	
	
}

function ordercust_a57_d_update_fieldcont_total_title(container_id){
	fldcont00= pegGetCmp(container_id ,'fieldcont_total');
	let screenData=pegGetCmp(container_id).peg_getData();
	if(fldcont00.collapsed==true){
		pegGetDic('peg_dic_invoice_sum', function(desc){ 
			fldcont00.setTitle(desc + ': ' + screenData.p0109 ); 
		});
	}else{
		fldcont00.setTitle(fldcont00.title00);
	}
}

function ordercust_a57_d2_afterDraw_listeners(container_id){
	// var screen	= pegGetCmp(container_id);
	// var a57_d3_container_id		=	pegGetContainer_id_d(container_id , 'a57_d3'   , '' , 'a57_d' );
	// var p0102	= pegGetCmp(container_id ,'p0102');
	 	
	var grid	= pegGetCmp(container_id ,'grid');

	if(typeof invoices_grid_rowedit_handler === 'function') {
		invoices_grid_rowedit_handler(grid)
	} else {
		grid.setpeg_isEditable(true)
	}
	
	grid.on('beforeedit', function(editor, context) {
		return invoices_beforeedit_actions(container_id,context,'a57');
	});
	grid.on('edit', function(editor, context) { 
		return invoices_edit_actions(container_id,context,'a57');
	});
	grid.on('canceledit',  function(editor, context) {  
		return invoices_canceledit_actions(container_id,context,'a57');
	});
	grid.on('cellkeydown', function(me , td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		return invoices_cellkeydown_actions(e.keyCode,rowIndex,container_id,'a57');
	});
	grid.on('validateedit' , function(editor, context) { 
		return invoices_validateedit_actions(container_id,context,'a57');
	});
	grid.on('peg_delete_all',function(me,recs){
		ordercust_calculate_total(container_id);
		pegGridRefresh(container_id,'grid');
	});
	
	//Το Αντικαταστήσαμε με την συνάρτηση invoices_keyup_actions γιατι κάποιες android συσκευες δεν επιστρεφουν σωστο keycode
	// pegGetCmp(container_id+'_grid_v101').on('keydown', function(me , e	){ 
	// 	invoices_keydown_actions(e.keyCode,container_id,1);
	// });
	
	// pegGetCmp(container_id+'_grid_v102').on('keydown', function(me , e	){ 
	// 	invoices_keydown_actions(e.keyCode,container_id,2);
	// });

	pegGetCmp(container_id + '_grid_v101').on('keyup', function (me, e) {
        invoices_keyup_actions(me.value, container_id, 1);
    });

	pegGetCmp(container_id + '_grid_v102').on('keyup', function (me, e) {
        invoices_keyup_actions(me.value, container_id, 2);
    });

	invoices_set_tooltips(container_id,'a57');
	
	
}

function ordercust_a57_d3_afterDraw_listeners(container_id){
	
	var p09		= pegGetCmp(container_id ,'p09');
	var pn01	= pegGetCmp(container_id ,'pn01');
	var pn02	= pegGetCmp(container_id ,'pn02');
	var p506	= pegGetCmp(container_id ,'p506');
	var p07	    = pegGetCmp(container_id ,'p07'); 

	p09.on('change', function(me, newValue, oldValue, eOpts ){ 
		if(newValue == oldValue ){
			return ;
		}  
		ordercust_change_katestos_fpa( container_id );
	});
	
	
	pn01.on('change', function(me, newValue, oldValue, eOpts ){ 
		if(newValue == oldValue ){
			return ;
		}  

		account_get_exchange_rate(container_id , 'a57');
		if(me.getValue() != '') {
			pegSetFieldReadonly('pn02', container_id, false);
		}else{
			pegSetFieldReadonly('pn02', container_id, true);
		}
	});

	pn02.on('change', function (me, e) {
		if ((me.value_old != me.getValue()) || (!me.value_old)) {
			me.value_old = me.getValue();
			ordercust_calculate_total(container_id);
		}
	});
	
	p07.on('change', function(me, newValue, oldValue, eOpts ){ 
		if(newValue == oldValue ){
			return ;
		}  
		ordercust_calculate_total( container_id );
	});	
	if(p506){
		p506.on('change', function(me, newValue, oldValue, eOpts ){ 
			if(newValue == oldValue ){
				return ;
			}  
			ordercust_calculate_total( container_id );
		});	
	}
}

function ordercust_a57_d4_afterDraw_listeners(container_id){
	var screen	= pegGetCmp(container_id);
	
	var p415	= pegGetCmp(container_id ,'p415');
	var p416	= pegGetCmp(container_id ,'p416');
	
	if(p415){
		p415.on('change', function(me, newValue, oldValue, eOpts ){ 
			if(newValue == oldValue ){
				return ;
			}  
	
			invoices_change_local_stores( container_id , 'a57');
		});	
	}
	
	if(p416){
		p416.on('change', function(me, newValue, oldValue, eOpts ){ 
			if(newValue == oldValue ){
				return ;
			}  
	
			invoices_change_local_stores( container_id , 'a57');
		});		
	}
}

function ordercust_a57_d5_afterDraw_listeners(container_id){
	var screen = pegGetCmp(container_id );
	var p410Field = pegGetCmp(container_id,'p410' );

	
	for (var i = 1; i < 10; i++) {
		var tmpVar =  pegGetCmp(container_id+'_p20'+ i);
		tmpVar.on('blur', function(me){ 
			if((me.value_old!=me.getValue()) || (!me.value_old)){		
				me.value_old=me.getValue();
				invcust_calculate_total( container_id);
			}
		});
		
	}
	
	for (var i = 1; i < 10; i++) {
		var tmpVar =  pegGetCmp(container_id+'_p30'+ i);
		tmpVar.on('blur', function(me){ 
			if((me.value_old!=me.getValue()) || (!me.value_old)){		
				me.value_old=me.getValue();
				invcust_calculate_total( container_id );
			}
		});
		
	}
	
	p410Field.on('change', function(me){ 
		var type=true;
		
		if(me.getValue()==true || me.getValue()==1){
		    type=false;
		}else{
			ordercust_calculate_total( container_id);
		}
		
		pegSetFieldReadonly('p201' , container_id, type);
		pegSetFieldReadonly('p202' , container_id, type);
		pegSetFieldReadonly('p203' , container_id, type);
		pegSetFieldReadonly('p204' , container_id, type);
		pegSetFieldReadonly('p205' , container_id, type);
		pegSetFieldReadonly('p206' , container_id, type);
		pegSetFieldReadonly('p207' , container_id, type);
		pegSetFieldReadonly('p208' , container_id, type);
		pegSetFieldReadonly('p209' , container_id, type);
		
		pegSetFieldReadonly('p301' , container_id, type);
		pegSetFieldReadonly('p302' , container_id, type);
		pegSetFieldReadonly('p303' , container_id, type);
		pegSetFieldReadonly('p304' , container_id, type);
		pegSetFieldReadonly('p305' , container_id, type);
		pegSetFieldReadonly('p306' , container_id, type);
		pegSetFieldReadonly('p307' , container_id, type);
		pegSetFieldReadonly('p308' , container_id, type);
		pegSetFieldReadonly('p309' , container_id, type);

	});
	 
}

var ordercust_a58_d_ajax = null;
function ordercust_a58_d_afterDraw_listeners(container_id){
	
	var screen = pegGetCmp(container_id );
	// var v101 = pegGetCmp(container_id,'v101' );
	// var search_v101 = pegGetCmp(container_id,'search_v101' );
	// var v102 = pegGetCmp(container_id,'v102' );
	// var search_v102 = pegGetCmp(container_id,'search_v102' );
	// var but_mng_i00 = pegGetCmp(container_id,'but_mng_i00' );
	var v_i00	= pegGetCmp(container_id ,'v_i00');
	var tabs = pegGetCmp(container_id,'tab');
	var has_color_size = screen.peg_getData('has_color_size');
	var has_serial = screen.peg_getData('has_serial');
	var has_lot = screen.peg_getData('has_lot');
	 
	
	if(has_color_size==1){
		var totalItems = tabs.items.getCount();
		for (i = 0; i < totalItems; i++) {
			 _d  = tabs.getItem_d(i);
			 
			 if(_d == 'a58_d01'){
				 tabs.items.get(i).enable();
			 }	 
		}
	} 
	
	if(has_serial==1){
		var totalItems = tabs.items.getCount();
		for (i = 0; i < totalItems; i++) {
			 _d  = tabs.getItem_d(i);
			 
			 if(_d == 'a58_d02'){
				 tabs.items.get(i).enable();
			 }	 
		}
	}  

	if(has_lot==1){
		var totalItems = tabs.items.getCount();
		for (i = 0; i < totalItems; i++) {
			 _d  = tabs.getItem_d(i);
			 
			 if(_d == 'a58_d03'){
				 tabs.items.get(i).enable();
			 }	 
		}
	}


	v_i00.on('change', function(me, newValue, oldValue, eOpts ){ 
		if(newValue == oldValue ){
			return ;
		}  
		pegSetVal('v101' ,container_id ,newValue);
		var row = {};
		row.v101 = newValue;
		invoices_get_product_data(row, '', container_id , '' , '' ,  'a57');
	});
	// invoices_set_tooltips(container_id,'a58');
	// v101.on('keydown', function(me , e	){ 
	// 	if(e.keyCode==13 || e.keyCode==191){
	// 		search_v101.handler();	
	// 	}
	// });
	// search_v101.setHandler(function(){
		
	//     if( pegGetVal_d('i18a58' , container_id , 'a58_d00' , '' , 'a58_d' )>0 ){
	//     	pegGetDic('peg_dic_invoices_i18',function(desc){
	//     		 pegAlert(desc);
	//     	});
	       
	//     }else{
	//         invoices_search_product( container_id, 'a57' , 1);
	//     }
	// });
	// v102.on('keydown', function(me , e	){ 
	// 	if(e.keyCode==13){
	// 		search_v102.handler();	
	// 	}
	// });
	// search_v102.setHandler(function(){
	// 	if( pegGetVal_d('i18a58' , container_id , 'a58_d00' , '' , 'a58_d' )>0 ){
	// 		pegGetDic('peg_dic_invoices_i18', function(desc){
	// 			pegAlert(desc);
	// 		}); 
	        
	//     }else{
	//         invoices_search_product( container_id, 'a57' , 2);
	//     }
	// });
	        
	// but_mng_i00.setHandler(function(){
	// 	pedEditRec2Tab( 
	// 			'i00' , 'i00_d' , 
	// 			'inventory' , container_id  , 'pno' , pegGetVal('v101' , container_id )
	// 	);	
	// });
}

function ordercust_a58_d00_afterDraw_listeners(container_id){
	var screen 		  = pegGetCmp(container_id);
	var mmnr01 		  = screen.getMmnr01();
	var v103 		  = pegGetCmp(container_id,'v103');
	var v120 		  = pegGetCmp(container_id,'v120');
	var v108 		  = pegGetCmp(container_id,'v108');
	var but_clear_i18 = pegGetCmp(container_id,'but_clear_i18');
	var v308 		  = pegGetCmp(container_id,'v308');
	
	v103.on('change', function(me){ 
	    invoices_change_product_v103( container_id , 'a57');    
	    invoices_find_product_total('a58_d'   , container_id); 
	});
	v120.on('change', function(me){ 
		invoices_change_product_v120( container_id, mmnr01.substr(0 ,3)) ;	
	});
	
	var fld_total = ["v104", "v106", "v106a", "v1041", "v1042","v616"];
	for (var i = 0; i < fld_total.length; i++) {
		var fld  = fld_total[i];
		var tmpVar =  pegGetCmp(container_id, fld);
		tmpVar.on('blur', function(me){ 
			if(me.peg_onBlurValueHasChanged()){			
				//me.value_old=me.getValue();  
				//var a01_nr01 =  pegGetVal_d('p03' , container_id , 'a57_d' , '' , 'a57_d');
				//sxoliasa egw to a01nr01 giati den xrhsimopoieitai kapou mesa sthn synarthsh
				invoices_find_product_total('a58_d'   , container_id /*,a01_nr01*/ ,0,'a57');
			}
		});
	}
	but_clear_i18.setHandler(function(){
		if(pegGetVal('i18a58' ,container_id)>0){
		    pegSetVal('i18a58' ,container_id,'0');

		    var screen_container_id = container_id;
		    screen_container_id = pegGetContainer_id_d(screen_container_id , 'a58_d' , '' , 'a58_d' );

		    var row = {};
		    row.v101 = pegGetVal('v101' ,  screen_container_id );
		    invoices_get_product_data( row , '', screen_container_id , '' , '' ,  'a57' );
		}
	});
	v308.on('change',  function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		}
		invoices_find_product_quantity('a58_d' , container_id ,  '', '' , 'a57');
	});
	var fld_quantity = ["v301" , "v302", "v303", "v304", "v306", "v307",  "v309", "v310"];
	for (var i = 0; i < fld_quantity.length; i++) {
		var fld  = fld_quantity[i];
		var tmpVar =  pegGetCmp(container_id,fld );
		tmpVar.on('blur', function(me){ 
			if(me.peg_onBlurValueHasChanged()){			
				invoices_find_product_quantity('a58_d' , container_id ,  '', '' , 'a57');
				 
			}
		}); 
	}


	v108.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue){
			return ;
		}
		
		ordercust_change_product_vat_category(container_id, mmnr01.substr(0, 3), newValue);
	});
}

function ordercust_a58_d01_afterDraw_listeners(container_id){
	var screen = pegGetCmp(container_id );
	var grid = pegGetCmp(container_id,'grid');
	grid.setpeg_isEditable(true);
	 grid.on('edit', function(editor, context) {  
		var values = context.record.data;
			values.p01 = screen.getNr01(); 
			 if(values.nr01<0){
			 	values.nr01=0;
			 }			
			//console.info('values' , values);
			
			pegSave_grid_row( 
					grid.peg_view__d ,
					'peg_tmp_a59' , 
					grid.peg_view_module  ,
					grid.getGridMnr01(),  
					grid.getMmnr01(), values , function(jsondata){
						if(!jsondata.ok){ 
							pegAlert(jsondata.message);
							return ;
						}	
						context.record.data['nr01'] = jsondata.nr01;
						context.record.data['v_rest'] = context.record.data['p04'] - context.record.data['p05'];
						context.record.commit(); 
						invoices_find_product_quantity(
								'a58_d'   , 
								container_id, 
								0  , 
								'' , 
								'a57'		
						);
					}
			); 
		 
		 
	});  
	grid.on('peg_delete_all',function(me,recs){
		ordercust_calculate_total(container_id);
		pegGridRefresh(container_id,'grid');
	});
}

function ordercust_a58_d02_afterDraw_listeners(container_id){
	var screen = pegGetCmp(container_id );
	var grid = pegGetCmp(container_id,'grid');
	
	grid.on('edit', function(editor, context) {  
		var values = context.record.data;
		values.p02 = values.v_p02;
		pegSave_grid_row( 
			grid.peg_view__d ,
			'peg_tmp_i32' , 
			grid.peg_view_module  ,
			grid.getGridMnr01(),  
			grid.getMmnr01(), values , function(jsondata){
				if(jsondata.ok==false){
					pegAlert(jsondata.message);
					context.record.data['v_p02'] =jsondata.data.p02 ;
					context.record.commit();
				}else{
						
					context.record.commit();
				}

			}
		);
	});
}

function ordercust_i00_add_to_a57(container_id,id,mnr01,mmnr01,dic,type){
	if(type==2){
		pegAddTab_d("" , "a57", "a57_d" , "ordercust", "", 0 , "", {i00_nr01: mnr01 });
		return;
	}
	var row=pegGridGetSelectedRow(container_id , id);
	if(row){
		var nr01=row.nr01;
		if(nr01<1){
			pegAlert(dic);
			return;
		}			
		params={};
		params.a57nr01=nr01;
		params.i00nr01=mnr01;
		pegAjaxDefer('/' + main_path + '/ordercust01/i00_in_a57_items.php' , params ,function(jsondata){
			if(!jsondata.ok){
				pegConfirmBox( '' ,  jsondata['msg'] , function(ok){
					if(ok=='yes'){
						pegAddTab_d("" , "a57", "a57_d" , "ordercust", "", nr01 , "", {i00_nr01: mnr01 });
					}else{
						pegAddTab_d("" , "a57", "a57_d" , "ordercust", "", nr01 , "", {});
					}
				});
				return;
			}
			pegAddTab_d("" , "a57", "a57_d" , "ordercust", "", nr01 , "", {i00_nr01: mnr01 });
		});
	}else{
		pegAlert(dic);
	}	
}


var ordercust_print_order_ajax = '';
function ordercust_print_order(container_id, nr01){
	
	if(ordercust_print_order_ajax!=''){
		if(ordercust_print_order_ajax.id>0){ 
			Ext.ux.AjaxDefer.abort(ordercust_print_order_ajax);  
		}
	}
	var params = {};
	params.a57_nr01 = nr01;
	receipts_print_receipt_ajax = pegAjaxDefer('/' + main_path + '/ordercust01/check_print_forms.php' , params , function(json_data){
		if(json_data.p85_nr01>0){
			params00 = {};
		    params00['a57_nr01'] 		  = params.a57_nr01;
			params00['dias_main_nr01'] 	  = params.a57_nr01;
			params00['dias_main_table']   = 'a57';
			params00['dias_container_id'] = container_id;

			pegPrintToPDF(json_data.p85_nr01, params00);		
		}else{
			pegWindowShow_d('', 'browse_d005', 'core', '', '0', '&tp=grid&dias_main_table=a57&dias_main_nr01=' + params.a57_nr01,  '',0 , 0 , '', {}, false, true, 0,'tablet');

		}
		
	});
}

var ordercust_a57_mail_send_ajax='';
function ordercust_a57_mail_send_d00_from_record(nr01){
	if(ordercust_a57_mail_send_ajax!=''){
		if(ordercust_a57_mail_send_ajax.id>0){ 
			Ext.ux.AjaxDefer.abort(ordercust_a57_mail_send_ajax);  
		}
	}
	params = {};	
	ordercust_a57_mail_send_ajax = pegAjaxDefer('/' + main_path + '/ordercust01/init_mail_send.php' , 
		params, function(jsondata){
		peg_mail_show_mail_send_d00_ajax("a57", nr01, '', '', jsondata.mail02, jsondata.p85);
	});	
}


function query_q10_d90_140000012000005_d101_grid01_view_afterDraw_listeners(container_id){
    
	var grid = pegGetCmp(container_id, 'grid01');
	var t1_vp03 = WebApp.view.grid.Grid.peg_getColumn(grid, 't1_vp03');
	var t1_nr01 = WebApp.view.grid.Grid.peg_getColumn(grid, 't1_nr01');

	if(t1_vp03){
		t1_vp03.peg_set_metaData = function (me, metaData, record, rowIndex, colIndex){
			try{
					metaData.tdCls = 'peg_clickable_cell';
				}catch(error){
				}
				return metaData;
		
			}
			t1_vp03.peg_column_celldblclick_handler=function(me, td, cellIndex, record, tr, rowIndex, e, eOpts){
				// console.log("You clicked p05 column"+record.get("last_contact_nr01"));
				pegAddTab_d('', 'a01', 'a01_d', 'customers', '', record.get("t1_p03"));
				return false;
			}
	}

	if(t1_nr01){

		t1_nr01.peg_set_metaData = function (me, metaData, record, rowIndex, colIndex){
			try{
					metaData.tdCls = 'peg_clickable_cell';
				}catch(error){
				}
				return metaData;
		
			}
		
		t1_nr01.peg_column_celldblclick_handler=function(me, td, cellIndex, record, tr, rowIndex, e, eOpts){
			// console.log("You clicked p05 column"+record.get("last_contact_nr01"));
			pegAddTab_d('', 'a57', 'a57_d', 'ordercust', '', record.get("t1_nr01"));
			return false;
		}
}
}

// Toggle Fullscreen Std Action
var ordercust_1000_retail00_std_action_ajax = '';
function ordercust_1000_retail00_std_action(container_id) {
	if (ordercust_1000_retail00_std_action_ajax != '') {
		if (ordercust_1000_retail00_std_action_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(ordercust_1000_retail00_std_action_ajax);
		}
	}

	var parent_d = 'retail00_01_d';
	var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , 0 , parent_d );
	if(!retail00_01_d_container_id) {
		parent_d = 'retail00_02_d';
		retail00_01_d_container_id = pegGetContainer_id_d(container_id , 'retail00_02_d'   , 0 , parent_d );
	}

	var retail00_01_d02_container_id = pegGetContainer_id_d(container_id , 'retail00_01_d02' , 0 , parent_d );
	var retail00_01_d04_container_id = pegGetContainer_id_d(container_id , 'retail00_01_d04' , 0 , parent_d );
	var retail00_01_d07_container_id = pegGetContainer_id_d(container_id , 'retail00_01_d07' , 0 , parent_d );

	var values = {
		a01nr01: 	pegGetVal('a01nr01', retail00_01_d02_container_id),
		a01p45:  	pegGetVal('a01p45',  retail00_01_d02_container_id),
		a01p803c:  	pegGetVal('a01p803c',  retail00_01_d02_container_id),
		a01p27:  	pegGetVal('a01p27',  retail00_01_d02_container_id),
		a01a71:  	pegGetVal('a01a71',  retail00_01_d02_container_id),
		a55p30:		pegGetVal('a55p30',  retail00_01_d07_container_id)
	};
	values = Ext.Object.merge(values, pegGetFormVal_d(retail00_01_d04_container_id   , 'retail00_01_d04'  , '' , '' , parent_d));

	ordercust_1000_retail00_std_action_ajax = pegAjaxDefer('/' + main_path + '/ordercust01/ordercust_retail00_order_submit.php', values, function (jsondata) {
		if(jsondata.ok == 1) {
			pegToast(jsondata.msg, 'success');
			retail00_clear_invoice(retail00_01_d_container_id, 1);
		}else{
			pegAlert(jsondata.msg);
		}
	});
}