<?php
    function ordercust_prints_a58_query($a57_nr01, $costs, $disable_i71=false, $lang="GR"){

        $products_query_fields = array(
            'nr01'      => 'nr01', 
            'p00'       => 'p00', 
            'p591'      => 'p591', 
            'p616p'     => 'p616p', 
            'p703'      => 'p703', 
            'remdate'   => 'remdate', 
            'remfdate'  => 'remfdate', 
            'remftime'  => 'remftime', 
            'remfuser'  => 'remfuser', 
            'remguc'    => 'remguc', 
            'remtime'   => 'remtime', 
            'remuser'   => 'remuser', 
            'timh1'     => 'timh1', 
            'timh2'     => 'timh2', 
            'timh3'     => 'timh3', 
            'timh4'     => 'timh4', 
            'v101'      => 'v101', 
            'v102'      => 'v102', 
            'v103'      => 'v103', 
            'v104'      => 'v104', 
            'v1041'     => 'v1041', 
            'v1042'     => 'v1042', 
            'v105'      => 'v105', 
            'v106'      => 'v106', 
            'v106a'     => 'v106a', 
            'v107'      => 'v107', 
            'v108'      => 'v108', 
            'v109'      => 'v109', 
            'v111'      => 'v111', 
            'v120'      => 'v120', 
            'v160'      => 'v160', 
            'v161'      => 'v161', 
            'v301'      => 'v301', 
            'v302'      => 'v302', 
            'v303'      => 'v303', 
            'v304'      => 'v304', 
            'v306'      => 'v306', 
            'v307'      => 'v307', 
            'v308'      => 'v308', 
            'v309'      => 'v309', 
            'v310'      => 'v310', 
            'v614'      => 'v614', 
            'v616'      => 'v616', 
            'v900'      => 'v900', 
            'vapc1'     => 'vapc1', 
            'vapcl1'    => 'vapcl1', 
            'vd01'      => 'vd01', 
            'vd100'     => 'vd100', 
            'vd101'     => 'vd101', 
            'vd102'     => 'vd102', 
            'i18a58'    => 'i18a58', 
            'i19p03'    => 'i19p03', 

            'i71_tot'   => 'i71_tot',
        );  
        
        if(pegasus_module_exists('colorsize')){
            $products_query_fields['a59_p02'] = 'a59_p02';
            $products_query_fields['a59_p03'] = 'a59_p03';
            $products_query_fields['a59_p04'] = 'a59_p04';
        }

        if(pegasus_module_exists('serial')){
            $products_query_fields['i32_p02'] = 'i32_p02';
        }

        $sql_a58_fields = '';
        foreach ($products_query_fields as $field=>$alias) {
            if(!empty($sql_a58_fields)) { $sql_a58_fields .= ", \n"; }

            switch (true) {
                case ($field=='a59_p02'):
                    $dbfield = "a59.p02";
                    break;
                
                case ($field=='a59_p03'):
                    $dbfield = "a59.p03";
                    break;

                case ($field=='a59_p04'):
                    $dbfield = "a59.p04";
                    break; 

                case ($field=='i32_p02'):
                    $dbfield = "i32.p02";
                    break;

                case ($field=='i71_tot'):
                    $dbfield = "0";
                    break;    
                
                default:
                    $dbfield = "a58.".$field;
                    break;
            }

            $sql_a58_fields .= $dbfield . " as " . $alias;
        }

        $sql  = " (select ";
        $sql .= $sql_a58_fields;
        $sql .=	" from a58 ";

        if(pegasus_module_exists('colorsize')){
            $sql .=	" left join a59 on a59.p01=a58.nr01";
        }

        if(pegasus_module_exists('serial')){
            $sql .=	" left join i32 on i32.p00=a58.nr01 and i32.p010=2";
        }
        $sql .=	" where a58.p00=:a57_nr01";

        if(pegasus_module_exists('orders')){
                $sql .= " and a58.v101 not in(:costs_apostpno, :costs_codpno, :costs_cost0pno, :costs_cost1pno, :costs_cost2pno, :costs_cost3pno) ";
        }
        $sql .= ')';


        $sql_i71_fields = '';
        foreach ($products_query_fields as $field=>$alias) {
            if($field=='i71_tot') { continue; }

            switch (true) {
                case ($field=='a59_p02'):
                    $dbfield = "''";
                    break;
                
                case ($field=='a59_p03'):
                    $dbfield = "''";
                    break;

                case ($field=='a59_p04'):
                    $dbfield = "''";
                    break; 

                case ($field=='i32_p02'):
                    $dbfield = "''";
                    break;

                case ($field=='nr01'):
                    $dbfield = "(-1) * i71.nr01";
                    break;

                case ($field=='v102'):
                    $dbfield = "i70.p01";
                    break; 
                    
                case ($field=='v104'):
                    $dbfield = "i71.p100";
                    break;    
                
                default:
                    $dbfield = "''";
                    break;
            }

            $sql_i71_fields .= $dbfield . " as " . $alias . ", \n";
        }

        //Deductions
        $sql_i71_deduc  = " union (select " . $sql_i71_fields;        
        //$sql_i71_deduc .=  "if(i71.i70p02=1, 1, -1) * if(i71.i70p07=0, 0, i71.p100) as i71_tot, ";
		$sql_i71_deduc .=  "'' as i71_tot ";
		$sql_i71_deduc .= "from i71 join i70 on i71.i70=i70.nr01 ";	
		$sql_i71_deduc .= "where i71.tbl='a57' and i71.tbl_nr=:a57_nr01 and i71.i70p02=2 ";
        $sql_i71_deduc .= "order by i71.i70p02,i70.p01) ";

        $replace_array = array("i70.p01"=>($lang=="GR") ? "'Κρατήσεις'" : "'Deductions'","i71.p100"=>"''");
		$sql_i71_deduc_title  = " union (select " . str_replace(array_keys($replace_array), array_values($replace_array), $sql_i71_fields);
		$sql_i71_deduc_title .=  "'' as i71_tot ";
        $sql_i71_deduc_title .= "from i71 join i70 on i71.i70=i70.nr01 ";	
		$sql_i71_deduc_title .= "where i71.tbl='a57' and i71.tbl_nr=:a57_nr01 and i71.i70p02=2 ";
        $sql_i71_deduc_title .= "limit 1) ";

        //Taxes
        $sql_i71_tax  = " union (select " . $sql_i71_fields;        
        //$sql_i71_tax .=  "if(i71.i70p02=1, 1, -1) * if(i71.i70p07=0, 0, i71.p100) as i71_tot, ";
		$sql_i71_tax .=  "'' as i71_tot ";
		$sql_i71_tax .= "from i71 join i70 on i71.i70=i70.nr01 ";	
		$sql_i71_tax .= "where i71.tbl='a57' and i71.tbl_nr=:a57_nr01 and i71.i70p02=1 ";
        $sql_i71_tax .= "order by i71.i70p02,i70.p01) ";
        
        $replace_array = array("i70.p01"=>($lang=="GR") ? "'Φόροι'" : "'Taxes'","i71.p100"=>"''");
        $sql_i71_tax_title  = " union (select " . str_replace(array_keys($replace_array), array_values($replace_array), $sql_i71_fields);
		$sql_i71_tax_title .=  "'' as i71_tot ";
        $sql_i71_tax_title .= "from i71 join i70 on i71.i70=i70.nr01 ";	
		$sql_i71_tax_title .= "where i71.tbl='a57' and i71.tbl_nr=:a57_nr01 and i71.i70p02=1 ";
        $sql_i71_tax_title .= "limit 1) ";
        
        $sql_i71 = $sql_i71_deduc_title . $sql_i71_deduc . $sql_i71_tax_title . $sql_i71_tax;
        
        if($disable_i71==false){
            $sql .= $sql_i71;    
        }

        $sqlParams['a57_nr01'] = $a57_nr01;
        $sqlParams['costs_apostpno'] = $costs['apostpno'];
        $sqlParams['costs_codpno']   = $costs['codpno'];
        $sqlParams['costs_cost0pno'] = $costs['s_cost0pno'];
        $sqlParams['costs_cost1pno'] = $costs['s_cost1pno'];
        $sqlParams['costs_cost2pno'] = $costs['s_cost2pno'];
        $sqlParams['costs_cost3pno'] = $costs['s_cost3pno'];
        
        //echo pegasus_replace_values_in_sql($sql,$sqlParams);
        return array('sql'=>$sql, 'sqlParams'=>$sqlParams);
    }

?>