<?php 
require_once '../peg002_classes/Peg002_Cookie.php';
require_once '../peg002_00/functions.php'; 

class Peg002_Cash{
    private static $noCash = false;
    private static $noCash_d = array( 
        'browse_d0011',
        'browse_d0012',
        'browse_d0013',
        'browse_d0014',
        'browse_d0015',
        'browse_d0016', 
        'browse_d00413',
        'browse_d00414', 
        'browse_d00415', 
        
        '_charts_display_pie_d',
        '_charts_display_cartesian_d',
        
        '_dashboard_d' ,
        
        'q10_d90',
        'q10_d901',
        'q10_d902',
        'q10_d91',
        
        'massimport01_d',
        'massimport01_d03',
        
        'mlang_grid_d',
        'kernel_03_d',
        
        '_massexport_data'
    );
    
    private $lang;
    private $profile;
    private $profilePath;
    private $module;
    private $_d;
    private $table;
    
     
    
    /**
     * 
     * @var {'store', 'structure'}
     */
    private $type ;
    private $display_type ;
    private static $mainPath = '../../tmp/';
    
    protected $curCashFile = '';
    
    public static $p82HtmlTag = <<<EOT
'peg002_tab_items', 'core_submit', 'core_cancel',
'core_count', 'core_close_tab', 'core_close_all_tabs',
'core_close_all_other_tabs', 'core_is_not_pegasus_client',
'core_select_color', 'core_deny_empty_field_value', 'core_only_for_selectbox',
'core_selectbox_mng', 'core_selectbox_erase', 'core_selectbox_edit',
'core_selectbox_search','core_selectbox_list','core_dragtext',
'core_enable_editmode_title','core_dis_editmode_title','core_en_dis_editmode_title',
'core_no_item_selected', 'core_perm_deny_edit_rec','core_perm_deny',
'core_mask_msg',  'core_please_wait', 'core_export_forms_updfrst',
'core_confirm_submit','core_no', 'core_yes','core_no_rec_found','core_f5keydown_msg', 'core_f5keydown_title',
'core_failed_to_load_data_ttl','core_failed_to_load_data_msg',
'core_logoutandrelogin'
EOT;
    
    
    public function __construct( ){
        $this->isStore = false;
        $userCookie = new Peg002_Cookie();
        $this->lang = $userCookie->getLang();
        $this->set_profile($userCookie->getUser_profile());
         
        if(isset($_REQUEST['module'])){
            $this->set_module($_REQUEST['module']);
        }else{
            $this->set_module('');
        }
        
        if(isset($_REQUEST['_d'])){
            $this->set__d($_REQUEST['_d']);
        }else{
            $this->set__d('');
        }


        $this->display_type = '';
        if(isset($_REQUEST['display_type'])){
            $this->display_type = $_REQUEST['display_type']; 
            if($this->display_type == '_selectbox_grid'){
                $this->set_module($_REQUEST['dias_view_module']);
                $this->set__d($_REQUEST['dias_view_d']);
            }
        }
//         $this->set_module($_REQUEST['module']);
//         $this->set__d($_REQUEST['_d']);
    }
    public function __toString(){
        
        if( $_SERVER['REMOTE_ADDR'] === '127.0.0.1'){
            peg002_optionHeader();
            if($_SERVER['REQUEST_METHOD'] == 'OPTIONS')
                return '';
        }
        
        
        $data = $this->getCurrentCashFile();
        header('Content-Type: application/json');
        //         header("Content-Length:" . strlen($data));
        //         set_time_limit(0);
        return $data;
    }
    public function get_curCashFile(){
        return $this->curCashFile;
    }
    public function get_profile(){
        return $this->profile;
    }
    public function set_module($module){
        $this->module = $module; 
    }
    
    public function set__d($_d){    
        $this->_d = $_d; 
    }
    public function set_table($table){
        $this->table = $table;
    }
    
    public function set_profile($profile){ 
        
        $this->profile = $profile;
        if(!empty(  $this->profile )){
            $this->profilePath = 'profile_'.  $profile . '/';
        }else {
            $this->profilePath = 'profile'.  '/';
        }
    }
    

    
    
    public function getCurrentCashFile(){
        if(self::$noCash && $this->type!='store'){
            return '';
        }
        
        if(empty($this->curCashFile)){
            return '';
        }
        $file = file_get_contents( $this->curCashFile);
        if($file === false){
            return '';
        }
//         $data = unserialize($file);
        return $file ;
    }
    
    public function getstructure_has_cash(){
        if(self::$noCash || in_array( $this->_d , self::$noCash_d)){
            //XXX Oi othones pou den prepei na exoun cash
            return false;
        }
        
        $this->curCashFile = static::$mainPath .$this->profilePath .$this->module.'/'.$this->_d.'/';
        if(!empty($this->lang)){
            $this->curCashFile .= $this->lang.'/';
        }
        if(!empty($_REQUEST['peg_ext_containerid'])){
            $this->curCashFile .= substr($_REQUEST['peg_ext_containerid'], 0, 5).'/';
        }
        if( $this->display_type == 'browse_d00'){
            $this->curCashFile .= $this->_d .'_browse_d00.json';
        }elseif ( $this->display_type == '_selectbox_grid') {
            $this->curCashFile .=  $this->_d .'_selectbox_grid.json';
        }else{
            $this->curCashFile .= $this->_d .'.json';
        }
       
        if(file_exists( $this->curCashFile )){
            
            return true;
        } 
        return false;
            
    }
    
    public function getstructure_generate_cash($data){
        if(is_array($data)){
            $data['cashed'] = true; 
        }
        return $this->_file_put_contents($data);
        
    }
    
    
    public function getfields_has_cash(){
        if(self::$noCash || in_array( $this->_d , self::$noCash_d)){
            //XXX Oi othones pou den prepei na exoun cash
            return false;
        }
        
        $this->curCashFile = static::$mainPath .$this->profilePath .$this->module.'/'.$this->_d.'/';
        if(!empty($this->lang)){
            $this->curCashFile .= $this->lang.'/';
        }
        if(!empty($_REQUEST['peg_ext_containerid'])){
            $this->curCashFile .= substr($_REQUEST['peg_ext_containerid'], 0, 5).'/';
        }
        if(isset($_REQUEST['display_type'] ) && $_REQUEST['display_type'] == 'browse_d00'){
            $this->curCashFile .= $this->_d .'_fields_browse_d00.json';
        }else{
            $this->curCashFile .= $this->_d .'_fields.json';
        }
        if(file_exists( $this->curCashFile )){ 
            return true;
        } 
        return false;
        
    }
    public function getfields_generate_cash($data){
        return $this->_file_put_contents($data);
       
    }
     
    
    public function  store_has_cash($storename){
        $this->type = "store";
        /* 
        if(self::$noCash )
            return false;
        } */  
        if(empty($storename)){
            return false;
        }
        
        $this->curCashFile = static::$mainPath .$this->profilePath . 'store/'.$storename.'.json';  
        if(file_exists( $this->curCashFile )){
            return true;
        }
        return false;
    }
    public function  store_has_cash_with_lang($storename, $lang = ''){ 
        if(empty($lang)){
            $lang = $this->lang ;
        }
        if(empty($storename) || empty( $lang )){
            return false;
        }
        $storename .= '_' .  $lang;

        return $this->store_has_cash($storename);
    }
    public function  store_generate_cash($data){
        return $this->_file_put_contents($data);
    }
    
    public function getData_p52_has_cash(){
        if(self::$noCash  ){
            //XXX Oi othones pou den prepei na exoun cash
            return false;
        }
        
        $this->curCashFile = static::$mainPath .$this->profilePath .$this->module.'/'.$this->_d.'/';
        if(!empty($this->lang)){
            $this->curCashFile .= $this->lang.'/';
        }
        if(!empty($_REQUEST['peg_ext_containerid'])){
            $this->curCashFile .=substr($_REQUEST['peg_ext_containerid'], 0, 5).'/';
        }
        if(isset($_REQUEST['display_type'] ) && $_REQUEST['display_type'] == 'browse_d00'){
            $this->curCashFile .= $this->_d .'_p52_browse_d00.json';
        }else{
            $this->curCashFile .= $this->_d .'_p52.json';
        }
        if(file_exists( $this->curCashFile )){
            
            return true;
        }
        return false;
    }
    public function getData_p52_generate_cash($data){
        return $this->_file_put_contents($data);
        
    }
    
    public function getData_query_has_cash(){
        if(self::$noCash  ){
            //XXX Oi othones pou den prepei na exoun cash
            return false;
        }
        
        $this->curCashFile = static::$mainPath .$this->profilePath .$this->module.'/'.$this->_d.'/'.$this->table.'/';
        if(!empty($this->lang)){
            $this->curCashFile .= $this->lang.'/';
        }
        if(!empty($_REQUEST['peg_ext_containerid'])){
            $this->curCashFile .=substr($_REQUEST['peg_ext_containerid'], 0, 5).'/';
        }
        if(isset($_REQUEST['display_type'] ) && $_REQUEST['display_type'] == 'browse_d00'){
            $this->curCashFile .= $this->_d .'_query_browse_d00.json';
        }else{
            $this->curCashFile .= $this->_d .'_query.json';
        }
        if(file_exists( $this->curCashFile )){ 
            return true;
        }
        return false;
    }
    public function getData_query_generate_cash($data){
        return $this->_file_put_contents($data);
        
    }
    
    public function logLastDataQuery($filename ='' , $query){
        $tmpPath00 = static::$mainPath .$this->profilePath .$this->module.'/'.$this->_d.'/';
        if(!empty($this->lang)){
            $this->curCashFile .= $this->lang.'/';
        }
        if(!empty($filename)){
            $tmpPath00 .= $filename .'.sql'; 
        }else{
            $tmpPath00 .= 'dataQuery.sql'; 
        }
        $dirAr = explode('/', str_replace( static::$mainPath, '',$tmpPath00 ));
        $counter = (count($dirAr) - 1);
        for ($i = 0; $i < $counter ; $i++) {
            $tmpPath .= $dirAr[$i] .'/';
            if(!is_dir($tmpPath)){
                mkdir($tmpPath, 0777 , true);
            }
        }
        file_put_contents($tmpPath00, $query);
    }
    
    private function _file_put_contents($data){
        $tmpPath = static::$mainPath;
        $dirAr = explode('/', str_replace( static::$mainPath, '', $this->curCashFile ));
        $counter = (count($dirAr) - 1);
        for ($i = 0; $i < $counter ; $i++) {
            $tmpPath .= $dirAr[$i] .'/';
            if(!is_dir($tmpPath)){
                mkdir($tmpPath, 0777 , true);
            }
        }
         
        file_put_contents($this->curCashFile, json_encode($data));
    }
    
} 