/**
 * @class Functions.peg002.general
 * 
 * @member WebApp.view
 * 
 *  ##Properties
 *  
 *  The global variables of the module
 *  
 *   
 *  ##Methods
 * 
 	- Get Form Data
 	- Manage Data (submit/delete)
 	- Element Type functions
 *  
 *   
 */


//var modelName = 'Pegasus_model'+PEGASUS.USER.get('profile')+'_'+table+'_'+_d; 
/**
 * This objects has as key the element ID and value tru or false if the element is loading
 * @type {Object}
 */
var peg002_loadingObj = {
		_main_d: false
} ;

/**
* Αυτή η συνάρτηση εμφανίζει ένα loading mask στο component που θα δώσουμε ή σε ολόκληρη την οθόνη
* @param {String} container_id="_main_d" To container_id της οθόνης στην οποία θέλουμε να εμφανίσουμε το mask. Αν δεν δώσουμε container_id θα παίρνει αυτόματα το '_main_d' και θα εφαρμόζει το mask σε ολόκληρη την οθόνη.
* @param {String} mask_text="" Το κείμενο που θα εμφανίζεται στο κέντρο του mask πλαισίου. Αν δεν δώσουμε κείμενο θα εμφανίζεται το λεκτικό core_mask_msg ("Παρακαλώ Περιμένετε...")
* @returns Boolean
*/
function peg002_mask(container_id,mask_text=''){
	if(pegIsEmpty(container_id)){
		container_id = '_main_d';
	}
	var dic_mask_msg;
	if(pegIsEmpty(mask_text)){
		pegGetDic('peg_dic_core_mask_msg', function(desc){ dic_mask_msg = desc; });
	}else{
		dic_mask_msg = mask_text;
	}
	if(container_id == '_main_d'){
		Ext.getBody().mask(dic_mask_msg).dom.style.zIndex = '99999';
		peg002_loadingObj['_main_d'] = true;
		return true;
	}else{
		var screen = pegGetCmp(container_id);
		if(screen ){
			if(!screen.masked && !screen.isDestroyed){
				screen.mask(dic_mask_msg);
			}
			peg002_loadingObj[container_id] = true;
		}
		return true;
	}
	 
}
/**
* Αυτή η συνάρτηση αφαιρεί το loading mask από το component που θα δώσουμε ή από ολόκληρη την οθόνη
* @param {String} container_id To container_id της οθόνης από την οποία θέλουμε να αφαιρέσουμε το mask. Αν δεν δώσουμε container_id θα αφαιρέσει αυτόματα όλα τα mask πλαίσια που υπάρχουν στην εφαρμογή.
* @returns Boolean
*/
function peg002_unmask(container_id){ 
	if(pegIsEmpty(container_id) || !peg002_loadingObj[container_id]){
		 
		for (var loadingObj in peg002_loadingObj) {
			if(!pegIsEmpty(loadingObj) && peg002_loadingObj[loadingObj] ){
				if(!loadingObj.isDestroyed){
					peg002_unmask(loadingObj);					
				}

			} 
		}
		
		if(Ext.getBody() && Ext.getBody().isMasked()){
			Ext.getBody().unmask();	
		}
		
		return true;
	}
	
	if(container_id == '_main_d'){
		if(peg002_loadingObj['_main_d']){
			Ext.getBody().unmask();
		}
		peg002_loadingObj['_main_d'] = false;
	}else{
		var screen = pegGetCmp(container_id);
		if(screen ){
			if(screen.peg_mainForm){
				var mainScreen = pegGetCmp(screen.peg_mainForm); 
				if(mainScreen && mainScreen.masked){
					if(mainScreen.masked && !mainScreen.isDestroyed){
						mainScreen.unmask();						
					}

					peg002_loadingObj[container_id] = false;
					delete peg002_loadingObj[container_id];
					return ;
				}
			} 
			if(screen.masked && !screen.isDestroyed){
				screen.unmask();			
			}
		}

		peg002_loadingObj[container_id] = false;
		delete peg002_loadingObj[container_id];
	}
	
}

/**
 * 
 * @param _d
 * 		//To _d poy ua zografistei
 * @param table
 * 		//O pinakas toy _d
 * @param structure
 * 		//Javascript oblect me ta element ths othonis
 * @param  parent_id 
 * 		//To container_id tou screen poy einai panw apo to screen
 * @deprecated @param  container_id
 * 		//To container_id tou screen poy ua dimioyrgithei. 
 * @param extrapar 
 * 		//Obj me epipleon parametrous
 		{
			nr01: nr01
 		}
 * @param dataparams
 * 		// Obj me epipleon parametrous poy tha ginoun get sto load toy modelou
 * @param callback
 * 		//function as callback after sceen draw
 * @returns
 */
function peg002_drawScreen00(_d, table , structure, parent_id,container_id,extrapar,dataparams, callback , appendTo ){ 
	let timecaller="peg002_drawScreen00|"+container_id;
	peg002_time(timecaller,"(total)");
	if(pegIsEmpty(extrapar)){
		extrapar = {};
	}

	if(pegIsEmpty(structure)){
		pegAlert('Fail load structure');
		console.log(structure);
		//console.log(operation);
		peg002_timeEnd(timecaller,"(total)");
		return false;
	}
	peg002_time(timecaller,"setModel(total)");
	
	return peg002_setModel(_d, table,extrapar, 
			function(){
				peg002_time(timecaller,"setModel(callback)");
				var modelName = 'Pegasus_model_'+table+'_'+_d+'_'+PEGASUS.USER.get('profile');
				if(!Ext.ClassManager.isCreated(modelName)  ){
					peg002_timeEnd(timecaller,"setModel(callback)");
					peg002_timeEnd(timecaller,"setModel(total)");
					peg002_timeEnd(timecaller,"(total)");
					throw new Error('Model is not created "' + modelName +'" '); 
					return false;
				}
				 
				if(pegIsEmpty(dataparams)){
					dataparams = {};
				}
				
				dataModel =  eval(modelName);
				if(extrapar['nr01']< 0){
					extrapar['nr01'] = 0;
					extrapar['rec_new'] = 1;
				}
				
				var idValue = extrapar['nr01'];
				if(pegIsEmpty(idValue) && pegIsEmpty(table)){
					idValue = 0; 
				}

				if(dataparams['contextrowIdx'] && dataparams['contextcolIdx']){
					extrapar['contextrowIdx'] = dataparams['contextrowIdx'];
					extrapar['contextcolIdx'] = dataparams['contextcolIdx'];
					delete dataparams['contextrowIdx'];
					delete dataparams['contextcolIdx'];
				}
				
				
				if(pegIsEmpty(extrapar['nr01'])) {
					if(pegIsEmpty(dataparams['nr01'])){
						dataparams['nr01'] =0;
					}
				}else{
					dataparams['nr01'] = extrapar['nr01'];
				}
						
				dataparams['initialize'] = 1;
				dataparams['parent_id'] = parent_id;
				dataparams['container_id'] = container_id;
				if(!pegIsEmpty(extrapar['mnr01']) && pegIsEmpty(dataparams['mnr01'])){
					dataparams['mnr01'] = extrapar['mnr01'];
				}
				if(!pegIsEmpty(extrapar['mmnr01']) && pegIsEmpty(dataparams['mmnr01'])){
					dataparams['mmnr01'] = extrapar['mmnr01'];
				} 
				 
				if(!pegIsEmpty(extrapar['module']) && pegIsEmpty(dataparams['module'])){
					dataparams['module'] = extrapar['module'];
				}
				
				if(!pegIsEmpty(extrapar['rec_new'])){
					dataparams['rec_new'] = extrapar['rec_new'];
				}else if (pegIsEmpty(extrapar['nr01']) && !pegIsEmpty(table)){
					dataparams['rec_new'] = 1;
				}else{
					dataparams['rec_new'] = 0;
				}
				 
				if(pegIsEmpty(dataparams['peg_request_data_from_grid'])){
					dataparams['peg_request_data_from_grid'] = 0;
				}
				
				if(!pegIsEmpty(extrapar['peg_mainForm'])){ 
					var manaScreen = pegGetCmp(extrapar['peg_mainForm']);
					dataparams['peg_mainForm']	= extrapar['peg_mainForm'];
					dataparams['peg_mainTable']	= manaScreen.peg_table;
					dataparams['peg_loaddata']= extrapar['peg_loaddata'];
					
				}
				
				peg002_time(timecaller,"loadDataModel(total)");
				dataModel.load(
					idValue,
					{
						scope: dataModel,
						params:dataparams,
						
						callback: function(record, operation, success) {  
							peg002_time(timecaller,"loadDataModel(callback)");
							if(success===false){   
								var msg  = record.get('msg');
								if(!pegIsEmpty(msg)){
									pegToast(msg,'alert');
								}else{
									pegAlert('Fail load data');
									console.log(record);
									console.log(operation);
								}
								peg002_unmask(parent_id);
								peg002_timeEnd(timecaller,"loadDataModel(callback)");
								peg002_timeEnd(timecaller,"loadDataModel(total)");
								peg002_timeEnd(timecaller,"setModel(callback)");
								peg002_timeEnd(timecaller,"setModel(total)");
								peg002_timeEnd(timecaller,"(total)");	
								return false;
							}else{
								if(pegIsEmpty(idValue)){
									record.phantom = true; 
								}
								
								// TODO peg002_unmask(parent_id); if empty data
								// console.info('dataModel', record); 
								// console.info('dataModel::getdata', record.getData()); 
								// console.info('extrapar',extrapar);
								// console.info('callback',callback);
								// console.info('appendTo',appendTo); 
								peg002_drawScreen(structure, record,record.get('parent_id'),record.get('container_id'),extrapar, callback , appendTo );
								peg002_timeEnd(timecaller,"loadDataModel(callback)");
								peg002_timeEnd(timecaller,"loadDataModel(total)");
								peg002_timeEnd(timecaller,"setModel(callback)");
								peg002_timeEnd(timecaller,"setModel(total)");	
								peg002_timeEnd(timecaller,"(total)");

								return true;
							}
						 }
					}
				);
			}
	);
}
var peg002_ModelMap = {};
var ajaxRequest_setModel = {};
function peg002_setModel(_d, table,extrapar, callback00){
	var modelName = 'Pegasus_model_'+table+'_'+_d+'_'+PEGASUS.USER.get('profile'); 
	let timecaller="peg002_setModel|"+_d+'_'+PEGASUS.USER.get('profile');
	peg002_time(timecaller,"(total)");
	var model = null;
	if(	(Ext.ClassManager.isCreated(modelName))){
		model = eval(modelName);
	}
	if(!pegIsEmpty(_d) &&   !(Ext.ClassManager.isCreated(modelName)) ){ 
		//Ean exw 2 ajax request gia model sigoura ektelestike kat 2 fores se nano second	
		if(ajaxRequest_setModel && ajaxRequest_setModel[table+'_'+_d]){
			if(ajaxRequest_setModel[table+'_'+_d].id>0){ 
				Ext.ux.AjaxDefer.abort(ajaxRequest_setModel[table+'_'+_d]);  
			}
		}
		peg002_time(timecaller,"Ajax(total) "+PEGREQUEST.FIELDS);
		peg002_time(timecaller,"ΗTTP Request Ajax(total)"+PEGREQUEST.FIELDS);
		ajaxRequest_setModel[table+'_'+_d] = 	
			pegAjax(
				PEGREQUEST.FIELDS , 
				{
					_d: _d,
					module: extrapar['module']
				} , 
				function(resp){
					peg002_timeEnd(timecaller,"ΗTTP Request Ajax(total)"+PEGREQUEST.FIELDS);
					peg002_time(timecaller,"Ajax(callback) "+PEGREQUEST.FIELDS);
					var id = 'id';  
					var phantom = false;
					if(!pegIsEmpty(resp['id'])){
						id = resp['id'];
						//To kanw true gt g thn dimiourgeia einai ypeuthino to webapp
						phantom = true;
					}
					
					Ext.define( modelName , {
						extend: 'Ext.data.Model', 
						fields: resp['data'],
						idProperty:  id, 
						phantom: phantom,
						schema: { 
							id: 'shema_'+_d,
							proxy: {
								type: 'ajax',
								actionMethods : {create: 'POST', read: 'POST', update: 'POST', destroy: 'POST'},
								timeout:120000,
								url: PEGREQUEST.DATA ,
								extraParams: { 
									_d: _d,
								    table: table,
									theme:location.search.match(/\btheme=classic\b/) ?'classic':'pegasus-modern'
								},  
								reader: {
									type: 'json',
									rootProperty: 'data', 
									successProperty: 'status'
								},
								         
								        
							}
						},
							   
					});
					peg002_timeEnd(timecaller,"Ajax(callback) "+PEGREQUEST.FIELDS);
					peg002_timeEnd(timecaller,"Ajax(total) "+PEGREQUEST.FIELDS);
					if(callback00 &&  typeof callback00 === 'function'){
						return callback00();
					}
				}
			); 
		peg002_timeEnd(timecaller,"(total)");
		return ajaxRequest_setModel[table+'_'+_d];
	}else if ((Ext.ClassManager.isCreated(modelName)) && Array.isArray(model.fields) && model.fields.length === 0) {
		//Ean exw 2 ajax request gia model sigoura ektelestike kat 2 fores se nano second	
		if(ajaxRequest_setModel && ajaxRequest_setModel[table+'_'+_d]){
			if(ajaxRequest_setModel[table+'_'+_d].id>0){ 
				Ext.ux.AjaxDefer.abort(ajaxRequest_setModel[table+'_'+_d]);  
			}
		}
		peg002_time(timecaller,"Ajax(total) "+PEGREQUEST.FIELDS);
		peg002_time(timecaller,"ΗTTP Request Ajax(total)"+PEGREQUEST.FIELDS);
		ajaxRequest_setModel[table+'_'+_d] = 	
			pegAjax(
				PEGREQUEST.FIELDS , 
				{
					_d: _d,
					module: extrapar['module']
				} , 
				function(resp){
					peg002_timeEnd(timecaller,"ΗTTP Request Ajax(total)"+PEGREQUEST.FIELDS);
					model.replaceFields(resp['data'], true);
					peg002_timeEnd(timecaller,"Ajax(total) "+PEGREQUEST.FIELDS);
					if(callback00 &&  typeof callback00 === 'function'){
						 
						return callback00();
					}
				}
			); 
		peg002_timeEnd(timecaller,"(total)");
		return ajaxRequest_setModel[table+'_'+_d];
	}else{
		peg002_timeEnd(timecaller,"(total)");
		if(callback00 &&  typeof callback00 === 'function'){ 
			return callback00();
		}
	}
	
}
 
function peg002_setStoreModel(table,_d, obj){
	if(pegIsEmpty(table)){
		return null;
	}
	if(pegIsEmpty(_d)){
		return null;
	}
	// console.info('peg002_setStoreModel::obj', obj);
	if(obj['idProperty']){
		  
		var idPropertyFlagError = true ;
		for (var i = 0; i < obj['fields'].length; i++) {
			var array_element = obj['fields'][i];
			if(array_element['name'] == obj['idProperty']){ 
				idPropertyFlagError = false;
				break;
			}
		}
		if(idPropertyFlagError){ 
			console.error('IdProperty "'+obj['idProperty']+'" not in fields ');
			return null;
		}
	}else{
		return null;
	}
	
	var modelName = 'Pegasus_store_model_'+table+'_'+_d+'_'+PEGASUS.USER.get('profile'); 
	var model = null;
	if(	(Ext.ClassManager.isCreated(modelName))){ 
		if(!pegIsEmpty(obj['fields'])){
			model = eval(modelName); 
			model.replaceFields(obj['fields'], true);
		}
		return modelName;
	}
	conf = {
			extend: 'Ext.data.Model' 
		};
	if(!pegIsEmpty(obj['fields'])){
		conf['fields'] = obj['fields'];
	}
	
	if(!pegIsEmpty(obj['idProperty'])){
		
		//To kanw true gt g thn dimiourgeia einai ypeuthino to webapp
		
		if(obj['idProperty']=='nr01'){
			conf['extend'] = 'WebApp.model.Model'; 
		}else{
			conf['idProperty'] = obj['idProperty']; 
		}
	}
	if(!pegIsEmpty(obj['proxy'])){
		conf['proxy'] = obj['proxy'];
	}
	// console.log(modelName+'::conf',  conf);
	Ext.define( modelName , conf);
	 
	return modelName;
}

function peg002_drawScreen(structure,dataModel, parent_id,container_id,extrapar, callback , appendTo ){
	let timecaller= "peg002_drawScreen|".padEnd(30, ' ').substr(0,30) +container_id.padEnd(30, ' ').substr(0,30);
	peg002_time(timecaller,"(total)");
	var screen = null ; 	
	var type = '';
	var fieldTitle = ''; 
	var fieldName = ''; 
	 
	var peg_mainForm = ''; 
	var constructor	= {};  
	
	for (var i = 0; i < structure.length; i++) {
		if(i>1000){
			peg002_timeEnd(timecaller,"(total)");
			return false;
		}
		var constructor = structure[i];
		
		var type = constructor['elementType'];
		var fieldTitle= constructor['fieldTitle'];
		var fieldName = constructor['name']; 
		 
		 	
		if(!pegIsEmpty(constructor['layout'])){
			constructor['layout'] = peg002_formCreateObjGetData('layout', constructor['layout']);
		}
		if(!pegIsEmpty(constructor['responsiveConfig'])){
			constructor['responsiveConfig'] = peg002_formCreateObjGetData('responsiveConfig', constructor['responsiveConfig']);
		}
		if(!pegIsEmpty(constructor['style'])){
			constructor['style'] = peg002_formCreateObjGetData('style', constructor['style']);
		} 
		try {
			if(
					!pegIsEmpty(constructor['name']) &&
					pegIsEmpty(constructor['value']) &&
					screen
			){
				//TODO Check
				constructor['value'] = screen.peg_getData(constructor['name']);
				
			}
			
			
		}catch (e) {
			// TODO: handle exception
			console.error(e);
			console.dir(dataModel);
		}
		
	
			
			
			
		if(type=='screen'){
			if(typeof extrapar == 'object'){
				try {
					var paramsnr01 = dataModel.get('nr01');
					if(!pegIsEmpty(paramsnr01)){
						constructor['peg_nr01'] = paramsnr01;
					}
				} catch (e) {
					// TODO: handle exception
				}
				
				constructor['peg_new_rec'] = false; 
				try {
					constructor['peg_new_rec'] = dataModel.get('peg_new_rec');

				} catch (e) {
					if(!pegIsEmpty(extrapar['rec_new'])){
						constructor['peg_new_rec']  = true;
					}else if (pegIsEmpty(extrapar['nr01']) && !pegIsEmpty(extrapar['table'])) {
						constructor['peg_new_rec']  = true;
					}	
				}
				
				try {
					constructor['peg_mmnr01'] = dataModel.get('mmnr01'); 
				} catch (e) { 
					if(!pegIsEmpty(extrapar['mmnr01'])){
						constructor['peg_mmnr01'] = extrapar['mmnr01'];
					}
				}
				
				try {
					constructor['peg_mnr01'] = dataModel.get('mnr01'); 
				} catch (e) { 
					if(!pegIsEmpty(extrapar['mnr01'])){
						constructor['peg_mnr01'] = extrapar['mnr01'];
					}
				}
				if(!pegIsEmpty(extrapar['table'])){
					constructor['peg_table'] = extrapar['table'];   
				}
				if(!pegIsEmpty(extrapar['url_vars00'])){
					constructor['url_vars00'] = extrapar['url_vars00'];
				}
				  
				
				if(!pegIsEmpty(extrapar['peg_mainForm'])){
					constructor['peg_mainForm'] = extrapar['peg_mainForm'];
				}
				
				if(!pegIsEmpty(extrapar['viewModelData'])){
					constructor['viewModelData'] = extrapar['viewModelData'];						
				}
				if(!pegIsEmpty(extrapar['inWindow'])){
					constructor['peg_inWindow'] = extrapar['inWindow'];						
				}else{
					constructor['peg_inWindow'] = 0;	
					
				}
				
				if(!pegIsEmpty(extrapar['peg_tabid'])){
					constructor['peg_tabid']  =  extrapar['peg_tabid'];
				}
				if(!pegIsEmpty(extrapar['winid'])){ 
					constructor['peg_winid']  =  extrapar['winid'];
				}
				
			
				if(!pegIsEmpty(extrapar['peg_screen_parent_container_id'])){
					constructor['peg_screen_parent_container_id'] = extrapar['peg_screen_parent_container_id'];
				}
				
				
				
				if(!pegIsEmpty(extrapar['peg_screen_parent_element_name'])){
					constructor['peg_screen_parent_element_name'] = extrapar['peg_screen_parent_element_name'];
				}

				if(extrapar['contextrowIdx'] && extrapar['contextcolIdx']){
					constructor['contextrowIdx'] = extrapar['contextrowIdx'];
					constructor['contextcolIdx'] = extrapar['contextcolIdx'];
				} 
			}
			constructor['dataModel'] = dataModel;
			if(!pegIsEmpty(peg_mainForm)){ 
				constructor['peg_mainForm'] = peg_mainForm;
			} 
		}else if (type=='numberbox') {
			
			if(typeof constructor['decimal'] === 'string'){
				constructor['decimal'] = parseInt(constructor['decimal']) 
			}
			if(typeof constructor['decimalPrecision'] === 'string'){
				constructor['decimalPrecision'] = parseInt(constructor['decimalPrecision']) 
			}
			if(constructor['decimal']>0  && pegIsEmpty(constructor['decimalPrecision'])){
				constructor['decimalPrecision']	 = constructor['decimal'];
			}
			delete constructor['decimal'];

		}else if (type=='datebox') {
			constructor['size']	 = parseInt(constructor['size'])+3;
		}else if (type=='tab') {
			constructor['peg_mainForm']= peg_mainForm; 
		}else if (type=='dashboard') {
			try {
				constructor['defaultContent'] =  screen.peg_getData(constructor['name']+ '_defaultContent'); 
			} catch (e) { 
				 
			}
			try {
				constructor['columnWidths'] =  screen.peg_getData(constructor['name']+ '_columnWidths'); 
			} catch (e) { 
				 
			}

		}
		

		if(!pegIsEmpty(type)){ 
			element = peg002_formCreateObj(type, parent_id, container_id,fieldTitle, fieldName, constructor,appendTo);
			if(type == 'screen'){
				peg_mainForm = element.peg_mainForm; 
			} 
			if(type == 'screen'){  
				screen = element;
				//screen.suspendLayouts(); 
			} 
		}
	}   

	
	// console.info('Before after draw',screen );
	// screen.peg_afterDraw();
	screen.peg_execAfterDraw();
	//screen.resumeLayouts(true); 


	peg002_unmask(parent_id);	
	if(callback &&  typeof callback === 'function'){
		peg002_timeEnd(timecaller,"(total)");
		return callback(screen);
		
	}
	
	if(parent_id == '' || parent_id == 'pegasus_body' ){  
		// Turn the suspendLayout flag off.
		screen.suspendLayout = false;
		// Trigger a layout.
		screen.updateLayout();
		 		
	} 
	peg002_timeEnd(timecaller,"(total)");;	
	return true;
}

function peg002_formCreateObj(type, parent_id, container_id ,fieldTitle, fieldName ,constructor, appendTo){
	let timecaller='';
	try {
		timecaller="  peg002_formCreateObj " .padEnd(30, ' ').substr(0,30) +type.padEnd(30, ' ').substr(0,30)+" "+container_id.padEnd(30, ' ').substr(0,30)+" "+fieldName.padEnd(30, ' ').substr(0,30);
	} catch (error) {
		console.error("Error in peg002_formCreateObj: ",error);
		console.error("Params:");
		console.error("type: ",type);
		console.error("container_id: ",container_id);
		console.error("fieldName: ",fieldName);
	}
		peg002_time(timecaller,"(total)");
	var element = null;
 
	 var container = container_id;
	 if(fieldName!='screen'){
		 container+='_'+fieldName;
	 } 
	 constructor['container_id'] = container_id;
	 constructor['id'] = container;  

	 

	switch (type) {
	case 'screen': 
		var screen_js_code = '';
		if(!pegIsEmpty(constructor['screen_js_code'])){
			screen_js_code = constructor['screen_js_code'];
			delete constructor['screen_js_code'];
		} 
		element =  new WebApp.view.Screen(constructor);
		element.peg_screen_js_code(screen_js_code);
		break; 
	case 'fieldSet':
		if(pegIsEmpty(constructor['title'])){
			constructor['title'] = fieldTitle; 
		}
		element =  new WebApp.view.FieldSet(constructor);
		break; 
	case 'PanelFieldset':
		if(pegIsEmpty(constructor['title'])){
			constructor['title'] = fieldTitle; 
		}
		element =  new WebApp.view.PanelFieldset(constructor);
		break; 
	case 'fieldcontainer': 
		element =  new WebApp.view.FieldContainer(constructor);
		break;
	case 'tab':   
		element =  new WebApp.view.tab.Tab(constructor);
		break;
	case 'textbox':
		if(pegIsEmpty(constructor['fieldLabel'])){
			constructor['fieldLabel'] = fieldTitle; 
		} 
		element =  new WebApp.view.field.Text(constructor); 
		break;
	case 'textarea':
		if(pegIsEmpty(constructor['fieldLabel'])){
			constructor['fieldLabel'] = fieldTitle;
		} 
 
		element =  new WebApp.view.field.textarea.TextArea(constructor);
		 
		break;	
	case 'fileUpload':
		if(pegIsEmpty(constructor['fieldLabel'])){
			constructor['fieldLabel'] = fieldTitle; 
		}
		if(constructor['dnd_mode']){
			element =  new WebApp.view.field.UploadPanel(constructor);
		}else{
			element =  new WebApp.view.field.FileUpload(constructor);
		}
 
		 
		break;	
	case 'FileExplorer': 
		element =  new WebApp.view.fileExplorer.FileExplorer(constructor);
		break;
	case 'tinymce':  
		if(pegIsEmpty(constructor['fieldLabel'])){
			constructor['fieldLabel'] = fieldTitle; 
		}
		if(peg002_tinyMCE_button_display_mode_eval(constructor['button_mode'])){
			element= new WebApp.view.field.textarea.tinyButton(constructor);
		}else{
			element =  new WebApp.view.field.textarea.tinyMCE.TinyMCE(constructor); 
		}
		break;	
	case 'numberbox': 

		if(pegIsEmpty(constructor['fieldLabel'])){
			constructor['fieldLabel'] = fieldTitle; 
		} 
		
		element =  new WebApp.view.field.Number(constructor);
		break;
	 
		
	case 'button': 
		if(pegIsEmpty(constructor['text'])){
			constructor['text'] = fieldTitle;
		}  
		element =  new WebApp.view.Button(constructor);
		break;
	 
	case 'combobox':  
		if(pegIsEmpty(constructor['fieldLabel'] )){
			constructor['fieldLabel'] = fieldTitle; 
		}
		element =  new WebApp.view.field.ComboBox(constructor);
		//element =  new WebApp.view.field.ComboBox2(constructor);
		break;
	case 'comboboxV2':  
		if(pegIsEmpty(constructor['fieldLabel'] )){
			constructor['fieldLabel'] = fieldTitle; 
		}
		element =  new WebApp.view.field.ComboBoxV2(constructor);
		break;
	 
	case 'checkbox': 
		if(pegIsEmpty(constructor['fieldLabel'] )){
			constructor['fieldLabel'] = fieldTitle; 
		}
		element =  new WebApp.element.Checkbox(constructor);
		break;
	case 'radio': 
		if(pegIsEmpty(constructor['fieldLabel'])){
			constructor['fieldLabel'] = fieldTitle;
		}
		element =  new WebApp.view.field.Radio(constructor);
		break; 
	case 'datebox':
		if(pegIsEmpty(constructor['fieldLabel'] )){
			constructor['fieldLabel'] = fieldTitle; 
		}
		element =  new WebApp.view.field.Date(constructor);
		break; 
	case 'timefield' : 
		if(pegIsEmpty(constructor['fieldLabel'] )){
			constructor['fieldLabel'] = fieldTitle;
		} 
		element =  new WebApp.view.field.Time(constructor);
		break;
	case 'grid':
		element =  new WebApp.view.grid.Grid(constructor);
		break;
	case 'gridproperty':
		if(pegIsEmpty(constructor['title'])){
			constructor['title'] = fieldTitle;
		}
		element =  new WebApp.view.grid.Property(constructor);
		break;
	case 'accordion':  
		element =  new WebApp.view.panel.Accordion(constructor);
		break; 
	case 'selectbox':  
		if(pegIsEmpty(constructor['fieldLabel'] )){
			constructor['fieldLabel'] = fieldTitle; 
		}
		element =  new WebApp.view.SelectBox(constructor);
		break;  
	case 'scheduler':
		element =  new WebApp.view.Scheduler(constructor);
		break;  
	case 'panel':
		element =  new WebApp.view.panel.Panel(constructor);
		break;  
	case 'progressbar':
		element =  new WebApp.view.ProgressBar(constructor);
		break;  
	case 'multi_selectbox':
		if(pegIsEmpty(constructor['fieldLabel'])){
			constructor['fieldLabel'] = fieldTitle; 
		}
		element =  new WebApp.view.Tag(constructor);
		break;  
	case 'codemirror':
		if(pegIsEmpty(constructor['title'])){
			constructor['title'] = fieldTitle;
		}
		element =  new WebApp.view.codemirror.CodeMirror(constructor);
		break;  
	case 'treepanel':
		element =  new WebApp.view.TreePanel(constructor);
		break;
	case 'toolbar':
		element =  new WebApp.view.toolbar.Toolbar(constructor);
		break;
	case 'filemanager': 
		element =  new WebApp.view.FileManager(constructor);
		break;
	case 'dataview': 
		element =  new WebApp.view.DataView(constructor);
		break;
	case 'dataviewmenu': 
		element =  new WebApp.view.DataViewMenu(constructor);
		break; 
	case 'colorpicker':
		if(pegIsEmpty(constructor['fieldLabel'])){
			constructor['fieldLabel'] = fieldTitle; 
		}
		element =  new WebApp.view.ColorPicker(constructor);
		break;
	case 'dashboard': 
		element =  new WebApp.view.Dashboard(constructor);
		break;
	case 'polarchart': 
		element =  new WebApp.view.charts.polar.Polar(constructor);
		break;
	case 'cartesianchart': 
		element =  new WebApp.view.charts.navigator.Navigator(constructor);
		//element =  new WebApp.view.charts.cartesian.Cartesian(constructor);
		break; 
	case 'DrawPanel': 
		element =  new WebApp.view.DrawPanel(constructor);
		break; 
	default:
		peg002_timeEnd(timecaller,"(total)");
		console.warn('peg002_formCreateObj: Underfinted element type:'+ type);
		return null;
		break; 
	} 
	
	

	if(type == 'screen' ){
		if(!pegIsEmpty(appendTo) && appendTo!='' ){
			try { 
				var filedcontainer = pegGetCmp(appendTo);
				filedcontainer.add(element);			
			} catch (e) { 
				console.error(e);
				console.error('peg002_formCreateObj: 1 undefined appendTo:'+appendTo);
				console.log("Try Ext.getCmp('"+appendTo+"')"); 
			}
		}
	 
	}else {
		if(pegIsEmpty( element ) || pegIsEmpty( element.id )){  
			//mporei o constructor na exei epistrepsei null
			peg002_timeEnd(timecaller,"(total)");
			return null;
		}
		try { 
			var filedcontainer = pegGetCmp(element.appendTo()); 
			filedcontainer.add(element);			
		} catch (e) { 
			// TODO: handle exception
			console.error(e);
			console.error('peg002_formCreateObj: 2 undefined append To:'+ element.appendTo());
			console.log("Try Ext.getCmp('"+element.appendTo()+"')");
			console.log(element);
			
			
		}
	}
	peg002_timeEnd(timecaller,"(total)");
	
	return element;
}
function peg002_formCreateObjGetData(par_nm, par_val){
	 
	
	if(par_nm == 'layout'  && par_val.charAt(0) == '{' ){
		return pegJsonDecode(par_val);
	}else if(par_nm == 'responsiveConfig' && par_val.charAt(0) == '{'){
		return pegJsonDecode(par_val);
	} else if(par_nm == 'style'){
		if( par_val.charAt(0) != '{'){
			par_val = '{' + par_val + '}';
		}
		
		return pegJsonDecode(par_val);	
	} 
	return par_val;
}


function peg002_findElementLabelAlign(type, containerID, name , fieldContainer, labelAlign){
	if(!pegIsEmpty(labelAlign)){
		if(labelAlign=='peg_responsive'){
			if(Ext.getViewportWidth() < DIAS.SCREEN.WIDTH.SMALL){
				if(type=='pegasusCheckBox'){
					return 'left';
				}else{
					return 'top';
				}
			}
			return DIAS.LABELALIGN;
		}
		return labelAlign;
	}
	if(!pegIsEmpty(fieldContainer)){
		var obj = pegGetCmp(containerID, fieldContainer);
		if(typeof obj == 'object'){
			labelAlign = obj.labelAlign;
			if(!pegIsEmpty(labelAlign)){
				if(labelAlign=='peg_responsive'){
					if(Ext.getViewportWidth() < DIAS.SCREEN.WIDTH.SMALL){
						if(type=='pegasusCheckBox'){
							return 'left';
						}else{
							return 'top';
						}
					}
					return DIAS.LABELALIGN;
				}
				return labelAlign;
			}
		}
	}
	var obj = pegGetCmp(containerID); 
	if(typeof obj == 'object'){
		labelAlign = Ext.getCmp(containerID).labelAlign;
		if(!pegIsEmpty(labelAlign)){
			if(labelAlign=='peg_responsive'){
				if(Ext.getViewportWidth() < DIAS.SCREEN.WIDTH.SMALL){
					if(type=='pegasusCheckBox'){
						return 'left';
					}else{
						return 'top';
					}
				}
				return DIAS.LABELALIGN;
			}
			return labelAlign;
		}
	}
	if(type=='pegasusTextArea'){
		return 'top';
	}
	return DIAS.LABELALIGN;
}
function peg002_findElementLabelWidth(type, containerID, name , fieldContainer, labelWidth){
	labelWidth = parseInt(labelWidth);
	
	if(!pegIsEmpty(labelWidth) && labelWidth>0){
		return labelWidth ;
	}
	if(!pegIsEmpty(fieldContainer)){
		var obj =  pegGetCmp(containerID+'_'+fieldContainer);
		if(typeof obj == 'object'){
			labelWidth =  parseInt(obj.labelWidth);
			if(!pegIsEmpty(labelWidth)){
				return labelWidth ;
			}
		}
	}
	var obj =  pegGetCmp(containerID); 
	if(typeof obj == 'object'){ 
		labelWidth = parseInt( obj.labelWidth );
		if(!pegIsEmpty(labelWidth)){
			return labelWidth;
		}
	}
	return DIAS.LABELWIDTH ;
} 
/**
 * @deprecated orizoume mono min kai max width 
 */
function peg002_findElementWidth(type, labelwidth  , size  , min_fieldwidth ){
	return null; 
}
/**
 * @deprecated
 */
function peg002_findElementMinWidth(type, me , size ){
	var width 			= 0;
	var min_fieldwidth	= 30;
	var labelwidth  	= 0;
	
	if(!me.hideLabel  ){
		labelwidth = parseInt(me.labelWidth)
	}
	if(pegIsEmpty(size)){
		size  = 0;
	}else{
		size  = parseInt( size);		
	}

//	type == 'pegasusButton'
//	type == 'pegasusCheckRadio' ||
	if (type == 'pegasusDate' || type == 'pegasusColorPick'  ) {
		 min_fieldwidth =70;
	}else if (type == 'pegasusComboBox' || type == 'pegasusFileUpload' ) {
		 min_fieldwidth =100;
	}else if (
				type == 'pegasusSelectBox' ||  
				type == 'pegasusTextArea' || 
				type == 'pegasusCodeMirror' ||  
				type == 'pegasusTag' 
					
		) {
			min_fieldwidth = 0;
	}else if (type == 'pegasusTextBox' ) {
		min_fieldwidth = 40; 
		if(size>min_fieldwidth){
			min_fieldwidth = size;
		}
	}

	if( me.labelAlign == 'left' || me.labelAlign == 'right' ){
		width = labelwidth+min_fieldwidth ;		
	}else{
		if(  labelwidth   > min_fieldwidth){
			width = labelwidth ;
		}else{
			width = min_fieldwidth;
		}
	}

	
	
	if(type =='pegasusNumber' || type=='pegasusTime'){
		//Einai ta 22 px twn 2 arrow anevasma kai katevasma timhs και 3 τα padding toyy dield
		width+=25;
	}  
	
	return width  ; 
}
/**
 * @deprecated
 * @param type
 * @param me
 * @param size
 * @returns
 */
function peg002_findElementMaxWidth(type, me , size ){
	
	var width 			= 0;
	var min_fieldwidth	= 30;
	var labelwidth  	= 0;
	
	if(!me.hideLabel  ){
		labelwidth = parseInt(me.labelWidth)
	}
	if(pegIsEmpty(size)){
		size  = 0;
	}else{
		size  = parseInt( size);		
	}
	 if (type == 'pegasusDate' || type == 'pegasusColorPick' ) {
		min_fieldwidth =140;
		size = 10;
	}else if (type == 'pegasusComboBox') {
		min_fieldwidth =1400;
	}else if (type == 'pegasusTextBox' ) {
		if(size === 0){ 
			size = 250;
		}
		min_fieldwidth = 130;
		if(size>min_fieldwidth){
			min_fieldwidth = size;
		}
	} else if (
			type == 'pegasusSelectBox' || 
			type == 'pegasusTextArea' || 
			type == 'pegasusCodeMirror' || 
			type == 'pegasusCheckRadio' ||
			type == 'pegasusTag' ||
			type == 'pegasusFileUpload' ||  
			type == 'pegasusButton' ||
			type == 'pegasusDisplay' || 
			type == 'pegasusPanel'
				
	) {
		min_fieldwidth = 0;
	}
	 

//	if(type == 'pegasusButton'){
//		console.info('peg002_findElementMaxWidth::type', type);
//		console.info('peg002_findElementMaxWidth::me', me);
//		console.info('peg002_findElementMaxWidth::min_fieldwidth', min_fieldwidth);
//		console.info('peg002_findElementMaxWidth::size', size);		 
//	}
	 
	if(type == 'pegasusButton'){
		labelwidth = 0; 
		if(!pegIsEmpty( me.icon ) && size>0) {
			size+=me.iconWidth; 
		}
	}
	
	
    if(size==0 && min_fieldwidth==0 ){ 
		return null ;
	}	
			
	if(size == 0){
		width = min_fieldwidth ;
	}else{
		if(size<=3){
			size++;
		}	
		width = (size*10); 
	}
	if( me.labelAlign == 'left' || me.labelAlign == 'right' ){
		width = labelwidth+width ;		 
	}
	
	if(type =='pegasusNumber' || type=='pegasusTime'){
		//Einai ta 22 px twn 2 arrow anevasma kai katevasma timhs και 3 τα padding toyy dield
		width+=25; 
	} 
	if(min_fieldwidth>width){
		return min_fieldwidth  ;
	}
	
	return width  ; 
} 

function peg002_appendKeyMap(me,key,handleKey, extra, scope){
	var ctrl = false;
	var shift = false; 
	var keyEvent = key; 
	 
	scope = me;
	var keymapvar_name='keymap_'+key; 	
	if(extra){
		if(extra['ctrl'] === true){
			ctrl = extra['ctrl'] ;
			keyEvent = 'Ctrl+'+keyEvent;
			keymapvar_name+='_ctrl';			
		}
		if(extra['shift'] === true){
			shift = extra['shift'] ;
			keyEvent = 'Shift+'+keyEvent;
			keymapvar_name+='_shift';
		}
	}
	keymapvar_name+='_enabled';
	if(me[keymapvar_name]){
		return;
	}else{
		me[keymapvar_name]=true;
	}

	
	var target = me;
	if(!pegIsEmpty(me.peg_tabid)  ){
		target = pegGetCmp(me.peg_tabid); 
	}else if (!pegIsEmpty(me.peg_winid)  ) { 
		target = pegGetCmp(me.peg_winid); 
	}
	if(typeof target.setKeyMap  === 'function'){
		var tmpObg = {};
		tmpObg[keyEvent] = { 
				handler: function(keyCode, e){   
					if(!pegIsEmpty(e.peg_screen_id) && pegGetCmp(e.peg_screen_id)){ 
						var ttt = pegGetCmp(e.peg_screen_id);
						handleKey(keyCode, ttt); 
					}else{
						handleKey(keyCode, e); 					
					}
				},
				scope: scope, 
			};   
		target.setKeyMap(tmpObg);
	}else{
		//console.error('Key map error keyEvent' + keyEvent);
		//console.info('target::', target);
		
	}
	
}

/**
 * This function replace the fields of a screen model
 * @param _d
 * @param table
 * @returns
 */
function peg002_screenModelReplaceFields(_d, table){
	if(pegIsEmpty(_d)){
		return false;
	}
	if(pegIsEmpty(table)){
		table = '';
	}
	var modelName = 'Pegasus_model_'+table+'_'+_d+'_'+PEGASUS.USER.get('profile'); 
	var model = null;
	if(	(Ext.ClassManager.isCreated(modelName))){
		model = eval(modelName);
	}else{
		return false;
	}
	model.fields = [];
	return true;
}


/**
 * This Function initialize the global variable PEGASUS.EVENTSMAP with default events 
 * 
 * @link https://docs.sencha.com/extjs/6.5.3/classic/src/Event.js-3.html
 * @link https://docs.sencha.com/extjs/6.5.3/classic/Ext.util.KeyMap.html
 * 
 * @returns
 */
function peg002_core_events(){
	var pegKeyMaps = [];
	//Start F?
	//XXX F1 
	pegKeyMaps.push({
		key: Ext.event.Event.F1  ,   
		handler: function(keycode,e){
			e.stopEvent();
			
			var tab = pegGetCmp(PEGASUS.DEF._main_d_tab);
			var activeScreen = tab.peg_getActiveScreen(); 
			
			if(activeScreen){
				return true;
			}
			
			var buttonHelp = pegGetCmp('_main_d_toolbarbutton_140000000000117');
			if(buttonHelp){
				buttonHelp.handler();
				return false;
			}
			return true;


			
			
//			var tab = pegGetCmp(PEGASUS.DEF._main_d_tab);
//	   		 var activeScreen = tab.peg_getActiveScreen(); 
//	   		console.info('activeScreen', activeScreen);
//	       	 return true;
//			console.log('F1')
//			return false;
		}, 
	});
	//XXX F2
	pegKeyMaps.push({
		key: Ext.event.Event.F2  ,   
		handler: function(keycode,e){
			e.stopEvent();
			return false; 
		}, 
	});
	//XXX F3
	pegKeyMaps.push({
		key: Ext.event.Event.F3  ,   
		handler: function(keycode,e){
			e.stopEvent();
			return false; 
		}, 
	});
	//XXX F5
	pegKeyMaps.push({
		key: Ext.event.Event.F5  ,
        ctrl: false ,
        shift: false, 
		handler: function(keycode,e){  
			e.stopEvent();
			
			var desc = null;
			var title = null;
			
			pegGetDic( 
					'peg_dic_core_f5keydown_title' , 
					function(title00){ 
						title = title00 
						pegGetDic( 
								'peg_dic_core_f5keydown_msg' , 
								function(desc00){ 
									desc = desc00 
									pegConfirmBox(
											title , 
											desc,  
											function(but){ 
												if(but=='yes'){
													window.onbeforeunload = null;
													location.reload();
										  		}
									  		}
									  );
								});
					});


//			
					
			return false;
		}, 
	});
	
	pegKeyMaps.push({
		key:  [Ext.event.Event.META , Ext.event.Event.CONTEXT_MENU ] ,
        ctrl: false ,
        shift: false, 
		handler: function(keycode,e){  
			e.stopEvent();
//			alert('swraios');
			return false;
		}, 
	});
	
	
	
	//Ctrl + s
	pegKeyMaps.push(
		{
	        key: "s",
	        ctrl: true,
	        shift: false, 
	    	handler: function(keycode,e){
	        	 e.stopEvent();
	        	 return true;
	        }
		}
	);
	//Ctrl + Shift + s
	pegKeyMaps.push({
    	key: "s",
        ctrl: true,
        shift: true,
        handler: function(keycode,e){
        	e.stopEvent();
        	 return true;
        },  
     });
	//TAB
	pegKeyMaps.push({
	   	 key: "\t",
		 ctrl: false,
		 shift: false,
		 handler: function(keycode,e){
			 
//			 console.log('Change field');
//			 e.stopEvent();
//	    	 return true;
	     }, 
	 });
	//Ctrl + TAB
	pegKeyMaps.push({
    	 key: "\t",
    	 ctrl: true,
    	 shift: false,
    	 handler: function(keycode,e){
    		 e.stopEvent();
    		 var tab = pegGetCmp(PEGASUS.DEF._main_d_tab);
    		 var activeScreen = tab.peg_getActiveScreen(); 
    		 tab.peg_nextTab();
        	 return true;
         }, 
     });
	//Ctrl + Shift + TAB
	pegKeyMaps.push({
   		key: "\t",
		ctrl: true,
		shift: true,
		handler: function(keycode,e){
			e.stopEvent();
			var tab = pegGetCmp(PEGASUS.DEF._main_d_tab);
			var activeScreen = tab.peg_getActiveScreen();
			tab.peg_previousTab();
			return true;
		}, 
	});
	//Ctrl + F
	pegKeyMaps.push({
    	 key: "F",
    	 ctrl: true,
    	 shift: false,
    	 handler: function(keycode,e){
    		 var tab = pegGetCmp(PEGASUS.DEF._main_d_tab);
    		 var activeScreen = tab.peg_getActiveScreen();
    		 if(activeScreen && activeScreen.peg__d=='browse_d00'){
    			 e.stopEvent();
    			 var grid = pegGetCmp(activeScreen.getContainer_ID()+'_grid');
    			 
    			 pegGetCmp(activeScreen.getContainer_ID()+'_grid_quickfind').focusEl.focus(true);
    			 return true;
    		 } else if (
					activeScreen && 
					(
						activeScreen.peg__d == '_peg002_tree_menu_d' ||
						activeScreen.peg__d == '_peg002_dataview_menu_d'	
					)
			 ) {
				 e.stopEvent();
				 var qtext = pegGetCmp(activeScreen.getContainer_ID(), 'qtext');
				 qtext.focus();
			}  


        	 return false;
         }, 
     });
	//CTRL + Shift + F
	pegKeyMaps.push({
    	 key: "F",
    	 ctrl: true,
    	 shift: true,
    	 handler: function(keycode,e){
    		 var tab = pegGetCmp(PEGASUS.DEF._main_d_tab);
    		 var activeScreen = tab.peg_getActiveScreen();
    		 if(activeScreen ){
    			 if(activeScreen.peg__d=='browse_d00'){
        			 e.stopEvent();
        			 var prpGrid = pegGetCmp(activeScreen.getContainer_ID(),'gridproperty');
        			 var prpGridSlctModel =  prpGrid.getSelectionModel();

        			 prpGridSlctModel.select(0);
        			 prpGrid.getView().focusCell(prpGridSlctModel.getPosition() );
        			 prpGrid.focus();
        			 return true;    				 
    			 }
    		 } 

        	 return false;
         }, 
     });
	//Ctrl + Ε
	pegKeyMaps.push({
    	 key: "Ε",
    	 ctrl: true,
    	 shift: false,
    	 handler: function(keycode,e){
    		 e.stopEvent();
         }, 
     });
	//Ctrl + C
	pegKeyMaps.push({
    	 key: "C",
    	 ctrl: true,
    	 shift: false,
    	 handler: function(keycode,e){
    		 //XXX Disable for the ctrl+c on text field
//    		 var tab = pegGetCmp(PEGASUS.DEF._main_d_tab);
//    		 var activeScreen = tab.peg_getActiveScreen();
//    		 if(activeScreen && activeScreen.peg__d=='browse_d00'){
//    			 e.stopEvent();
//    		 }
         }, 
     });
	//Ctrl + P
	pegKeyMaps.push({
   	 key: "P",
   	 ctrl: true,
   	 shift: false,
   	 handler: function(keycode,e){
   		 var tab = pegGetCmp(PEGASUS.DEF._main_d_tab);
   		 var activeScreen = tab.peg_getActiveScreen();
   		 if(activeScreen && 
   				(
   					activeScreen.peg__d=='plano_d' ||
   					activeScreen.peg__d=='plano_typon_d' ||
   					
   					activeScreen.peg__d=='_plano_omadikon_d' ||
   					activeScreen.peg__d=='_plano_omadikon_d00' ||

   					activeScreen.peg__d=='_plano_paroxon_d' ||
   					activeScreen.peg__d=='_plano00_crm005_d' 
   					
   					
   				)
   					 
   		 ){
   			 var plano = pegGetCmp(activeScreen.getContainer_ID(), 'plano');
   			 
   			 if(plano && plano.print){
   				plano.print();
   	   			e.stopEvent(); 
   	   			return true;   				 
   			 }
   			 return false;
   		 }
       	 return false;
        }, 
    });
	//Alt + "/"
	pegKeyMaps.push({
    	 key: 191 , // The symbol "/"
    	 ctrl: false,
    	 shift: false,
    	 alt: true,
    	 handler: function(keycode,e){
    		 e.stopEvent();
    		 var mainTooltip = pegGetCmp("_main_d_screen_docitem_top");
    		 
    		 if(mainTooltip && mainTooltip.items && mainTooltip.items.items[0]){ 
    			 mainTooltip.items.items[0].focus();

    			 return true;
    		 }
    		 return false;
         }, 
     });
	

		       
	PEGASUS.EVENTSMAP = 
		new Ext.util.KeyMap({
				target:Ext.getDoc(),
				binding: pegKeyMaps
		});
}

function peg002_updateCookie(user_profile, lang, theme){
	var params = {
		user_profile: 0,
		lang: 'GR',
		theme: 'classic'
    };
	if(Ext.util.Cookies.get(PEGASUS.cookiePrpName)  !== null){
		var tmp = pegJsonDecode(Ext.util.Cookies.get(PEGASUS.cookiePrpName));
		if(pegIsEmpty(user_profile) && !pegIsEmpty(tmp['user_profile'])){
			user_profile = tmp['user_profile']
		}
		if(pegIsEmpty(lang) && !pegIsEmpty(tmp['lang'])){
			lang = tmp['lang']
		}
		if(pegIsEmpty(theme) && !pegIsEmpty(tmp['theme'])){
			theme = tmp['theme']
		}
	}
	if(!pegIsEmpty(user_profile)){
		params['user_profile'] = user_profile;
	}
	if(!pegIsEmpty(lang)){
		params['lang'] = lang;
	}

	if(!pegIsEmpty(theme)){
		params['theme'] = theme;
	}
	
	Ext.util.Cookies.set(PEGASUS.cookiePrpName, pegJsonEncode(params) );
} 

function peg002_getCookieLang(){
	if(Ext.util.Cookies.get(PEGASUS.cookiePrpName)  !== null){
		var tmp = pegJsonDecode(Ext.util.Cookies.get(PEGASUS.cookiePrpName));
		 
		if(!pegIsEmpty(tmp['lang'])){
			return tmp['lang'];
		}
	}
	return 'GR';
}

function peg002_requestReload(response){
	if(response && response['ok'] == 0 &&  response['reload'] && response['reload'] === true){
		location.reload(true);
		return true;
	}
	return false;
	
}
//XXX Start After draw functions
function peg002__peg002_tree_menu_d_afterDraw_listeners(container_id){
	var screen		= pegGetCmp(container_id );
	var qtext		= pegGetCmp(container_id , 'qtext'); 
	var menu		= pegGetCmp(container_id , 'menu'); 
	var menuStore	= menu.getStore() ;
	menu.getView().blockRefresh=true;
	
	try {
		menuStore.clearTreeFilter();
	} catch (e) {
		// TODO: handle exception
	}

	/*WebApp.view.Screen.peg_appendKeyMap(
			screen, 
			'F', 
			function(e ){ 
				e.stopEvent();
				qtext.focus();
				return false;
			}, 
			{ ctrl:true });*/
	
	if(screen.peg_tabid.indexOf('toolbox') > -1){
		try {
			menu.collapseAll();
			var record = menuStore.findNode('cd','core9900'); 
			menu.expandNode(record);			
		} catch (e) { 
			// TODO: handle exception
		}

	}

	qtext.on('change', function (field, newValue, oldValue) {
		menu.getView().blockRefresh=false;
		if(menuStore.isLoading()){
			return true;
		}
		var searchString = newValue; 
		
		searchString = searchString.toLowerCase();
		searchStringGR = peg_strGreekToGreekenglish(searchString);
		
		
		
		if (searchString.length < 1) {
			menuStore.clearTreeFilter();
			if(screen.peg_tabid.indexOf('toolbox') > -1){
				menu.collapseAll();
				var record = menuStore.findNode('cd','core9900');
				menu.expandNode(record);
			}
			
		}else{
			
			var regexps00 = Ext.Array.map(searchString.split(/\s+/), function (token) {
                return new RegExp(Ext.String.escapeRegex(searchString), 'i');
            });
			var regexps01; 
			if(searchString!=searchStringGR){
				
				regexps01 = Ext.Array.map(searchStringGR.split(/\s+/), function (token) {
	                return new RegExp(Ext.String.escapeRegex(searchStringGR), 'i');
	            });				
			}else{
				regexps01 = regexps00;
			}
			var length = regexps00.length;
            menuStore.filterTreeBy(function (resource) {

                var title = peg_strGreekToGreekenglish( resource.get('title').toLowerCase() );
                var etitle = resource.get('etitle').toLowerCase();
				var ret=peg_strGreekToLatinCheck(resource.get('title').toLowerCase());
				if(resource.parentNode.data.title){
					var ret2=peg_strGreekToLatinCheck(resource.parentNode.data.title);
					for (var i = 0; i < ret2.length; i++){
						for (var ii = 0; ii < length; ii++){
							if(regexps01[ii].test(ret2[i])){return true;} 
						}
					}
				}
				for (var i = 0; i < ret.length; i++){
					for (var ii = 0; ii < length; ii++){
						if(regexps01[ii].test(ret[i])){return true;} 
					}
				}
				// var ret2=peg_strGreekToLatinCheck(pcd_text);
//              console.info('searchString' , searchString);
//    			console.info('searchStringGR' , searchStringGR); 
//    			console.info('title' , title);
//    			console.info('etitle' , etitle);

                for (var i = 0; i < length; i++){
                	if (!regexps01[i].test(title) && !regexps00[i].test(etitle)) return false;	
                }

                return true;
            });

		}
		return true;
	}); 

	qtext.on('blur',function(){
		menu.getView().blockRefresh=true;
	});
	menu.on('select', function(selectionModel, record, index, eOpts){ 
		if(record.get('leaf') === true){
			try {
				WebApp.view.treePanel.column.MenuItem.pegExecuteAction(container_id, record);				
			} catch (e) {
				console.error(e);
				console.dir(container_id);
				console.dir(record);
				// TODO: handle exception
			}

		}
		try {
			selectionModel.deselect(record);			
		} catch (e) {
			console.error(e);
			console.dir(selectionModel);
			console.dir(record);
			//TODO: handle exception
		}

		return true;
	}); 

 
}
function peg002__peg002_dataview_menu_d_afterDraw_listeners(container_id){
	var screen	= pegGetCmp(container_id );
	var qtext	= pegGetCmp(container_id , 'qtext'); 
	var menu	= pegGetCmp(container_id , 'menu'); 
	var menuStore	= menu.getStore() ;
	menu.blockRefresh=false;
	menuStore.filterTreeBy(function(node){return true;})

	qtext.on('change', function (field, newValue, oldValue) {
		menu.blockRefresh=false;
		var searchString = newValue; 
		
		searchString = searchString.toLowerCase();
		searchStringGR = peg_strGreekToGreekenglish(searchString);
		
		if (searchString.length < 1) {
			menuStore.clearTreeFilter();
		}else{
			var regexps00 = Ext.Array.map(searchString.split(/\s+/), function (token) {
                return new RegExp(Ext.String.escapeRegex(searchString), 'i');
            });
			var regexps01; 
			if(searchString!=searchStringGR){
				
				regexps01 = Ext.Array.map(searchStringGR.split(/\s+/), function (token) {
	                return new RegExp(Ext.String.escapeRegex(searchStringGR), 'i');
	            });				
			}else{
				regexps01 = regexps00;
			}
			var length = regexps00.length;
            menuStore.filterTreeBy(function (resource) {
				var title = peg_strGreekToGreekenglish( resource.get('title').toLowerCase() );
				var etitle = resource.get('etitle').toLowerCase();
				var pcd_text= resource.get('pcd_text').toLowerCase();
				var ret=peg_strGreekToLatinCheck(resource.get('title').toLowerCase());
				var ret2=peg_strGreekToLatinCheck(pcd_text);
				for (var i = 0; i < ret2.length; i++){
					for (var ii = 0; ii < length; ii++){
						if(regexps01[ii].test(ret2[i])){return true;} 
					}
				}
				for (var i = 0; i < ret.length; i++){
					for (var ii = 0; ii < length; ii++){
						if(regexps01[ii].test(ret[i])){return true;} 
					}
				}
                for (var i = 0; i < length; i++){
                	if (!regexps01[i].test(title) && !regexps00[i].test(etitle)) return false;	
                }

                return true;
            });

		}
	}); 
	qtext.on('blur',function(){
		menu.blockRefresh=true;
	});
}

function peg002__peg002_upload_d_submit(screen) {
	var filename = screen.peg_getData('vph');
	var params 			= {};
		params.mmnr01		= screen.getMmnr01() ;
		params.mnr01		= screen.getMnr01() ;
		params.scr__d		= screen.peg__d;
		params.scr_table	= screen.peg_table;
		params.scr_module 	= screen.peg_module;
		params.scr_container_id = screen.getContainer_ID();
		params.no_confim	= 0;

	var form =  screen.getForm();
	if(form.isValid()){
      	pegGetDic('peg_dic_backup_upload_file', function(desc){ 
		form.submit({
			url: '/' + main_path + '/core_global/save_d.php',
			waitMsg: desc,
			params: params,
			success: function(fp, o) {
				var screenData = screen.peg_getData_d();
				var parent_container_id   = screen.peg_screen_parent_container_id; 
				var fileManager = pegGetCmp(parent_container_id + '_filemanager');
				if( o.result.ok==1){ 	
			    	pegAjaxDefer('/' + main_path + '/peg002_tinyMCE/_peg002_upload_d_upload.php',
        		  		params ,
        		  		function(jsonData){
							if(jsonData['ok'] == 1){
								if(jsonData['path'][jsonData['path'].length-1]=='/'){
									jsonData['path']=jsonData['path'].substring(0,jsonData['path'].length-1);
								}
								fileManager.peg_setActiveNodeFromPathAndName(fileManager,  jsonData['path'], jsonData['name']);

								var path=jsonData['path']+'/'+jsonData['name'];
								if(!pegGetCmp(fileManager.peg_treepanelID).getStore().findNode('path',path)){
									fileManager.peg_activeNode.appendChild({	text:jsonData['name'],leaf:true,path:path});
								}
							}
							pegWindowClose(screen.peg_winid);						
				  		}
					);
			   	}else{
			    	fileManager.pegAlert(o.result.message,'',screen.id);
			   	}
			}
		});
      });
	}
}
//TODO
/**
 * @ignore
 */
function peg_strGreekToGreekenglish(str){
	if(typeof str !== 'string'){
		return '';
	}

	str = str.replace(/[αΑ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/gu , 'af$1');
	str = str.replace(/[αΑ][υύΥΎ]/gu , 'av');
	str = str.replace(/[εΕ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/gu , 'ef$1');
	str = str.replace(/[εΕ][υύΥΎ]/gu , 'ev');
	str = str.replace(/[οΟ][υύΥΎ]/gu , 'ou');
	str = str.replace(/[μΜ][πΠ]/gu , 'mp');
	str = str.replace(/[νΝ][τΤ]/gu , 'nt');
	str = str.replace(/[τΤ][σΣ]/gu , 'ts');
	str = str.replace(/[τΤ][ζΖ]/gu , 'tz');
	str = str.replace(/[γΓ][γΓ]/gu , 'ng');
	str = str.replace(/[γΓ][κΚ]/gu , 'gk');
	str = str.replace(/[ηΗ][υΥ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/gu , 'if$1');
	str = str.replace(/[ηΗ][υΥ]/gu , 'iu');
	str = str.replace(/[θΘ]/gu , 'th');
	str = str.replace(/[χΧ]/gu , 'x');
	str = str.replace(/[ψΨ]/gu , 'ps');
	str = str.replace(/[αάΑΆ]/gu , 'a');
	str = str.replace(/[βΒ]/gu , 'v');
	str = str.replace(/[γΓ]/gu , 'g');
	str = str.replace(/[δΔ]/gu , 'd');
	str = str.replace(/[εέΕΈ]/gu , 'e');
	str = str.replace(/[ζΖ]/gu , 'z');
	str = str.replace(/[ηήΗΉ]/gu , 'i');
	str = str.replace(/[ιίϊΙΊΪ]/gu , 'i');
	str = str.replace(/[κΚ]/gu , 'k');
	str = str.replace(/[λΛ]/gu , 'l');
	str = str.replace(/[μΜ]/gu , 'm');
	str = str.replace(/[νΝ]/gu , 'n');
	str = str.replace(/[ξΞ]/gu , 'x');
	str = str.replace(/[οόΟΌ]/gu , 'o');
	str = str.replace(/[πΠ]/gu , 'p');
	str = str.replace(/[ρΡ]/gu , 'r');
	str = str.replace(/[σςΣ]/gu , 's');
	str = str.replace(/[τΤ]/gu , 't');
	str = str.replace(/[υύϋΥΎΫ]/gu , 'i');
	str = str.replace(/[φΦ]/giu , 'f');
	str = str.replace(/[ωώ]/giu , 'o');
	return str;
}


function peg_strGreekToLatinCheck(str){
	if(typeof str !== 'string' && str.length<3 ){
		return [str];
	}
    var ret=[str];
    var regexArr=[    {key:/[αΑ]/gu ,values : ['a'] },
                      {key:/[γΓ]/gu ,values : ['g'] },
                      {key:/[ζΖ]/gu ,values : ['z'] } ,
                      {key:/[κΚ]/gu ,values : ['k'] } ,
                      {key:/[εέΕΈ]/gu ,values : ['e'] } ,
                      {key:/[ιίϊΙΊΪ]/gu ,values : ['i'] } ,
                      {key:/[λΛ]/gu ,values : ['l'] } ,
                      {key:/[μΜ]/gu ,values : ['m'] } ,
                      {key:/[νΝ]/gu ,values : ['n'] } ,
                      {key:/[οόΟΌ]/gu ,values : ['o'] } ,
                      {key:/[πΠ]/gu ,values : ['p'] } ,
                      {key:/[ρΡ]/gu ,values : ['r'] } ,
                      {key:/[τΤ]/gu ,values : ['t'] } ,
                      {key:/[βΒ]/gu ,values : ['b','v'] },
                      {key:/[δΔ]/gu ,values : ['d','th'] } ,
                      {key:/[ηήΗΉ]/gu ,values : ['h','i'] } ,
                      {key:/[θΘ]/gu ,values : ['u','th'] } ,
                      {key:/[ξΞ]/gu ,values : ['c','x','ks'] } ,
                      {key:/[σςΣ]/gu ,values : ['s','w'] } ,
                      {key:/[υύϋΥΎΫ]/gu ,values : ['u','y','i'] }  ,
                      {key:/[φΦ]/giu ,values : ['f','ph'] } , 
                      {key:/[χΧ]/gu  ,values : ['x','h']} ,   
                      {key:/[ψΨ]/gu  ,values : ['y','ps','c'] } ,
                      {key:/[ωώΩΏ]/giu ,values : ['v','o','w'] }  ];
    regexArr.forEach(rule => {  
        if(rule.values.length==1){
             for(var i=0;i<ret.length;i++){
                        
                     ret[i]=ret[i].replace(rule.key,rule.values[0]);
                }
        }else{
            ret.forEach(st => {
                rule.values.forEach(rep => {
                    var item=st.replace(rule.key,rep);
                    ret=ret.filter(x=>x!=st);
                    if(ret.indexOf(item) === -1) {
                        ret.push(item);  
                    }
                });
            });    
	    }
    });
	
	return ret;
}
function peg002_tinyMCE_button_display_mode_eval(value){
	if(value==1){
		return true;
	}else if(value=='tablet'){
		if(peg002_IsMobileOrTabletScreen()){
			return true;
		}
		return false;
	}else if(value=='mobile'){
		if(peg002_IsMobileScreen()){
			return true;
		}
		return false;
	}
	return false;
}
function peg002_GridProperty_html_collapse(me){
if(me){
     me.classList.toggle("active");
    var content = me.nextElementSibling;
    if (content.style.display === "block") {
      content.style.display = "none";
	  me.getElementsByClassName('peg_grid_prop_icon_expanded')[0].style.display="none";
	  me.getElementsByClassName('peg_grid_prop_icon_collapsed')[0].style.display="block";
    } else {
      content.style.display = "block";
	  me.getElementsByClassName('peg_grid_prop_icon_collapsed')[0].style.display="none";
	  me.getElementsByClassName('peg_grid_prop_icon_expanded')[0].style.display="block";
    }
    }
}
function peg002_grid_multi_delete(container_id,name,table,mnr01,mmnr01){
	var winParams={ };
	winParams['grid_mnr01']=mnr01;
	winParams['grid_mmnr01']=mmnr01;
	winParams['grid_table']=table;
	winParams['grid_name']=name;
	winParams['grid_container_id']=container_id;
	peg_windowShow_d(
		'',
		'peg002_grid_multidelete_progress_d',
		'peg002',
		container_id,
		'',
		0,
		'',
		'',winParams,true
		); 
}
function peg002_peg002_grid_multidelete_progress_d_afterDraw_listeners(container_id){
	var screen= pegGetCmp(container_id);
	var continueBt= pegGetCmp(container_id,'continue');
	var closeBt= pegGetCmp(container_id,'close');
	
	var progress_bar	= pegGetCmp(container_id,'progressbar');
	progress_bar.checked=0;
	progress_bar.todel=[];
	pegGetDic('peg_dic_peg002_multidel_loading_txt00',function(desc) {
		progress_bar.loadingTxt=desc;
		progress_bar.updateProgress(0,desc+'('+0+'%)');
	});
	pegGetDic('peg_dic_peg002_multidel_loading_txt01',function(desc) {
		progress_bar.loadingTxt01=desc;
	});
	pegGetDic('peg_dic_peg002_multidel_deleting',function(desc) {
		progress_bar.deletingTxt=desc;
	});
	pegGetDic('peg_dic_peg002_multidel_check_label',function(desc) {
		progress_bar.check_label=desc;
	});
	pegGetDic('peg_dic_peg002_multidel_success',function(desc) {
		progress_bar.multidel_success=desc;
	});
	
	

	var data=pegGetCmp(container_id).peg_getData(); 
	var grid=pegGetCmp(data.grid_container_id,data.grid_name);
	var recs2=WebApp.view.Grid.getSelectedRows(pegGetCmp(data.grid_container_id,data.grid_name));
	progress_bar.totalRecs=recs2.length;
	
	recs2.map(
		item	=>	{	
			var params ={};
			var url00 = '/' +main_path + '/core_global/delete_check_rec.php' ; 
			params.table  = data.grid_table;
			params.nr01   = item.nr01;
			params.name   = data.grid_name;
			params.container_id = screen.peg_screen_parent_container_id;
			params.mnr01  = data.grid_mnr01;
			params.mmnr01 = data.grid_mmnr01;

			if(typeof grid.peg_deleteRec_params == "function"){
				params= {...grid.peg_deleteRec_params({...params},item)};
			}
			pegAjaxDefer(
				url00 , 
				params , 
				function(jsonData){
					var color='green';
					var details=''
					details=jsonData.message;
					if(!jsonData.ok){
						var color='red';
					}else{
						progress_bar.todel.push(item);
					}
					var oldVal=pegGetVal('info',container_id);
					var rec_HTML=	'<div style="text-align:left" class="peg_grid_multidel_prop peg_grid_multidel_cell peg_grid_multidel_prop##mod2##" >'+
										'<div style="border-left:4px solid ##color##">'+
											'<div style="margin-left:3px">'+
												'<b style="color:#04468C">'+
													'##desc##'+
												'</b><br>'+
												'##details##'+
											'</div>'+
										'</div>'+
									'</div>';
					if(!item.description){
						item.description=pegGetCmp(data.grid_container_id,data.grid_name).getPlugin("gridMultiselect").getTagDesc(item,item.nr01);
					}
					rec_HTML=rec_HTML.replace('##nr01##',item.nr01).replace('##color##',color).replace('##details##',details).replace('##check_label##',progress_bar.check_label).replace('##desc##',item.description).replace('##mod2##',progress_bar.checked%2);
					pegSetVal('info',container_id,oldVal+rec_HTML);
					
					progress_bar.checked++;
					if(progress_bar.checked==progress_bar.totalRecs){ 
						pegSetFieldHidden('continue',container_id,false);
						pegSetFieldHidden('close',container_id,false);
						pegSetFieldHidden('wait_txt',container_id,true);
					}
					var prc=(progress_bar.checked/progress_bar.totalRecs);
					progress_bar.updateProgress(prc,progress_bar.loadingTxt+'('+Math.round(prc*100)+'%)');
				});
		}
	);
	progress_bar.deleted=0;
	closeBt.setPeg_handler(function(me){ 
		pegWindowClose(container_id);

	});
	continueBt.setPeg_handler(function(me){ 
		if(progress_bar.todel.length==0){
			pegGetDic('peg_dic_peg002_multidel_no_recs',function(desc) {
				pegAlert(desc);
			});
			return;
		}
		pegGetDic('peg_dic_peg002_multidel_confirm',function(desc) {
			pegConfirmBox('',desc.replace('##num##',progress_bar.todel.length),function(but){ 						
				if(but=='yes'){
					pegSetFieldHidden('continue',container_id,true);
					
					pegSetVal('info',container_id,'');
					var count=0;
					var countPrint=0;
					progress_bar.updateProgress(0,progress_bar.loadingTxt01+'('+0+'%)');
					progress_bar.todelTot=progress_bar.todel.length;
					progress_bar.promisses=[];
					progress_bar.del_recs_data=[];
					progress_bar.todel.map(
						item=>{
							var pr=new Ext.Promise(function (resolve, reject) {
								count++;
								var params ={};
								url00 = '/' +main_path + '/core_global/delete_rec.php' ; 
								params.table  = data.grid_table;
								params.nr01   = item.nr01;
								params.container_id = screen.peg_screen_parent_container_id;
								params.mnr01  = data.grid_mnr01;
								params.mmnr01 = data.grid_mmnr01;
								
								if(typeof grid.peg_deleteRec_params == "function"){
									params= {...grid.peg_deleteRec_params({...params},item)};
								}
								pegAjaxDefer(
									url00 , 
									params , 
									function(jsonData){
										resolve(jsonData);
										countPrint++;
										var oldVal=pegGetVal('info',container_id);
										var prc=count/progress_bar.todelTot;
										progress_bar.updateProgress(prc,progress_bar.loadingTxt01+'('+Math.round(prc*100)+'%)');
										var color='green';
										if(!jsonData.ok){
											var color='red';
											msg=jsonData.message;				
										}else{
											msg=progress_bar.multidel_success;
											var grid=pegGetCmp(data.grid_container_id,data.grid_name);
											grid.fireEvent('peg_delete',grid,jsonData.data);
											progress_bar.del_recs_data.push({...jsonData.data});
										}
										
										var oldVal=pegGetVal('info',container_id);

										
										var rec_HTML=	'<div style="text-align:left" class="peg_grid_multidel_prop peg_grid_multidel_cell peg_grid_multidel_prop##mod2##" >'+
										'<div style="border-left:4px solid ##color##">'+
											'<div style="margin-left:3px">'+
												'<b style="color:#04468C">'+
													'##desc##'+
												'</b><br>'+
												'##details##'+
											'</div>'+
										'</div>'+
									'</div>';
									if(!item.description){
										item.description=pegGetCmp(data.grid_container_id,data.grid_name).getPlugin("gridMultiselect").getTagDesc(item,item.nr01);
									}
									
									rec_HTML=rec_HTML.replace('##nr01##',item.nr01).replace('##color##',color).replace('##details##',msg).replace('##desc##',item.description).replace('##mod2##',countPrint%2);
									pegSetVal('info',container_id,oldVal+rec_HTML);
										if(countPrint==progress_bar.todelTot){
											pegGridRefresh(data.grid_container_id,data.grid_name);
										}
									}
								);
							});
							progress_bar.promisses.push(pr); 

						}
					);
					var resultingPromise = Ext.Promise.all([...progress_bar.promisses]);
					resultingPromise.then(
						function(){
							var grid=pegGetCmp(data.grid_container_id,data.grid_name);
							grid.fireEvent('peg_delete_all',grid,progress_bar.del_recs_data);
						}
					);
				}
			});
			
		});
	});	
}
function peg002_findSubstr_inStore(store,text){
	var data=store.getData().items;
	var tot=data.length;
	var retArr=[];
	for (let i = 0; i < tot; i++) {
		var countChildren=data[i].childNodes.length;
		var tt;
		for (let j = 0; j < countChildren; j++) {
			tt=peg002_searchChildren(data[i].childNodes[j],text);
			retArr=[...retArr,...tt];
		}
	}
	return retArr;
}

function peg002_searchChildren(node,text){
	var countChildren=node.childNodes.length;
	var return_array=[];
	if(countChildren>0){
		for (let i = 0; i < countChildren; i++) {
			var children=peg002_searchChildren(node.childNodes[i],text);		
			if(children.length>0){
				return_array=[...return_array,...children];
			}
		}
	}else{

		var searchString = text;
		searchString = searchString.toLowerCase();
		var searchStringGR = peg_strGreekToGreekenglish(searchString);
		var regexps00 = 
			Ext.Array.map(searchString.split(/\s+/), function (token) {
				return new RegExp(Ext.String.escapeRegex(searchString), 'i');
			});
	
		var regexps01; 
		if(searchString!=searchStringGR){
			regexps01 = 
				Ext.Array.map(searchStringGR.split(/\s+/), function (token) {
					return new RegExp(Ext.String.escapeRegex(searchStringGR), 'i');
				});				
		}else{
			regexps01 = regexps00;
		}
		var title = peg_strGreekToGreekenglish( node.get('title').toLowerCase() );
		var etitle = node.get('etitle').toLowerCase();
	
		var ret=peg_strGreekToLatinCheck(node.get('title').toLowerCase());
	
		var length = regexps00.length;
		for (var i = 0; i < ret.length; i++){
			for (var ii = 0; ii < length; ii++){
				if(regexps01[ii].test(ret[i])){ 
					return  [node];
				} 
			}
		}
	}
	return return_array;
}

function peg002_update_user_phna05(phna05,cor003=''){
	if(!pegIsEmpty(cor003) && cor003!=PEGASUS.USER.get('cor003')){
		return;
	}
	PEGASUS.USER.set('phna05',phna05);
}

function peg002_update_profile_prop_collasped(prop_collapsed){
	pegAjaxDefer( '/' + main_path + '/peg002_03/update_us0_prop_collapsed.php',
		{	'prop_collapsed':prop_collapsed,
			'us0_nr01':PEGASUS.USER.get('nr01')
		},
		function(jsonData){}
	);	
}


function peg002_disk_usage_exceed_d_afterDraw_listeners(container_id){
	var back_button=pegGetCmp(container_id,'back_button');
	back_button.setPeg_handler(function(me){ 
		peg002_logout();
	});
	var renew_button=pegGetCmp(container_id,'renew_button');
	var params={};
	renew_button.setPeg_handler(function(me){ 
		pegAjaxDefer('/' + main_path + '/peg002_03/check_disk_usage_excess_or_expiry.php',
			params , 
			function(jsonData){
				window.onbeforeunload = null;
				window.location.reload();
			}
		);
	});
}
function peg002_disk_usage_exceed_80_d_afterDraw_listeners(container_id){
	var continue_button=pegGetCmp(container_id,'continue_button');
	continue_button.setPeg_handler(function(me){ 
		disk_usage_exceed_80_continue();
	});
}
function disk_usage_exceed_80_continue(){
	var params={};
	pegAjaxDefer('/' + main_path + '/peg002_03/disk_usage_exceed_80_continue.php',
		params , 
		function(jsonData){
			window.onbeforeunload = null;
			window.location.reload();
		}
	);
}

function peg002_contract_expires_warn_d_afterDraw_listeners(container_id){
	var continue_button=pegGetCmp(container_id,'continue_button');
	continue_button.setPeg_handler(function(me){ 
		contract_expires_warn_continue();
	});
}
function contract_expires_warn_continue(){
	var params={};
	pegAjaxDefer('/' + main_path + '/peg002_03/contract_expires_warn_continue.php',
		params , 
		function(jsonData){
			window.onbeforeunload = null;
			window.location.reload();
		}
	);
}
function peg002_contract_expired_d_afterDraw_listeners(container_id){
	var back_button=pegGetCmp(container_id,'back_button');
	back_button.setPeg_handler(function(me){ 
		peg002_logout();
	});
	var renew_button=pegGetCmp(container_id,'renew_button');
	var params={};
	renew_button.setPeg_handler(function(me){ 
		pegAjaxDefer('/' + main_path + '/peg002_03/check_disk_usage_excess_or_expiry.php',
			params , 
			function(jsonData){
				window.onbeforeunload = null;
				window.location.reload();
			}
		);
	});
}

function peg002_logout(){
	peg002_mask();
    pegAjax('/' + main_path + '/core01/logout.php' , {} , 
    function(jsonData){   
        if(jsonData.ok==1){
            window.onbeforeunload = null;
			window.location.reload();
        }
    });
}

function peg002_unlock_app_d_afterDraw_listeners(container_id){
	var screen= pegGetCmp(container_id);
	var back_button=pegGetCmp(container_id,'back_button');
	back_button.setPeg_handler(function(me){ 
		peg002_logout();
	});
	var next_button=pegGetCmp(container_id,'next_button');
	next_button.setPeg_handler(function(me){ 

		pegAjax('/' + main_path + '/peg002_03/continue_without_unlock.php' , {} , 
		function(jsonData){   
			if(jsonData.ok==1){
				window.onbeforeunload = null;
				window.location.reload();
			}
		});
	});
	var next_unlock_button=pegGetCmp(container_id,'next_unlock_button');
	next_unlock_button.setPeg_handler(function(me){
		pegAjax(
			'/' + main_path + '/core_exec/exec00.php' , 
			{	'new_sn': pegGetVal('sn' , container_id)	} , 
			function(jsonData){
				if(jsonData.ok==1){
					window.onbeforeunload = null;
					location.reload(true);
				}else{
					pegAlert(jsonData.msg)
				}
			} , 
			'json' , 
			'1'
		);
	});
	 
}
var html5QrcodeScanner=null;
function peg002_peg002_qrscanner_afterDraw_listeners(container_id){
	var video_el=pegGetCmp(container_id+'_video_el');
	var screen=pegGetCmp(container_id);
	var vm=video_el.getViewModel();
	vm.bind('{theRec.video_el}',function(a,b,c){ 
		html5QrcodeScanner = new Html5Qrcode("qr-reader");		
		var opts= { fps: 500, qrbox: 200 , disableFlip:false };
		if(peg002_IsMobileOrTabletScreen()){
			opts.aspectRatio=1;
		}
		html5QrcodeScanner.start({ facingMode: "environment" },opts, 
		function(decodedText, decodedResult){
			var parent=pegGetCmp(screen.peg_getData().parent_container_id,screen.peg_getData().parent_name);
			if(!parent.fireEvent('peg_before_qrscan_success',parent,decodedText,decodedResult)){
      			return;
			}
			parent.qrval=null;
			if(parent.qrval!=decodedText){
				if(!pegIsEmpty(screen.peg_tabid)){
					pegTabClose(screen.peg_tabid);
				}else{
					pegWindowClose(screen.peg_winid);
				}
				html5QrcodeScanner.stop();
				parent.qrval=decodedText;
				pegSetVal(screen.peg_getData().parent_name,screen.peg_getData().parent_container_id,decodedText);
				parent.fireEvent('peg_qrscan_success',parent,decodedText,decodedResult);				
			}
		} );
	});  
	video_el.on('destroy',function( me, eOpts ){
		if(html5QrcodeScanner!=null){
			try {
				html5QrcodeScanner.stop().then((ignore) => { 
				  }).catch((err) => { 
				  });
		
				  html5QrcodeScanner=null;
			} catch (error) {
				
			}
		} 
	}); 
}
function peg002_show_peg002_qrscanner(me){
	peg_windowShow_d('','peg002_qrscanner','peg002',0,0,0,'','',
	{	'parent_container_id':me.getContainer_ID(),
		'parent_name':me.getName()},false,true,false,0,'mobile');
}

function peg002_update_app_d_afterDraw_listeners(container_id){
	var screen	= pegGetCmp(container_id); 
	var update_button=pegGetCmp(container_id,'update_button');
	var next_button=pegGetCmp(container_id,'next_button');
	var fldcont_help0=pegGetCmp(container_id,'fldcont_help0');
	var progress=pegGetCmp(container_id,'progress');
	var changes=pegGetCmp(container_id,'changes');
	pegGetDic('peg_dic_peg002_check_for_updates',function(desc) {
		fldcont_help0.mask(desc);
	});
 
	update_button.setDisabled(true);
	pegAjax( '/'+main_path+'/core_update/update.php' ,{'step':'login_to_tesae'} , 
		function(jsonData){
			if(jsonData){
				//login to tesae
				if(jsonData.ok==1){ 
					progress.setStyle('line-height','40px')
					progress.updateProgress(1/3,jsonData.message, true); 
					pegAjax('/'+main_path+'/core_update/update.php' , {'step':'validate_sn'} , 
						function(jsonData){
							//validate sn
							if(jsonData.ok==1){
								progress.updateProgress(2/3,jsonData.message, true);
								pegAjax(
									'/'+main_path+'/core_update/update.php' , 
									{'step':'check_module'} , 
									function(jsonData){										
										//check module
										progress.updateProgress(1,jsonData.message, true);
										fldcont_help0.unmask();
										if(jsonData.ok==1){
											changes.setData(jsonData.change); 
											progress.updateProgress(0,'0%', true);
											update_button.setDisabled(false);
										}else{
											pegMsgBox( jsonData.message ); 	
										}
									} , 'json' , 0  ,true);
							}else{ 
								pegAlert( jsonData.message ); 
							}
						} , 'json' , 0 ,true 
					);				
				}else{
					pegAlert( jsonData.message );
				}
			}
		} , 'json' , 0  ,true
	);   
	progress._upd_updateTaskRunner = function (){ 
		pegAjax('/' + main_path + '/core_update/update_task.php' , {} , 
			function(jsondata){
				peg002_update_app_d_progressbar_update(progress, jsondata.text ); 
			}
		);
	}	
	
	var _upd_runner = new Ext.util.TaskRunner();
	progress.peg_task = _upd_runner.newTask({
		run: progress._upd_updateTaskRunner,
		interval: 1000 	 
	});
	update_button.setPeg_handler(function(me){ 
		progress.setStyle('line-height','19px');
		peg002_update_app_d_exec( {'step':'login_to_tesae'}, progress);
		if(progress.peg_task && typeof progress.peg_task.start == "function"){
			progress.peg_task.start();							
		}
		update_button.setDisabled(true);
		next_button.setDisabled(true);
	});
	next_button.setPeg_handler(function(me){
		pegAjax('/' + main_path + '/peg002_03/continue_without_update.php' , {} , 
		function(jsonData){   
			if(jsonData.ok==1){
				window.onbeforeunload = null;
				window.location.reload();
			}
		});
	});
}


function peg002_update_app_d_exec( params , progress_bar ) {
	pegAjax('/'+main_path+'/core_update/update.php' , params , function(jsonData){
		if(jsonData.params && jsonData.params.progress){
			progress_bar.peg_progress=jsonData.params.progress;
		}
		var step_descr='';
		if(jsonData.params ){ 
			if(jsonData.params.step=='download_files'){
				progress_bar.peg_step=1; 
				if( progress_bar.peg_progress==1){
						progress_bar.peg_progress=0.99;
					}
			}else if(jsonData.params.step=='install_files'){
				progress_bar.peg_step=2; 
				if( progress_bar.peg_progress==1){
						progress_bar.peg_progress=0.99;
					}
			}else{
				progress_bar.peg_step=0;
				progress_bar.peg_progress=0; 
				jsonData.message ='';
			}
		
			step_descr=jsonData.params.step_descr;

		} 
		if( step_descr && progress_bar.peg_step_descr!=step_descr){
			progress_bar.peg_progress=0;
			progress_bar.peg_step_descr=step_descr;
		} 	
		peg002_update_app_d_progressbar_update(progress_bar, jsonData.message ); 
		if(jsonData.exec_next==1){
			peg002_update_app_d_exec( jsonData.params , progress_bar );
				
		}
		if(jsonData.end==1){
			progress_bar.setStyle('line-height','40px');
			progress_bar.updateProgress(1, jsonData.message,true);
			if(progress_bar.peg_task && typeof progress_bar.peg_task.stop == "function"){
				progress_bar.peg_task.stop();							
			}
            window.onbeforeunload = null;
			window.location.reload();
		}
	}, 'json');
}	

function peg002_update_app_d_progressbar_update(progressbar,message){

	var peg_step=progressbar.peg_step;
	var peg_step_descr=progressbar.peg_step_descr;

	var peg_progress=progressbar.peg_progress;
	 
	var percentage=Math.round(peg_progress*100);
	var step_dic='Step';
	if (peg002_getCookieLang()=='GR'){
		step_dic='Βήμα';
	}
	var step_str=`${step_dic} ${peg_step}/2&nbsp;&nbsp;-&nbsp;&nbsp;`;
	if( progressbar.peg_step==0){
		step_str='';
	}
	if(percentage>=0 && progressbar.peg_step!=0){
		var percentage_str=`&nbsp;( ${percentage}% )`;
	}else{
		var percentage_str='';
	}
	if(!message || message==progressbar.message ||  progressbar.message==peg_step_descr){
		message='...';
	}
	progressbar.message=message;
	progressbar.updateProgress(peg_progress, ` ${message}<br>${step_str}${peg_step_descr}${percentage_str}`);
}

function peg002_sync_app_d_afterDraw_listeners(container_id){
	var screen	= pegGetCmp(container_id); 
	var sync_button=pegGetCmp(container_id,'sync_button');
	var next_button=pegGetCmp(container_id,'next_button');
	var fldcont_help0=pegGetCmp(container_id,'fldcont_help0');
	var progress=pegGetCmp(container_id,'progress');
	var changes=pegGetCmp(container_id,'changes');
	// pegGetDic('peg_dic_peg002_check_for_updates',function(desc) {
	// 	fldcont_help0.mask(desc);
	// });
 
	sync_button.setDisabled(true);
	pegAjax( '/'+main_path+'/core_update/check_json_updates.php' ,{} , 
		function(jsonData){
			if(jsonData){			
				if(jsonData.ok==1){ 
					progress.setStyle('line-height','40px')
					if(jsonData.change_html != undefined && jsonData.change_html != '' && jsonData.change_html != null){
						changes.setData(jsonData.change_html); 
					}
					progress.updateProgress(0,'0%', true);
					sync_button.setDisabled(false);
					modules = jsonData.modules;
				}
			}
		} , 'json' , 0  ,true
	); 

	progress._upd_updateTaskRunner = function (){ 
		pegAjax('/' + main_path + '/core_exec/exec_task.php' , {} , 
			function(jsondata){
				peg002_sync_app_d_progressbar_update(progress, jsondata.text ); 
			}
		);
	}

	var _upd_runner = new Ext.util.TaskRunner();
	progress.peg_task = _upd_runner.newTask({
		run: progress._upd_updateTaskRunner,
		interval: 1000 	 
	});

	sync_button.setPeg_handler(function(me){ 
		progress.setStyle('line-height','19px');
		peg002_sync_app_d_exec( {'step':2, 'peg_grid_module': modules, 'p92_nr01': 140000000000011}, progress);
		
		if(progress.peg_task && typeof progress.peg_task.start == "function"){
			progress.peg_task.start();							
		}
		sync_button.setDisabled(true);
		next_button.setDisabled(true);
	});
	next_button.setPeg_handler(function(me){
		pegAjax('/' + main_path + '/peg002_03/continue_without_update.php' , {} , 
		function(jsonData){   
			if(jsonData.ok==1){
				window.onbeforeunload = null;
				window.location.reload();
			}
		});
	});

}
function peg002_sync_app_d_exec( params , progress_bar ) {
	pegAjax('../../pegasus_cloud_app/core_exec/exec.php' , params , function(jsonData){
		if(jsonData.params && jsonData.params.prog){
			progress_bar.peg_progress=jsonData.params.prog;
		}
		peg002_sync_app_d_progressbar_update(progress_bar, jsonData.message ); 
		if(jsonData && jsonData.exec_next == 1){
			params.exp_i = jsonData.params.exp_i
			params.exp_j = jsonData.params.exp_j
			params.count = jsonData.params.count
			params.mark = jsonData.params.mark
			params.p_step = jsonData.params.p_step
			params.p_rep_cnt = jsonData.params.p_rep_cnt
			peg002_sync_app_d_exec(params, progress_bar);
		}

		if(jsonData.end==1){
			progress_bar.setStyle('line-height','40px');
			progress_bar.updateProgress(1, jsonData.message,true);
			if(progress_bar.peg_task && typeof progress_bar.peg_task.stop == "function"){
				progress_bar.peg_task.stop();							
			}
			window.onbeforeunload = null;
			window.location.reload();
		}
	}, 'json');
	
}

function peg002_sync_app_d_progressbar_update(progressbar, message){

	var peg_progress=progressbar.peg_progress;
	var percentage=Math.round(peg_progress*100);
	if(percentage>=0){
		var percentage_str=`&nbsp;( ${percentage}% )`;
	}

	if(!message || message==progressbar.message){
		message='...';
	}
	progressbar.message=message;
	progressbar.updateProgress(peg_progress, ` ${message}<br>${percentage_str}`);
}



function peg002_insert_in_container(parent,obj,index){
	if(!obj.name){
		console.warn("WebApp.view.FieldSet@peg_insert: You must provide a name for the object to be inserted");
		return;
	}
	if(!obj.xtype){
		console.warn("WebApp.view.FieldSet@peg_insert: You must provide a valid xtype for the object to be inserted");
		return;
	} 
	if(!obj.container_id){
		obj.container_id=parent.container_id;
	}
	if(!obj.peg_module){
		obj.peg_module=parent.peg_module;
	}
	if(!obj.peg__d){
		obj.peg__d=parent.peg__d;
	}   
	// delete  obj.xtype ;  ; 
	var myinstance=peg002_formCreateObj(obj.xtype,'',obj.container_id,'',obj.name,obj,parent); 
	try {
		if(index>0){
			parent.insert(index, myinstance);
		}else{
			parent.add(myinstance);
		}
	} catch (error) {
		console.error(error);
	}
	return myinstance;
}

function peg002_add_to_screen_data(container_id,name,value){
	var screen=pegGetCmp(container_id);
	if(screen){
		var vm = screen.getViewModel();
		if(vm){
			var data=vm.getData();
			if(data){
				data.theRec.set(name,value);
			}
		}
	}
}

function peg002_remove_from_screen_data(container_id,name){
	peg002_add_to_screen_data(container_id,name,'');
}

function peg002_get_screen_data(container_id,name){ 
	return pegGetCmp(container_id).peg_getData(name);
}

function peg002_set_screen_data(container_id,name,value){
	var screen=pegGetCmp(container_id);
	if(screen){
		var vm = screen.getViewModel();
		if(pegIsEmpty(vm)){
			vm  = pegGetCmp(screen.peg_mainForm).getViewModel();
		}
		if(vm){
			var data=vm.getData();
			if(data){
				return data.theRec.set(name,value);
			}
		}
	}
	return null;
}

function peg002_unset_screen_data(container_id,name){ 
	var screen=pegGetCmp(container_id);
	if(screen){
		var vm = screen.getViewModel();
		if(pegIsEmpty(vm)){
			vm  = pegGetCmp(screen.peg_mainForm).getViewModel();
		}
		if(vm){
			var data=vm.getData();
			if(data && data.theRec && data.theRec.data){
				return delete data.theRec.data[name];
			}
		}
	}
	return null;
}

function peg002_delete_record(container_id , table , nr01 , mnr01 , mmnr01 , callback){
	if(!nr01 || !table ) return;
	var params ={};
	url00 = '/' +main_path + '/core_global/delete_check_rec.php' ; 
	params.table  = table;
	params.nr01   = nr01;
	params.container_id = container_id;
	params.mnr01  = mnr01;
	params.mmnr01 = mmnr01;
			
	Ext.Ajax.request({
		url: url00      ,
		params: params  ,
		success: function(response){	
		    var text = response.responseText;					        
			var jsonData = Ext.JSON.decode( text );
			if(!jsonData.ok){
				pegAlert(jsonData.message);
			}else{
				pegConfirmBox( '' , jsonData.message ,    function(but){ 
					if(but=='yes'){
						peg002_delete_record00(container_id ,table , params.nr01 , mnr01 , mmnr01 , callback);
					} 
				});
			}
		}
	}); 			
}

function peg002_delete_record00(container_id , table , nr01 , mnr01 , mmnr01 , callback  ){
	var params ={};
		url00 = '/' +main_path + '/core_global/delete_rec.php' ; 
		params.table  = table;
		params.nr01   = nr01;
		params.container_id = container_id;
		params.mnr01  = mnr01;
		params.mmnr01 = mmnr01;
			
		Ext.Ajax.request({
		    url: url00      ,
		    params: params  ,
		    success: function(response){	
		    	var text = response.responseText;					        
				var jsonData = Ext.JSON.decode( text );
				if(!jsonData.ok){
					pegAlert(jsonData.message);				
				}else{
					if(callback && typeof(callback) === "function"){
						callback(jsonData);
					}	
				}
		    }
		}); 		
}
function peg002_update_GridProperty_data(main_grid,propertypanel,view_nr01){
	propertypanel.mask("Please Wait");
	var params={};
	params.name = propertypanel.name; 
	params.view_d = main_grid.peg_view__d; 
	params.view_table = main_grid.peg_view_table; 
	params.view_module = main_grid.peg_view_module; 
	params.view_nr01 = view_nr01; 
	params._d= main_grid.peg__d;
	params.module= main_grid.peg_module;
	params.container_id=main_grid.container_id;
	params.html=1;
	params.view_grid_name=main_grid.name;
	params.peg_total_count=main_grid.peg_total_count;
	pegAjaxDefer(PEGREQUEST.GRIDPROPERTYDATA,params,function(jdonData){
		propertypanel.setHtml(jdonData.data);
		propertypanel.unmask();
	});
}
function peg002ClearFilter(filter,container_id,view_grid_name,elementId){ 
	Ext.get(elementId).setDisplayed(false);
	var params={...filter};
	params.container_id=container_id;
	params.view_grid_name=view_grid_name;
	pegAjaxDefer(
		'/' + main_path + '/peg002_03/clear_grid_filter.php',
		params , 
		function(jsonData){
			pegGetCmp(container_id,view_grid_name).store.proxy.url= PEGREQUEST.GRIDDATA; 
			peg002_GridRefresh(container_id,view_grid_name,0,true);
			var browse_d0021_container_id=pegGetContainer_id_d(container_id,'browse_d0021','','browse_d0021');
			if(!pegIsEmpty(browse_d0021_container_id)){
				core_browse_d0021_refresh(browse_d0021_container_id);
			}
		});

}
function peg002_app_owner_update_d_check_d64(container_id,atleast=0){
	var nonEmpty=Object.keys(peg002_get_screen_data(container_id)).filter(k=>{return  k.match(/d00_00_d64_p001_[0-9]*$/) }).filter(dt=>peg002_get_screen_data(container_id)[dt]!='');
	if(nonEmpty.length<=atleast){
		pegGetDic("peg_dic_peg002_owner_app_update_d64_empty",function(desc){
			pegToast(desc,"alert");
		});
		return false;
	}
	return true;
}
function peg002_app_owner_update_d_check_d65(container_id,atleast=0){
	var nonEmpty=Object.keys(peg002_get_screen_data(container_id)).filter(k=>{return  k.match(/d00_00_d65_p01_[0-9]*$/) }).filter(dt=>peg002_get_screen_data(container_id)[dt]!='');
	if(nonEmpty.length<=atleast){
		pegGetDic("peg_dic_peg002_owner_app_update_d65_empty",function(desc){
			pegToast(desc,"alert");
		});
		return false;
	}
	return true;
}
function peg002_app_owner_update_d_remove_d64d65(container_id,mode,index){
	if(mode!='d65' && mode!='d64' || index<1 || index>10){
		return;
	}
	var total_recs=0;
	for (let i = 1; i <= 10 ; i++) {
		if(!pegIsEmpty(pegGetVal(mode+'_p01_'+i,container_id)) && index!=i ){
			total_recs++;
		}
	}
	if(total_recs==0){
		pegGetDic("peg_dic_peg002_owner_app_update_"+mode+"_empty",function(desc){
			pegToast(desc,"alert");
		});
		return ;
	}
	pegSetVal(mode+'_nr01_'+index,container_id,"");
	pegSetVal(mode+'_p01_'+index,container_id,"");

	if(pegGetCmp(mode+'_p300_'+index)){
		pegSetVal(mode+'_p300_'+index,container_id,""); 
	}
	// peg002_app_owner_update_d_toggle_hidden_d64d65(container_id,mode,index,true);

	peg002_app_owner_update_d_shift_d64d65(container_id,mode,index);
}
function peg002_app_owner_update_d_shift_d64d65(container_id,mode,index){
	
	peg002_mask();
	var empty_idx=0;
	for (let i = 1; i <= 10 ; i++) {
		if( pegIsEmpty(pegGetVal(mode+'_p01_'+i,container_id)) ){
			empty_idx=i;
		}else{
			if(empty_idx>0   && empty_idx!=i){
				pegSetVal(mode+'_nr01_'+empty_idx,container_id,pegGetVal(mode+'_nr01_'+i,container_id));
				pegSetVal(mode+'_nr01_'+i,container_id,'');
				pegSetVal(mode+'_p01_'+empty_idx,container_id,pegGetVal(mode+'_p01_'+i,container_id));
				pegSetVal(mode+'_p01_'+i,container_id,'');
				if(mode=='d65'){
					pegSetVal(mode+'_p300_'+empty_idx,container_id,pegGetVal(mode+'_p300_'+i,container_id));
					pegSetVal(mode+'_p300_'+i,container_id,'');
				}
				peg002_app_owner_update_d_toggle_hidden_d64d65(container_id,mode,empty_idx,false);
				peg002_app_owner_update_d_toggle_hidden_d64d65(container_id,mode,i,true);
				empty_idx=i;
			}
		}
	}
	for (var i = 1; i <= 10 ; i++) {
		if(pegIsEmpty(pegGetVal(mode+'_p01_'+i,container_id)) ){
			peg002_app_owner_update_d_toggle_hidden_d64d65(container_id,mode,i,true);
		}

	}
	peg002_unmask();
}

function peg002_app_owner_update_d_toggle_hidden_d64d65(container_id,mode,index,value){
	pegSetFieldHidden(mode+'_p01_'+index,container_id,value);
	pegSetFieldHidden(mode+'_remove_btn_'+index,container_id,value);
	pegSetFieldHidden(mode+'_fldcont_'+index,container_id,value);

	if(mode=='d65'){
		pegSetFieldHidden(mode+'_p300_'+index,container_id,value);
	}
	if(index==10){
		pegSetFieldHidden(mode+'_add_btn',container_id,!value);
	}
}

function peg002_app_owner_update_d_add_d64d65_btn_handler(container_id,mode){

	for (var i = 1; i <= 10 ; i++) {
		if(pegIsEmpty(pegGetVal(mode+'_p01_'+i,container_id)) ){
			peg002_app_owner_update_d_toggle_hidden_d64d65(container_id,mode,i,false);
			break;
		}
	}
}
function peg002_app_owner_update_d_afterDraw_listeners(container_id){
	var back_button=pegGetCmp(container_id,'back_button');
	back_button.setPeg_handler(function(me){ 
		peg002_logout();
	});
	 
	for (let i = 1; i <= 10; i++) {
		pegGetCmp(container_id,'d64_remove_btn_'+i).setPeg_handler(function(){
			peg002_mask();
			peg002_app_owner_update_d_remove_d64d65(container_id,'d64',i);
			peg002_unmask();
		});

		pegGetCmp(container_id,'d65_remove_btn_'+i).setPeg_handler(function(){
			peg002_mask();
			peg002_app_owner_update_d_remove_d64d65(container_id,'d65',i);
			peg002_unmask();

		});
	}
	pegGetDic('peg_dic_peg002_app_owner_update_d_d64_label',function(desc){
		pegGetCmp(container_id,'d64_p01_1').setEmptyText(desc);

	});
	pegGetDic('peg_dic_peg002_app_owner_update_d_d65_label',function(desc){
		pegGetCmp(container_id,'d65_p01_1').setEmptyText(desc);

	});

	var submit_button=pegGetCmp(container_id,'submit_button');
	submit_button.setPeg_handler(function(){
		peg002_mask();
		var total_recs=0;
		for (let i = 1; i <= 10 ; i++) {
			if(!pegIsEmpty(pegGetVal('d64_p01_'+i,container_id))){
				total_recs++;
			}
		}
		if(total_recs==0){
			pegGetDic("peg_dic_peg002_owner_app_update_d64_empty",function(desc){
				peg002_unmask();		
				pegToast(desc,"alert");
			});
			
			return ;
		}

		
		total_recs=0;
		for (let i = 1; i <= 10 ; i++) { 
			if(!pegIsEmpty(pegGetVal('d65_p01_'+i,container_id))){
				total_recs++;
			}
		}
		if(total_recs==0){
			pegGetDic("peg_dic_peg002_owner_app_update_d65_empty",function(desc){
				peg002_unmask();
				pegToast(desc,"alert");
			});
			return ;
		} 
		var params={
			 "d00_00_p19"					:	peg002_get_screen_data(container_id,'d00_p19'),
			 "d00_00_p2"					:	peg002_get_screen_data(container_id,'d00_p2'),
			 "d00_00_p3"					:	peg002_get_screen_data(container_id,'d00_p3'),
			 "d00_00_p4"					:	peg002_get_screen_data(container_id,'d00_p4'),
			 "d00_00_d99102_terms"			:	(peg002_get_screen_data(container_id,'terms_check')?1:0)
		};
		// "d00_00_d99102_peg_referred_by":	(peg002_get_screen_data(container_id,'partner_check')?1:0)
		if(!pegGetCmp(container_id,'partner_check').hidden){
			params['d00_00_d99102_peg_referred_by']=peg002_get_screen_data(container_id,'partner_check')?1:0;
		}
		for (let i = 1; i <=10; i++) { 
			if(!pegGetCmp(container_id,'d64_p01_'+i).hidden){
				params['d00_00_d64_nr01_'+i]= peg002_get_screen_data(container_id,'d64_nr01_'+i);
		 
				if(!pegIsEmpty(peg002_get_screen_data(container_id,'d64_p01_'+i))){ 
					params['d00_00_d64_p001_'+i]= peg002_get_screen_data(container_id,'d64_p01_'+i);
				}
			}
				
			 
			if(!pegGetCmp(container_id,'d65_p01_'+i).hidden){
					params['d00_00_d65_nr01_'+i]= peg002_get_screen_data(container_id,'d65_nr01_'+i); 
				if(!pegIsEmpty(peg002_get_screen_data(container_id,'d65_p01_'+i))){ 
					params['d00_00_d65_p01_'+i]= peg002_get_screen_data(container_id,'d65_p01_'+i);
				}
				params['d00_00_d65_p300_'+i]=( peg002_get_screen_data(container_id,'d65_p300_'+i)?1:0);
			}
		} 
		pegAjax('/' + main_path + '/peg002_03/app_owner_update_data.php' , params , function(jsonData){
			peg002_unmask();
			if(!jsonData.ok){
				pegToast(jsonData.msg,'alert');
				return;
			}
			pegToast(jsonData.msg,'success');
            window.onbeforeunload = null;
			window.location.reload();
		} , 'json' , true);
	});

	var d64_add_btn=pegGetCmp(container_id,'d64_add_btn');
	d64_add_btn.setPeg_handler(function(){
		peg002_app_owner_update_d_add_d64d65_btn_handler(container_id,'d64');

	});
	var d65_add_btn=pegGetCmp(container_id,'d65_add_btn');
	d65_add_btn.setPeg_handler(function(){
		peg002_app_owner_update_d_add_d64d65_btn_handler(container_id,'d65');
	});
}

function peg002_peg002_keyboard_afterDraw_listeners(container_id){
	
	peg002_unmask();
	var screen=	pegGetCmp(container_id);
	screen.peg_lang=peg002_get_screen_data(container_id,'lang');
	peg002_keyboard_assign_handlers(container_id);
	peg002_keyboard_refresh_keys(container_id);  
	pegGetCmp(container_id,'input_field_textarea').on('change',function(field, newValue, oldValue){  
		pegSetVal('input_field',container_id,newValue);
	});
	pegGetCmp(container_id,'input_field_textfield').on('change',function(field, newValue, oldValue){  
		pegSetVal('input_field',container_id,newValue);
	});
} 
function peg002_keyboard_press_backspace(container_id){ 
if(peg002_get_screen_data(container_id,'isMobileOrTablet')){
	var text=pegGetVal('input_field',container_id);
	text=text.substr(0,text.length - 1 ); 
	pegSetVal('input_field',container_id,text); 
	return;
}
	var input_val=pegGetVal("input_field",container_id);
	var fld_name='input_field_textfield';
	if(peg002_get_screen_data(container_id,'xtype')=='pegasusTextArea'){
		fld_name='input_field_textarea';
	} 
	var cursorPosStart=pegGetCmp(container_id,fld_name).inputEl.dom.selectionStart;
	var cursorPosEnd=pegGetCmp(container_id,fld_name).inputEl.dom.selectionEnd;
	var cursorPos=cursorPosStart;	
	var newInp;
	if(cursorPosStart!=cursorPosEnd){
		newInp=input_val.slice(0,cursorPosStart)+input_val.slice(cursorPosEnd);
	}else{
		if(cursorPosStart>0){
			cursorPosStart--;
			cursorPos--;
		}
		newInp=input_val.slice(0,cursorPosStart)+input_val.slice(cursorPosEnd);
	}

	pegSetVal("input_field",container_id,newInp);
	
		
	pegSetVal(fld_name,container_id,newInp);
	pegGetCmp(container_id,fld_name).selectOnFocus=false; 
	try {
		pegGetCmp(container_id,fld_name).focus([cursorPos,cursorPos]); 
	} catch (error) {}
	pegGetCmp(container_id,fld_name).lastCursorPos=cursorPos;

}
function peg002_show_keyboard(me){
	peg002_mask();
	peg_windowShow_d('','peg002_keyboard','peg002',0,0,0,'','',
	{	'parent_container_id':me.getContainer_ID(),
		'parent_name':me.getName(),
		'input_field':pegGetVal(me.getName(),me.getContainer_ID()),
		'peg_screenTitle':me.getFieldLabel(),
		'xtype':me.xtype
	},true,true,false,0,'mobile');
} 
function peg002_show_numpad(me){ 
	peg_windowShow_d('','peg002_numpad','peg002',0,0,0,'','',
	{	'parent_container_id':me.getContainer_ID(),
		'parent_name':me.getName(),
		'input_field':pegGetVal(me.getName(),me.getContainer_ID()),
		'peg_screenTitle':me.getFieldLabel()
	},true,true,false,0,'mobile');
} 
function peg002_keyboard_get_mapping(container_id){
	var screen=	pegGetCmp(container_id);
	if( screen && typeof screen.mapping == "object"){
		return screen.mapping;
	} 
	screen.mapping ={
		"backquote"	:	{ "default":"`",	"shift":"~"	},
		"1"			:	{ "default":"1",	"shift":"!"  },
		"2"			:	{ "default":"2",	"shift":"@"	,"ctrl_alt":"²" },
		"3"			:	{ "default":"3",	"shift":"#" ,"ctrl_alt":"³" },
		"4"			:	{ "default":"4",	"shift":"$" ,"ctrl_alt":"£" },
		"5"			:	{ "default":"5",	"shift":"%" ,"ctrl_alt":"§" },
		"6"			:	{ "default":"6",	"shift":"^" ,"ctrl_alt":"¶"  },
		"7"			:	{ "default":"7",	"shift":"&"  },
		"8"			:	{ "default":"8",	"shift":"*" ,"ctrl_alt":"¤"  },
		"9"			:	{ "default":"9",	"shift":"(" ,"ctrl_alt":"¦" },
		"0"			:	{ "default":"0",	"shift":")" ,"ctrl_alt":"°" },
		"minus"		:	{ "default":"-",	"shift":"_" ,"ctrl_alt":"±" },
		"plus"		:	{ "default":"=",	"shift":"+" ,"ctrl_alt":"½" },
		"q"			:	{ "default_en":"q",	"default_el":";", "shift_en":"Q" ,"shift_el":":" },
		"w"			:	{ "default_en":"w",	"default_el":"ς", "shift_en":"W" ,"shift_el":"΅" },
		"e"			:	{ "default_en":"e",	"default_el":"ε", "shift_en":"E" ,"shift_el":"Ε" ,'ctrl_alt':"€" , "accent_el":"έ", "accent_shift_el":"Έ" },
		"r"			:	{ "default_en":"r",	"default_el":"ρ", "shift_en":"R" ,"shift_el":"Ρ" ,'ctrl_alt':"®" },
		"t"			:	{ "default_en":"t",	"default_el":"τ", "shift_en":"T" ,"shift_el":"Τ" },
		"y"			:	{ "default_en":"y",	"default_el":"υ", "shift_en":"Y" ,"shift_el":"Υ" ,'ctrl_alt':"¥", "accent_el":"ύ" , "accent_shift_el":"Ύ" , "umlaut_shift_el":"Ϋ","umlaut_el":"ϋ","accent_umlaut_el":"ΰ" },
		"u"			:	{ "default_en":"u",	"default_el":"θ", "shift_en":"U" ,"shift_el":"Θ" },
		"i"			:	{ "default_en":"i",	"default_el":"ι", "shift_en":"I" ,"shift_el":"Ι", "accent_el":"ί" , "accent_shift_el":"Ί" ,"umlaut_el":"ϊ", "umlaut_shift_el":"Ϊ" ,"accent_umlaut_el":"ΐ"  },
		"o"			:	{ "default_en":"o",	"default_el":"ο", "shift_en":"O" ,"shift_el":"Ο" , "accent_el":"ό", "accent_shift_el":"Ό" },
		"p"			:	{ "default_en":"p",	"default_el":"π", "shift_en":"P" ,"shift_el":"Π" },
		"bracket_left":	{ "default":"[", 	"shift":"{" ,	"ctrl_alt":"«"},
		"bracket_right":{ "default":"]", 	"shift":"}" ,	"ctrl_alt":"»"},
		"backslash" :	{ "default":"\\", 	"shift":"|" ,	"ctrl_alt":"¬"},
		"a"			:	{ "default_en":"a",	"default_el":"α", "shift_en":"A" ,"shift_el":"Α" , "accent_el":"ά", "accent_shift_el":"Ά" },  
		"s"			:	{ "default_en":"s",	"default_el":"σ", "shift_en":"S" ,"shift_el":"Σ" },  
		"d"			:	{ "default_en":"d",	"default_el":"δ", "shift_en":"D" ,"shift_el":"Δ" },  
		"f"			:	{ "default_en":"f",	"default_el":"φ", "shift_en":"F" ,"shift_el":"Φ" },  
		"g"			:	{ "default_en":"g",	"default_el":"γ", "shift_en":"G" ,"shift_el":"Γ" },   
		"h"			:	{ "default_en":"h",	"default_el":"η", "shift_en":"H" ,"shift_el":"Η", "accent_el":"ή" , "accent_shift_el":"Ή" },  
		"j"			:	{ "default_en":"j",	"default_el":"ξ", "shift_en":"J" ,"shift_el":"Ξ" },  
		"k"			:	{ "default_en":"k",	"default_el":"κ", "shift_en":"K" ,"shift_el":"Κ" },  
		"l"			:	{ "default_en":"l",	"default_el":"λ", "shift_en":"L" ,"shift_el":"Λ" }, 
		"semicolon"	:	{ "default_en":";",	"default_el":"΄", "shift_en":":" ,"shift_el":"¨",'ctrl_alt':'΅' , "dead_el":"accent"  , "dead_ctrl_alt_el":"accent_umlaut" , "dead_shift_el":"umlaut" }, 
		"quote"		:	{ "default_en":"'",	"default_el":"'", "shift":'"' }, 
		"z"			:	{ "default_en":"z",	"default_el":"ζ", "shift_en":"Z" ,"shift_el":"Ζ" },
		"x"			:	{ "default_en":"x",	"default_el":"χ", "shift_en":"X" ,"shift_el":"Χ" }, 
		"c"			:	{ "default_en":"c",	"default_el":"ψ", "shift_en":"C" ,"shift_el":"Ψ" ,'ctrl_alt':'©' }, 
		"v"			:	{ "default_en":"v",	"default_el":"ω", "shift_en":"V" ,"shift_el":"Ω" , "accent_el":"ώ", "accent_shift_el":"Ώ" }, 
		"b"			:	{ "default_en":"b",	"default_el":"β", "shift_en":"B" ,"shift_el":"Β" }, 
		"n"			:	{ "default_en":"n",	"default_el":"ν", "shift_en":"N" ,"shift_el":"Ν" }, 
		"m"			:	{ "default_en":"m",	"default_el":"μ", "shift_en":"M" ,"shift_el":"Μ" }, 
		"comma"		:	{ "default":",",	"shift":"<" }, 
		"dot"		:	{ "default":".",	"shift":">" }, 
		"slash"		:	{ "default":"/",	"shift":"?" },
		"space"		:	{ "default":" "},
		"shift"		:	{ "force":true,		"keep_pressed":true},
		"ctrl_alt"	:	{ "force":true,		"keep_pressed":true},
		"caps_lock"	:	{ "force":true,		"keep_pressed":true},
		"enter"		:	{ "default":"\n"}
	};
	return screen.mapping;
}
function peg002_keyboard_type_character(container_id,char){
	var input_val=pegGetVal("input_field",container_id);
	if(peg002_get_screen_data(container_id,'isMobileOrTablet')){ 
		pegSetVal("input_field",container_id,input_val+char);
		return;
	}
	var fld_name='input_field_textfield';
	if(peg002_get_screen_data(container_id,'xtype')=='pegasusTextArea'){
		fld_name='input_field_textarea';
	} 
	var cursorPosStart=pegGetCmp(container_id,fld_name).inputEl.dom.selectionStart;
	var cursorPosEnd=pegGetCmp(container_id,fld_name).inputEl.dom.selectionEnd;
	var cursorPos=cursorPosStart;
	// if(pegGetCmp(container_id,fld_name).lastCursorPos==null){
	// 	cursorPos=input_val.length;
	// }
	var newInp=input_val.slice(0,cursorPosStart)+char+input_val.slice(cursorPosEnd);

	pegSetVal("input_field",container_id,newInp);
	
	pegGetCmp(container_id,fld_name).inputEl.on('blur',function () { 
		var blurEl = this; 
		setTimeout(function() {
			try {
				blurEl.focus()
			} catch (error) {}
		}, 10);
	});

	pegSetVal(fld_name,container_id,newInp);
	pegGetCmp(container_id,fld_name).selectOnFocus=false;
	try {
		pegGetCmp(container_id,fld_name).focus([cursorPos+1,cursorPos+1]); 
	} catch (error) {}
	pegGetCmp(container_id,fld_name).lastCursorPos=cursorPos+1;
}
function peg002_keyboard_press_key(container_id,key){
	var screen=	pegGetCmp(container_id);
	var lang=screen.peg_lang;
	var mapping=peg002_keyboard_get_mapping(container_id);
	var new_char='';
	if(peg002_keyboard_is_dead_key(container_id,key) && !screen.peg_dead_char){  
		screen.peg_dead_char=peg002_keyboard_get_key_char(container_id,key);
		screen.peg_dead_key=mapping[key]['dead'+((peg002_keyboard_is_key_active(container_id,'ctrl_alt'))?"_ctrl_alt":"")+((peg002_keyboard_is_key_active(container_id,'shift'))?"_shift":"")+(lang?"_"+lang:"")];
		screen.peg_dead_lang=lang;
	}else{

		new_char=peg002_keyboard_get_key_char(container_id,key);
		if( screen.peg_dead_char){  
			new_char=screen.peg_dead_char+new_char;
			screen.peg_dead_key=false;
			screen.peg_dead_char=false;
			screen.peg_dead_lang=false;
		}
		if(new_char==""){
			return;
		}
		peg002_keyboard_type_character(container_id,new_char);
	}
	Object.entries(mapping).forEach(it=>{
		if(it[1]["keep_pressed"] && peg002_keyboard_is_key_active(container_id,it[0])){
			screen['peg_'+it[0]+'_pressed']=false;
			peg002_keyboard_remove_cls(container_id,it[0],'peg_keyboard_key_pressed');  
		} 
	});
	peg002_keyboard_refresh_keys(container_id);
	
}
function peg002_keyboard_refresh_keys(container_id){
 
	var screen=	pegGetCmp(container_id);
	var peg_dead_key_bef=screen.peg_dead_key;
	var peg_dead_char_bef=screen.peg_dead_char;
	var peg_dead_lang_bef=screen.peg_dead_lang;
	var mapping=peg002_keyboard_get_mapping(container_id);
	
	Object.entries(mapping).forEach(it=>{
		var key=it[0];
		var new_char=peg002_keyboard_get_key_char(container_id,key);
		if(pegGetCmp(container_id,'bt_'+key)){
			pegGetCmp(container_id,'bt_'+key ).setText(new_char|| " ");

		}
		var screen=	pegGetCmp(container_id);
		screen.peg_dead_key = peg_dead_key_bef;
		screen.peg_dead_char = peg_dead_char_bef;
		screen.peg_dead_lang =  peg_dead_lang_bef;
	});
}
function peg002_keyboard_active_dead_key(container_id,key=null){
	var screen=	pegGetCmp(container_id);
	var special_keys=['','_ctrl_alt','_shift'];
	var langs=['','_en','_el'];
	if(key!=null){ 
		for (let i = 0; i < special_keys.length; i++) {
			for (let j = 0; j < langs.length; j++) {
				var var_name='peg_dead_'+key+special_keys[i]+langs[j];
				if(!(!(screen[var_name]))){
					return var_name;
				}
			}
		}
	}
	for (const [key00, value] of Object.entries(peg002_keyboard_get_mapping(container_id))) {
		if(peg002_keyboard_is_dead_key(container_id,key00)){
			for (let i = 0; i < special_keys.length; i++) {
				for (let j = 0; j < langs.length; j++) {
					var var_name='peg_dead_'+key00+special_keys[i]+langs[j];
					if(!(!(screen[var_name]))){
						return var_name;
					}
				}
			}
		}
	}
	return false;
}
function peg002_keyboard_is_dead_key(container_id,key){
	var screen=	pegGetCmp(container_id);  
	var mapping=peg002_keyboard_get_mapping(container_id);
	var lang=screen.peg_lang;
	var ctrl_alt=peg002_keyboard_is_key_active(container_id,'ctrl_alt')?"ctrl_alt_":"";
	var shift=peg002_keyboard_is_key_active(container_id,'shift')?"shift_":"";  
	return !(!(mapping[key]['dead_'+(ctrl_alt||shift)+lang] || mapping[key]['dead']));
}
function peg002_keyboard_get_key_char(container_id,key){
	var screen=	pegGetCmp(container_id);
	var mapping=peg002_keyboard_get_mapping(container_id);
	var new_char=''; 

	if(peg002_keyboard_is_key_active(container_id,'ctrl_alt')){
		new_char=mapping[key]['ctrl_alt_'+screen.peg_lang] || mapping[key]['ctrl_alt'];
	}else if(peg002_keyboard_is_key_active(container_id,'shift')){
		new_char=mapping[key]['shift_'+screen.peg_lang] || mapping[key]['shift'];
	}else{
		new_char=mapping[key]['default_'+screen.peg_lang] || mapping[key]['default'];
	} 
	if( screen.peg_dead_char  && screen.peg_dead_lang==screen.peg_lang ){  
		var ctrl_alt_en=peg002_keyboard_is_key_active(container_id,'ctrl_alt')?"_ctrl_alt":"";
		var shift_en=peg002_keyboard_is_key_active(container_id,'shift')?"_shift":"";
		var lang_val=screen.peg_lang ?("_"+screen.peg_lang):"";
		if(mapping[key][screen.peg_dead_key+ctrl_alt_en+shift_en+lang_val]){
			new_char=mapping[key][screen.peg_dead_key+ctrl_alt_en+shift_en+lang_val];
			screen.peg_dead_char=false;
			screen.peg_dead_key=false;
			screen.peg_dead_lang=false;
		}
	}

	if(peg002_keyboard_is_key_active(container_id,'caps_lock') && new_char){
		if(new_char == new_char.toUpperCase()){
			new_char=new_char.toLowerCase();
		}else{
			new_char=new_char.toUpperCase();
		} 
	} 
	return new_char||'';
}

function peg002_keyboard_is_key_active(container_id,key){
	var screen=	pegGetCmp(container_id);
	return !(!(screen['peg_' + key + '_forced']||screen['peg_' + key + '_pressed']));
}
function peg002_keyboard_add_cls(container_id,key,cls){
	if(pegGetCmp(container_id,'bt_'+key)){
		pegGetCmp(container_id,'bt_'+key).addCls(cls);
	}
	if(pegGetCmp(container_id,'bt_'+key+'_right')){
		pegGetCmp(container_id,'bt_'+key+'_right').addCls(cls);
	}
	if(pegGetCmp(container_id,'bt_'+key+'_left')){
		pegGetCmp(container_id,'bt_'+key+'_left').addCls(cls);
	}
}
function peg002_keyboard_remove_cls(container_id,key,cls){
	if(pegGetCmp(container_id,'bt_'+key)){
		pegGetCmp(container_id,'bt_'+key).removeCls(cls);
	}
	if(pegGetCmp(container_id,'bt_'+key+'_right')){
		pegGetCmp(container_id,'bt_'+key+'_right').removeCls(cls);
	}
	if(pegGetCmp(container_id,'bt_'+key+'_left')){
		pegGetCmp(container_id,'bt_'+key+'_left').removeCls(cls);
	}
}

function peg002_keyboard_keep_pressed_key(container_id,key){
	var screen=	pegGetCmp(container_id);
	var mapping=peg002_keyboard_get_mapping(container_id);
	if(mapping[key]['keep_pressed']===true){
		screen['peg_' + key+'_pressed']=!(screen['peg_' + key+'_pressed']);
		if( screen['peg_' + key + '_forced'] ){ 
			screen['peg_' + key + '_pressed']=false;
			screen['peg_' + key + '_forced']=false;
			peg002_keyboard_remove_cls(container_id,key,'peg_keyboard_key_forced');
		}
		if(screen['peg_' + key+'_pressed'] ){
			peg002_keyboard_add_cls(container_id,key,'peg_keyboard_key_pressed');
		}else{
			peg002_keyboard_remove_cls(container_id,key,'peg_keyboard_key_pressed');
		}
	}
	peg002_keyboard_refresh_keys(container_id);
}

function peg002_keyboard_force_key(container_id,key){
	var screen=	pegGetCmp(container_id);
	var mapping=peg002_keyboard_get_mapping(container_id); 
	if(mapping[key]['force']===true){
		screen['peg_' + key+'_forced']=!(screen['peg_' + key+'_forced']);
		if( screen['peg_' + key + '_pressed'] ){ 
			screen['peg_' + key + '_pressed']=false;
			peg002_keyboard_remove_cls(container_id,key,'peg_keyboard_key_pressed');
		}
		if(screen['peg_' + key+'_forced'] ){
			peg002_keyboard_add_cls(container_id,key,'peg_keyboard_key_forced');
		}else{
			peg002_keyboard_remove_cls(container_id,key,'peg_keyboard_key_forced');
		}
	}
	peg002_keyboard_refresh_keys(container_id);
}

function peg002_keyboard_assign_handlers(container_id){
	var screen=	pegGetCmp(container_id);
	var mapping=peg002_keyboard_get_mapping(container_id);

	var _upd_runner = new Ext.util.TaskRunner();
	Object.entries(mapping).forEach(it=>{
		var key=it[0]; 	 
		var keyMap=it[1]; 	 
		var delay=400;
		var clicks=0;
		var timer=null;
		var btns_arr=[];

		if(pegGetCmp(container_id,'bt_'+key)){
			btns_arr.push(pegGetCmp(container_id,'bt_'+key));
		}
		if(pegGetCmp(container_id,'bt_'+key+'_right')){
			btns_arr.push(pegGetCmp(container_id,'bt_'+key+'_right'));	
		}
		if(pegGetCmp(container_id,'bt_'+key+'_left')){
			btns_arr.push(pegGetCmp(container_id,'bt_'+key+'_left'));
		}
		btns_arr.forEach(btn=>{
			btn.el.on('mousedown', function(event) {
				event.preventDefault();
			});
			if(keyMap['forced'] || keyMap['keep_pressed']){
				btn.on('click', function(me,e, t , eOpts){
					clicks++;  //count clicks
					if(clicks === 1) {
						timer = setTimeout(function() {
							peg002_keyboard_keep_pressed_key(container_id,key);
							clicks = 0;             //after action performed, reset counter
						}, delay);
					} else {
						clearTimeout(timer);    //prevent single-click action
						peg002_keyboard_force_key(container_id,key);
						clicks = 0;             //after action performed, reset counter
					}
				});	
			}
			
			if(keyMap['default'] || keyMap['default_en'] || keyMap['default_el']){
				btn.setPeg_handler(function(){
					peg002_keyboard_press_key(container_id,key);
					// pegGetCmp(container_id,'input_wrapper').getScrollable().scrollTo(Infinity, 0);
					
				});
				btn.peg_task = _upd_runner.newTask({
					run: function(){ 
						if(btn.hasCls('x-btn-pressed')){
							btn.peg_handler();
						}else{
							btn.peg_task.stop();
						}
					},
					interval: 50 	 
				});
				btn.el.on('longPress', function (longPress) {
					btn.peg_task.start();
					
				}, this); 
				btn.el.on('contextmenu', function(e, t , eOpts){									
					e.stopPropagation();
				});
			}
			
		})
	});
	var bt_backspace=pegGetCmp(container_id,'bt_backspace');
	bt_backspace.setPeg_handler(function(){
		peg002_keyboard_press_backspace(container_id);
	});
	bt_backspace.peg_task = _upd_runner.newTask({
		run: function(){
			if(bt_backspace. hasCls('x-btn-pressed')){
				bt_backspace.peg_handler();
			}else{
				bt_backspace.peg_task.stop();
			}
		},
		interval: 50 	 
	}); 
	bt_backspace.el.on('longPress', function (longPress) {
		bt_backspace.peg_task.start();
		
	}, this); 
	bt_backspace.el.on('contextmenu', function(e, t , eOpts){									
		e.stopPropagation();
	});	
	bt_backspace.el.on('mousedown', function(event) {
		event.preventDefault();
	});
	pegGetCmp(container_id,'bt_lang').setPeg_handler(function(){
		screen.peg_lang=(screen.peg_lang=='el')?'en':'el';
		peg002_keyboard_refresh_keys(container_id)
	});
	pegGetCmp(container_id,'bt_lang').el.on('mousedown', function(event) {
		event.preventDefault();
	});
	pegGetCmp(container_id,'bt_submit').setPeg_handler(function(){
		var text=pegGetVal('input_field',container_id); 
		pegGetCmp(peg002_get_screen_data(container_id,'parent_container_id'),peg002_get_screen_data(container_id,'parent_name')).focus();
		pegSetVal(peg002_get_screen_data(container_id,'parent_name'),peg002_get_screen_data(container_id,'parent_container_id'),text);
		peg002_keyboard_close(container_id); 
	});
	pegGetCmp(container_id,'bt_cancel').setPeg_handler(function(){
		peg002_keyboard_close(container_id); 
	});
	
	pegGetCmp(container_id,'bt_clear').setPeg_handler(function(){
		pegSetVal('input_field',container_id,''); 
	});
	
	pegGetCmp(container_id,'bt_clear').el.on('mousedown', function(event) {
		event.preventDefault();
	});
	pegGetCmp(container_id,'bt_clear_editable').setPeg_handler(function(){
		pegSetVal('input_field_textfield',container_id,''); 
		pegSetVal('input_field_textarea',container_id,''); 
	});

	pegGetCmp(container_id,'bt_clear_editable').el.on('mousedown', function(event) {
		event.preventDefault();
	});
	pegGetCmp(container_id,"input_field_textfield").inputEl.on('click',function(){
		if(pegGetCmp(container_id,"input_field_textfield").lastCursorPos==null){
			pegGetCmp(container_id,"input_field_textfield").lastCursorPos=pegGetVal("input_field_textfield",container_id).length;
		} 
   	}); 
	   pegGetCmp(container_id,"input_field_textarea").on('click',function(){
		   if(pegGetCmp(container_id,"input_field_textarea").lastCursorPos==null){
			   pegGetCmp(container_id,"input_field_textarea").lastCursorPos=pegGetVal("input_field_textarea",container_id).length;
		   } 
		   console.error(pegGetCmp(container_id,"input_field_textarea").lastCursorPos);
		  });
}

function peg002_numpad_press_backspace(container_id){ 
	var fld_name ='input_field';	
	var input_val=pegGetVal(fld_name,container_id);

	var cursorPosStart=pegGetCmp(container_id,fld_name).inputEl.dom.selectionStart;
	var cursorPosEnd=pegGetCmp(container_id,fld_name).inputEl.dom.selectionEnd;
	var newInp=input_val.slice(0,cursorPosStart).substr(0,input_val.slice(0,cursorPosStart).length - 1 )+input_val.slice(cursorPosEnd);

	// text=text.substr(0,text.length - 1 ); 
	pegSetVal(fld_name,container_id,newInp); 
	
	pegGetCmp(container_id,fld_name).selectOnFocus=false;
	try {
		pegGetCmp(container_id,fld_name).focus([cursorPosEnd-1,cursorPosEnd-1]); 
	} catch (error) {}

}
function peg002_peg002_numpad_type_character(container_id,char){
	var fld_name ='input_field';	
	var input_val=pegGetVal(fld_name,container_id);
	if(char==PEGASUS.GENERAL.NUMBER.decimalSeparator && input_val.indexOf(char)>=0){
		return;
	}
	var cursorPosStart=pegGetCmp(container_id,fld_name).inputEl.dom.selectionStart;
	var cursorPosEnd=pegGetCmp(container_id,fld_name).inputEl.dom.selectionEnd;
	var cursorPos=cursorPosStart; 
	var newInp=input_val.slice(0,cursorPosStart)+char+input_val.slice(cursorPosEnd);
	pegSetVal(fld_name,container_id,newInp);

	pegGetCmp(container_id,fld_name).selectOnFocus=false;
	try {
		pegGetCmp(container_id,fld_name).focus([cursorPos+1,cursorPos+1]); 
	} catch (error) {}
}
function peg002_peg002_numpad_afterDraw_listeners(container_id){
	var screen=	pegGetCmp(container_id); 
	var bt_backspace=pegGetCmp(container_id,'bt_backspace');
	pegGetCmp(container_id,'input_field').selectText();
	bt_backspace.setPeg_handler(function(){
		peg002_numpad_press_backspace(container_id);
	});
	var _upd_runner = new Ext.util.TaskRunner();

	bt_backspace.peg_task = _upd_runner.newTask({
		run: function(){
			if(bt_backspace. hasCls('x-btn-pressed')){
				bt_backspace.peg_handler();
			}else{
				bt_backspace.peg_task.stop();
			}
		},
		interval: 50 	 
	}); 
	bt_backspace.el.on('longPress', function (longPress) {
		bt_backspace.peg_task.start();
		
	}, this); 
	bt_backspace.el.on('contextmenu', function(e, t , eOpts){									
		e.stopPropagation();
	});	
	pegGetCmp(container_id,'input_field').on('change',function(){ 
		// pegGetCmp(container_id,'input_wrapper').getScrollable().scrollTo(Infinity, 0);

	});
	var keys=['0','1','2','3','4','5','6','7','8','9'];
	keys.forEach(k=>{
		pegGetCmp(container_id,'bt_'+k).setPeg_handler(function(){
			peg002_peg002_numpad_type_character(container_id,k);
		});
	});
	pegGetCmp(container_id,'bt_decimal').setPeg_handler(function(){
		peg002_peg002_numpad_type_character(container_id,PEGASUS.GENERAL.NUMBER.decimalSeparator);
	});
	pegGetCmp(container_id,'bt_submit').setPeg_handler(function(){
		var text=pegGetVal('input_field',container_id); 
		pegGetCmp(peg002_get_screen_data(container_id,'parent_container_id'),peg002_get_screen_data(container_id,'parent_name')).focus();
		pegSetVal(peg002_get_screen_data(container_id,'parent_name'),peg002_get_screen_data(container_id,'parent_container_id'),text);
		peg002_numpad_close(container_id); 
	});
	pegGetCmp(container_id,'bt_cancel').setPeg_handler(function(){
		peg002_numpad_close(container_id); 
	});
	pegGetCmp(container_id,'bt_clear').setPeg_handler(function(){
		pegSetVal('input_field',container_id,''); 
	});
	pegGetCmp(container_id,'bt_neg').setPeg_handler(function(){
		var fld_name ='input_field';	
		var text=pegGetVal('input_field',container_id);
		var sign=(text.trim().slice(0,1)==='-')?'':'-';
		text=sign+text.trim().replace('-','');
		var cursorPosStart=pegGetCmp(container_id,fld_name).inputEl.dom.selectionStart;
		var cursorPosEnd=pegGetCmp(container_id,fld_name).inputEl.dom.selectionEnd;
		var cursorPos=cursorPosStart; 
		pegSetVal('input_field',container_id,text); 

		if(sign=='-'){
			cursorPos++;
		}else{
			cursorPos--;
		}
		pegGetCmp(container_id,fld_name).selectOnFocus=false;
		try {
			pegGetCmp(container_id,fld_name).focus([cursorPos,cursorPos]); 
		} catch (error) {}
	});
}  

function peg002_keyboard_close(container_id) {
	var screen=	pegGetCmp(container_id); 
	if(!pegIsEmpty(screen.peg_tabid)){
		pegTabClose(screen.peg_tabid);
	}else{
		pegWindowClose(screen.peg_winid);
	}
}
function peg002_numpad_close(container_id) {
	var screen=	pegGetCmp(container_id); 
	if(!pegIsEmpty(screen.peg_tabid)){
		pegTabClose(screen.peg_tabid);
	}else{
		pegWindowClose(screen.peg_winid);
	}
}
function peg002_formatBytes(bytes,decimals=2){
	if (!+bytes) return '0 Bytes';

	const k = 1024;
	const dm = decimals < 0 ? 0 : decimals;
	const sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];

	const i = Math.floor(Math.log(bytes) / Math.log(k));

	return `${parseFloat((bytes / Math.pow(k, i)).toFixed(dm))} ${sizes[i]}`;
}
 