<?php  


require_once '../peg002_classes/mysql/Peg002_MySQL.php';

/**
 * - alias
 * - General functions 
 * - Start Structure Functions 
 * - Start Service functions
 * - Start Screen Function 
 * - Caching Function
 * 
 */

//XXX alias
/**
 * @alias for peg002_cleanProfileCache 
 */
function peg002_clean_profileCache($p95 = 0){  
    return peg002_cleanProfileCache($p95); 
}
//XXX Start General functions 
function peg002_after_update(){
    require_once '../peg002_00/afterupdate.php';
}


/**
 * Check if running under peg002App
 * @return Bool
 */
function peg002_isPeg002App(){
    if(isset($GLOBALS['userCookie'])){
        return true;
    }else{
        return false;
    }
}

function peg002_createMenu($p95, $lang){
    
    $profnr01 = Peg002_MySQL::pegasus_printfld('p95', 'nr01', 'nr01 = :nr01' , array('nr01' =>$p95 ));
    if(empty($profnr01)){
        return false;
    }
    if(!in_array($lang, array('GR', 'EN'))){
        return false;
    }
   
    $treeMap = array();
    $directMap= array();
    $data = array();
    $query = peg_read_file('../peg002_sql/store/menu/p80.sql');
    $query = str_replace(array('##LANG##' ), array($lang ), $query);
    $res = Peg002_MySQL::pegasus_query($query, array('user_profile' => $profnr01));
     
    $pegasus_lock_check_app = pegasus_lock_check_app();

    
    while ($p80 = pegasus_fetch_assoc($res)) {


        if(!pegasus_module_exists( $p80['module'])){
            continue;
        }

        //TODO Add mao array
        $pcode = $p80['pcd'];

        if($pegasus_lock_check_app==3){
            if(
                $p80['cd']!='core9900' and
                $p80['cd']!='core9913' and
                $p80['cd']!='core9901' and
                $p80['cd']!='core9902' and
                $p80['cd']!='core9907' and
                $p80['cd']!='core9912'
                ){
                    continue;
            }
        }

        $row = array(
            'pcd' => $p80['pcd'],
            'cd' => $p80['cd'],
            'act' => $p80['act'],
            'expanded' => false,
            'leaf' => true,
            'text' => str_replace( '<!--#-->' , '' ,$p80['text']),
            'title' => $p80['title'],
            'etitle' => $p80['etitle'],
            'tax' => (int) $p80['tax'],
            'iconCls' => $p80['iconcls'],
            'icon' => $p80['icon'],
            'enable_quick_find' => $p80['full_text_search'],
            'browse_copy' => $p80['copy_recs'] ,
            'browse_edit' => $p80['browse_edit'],
            'view_d' => $p80['view_d'],
            'view_module' => $p80['view_module'],
            'view_table' => $p80['view_table'],
            'view_orderby' => $p80['view_orderby'],
            'view_groupby' => $p80['view_groupby'],
            'peg_handler' => '',
            'urlparams' => '',
        );
        $peg_handler='';
        if(pegasus_lock_check_app()==1){
            $peg_handler .= "pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "');";
        }
        $urlparams='';
        
        if($p80['act']=='browse'){
            if(!empty($p80['view_table'])){
                if(!pegasus_profile_check_data_permission($p80['view_table'] , 'SHOW' ,$profnr01)){
                    continue;
                }
            }
            if(!empty($p80['urlparams'])){
                $urlparams = eval($p80['urlparams']) ;
                if ( $urlparams === false && ($error = error_get_last()) ) {
                    if(pegasus_displayErrors()){
                        print_r($p80);
                        var_dump($error);
                    }
                    
                    die('Error in eval');
                } 
            }
           
        }elseif ($p80['act']=='show_d'){
            if(!empty($p80['view_table'])){
                if(!pegasus_profile_check_data_permission($p80['view_table'] , 'SHOW' ,$profnr01)){
                    continue;
                }
            }
            
            if(!empty($p80['urlparams'])){
                $urlparams = eval($p80['urlparams']) ;
                if ( $urlparams === false && ($error = error_get_last()) ) {
                    if(pegasus_displayErrors()){
                        print_r($p80);
                        var_dump($error);
                    }
                    
                    die('Error in eval');
                }
            }
        }elseif ($p80['act']=='meth'){
            $con_id = 'p80_3_' . $p80['nr01'];
            $tmp = " pegAddTab('' , '" . $p80['title'] . "'  ,  ''  , true , '" . eval($p80['meth']) . "'  , '" .$con_id. "' ); ";
            $peg_handler .= $tmp;
        }elseif ($p80['act']=='handler'){
            
            
            if(!empty($p80['handler_js'])){
               $tmp =  @eval($p80['handler_js'] );
               if ( $tmp  === false && ($error = error_get_last()) ) {
                    if(pegasus_displayErrors()){
                        print_r($p80);
                        var_dump($error);
                    }
                    die('Error in eval');
                }
                $peg_handler .= $tmp;
            }else if( !empty($p80['handler']) ){
                $tmp =  @eval($p80['handler'] );
                if ($tmp === false && ($error = error_get_last()) ) {
                    if(pegasus_displayErrors()){
                        print_r($p80);
                        var_dump($error);
                    }
                    die('Error in eval');
                }
                $peg_handler .= $tmp;
            }
        } 
         
        $row['peg_handler'] = $peg_handler;
        $row['urlparams'] = $urlparams;
        
        if(strpos($pcode, '#')!==false){
            $pcodeAr = explode('#', $pcode);
            foreach ($pcodeAr as $value){
                if(!empty($value)){
                    peg002_createStoreMenustoreAddRec($treeMap,$directMap ,$data, $value,$row  );
                }
                
            }
            
        }else {
            peg002_createStoreMenustoreAddRec($treeMap, $directMap ,$data, $pcode,$row  );
        }
        
    }
 
    return $data;
   

}

function peg002_createStoreMenustoreAddRec(&$map, &$directMap ,&$data, $code,$row  ){
    $pointerToMap = &$map;
    $pointerToData = &$data;
    if(!empty($code)){
        if(is_array($directMap[$code])){
            $pointerToMap = &$directMap[$code];
            $pointerToData = &$directMap[$code]['pointerToData'];
        }else{
            $pathArray = explode('.', $code);
            
            
            
            foreach ($pathArray as $path){
                if(empty($path)){
                    continue;
                }
                if(isset($pointerToMap[$path])){
                    $pointerToMap = &$pointerToMap[$path];
                    $pointerToData = &$pointerToMap['pointerToData'];
                }else{
                    return ;
                }
            }
        }
        
               
        for ($i = 0; $i < count($pointerToData); $i++) {
            $rec = &$pointerToData[$i];
            if(isset($rec) &&  $rec['cd']==$code ){
                if($rec['leaf'] === true){
                    $rec['leaf'] = false;
                    $rec['expanded'] = false;
                    if(empty($rec['pcd'])){
                        $rec['expanded'] = true;
                    }
                    if(!isset($rec['data'])){
                        $rec['data'] = array();
                    }
                }
                $pointerToData = &$rec['data'];
                break;  
            }
        }
    }
    $row['leaf'] = true;
    $row['pcd'] = $code;
    $pointerToData[] = $row;
    $path = str_replace($path.'.', '', $row['cd']);
    if(strripos($path, '.')>0){
        $path = substr($path, strripos($path, '.'));
    }
    $directMap[$row['cd']] = array('pointerToData' => &$pointerToData); 
    $pointerToMap[$path] = array('pointerToData' => &$pointerToData); 
     
}
function peg002_treeStoreGetLeaf($data, $childerntag = 'data'){
   
    $retAr = array();
    $ttt = array_keys($data);
    for ($i = 0; $i < count($data); $i++) {
        $row = ($data[$ttt[$i]]);  
        
         
        if(is_array($row[$childerntag])){
            $tmpAr00 = peg002_treeStoreGetLeaf($data[$ttt[$i]][$childerntag], $childerntag );
            foreach ($tmpAr00 as $value) {
                if(empty($value['pcd_text'])){
                    $value['pcd_text'] = $data[$ttt[$i]]['text'];
                }
                $retAr[] = $value;
            } 
        }else{
            $retAr[] = $row;
        }
        
    } 

    return $retAr;
}

function peg002_tree_help($pcd='' , $arr=array()){
    $query = "  SELECT p80.* 
                FROM p80 
                JOIN p55 ON p55.p00 = p80.module AND p55.en=1
                JOIN p95p55 ON p80.module=p95p55.module AND p95p55.en=1 AND p95p55.p95=:user_profile_00
                JOIN p95p80 ON p95p80.p80=p80.nr01 AND p95p80.p300=1 AND p95p80.p95=:user_profile_01 
                WHERE ( p80.pcd=:pcd OR p80.pcd LIKE :pcd_like ) AND p80.type IN (1,3) 
                ORDER BY p80.tax , p80.title;";
    $queryParams=array(
        'user_profile_00'=>$_SESSION['user_profile'],
        'user_profile_01'=>$_SESSION['user_profile'],
        'pcd' => $pcd, 
        'pcd_like' => '%#'.$pcd.'#%'
    );
    // echo pegasus_replace_values_in_sql($query, $queryParams);//die();
    $ret = pegasus_query($query, $queryParams);
    while ($p80 = pegasus_fetch_assoc($ret)){
        if($p80['cd']=='query0002'){
            $arr00 =  peg002_tree_query0002_help();
        }else{
            $arr00 =  peg002_tree_help($p80['cd'] , array());
        }
        if(!empty($arr00)){
            array_push($arr , array( 'text' => '<u>' . $p80['title'] . '</u>'  , 'view_d'=> $p80['view_d'] , 'view_module'=> $p80['view_module'] , 'expanded' =>  false,  'data' => $arr00 ) );
        }else{
            if( $p80['cd'] =='retail00.retail00'){
                $p80['view_d'] ='retail00_01_d';
            }
            array_push($arr , array( 'text' => '<u>' . $p80['title'] . '</u>'  , 'view_d'=> $p80['view_d'] , 'view_module'=> $p80['view_module'] ,  'leaf' => true ) );
        }
    }
    return $arr;
}
function peg002_tree_query0002_help(){
	$query = " 	SELECT  q10.nr01 AS q10_nr01, 
						IF(:lang00='GR',q08.p01,q08.ep01)  AS q08,
						IF(:lang01='GR',q09.p01,q09.ep01)  AS q09,	
						IF(:lang02='GR',q10.p01,q10.ep01)  AS p01 ,
						q08.nr01 AS q08_nr01,
						q09.nr01 AS q09_nr01
				FROM q10 
                JOIN p55 ON p55.p00 = q10.p55 AND p55.en=1
                JOIN p95p55 ON q10.p55=p95p55.module AND p95p55.en=1 AND p95p55.p95=:user_profile 
				LEFT JOIN q08 ON q08.nr01=q10.q08    
				LEFT JOIN q09 ON q09.nr01=q10.p04      
				GROUP BY q10.nr01 
				ORDER BY q08,p04  ";
		$queryParams=array(
            'lang00'=>$_SESSION['lang'],
            'lang01'=>$_SESSION['lang'],
            'lang02'=>$_SESSION['lang'],
            'user_profile'=>$_SESSION['user_profile']
        );
        // echo pegasus_replace_values_in_sql($query, $queryParams);//die();
		$ret = pegasus_query($query, $queryParams);
		$categories=array();
		$subcategories=array();
		$panaf=array();
		while ($row = pegasus_fetch_assoc($ret)){
			if(!isset($categories[$row['q08_nr01']])){
				$categories[$row['q08_nr01']]=array( 'text' => '<u>' . $row['q08'] . '</u>'  , 'view_d'=> '', 'view_module'=> '' , 'expanded' =>  false );
				$subcategories[$row['q08_nr01']]=array();
			}
			if(!isset($subcategories[$row['q08_nr01']][$row['q09_nr01']])){
				$subcategories[$row['q08_nr01']][$row['q09_nr01']]=array( 'text' => '<u>' . $row['q09'] . '</u>'  , 'view_d'=> '', 'view_module'=> '' , 'expanded' =>  false );
			}
			if(!is_array($subcategories[$row['q08_nr01']][$row['q09_nr01']]['data'])){
				$subcategories[$row['q08_nr01']][$row['q09_nr01']]['data']=array();
			}
			array_push($subcategories[$row['q08_nr01']][$row['q09_nr01']]['data'],array( 'text' => '<u>' . $row['p01'] . '</u>'  ,'view_d'=> "q10_d90_".$row['q10_nr01']."_d" , 'view_module'=> 'query',  'leaf' => true ));
		}
		foreach ($categories as $key => $value) {
			$categories[$key]['data']=array();
			foreach($subcategories[$key] as $key01 =>$value01){
				array_push($categories[$key]['data'],$value01); 
			}
			array_push($panaf,$categories[$key]);
        }
        return $panaf;
}

/**
 * Print def header for peg002
 * @deprecated
 */
function peg002_optionHeader(){
    return ;
    header("Access-Control-Allow-Origin: *");
    header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept');
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS'); 
    return ;
}

if(file_exists('../peg002_functions/filemanager.php')){
    require_once '../peg002_functions/filemanager.php'; 
}
//XXX End General functions 
//XXX Start Structure Functions
/**
 * Validate Properties
 * TODO: Add all structure properties
 */
function peg002_validateProperty($par_nm,$par_val){ 
    
    if($par_nm == 'flex'|| $par_nm == 'flex_mobile' || $par_nm == 'flex_tablet' || $par_nm == 'hidden'){
        return intval($par_val);

    }elseif ($par_nm == 'step' ){
        return (int)$par_val;

    }elseif ($par_nm == 'hidden_cd' || $par_nm == 'hidden_var'){
        return (!empty($par_val) && $par_val!='0')?true:false ;

    }elseif ($par_nm == 'width' || $par_nm == 'height' || $par_nm == 'labelWidth'){
        if(strpos($par_val, 'px')===false){
            return (int)$par_val;
        } 
        return trim($par_val);

    }elseif ($par_nm == 'hideLabel' || $par_nm == 'disablePages' ||  $par_nm ==  'fldtitleasplaceholder'){
        return !!($par_val);

    }else if( $par_nm == 'preventHeader'){
        //die(var_dump($par_val ));
        return $par_val;

    }elseif (is_string($par_val)){
        return trim($par_val);
    }
    
    return $par_val;
}
/**
 * Validate An Element
 * @param enum {
 * accordion,actioncolumn,button,cartesianchart,checkbox,
 * codemirror,colorpicker,combobox,contentpanel,dashboard,
 * dataview,dataviewmenu,datebox,editorExtJs,fieldcontainer,fieldSet,
 * filemanager,fileUpload,grid,gridproperty,menu,menuBar,multi_selectbox,
 * numberbox,panel,polarchart,progressbar,radio,scheduler,
 * screen,selectbox,tab,text,textarea,textbox,timefield,tinymce,toolbar,treepanel
 * } $elementType
 * @param array  $data //p52 data of element 
 * @param array global_array // Array that will be returned
 * 
 * @return array(
 *      fieldTitle => ''
 *      name => ''
 *      peg_module => ''
 *      peg__d => ''
 *      size => ''
 *      decimal => ''
 *      [p52*] => ''
 * )
 */ 
function peg002_validateElement($elementType, &$data, $global_array = array()){
    $tmpar = $data['0'];
    $tmpar['par_nm'] = 'elementType';
    $tmpar['par_val'] = $elementType;
    $tmpar['code'] = 0;
   
    array_unshift($data, $tmpar );
    

    if($elementType == 'grid'){ 
        $gridValues = array();
        $dockItemsPos = -1;
        foreach ($data as $pos => $row){ 
            $gridValues[$row['par_nm']] =  $row['par_val'];
            if($row['par_nm']=='dockedItems'){
                $dockItemsPos = $pos;
            }
        } 
        $data[] =array('par_nm'=>'record_screen_title','par_val'=>peg002_screenTitle($gridValues['module'],$gridValues['_d'])); 
        $data[] =array('par_nm'=>'record_isTitle_flds','par_val'=>peg002_isTitle_fields($gridValues['module'],$gridValues['_d']));

        $gridValues['name']=$data['0']['desc05'];
        if(!isset($gridValues['columns'])){
            if(isset($gridValues['title_array'])){
                 
                $data[] = array(
                    'par_nm' => 'columns' ,
                    'par_val' => $gridValues['title_array'],
                    'module' => $data['0']['module'],
                    'desc07' => $data['0']['desc07'],
                    'desc05' => $data['0']['desc05'],
                    'desc02' => '',
                    'code' => 0
                ) ;
                
            }else {
                $columns = Peg002_Grid::makeColumns($gridValues,$global_array['isMobile']);
                // print_r($columns );
                // die();
                if(count($columns)>0){
                    $data[] = array(
                        'par_nm' => 'columns' ,
                        'par_val' => $columns,
                        'module' => $data['0']['module'],
                        'desc07' => $data['0']['desc07'],
                        'desc05' => $data['0']['desc05'],
                        'desc02' => '',
                        'code' => 0
                    ) ;
                }
            }
        }

        if(!isset($gridValues['fields'])){
            if(isset($gridValues['grid_fields'])){
                $data[] = array(
                    'par_nm' => 'fields' ,
                    'par_val' => $gridValues['grid_fields'],
                    'module' => $data['0']['module'],
                    'desc07' => $data['0']['desc07'],
                    'desc05' => $data['0']['desc05'],
                    'desc02' => '',
                    'code' => 0
                ) ;
            }else{
                $fields = Peg002_Grid::makeFields($gridValues,$global_array['isMobile']);
                //             print_r($fields);
                if(count($fields)>0){
                    $data[] = array(
                        'par_nm' => 'fields' ,
                        'par_val' => $fields,
                        'module' => $data['0']['module'],
                        'desc07' => $data['0']['desc07'],
                        'desc05' => $data['0']['desc05'],
                        'desc02' => '',
                        'code' => 0
                    ) ;
                }
            }
        } 
        /* Do not return dockedItems for comboboxV2 grid */
        if($_REQUEST['display_type'] !=='_comboboxV2_grid' ){
            $dockedItems = Peg002_Grid::makeDockedItems($gridValues); 
            if(!isset($gridValues['dockedItems']) ){
            
                
                
                $data[] = array(
                    'par_nm' => 'dockedItems' ,
                    'par_val' => $dockedItems,
                    'module' => $data['0']['module'],
                    'desc07' => $data['0']['desc07'],
                    'desc05' => $data['0']['desc05'],
                    'desc02' => '',
                    'code' => 0
                ) ;  
            }elseif ( !empty($gridValues['dockedItems'] )){ 
            
                if(is_array($gridValues['dockedItems'])){
                    
                    
                    $data[$dockItemsPos]['par_val'] =  array_merge(  $gridValues['dockedItems'] ,$dockedItems); 
                    

                }else {
                    $data[$dockItemsPos]['par_val'] = $dockedItems;
                }
            }
        }
        if($_REQUEST['service_only'] ==  1){ //Υπηρεσίες (inventory01)
            $data[] = array(
                'par_nm' => 'url_vars00' ,
                'par_val' =>  '&service_only=' . $_REQUEST['service_only'],
                'module' => $data['0']['module'],
                'desc07' => $data['0']['desc07'],
                'desc05' => $data['0']['desc05'],
                'desc02' => '',
                'code' => 0
            ) ; 
        }
        if($_REQUEST['t10_p0102_cont']>0){
            $data[] = array(
                'par_nm' => 'url_vars00' ,
                'par_val' =>  '&t10_p0102_cont=' . $_REQUEST['t10_p0102_cont'],
                'module' => $data['0']['module'],
                'desc07' => $data['0']['desc07'],
                'desc05' => $data['0']['desc05'],
                'desc02' => '',
                'code' => 0
            ) ; 
        }
    }elseif ($elementType == 'combobox'){
        $gridValues = array();
        foreach ($data as $row){
            $gridValues[$row['par_nm']] =  $row['par_val'];
        }
        if(!empty($gridValues['table'])){
            $data[] = array(
                'par_nm' => 'peg_view_table' ,
                'par_val' => $gridValues['table'],
                'module' => $data['0']['module'],
                'desc07' => $data['0']['desc07'],
                'desc05' => $data['0']['desc05'],
                'desc02' => '',
                'code' => 0
            ) ;
        }
        
        if(!empty($gridValues['module'])){
            $data[] = array(
                'par_nm' => 'peg_view_module' ,
                'par_val' => $gridValues['module'],
                'module' => $data['0']['module'],
                'desc07' => $data['0']['desc07'],
                'desc05' => $data['0']['desc05'],
                'desc02' => '',
                'code' => 0
            ) ;
        }
    }elseif ($elementType == 'selectbox' || $elementType == 'comboboxV2' ){
        $gridValues = array();
        foreach ($data as $row){
            $gridValues[$row['par_nm']] =  $row['par_val'];
        }
        
        if(isset($gridValues['request_params']) && !empty($gridValues['request_params'])){
            $request_params_arr = array();
            $dias_array_request_params = explode( ',' , $gridValues['request_params']);
            foreach ($dias_array_request_params as $dias_array_request_params_d){
                if(!empty($dias_array_request_params_d)){
                    $dias_array_request_params_d_00 = explode( '.' , $dias_array_request_params_d);
                    if(empty($dias_array_request_params_d_00[1])){
                        array_push($request_params_arr , array( '_d' => $dias_array_request_params_d ));
                    }else{
                        array_push($request_params_arr , array( '_d' => $dias_array_request_params_d_00[1] , 'm_d' => $dias_array_request_params_d_00[0]  ));
                        
                    }
                    
                }
            }
            if( count($request_params_arr)>0 ){
                $data[] = array(
                    'par_nm' => 'request_params_d' ,
                    'par_val' => $request_params_arr,
                    'module' => $data['0']['module'],
                    'desc07' => $data['0']['desc07'],
                    'desc05' => $data['0']['desc05'],
                    'desc02' => '',
                    'code' => 0
                ) ;
            }
        }
    }elseif ($elementType == 'screen'){ 
        if( isset($_REQUEST['inWindow'])  ){ 
            $inWindow = $_REQUEST['inWindow'] ;
            
            $dockedItems = peg002_make_toolbars_arr(
                '',
                $data['0']['module'],
                $data['0']['p02'],
                '',
                0,
                '',
                '',
                0,
                $inWindow
                ); 
            //         $container_id, $module, $_d,$table,$nr01,$mnr01, $mmnr01 , $readOnly, $inWindow
            $data[] = array(
                'par_nm' => 'dockedItems' ,
                'par_val' => $dockedItems,
                'module' => $data['0']['module'],
                'desc07' => $data['0']['desc07'],
                'desc05' => $data['0']['desc05'],
                'desc02' => '',
                'code' => 0
            ) ;  
            $rightClickMenu = peg002_make_rightclick_arr("",0,$data['0']['p02']); 
            $data[] = array(
                'par_nm' => 'peg_rightClickMenu' ,
                'par_val' => $rightClickMenu,
                'module' => $data['0']['module'],
                'desc07' => $data['0']['desc07'],
                'desc05' => $data['0']['desc05'],
                'desc02' => '',
                'code' => 0  
            ) ; 
        }
    }
    
    $retData = array(
        'fieldTitle' => $tmpar['desc02'],  
        'name'      => $tmpar['desc05'], 
        'peg_module' => $tmpar['module'],
        'peg__d'    => $tmpar['p02'],
        'isdbfld'    => $tmpar['isdbfld']
    );
    if($tmpar['desc17']>0 && $tmpar['desc16']!='M'){
        $retData['size'] = intval($tmpar['desc17']);
    }
    if($tmpar['desc18']>0){
        $retData['decimal'] = intval($tmpar['desc18']); 
    }
    if(!empty($tmpar['desc16'])){
        $retData['db_type']=$tmpar['desc16'];
        
    }
    foreach ($data as $row){
        if($row['code'] == 0 && !empty($row['par_nm'])){
            $retData[$row['par_nm']] = peg002_validateProperty($row['par_nm'], $row['par_val']) ; 
            if($row['par_nm'] === 'hidden' && $retData[$row['par_nm']] == 2){
                $retData[$row['par_nm']] = 0;
            }
        }
    } 
    if(!empty($_REQUEST['field'])){
        $retData['peg_field']=$_REQUEST['field'];
    }

    if(!empty($_REQUEST['peg_parent_grid_name'])){
        $retData['peg_parent_grid_name']=$_REQUEST['peg_parent_grid_name'];
    }
    /*  grid name is set in constructor for comboboxV2 grid 
        We removed it from stucture so that it doesn't get cached */
    if($_REQUEST['display_type'] =='_comboboxV2_grid' ){
        unset($retData['name']);
    }
    return $retData;
}

/**
 * Return an array with toolbars items 
 * @see @old screen->make_toolbars_arr
 */
function peg002_make_toolbars_arr($container_id, $module, $_d,$table,$nr01,$mnr01, $mmnr01 , $readOnly, $inWindow){
    $printToolBarMenu = false;
    $menu = '';  

    $query = peg_read_file('../peg002_sql/screen/toolbars.sql'); 
    
    if(empty($table) && !empty($_d)){
        $table = Peg002_MySQL::pegasus_printfld('p50', 'p01', ' p02=:p02 ', array('p02'=>$_d));
    }
   
    $res =  Peg002_MySQL::pegasus_query(
        $query, 
        array(
            '_d' => $_d, 
            'module' =>  $module,
            'user_profile' => $_SESSION['user_profile']
        )
    );
    
    $save_item_count=0;
    $menu = array();
    $pegasusToolBarAr = array();
    $pos = ''; 
    while ($p81 = pegasus_fetch_assoc($res)){

        
        if($GLOBALS['userCookie']->getLang()=='EN' and !empty($p81['etitle']) ){
            $p81['title'] = $p81['etitle'];
        }
        if(!$printToolBarMenu && $p81['toolBarMenu'] == 1){ 
            $printToolBarMenu = true;
        }
        
        if($pos != $p81['pos']){
            
            $pos = $p81['pos'];
            $pegasusToolBarAr[$pos] = array(
                'xtype' => 'pegasusToolBar',
                'dock'=> $pos,
                'items' => array()
            );
        }
        
        $toolbar_item = array(
            'xtype' => 'pegasusToolBarButton',
            'p81_id' => $p81['nr01'],
            'p81_nr01' => $p81['nr01'],
            'p81_type' => $p81['type']

        );
        
        if($p81['type'] == 'button' || $p81['type'] == 'button_only_icon'){
            $_handler = $p81['handler_js']  ;
             
            
            if( $p81['type'] == 'button_only_icon'){
                $p81['icon_only'] = 1;
            }
            // $_handler.=" console.warn('p81nr01 ".$p81['nr01']."'  ); ";
            if(pegasus_lock_check_app()==1){
                $_handler = "pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "');" . $_handler ;
            }
             
            
            $toolbar_item =  array_merge($toolbar_item, array(
                'text' => $p81['title'],
                'peg_handler' =>  $_handler ,
                'iconCls' => $p81['iconcls'],
                'icon_only' => $p81['icon_only']
            ));
            if(!empty($p81['icon'])){
                $toolbar_item['icon'] =  $p81['icon'] ;
            }
            
            
            $pegasusToolBarAr[$pos]['items'][] = $toolbar_item;
            
            $toolbar_item['xtype'] = 'pegasusToolBarMenuItem' ;
            $menu[] = $toolbar_item;
        }elseif($p81['type'] == 'text'){
            $toolbar_item =  array_merge($toolbar_item, array(
                'text' => $p81['title'],
                'border' => 0,
                'style' => array('backgroundColor' => '')
            ));
            $pegasusToolBarAr[$pos]['items'][] = $toolbar_item;
            $toolbar_item['xtype'] = 'pegasusToolBarMenuItem' ;
            $menu[] = $toolbar_item;
        }elseif($p81['type'] == 'tbfill'){
            $toolbar_item = array(
                'xtype' => 'pegasusToolBartbfill'
            );
            $pegasusToolBarAr[$pos]['items'][] = $toolbar_item;
        }elseif($p81['type'] == 'tbseparator'){
            $toolbar_item = array(
                'xtype' => 'pegasusToolBartbseparator'
            );
            $pegasusToolBarAr[$pos]['items'][] = $toolbar_item;
        }elseif($p81['type'] == 'tbspacer'){
            $toolbar_item = array(
                'xtype' => 'pegasusToolBartbspacer'
            );
            $pegasusToolBarAr[$pos]['items'][] = $toolbar_item;
        }elseif($p81['type'] == 'other'){
            $_handler =@eval( $p81['handler_js']);
            
            if ( $_handler === false && ($error = error_get_last()) ) {
                if(pegasus_displayErrors()){
                    print_r($p81);
                    var_dump($error);
                } 
                
                die('Error in eval');
            } 
           
            /*  $toolbar_item = array(
             'xtype' => 'pegasusToolBartbspacer'
             ); */
            foreach ($_handler as $item){
                $pegasusToolBarAr[$pos]['items'][] =$item;
            }
            
        }elseif($p81['type'] == 'help_d'){
            $toolbar_item =  array_merge($toolbar_item, array(
                'xtype' => 'pegasusToolBarHelp',
                'text' =>  $p81['title'] , 
                'iconCls'=> $p81['iconcls'],
                'icon_only' => $p81['icon_only']
            ));
            
            if(pegasus_lock_check_app()==1){
                $toolbar_item['extrahandler'] =  "pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "');";
            }
            if(!empty( $p81['icon']))	{
                $toolbar_item['icon'] = $p81['icon'];
            }
            $pegasusToolBarAr[$pos]['items'][] = $toolbar_item ;
            $toolbar_item['xtype'] = 'pegasusToolBarMenuItem' ;
            $menu[] = $toolbar_item;
        }elseif($p81['type'] == 'z21_d_preview'){
            
           
            
            $toolbar_item =  array_merge($toolbar_item, array(
                'xtype' => 'pegasusToolBarZ21', 
                'iconCls'=> $p81['iconcls'],
                'icon_only' => $p81['icon_only'] 
            ));
            
            if(empty( $p81['title'] )){
                $toolbar_item['text'] = $_SESSION['peg_dic_kernel_manage_url'] ;
            }else{
                $toolbar_item['text'] = $p81['title'];
            }
            if(!empty( $p81['icon']))	{
                $toolbar_item['icon'] =  $p81['icon'];
            }else{
                $toolbar_item['icon'] =  "kernel_images/z21_manage.png";
            }
            if(pegasus_lock_check_app()==1){
                $toolbar_item['extrahandler'] =  "pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "');";
            }
            $tmpAr = $toolbar_item;
            $pegasusToolBarAr[$pos]['items'][] = $toolbar_item ;
            
            $tmpAr['p81_id']  ='z21';
            
            $tmpAr['xtype'] = 'pegasusToolBarMenuItem' ;
            $menu[] = $tmpAr;
        }elseif($p81['type'] == 'multi_lang' && substr($table,0,8) != 'peg_tmp_'){
            
            
            $toolbar_item =  array_merge($toolbar_item, array(
                'xtype' => 'pegasusToolBarMultiLang', 
                'iconCls'=> $p81['iconcls'],
                'icon_only' => $p81['icon_only'],
                'text'=>  $p81['title'] 
               
            ));
            
            if(pegasus_lock_check_app()==1){
                $toolbar_item['extrahandler'] =  "pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "');";
            }
            if(!empty( $p81['icon']))	{
                $toolbar_item['icon'] = $p81['icon'];
            }
            
            $pegasusToolBarAr[$pos]['items'][] = $toolbar_item ;
            $toolbar_item['xtype'] = 'pegasusToolBarMenuItem' ;
            
            $menu[] = $toolbar_item;
        }elseif($p81['type'] == 'archive' && substr($table,0,8) != 'peg_tmp_' && pegasus_profile_check_module_permission('archive', $_SESSION['user_profile'])){
            // $con_id = pegasus_container_id_create( $container_id , session_id());
            
            $toolbar_item =  array_merge($toolbar_item, array(
                'xtype' => 'pegasusToolBarArchive', 
                'iconCls'=> $p81['iconcls'],
                'icon_only' => $p81['icon_only'] 
            ));
            
            if(pegasus_lock_check_app()==1){
                $toolbar_item['extrahandler'] =  "pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "');";
            }
            if(empty( $p81['title'] )){
                $toolbar_item['text'] = $_SESSION['peg_dic_archive_manage_data'] ;
            }else{
                $toolbar_item['text'] = $p81['title'];
            }
            if(!empty( $p81['icon']))	{
                $toolbar_item['icon'] =  $p81['icon'];
            }else{
                $toolbar_item['iconCls'] =   "fas fa-folder";
            }
            
            
            $tmpAr = $toolbar_item;
            $tmpAr['p81_id']  ='archive';
            $pegasusToolBarAr[$pos]['items'][] = $toolbar_item ;
            $tmpAr['xtype'] = 'pegasusToolBarMenuItem' ;
            $menu[] = $tmpAr;
            
        }elseif($p81['type'] == 'showd01grid' && substr($table,0,8) != 'peg_tmp_' && pegasus_profile_check_module_permission('crm002', $_SESSION['user_profile'])){
            //             $con_id = pegasus_container_id_create( $container_id , session_id());
            
            $toolbar_item =  array_merge($toolbar_item, array(
                'xtype' => 'pegasusToolBarShowD01Grid',
                'iconCls'=> $p81['iconcls'],
                'icon_only' => $p81['icon_only']
            ));
            
            if(pegasus_lock_check_app()==1){
                $toolbar_item['extrahandler'] =  "pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "');";
            }
            if(empty( $p81['title'] )){
                $toolbar_item['text'] = $_SESSION['peg_dic_crm002_tasks_of_the_rec'] ;
            }else{
                $toolbar_item['text'] = $p81['title'];
            }
            if(!empty( $p81['icon']))	{
                $toolbar_item['icon'] =  $p81['icon'];
            }else{
                $toolbar_item['icon'] =   "crm002_images/calendar_16x16.png";
            }
            
            
            
            
            $pegasusToolBarAr[$pos]['items'][] = $toolbar_item ;
            $toolbar_item['xtype'] = 'pegasusToolBarMenuItem' ;
            $menu[] = $toolbar_item;
            
        }elseif($p81['type'] == 'peg_photos' && substr($table,0,8) != 'peg_tmp_' && pegasus_profile_check_module_permission('peg_photos', $_SESSION['user_profile'])){
            //             $con_id = pegasus_container_id_create( $container_id , session_id());
            
            $toolbar_item =  array_merge($toolbar_item, array(
                'xtype' => 'pegasusToolBarPegPhotos',
                'iconCls'=> $p81['iconcls'],
                'icon_only' => $p81['icon_only']
            ));
            
            if(pegasus_lock_check_app()==1){
                $toolbar_item['extrahandler'] =  "pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "');";
            }
            if(empty( $p81['title'] )){
                $toolbar_item['text'] = $_SESSION['peg_dic_peg002_peg_photos_of_the_rec'] ;
            }else{
                $toolbar_item['text'] = $p81['title'];
            }
            if(!empty( $p81['icon']))	{
                $toolbar_item['icon'] =  $p81['icon'];
            }else{
                $toolbar_item['icon'] =   "peg_photos_images/image_16x16.png";
            }
            
            
            
            
            $pegasusToolBarAr[$pos]['items'][] = $toolbar_item ;
            $toolbar_item['xtype'] = 'pegasusToolBarMenuItem' ;
            $menu[] = $toolbar_item;
            
        }elseif($p81['type'] == 'rec_photo' && substr($table,0,8) != 'peg_tmp_' && pegasus_profile_check_module_permission('peg_photos', $_SESSION['user_profile'])){  
            $toolbar_item =  array_merge($toolbar_item, array(
                'xtype' => 'pegasusToolBarRecPhoto',
                'iconCls'=> 'fa fa-camera',
                'icon_only' => $p81['icon_only']
            ));
            
            if(pegasus_lock_check_app()==1){
                $toolbar_item['extrahandler'] =  "pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "');";
            }
            if(empty( $p81['title'] )){
                $toolbar_item['text'] = $_SESSION['peg_dic_peg_photos_rec_photo'] ;
            }else{
                $toolbar_item['text'] = $p81['title'];
            }
            if(!empty( $p81['icon']))	{
                $toolbar_item['icon'] =  $p81['icon'];
            }           
            
            
            $pegasusToolBarAr[$pos]['items'][] = $toolbar_item ;
            $toolbar_item['xtype'] = 'pegasusToolBarMenuItem' ;
            $menu[] = $toolbar_item;
            
        }elseif($p81['type'] == 'relations_q30' && substr($table,0,8) != 'peg_tmp_' ){

            
            $toolbar_item =  array_merge($toolbar_item, array(
                'xtype' => 'pegasusToolBarRelationQ30',
                'iconCls'=> $p81['iconcls'],
                'icon_only' => $p81['icon_only']
            ));
            
            if(pegasus_lock_check_app()==1){
                $toolbar_item['extrahandler'] =  "pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "');";
            }
            if(empty( $p81['title'] )){
                $toolbar_item['text'] = $_SESSION['peg_dic_core_relations_q30'] ;
            }else{
                $toolbar_item['text'] = $p81['title'];
            }
            if(!empty( $p81['icon']))	{
                $toolbar_item['icon'] =  $p81['icon'];
            }else{
                $toolbar_item['icon'] =   "core_images/relation_16x16.png";
            }
            
            
            
            
            $pegasusToolBarAr[$pos]['items'][] = $toolbar_item ;
            $toolbar_item['xtype'] = 'pegasusToolBarMenuItem' ;
            $menu[] = $toolbar_item;
            
        }elseif($p81['type'] == 'save_tab'  || $p81['type']=='save_window' || $p81['type']=='update_tab'){
            $_handler = $p81['handler_js'];
             
            if((empty( $p81['icon']) || empty( $p81['iconCls']) ) and $p81['type']=='update_tab'){
                $p81['iconcls'] =  "icon-update";
            }
            $toolbar_item =  array_merge($toolbar_item, array(
                'xtype' => 'pegasusToolBarSaveUpdate',
                'type' => $p81['type'],
                'iconCls'=> $p81['iconcls'],
                'icon'=>  $p81['icon'] ,
                'icon_only' => $p81['icon_only'],
                
                
                'saveHandler' => $_handler,
                
                'text' => $p81['title'],
                
            ));
            
            if(pegasus_lock_check_app()==1){
                $toolbar_item['extrahandler'] =  "pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "');";
            }
            if( $p81['type']=='update_tab'){
                $toolbar_item['p81_id']  ='update';
            }else{
                $toolbar_item['p81_id']  ='save'; 
                if($save_item_count>0){
                    $toolbar_item['p81_id'].=$save_item_count;
                } 
                $save_item_count++;
            }
            $pegasusToolBarAr[$pos]['items'][] = $toolbar_item ;
            
            $toolbar_item['xtype'] = 'pegasusToolBarMenuItem' ;
            $menu[] = $toolbar_item;
            
        }elseif ($p81['type'] == 'close_tab'  || $p81['type']=='close_window' ){
            $toolbar_item =  array_merge($toolbar_item, array(
                'xtype' => 'pegasusToolBarClose',
                'text'  => $p81['title'],
                'iconCls'  => $p81['iconcls']
            ));
            $toolbar_item['p81_id']  ='close';
            if(!empty( $p81['icon']))	{
                $toolbar_item['icon'] =  $p81['icon'];
            } 
            if(pegasus_lock_check_app()==1){
                $toolbar_item['extrahandler'] =  " pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "'); ";
            }
            
            $pegasusToolBarAr[$pos]['items'][] = $toolbar_item ;
            
            $toolbar_item['xtype'] = 'pegasusToolBarMenuItem' ;
            $menu[] = $toolbar_item;
        }elseif($p81['type'] == 'fullscreen'){
            $toolbar_item =  array_merge($toolbar_item, array(
                'xtype' => 'pegasusToolBarFullscreen',
                'icon_only' => $p81['icon_only'] , 
                'iconCls'=> 'fas fa-expand'
            ));
            
            if(empty( $p81['title'] )){
                $toolbar_item['text'] = $_SESSION['peg_dic_archive_manage_data'] ;
            }else{
                $toolbar_item['text'] = $p81['title'];
            }
            if(!empty( $p81['icon']))	{
                $toolbar_item['icon'] =  $p81['icon'];
            } 
            $pegasusToolBarAr[$pos]['items'][] = $toolbar_item ;
            $toolbar_item['xtype'] = 'pegasusToolBarMenuItem' ;
            $menu[] = $toolbar_item;
        }
        
        
        
    }
     
    if(empty($pegasusToolBarAr['top'] )){
        $pegasusToolBarAr['top'] = array(
            'xtype' => 'pegasusToolBar',
            'dock'=> 'top',
            'items' => array()
        );
    } 
    
    if(count($menu)>0 and $_d !== "_main_d" and $_d !== "browse_d00"){

        if($inWindow==0 || ( $inWindow==1 && $printToolBarMenu === true) ){
            array_unshift(
                $pegasusToolBarAr['top']['items'],
                    array(
                        'xtype' => 'pegasusToolBarMenu',
                        'text' => $_SESSION['peg_dic_core_actions'] ,
                        'icon' =>   "core_images/menu_16x16.png" ,
                        'peg_pos' => 'top',
                        'menu' => $menu
                    )
                ); 
            $pegasusToolBarAr['top']['items'][] = array(
                'xtype' => 'tbfill',
                'border' => 0 ,
                'style' => array('backgroundColor' => '')
            );
            $pegasusToolBarAr['top']['items'][] = array(
                'xtype' => 'pegasusDynamicTitle',
                'name' => 'peg_screenTitle', 
                'cls' => 'screenTitle', 
                'border'=> 0,
                'style'=> array('backgroundColor' => '')
            ); 
        }        
    }
    
    if(is_array($pegasusToolBarAr['bottom'])){
        if(count($pegasusToolBarAr['bottom'])>0){
            array_unshift(
                $pegasusToolBarAr['bottom']['items'] ,
                array(
                    'xtype' => 'pegasusToolBartbtext'
                ) );
            array_unshift(
                $pegasusToolBarAr['bottom']['items'],
                array(
                    'xtype' => 'tbfill',
                    'border'=> 0 ,
                    'style' => array('backgroundColor'=>'')
                )
                );
        }
    }
    $retAr = array();
    foreach($pegasusToolBarAr as $value){
        if(count( $value['items'] ) == 0){
            continue;
        }
        $retAr[] = $value;
    }
    return $retAr;
}
/**
 * This functions return a array with menu Items
 * 
 * @see toolbar item Main Menu
 * @see @old make_menu_arr()
 * 
 * @param string $pcd
 * @param string $container_id 
 * @param string $onlyCode //Get meny for p80.cd
 * @return array
 * 
 * @example
 * peg002_make_menu_arr('' ,  "_main_d", 'dias0008')
 */
function peg002_make_menu_arr($pcd="", $container_id="", $onlyCode = ""){ 
    $query = peg_read_file('../peg002_sql/screen/menu.sql'); 
    $query = str_replace(
        array( '##LANG##'),
        array($GLOBALS['userCookie']->getLang()),
        $query
    ); 
    
    $res =  Peg002_MySQL::pegasus_query($query, array(
        'pcd' => $pcd,
        'pcd_like' => "%#$pcd#%",
        'onlyCode' => $onlyCode,
        'user_profile' =>  $_SESSION['user_profile']
    ));  
    $arr = array();
    if(pegasus_lock_check_app()==3){
        $locked = true;
    }
    
    while ($p80 = pegasus_fetch_assoc($res)){  
        $no_print=false;
        if($locked){
            if(
                $p80['cd']!='core9900' and
                $p80['cd']!='core9913' and
                $p80['cd']!='core9901' and
                $p80['cd']!='core9902' and
                $p80['cd']!='core9907' and
                $p80['cd']!='core9912' 
                ){
                    $no_print=true;
            }
        }
        
        if(!$no_print){
            $arr1 = array();
            
            $icon = '';
            $iconCls = '';
            
            $arr1["text"]  = str_replace( '<!--#-->' , '' ,$p80['title']); 
            // $arr1["xtype"]      = "pegasusMenuItem";
            if(!empty($p80["icon"])){ 
                $arr1["icon"]   =  $p80['icon'];
                $icon           = $p80['icon'];
            }else{
                $arr1["iconCls"]= $p80['iconcls'];
                $iconCls        = $p80['iconcls'];
            }
            
            $urlparams = eval($p80['urlparams']) ;
            
            
            if ( $urlparams === false && ($error = error_get_last()) ) {
                if(pegasus_displayErrors()){
                    print_r($p80);
                    var_dump($error);
                }
                
                die('Error in eval');
            } 
            
            $permDeny=0;
            if($p80['act']=='browse'){
                
               
                
                $con_id = 'M' . $p80['nr01'];
                $arr1 = Peg002_Menu::actionBrowse(
                    $pcd,
                    $container_id."_tab",
                    $con_id,
                    $p80['title'],
                    $icon,
                    $iconCls,
                    $p80['view_d'],
                    $p80['view_module'],
                    $p80['view_table'],
                    $p80['view_orderby'],
                    $p80['view_groupby'],
                    $p80['browse_edit'],
                    $p80['copy_recs'],
                    $p80['full_text_search'],
                    $urlparams 
                   );

        
                
            }elseif ($p80['act']=='show_d'){
                
                
                $con_id = 'p80_1_' . $p80['nr01']; 
                $arr1 = Peg002_Menu::actionShow_d(
                    $pcd,
                    $container_id."_tab",
                    $con_id,
                    $p80['title'],
                    $icon,
                    $iconCls,
                    $p80['view_d'],
                    $p80['view_module'],
                    $p80['view_table'], 
                    $urlparams
                    );
               
                
            }elseif ($p80['act']=='meth'){
                $con_id = 'p80_1_' . $p80['nr01'];
                $meth = $p80['meth'];
                $arr1 = Peg002_Menu::actionMethod(
                    $pcd,
                    $container_id."_tab",
                    $con_id,
                    $p80['title'],
                    $icon,
                    $iconCls,
                    $meth
                    );
                
                 
                
            }elseif ($p80['act']=='handler'){
                $peghandler = null;
                if(!empty($p80['handler_js'])){
                    $peghandler  = @eval($p80['handler_js']) ;
                    if ( $peghandler === false && ($error = error_get_last()) ) {
                        if(pegasus_displayErrors()){
                            print_r($p80);
                            var_dump($error);
                        }

                        die('Error in eval');
                    }
                    
                 
                    
                }else{
                    $peghandler  = @eval($p80['handler']) ;
                    if ( $peghandler === false && ($error = error_get_last()) ) {
                        if(pegasus_displayErrors()){
                            print_r($p80);
                            var_dump($error);
                        }
                        die('Error in eval');
                    }
                }
                $arr1 = Peg002_Menu::actionMenuItem( 
                    $pcd,
                    $p80['title'],
                    $icon,
                    $iconCls, 
                    $peghandler
                    );
               
                
            }elseif ($p80['act']=='other'){ 
                $peghandler = null;
                if(!empty($p80['handler_js'])){
                    $peghandler  = @eval($p80['handler_js']) ;
                    if ( $peghandler === false && ($error = error_get_last()) ) {
                        if(pegasus_displayErrors()){
                            print_r($p80);
                            var_dump($error);
                        }
                        die('Error in eval');
                    }
               
                    
                }else{
                    $peghandler  = @eval($p80['handler']) ;
                    if ( $peghandler === false && ($error = error_get_last()) ) {
                        if(pegasus_displayErrors()){
                            print_r($p80);
                            var_dump($error);
                            
                        }
                        die('Error in eval');
                    }
                }
                $arr1 = Peg002_Menu::actionMenuItem(
                    $pcd,
                    $p80['title'],
                    $icon,
                    $iconCls,
                    $peghandler
                    );
      
                
            }else{
                //When the action is no defined
                if(!empty($pcd)){
                    $arr1['xtype'] = 'pegasusToolBarMenuItem';
                } 
            }
            
            if($permDeny==0){
                if(is_array($arr1)){
                    $menu = peg002_make_menu_arr($p80['cd'] , $container_id);
                    // $menu = peg002_make_menu_arr($p80['cd'] , $container_id, $onlyCode);
                    if(!empty($menu[0]['text'])){
                        $arr1["menu"]  =  $menu;
                        // $arr1["menu"]['defaults'] = array('xtype' => 'pegasusMenuItem');
                    }
                
                    array_push($arr  , $arr1);
                }

            }
        }
    }
    
    
    return $arr;
}
/**
 * @see @old screen->make_rightclick_arr
 * 
 * @param string $pcd
 * @param number $depth
 * @return array()
 */
function peg002_make_rightclick_arr($pcd=""  , $depth=0 , $_d=''){ 
    
    
    $depth++;
    $arr = array();
    
   
    $query = peg_read_file('../peg002_sql/screen/menuRightClick.sql'); 
    $query = str_replace(
        array( '##LANG##'),
        array($GLOBALS['userCookie']->getLang()),
        $query
    );

    // $query = " select p80.* from p80
	// 						join p95p55 on p80.module=p95p55.module and p95p55.en=1 and p95p55.p95=\"" .$_SESSION['user_profile']. "\"
	// 						join p95p80 on p95p80.p80=p80.nr01 and p95p80.p300=1 and p95p80.p95=\"" .$_SESSION['user_profile']. "\"
    // 						where p80.pcd=\"".$pcd."\" and p80.type in (4) order by p80.tax;"; 
    
    $res =  Peg002_MySQL::pegasus_query($query, array(
        'pcd' => $pcd,
        'user_profile' => $_SESSION['user_profile']
    ),1);

    if(empty($pcd)){
        $pcd = 'rightclick';
    }
    
    $urlparams = '';
    // foreach ($p80_arr //as $p80){
    while ($p80 = pegasus_fetch_assoc($res)){ 
        // if($GLOBALS['userCookie']->getLang()=='EN' and !empty($p80['etitle']) ){
        //     $p80['title'] = $p80['etitle'];
        // }
        $arr1 = array();
        $icon = '';
        $iconCls ='';
        $arr1["iconCls"]  = $p80['iconcls'];
        $arr1["text"]     = $p80['title'];
       
        
        
        if(!empty($p80["icon"])){
            $arr1["icon"]     =  $p80['icon'];
            $icon = $arr1["icon"] ;
        }
        
        $iconCls = $arr1["iconCls"] ;
        
        $permDeny=0;
        if($p80['act']=='browse'){
            // $con_id = pegasus_container_id_create( $container_id , session_id());
            $arr1 = Peg002_Menu::actionBrowse(
                $pcd,
                '',
                '',
                $p80['title'],
                $icon,
                $iconCls,
                $p80['view_d'],
                $p80['view_module'],
                $p80['view_table'],
                $p80['view_orderby'],
                $p80['view_groupby'],
                $p80['browse_edit'],
                $p80['copy_recs'],
                $p80['full_text_search'],
                $urlparams
            );
        }elseif ($p80['act']=='show_d'){
            // $con_id = pegasus_container_id_create( $container_id , session_id());
            $arr1 = Peg002_Menu::actionShow_d(
                $pcd,
                '',
                '',
                $p80['title'],
                $icon,
                $iconCls,
                $p80['view_d'],
                $p80['view_module'],
                $p80['view_table'],
                $urlparams
                );
           
        }elseif ($p80['act']=='meth'){
            // $con_id = pegasus_container_id_create( $container_id , session_id()) ;
            $meth = $p80['meth'];
            $arr1 = Peg002_Menu::actionMethod( 
                $pcd,
               '',
                '',
                $p80['title'],
                $icon,
                $iconCls,
                $meth
             );
        }elseif ($p80['act']=='handler'){ 
            $peghandler = null;
            if(!empty($p80['handler_js'])){
                $peghandler  = @eval($p80['handler_js']) ;
                if ( $peghandler === false && ($error = error_get_last()) ) {
                    
                 
                    
                    if(pegasus_displayErrors()){
                        print_r($p80);
                        var_dump($error);
                    }
                    die('Error in eval');
                }
            }else{
                $peghandler  = @eval($p80['handler']) ;
                if ( $peghandler === false && ($error = error_get_last()) ) {
                    if(pegasus_displayErrors()){
                        print_r($p80);
                        var_dump($error);
                    }
                    die('Error in eval');
                }
            }
         //   var_dump(in_array($p80['cd'],array('core9801','core9802')) );
            
            $arr1 = Peg002_Menu::actionMenuItem(
                $pcd,
                $p80['title'],
                $icon,
                $iconCls,
                $peghandler,
                $p80['cd']
            );
            
        }
        
        if($permDeny==0){ 
            if(is_array($arr1)){
                $items =  peg002_make_rightclick_arr($p80['cd']  , $depth);
                if(!empty($items[0]['text'])){
                    if(empty($pcd)){
                        $arr1["items"]  =  $items;
                    }else{
                        $arr1["menu"]  =  $items;
                    }
                }
                array_push($arr  , $arr1);
            }
        }
    }
     

    return $arr;
}	
/**
 *@see @old make_accordion_arr
 */
function peg002_make_accordion_arr($pcd="" , $container_id ="" , $depth=0){
    $depth++;

    $query = peg_read_file('../peg002_sql/accordion/p80.sql'); 
    $query = str_replace(
        array('##LANG##' ),
        array($GLOBALS['userCookie']->getLang()),
        $query);
 

    $res =  Peg002_MySQL::pegasus_query(
        $query,
        array(
            'pcd' => $pcd,
            'pcd_like' => "%#$pcd#%",
            'user_profile' => $_SESSION['user_profile']

        )
    ); 
    
    $arr = array(); 
    if(pegasus_lock_check_app()==3){
        $locked =true;
    }
    
    while ($p80 = pegasus_fetch_assoc($res)){ 
        
        // if($GLOBALS['userCookie']->getLang()=='EN' and !empty($p80['etitle']) ){
        //     $p80['title'] = $p80['etitle'];
        // }
        
        $no_print=false;
        if($locked){
            if( $p80['cd']!='core9900' and $p80['cd']!='core9913' and $p80['cd']!='core9912'){
                $no_print=true;
            }
        }
        
        if(!pegasus_profile_check_module_permission(  $p80['module'] , $_SESSION['user_profile'])){
            $no_print=true;
        }
        if(!$no_print){
            $permDeny=0;
            $arr1 = array();
            // $arr1["xtype"]      = "pegasusButton";
            $arr1["iconCls"]  = $p80['iconcls'];
            if(!empty($p80["icon"])){
                $arr1["icon"]     = $p80['icon'];
            }
            
            if(empty($pcd)){
                $arr1["title"]  = str_replace( '<!--#-->' , '' ,$p80['title']); 
                $arr1["layout"]  =array('type'=>'vbox' , 'align' => 'stretch' );
                $arr1["autoScroll"]  =true;
                
            }else{
                $arr1["text"]  = str_replace( '<!--#-->' , '<br>' ,$p80['title']);
                if($depth==2){
                    $arr1["xtype"]      = "pegasusAccordionButton";
                    $arr1["p80_id"] = $p80['nr01']; 
                }
                
             
                if($p80['act']=='browse'){
                    if(!empty($p80['view_table'])){
                        if(!pegasus_profile_check_data_permission($p80['view_table'] , 'SHOW' , $_SESSION['user_profile'])){
                            $permDeny=1;
                        }
                    }
                    $arr1["xtype"] = 'pegasusAccordionItemBrowse';
                    // kaname gia  tin allagi gia veltiosi tis taxititas$con_id = pegasus_container_id_create( $container_id , session_id());
                    $con_id = 'p80_3_' . $p80['nr01'];
                    $arr1["view_d"]= $p80['view_d'];
                    $arr1["view_module"]= $p80['view_module'];
                    $arr1["view_table"] = $p80['view_table'];
                    $arr1["view_orderby"]= $p80['view_orderby'];
                    $arr1["view_groupby"]= $p80['view_groupby'];
                    $arr1["browse_edit"]= $p80['browse_edit'];
                    $arr1["browse_copy"]= $p80['copy_recs'];
                    $arr1["enable_quick_find"]= $p80['full_text_search'];
                    $arr1["urlparams"] = "";
                    if( !empty($p80['urlparams'])){
                        $arr1["urlparams"] = @eval($p80['urlparams']);
                        
                        if (  $arr1["urlparams"] === false && ($error = error_get_last()) ) {
                            if(pegasus_displayErrors()){
                                print_r($arr1);
                                var_dump($error);
                            }
                            die('Error in eval');
                        }
                    }
                    
                    if(pegasus_lock_check_app()==1){
                        $arr1["peg_handler"] .= "pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "');";
                    }
                    
                     
                }elseif ($p80['act']=='show_d'){
                    if(!empty($p80['view_table'])){
                        if(!pegasus_profile_check_data_permission($p80['view_table'] , 'SHOW' , $_SESSION['user_profile'])){
                            $permDeny=1;
                        }
                    }
                    $arr1["xtype"] = 'pegasusAccordionItemShow_d';
                    
                    $con_id = 'p80_3_' . $p80['nr01'];
                    $arr1["view_d"]= $p80['view_d'];
                    $arr1["view_module"]= $p80['view_module'];
                    $arr1["view_table"] = $p80['view_table'];
                    $arr1["urlparams"] = "";
                    if( !empty($p80['urlparams'])){
                        $arr1["urlparams"] = @eval($p80['urlparams']);
                        
                        if (  $arr1["urlparams"] === false && ($error = error_get_last()) ) {
                            if(pegasus_displayErrors()){
                                print_r($arr1);
                                var_dump($error);
                            }
                            die('Error in eval');
                        }
                    }
                    if(pegasus_lock_check_app()==1){
                        $arr1["peg_handler"] .= "pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "');";
                    }
                     
                }elseif ($p80['act']=='meth'){
                    $con_id = 'p80_3_' . $p80['nr01'];
                    $arr1["peg_handler"] = " pegAddTab('". $container_id."_tab' , '" . $p80['title'] . "'  ,  ''  , true , '" . eval($p80['meth']) . "'  , '" .$con_id. "' ); ";
                    
                    if(pegasus_lock_check_app()==1){
                        $arr1["peg_handler"] .= "pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "');";
                    }
                     
                }elseif ($p80['act']=='handler'){
                    $arr1["xtype"] = 'pegasusAccordionItemAction';
                    
                    $con_id = 'p80_3_' . $p80['nr01'];
                    if( !empty($p80['urlparams'])){
                        $arr1["urlparams"] = @eval($p80['urlparams']);
                        if (  $arr1["urlparams"] === false && ($error = error_get_last()) ) {
                            if(pegasus_displayErrors()){
                                print_r($p80);
                                var_dump($error);
                            }
                            die('Error in eval');
                        }
                    }
                    if(!empty($p80['handler_js'])){
                        $arr1["peg_handler"] =  @eval($p80['handler_js'] ); 
                        if ( $arr1["peg_handler"]  === false && ($error = error_get_last()) ) {
                            if(pegasus_displayErrors()){
                                print_r($p80);
                                var_dump($error);
                            }
                            die('Error in eval');
                        }
                    }else{
                        $arr1["peg_handler"] =  @eval($p80['handler'] ); 
                        if ( $arr1["peg_handler"] === false && ($error = error_get_last()) ) {
                            if(pegasus_displayErrors()){
                                print_r($p80);
                                var_dump($error);
                            }
                            die('Error in eval');
                        }
                    }

                    if(pegasus_lock_check_app()==1){
                        $arr1["peg_handler"] .= "pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "');";
                    }
                     
                }
                
            }
            
            if($permDeny==0){
                $items='';
                $items = peg002_make_accordion_arr($p80['cd'] , $container_id , $depth);
                if(!empty($items[0]['text'])){
                    if(empty($pcd)){
                        $arr1["items"]  =  $items;
                    }else{
                        $arr1["menu"]  =  $items;
                    }
                }
                array_push($arr  , $arr1);
            }
        }
        
    }
    return $arr;
}

//XXX End Structure Functions
//XXX Start Service functions
 
function peg002_create_row_data_query($p52_module, $p52__d, $p52_table , $user_profile = 0 , $quick_find = '' , $container_id ='' ){
    $cor000_en_caching =  $_SESSION['cor000_en_caching'];
    $cor000_en_caching  =  0 ;
    $en_quick_find = 0;
    if(!empty($quick_find)){
        $en_quick_find = 1;
    }
    $var_name = 'getdata_row_p51_peg002_' .  $p52_module. '_' .  $p52__d. $user_profile . '_' . $GLOBALS['userCookie']->getLang() ;
     
    
    
    $p52_query = ''; 
    $p52_queryParams = array(
        '_d' =>  $p52__d,
        'module' => $p52_module
    );
    if(!empty($user_profile)){
        if(!file_exists('../peg002_sql/peg002_03/geddata/get_row_fields_underprofile.sql')){
            return '';   
        }
        $p52_queryParams['user_profile'] = $user_profile;
        $p52_query = peg_read_file('../peg002_sql/peg002_03/geddata/get_row_fields_underprofile.sql');
        
    }else {
        if(!file_exists('../peg002_sql/peg002_03/geddata/get_row_fields.sql')){
            return '';
        }
        $p52_query = peg_read_file('../peg002_sql/peg002_03/geddata/get_row_fields.sql'); 
    }
    
    $p52_query =  str_replace(
        array('##LANG##'  ),
        array($GLOBALS['userCookie']->getLang() ),
        $p52_query); 
    
    $p51_array = pegasusGetGlobalVar($var_name, $p52_module.'/'.$p52__d);
    if(  $p51_array=='' or $cor000_en_caching == 0 ){ 
        $res =  Peg002_MySQL::pegasus_query(
            $p52_query,
            $p52_queryParams
        );  

        $p51_array = array();
        while($p510 = pegasus_fetch_assoc($res)){
            array_push($p51_array , $p510);
        }
        pegasusSetGlobalVar($var_name , $p51_array,$p52_module.'/'.$p52__d);
    }
    
    
    $desc05='';
    $field_arr=array();
    $query_field        = '';
    $browse_jn_table    = '';
    $browse_jn_as_table = '';
    $browse_jn_where    = '';
    $browse_jn_field    = '';
    $browse_jn_type     = '';
    $ls_data            = '';
    $displayField       = '';
    $valueField         = '';
    
    $browse_selectbox_type = '';
    $browse_selectbox_code_title = '';
    $br_table = '';
    
    if(count($p51_array)>0  ){
        foreach ($p51_array as $p51) {
            
            if($p51['desc05']!=$desc05 and !empty($desc05)){
                $field_arr[] = array(
                    "tax" => $tax , 
                    "desc13" => $desc13 , 
                    "name" => $desc05 , 
                    "db_type" => $desc16 , 
                    "type" => $desc07 , 
                    "desc17" => $desc17, 
                    "browse_jn_table" => $browse_jn_table , 
                    "browse_jn_as_table" => $browse_jn_as_table , 
                    "browse_jn_where" => $browse_jn_where , 
                    "browse_jn_type" => $browse_jn_type, 
                    "browse_jn_field" => $browse_jn_field, 
                    "ls_data" => $ls_data , 
                    "valueField" => $valueField  , 
                    "displayField" => $displayField  , 
                    "browse_value" => $browse_value, 
                    "browse_value_code" => $browse_value_code , 
                    "br_table" => $br_table  , 
                    'browse_selectbox_type' =>  $browse_selectbox_type , 
                    'browse_selectbox_code_title' => $browse_selectbox_code_title    
                );
                
                if(!empty($browse_jn_field) and ( ((!empty($browse_jn_table)) and pegasus_mysql_table_exists($browse_jn_table)) or empty($browse_jn_table))   ){ 
                    if($desc13!=0 or $tax!=0){ 
                        if($desc07=='selectbox' || $desc07=='comboboxV2'){
                            if(strtoupper($desc16)!='V' ){ 
                                $query_field .= ','. $browse_jn_field . ' as ';
                                $query_field .= 'v_selectbox_' . $desc05;
                            }
                        }else {
                            $query_field .= ',' .$browse_jn_field . ' as ';
                            $query_field .= $desc05;
                        }
                    }

                }else{
                    if(($desc07=='selectbox' || $desc07=='comboboxV2' ) and (!empty($br_table)) and pegasus_mysql_table_exists($br_table)){
                        
                        if($desc13!=0 or $tax!=0){ 
                            $query_field .= ' , selectbox_'.$desc05.'_' . $br_table  . '.' . $displayField  ;
                            $query_field .= ' as v_selectbox_' . $desc05;
                        } 
                        
                    } 
                }
                
                
                $childs=array();
                
                $browse_jn_table    ='';
                $browse_jn_as_table ='';
                $browse_jn_where    ='';
                $browse_jn_field    ='';
                $browse_jn_type     ='';
                $browse_value     ='';
                $browse_value_code     ='';
                $ls_data     ='';
                $displayField     ='';
                $valueField     ='';
                
                
                $browse_selectbox_type = '';
                $browse_selectbox_code_title = '';
                $br_table = '';
            }
            
            $desc05 = $p51['desc05'];
            $desc17 = $p51['desc17'];
            $desc16 = $p51['desc16'];
            $desc07 = $p51['desc07'];
            $desc98 = $p51['desc98'];
            $desc13 = $p51['desc13'];
            $tax = $p51['tax'];
            if($p51['par_nm']=='browse_value'){
                $browse_value_code = $p51['code'] ;
                $browse_value      = $p51['par_val'];
            }
            
            if($p51['par_nm']=='ls_data'){
                if($p51['code']==1){
                    $ls_data = eval($p51['par_val']);
                }else{
                    $ls_data = $p51['par_val'];
                }
            }
            
            if($p51['par_nm']=='displayField'){
                if($p51['code']==1){
                    $displayField = eval($p51['par_val']);
                }else{
                    $displayField = $p51['par_val'];
                }
            }
            
            if($p51['par_nm']=='table'){
                if($p51['code']==1){
                    $br_table = eval($p51['par_val']);
                }else{
                    $br_table = $p51['par_val'];
                }
            }
            
            if($p51['par_nm']=='browse_selectbox_type'){
                if($p51['code']==1){
                    $browse_selectbox_type = eval($p51['par_val']);
                }else{
                    $browse_selectbox_type = $p51['par_val'];
                }
            }
            
            if($p51['par_nm']=='browse_selectbox_code_title'){
                if($p51['code']==1){
                    $browse_selectbox_code_title = eval($p51['par_val']);
                }else{
                    $browse_selectbox_code_title = $p51['par_val'];
                }
            }
            
            if($p51['par_nm']=='noPrivilegeCheck'){
                if($p51['code']==1){
                    $noPrivilegeCheck = eval($p51['par_val']);
                }else{
                    $noPrivilegeCheck = $p51['par_val'];
                }
            }
            
            if($p51['par_nm']=='valueField'){
                if($p51['code']==1){
                    $valueField = eval($p51['par_val']);
                }else{
                    $valueField = $p51['par_val'];
                }
            }
            
            if($p51['par_nm']=='browse_jn_table'){
                if($p51['code']==1){
                    $browse_jn_table = eval($p51['par_val']);
                }else{
                    $browse_jn_table = $p51['par_val'];
                }
            }
            
            if($p51['par_nm']=='browse_jn_as_table'){
                if($p51['code']==1){
                    $browse_jn_as_table = eval($p51['par_val']);
                }else{
                    $browse_jn_as_table = $p51['par_val'];
                }
            }
            
            if($p51['par_nm']=='browse_jn_where'){
                if($p51['code']==1){
                    $browse_jn_where = eval($p51['par_val']);
                }else{
                    $browse_jn_where = $p51['par_val'];
                }
            }
            
            if($p51['par_nm']=='browse_jn_field'){
                if($p51['code']==1){
                    $browse_jn_field = eval($p51['par_val']);
                }else{
                    $browse_jn_field = $p51['par_val'];
                }
            }
            
            if($p51['par_nm']=='browse_jn_type'){
                if($p51['code']==1){
                    $browse_jn_type = eval($p51['par_val']);
                }else{
                    $browse_jn_type = $p51['par_val'];
                }
            }
            
        }
        
        $field_arr[] = array(
            "tax" => $tax , 
            "desc13" => $desc13 ,
            "name" => $desc05 , 
            "db_type" => $desc16, 
            "type" => $desc07,
            "desc17" => $desc17 , 
            "browse_jn_table" => $browse_jn_table , 
            "browse_jn_as_table" => $browse_jn_as_table , 
            "browse_jn_where" => $browse_jn_where , 
            "browse_jn_field" => $browse_jn_field  , 
            "browse_jn_type" => $browse_jn_type, 
            "ls_data" => $ls_data  , 
            "valueField" => $valueField  , 
            "displayField" => $displayField , 
            "browse_value" => $browse_value  , 
            "browse_value_code" => $browse_value_code , 
            "br_table" => $br_table  , 
            'browse_selectbox_type' =>  $browse_selectbox_type , 
            'browse_selectbox_code_title' => $browse_selectbox_code_title
            
        );
        
        if((!empty($browse_jn_field))  and ( ((!empty($browse_jn_table)) and pegasus_mysql_table_exist($browse_jn_table)) or empty($browse_jn_table)) ){
            if($desc13!=0 or $tax!=0){ 
                
                $query_field .= ', '. $browse_jn_field . ' as ';
                $query_field .= $desc05;
            } 
        }else{
            if(($desc07=='selectbox' || $desc07=='comboboxV2') and ((!empty($br_table)) and pegasus_mysql_table_exist($br_table))){ 
                
                if($desc13!=0 or $tax!=0){ 
                    $query_field .= ', selectbox_'.$desc05.'_' . $br_table  . '.' . $displayField  ;
                    $query_field .= ' as v_selectbox_' . $desc05;
                }
                
            } 
        }
    }
    
    
    $join = array();
    foreach ($field_arr as $jn){
        
        if( (!empty($jn['browse_jn_table']))  and   pegasus_mysql_table_exist($jn['browse_jn_table']) and (!empty( $jn['browse_jn_where'])) ){
            
            if(!empty($jn['browse_jn_type'])){
                $tb = $jn['browse_jn_type'] . ' join ' ;
            }else{
                $tb = ' left join ' ;
            }
            
            $tb .= $jn['browse_jn_table'];
            if(!empty($jn['browse_jn_as_table'])){
                $tb .= " as " . $jn['browse_jn_as_table'];
            }
            
            //join on
            if(!empty($join[$tb])){
                $join[$tb] .= " and " ;
            }
            $join[$tb] .=   $jn['browse_jn_where'];
            
        }elseif(($jn['type']=='selectbox' || $jn['type']=='comboboxV2') and   pegasus_mysql_table_exist($jn['br_table'])){
            $tb = ' left join ' ;
            $tb .= $jn['br_table']  .  ' as selectbox_'.  $jn['name'].'_' . $jn['br_table'] ;
            
            if(!empty($jn['browse_jn_field'])){
                $join[$tb] .=  $jn['browse_jn_field'] . '= selectbox_'.  $jn['name'].'_' .  $jn['br_table'] . '.' .  $jn['valueField'];
            }else{
                $join[$tb] .=   $p52_table . '.' . $jn['name'] . '= selectbox_'.  $jn['name'].'_' .  $jn['br_table'] . '.' .  $jn['valueField'];
            }
        }
        
    }
    
    
    $q_join='';
    foreach ($join as  $key => $value) {
        if(!empty($value)){
            $q_join .= "   " . $key . " on " . $value;
            
        }
        
    }
    if(!empty($p52_table)){
        if(!pegasus_profile_check_data_permission($p52_table , 'SHOW' , $_SESSION['user_profile'])){ 
            return ;
        }
    }
    
     
    
    if(empty($groupby)){
        $groupby  = ' group by ' . $p52_table . '.nr01';
    }
    
    $query = " select  $p52_table.* $query_field from  $p52_table  $q_join $where $groupby " ;
    
    return $query;
}
/**
 * TODO: use parameter $user_profile
 */
function peg002_create__d_fields_query(&$array, $manatable,$table, $user_profile){
    $ret_array = array('fields' => '', 'leftjoin' => '', 'data' => array());

    $field_type = array(
        'textbox','numberbox','checkbox','comboboxV2','combobox','radio','textarea','codemirror','datebox','tinymce','selectbox','timefield','multi_selectbox','colorpicker',
    );
     
    $tmpArray = array();
    if(empty($user_profile)){
        $user_profile  = $_SESSION['user_profile'];
    }
    
    if( !(
        pegasus_mysql_table_exists($table) &&
        pegasus_profile_check_data_permission($table, 'SHOW' ,  $user_profile)
        )
        ){
            //XXX Ean den uparxei o pinakas h ean den mporei na ton dei
            //TODO na elegjw oti den xanw dedomena sto onsert
            return $ret_array;
    }
     
    foreach ($array as  $row){
        $desc05 = $row['p51_desc05']; 
        if($row['hidden']['par_val']!=1 and $row['p51_type']!='V' && $row['p51_type']!='X'){
            if(in_array($row['p51_desc07'], $field_type )){
                if($table != $manatable){
                    $ret_array['fields'] .= $table.'.'.$desc05 .' as '. $desc05 .', ';
                }
                
                $ret_array['data'][$desc05] = null;

                    if($row['p51_desc07']=='selectbox' || $row['p51_desc07']=='comboboxV2' ){
                        if(!empty($row['table']['par_val']) && $row['table']['code'] == 0){
                            if(
                                !empty($row['valueField']['par_val'] ) &&
                                !empty($row['displayField']['par_val'] ) &&
                                !(
                                pegasus_mysql_table_exists($row['table']['par_val']) &&
                                pegasus_profile_check_data_permission($row['table']['par_val'] , 'SHOW' ,  $user_profile)
                                )
                            ){
                                //XXX Ean den uparxei o pinakas h ean den mporei na ton dei
                                //TODO na elegjw oti den xanw dedomena sto onsert
                                continue;
                            }
                            if(! pegasus_mysql_table_field_exists($row['table']['par_val'] , $row['displayField']['par_val']) ){
                                continue;
                            }

                            if($row['displayField']['par_val'] == $row['valueField']['par_val'] and $row['p51_desc07']=='selectbox'){
                                continue;
                            }

                            $tmpSelectBoxJoinTable = $row['table']['par_val'];
                            if(!empty($row['query']['par_val']) && $row['query']['code'] == 0){
                                $tmpSelectBoxJoinTable = ' (' . str_replace(';', '', $row['query']['par_val']) . ') ';
                            }
                            
                                
                            $ret_array['leftjoin'] .= ' left join '.$tmpSelectBoxJoinTable.' as '. $row['table']['par_val'].$desc05 . ' on '.$row['table']['par_val'].$desc05 .'.'.$row['valueField']['par_val'].'='.$table.'.'.$desc05. ' ';
    
                            $ret_array['fields'] .= $row['table']['par_val'].$desc05 .'.'.$row['displayField']['par_val'] .' as  dias_var_'. $desc05 .', ';
                            $ret_array['data']['dias_var_'.$desc05] = null;
                        }
                    }
                        
                } 
            }

    }
 
    
    $ret_array['fields'] = substr($ret_array['fields'], 0, -2);
     
    
    return $ret_array;
}


function peg002_create_tab_items_array($tabs,$container_id, $main_module,$main_d, $main_table, $main_nr01){
    $i=0;
    $items_array = array();
    foreach ($tabs as $arr1){
        $item = array();
        
        $i++;
        $url ='';
        // $container_id00 =  pegasus_container_id_create($container_id , session_id()  );
        
        $title = $arr1['title'];
        
        $module = $arr1['module'];
        if(empty($module)){
            $module = $main_module;
        }
        
        $table = $arr1['table'];
        if(empty($table)){
            $table = $main_table;
        }
        
        $nr01 = $arr1['nr01'];
        if(empty($nr01)){
            $nr01 = $main_nr01;
        }
        
        // elenxei ta dikaiomata
        $permDeny = 0;
        if(!empty($table)){
            
            if(!pegasus_profile_check_data_permission($table , 'SHOW' , $_SESSION['user_profile'])){
                $permDeny = 1;
            }
        }
        
        if(  !pegasus_profile_check_module_permission($module, $_SESSION['user_profile'] )){
            //             echo "modole = " . $module . "\n";
            $permDeny = 1;
        } 
        
        if ($permDeny==0){
            if(!empty($arr1['_d'])){
                // $title = findScreenTitle( $module , $arr1['_d'] );
                // if(empty($title)){
                //     $title = $arr1['_d'];
                // }
                $item['module'] = $module;
                $item['_d'] = $arr1['_d'];
                $item['table'] = $table; 
                
                $item['iconCls'] = $arr1['iconCls']; 
                $item['custom_id'] = $arr1['custom_id']; 
                $item['closable'] = $arr1['closable']; 
                if(($arr1['load_on_render']=='1') || $i==1){
                    $query = peg_read_file('../peg002_sql/screen.sql');
                    
                    $item['screen_data'] = peg002_create_screen_array($query, $item['module'], $item['_d'], '', $item['parent_id'], $item['mnr01'],  $item['mmnr01'], $nr01);
                }
            }
            // $item['title'] = $title;
            // $item['disabled'] = $disabled;
            // $item['id'] = $container_id00;
            $item['hideMode'] = "offsets";
            
            
            
            $items_array[] = $item;
        }
        
        
    }
    return $items_array;
    
} 
function peg002_create_tab_data_array($tabs,$maincontainer_id, $main_module,$main_d, $main_table, $main_nr01){
    $i=0;
    $items_array = array('noeval' => array(), 'eval' => array(),'type' => array(),'tabs' => array(),  'items' => array() );
    // print_r($tabs);
    // die();
    foreach ($tabs as $arr1){
        $item = array();
        
        $i++;
        $url =''; 
        
        $title = $arr1['title'];
        
        
        $icon = $arr1['icon'];
        $iconCls = $arr1['iconCls'];
        
        $module = $arr1['module'];
        if(empty($module)){
            $module = $main_module;
        }
        
        $table = $arr1['table'];
        if(empty($table)){
            $table = $main_table;
        }
        
        $nr01 = $arr1['nr01'];
        if(empty($nr01)){
            $nr01 = $main_nr01;
        }
        // print_r($arr1);
        $disabled = ($arr1['disabled'] == true)?true:false; 
        if(empty($disabled)){
            $disabled = false;
        }

        // elenxei ta dikaiomata
        $permDeny = 0;
        if(!empty($table)){
            
            if(!pegasus_profile_check_data_permission($table , 'SHOW' , $_SESSION['user_profile'])){
                $permDeny = 1;
            }
        }
        
        if(  !pegasus_profile_check_module_permission($module, $_SESSION['user_profile']) ){
            $permDeny = 1;
        }
        
        if ($permDeny==0){
            if(!empty($arr1['_d'])){
                if(empty($title)){
                    $title = findScreenTitle( $module , $arr1['_d'] );
                    $mob_title = findScreenTitle( $module , $arr1['_d'] ,'',0,1);
                    if(empty($title)){
                        $title = $arr1['_d'];
                    }
                }

                $item['module'] = $module;
                $item['_d'] = $arr1['_d'];
                $item['table'] = $table; 
                $item['parent_id'] = $maincontainer_id;
                $item['id'] =  pegasus_container_id_create($maincontainer_id , session_id()  );
                $item['nr01'] = $nr01;
                $item['mnr01'] = $nr01;
                $item['mmnr01'] = $main_d . '-' . $main_nr01;  
                if(!empty($arr1['mmnr01'])){
                    $item['mmnr01'] =$arr1['mmnr01'];
                } 
                if(($arr1['load_on_render']=='1') || $i==1){
                    
                    $screen = new Peg002_ScreenData(); 
                    $screen->set_displayType($_REQUEST['display_type']);
                    $screen->set_parent_id($item['parent_id']);
                    $screen->set_container_id(pegasus_container_id_create($item['id'] , session_id()  , $item['_d']) );
                    $screen->set_initialize($_REQUEST['initialize']);
                    $screen->set__d($item['_d']);
                    $screen->set_table($item['table']);
                    $screen->set_module($item['module']);
                    $screen->set_mmnr01($item['mmnr01']);
                    $screen->set_mnr01($item['mnr01']);
                    $screen->set_nr01($item['nr01']); 
                    
                    $screen->set_peg_request_data_from_grid($_REQUEST['peg_request_data_from_grid']);
                    $screen->set_rec_copy_nr01($_REQUEST['rec_copy_nr01']);
                    
                    $screen->set_peg_mainForm($_REQUEST['peg_mainForm']);
                    $screen->set_peg_loadData($_REQUEST['peg_loaddata']);
                    
                    $screen->set_peg_mainTable($item['table']);
                    
                    $screen->validateRequest();
                    $display_type   = $screen->get_displayType();
                    
                    $_d             = $screen->_d;
                    $initialize     = $screen->initialize ;
                    
                    $peg_request_data_from_grid = $screen->peg_request_data_from_grid ;
                    
                    
                    $mmnr01         = $screen->mmnr01 ;
                    $mnr01          = $screen->mnr01;
                    $nr01           = $screen->nr01 ;
                    
                    $container_id   = $screen->container_id;
                    
                    $rec_new        = $screen->rec_new;
                    $rec_copy_nr01  = $screen->rec_copy_nr01;
                    $table          = $screen->table;
                    $module         = $screen->module;
                    
                    $peg_is_newrec  = $screen->get_rec_new(); 
                    
                    $view_table     = $screen->view_table;
                    $view_module    = $screen->view_module;  
                    
                    // $query  = $screen->get_screenFieldQuery(); 
                    $retAr =  $screen->get_screenFieldCache(); 
                    $tmpArray00 = $retAr['noeval'];
                    $typeArray = $retAr['types'];
                     
                     
                     
                    
                    $items_array['tabs'][] = $screen;
                    
                    if (is_array($tmpArray00)){
                        $items_array['noeval']  = array_merge($items_array['noeval'],$tmpArray00 );
                    }
                    if (is_array($typeArray)){
                        $items_array['type']= array_merge($items_array['type'],$typeArray  );
                    } 
                    $item['itemContainte_id']  = $container_id; 
                }
                
            }
            
            
            $item['peg_tabTitle'] = $title;
            $item['peg_tabTitle_mob'] = $mob_title;
            $item['peg_tabIcon'] = $icon;
            
            $item['disabled'] = $disabled; 
            $item['iconCls'] = $iconCls;
            
            
            
            $items_array['items'][] = $item;
        }
        
        
        
    }
    
    return $items_array;
    
}  
/**
 * Used by tab Items
 */
function peg002_create_screen_array($query, $module, $_d, $container_id, $parent_id, $mnr01, $mmnr01, $nr01){
    
    $p62p00valid = $GLOBALS['p62p00valid']; 
    
    $show_d = $_d;
    $global_array= array( 
        'data' => array()
    );
    $structureData = array(); 
    $query = str_replace(
        array('##LANG##', '##module##', '##_d##' ),
        array($GLOBALS['userCookie']->getLang(),$module,$show_d ),
        $query); 
        
    $lastType = 'screen';//panta einai to proto screen
    $lastName= 'screen';
    $tmpArray = array();
    
    // echo $query;
    
    $rs = Peg002_MySQL::pegasus_query(
        $query,
        array(
            'module' => $module,
            '_d'=> $show_d
        )
    );
    while ($row = pegasus_fetch_assoc($rs)){
        if(empty($row['par_nm'])){
            $row['code'] = 0;
        }
        
        if($row['code'] == 1 ){
            $string = $row['par_val'];
            $name = $row['desc05'];
  
        //    print_r($row);
        //     if($_REQUEST['stv'] == 1){
        //         print_r($row);
        //     }
            
            $response = @eval($string);
            if ( $response === false && ($error = error_get_last()) ) {
                if(pegasus_displayErrors()){
                    echo $name .'\n- '.$row['par_nm']. '-\n'. $string . "\n";
                    var_dump($error);
                }
                die('Error eval peg002_create_screen_array');
            }else{
                $row['par_val'] = $response;
                $row['code'] = 0;
            }
            $name = '';
            
        }
        
        
        if($lastName != $row['desc05']){
            
            $structureData[]  = peg002_validateElement($lastType, $tmpArray);
             
            $lastName = $row['desc05'];
            $lastType = $row['desc07'];
            $tmpArray = array();
        }
        $tmpArray[] = $row;
    }
    
    $structureData[] = peg002_validateElement($lastType, $tmpArray);

    
    $global_array['data'] = $structureData;
    
    return $global_array;
}


function peg002_create__d_fields(&$array){
    $ret_array = array();
    
    $field_type = array('textbox','numberbox','checkbox','combobox','comboboxV2','radio','textarea','codemirror','datebox','tinymce','selectbox','timefield','multi_selectbox','colorpicker');
    
    $lastType = 'screen';//panta einai to proto screen
    $tmpArray = null;
    $lastName = null;
    foreach ($array as $row){
        if($lastName != $row['desc05']){
            
            if(is_array($tmpArray) && $tmpArray['hidden']!=1){
                
                if(in_array($lastType, $field_type )){
                    
                    $ret_array[] = peg002_get_field($tmpArray, $lastName);
                    if($lastType=='selectbox' || $lastType=='comboboxV2'){
                        
                        $ret_array[] = peg002_get_field(
                            array(
                                'type' => 'C', 
                                // 'size' => $tmpArray['size'],
                                // 'desc07' =>  $tmpArray['desc07']
                            ), 'dias_var_' . $lastName);
                    }
                }elseif ($lastType == 'tab' && is_array($tmpArray['items_array']) && count($tmpArray['items_array'])>0){
                    
                    foreach ($tmpArray['items_array'] as $subscreen){
                        if(is_array($subscreen) && is_array($subscreen['screen_data'])){
                            $tmpArray = peg002_create__d_fields($subscreen['screen_data']['data']);
                            $ret_array = array_merge($ret_array, $tmpArray);
                        }
                    }
                }
            }
            
            
            
            $lastName = $row['desc05'];
            $lastType = $row['desc07'];
            $tmpArray = array();
            $tmpArray['desc07'] =  $row['desc07'];
            $tmpArray['type'] =  $row['desc16'];
            if($row['desc17']>0 && $row['desc16']!='M'){
                $tmpArray['size'] =  $row['desc17'];
            }
           
            $tmpArray['dec'] =  $row['desc18'];
        }
        
        $tmpArray[$row['par_nm']] = $row['par_val'];
    }
    if($tmpArray['hidden']!=1){
        
        if(in_array($lastType, $field_type )){
            
            $ret_array[] = peg002_get_field($tmpArray, $lastName);
            if($lastType=='selectbox' || $lastType=='comboboxV2'){
                
                $ret_array[] = peg002_get_field(
                    array(
                        'type' => 'C', 
                        // 'size' => $tmpArray['size'],
                        // 'desc07' =>  $tmpArray['desc07']
                    ), 'dias_var_' . $lastName);
            }
        }elseif ($lastType == 'tab' && is_array($tmpArray['items_array']) && count($tmpArray['items_array'])>0){
            
            foreach ($tmpArray['items_array'] as $subscreen){
                if(is_array($subscreen) && is_array($subscreen['screen_data'])){
                    $tmpArray = peg002_create__d_fields($subscreen['screen_data']['data']);
                    $ret_array = array_merge($ret_array, $tmpArray);
                }
            }
        }
    }
    return $ret_array;
}
function peg002_get_field($typeAr, $name){
    switch (strtoupper($typeAr['type'])) {
        case 'C':
            if(isset($typeAr['desc07']) && $typeAr['desc07']=='timefield'){
                $dateFormat = 'H:i';
                if($typeAr['size']>6){
                    $dateFormat = 'H:i:s';
                }
                return array(
                    'name'  => $name ,
                    'type'  => 'date',
                    'dateFormat' => $dateFormat       
                );
            }else{
                return array(
                    'name' => $name ,
                    'type' => 'string'
                );
            }
            break;
        case 'D':
            return array(
                    'name'  => $name ,
                    'type'  => 'date',
                    'dateFormat' =>  'Y-m-d'
                );
            break;
        case 'L':
            return array(
                'name' => $name ,
                'type' => 'boolean'
                );
            break;
        case 'M':
            return array(
                'name' => $name
            );
            break;
        case 'N':
            return array(
                'name' => $name ,
                'type' => 'number'
                );
            break;
        case 'V':
            return array(
                'name' => $name
            );
            break;
        case 'X':
            return array(
                'name' => $name
            );
            break;
        default:
            return array(
                'name' => $name
            );
            break;
    }
}
function peg002_removeCoreCode($str){
    $startComment = '/*core_begin*/';
    $endComment = '/*core_end*/';
    while (strrpos($str, $startComment) !== false && strrpos($str, $endComment) !== false ) {
        $start 		= mb_strripos($str , $startComment,0, 'UTF-8') ; //find_last_pos($data_contents , $productStart);
        $end   		= mb_strripos($str , $endComment,0, 'UTF-8')  + mb_strlen($endComment, 'UTF-8');// find_last_pos($data_contents , $productEnd);
        $tmpstr     = mb_substr($str, $start, $end-$start , 'UTF-8');
        $str        = str_replace($tmpstr, '',$str);
    }
    return $str;
}

function peg002_comboboxV2_where(){
    $peg_where= '';    
    $container_id= $_REQUEST['container_id'];
    foreach ($_REQUEST as $key => $value) {
        if(substr($key , 0 , 9) == 'dias_fld_'){
            $data[str_replace('dias_fld_', '', $key)] = $value;
        }
    }
    $peg_select = " select * from p52 where p02 = :p02 and module= :module and desc05= :desc05 and par_nm='where' ;";
    $res = pegasus_query(
        $peg_select,
        array(
            'p02' =>    $_REQUEST['_d'],
            'module' => $_REQUEST['module'],
            'desc05' => $_REQUEST['name']
        )
    );
    while($peg_p52 = pegasus_fetch_assoc($res)){
        if($peg_p52['code']==1){
            if(!empty($peg_p52['par_val_js'])){
                ${'peg_' . $peg_p52['par_nm']} = eval($peg_p52['par_val_js']);
            }else{
                ${'peg_' . $peg_p52['par_nm']} = eval($peg_p52['par_val']);
            }
        }else{
            if(!empty($peg_p52['par_val_js'])){
                ${'peg_' . $peg_p52['par_nm']} = $peg_p52['par_val_js'];
            }else{
                ${'peg_' . $peg_p52['par_nm']} = $peg_p52['par_val'];
            }
            
        }
    }
    
    if(empty($peg_where)){
        return '';
    }
    
    
    return $peg_where;
}

//XXX Start Screen Function 
function peg_peg002__peg002_newfolder_d_initialize($data,$mmnr01 = '',$mnr01 = '',$_d = '',$container_id = ''){
    $data['_file_type'] = '';
    $data['_file_path'] = '../../images/';
    
     
    
    if(
        !empty($_REQUEST['filetype']) &&
        (
            $_REQUEST['filetype'] == 'file' ||
            $_REQUEST['filetype'] == 'image'
            )
        ){
            $data['_file_type'] = $_REQUEST['filetype'];
    }else{
        $data['errormsg'] ='Invalid file type';
        $data['readonly'] = 1;
    }
    
    if(!empty($_REQUEST['currentvalue'])){
        $currentvalue = trim($_REQUEST['currentvalue']);
        if(strpos($currentvalue, '/images/') === 0 ){
            $currentvalue = '../..'.$currentvalue;
        }
        
        if(strpos($currentvalue, '../../images/') === 0 && file_exists($currentvalue)){
            $data['_file_path'] = $currentvalue;
        }
        
    }
    return $data;
}
function peg_peg002__peg002_upload_d_initialize($data,$mmnr01 = '',$mnr01 = '',$_d = '',$container_id = ''){
    $data['_file_type'] = '';
    $data['_file_path'] = '../../images/';
    
    if(!empty($_REQUEST['field_name'])){
        $data['_field_name']  = pegasus_mysql_real_escape_string($_REQUEST['field_name']);
    }else{
       $data['errormsg'] ='Invalid field name'; 
       $data['readonly'] = 1;
    }
    
    if(
        !empty($_REQUEST['filetype']) &&
        (
            $_REQUEST['filetype'] == 'file' ||    
            $_REQUEST['filetype'] == 'image' 
        )
    ){
        $data['_file_type'] = $_REQUEST['filetype'];
    }else{
        $data['errormsg'] ='Invalid file type'; 
        $data['readonly'] = 1;
    }
   
    if(!empty($_REQUEST['currentvalue'])){
        $currentvalue = trim($_REQUEST['currentvalue']);
        if(strpos($currentvalue, '/images/') === 0 ){
            $currentvalue = '../..'.$currentvalue;
        }
        
        if(strpos($currentvalue, '../../images/') === 0 && file_exists($currentvalue)){
            $data['_file_path'] = $currentvalue;
        }
        
    } 
    return $data;
   
}
 
function peg_peg002__peg002_filemanager_d_initialize($data,$mmnr01 = '',$mnr01 = '',$_d = '',$container_id = ''){
    $data['_file_type'] = '';
    $_file_path = '/images/';
    if(!empty($_SESSION['cor000_f_path'])){
        $_file_path .=trim($_SESSION['cor000_f_path'],'/\\').'/';
    }
    $data['_file_path'] = '../..'.$_file_path;
    
    if(!empty($_REQUEST['field_name'])){
        $data['_field_name']  = pegasus_mysql_real_escape_string($_REQUEST['field_name']);
    } 
    
    if(
        !empty($_REQUEST['filetype']) &&
        (
            $_REQUEST['filetype'] == 'file' ||
            $_REQUEST['filetype'] == 'image'
            )
        ){
            $data['_file_type'] = $_REQUEST['filetype'];
    }else{
        $data['errormsg'] ='Invalid file type';
        $data['readonly'] = 1;
    }
    $data['url']=$_REQUEST['_file_path'];
    if(!empty($_REQUEST['_file_path'])){
        $currentvalue = trim($_REQUEST['_file_path']);
        if(strpos($currentvalue, $_file_path) === 0 ){
            $currentvalue = '../..'.$currentvalue;
        }
        // var_dump($currentvalue);
        if(strpos($currentvalue, '../..'.$_file_path) === 0 && file_exists($currentvalue)){
            if(is_file($currentvalue)){
                $currentvalue=dirname($currentvalue);
            }
            $data['_file_path'] = $currentvalue;
        }
        
    } 
    $data['active_path_disp']=$_file_path;
    return $data;
}
function peg_peg002__comboboxV2_grid_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
    if($_d=='_selectbox_grid_d'){
        peg_peg002__comboboxV2_grid_d_setGlobalWhere($data,$mmnr01,$mnr01,$_d,$container_id);
        
        $data['grid_quickfind_hidden'] = false;
        $data['grid_rowchange_hidden'] = true;
    }
    return $data;
}

function peg_peg002__comboboxV2_grid_d_setGlobalWhere($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
    if($_d=='_comboboxV2_grid_d'){
        global $PegInput;
        $PegInput->addVar(new peg_input_alphanumeric('dias_selectbox_d'));
        $PegInput->addVar(new peg_input_alphanumeric('dias_selectbox_module'));
        $PegInput->addVar(new peg_input_alphanumeric('dias_selectbox_desc05'));

        $dias_selectbox_d       = $PegInput->getRequest('dias_selectbox_d');
        $dias_selectbox_module  = $PegInput->getRequest('dias_selectbox_module');
        $dias_selectbox_desc05  = $PegInput->getRequest('dias_selectbox_desc05');
        
        $peg_select = " select * from p52 where p02 = :p02 and module= :module and desc05= :desc05 and ( par_nm='displayField'  or par_nm='valueField' or par_nm='where_array') ";

        $res = pegasus_query(
            $peg_select,
            array(
                'p02' => $dias_selectbox_d,
                'module' => $dias_selectbox_module,
                'desc05' => $dias_selectbox_desc05
            )
        );
        while($p52 = pegasus_fetch_assoc($res)){
            
            
            if(!empty($p52['par_val_js'])){
                if ($_SESSION['lang']=='EN' and !empty($p52['epar_val_js'])){
                    $par_val = $p52['epar_val_js'];
                }else {
                    $par_val = $p52['par_val_js'];
                }
                
            }elseif ($_SESSION['lang']=='EN' and !empty($p52['epar_val'])){
                $par_val = $p52['epar_val'];
            }else{
                $par_val = $p52['par_val'];
            }
            
            
            if($p52['code']==1){ 
                $name = $p52['desc05'];
                ${'peg_' . $p52['par_nm']} = eval($par_val);
                $name = '';
            }else{
                ${'peg_' . $p52['par_nm']} = $par_val;
            }

        }
        
        
        $PegInput->addVar(new peg_input_number('dias_no_search'));
        if($PegInput->getRequest('dias_no_search')!=1){	
            $PegInput->addVar(new peg_input_alphanumeric('dias_fld_dias_var_' . $dias_selectbox_desc05));
            $_dias_fld_dias_var_desc05_value=$PegInput->getRequest('dias_fld_dias_var_' . $dias_selectbox_desc05);
            if(!empty($_dias_fld_dias_var_desc05_value)){
                $array00 = pegasusGetGlobalVar( 'gridData_' . $container_id . '_grid_where_array' ); 
                if(empty($array00)){
                    $array00 = array();
                }
                
                $array01 = array();
                $array01['name']    = $peg_displayField ;
                
                $array01['db_type'] = 'C';
                
                if(substr($_dias_fld_dias_var_desc05_value ,  0 , 1 )=='~' or
                    substr($_dias_fld_dias_var_desc05_value ,  0 , 1 )=='='  ){
                        
                        $array01['value']   = substr($_dias_fld_dias_var_desc05_value , 1  );
                        $array01['mode']    = substr($_dias_fld_dias_var_desc05_value , 0 , 1 );
                        
                }else{
                    $array01['value']   = $_dias_fld_dias_var_desc05_value;
                    $array01['mode']    = '';
                } 
                array_push($array00 ,$array01); 
                pegasusSetGlobalVar( 'gridData_' . $container_id . '_grid_where_array' ,  $array00 );
                
            }
        }
    }
}
function peg_peg002__comboboxV2_grid_d_p52_groupby(){
    global $PegInput;
    $data = array();
    foreach ($_REQUEST as $key => $value) {
        if(substr($key , 0 , 9) == 'dias_fld_'){
            $PegInput->addVar(new peg_input_alphanumeric($key));
            $data[str_replace('dias_fld_', '', $key)] = $PegInput->getRequest( $key );
        }
    }
    
    $PegInput->addVar(new peg_input_alphanumeric('dias_selectbox_d'));
    $PegInput->addVar(new peg_input_alphanumeric('dias_selectbox_module'));
    $PegInput->addVar(new peg_input_alphanumeric('dias_selectbox_desc05'));

    $dias_selectbox_d       = $PegInput->getRequest('dias_selectbox_d');
    $dias_selectbox_module  = $PegInput->getRequest('dias_selectbox_module');
    $dias_selectbox_desc05  = $PegInput->getRequest('dias_selectbox_desc05');
    
    $peg_groupby= '';
    
    
    
    $peg_select = " select * from p52 where p02 = :p02 and module= :module and desc05= :desc05 and par_nm='groupby' ";
    $res = pegasus_query(
        $peg_select, 
        array(
            'p02' => $dias_selectbox_d, 
            'module' => $dias_selectbox_module,
            'desc05' => $dias_selectbox_desc05
        )
    );
    while($peg_p52 = pegasus_fetch_assoc($res)){
        if($peg_p52['code']==1){
            if(!empty($peg_p52['par_val_js'])){
                ${'peg_' . $peg_p52['par_nm']} = eval($peg_p52['par_val_js']);
            }else{
                ${'peg_' . $peg_p52['par_nm']} = eval($peg_p52['par_val']);
            }
        }else{
            if(!empty($peg_p52['par_val_js'])){
                ${'peg_' . $peg_p52['par_nm']} = $peg_p52['par_val_js'];
            }else{
                ${'peg_' . $peg_p52['par_nm']} = $peg_p52['par_val'];
            }
            
        }
    }
    
    if(empty($peg_groupby)){
        return '';
    }
    
    return $peg_groupby; 
}
function peg_peg002__comboboxV2_grid_d_p52_orderby(){
    global $PegInput;
    $data = array();
    foreach ($_REQUEST as $key => $value) {
        if(substr($key , 0 , 9) == 'dias_fld_'){
            $PegInput->addVar(new peg_input_alphanumeric($key));
            $data[str_replace('dias_fld_', '', $key)] = $PegInput->getRequest( $key );
        }
    }
    
    $PegInput->addVar(new peg_input_alphanumeric('dias_selectbox_d'));
    $PegInput->addVar(new peg_input_alphanumeric('dias_selectbox_module'));
    $PegInput->addVar(new peg_input_alphanumeric('dias_selectbox_desc05'));
    $PegInput->addVar(new peg_input_alphanumeric('dias_container_id')); 

    $dias_selectbox_d       = $PegInput->getRequest('dias_selectbox_d');
    $dias_selectbox_module  = $PegInput->getRequest('dias_selectbox_module');
    $dias_selectbox_desc05  = $PegInput->getRequest('dias_selectbox_desc05');
    $container_id           = $PegInput->getRequest('dias_container_id');
    $peg_orderby= '';    
    
    $peg_select = " select * from p52 where p02 = :p02 and module= :module and desc05= :desc05 and par_nm='orderby' ";
    $res = pegasus_query(
        $peg_select, 
        array(
            'p02' => $dias_selectbox_d,
            'module' => $dias_selectbox_module,
            'desc05' => $dias_selectbox_desc05
        )
    );
    while($peg_p52 = pegasus_fetch_assoc($res)){
        if($peg_p52['code']==1){
            if(!empty($peg_p52['par_val_js'])){
                ${'peg_' . $peg_p52['par_nm']} = eval($peg_p52['par_val_js']);
            }else{
                ${'peg_' . $peg_p52['par_nm']} = eval($peg_p52['par_val']);
            }
        }else{
            if(!empty($peg_p52['par_val_js'])){
                ${'peg_' . $peg_p52['par_nm']} = $peg_p52['par_val_js'];
            }else{
                ${'peg_' . $peg_p52['par_nm']} = $peg_p52['par_val'];
            }
            
        }
    }
    $dynamic_orderby_fun_name=$dias_selectbox_module.'_'.$dias_selectbox_d.'_comboboxV2_dynamic_fields_orderby';
    if(function_exists($dynamic_orderby_fun_name)){
        $dynamic_orderbyArr=$dynamic_orderby_fun_name($dias_selectbox_desc05,$container_id);
        $dynamic_orderby='';
        if(is_array($dynamic_orderbyArr)){
            $dynamic_orderby=$dynamic_orderbyArr['sql'];
        }else{
            $dynamic_orderby=$dynamic_orderbyArr;
        }
        $peg_orderby=$dynamic_orderby;
    }
    if(empty($peg_orderby)){
        return '';
    }
    
    
    return $peg_orderby;
}
function peg_peg002__comboboxV2_grid_d_p52_query(){
    global $PegInput;
    $data = array();
    foreach ($_REQUEST as $key => $value) {
        if(substr($key , 0 , 9) == 'dias_fld_'){
            $PegInput->addVar(new peg_input_alphanumeric($key));
            $data[str_replace('dias_fld_', '', $key)] = $PegInput->getRequest( $key );
        }
    }
    
    $PegInput->addVar(new peg_input_alphanumeric('dias_selectbox_d'));
    $PegInput->addVar(new peg_input_alphanumeric('dias_selectbox_module'));
    $PegInput->addVar(new peg_input_alphanumeric('dias_selectbox_desc05'));
    $PegInput->addVar(new peg_input_alphanumeric('container_id'));

    $dias_selectbox_d       = $PegInput->getRequest('dias_selectbox_d');
    $dias_selectbox_module  = $PegInput->getRequest('dias_selectbox_module');
    $dias_selectbox_desc05  = $PegInput->getRequest('dias_selectbox_desc05');

    $container_id           = $PegInput->getRequest('container_id');
    
    $peg_query= '';
    $peg_table= '';
    
    $peg_select = " select * from p52 where p02 = :p02 and module= :module and desc05= :desc05 and ( par_nm='query' or par_nm='table') ";
    $res = pegasus_query(
        $peg_select,
        array(
            'p02' => $dias_selectbox_d,
            'module' => $dias_selectbox_module,
            'desc05' => $dias_selectbox_desc05
        )
    );
    while($peg_p52 = pegasus_fetch_assoc($res)){
        
        
        if($peg_p52['code']==1){
            if(!empty($peg_p52['par_val_js'])){
                ${'peg_' . $peg_p52['par_nm']} = eval($peg_p52['par_val_js']);
            }else{
                ${'peg_' . $peg_p52['par_nm']} = eval($peg_p52['par_val']);
            }
        }else{
            if(!empty($peg_p52['par_val_js'])){
                ${'peg_' . $peg_p52['par_nm']} = $peg_p52['par_val_js'];
            }else{
                ${'peg_' . $peg_p52['par_nm']} = $peg_p52['par_val'];
            }
            
        }
    }
    
    if(empty($peg_query) and empty($peg_table)){
        return '';
    }
    
    $peg_query00='';
    $peg_queryParams=array();
    if(!empty($peg_query)){
        if (is_array($peg_query)) { 
            if (is_array($peg_query['sqlParams'])) {
                $peg_queryParams = array_merge($peg_queryParams, $peg_query['sqlParams']);  //$www['sqlParams'] must be associative array
            }
            $peg_query =  $peg_query['sql'];
        } else {
            $peg_query = $peg_query;
        }
        
        $peg_query = str_replace(';' , '' , $peg_query);
        $peg_query00 =  "select * from (" . $peg_query . ") as tbl";
    }
    return array('sql'=>$peg_query00,'sqlParams'=>$peg_queryParams);
    
    
}
function peg_peg002__comboboxV2_grid_d_p52_where(){
    $data = array();    
    global $PegInput;
    foreach ($_REQUEST as $key => $value) {
        if(substr($key , 0 , 9) == 'dias_fld_'){
            $PegInput->addVar(new peg_input_alphanumeric($key));
            $data[str_replace('dias_fld_', '', $key)] = $PegInput->getRequest( $key );
        }
    }
    
    
    $PegInput->addVar(new peg_input_alphanumeric('dias_selectbox_d'));
    $PegInput->addVar(new peg_input_alphanumeric('dias_selectbox_module'));
    $PegInput->addVar(new peg_input_alphanumeric('dias_selectbox_desc05'));
    $PegInput->addVar(new peg_input_alphanumeric('dias_container_id')); 
    $PegInput->addVar(new peg_input_alphanumeric('dias_view_d')); 
    
    $dias_selectbox_d       = $PegInput->getRequest('dias_selectbox_d');
    $dias_selectbox_module  = $PegInput->getRequest('dias_selectbox_module');
    $dias_selectbox_desc05  = $PegInput->getRequest('dias_selectbox_desc05'); 
    $dias_view_d  = $PegInput->getRequest('dias_view_d'); 

    $container_id           = $PegInput->getRequest('dias_container_id');
    
    $peg_where= '';
    
    
    
    $peg_select = " select * from p52 where p02 = :p02 and module= :module and desc05= :desc05 and par_nm='where' ;";
    $res = pegasus_query(
        $peg_select,
        array(
            'p02' => $dias_selectbox_d,
            'module' => $dias_selectbox_module,
            'desc05' => $dias_selectbox_desc05
        )
    );
    while($peg_p52 = pegasus_fetch_assoc($res)){
        if($peg_p52['code']==1){
            if(!empty($peg_p52['par_val_js'])){
                ${'peg_' . $peg_p52['par_nm']} = eval($peg_p52['par_val_js']);
            }else{
                ${'peg_' . $peg_p52['par_nm']} = eval($peg_p52['par_val']);
            }
        }else{
            if(!empty($peg_p52['par_val_js'])){
                ${'peg_' . $peg_p52['par_nm']} = $peg_p52['par_val_js'];
            }else{
                ${'peg_' . $peg_p52['par_nm']} = $peg_p52['par_val'];
            }
            
        }
    }
    $dynamic_where_fun_name=$dias_selectbox_module.'_'.$dias_selectbox_d.'_comboboxV2_dynamic_fields_where';
    if(function_exists($dynamic_where_fun_name)){
        $dynamic_whereArr=$dynamic_where_fun_name($dias_selectbox_desc05,$container_id);
        $dynamic_where='';
        $dynamic_whereParams=array();
        if(is_array($dynamic_whereArr)){
            $dynamic_where=$dynamic_whereArr['sql'];
            $dynamic_whereParams=$dynamic_whereArr['sqlParams'];
        }else{
            $dynamic_where=$dynamic_whereArr;
        }
        if(empty($peg_where)){
            $peg_where00='1=1';
            $peg_whereParams00=array();
        }else{
            if(is_array($peg_where)){
                $peg_where00=$peg_where['sql'];
                $peg_whereParams00=$peg_where['sqlParams'];
            }else{ 
                $peg_where00=$peg_where;
                $peg_whereParams00=array();
            }
        }

        if(!empty($dynamic_where)){ 
            $peg_where00="( $peg_where00 ) AND ( $dynamic_where )";
            if(is_array($dynamic_whereParams)){
                $peg_whereParams00=array_merge($peg_whereParams00,$dynamic_whereParams);
            }
        }
        $peg_where=array(   'sql'           =>  $peg_where00 ,
                            'sqlParams'     =>  $peg_whereParams00  );
    }
    if(function_exists('peg_selectbox_grid_d_extra_where')){
        return peg_selectbox_grid_d_extra_where($peg_where,$dias_view_d);
    }
    if(empty($peg_where)){
        return '';
    }
    
    
    return $peg_where;
}
//XXX End Screen Function

//XXX Start Grid Data Function
function peg002_make_grid_where($where_array , $table){
//  var_dump($where_array);
    $wwhr='';
    $whereParams = array(); 
    $having='';
    $havingParams=array();
    $paramcounteri = 0;
	foreach ($where_array as $wh){
		$where_table00 = $table;
		$where_name00 = $wh['name'];
		if(strpos($wh['name'] ,'.')>0){
			$tr_fld = explode('.' , $wh['name']);
			$where_table00 = $tr_fld[0];
			$where_name00  = $tr_fld[1];
        }
        // var_dump($where_name00);
		// print_r($wh);
		if(!empty($where_name00)){	
			if(empty($wh['db_type'])){
			    if($wh['type']=='textbox' or $wh['type']=='textarea' or $wh['type']=='tinymce' or $wh['type']=='timefield'or $wh['type']=='codemirror'){
					$wh['db_type'] = 'C';
				}elseif ($wh['type']=='checkbox'){
					$wh['db_type'] = 'L';
				}elseif ($wh['type']=='numberbox'){
					$wh['db_type'] = 'N';
				}elseif ($wh['type']=='datebox'){
					$wh['db_type'] = 'D';
				}elseif ($wh['type']=='comboboxV2' or $wh['type']=='combobox' or $wh['type']=='selectbox'){
					$wh['db_type'] = 'C';
					$wh['mode'] = '=';
				}
				
			}
	 
 
			
			if(!empty($wh['in_fld'])){
				if (!empty($wwhr)) {
					$wwhr .= ' and ';
				}
										
				$where_value00_arr = explode(',' , $wh['in_fld']);
				$where_value00 = '';
				foreach ($where_value00_arr as $wh_val){
					if(!empty($where_value00)){
						$where_value00 .= ' , '; 
					}		
                    $where_value00 .= ':param'.$paramcounteri; 
                    if(strpos($wh_val,'/')!=false){
                        $wh_val_arr=explode('/',$wh_val);
                        $wh_val=$wh_val_arr[2].'-'.$wh_val_arr[1].'-'.$wh_val_arr[0];
                    }   
                    
                if($wh['having']){
                    $havingParams['param'.$paramcounteri] = $wh_val; 
                }else{
                    $whereParams['param'.$paramcounteri] = $wh_val; 

                }
                    ++$paramcounteri ;
				}
                $fld_name='';
                if($wh['having']){
                    $fld_name=$where_name00; 
                }else{
                    $fld_name=$where_table00  . '.' .  $where_name00 ; 
                }
                $where_in= $fld_name.' in (' .$where_value00 . ')' ;
                if($wh['not'] ==1 ){
                    $where_in = ' not ('. $where_in .')' ;
                }
                
                if($wh['having']){
                    $having.= $where_in ; 
                }else{
                    $wwhr .=  $where_in ;
                }
				//$wwhr .= '   ';
				///$wwhr .=  '(' .$where_value00 . ')' ;
					
			 }else{
                if($wh['having']){
                    $where_table00=''; 
                }
				if($wh['db_type'] == 'C'){   
                    if( $wh['type']=='timefield' ){
                        $peg002CondAr = peg002_cond($paramcounteri, $where_table00 , $where_name00 ,$wh['value'] , 'C' ,  $wh['value1']);
                    }else{
                        $peg002CondAr = peg002_cond($paramcounteri, $where_table00 , $where_name00 ,( $wh['mode']  .$wh['value'] ) , 'C' ,  $wh['value1']);
					
                    }
					// echo 'test/' . print_r($wh ,true) . '/test';
					// print_r($peg002CondAr );
				}elseif ($wh['db_type'] == 'L'){	 
					$peg002CondAr = peg002_cond($paramcounteri, $where_table00 , $where_name00 ,  $wh['value']  , 'L' );
				}elseif ($wh['db_type'] == 'N'){ 
					$peg002CondAr = peg002_cond($paramcounteri, $where_table00 , $where_name00 ,  $wh['value']  , 'N',  $wh['value1'] ); 
				}elseif ($wh['db_type'] == 'D'){
					
					$peg002CondAr = peg002_cond($paramcounteri, $where_table00 , $where_name00 ,  $wh['value']  , 'D',  $wh['value1'] );
                }

                if(is_array($peg002CondAr) && !empty($peg002CondAr['where'] )){

                    if($wh['not'] ==1 ){
                        $peg002CondAr['where'] ="/**/!(".$peg002CondAr['where'].")";
                    }
                    if($wh['having']){
                        if (!empty($having)) {
                            $having .= ' and ';
                        }
                        $having.= $peg002CondAr['where'] ; 
                    }else{
                        if (!empty($wwhr)) {
                            $wwhr .= ' and ';
                        }
                        $wwhr .=  $peg002CondAr['where'] ;
                    }
                    //$whereParams  = array_merge($whereParams ,  $peg002CondAr['whereParams']);
                    foreach ($peg002CondAr['whereParams'] as $key => $value) {
                        if($wh['having']){
                            $havingParams[$key] = $value;
                        }else{
                            $whereParams[$key] = $value;
                        }
                        ++$paramcounteri;
                    }
                   
                    
                }
               
			}
        } 
      
	}	 
	
	return array('where' => $wwhr, 'whereParams' => $whereParams, 'having'  =>  $having , 'havingParams'    =>  $havingParams);
}
function peg002_cond($paramcounteri, $table , $field , $value , $type  , $value1=''){
    $table  = strtolower( trim($table) );
    $type   = strtoupper($type);
    $whereParams = array();
    $having='';
    $havingParams=array();
    // Αυτον ο κωδικα εχει μπει για το PDO το σχολιαζω γιατι δνε μπορουν να παιξουν τα V πεδια π.χ. καθαριμοι ΠΠΥ 2044321
    // if(!pegasus_mysql_table_exists($table) || !pegasus_mysql_table_field_exists($table , $field )){
    //     return;
    // }
    // var_dump($field,$type);

	if ($type=='C' or $type=='M' or $type=='V') {
        // var_dump($field);
		if(!empty($value1)){
            $v_name='peg002_cond_'.$paramcounteri.'_'.$table . '_' . $field;
		    $where =  (!empty($table)?$table. '.' : '' )  . $field . '>=:'.$v_name.' ';
            $whereParams[$v_name] = trim($value);
			if(!empty($value1)){
                ++$paramcounteri;
                $v_name='peg002_cond_'.$paramcounteri.'_'.$table . '_' . $field;
                $where = $where . ' and ' .  (!empty($table)?$table. '.' : '' ). $field . '<=:'.$v_name.' ';
                $whereParams[$v_name] = trim($value1);
			}			
		
		}elseif (substr($value,0,1)=='~'){
			if (substr($value,1,1)=='+') {
				$array=pegasus_CrStrArray(trim($value) , ' ' , 2);
				$size=sizeof($array);
				$where='';
				for ($i=0; $i<$size; $i++){
					if ($i==0) {
                        $v_name='peg002_cond_'.$paramcounteri.'_'.$table . '_' . $field;
                        $where =   (!empty($table)?$table. '.' : '' ). $field . ' like :'.$v_name.' ';
                        $whereParams[$v_name] = '%'. trim($array[$i]) . '%';
					}else {
                        ++$paramcounteri;
                        $v_name='peg002_cond_'.$paramcounteri.'_'.$table . '_' . $field;
                        $where = $where . ' and ' . (!empty($table)?$table. '.' : '' ). $field . ' like :'.$v_name.' ';
                        $whereParams[$v_name] = '%'. trim($array[$i]) . '%';
					}
				}
			}elseif (substr($value,1,1)=='-') {
				$array=pegasus_CrStrArray(trim($value) , ' ' , 2);
				$size=sizeof($array);
				$where='';
				for ($i=0; $i<$size; $i++){
					if ($i==0) {
                        $v_name='peg002_cond_'.$paramcounteri.'_'.$table . '_' . $field;
                        $where =   (!empty($table)?$table. '.' : '' ). $field .' like :'.$v_name.' ';
                        $whereParams[$v_name] = '%'. trim($array[$i]) . '%';
					}else {
                        ++$paramcounteri;
                        $v_name='peg002_cond_'.$paramcounteri.'_'.$table . '_' . $field;
                        $where = $where . ' or ' . (!empty($table)?$table. '.' : '' ) . $field . ' like :'.$v_name.' ';
                        $whereParams[$v_name] = '%'. trim($array[$i]) . '%';
					}
				}
			}else {
                $v_name='peg002_cond_'.$paramcounteri.'_'.$table . '_' . $field;
                $where =   (!empty($table)?$table. '.' : '' ) . $field  . '  like :'.$v_name.' ';
                $whereParams[$v_name] = '%'. trim(substr($value,1, (strlen($value)-1) ))  . '%';
			}
		}elseif (substr($value,0,1)=='=') {
            $v_name='peg002_cond_'.$paramcounteri.'_'.$table . '_' . $field;
            if (substr($value,1,1)=='=') {
                $where =   (!empty($table)?$table. '.' : '' ). $field  . ' = :'.$v_name.' ';
                $whereParams[$v_name] =  trim(substr($value,2, (strlen($value)-2) ))  ; 
            }else{
                
				$value=str_replace( '*', '%' ,$value);
				$value=str_replace( '?', '_' ,$value);
                $where =   (!empty($table)?$table. '.' : '' ). $field  . ' like :'.$v_name.' ';
                $whereParams[$v_name] =  trim(substr($value,1, (strlen($value)-1) ))  ;
            } 
		}
		else {
            $v_name='peg002_cond_'.$paramcounteri.'_'.$table . '_' . $field;
            $where =   (!empty($table)?$table. '.' : '' ) . $field . '  like :'.$v_name.' ';
            $whereParams[$v_name] =  trim($value)  . '%';
		}
	}elseif ($type=='N'){
        $v_name='peg002_cond_'.$paramcounteri.'_'.$table . '_' . $field;
        $where =  (!empty($table)?$table. '.' : '' ) . $field  . '>= :'.$v_name.' ';
        $whereParams[$v_name] =  peg_str2Number($value)  ;
	    if( (empty($value1) && ($value1==='0' || $value1===0) ) || !empty($value1)){
            ++$paramcounteri;
            $v_name='peg002_cond_'.$paramcounteri.'_'.$table . '_' . $field;
            $where = $where . ' and ' .  (!empty($table)?$table. '.' : '' ). $field . '<= :'.$v_name.' ';
            $whereParams[$v_name] =  peg_str2Number($value1)  ;
		}
	}elseif ($type=='L'){ 
	    $value = trim($value);
		if($value=='true' or $value==1){
			$value = 1;
		}else{
			$value = 0;
		} 
        $v_name='peg002_cond_'.$paramcounteri.'_'.$table . '_' . $field;
        $where =   (!empty($table)?$table. '.' : '' ) . $field  . '= :'.$v_name.' ';
        $whereParams[$v_name] =  $value  ;
	}elseif ($type=='D'){ 
        $v_name='peg002_cond_'.$paramcounteri.'_'.$table . '_' . $field;
        $where =  (!empty($table)?$table. '.' : '' ) . $field  . '>= :'.$v_name.' ';
        $whereParams[$v_name] =  trim($value) ;
		if(!empty($value1)){
            ++$paramcounteri;
            $v_name='peg002_cond_'.$paramcounteri.'_'.$table . '_' . $field;
            $where = $where . ' and ' . (!empty($table)?$table. '.' : '' ) . $field . '<= :'.$v_name.' ';
            $whereParams[$v_name] =  trim($value1) ;
		}
	}

    return array(
        'where'         =>  $where,
        'whereParams'   =>  $whereParams,
        'having'        =>  $having,
        'havingParams'  =>  $havingParams
    );
	//return trim($table) . '.' . $field . $where;
}
//XXX End Grid Data Function

//XXX Start Caching Function
/**
 * Remove the Cashing 
 */
function peg002_cleanAllCache(){
    return peg002_cleanProfileCache();
}

function peg002_createStoresCache(){
    $ret1 = peg002_createStoreP82();
    $ret2 = peg002_createStoreP95P50store();
    $ret3 = peg002_createStoreP95P55store();

    return ($ret1 && $ret2 && $ret3);
}

/**
 * Remove all _d caches
 */
function peg002_cleanAll_dCache(){
    
    $query = " select * from p95 ";
    $res = Peg002_MySQL::pegasus_query($query);
    while ($row = pegasus_fetch_assoc($res)) {
        $tmpFolder = '../../tmp/profile_'.$row['nr01'].'/';
        if(is_dir($tmpFolder)){ 
            $dir_handle = opendir($tmpFolder);
            if (!$dir_handle){
                continue;
            }

            while($file = readdir($dir_handle)) {
                if ($file != "." && $file != ".." && $file != "store") {
                    if (!is_dir($tmpFolder."/".$file))
                        unlink($tmpFolder."/".$file);
                    else
                        pegasus_delete_directory($tmpFolder.'/'.$file);
                }
            }
            closedir($dir_handle); 
        }
    }
    $tmpFolder = '../../tmp/profile/';
    if(is_dir($tmpFolder)){
        pegasus_delete_directory($tmpFolder);
    }
    return true;
}
/**
 * Clean _d cache
 * @param string $_d (p50.p02)
 * @param number $p95 profile id 
 * @param bool $cleanGridRelations
 * @param array $added
 */
function peg002_clean_dCache($_d, $p95 = 0, $cleanGridRelations = true, $added = array()){
    if(empty($_d)){
        return false;
    }
    pegasus_mysql_use("select nr01, p02, p01, module from p50 where p02 = :_d ", $p50, array('_d' => $_d));
    if(empty($p50)){
        return false;
    }
    if(!empty($p50['p01'])){
        pegasus_query("delete from p73 WHERE var_name LIKE ?",array('griddata_count_'.$p50['p01'].'_%'));
    }
    if($p50['p02'] == 'browse_d00'){
        //thelw na kanw remove olo to cache
        return peg002_clean_profileCache();
    }
    
    $added[] = $p50['p02'];
    
    $query = " select * from p95 ";
    $params = array();
    if( $p95>0 ){
        $query .= " where nr01 = :p95 ";
        $params['p95'] = $p95;
    }
    $res = Peg002_MySQL::pegasus_query(
        $query,
        $params
    );
    while ($row = pegasus_fetch_assoc($res)) {
        
        $tmpFolder = '../../tmp/profile_'.$row['nr01'].'/'.$p50['module'].'/'.$p50['p02'] . '/';
        if(is_dir($tmpFolder)){
            pegasus_delete_directory($tmpFolder);
        }
       
        if($cleanGridRelations){
            $query00 = " select * from p52 where desc07 = 'grid' and par_nm = '_d' and (par_val like '%".$p50['p02']."%' || par_val_js like '%".$p50['p02']."%') ";
            $result = Peg002_MySQL::pegasus_query($query00);
            while ($p52 = pegasus_fetch_assoc($result)) {
                peg002_clean_dCache($p52['p02'] , $row['nr01'] , false, $added);
            } 
        } 
        
       
        $selectP52p02  = "select p02 from p52 where p52.par_nm = 'help_d_string' and p52.par_val like '%".$p50['module']."#".$p50['p02']."%' ";
        
        $resP52p02 = Peg002_MySQL::pegasus_query($selectP52p02);
        while($rowP52p02 = pegasus_fetch_assoc($resP52p02 )){
            $mana_d = $rowP52p02['p02'];
            //$p50['p02']
          
            if(!empty($mana_d) && $p50['p02'] != $mana_d && !in_array( $mana_d, $added)){
                
                peg002_clean_dCache($mana_d, $row['nr01']  , false, $added);
            }
        }
     
        
    }
    if($p50['p02'] == '_login_d'){
        $tmpFolder = '../../tmp/profile/';
        if(is_dir($tmpFolder)){
            pegasus_delete_directory($tmpFolder);
        }
    }
   
    
  
    
    return true;
    
}
/**
 * Remove
 * -- Removes folder
 *      /tmp/profile_{p95.nr01}/
 * -- Removes Super Global vars
 *      peg002_menu_arr_{p95.nr01}_%
 * -- Removes folder
 *      /tmp/profile/
 */
function peg002_cleanProfileCache($p95 = 0){
    
    $query = " select * from p95 ";
    $params = array();
    if( $p95>0 ){
        $query .= " where nr01 = :p95 ";
        $params['p95'] = $p95;
    }
    $res = Peg002_MySQL::pegasus_query($query, $params );
    while ($row = pegasus_fetch_assoc($res)) {
        $tmpFolder = '../../tmp/profile_'.$row['nr01'].'/';
        if(is_dir($tmpFolder)){
            pegasus_delete_directory($tmpFolder);
        }
        $var_name = "peg002_menu_arr_" . $row['nr01'] . "_%" ;
        pegasusUnSetSuperGlobalVar($var_name);
        $var_name = "peg002_help_arr_" . $row['nr01'] . "_%" ;
        pegasusUnSetSuperGlobalVar($var_name);

    }
    $tmpFolder = '../../tmp/profile/';
    if(is_dir($tmpFolder)){
        pegasus_delete_directory($tmpFolder);
    }
    return true;
    
}


/**
 * This function generate cache for table P82 
 * to all profiles
 * return 
 */
function peg002_createStoreP82($lang = ''){
    
    if(empty($lang) ){
        $ret1 = peg002_createStoreP82('GR');
        $ret2 = peg002_createStoreP82('EN');
        return ($ret1 && $ret2);
    }
    $lang = strtoupper($lang);
    if($lang!='GR' && $lang!='EN'){
        return false;    
    }
    
    $retAr =  array('ok' => 1, 'data' =>
        array(
            'dic'  =>'',
            'desc' => ''
        )
    );
    
    
    
    require_once '../peg002_classes/caching_class.php';
    $inArray  = Peg002_Cache::$p82HtmlTagArray;
    $inTagString = Peg002_Cache::$p82HtmlString; 

     
    $data = array();
    $query = peg_read_file('../peg002_sql/store/p82.sql');
    
    $query = str_replace(array('##LANG##' , '##IN##'), array( $lang, $inTagString  ), $query); 
    $res = Peg002_MySQL::pegasus_query($query, $inArray);
    if(pegasus_num_rows($res)<1){
        return false;
    }
    while ($row = pegasus_fetch_assoc($res)) {
        $data[] = $row;
    }
    $retAr['data'] = $data; 
    
    
    $query = " select * from p95 ";
    $res = Peg002_MySQL::pegasus_query($query);
    while ($row = pegasus_fetch_assoc($res)) {
    
        $peg_cacheStore = new Peg002_Cache();
        $peg_cacheStore->set_profile($row['nr01']);
        if($peg_cacheStore->store_has_cache_with_lang('p82store',$lang) ){
            $cacheFile = $peg_cacheStore->get_curCacheFile();
            if(!empty($cacheFile) && strpos($cacheFile, '../../tmp/')===0 && !is_dir($cacheFile)){
                unlink($cacheFile);
            }
        }
      
        
        $peg_cacheStore->store_generate_cache(  $retAr); 
    }
    return true;
}
/**
 * Generates permissions for tables @file "/tmp/profile_{p95.nr01}/store/p95p50store.json"
 * @param number $p95 (p95.nr01) if empty generates all profiles
 * @return boolean
 */
function peg002_createStoreP95P50store($p95 = 0){
    if(empty($p95)){
        $query = " select * from p95 ";
        $res = Peg002_MySQL::pegasus_query($query);
        $ret = true;
        while ($row = pegasus_fetch_assoc($res)) {
            $tmpret = peg002_createStoreP95P50store($row['nr01']);
            $ret = ($ret && $tmpret);
        }
        return $ret;
    }
    $retAr =  array('ok' => 1, 'data' =>
        array(
            'nr01'=>0,
            'p50' => '', 'p95' => 0, 'ins' => 0, 'del' => 0, 'chan' => 0, 'sh' => 0 )
    );
    
    // $profnr01 = pegasus_mysql_printfld('p95', 'nr01', 'nr01 = "'.$p95.'" ' );
    $profnr01 = Peg002_MySQL::pegasus_printfld('p95', 'nr01', 'nr01 = :nr01' , array('nr01' =>$p95 ));
    if(empty($profnr01)){
        return false;
    }
    
    require_once '../peg002_classes/caching_class.php';
    $peg_cacheStore = new Peg002_Cache();
    $peg_cacheStore->set_profile($profnr01);
    if($peg_cacheStore->store_has_cache('p95p50store')){
        $cacheFile = $peg_cacheStore->get_curCacheFile();
        if(!empty($cacheFile) && strpos($cacheFile, '../../tmp/')===0 && !is_dir($cacheFile)){
            unlink($cacheFile);
        }
    }
    $data = array();
    $query = 
        " select ".
            " p95p50.nr01, p95p50.p50,p95p50.p95, p95p50.ins,p95p50.del, p95p50.chan, p95p50.sh ".
        " from p50, p95p50 where p50.p01!='' && p95p50.p50 = p50.p01 and p95p50.p95 = :profnr01 ";
    
    $res = Peg002_MySQL::pegasus_query($query, array('profnr01' => $profnr01));
    // if(pegasus_num_rows($res)<1){
    //     return false;
    // }
    while ($row = pegasus_fetch_assoc($res)) {
        $data[] = $row;
    }
    
    $retAr['data'] = $data;
      
    $peg_cacheStore->store_generate_cache(  $retAr);
    return true;
}
/**
 * Generates permissions for modules @file "/tmp/profile_{p95.nr01}/store/p95p55store.json"
 * @param number $p95 (p95.nr01) if empty generates all profiles
 * @return boolean
 */
function peg002_createStoreP95P55store($p95 = 0){
    if(empty($p95)){
        $query = " select * from p95 ";
        $res = Peg002_MySQL::pegasus_query($query);
        $ret = true;
        while ($row = pegasus_fetch_assoc($res)) {
            $tmpret = peg002_createStoreP95P55store($row['nr01']);
            $ret = ($ret && $tmpret);
        }
        return $ret;
    }
    $retAr =  array('ok' => 1, 'data' =>
        array('nr01' => 0, 'en' => 0, 'p95' => 0, 'module' => '' )
    );
    // $profnr01 = pegasus_mysql_printfld('p95', 'nr01', 'nr01 = "'.$p95.'" ' );
    $profnr01 = Peg002_MySQL::pegasus_printfld('p95', 'nr01', 'nr01 = :nr01' , array('nr01' =>$p95 ));
    if(empty($profnr01)){
        return false;
    }
    
    require_once '../peg002_classes/caching_class.php';
    $peg_cacheStore = new Peg002_Cache();
    $peg_cacheStore->set_profile($profnr01);
    if($peg_cacheStore->store_has_cache('p95p55store')){
        $cacheFile = $peg_cacheStore->get_curCacheFile();
        if(!empty($cacheFile) && strpos($cacheFile, '../../tmp/')===0 && !is_dir($cacheFile)){
            unlink($cacheFile);
        }
    }
    $data = array();
    $query = 
        " select ".
            " p95p55.nr01, p95p55.en,p95p55.p95,p95p55.module ".
        " from p55, p95p55 where p55.en=1 and p95p55.module = p55.p00 and p95p55.p95 = :profnr01 ";
    
    $res = Peg002_MySQL::pegasus_query($query, array('profnr01' => $profnr01));
    // if(pegasus_num_rows($res)<1){
    //     return false;
    // }
    while ($row = pegasus_fetch_assoc($res)) {
        $data[] = $row;
    }
    
    
    $retAr['data'] = $data; 
    $peg_cacheStore->store_generate_cache(  $retAr);
    return true;
    
}
/**
 * Generates permissions for Menu @files 
 *      "/tmp/profile_{p95.nr01}/store/menu_GR.json"
 *      "/tmp/profile_{p95.nr01}/store/menu_EN.json"
 * @param number $p95 (p95.nr01) if empty generates all profiles
 * @return boolean
 */
function peg002_createStoreMenustore($p95 = 0, $lang = 'GR'){
    /* 
    'tax' => 0,
    'title' => '',
    'pcd' => '' ,
    'cd' => '' ,
    'module' => '',
    'act' => '',
    'view_module' => '',
    'view_d' => '',
    'view_table' => '',
    'view_orderby' => '',
    'view_groupby' => '',
    'browse_edit' => '',
    'copy_recs' => '',
    'full_text_searchL' => '',
    'urlparams' => '',
    'meth' => '',
    'iconcls' => '',
    'icon' => '',
    'handler_js' => '' */
    if(empty($p95)){
        $query = " select * from p95 ";
        $res = Peg002_MySQL::pegasus_query($query);
        $ret = true;
        while ($row = pegasus_fetch_assoc($res)) {
            $tmpret00 = peg002_createStoreMenustore($row['nr01'],'GR');
            $tmpret01 = peg002_createStoreMenustore($row['nr01'],'EN');
            $ret = ($ret && $tmpret00 && $tmpret01);
        }
        return $ret;
    }
    
    $retAr =  array('ok' => 1, 'data' =>
        array(  )
    );
    // $profnr01 = pegasus_mysql_printfld('p95', 'nr01', 'nr01 = "'.$p95.'" ' );
    $profnr01 = Peg002_MySQL::pegasus_printfld('p95', 'nr01', 'nr01 = :nr01' , array('nr01' =>$p95 ));
    if(empty($profnr01)){ 
        return false;
    }
    if(!in_array($lang, array('GR', 'EN'))){ 
        return false;
    }
    
    require_once '../peg002_classes/caching_class.php';
    $peg_cacheStore = new Peg002_Cache();
    $peg_cacheStore->set_profile($profnr01);
    $cachefile = 'menu_'.$lang;
    if($peg_cacheStore->store_has_cache($cachefile)){
        $cacheFile = $peg_cacheStore->get_curCacheFile();
        if(!empty($cacheFile) && strpos($cacheFile, '../../tmp/')===0 && !is_dir($cacheFile)){
            unlink($cacheFile);
        }
    }
    $data = peg002_createMenu($p95, $lang);
    // if(count($data) < 1){
    //     return false;
    // }
    
    $retAr['data'] = $data;
    $peg_cacheStore->store_generate_cache(  $retAr);
    return true;
    
}
/* Επιστρέφει το όνομα της superGlobal μεταβλητής χρησιμοποιώντας το όνομα του πίνακα και το ΜΚ του προφίλ */
function peg002_getGriddataTableCountName($table,$profil=''){
    if(empty($profil)){
        $profil=$_SESSION['user_profile'];
    }
    return "griddata_count_".$table."_".$profil;
}

/* Υπολογίζει το count που θα αποθηκεύεται στην μεταβλητή για το δοσμένο query */
function peg002_calculateGriddataTableCount($query='',$queryParams=array()){
    $cnt=array();
    pegasus_mysql_use($query,$cnt,$queryParams);
    return  $cnt['cnt'];
}
/*  Επιστρέφει το count για το δοσμένο πίνακα και query.
    Αν δεν βρεθεί μεταβλητη για τον πίνακα τη δημιουργεί.
    Αν βρεθεί μεταβλητή αλλά δεν βρεθεί εγγραφή για το δοσμένο query τη δημιουργεί.
    Αν βρεθεί εγγραφή για τον πίνακα και το δοσμένο query και έχει περάσει ο χρόνος ζωής της την ενημερώνε εκτελώντας ξανα το query

    Griddata Count Super Global example for table i00 and profile 1:
'griddata_count_i00_1'= array(  array(  'timestamp'   =>  ...,
                                        'query'       => '...',  -> We can have count records for multiple queries
                                        'queryParams' => '....',
                                        'value'       => ...
                                ) ,
                                array( 'timestamp'   =>  ...,
                                        'query'       => '...',
                                        'queryParams' => '....',
                                        'value'       => ...
                                ) ,...
                        )
        ),    
*/
function peg002_getGriddataTableCount($table='',$query='',$queryParams=array()){

    $userProfile=$_SESSION['user_profile'];
    $lifeSpan=(7 * 24 * 60 * 60);   //super global is updated every 7 days
    $varName=peg002_getGriddataTableCountName($table,$userProfile);
    $varValue=pegasusGetSuperGlobalVar($varName);
    if(!empty($varValue) && is_array($varValue)){ // Super grobal is set
        $i=0;
        foreach ($varValue as $rec) {
            if(empty($query)){
                $query="SELECT COUNT(*) as cnt FROM ".$table;
            }
            if($rec['query']==$query && 
                pegasus_replace_values_in_sql($rec['query'],$rec['queryParams'])==pegasus_replace_values_in_sql($query,$queryParams) ){ /* query found */
                $expiration = $rec['timestamp'] + $lifeSpan ; //expiration timestamp
                if($expiration<=time()){    
                    /* Super global for given table and query has expired */
                    return peg002_updateGriddataTableCount($table,$query,$queryParams,$i);
                }else{
                    if($rec['value']<10000){
                        return peg002_calculateGriddataTableCount($rec['query'],$rec['queryParams']);
                    }
                    return $rec['value']; 
                }
            }
            $i++;
        }
        /* Query was not found */
        return peg002_updateGriddataTableCount($table,$query,$queryParams);
    }else{ 
        /* Super Global was not found for given table */
        $x= peg002_updateGriddataTableCount($table,$query,$queryParams);
        return $x;
    }
}
/*  Εκτελεί όλα τα query για όλες τις αποθηκευμένες μεταβλητές των πινάκων της εφαρμογής και ενημερώνει το timestamp
 */
function peg002_updateAllGriddataTableCount($query_limit_start=-1,$log_file=''){
    $query_limit='';
    $ret_arr=array();
    if($query_limit_start >= 0 ){
        $query_limit = "limit ". $query_limit_start.", 10";
    }
    /* Find all existing profiles */
    $query="SELECT var_name 
                FROM p73 
                WHERE var_name LIKE 'griddata_count_%_%'
                ".$query_limit;
    $res=pegasus_query($query);
    while($varName=pegasus_fetch($res)){
        $varValue=pegasusGetSuperGlobalVar($varName['var_name']);
        $ret_arr[]=$varValue;
        $varValue2=array();
        foreach($varValue as $rec){
            $rec['value']=peg002_calculateGriddataTableCount($rec['query'],$rec['queryParams']);
            $rec['timestamp']=time();
            array_push($varValue2,$rec);
        }
        pegasusSetSuperGlobalVar( $varName, $varValue2 );
       
    }
    return $ret_arr;
}
/*  Αν δεν υπάρχει super Global μεταβλητή για το δοσμένο πίνακα και προφιλ τη δημιουργεί
    Αν υπάρχει η μεταβλητή και έχει δοθεί $queryIndex τότε ενημερώνει το count στην εγγραφή αυτή
    Αν υπάρχει μεταβλητή και δεν εχει δοθεί $queryIndex τότε προσθέτει νέα εγγραφή για το δοσμένο query
    Επιστρέφει το count που υπολογίζεται    
*/
function peg002_updateGriddataTableCount($table='',$query='',$queryParams=array(),$queryIndex=-1){
    /* Get superglobal var for given table and user_profile */
    $userProfile=$_SESSION['user_profile'];
    $varName=peg002_getGriddataTableCountName($table,$userProfile);
    $varValue=pegasusGetSuperGlobalVar($varName);

    if(empty($varValue)){ /* Super Global is not set */
        $varValue=array();
        $GriddataTableCountRec=peg002_GriddataTableCountRec($table,$query,$queryParams);
        array_push($varValue, $GriddataTableCountRec);
    }else{
        if($queryIndex>=0){ /* Update given rec */
            $GriddataTableCountRec=$varValue[$queryIndex];
            $GriddataTableCountRec['value']=peg002_calculateGriddataTableCount($GriddataTableCountRec['query'],$GriddataTableCountRec['queryParams']);
            $GriddataTableCountRec['timestamp']=time();
            $varValue[$queryIndex]=$GriddataTableCountRec;
        }else{ /* Append new rec */
            $GriddataTableCountRec=peg002_GriddataTableCountRec($table,$query,$queryParams);
            array_push($varValue, $GriddataTableCountRec);
        }
    }
    pegasusSetSuperGlobalVar( $varName, $varValue);
    return $GriddataTableCountRec['value'];
}

function peg002_GriddataTableCountRec($table='',$query='',$queryParams=array()){
    if(empty($query)){
        $query="SELECT COUNT(*) as cnt FROM ".$table;
    }
    return array(
                'timestamp'     =>  time(),
                'query'         =>  $query,  
                'queryParams'   =>  $queryParams,  
                'value'         =>  peg002_calculateGriddataTableCount($query,$queryParams)
            );
}
//XXX End Caching Function  


function peg002_get_file_tree($_file_path, $_file_pathreturn){
    peg_apm_start('function','peg002_get_file_tree');
    $retArr=array();
    $fileArray = peg_scandir($_file_path);
    if($fileArray === false){peg_apm_finish();return false;}
    foreach ($fileArray as $file){
        $leaf = false;
        $path =  rtrim($_file_path,'/').'/'.$file;
        $exp = '';
        if(!is_dir($path)){
            $leaf = true;
            $exp = peg_getFileExt($file);
           if(peg002_fileManager_validMIMEType(peg_mime_content_type($path))){
               $path=rtrim($_file_pathreturn,'/').'/'.$file;
                if(!pegasus_check_utf8($path)){
                    $path = iconv('ISO-8859-7' , 'UTF-8' , $path);
                    $file = iconv('ISO-8859-7' , 'UTF-8' , $file);
                }
                if($path ){   
                $retArr[] = array(
                        'leaf' => $leaf,
                        'path' => $path,
                        'text' => $file, 
                        'exp'   =>$exp,
                    );
                }
            }
        }else{
            $dirContent=peg002_get_file_tree($path, rtrim($_file_pathreturn,'/').'/'.$file);
            if(!$dirContent){
                $dirContent=array();
            }
            $path=rtrim($_file_pathreturn,'/').'/'.$file;
            if(!pegasus_check_utf8($path)){
                $path = iconv('ISO-8859-7' , 'UTF-8' , $path);
                $file = iconv('ISO-8859-7' , 'UTF-8' , $file);
            }
            if($path){
                $retArr[] = array(
                    'leaf' => $leaf,
                    'path' =>  $path,
                    'text' => $file, 
                    'exp'   =>$exp,
                    'data' =>$dirContent
                );

            }
        }
       
    }
    peg_apm_finish();
    return $retArr;
}

function peg002_screenTitle($module,$_d){
    $title00 = '';
    if($_SESSION['lang']!='GR'){
        $title00 = pegasus_mysql_printfld(
            'p52' , 
            'epar_val' , 
            'p02=:_d  and module=:module  and desc07="screen" and par_nm="title"', 
            array(
                '_d' => $_d,
                'module' => $module
            ));
        if(empty($title00)){
            $title00 = pegasus_mysql_printfld(
                'p51' , 
                'edesc02' , 
                'p51.desc07="screen" and p51.module=:module and p51.p02=:_d ',
                array(
                    '_d' => $_d,
                    'module' => $module
                )
            );
        }
    }
    
    if(empty($title00)){
        $title00 = pegasus_mysql_printfld(
            'p52' , 
            'par_val' , 
            'p02=:_d and module=:module and desc07="screen" and par_nm="title"',
            array(
                '_d' => $_d,
                'module' => $module
            ));
    }
    if(empty($title00)){
        $title00 = pegasus_mysql_printfld(
            'p51' , 
            'desc02' , 
            'p51.desc07="screen" and p51.module=:module and p51.p02=:_d ',
            array(
                '_d' => $_d,
                'module' => $module
            ));
    }
    return $title00;
}
function peg002_isTitle_fields($module,$_d){
                // find the tab title
    $query = 'select
                p52.code    ,

                p52.module  ,
                p52.p02     ,
                p52.desc05  ,
                p52.desc07  ,
                p52.par_nm  , ';
;
    if($_SESSION['lang']=='GR'){
        $query .= " p51.desc02,p52.par_val ";
    }else{
        $query .= " if(p51.edesc02='' , p51.desc02 , p51.edesc02) as desc02,";
        $query .= " if(p52.epar_val='' , p52.par_val , p52.epar_val) as par_val ";
    }

    $query .= ' from p51
                    join p52 on
                            p51.module=p52.module and
                            p51.p02=p52.p02 	  and
                            p51.desc05=p52.desc05 and
                            p51.desc07=p52.desc07
                where
                    p51.module=:module and
                    p51.p02=:_d and
                        
                    ( p52.par_nm="isTitle" and p52.par_val="1"  )
                        
                order by p51.desc13 ';


    $res = pegasus_query($query, array(
        'module' => $module,
        '_d' => $_d
    ));
    $retArr=array();
    while ($p52 = pegasus_fetch_assoc($res)) {
        $retArr[]=$p52['desc05'];
    }
    return $retArr;
}
function peg002_peg002_grid_multidelete_progress_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
    global $PegInput;

    $PegInput->addVar(new peg_input_alphanumeric('grid_mnr01'));
    $PegInput->addVar(new peg_input_alphanumeric('grid_mmnr01'));
    $PegInput->addVar(new peg_input_alphanumeric('grid_table'));
    $PegInput->addVar(new peg_input_alphanumeric('grid_name'));
    $PegInput->addVar(new peg_input_alphanumeric('grid_container_id'));

    $data['grid_mnr01']=$PegInput->getRequest('grid_mnr01');
    $data['grid_mmnr01']=$PegInput->getRequest('grid_mmnr01');
    $data['grid_table']=$PegInput->getRequest('grid_table');
    $data['grid_name']=$PegInput->getRequest('grid_name');
    $data['grid_container_id']=$PegInput->getRequest('grid_container_id');

    $data["peg002_peg002_grid_multidelete_progress_d_continue_hidden"]=1;
    $data["peg002_peg002_grid_multidelete_progress_d_close_hidden"]=1;
    return $data;
}
function peg002_set_p51_desc132_init_values($module=''){
    $module_sql=' and 1=1 ';
    $queryParams=array();
    if(!empty($module)){
        $module_sql="  and p55.p00= ?"; 
        $queryParams=array($module,$module,$module);
    }
    $query=
    "   UPDATE p51
        JOIN(
    
            SELECT  (@orderIdx := if(_d<>@last_d || module<>@last_mod,0,if(desc132_new>0,@orderIdx +1,@orderIdx+0))) as orderIdx ,
                    (@last_d:=_d) as previous_d,
                    (@last_mod:=module) as last_mod,
                    tt.*
            FROM 
            (   SELECT   _d,fld,module,
                        SUM(isDisplayField) AS isDisplayField2,
                        SUM(isGroupField) AS isGroupField,
                        SUM(isTitle) AS isTitle,
                        desc13, desc132,
                        IF( (fld='v_mobile_desc' && _d in ('hota04_d' ,'a57_d','a67_d','a60_d','a61_d' ,'a56_d','t08_d')) ||(fld='v_mobiletitle' && _d='a55_d') ,
							1,	
                            IF(fld='v_color' && _d in('a57_d','a67_d' ,'hota04_d','d02_d','d34_d','d29_d','d25_d','d33_d','d28_d','cona07_d','d78_d','a61_d','gym00_83_d'),0,
                                IF(_d='d01_d' AND fld='p01',5,
                                    IF(SUM(isTitle),IF((_d='i00_d' AND fld='pno') || (_d='d04_d' AND fld='p04'),2,1), 
                                        IF(SUM(isDisplayField),IF(_d='a37_d' AND fld='nr01',10,5) ,
                                            IF(SUM(isGroupField),-1,
                                                IF(fld='nr01' && desc13>0,10,
                                                    IF(desc13<0,-1,if(desc13=0,if(desc132>0,desc132,0),desc13*100))))))))) AS desc132_new
    
                FROM(
                    
                        /* Find fields that are used as displayFields in comboboxes V2*/
                        (   SELECT  IF(p52.par_val<>'',p52.par_val,p52.par_val_js) AS _d,
                                    IF(p5200.par_val<>'',p5200.par_val,p5200.par_val_js) AS  fld,
                                    IF(p5201.par_val<>'',p5201.par_val,p5201.par_val_js) AS  module,
                                    p51.desc13,
                                    p51.desc132,
                                    1 AS isDisplayField,
                                    0 AS isGroupField,
                                    0 AS isTitle,
                                    0 AS allFlds
                            FROM p52 
                            JOIN p52 AS p5201 ON p52.desc07='comboboxV2' AND p52.p02=p5201.p02 AND p52.desc05=p5201.desc05 AND p52.module=p5201.module AND p5201.par_nm='module'
                            JOIN p52 AS p5200 ON p52.desc07='comboboxV2' AND p52.p02=p5200.p02 AND p52.desc05=p5200.desc05 AND p52.module=p5200.module AND p5200.par_nm='displayField'
                            JOIN p51 ON p51.p02=IF(p52.par_val<>'',p52.par_val,p52.par_val_js)  AND p51.desc05=IF(p5200.par_val<>'',p5200.par_val,p5200.par_val_js) AND p51.module= IF(p5201.par_val<>'',p5201.par_val,p5201.par_val_js)
                            JOIN p55 ON p55.p00=p51.module AND p55.en=1  $module_sql
                            
                            WHERE p52.desc07='comboboxV2' AND p52.par_nm ='_d'
                            GROUP BY module,_d,fld
                            ORDER BY module,_d,fld
                        )
                    
                        UNION

                        /* Find fields that are used as groupFields in grids*/
                        (   SELECT 
                                IF(p52.par_val<>'',p52.par_val,p52.par_val_js) AS _d,
                                IF(p5200.par_val<>'',p5200.par_val,p5200.par_val_js) AS  fld,
                                IF(p5201.par_val<>'',p5201.par_val,p5201.par_val_js) AS module,
                                p51.desc13,
                                p51.desc132,
                                0 AS isDisplayField,
                                1 AS isGroupField,
                                0 AS isTitle,
                                0 AS allFlds
                            FROM p52 
                            JOIN p52 AS p5201 ON p52.desc07='grid' AND p52.p02=p5201.p02 AND p52.desc05=p5201.desc05 AND p52.module=p5201.module AND p5201.par_nm='module'
                            JOIN p52 AS p5200 ON p52.desc07='grid' AND p52.p02=p5200.p02 AND p52.desc05=p5200.desc05 AND p52.module=p5200.module AND p5200.par_nm='groupField'
                            JOIN p51 ON p51.p02=IF(p52.par_val<>'',p52.par_val,p52.par_val_js)  AND p51.desc05=IF(p5200.par_val<>'',p5200.par_val,p5200.par_val_js) AND p51.module= IF(p5201.par_val<>'',p5201.par_val,p5201.par_val_js)
                            JOIN p55 ON p55.p00=p51.module AND p55.en=1  $module_sql

                            WHERE p52.desc07='grid' AND p52.par_nm ='_d'
                            GROUP BY _d,fld,module
                            ORDER BY _d,fld,module
                        )

                        UNION

                        /* get all fields*/
                        (
                            SELECT  p51.p02 AS _d,
                                    p51.desc05 AS fld,
                                    p51.module AS module,
                                    p51.desc13 AS desc13,
                                    p51.desc132,
                                    0 AS isDisplayField,
                                    0 AS isGroupField,
                                    IF(p52.nr01 IS NOT NULL ,1, 0) AS isTitle,
                                    1 AS allFields	
                            FROM p51 
                            LEFT JOIN p52 ON p52.par_nm='isTitle' AND IF(p52.par_val_js=1,1,p52.par_val)=1 AND p52.p02=p51.p02 AND p52.module=p51.module AND p52.desc05=p51.desc05
                            JOIN p55 ON p55.p00=p51.module AND p55.en=1 $module_sql
                            GROUP BY _d,fld,module
                            ORDER BY _d,fld,module
                        )
                ) AS tbl
                GROUP BY _d,fld,module
                ORDER BY _d,module,desc132_new 
            ) as tt , (SELECT @orderIdx :=0, @last_d :='', @last_mod :='') AS par
            HAVING ( (orderIdx>8 && desc132<>-1) || (orderIdx<=8 && desc132_new<>desc132)) 
            ORDER BY _d,module,orderIdx
        )  AS tt ON  p51.p02 = tt._d AND p51.module = tt.module AND p51.desc05 = tt.fld 
    
        SET p51.remdate=curdate(),
            p51.remtime=curtime(),
            p51.desc132=IF( orderIdx>8,-1,tt.desc132_new)";
    // var_dump(pegasus_replace_values_in_sql($query,$queryParams));
    pegasus_query($query,$queryParams);
}
function peg002_copy_p52_p80_p81_js_values(){
    $query=
    "   UPDATE	p52 
        SET par_val = IF(par_val_js!='',par_val_js,par_val) ,
            epar_val = IF(epar_val_js!='',epar_val_js,epar_val),
            remtime=curtime(),
            remdate=curdate(),
            remuser=:username,
            remguc= :remguc
        WHERE ( par_val_js <> '' AND par_val_js <> par_val OR epar_val_js<>'' AND epar_val_js <> epar_val )    
    ";
    $queryParams=array( 'username'  =>  $_SESSION['username'],
                        'remguc'    =>  'peg002:v1r175 afterupdate');
    $res=pegasus_query($query,$queryParams);
    
}

function peg002_execute_auto_config(){
    $auto_config_file_name='../../peg_auto_config.php';
    if(file_exists($auto_config_file_name) && function_exists('pegasus_unlock_app')){ 
        $arr=require($auto_config_file_name);
        if(!empty($arr['tesae_gr_username']) && !empty($arr['tesae_gr_password']) && !empty($arr['serial']) ){
            pegasus_mysql_update('cor000',
                array('tesae_user','tesae_pass','sn'),
                array($arr['tesae_gr_username'] , $arr['tesae_gr_password'] , $arr['serial']),
                '1=1');
            pegasusWriteSession('cor000');
            pegasusReadSession('cor000');
        } 
        $ret= pegasus_unlock_app($arr['serial']);
        unlink($auto_config_file_name);
        return $ret;
    }elseif(core_is_main_db_enabled()){
        pegasusWriteSession('cor000');
		pegasusReadSession('cor000');
        if(!empty(pegasus_mysql_printfld('cor000', 'sn', 'nr01=1'))){
            $ret = pegasus_unlock_app(pegasus_mysql_printfld('cor000', 'sn', 'nr01=1'));
        }
    }
    return false;
}

function peg002_disk_usage_exceed_80_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
    $style="<style>
    .test_cls{ margin-left:0px}
    @media (min-width: 800px) {
        .test_cls{ margin-left: calc( ( 100% - 700px) / 2 )}
    }  
    .test_cls a {
        color: inherit;
    }
    </style>";
    $msg_replace=array();
    $appInfoArr=pegasusGetGlobalVar('peg_app_info');
    if(is_array($appInfoArr)){
        foreach( $appInfoArr as $cat){
            if(is_array($cat)){
                foreach ($cat['data'] as $prop) {
                    if($prop['name']=="disk_usage_info"){
                        if(core_is_main_db_enabled()){
                            $list = '<ol>';
                            $disk_size=$prop['raw_value']['do_disk_size'];
							$disk_usage=$prop['raw_value']['do_disk_usage'];
							$s3_size=$prop['raw_value']['s3_size'];
							$s3_usage=$prop['raw_value']['s3_usage'];
							$redis_size=$prop['raw_value']['redis_size'];
							$redis_usage=$prop['raw_value']['redis_usage'];

							if($disk_usage/$disk_size >= 0.8){
                                $list .= "<li> Βάση Δεδομένων $disk_usage MB / $disk_size MB</li>";
                            }
							if($s3_usage/$s3_size >= 0.8){
                                $list .= "<li> S3 Bucket $s3_usage MB / $s3_size MB</li>";
                            }
							if($redis_usage/$redis_size >= 0.8){
                                $list .= "<li> Redis $redis_usage MB / $redis_size MB</li>";
                            }
                            $list .= '</ol>';
                            $msg_replace['disk_usage_info']=$list;

                        }else{
                            $msg_replace['disk_size']=$prop['raw_value']['disk_size'];
                            $msg_replace['disk_usage']=$prop['raw_value']['disk_usage'];
                        }
                        $msg_replace['hosting_expiry']=peg_dateToStr($prop['raw_value']['hosting_expiry'],'d/m/Y');
                        $msg_replace['hosting_cona11_nr01']=$prop['raw_value']['hosting_cona11_nr01'];
                        $msg_replace['hosting_cona12_p02']=$prop['raw_value']['hosting_cona12_p02'];
                        $msg_replace['hosting_i31_nr01']=$prop['raw_value']['hosting_i31_nr01'];
                    }else if($prop['name']=='d00_01_p19'){
                        $msg_replace['d00_01_p19']=$prop['raw_value']['d00_01_p19'];
                    }else if($prop['name']=='d00_01_p8'){
                        $msg_replace['d00_01_p8']=$prop['raw_value']['d00_01_p8'];
                    }
                }
            } 
        }
    }  
    $help_msg=core_is_main_db_enabled() ? $_SESSION['peg_dic_peg002_do_disk_usage_exceed_80_d_msg'] : $_SESSION['peg_dic_peg002_disk_usage_exceed_80_d_msg'];
    // var_dump($msg_replace['d00_01_p8']);
    if(empty($msg_replace['d00_01_p8'])){
        $msg_d00_01_p8 =  pegasus_get_text_inside_tags('<tag_d00_01_start>','<tag_d00_01_end>',$help_msg);
        $help_msg=str_replace('<tag_d00_01_start>'.$msg_d00_01_p8.'<tag_d00_01_end>','',$help_msg);
    }
    $data['help']=$style.'<div style="max-width:700px " class=" test_cls peg_alert_warning_plain">'.$help_msg.'<div>';
    foreach ($msg_replace as $key => $value) {
        $data['help']=str_replace('##'.$key.'##',$value,$data['help']);
    }
    return $data;
}
function peg002_contract_expires_warn_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
    $style="<style>
    .test_cls{ margin-left:0px}
    @media (min-width: 800px) {
        .test_cls{ margin-left: calc( ( 100% - 700px) / 2 )}
    }  
    .test_cls a {
        color: inherit;
    }
    </style>";
    $msg_replace=array();
    $appInfoArr=pegasusGetGlobalVar('peg_app_info');
    // var_dump($appInfoArr);
    foreach( $appInfoArr as $cat){
        foreach ($cat['data'] as $prop) {
            if($prop['name']=="disk_usage_info"){
                $msg_replace['disk_size']=$prop['raw_value']['disk_size'];
                $msg_replace['disk_usage']=$prop['raw_value']['disk_usage'];
                $msg_replace['hosting_expiry']=peg_dateToStr($prop['raw_value']['hosting_expiry'],'d/m/Y');
                $msg_replace['hosting_cona11_nr01']=$prop['raw_value']['hosting_cona11_nr01'];
                $msg_replace['hosting_cona12_p02']=$prop['raw_value']['hosting_cona12_p02'];
                $msg_replace['hosting_i31_nr01']=$prop['raw_value']['hosting_i31_nr01'];
            }else if($prop['name']=='d00_01_p19'){
                $msg_replace['d00_01_p19']=$prop['raw_value']['d00_01_p19'];
            }else if($prop['name']=='d00_01_p8'){
                $msg_replace['d00_01_p8']=$prop['raw_value']['d00_01_p8'];
            }
        }
    }
    $help_msg=$_SESSION['peg_dic_peg002_contract_expires_warn_d_msg'];
    // var_dump($msg_replace['d00_01_p8']);
    if(empty($msg_replace['d00_01_p8'])){
        $msg_d00_01_p8 =  pegasus_get_text_inside_tags('<tag_d00_01_start>','<tag_d00_01_end>',$help_msg);
        $help_msg=str_replace('<tag_d00_01_start>'.$msg_d00_01_p8.'<tag_d00_01_end>','',$help_msg);
    }
    $data['help']=$style.'<div style="max-width:700px " class=" test_cls peg_alert_warning_plain">'.$help_msg.'<div>';
    foreach ($msg_replace as $key => $value) {
        $data['help']=str_replace('##'.$key.'##',$value,$data['help']);
    }
    return $data;
}


function peg002_disk_usage_exceed_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
    $style="<style>
    .test_cls{ margin-left:0px}
    @media (min-width: 800px) {
        .test_cls{ margin-left: calc( ( 100% - 700px) / 2 )}
    }  
    .test_cls a {
        color: inherit;
    }
    </style>";
    $msg_replace=array();
    $appInfoArr=pegasusGetGlobalVar('peg_app_info');
    foreach( $appInfoArr as $cat){
        if(!isset($cat['data'])){
            continue;
        }
        foreach ($cat['data'] as $prop) {
            if($prop['name']=="disk_usage_info"){
                if(core_is_main_db_enabled()){
                    $list = '<ol>';
                    $disk_size=$prop['raw_value']['do_disk_size'];
					$disk_usage=$prop['raw_value']['do_disk_usage'];
					$s3_size=$prop['raw_value']['s3_size'];
					$s3_usage=$prop['raw_value']['s3_usage'];
					$redis_size=$prop['raw_value']['redis_size'];
					$redis_usage=$prop['raw_value']['redis_usage'];

					if($disk_usage >= $disk_size){
                        $list .= "<li> Βάση Δεδομένων $disk_usage MB / $disk_size MB</li>";
                    }
					if($s3_usage >= $s3_size){
                        $list .= "<li> S3 Bucket $s3_usage MB / $s3_size MB</li>";
                    }
					if($redis_usage >= $redis_size){
                        $list .= "<li> Redis $redis_usage MB / $redis_size MB</li>";
                    }
                    $list .= '</ol>';
                    $msg_replace['disk_usage_info']=$list;

                }else{
                    $msg_replace['disk_size']=$prop['raw_value']['disk_size'];
                    $msg_replace['disk_usage']=$prop['raw_value']['disk_usage'];
                }
                $msg_replace['hosting_expiry']=peg_dateToStr($prop['raw_value']['hosting_expiry'],'d/m/Y');
                $msg_replace['hosting_cona11_nr01']=$prop['raw_value']['hosting_cona11_nr01'];
                $msg_replace['hosting_cona12_p02']=$prop['raw_value']['hosting_cona12_p02'];
                $msg_replace['hosting_i31_nr01']=$prop['raw_value']['hosting_i31_nr01'];
            }else if($prop['name']=='d00_01_p19'){
                $msg_replace['d00_01_p19']=$prop['raw_value']['d00_01_p19'];
            }else if($prop['name']=='d00_01_p8'){
                $msg_replace['d00_01_p8']=$prop['raw_value']['d00_01_p8'];
            }
        }
    }
    $help_msg=core_is_main_db_enabled() ? $_SESSION['peg_dic_peg002_do_disk_usage_exceed_d_msg'] : $_SESSION['peg_dic_peg002_disk_usage_exceed_d_msg'];
    if(empty($msg_replace['d00_01_p8'])){
        $msg_d00_01_p8 =  pegasus_get_text_inside_tags('<tag_d00_01_start>','<tag_d00_01_end>',$help_msg);
        $help_msg=str_replace('<tag_d00_01_start>'.$msg_d00_01_p8.'<tag_d00_01_end>','',$help_msg);
    }
    
    $data['help']=$style.'<div style="max-width:700px " class=" test_cls peg_alert_danger_plain">'. $help_msg .'<div>';
    foreach ($msg_replace as $key => $value) {
        $data['help']=str_replace('##'.$key.'##',$value,$data['help']);
    }
    return $data;
}

function peg002_contract_expired_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
    $style="<style>
    .test_cls{ margin-left:0px}
    @media (min-width: 800px) {
        .test_cls{ margin-left: calc( ( 100% - 700px) / 2 )}
    }  
    .test_cls a {
        color: inherit;
    }
    </style>";
    $msg_replace=array();
    $appInfoArr=pegasusGetGlobalVar('peg_app_info');
    foreach( $appInfoArr as $cat){
        foreach ($cat['data'] as $prop) {
            if($prop['name']=="disk_usage_info"){
                $msg_replace['disk_size']=$prop['raw_value']['disk_size'];
                $msg_replace['disk_usage']=$prop['raw_value']['disk_usage'];
                $msg_replace['hosting_expiry']= peg_dateToStr($prop['raw_value']['hosting_expiry'],'d/m/Y');
                $msg_replace['hosting_cona11_nr01']=$prop['raw_value']['hosting_cona11_nr01'];
                $msg_replace['hosting_cona12_p02']=$prop['raw_value']['hosting_cona12_p02'];
                $msg_replace['hosting_i31_nr01']=$prop['raw_value']['hosting_i31_nr01'];
            }else if($prop['name']=='d00_01_p19'){
                $msg_replace['d00_01_p19']=$prop['raw_value']['d00_01_p19'];
            }else if($prop['name']=='d00_01_p8'){
                $msg_replace['d00_01_p8']=$prop['raw_value']['d00_01_p8'];
            }
        }
    }

    $help_msg=$_SESSION['peg_dic_peg002_contract_expired_d_msg'];
    // var_dump($msg_replace['d00_01_p8']);
    if(empty($msg_replace['d00_01_p8'])){
        $msg_d00_01_p8 =  pegasus_get_text_inside_tags('<tag_d00_01_start>','<tag_d00_01_end>',$help_msg);
        $help_msg=str_replace('<tag_d00_01_start>'.$msg_d00_01_p8.'<tag_d00_01_end>','',$help_msg);
    }
    
    $data['help']=$style.'<div style="max-width:700px " class=" test_cls peg_alert_danger_plain">'.$help_msg.'<div>';
    foreach ($msg_replace as $key => $value) {
        $data['help']=str_replace('##'.$key.'##',$value,$data['help']);
    }
    return $data;
}
function peg002_unlock_app_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
    $data['help']=pegasus_lock_get_lock_msg();
    if(pegasus_lock_check_app()==1 ){
        $data['peg002_unlock_app_d_next_unlock_button_hidden']=1;
        $data['peg002_unlock_app_d_fldcont00_1_1_hidden']=1;
        
    }
    $data['sn']=pegasus_get_app_sn();
    return $data;
}
function peg002_update_app_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
    $data['help']=$_SESSION['peg_dic_peg002_update_app_d_help'];
    return $data;
}
function peg002_sync_app_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
    if(strpos($_SESSION['peg_dic_peg002_sync_app_d_help'], '##modules##')===false){
        $data['help'] = $_SESSION['peg_dic_peg002_sync_app_d_help'];
    }else{
        $ret = core_update_from_json_changes();
        $data['help']=str_replace('##modules##', $ret['change'], $_SESSION['peg_dic_peg002_sync_app_d_help']);
    }
    
    
    return $data;
}

function peg002_where_array_cor012_diff($grid_container,$grid_name){
    $_cor012_value=pegasusGetGlobalVar( $grid_container .'_cor012_value');
    $cor013_res=pegasus_query("SELECT * FROM cor013 WHERE cor012=?",array($_cor012_value));
    $core013_array=array();
    
    $_where_array=pegasusGetGlobalVar( 'gridData_' . $grid_container . '_' . $grid_name . '_where_array' );
    $_order_array=pegasusGetGlobalVar( 'gridData_' . $grid_container . '_' . $grid_name . '_order_array' );

    while($row=pegasus_fetch_assoc($cor013_res)){
        $core013_array[$row['desc05']]=$row;
        if(($row['porder']=='asc' || $row['porder']=='desc') && empty($_order_array) ){
            return true;
        }
        if(empty($_where_array)){
            return true;
        }
    }
    $order=array();
    foreach($_order_array as $ord){
        if( isset($core013_array[$ord['name']]) ){
            if($core013_array[$ord['name']]['porder']<>$ord['order'] || $core013_array[$ord['name']]['porder_tax']<>$ord['order_tax'] ){
                return true;
            }
            $order[$ord['name']]=$ord;
        }else{
            return true;
        }
    }
    $where=array();
    foreach($_where_array as $wh){
        if( isset($core013_array[$wh['name']]) ){
            $wh['mode']=(($wh['not']==1)?'!':'').$wh['mode'];
            if($core013_array[$wh['name']]['pvalue']<>$wh['value'] || $core013_array[$wh['name']]['pvalue1']<>$wh['value1']||  $core013_array[$wh['name']]['pmode']<>$wh['mode'] ||  $core013_array[$wh['name']]['pin_fld']<>$wh['in_fld']){
                return true;
            }
            $where[$wh['name']]=$wh;
        }else{
            return true;
        }
    }
    foreach ($core013_array as $key => $value) {
        // var_dump( $key , $value);
        if(!isset($where[$key]) && !isset($order[$key]) ){
            return true;
        }
    }
    return false;
}

function peg002_app_owner_update_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
    $style="<style>
    .test_cls{ margin-left:0px}
    @media (min-width: 800px) {
        .test_cls{ margin-left: calc( ( 100% - 700px) / 2 )}
    }  
    .test_cls a {
        color: inherit;
    }
    </style>";


    
    $owner_info=pegasusGetGlobalVar('peg_app_info_owner_info');

    
    $data['help']=$style.'<div style="max-width:700px " class=" test_cls peg_alert_warning_plain">'.$owner_info['set_app_info_help_'.(($_SESSION['lang']=='GR')?'el':'en')].'<div>';
    // var_dump($owner_info);
    $data['terms_help']='<div style="max-width:450px " class=" peg_alert_info_plain">'.$owner_info['d00_00_terms_help_'.(($_SESSION['lang']=='GR')?'el':'en')].'<div>';
    $data['partner_help']='<div style="max-width:450px " class=" peg_alert_info_plain">'.$owner_info['d00_00_partner_help_'.(($_SESSION['lang']=='GR')?'el':'en')].'<div>';
    
    for ($i=2; $i <= 10; $i++) { 
        if(!($owner_info['d00_00_d64_nr01_'.$i]>0)){
            $data['d64_nr01_'.$i."_hidden"]=true;
            $data['d64_p01_'.$i."_hidden"]=true; 
            $data['d64_remove_btn_'.$i."_hidden"]=true;
            $data['d64_fldcont_'.$i."_hidden"]=true;
            
        }
        if(!($owner_info['d00_00_d65_nr01_'.$i]>0)){
            $data['d65_nr01_'.$i."_hidden"]=true;
            $data['d65_p01_'.$i."_hidden"]=true;
            $data['d65_p300_'.$i."_hidden"]=true;
            $data['d65_remove_btn_'.$i."_hidden"]=true;
            $data['d65_fldcont_'.$i."_hidden"]=true;
            
        }
    }
    for ($i=1; $i <= 10; $i++) {     
        
        $data['d64_nr01_'.$i.'_hidden']=true;
        $data['d65_nr01_'.$i.'_hidden']=true;   
        if($owner_info['d00_00_d64_nr01_'.$i]>0){
            $data['d64_nr01_'.$i]=$owner_info['d00_00_d64_nr01_'.$i];
            $data['d64_p01_'.$i]=$owner_info['d00_00_d64_p001_'.$i];
        }
        if($owner_info['d00_00_d65_nr01_'.$i]>0){ 
            $data['d65_nr01_'.$i]=$owner_info['d00_00_d65_nr01_'.$i];
            $data['d65_p01_'.$i]=$owner_info['d00_00_d65_p01_'.$i];
            $data['d65_p300_'.$i]=$owner_info['d00_00_d65_p300_'.$i];
        }
    } 

    $data['d00_p19']=$owner_info['d00_00_p19'];
    $data['d00_p190']=$owner_info['d00_00_p190'];
    $data['d00_p20']=$owner_info['d00_00_p20'];
    $data['d00_p4']=$owner_info['d00_00_p4'];
    $data['d00_p2']=$owner_info['d00_00_p2'];
    $data['d00_p3']=$owner_info['d00_00_p3'];

    $data['d00_d65_p300_label']=$_SESSION['peg_dic_peg002_d00_d65_p300_accept'];
    $data['d00_d64d65_remove_tooltip']=$_SESSION['peg_dic_peg002_owner_app_update_d64d65_remove'];
    // var_dump($app_info['data']['raw_value']);
    $data['d00_p190_readonly']=true;
    $data['d00_p20_readonly']=true;
    $data['partner_help']=str_replace('##partner##',$owner_info['d00_01_p19'],$data['partner_help']);
// die(var_dump($owner_info['d00_01_nr01']));
    if($owner_info['d00_01_nr01']=='57611'){//TESAE
        $data['partner_help_hidden']=true;
        $data['partner_check_hidden']=true;
    } 
    
    return $data;
}
function peg002_update_where_array_and_order_array_from_cor012($p02,$module,$cor012,$grid_container_id='',$grid_name=''){
    $where_array=array();
    $order_array=array();

    $cor013Res = pegasus_query( 
        "   SELECT cor013.*,p51.desc07 FROM cor013 
            LEFT JOIN p51 ON  p51.desc05=cor013.desc05 && p51.p02=:p02 && p51.module=:module
            WHERE cor012=:cor012 ", 
            array(  'p02'       =>   $p02 ,
                    'module'    =>   $module ,
                    'cor012'    =>   $cor012 ) );
    while( $row = pegasus_fetch_assoc($cor013Res) ){
        if(in_array($row['desc05'],array('remdate','remfdate'))){
            $row['desc07']="datebox";
        }else if (in_array($row['desc05'],array('remtime','remftime'))) {
            $row['desc07']="timefield";
        } else if (in_array($row['desc05'],array('remuser','remfuser','remguc'))) {
            $row['desc07']="textbox";
        }

        $not=0;
        if(strpos($row['pmode'],'!')===0){
            $not=1;
            $row['pmode']=substr($row['pmode'],1);
        }
        if(
            !empty( $row['desc05']) || 
            !empty( $row['pvalue1']) || 
            !empty( $row['pin_fld']) 
        ){
            $where_array[] = array(
                'name' => $row['desc05'],
                'value' => $row['pvalue'],
                'value1' => $row['pvalue1'],
                'type' => $row['desc07'], 
                'mode' => $row['pmode'], 
                'not' => $not, 
                'in_fld' => $row['pin_fld'],
                'field_name' =>$row['desc05']
            );
        }
        if(
            !empty( $row['porder']) || 
            !empty( $row['porder_tax'])  
        ){
            $order_array[] = array(
                'name' =>  $row['desc05'],
                'order' => $row['porder'],
                'order_tax' => $row['porder_tax']
            );
        }
    }
    pegasusSetGlobalVar( 'gridData_' . $grid_container_id . '_' . $grid_name . '_where_array', $where_array );
    pegasusSetGlobalVar( 'gridData_' . $grid_container_id . '_' . $grid_name  . '_order_array', $order_array );
    // var_dump( 'gridData_' . $grid_container_id . '_' . $grid_name . '_where_array');
}

function peg002_peg002_keyboard_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
    global $PegInput;        
    $PegInput->addVar(new peg_input_alphanumeric('input_field'));
    $PegInput->addVar(new peg_input_alphanumeric('peg_screenTitle'));
    $PegInput->addVar(new peg_input_alphanumeric('parent_container_id'));
    $PegInput->addVar(new peg_input_alphanumeric('parent_name'));
    $PegInput->addVar(new peg_input_alphanumeric('xtype')); 
    $PegInput->addVar(new peg_input_alphanumeric('isMobileOrTablet'));

    $data['peg_screenTitle']=$PegInput->getRequest('peg_screenTitle'); 
    $data['lang']=($_SESSION['lang']=="GR")?'el':'en';
    $data['parent_container_id']=$PegInput->getRequest('parent_container_id');
    $data['parent_name']=$PegInput->getRequest('parent_name');
    $data['xtype']=$PegInput->getRequest('xtype');
    $data['input_field']=$PegInput->getRequest('input_field'); 
    $data['isMobileOrTablet']=$PegInput->getRequest('isMobileOrTablet');
    $data['isMobileOrTablet']=($data['isMobileOrTablet']===true || $data['isMobileOrTablet']==="true");

    if($data['xtype']=='pegasusTextArea'){
        $data['peg002_peg002_keyboard_fldcont_row3_empty_hidden']=true;  
        $data['peg002_peg002_keyboard_input_field_textfield_hidden']=true;  
        $data['input_field_textarea']=$PegInput->getRequest('input_field');    
    }else{
        $data['peg002_peg002_keyboard_bt_enter_hidden']=true; 
        $data['input_field_textfield']=$PegInput->getRequest('input_field');
        $data['peg002_peg002_keyboard_input_textarea_wrapper_hidden']=true;
    }
    
    if(!$data['isMobileOrTablet'] ){ //editable
        $data['peg002_peg002_keyboard_fldcont_row0_hidden']=true;
    }else{
        $data['peg002_peg002_keyboard_fldcont_row0_editable_hidden']=true; 
        
    }

    return $data;
}
function peg002_peg002_numpad_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
    global $PegInput;        
    $PegInput->addVar(new peg_input_alphanumeric('input_field'));
    $PegInput->addVar(new peg_input_alphanumeric('peg_screenTitle'));
    $PegInput->addVar(new peg_input_alphanumeric('parent_container_id'));
    $PegInput->addVar(new peg_input_alphanumeric('parent_name'));
    $data['bt_decimal_text']=$_SESSION['cor000_decimal_char'];
    $data['input_field']=str_replace(array(',','.'),$_SESSION['cor000_decimal_char'],$PegInput->getRequest('input_field'));
    $data['parent_container_id']=$PegInput->getRequest('parent_container_id');
    $data['parent_name']=$PegInput->getRequest('parent_name');
    $data['peg_screenTitle']=$PegInput->getRequest('peg_screenTitle'); 
    return $data;
}

function peg002_build_search_query_cond($field,$searchval,&$paramcounteri=0,$param_name_prefix="peg002_build_query_param_"){
    $param_name_prefix="peg002_build_query_param_";
    $where_array=array( 'sql'       =>  '',
                        'sqlParams' =>  array() );
    if(
        substr($searchval, 0, 1) != '~'  && 
        substr($searchval, 0, 2) != '~+' && 
        substr($searchval, 0, 2) != '~-' && 
        substr($searchval, 0, 1) != '='
    ){
        $param_name=$param_name_prefix. ++$paramcounteri .'_';
        $where_array['sql'].=$field . ' like  :' . $param_name;
        $where_array['sqlParams'][$param_name]="%".$searchval."%";
    }else{
        if (substr($searchval,0,1)=='~'){
            if (substr($searchval,1,1)=='+' || substr($searchval,1,1)=='-') {
                $quick_find_cond00="";
                $cond=" AND "; // ΑΝ εχω ~+ : Περιέχει όλες τις λέξεις
                if (substr($searchval,1,1)=='-') {
                    $cond=" OR "; // ΑΝ εχω ~- : Περιέχει τουλάχιστον μία λέξη
                }
                $array=pegasus_CrStrArray(trim($searchval) , ' ' , 2);
                $size=sizeof($array);
                for ($i=0; $i<$size; $i++){
                    $param_name=$param_name_prefix. ++$paramcounteri .'_';
                    if ($i!==0) {
                        $quick_find_cond00 .=$cond;
                    }
                    $quick_find_cond00 .= $field ." LIKE :" . $param_name . ' ';
                    $where_array['sqlParams'][$param_name] = '%'. trim($array[$i]) . '%';
                }
                $where_array['sql']="( $quick_find_cond00 )"; 
            }else{ // Αν έχω ~ : Μοιάζει με
                $param_name=$param_name_prefix. ++$paramcounteri .'_';
                $where_array['sql']= $field ." LIKE :" . $param_name . ' ';
                $where_array['sqlParams'][$param_name]= '%'.  trim(substr($searchval,1, (strlen($searchval)-1) ))  . '%';
            }
        }elseif (substr($searchval,0,1)=='=') {
            $param_name=$param_name_prefix. ++$paramcounteri .'_';
            if (substr($searchval,1,1)=='=') {  // Αν εχω == 
                $where_array['sql']= $field ." = :" . $param_name . ' ';
                $where_array['sqlParams'][$param_name] = trim(substr($searchval,2, (strlen($searchval)-2) ))  ; 
            }else{
                $searchval=str_replace( '*', '%' ,$searchval);
                $searchval=str_replace( '?', '_' ,$searchval);
                $where_array['sql']= $field ." LIKE :" . $param_name . ' ';
                $where_array['sqlParams'][$param_name] = trim(substr($searchval,1, (strlen($searchval)-1) ))  ;
            }
        }else{ // Arxizei apo
            $param_name=$param_name_prefix. ++$paramcounteri .'_';
            $where_array['sql']= $field ." LIKE :" . $param_name . ' ';
            $where_array['sqlParams'][$param_name] = trim($searchval). '%';
        }
    }
    return $where_array;
}
?>