<?php
/** This method formats and returns the given number
 * @param mixed $number The number to format
 * @param int $decimals The number of decimal digits. If number of decimals is 0 then no decimals are displayed
 * @param int $thousand_format The p52 param that indicates if the number will be formatted or not. 
 * Possible values are: 
 * * 1-To always format the number thousands, 
 * * 2-To never format the number thousands, 
 * * 0-To format number thousands only if the number of decimals is more than 0
 * @param mixed|null $thousand_separator The separator character that will be used for the thousands. If null, the function will use the configuration in cor000
 * @param mixed|null $decimal_separator The decimal point character. If null, the function will use the configuration in cor000
*/
function peg002_format_number($number,$decimals=0,$thousand_format=0,$thousand_separator=NULL,$decimal_separator=NULL){
    //
    if($thousand_separator===NULL){/** Αν έχω περάσει NULL θα βρίσκει το thousand separator από τις βασικές παραμέτρους*/
        switch ($_SESSION['cor000_thousand_char']) {
            case '1':
                $thousand_separator=' ';
                break;
            case '2':
                $thousand_separator=',';
                break;
            case '3':
                $thousand_separator='.';
                break;
            
            default:
                $thousand_separator='';
                break;
        }
    }


    if($decimal_separator===NULL){
        $decimal_separator=$_SESSION['cor000_decimal_char'];
    }

   

    $allowThousandSeparator=false;
    if(!empty($thousand_separator)){
        if($thousand_format==1){
            $allowThousandSeparator=true;
        }else if($thousand_format==2){
            $allowThousandSeparator=false;
        }else{
            if($decimals>0){
                $allowThousandSeparator=true;
            }else{
                $allowThousandSeparator=false;
            }
        }
    }


    if(empty($decimal_separator) || ($decimal_separator==$thousand_separator && $allowThousandSeparator)){
        if($thousand_separator==','){
            $decimal_separator='.';
        }else{
            $decimal_separator=',';
        }
    }

    if(!$allowThousandSeparator){
        $thousand_separator = '';
    }

    return number_format($number, $decimals, $decimal_separator, $thousand_separator);


    $number=str_replace(',','.',$number);
    $sign=1;
    if($number<0){
        $sign=-1;
    }
    if(strlen($number)>=15){
        $num_arr=explode('.',$number);
        $int_part=$num_arr[0];
        $dec_part=$num_arr[1];
        if($allowThousandSeparator){
            $int_part_formatted='';
            $rest=$int_part;
            while(strlen($rest)>0){
                $th=substr($rest,0,3);
                if(!empty($int_part_formatted)){
                    $int_part_formatted.=$thousand_separator;
                }
                $int_part_formatted.=$th;
                $rest=substr($rest,3); 
            }
            $int_part=$int_part_formatted;
        }
    }else{
        $number=(float) $number;
        $number=round($number,$decimals);
        $abs=$number*$sign;
        $num_arr=explode('.',$abs."");
        $int_part=$num_arr[0];
        $dec_part=$num_arr[1];
        if($allowThousandSeparator){
            $var_number=intval($int_part); 
            $int_part_formatted='';
            while($var_number>=1){
                 $mod=$var_number%1000;
                 if($var_number>=1000){
                     $th=str_pad($mod, 3, "0", STR_PAD_LEFT) ;
                 }else{
                     $th=$mod;
                 }
                 if(!empty($int_part_formatted)){
                     $int_part_formatted=$thousand_separator.$int_part_formatted;
                 }
                 $int_part_formatted=$th.$int_part_formatted;
                 $var_number=$var_number/1000;
            }
            $int_part=$int_part_formatted;
         }
    }
   

   
    if($decimals>0){
        if(strlen($dec_part)>$decimals){
            $dec_part=substr($dec_part,0,$decimals); 
        }
        $dec_part=$decimal_separator.str_pad($dec_part, $decimals,"0", STR_PAD_RIGHT);   
    }else{
        $dec_part='';
    }
    $int_part=str_pad($int_part, 1,"0", STR_PAD_LEFT);//Αν είναι μηδέν
    $sign=(($sign==-1)?'-':'');
    return $sign.$int_part.$dec_part;
}
?>