<?php
    require_once('../peg002_00/header.php');
    
	global $PegInput;
    $return_array=array( 'ok'    =>  0   );

    try {
        $json_response = pegasus_curl_request('https://services00.pegcloud.io/is_alive.php', false,  array(), array(CURLOPT_TIMEOUT => 4));
    } catch (Exception $ex) {
        $json_response = false;
    }

    if( !empty($json_response) and  $json_response=='true') {
        $service_name = 'pegcloud.io';
        $url = "https://services00.pegcloud.io/peg_app_info/execute.php";
    }else{
        $service_name = 'tesae.gr';
        $url = "https://services.tesae.gr/peg_app_info/execute.php";
    }
    $data = array(
        'html'  => ''
    );
	$sn			= 'Π'.pegasus_leading_zeros($_SESSION['cor000_sn'], 7);
    $user = $_SESSION['cor000_tesae_user'];
    $pass = $_SESSION['cor000_tesae_pass'];
    $app_code = $_SESSION['cor000_app_code'];
    // $sid = '';

    // $url = "https://marina.pegcloud.io/services/peg_app_info/execute.php";
    // $sn			= 'SN00222';
    // $user='marina';
    // $pass='marina';
    // $app_code = 'IN.01.001';
    // Login to service
	$params = array(
		'action'	=> 'login',
		'user'		=> $user,
		'pass'		=> $pass,
		'sn'		=> $sn,
		'un'		=> 1
	);
    try {
        $resp = pegasus_curl_request_post($url,$params); 
    } catch (Exception $ex) {
        $resp = false;
        $return_array["msg"]=$_SESSION['peg_dic_peg002_service_request_failed'];
    }

	$xml = simplexml_load_string($resp);
	if($xml->code == '100'){
        $sid = $xml->sid;
        $params = array(
            'action'	=> 'set_app_info',
            'sid'		=> $sid,
            'sn'		=> $sn,
            'app_code'	=> $app_code
        );
         
        $d00_00_valid_fields=array('d00_00_p19','d00_00_p2','d00_00_p3','d00_00_p4','d00_00_d99102_terms','d00_00_d99102_peg_referred_by');
        foreach($d00_00_valid_fields as $d00_fld){
            $PegInput->addVar(new peg_input_alphanumeric($d00_fld));
            $params[ $d00_fld ]=$PegInput->getRequest($d00_fld);
        }
        if($params[ 'd00_00_d99102_terms' ] !=1){
            $return_array["ok"]=0;
            $return_array["msg"]=$_SESSION['peg_dic_peg002_d00_d99102_terms_empty'];
            echo json_encode($return_array);
            return;
        }
        if($PegInput->issetRequest('d00_00_d99102_peg_referred_by') && $params[ 'd00_00_d99102_peg_referred_by' ] !=1){
            $return_array["ok"]=0;
            $return_array["msg"]=$_SESSION['peg_dic_peg002_d00_d99102_peg_referred_by_empty'];
            echo json_encode($return_array);
            return;
        }
        $d65_nr01_array=array();
        for ($i=1; $i <=10 ; $i++) { 
            $var_nr01_key='d00_00_d65_nr01_'.$i;
            $PegInput->addVar(new peg_input_alphanumeric($var_nr01_key));
            if(!$PegInput->issetRequest($var_nr01_key)){
                break;
            }
            $params[$var_nr01_key]=$PegInput->getRequest($var_nr01_key);

            array_push($d65_nr01_array,$PegInput->getRequest($var_nr01_key));
            $var_p01_key='d00_00_d65_p01_'.$i;
            $PegInput->addVar(new peg_input_alphanumeric($var_p01_key));
            $params[$var_p01_key]=$PegInput->getRequest($var_p01_key);

            
            $var_p300_key='d00_00_d65_p300_'.$i;
            $PegInput->addVar(new peg_input_alphanumeric($var_p300_key));
            $params[$var_p300_key]=$PegInput->getRequest($var_p300_key);
        }
        $max_d65_idx=$i;
        $d64_nr01_array=array();
        for ($i=1; $i <=10 ; $i++) { 
            $var_nr01_key='d00_00_d64_nr01_'.$i;
            $PegInput->addVar(new peg_input_alphanumeric($var_nr01_key));
            if(!$PegInput->issetRequest($var_nr01_key)){
                break;
            }
            array_push($d64_nr01_array,$PegInput->getRequest($var_nr01_key));
            $params[$var_nr01_key]=$PegInput->getRequest($var_nr01_key);

            $var_p01_key='d00_00_d64_p001_'.$i;
            $PegInput->addVar(new peg_input_alphanumeric($var_p01_key));
            $params[$var_p01_key]=$PegInput->getRequest($var_p01_key);
        }
        $max_d64_idx=$i;
        $owner_info=pegasusGetGlobalVar('peg_app_info_owner_info');
        for ($i=1; $i <= 10; $i++) {
            if($owner_info['d00_00_d64_nr01_'.$i]>0 && !in_array($owner_info['d00_00_d64_nr01_'.$i],$d64_nr01_array)){
              $params['d00_00_d64_nr01_'.$max_d64_idx]=$owner_info['d00_00_d64_nr01_'.$i];
              $max_d64_idx++;
            }
        }  
        for ($i=1; $i <= 10; $i++) {
            if($owner_info['d00_00_d65_nr01_'.$i]>0 && !in_array($owner_info['d00_00_d65_nr01_'.$i],$d65_nr01_array)){
              $params['d00_00_d65_nr01_'.$max_d65_idx]=$owner_info['d00_00_d65_nr01_'.$i];
              $max_d65_idx++;
            }
        } 
        try {
            $resp = pegasus_curl_request_post($url,$params);
        } catch (Exception $ex) {
            $resp = false;
        }
        $xml = simplexml_load_string($resp); 
        if($xml->code==200){
            $lang=strtolower($_SESSION['lang']);
            if($lang == 'gr' ) {
                $lang = 'el';
            } else {
                $lang = 'en';
            }
            $xml_data = json_decode(base64_decode($xml->data),true);
            $return_array["ok"]=1;
            $return_array["msg"]=$_SESSION['peg_dic_peg002_app_owner_update_success'];
            $_SESSION['owner_update']=false;
        }
    }
    echo json_encode($return_array);
?>