<?php
    require_once('../peg002_00/header.php');
    global $PegInput;
    $PegInput->addVar(new peg_input_number('cor012_nr01'));
    $PegInput->addVar(new peg_input_alphanumeric('cor012_p01')); 
    $PegInput->addVar(new peg_input_alphanumeric('grid_container_id')); 
    $PegInput->addVar(new peg_input_alphanumeric('grid_name')); 
    $PegInput->addVar(new peg_input_alphanumeric('grid_table')); 
    $PegInput->addVar(new peg_input_alphanumeric('grid__d')); 
    $PegInput->addVar(new peg_input_alphanumeric('grid_module')); 

    $where_array = pegasusGetGlobalVar('gridData_' . $PegInput->getRequest('grid_container_id') . '_' . $PegInput->getRequest('grid_name')  . '_where_array'); 
    $order_array = pegasusGetGlobalVar('gridData_' . $PegInput->getRequest('grid_container_id') . '_' . $PegInput->getRequest('grid_name')  . '_order_array');

    $cor012_data=array();
    $is_new=false;
    pegasus_mysql_use('SELECT * FROM cor012 WHERE nr01=?',$cor012_data,array($PegInput->getRequest('cor012_nr01')));
    if($cor012_data['nr01']>0){
        //Record already exists
        $cor012_nr01=$cor012_data['nr01'];
        $cor012_p01=$cor012_data['p01'];
        if( ! peg002_where_array_cor012_diff(  $PegInput->getRequest('grid_container_id')  , $PegInput->getRequest('grid_name') )){
            $ret=array( "ok"    =>  1,
                        'info'  =>  $_SESSION['peg_dic_peg002_cor012_update_no_changes'] ,
                        "data"  =>  array(  'cor012_nr01'   =>  $cor012_nr01 ,
                                            'cor012_p01'    =>  $cor012_p01 )
            );
            echo json_encode( $ret );
            return;

        }
        pegasus_mysql_delete('cor013','cor012=?',0,array($cor012_nr01));
    }else{
        if(empty($where_array) && empty($order_array)){
            echo json_encode(array( "ok"=>0, "msg"=> $_SESSION['peg_dic_peg002_cor012_save_no_filters']) );
            return;
        }
        if(empty($PegInput->getRequest('cor012_p01'))){
            echo json_encode(array( "ok"=>0, "msg"=>$_SESSION['peg_dic_peg002_cor012_save_empty_p01']) );
            return;
        }

        $is_new=true;
        $cor012_nr01=pegasus_mysql_newrec('cor012');
        $cor012_p01=$PegInput->getRequest('cor012_p01');
        $arr1=array();                  $arr2=array();
        array_push($arr1,'nr01');       array_push($arr2,$cor012_nr01);
        array_push($arr1,'p01');        array_push($arr2,$cor012_p01);
        array_push($arr1,'ptable');     array_push($arr2, $PegInput->getRequest('grid_table'));
        array_push($arr1,'p_d');        array_push($arr2, $PegInput->getRequest('grid__d'));
        array_push($arr1,'pmodule');   array_push($arr2, $PegInput->getRequest('grid_module'));
        array_push($arr1,'parent_code');   array_push($arr2, $PegInput->getRequest('grid__d').'-'.$PegInput->getRequest('grid_name'));
        pegasus_mysql_insert('cor012',$arr1,$arr2);

    }

    foreach ($where_array as $wh) {
        if($wh['not']==1){
            $wh['mode']='!'.$wh['mode'];
        }
        $arr1=array();                  $arr2=array();
        array_push($arr1,'nr01');       array_push($arr2,pegasus_mysql_newrec('cor013'));
        array_push($arr1,'cor012');     array_push($arr2,$cor012_nr01);
        array_push($arr1,'desc05');     array_push($arr2,$wh['name']);
        array_push($arr1,'pvalue');     array_push($arr2,$wh['value']);
        array_push($arr1,'pvalue1');    array_push($arr2,$wh['value1']);
        array_push($arr1,'pmode');      array_push($arr2,$wh['mode']);
        array_push($arr1,'pin_fld');    array_push($arr2,$wh['in_fld']);
        foreach ($order_array as $ord) {
            if($ord['name']==$wh['name']){
                array_push($arr1,'porder');         array_push($arr2,$ord['order']);
                array_push($arr1,'porder_tax');     array_push($arr2,$ord['order_tax']);
                break;
            }
        }
        pegasus_mysql_insert('cor013',$arr1,$arr2);
        pegasusSetGlobalVar($PegInput->getRequest('grid_container_id').'_cor012_value', $cor012_nr01);
    }
    
    if($is_new){
        $message=$_SESSION['peg_dic_peg002_cor012_save_success'];
    }else{
        $message=$_SESSION['peg_dic_peg002_cor012_update_success'];
    }

    $ret=array( "ok"    =>  1,
                'msg'   =>  $message,
                "data"  =>  array(  'cor012_nr01'   =>  $cor012_nr01 ,
                                    'cor012_p01'    =>  $cor012_p01 )
            );
    echo json_encode( $ret );
?>