<?php  
class Peg002_Cookie{
    /**
     * @javascript name PEGASUS.cookiePrpName
     * @var string
     */
    public static $cookiename = 'pegasuswebappprp';
    /**
     * User profile
     * 
     * @alias p95.nr01
     * @var integer 
     */
    private $user_profile;
    /**
     * User language
     * @var string enum {GR, EN}
     */
    private $lang;
    
    /**
     * User theme
     * @var string enum {classic, ''}
     */
    private $theme;
//     $_SESSION['theme'] =  'classic';
    /**
     * 
     * @var boolean
     */
    private $updateCookie ;
    
    private $isConnect;

    private $profile;
    
    public function __construct(){
        
        
        $this->isConnect = (isset($GLOBALS['pdo']) || isset($GLOBALS['dbc']))?true:false; 
        $this->updateCookie = false;
        if(isset($_COOKIE[self::$cookiename]) && !empty($_COOKIE[self::$cookiename])){ 
            $tmpArray = json_decode($_COOKIE[self::$cookiename],true);
            if(isset($tmpArray['user_profile'])){
                $this->user_profile = $tmpArray['user_profile'];
            }
            if(isset($tmpArray['lang'])){
                $this->lang = $tmpArray['lang'];
            }
            if(isset($tmpArray['theme'])){
                $this->theme = $tmpArray['theme'];
            }
             
            if (
                !isset($_SESSION['lang']) || 
                (isset($_SESSION['lang']) && $_SESSION['lang']!=$this->lang ) 
            ) { 
                $this->setLang( $this->lang); 
            } 
            if (isset($_SESSION['theme']) && $_SESSION['theme']!=$this->theme ) {
                $this->setTheme( $this->theme);
            }
            
            if (isset($_SESSION['user_profile']) && $_SESSION['user_profile']!=$this->user_profile ) {
                if(!empty($this->user_profile )){
                    $this->setUser_profile($this->user_profile);
                }else{
                    $this->setUser_profile($_SESSION['user_profile']);
                }
            }
            
        }elseif (isset($_SESSION['lang']) || isset($_SESSION['user_profile']) ){  
            if(isset($_SESSION['user_profile'])){
                $this->setUser_profile($_SESSION['user_profile']);
            }

            
            if(isset($_SESSION['lang']) ){
                $this->setLang($_SESSION['lang']);
            }

            
            if(isset($_SESSION['theme']) ){
                $this->setTheme($_SESSION['theme']);
            }
                    
                
            $this->updateCookie = true;
        }
        
        if(empty($this->lang)){
            $this->setLang(); 
        } 
        
        if(empty($this->profile)){
            $this->profile = 0;
            
            
            if($this->isConnect && isset($_SESSION['user']) && $_SESSION['user']>0){
                $this->profile = pegasus_mysql_printfld('us0', 'p95', 'nr01 = :nr01 ', array('nr01' => $_SESSION['user']));
                $this->updateCookie = true;
            }

        }  
        if( $this->updateCookie ){
            $this->updateCookie();
        }
    }
    
    public function __destruct(){
        if( $this->updateCookie ){
            $this->updateCookie();
        }
    }
    public function getTheme(){
        return $this->theme;
    }
    public function getLang(){
        if($this->lang!='GR' && $this->lang!='EN'){
            return 'GR';
        }else{
            return $this->lang;
        }
    }
    public function getUser_profile(){
        return $this->user_profile;
    }
    public function setTheme($theme){
//         return $this->theme;
        if(in_array($theme, array('classic', 'gray', 'crisp', 'neptune', 'crisp-touch', 'neptune-touch'  ))){
            if($theme != $this->theme){
                $this->updateCookie = true;
            }
            $this->theme = $theme;
        }elseif (empty($this->theme)){
            $this->theme = 'classic';
            $this->updateCookie = true;
        }

        if(!isset($_SESSION['theme'])){
            $_SESSION['theme'] = $this->theme;
        }elseif ($_SESSION['theme'] != $this->theme ) {
            $_SESSION['theme'] = $this->theme;
        } 
        
    }
    public function setLang($lang = ''){
        if($lang == 'GR' || $lang == 'EN'){
            if($this->lang != $lang){
                $this->updateCookie = true;
            }
            $this->lang = $lang;
        }elseif (empty($this->lang)){
            
            if($this->isConnect){
                $tmp_lang = null;
                if(pegasus_module_exists('lang') && pegasus_mysql_table_exists('lang99')){
                    pegasus_mysql_use("select * from lang99 where def = 1 ", $tmp_lang);
                    if(!empty($tmp_lang['lang'])){
                        $this->lang =  $tmp_lang['lang'];
                    }
                } 
            }
 
            if(empty($this->lang) || !in_array($this->lang, array('GR', 'EN'))){
                $this->lang =  'GR';
            }
            //$this->lang = 'GR';
            $this->updateCookie = true;
        }
        if(!isset($_SESSION['lang']) ){ 
            $_SESSION['lang'] = $this->lang;
        }elseif ($_SESSION['lang']!=$this->lang ) {
            $_SESSION['lang'] = $this->lang;
        }  
    }
    public function setUser_profile($profile){
        $profile += 0;
//         die("-->". $profile);
        if($_SESSION['user'] > 0 ){
            $us0 = null;
            pegasus_mysql_use('select nr01, p97, p95 from us0 where nr01 = :nr01 ', $us0, array('nr01'=>$_SESSION['user'] ));
            if($us0['p95']!= $profile){
                if(
                    $this->isConnect && 
                    !(pegasus_mysql_printfld(
                        'p97p95', 
                        'nr01', 
                        'p95 = :profile && p97= :p97  && en=1 ',
                        array(
                            'profile' =>  $profile,
                            'p97' => $us0['p97']
                        )
                    ) > 0)
                    ){
                        $this->user_profile = $us0['p95'];
                        $this->updateCookie = true;
                        
                }else{
                    if( $this->user_profile != $profile)
                       $this->updateCookie = true;
                    
                    $this->user_profile = $profile;
                   
                }
            }else{
                if($this->user_profile != $profile)
                    $this->updateCookie = true;
                
                $this->user_profile = $profile;
            }
            if(!isset($_SESSION['user_profile'])){
                $_SESSION['user_profile'] = $this->user_profile;
            }elseif ( $_SESSION['user_profile']!=$this->user_profile ) { 
                $_SESSION['user_profile'] = $this->user_profile;
            }
        }else{
            $this->user_profile = 0;
            if(isset($_SESSION['user_profile']) ){
                $_SESSION['user_profile'] = $this->user_profile;
            }
            $this->updateCookie = true;
        }

    }
    
    public function updateCookie(){
        if(!$this->isConnect){
            return ;
        }
        $value = json_encode(array(
            'user_profile' => $this->user_profile,
            'lang' => $this->lang,
        ));
        if(!isset($_COOKIE[self::$cookiename])){
            if($_SERVER['SERVER_PORT'] == 443) {
                $cookie_path = '/; samesite=None'; // Only for version < 7.3
                $cookie_samesite = 'None';
                $cookie_secure = true;
            }else{
                $cookie_path = '/';
                $cookie_samesite = 'Lax';
                $cookie_secure = false;
            }
            if(PHP_VERSION_ID >= 70300) { 
                setcookie(self::$cookiename, $value, [
                    'expires' => null,
                    'path'    => '/',
                    'domain'  => '',
                    'secure'  => $cookie_secure,
                    'samesite'=> $cookie_samesite
                ]);
            }else{
                setcookie(self::$cookiename, $value, null, $cookie_path, '', $cookie_secure);    
            }

            // setcookie(self::$cookiename, $value, null, '/');
        }else{
            $_COOKIE[self::$cookiename] =  $value;
        }
        $this->updateCookie = false;
    }
} 
?>