<?php 

class Peg002_Grid{
    private static function validatePropertyy($par_nm,$par_val){
        return peg002_validateProperty($par_nm,$par_val);  
    }
    
    private static function addColumn($desc07, &$title_array,&$arr_grid){
        if($desc07=='selectbox' || $desc07=='comboboxV2' ){
            if( pegasus_profile_check_data_permission($arr_grid['table'], 'SHOW') && pegasus_profile_check_module_permission($arr_grid['module']) ){
                    array_push($title_array , $arr_grid);
                    return true;
            }
        }elseif ($desc07=='combobox' && $_SESSION['user']>0) {
            if(!empty($arr_grid['table'])){
                if(
                    pegasus_profile_check_data_permission($arr_grid['table'], 'SHOW')
                    ){
                        array_push($title_array , $arr_grid);
                        return true;
                }
            }else{
                array_push($title_array , $arr_grid);
                return true;
            }
        }else{
            array_push($title_array , $arr_grid);
            return true;
        } 
        return false;
    }
    
    /**
     * Return the columns of a grid
     * @param array $gridValues
     * @return array 
     */
    public static function makeColumns($gridValues,$isMobile=false){
        if(empty($gridValues['_d'])  ){
            return array();
        }  
        //Den mporei to profile na einai keno
        if($_REQUEST['isMobile']==='true' || $_REQUEST['isMobile']===true){
            $query = peg_read_file('../peg002_sql/peg002_grid_make_columns/get_fields_underprofile_mob.sql');
        }else{
            $query = peg_read_file('../peg002_sql/peg002_grid_make_columns/get_fields_underprofile.sql');
        }

        $query = str_replace(
            array('##LANG##' ),
            array($GLOBALS['userCookie']->getLang() ),
            $query);
  
             
        $res = Peg002_MySQL::pegasus_query(
            $query,
            array(
                'user_profile' => $_SESSION['user_profile'],
                'module' => $gridValues['module'],
                '_d' => $gridValues['_d']
            ) 
        );
        // var_dump(pegasus_replace_values_in_sql($query,
        // array(
        //     'user_profile' => $_SESSION['user_profile'],
        //     'module' => $gridValues['module'],
        //     '_d' => $gridValues['_d']
        // ) ));
        $title_array=array();

        
        $new_arr='';
        $arr_grid   = array();
        $desc07     = null;
        $desc05     = null; 
        $desc16 	= null;
        while ($p51=pegasus_fetch_assoc($res)) {
            if($new_arr != $p51['desc07'] . '_' .$p51['desc05']){
                if(!empty($new_arr)){
                    if(!empty($desc05)){
                        $arr_grid['field'] = $desc05;
                        $arr_grid['db_type']  = $desc16;
                        
                        Peg002_Grid::addColumn($desc07, $title_array, $arr_grid);
                        $arr_grid=array();
                    }
                     
                }
                $arr_grid['field'] = $p51['desc05'];
                $arr_grid['name']  = $p51['desc02'];
                $arr_grid['db_type']  = $p51['desc16'];
                $arr_grid['desc17']   = $p51['desc17'];
                $arr_grid['type']     = $p51['desc07'];
                $arr_grid['tax']        = $p51['tax'];
                $arr_grid['tax_mob']    = $p51['tax_mob'];
                $arr_grid['col_width']    = $p51['col_width'];
                if($p51['desc18']>0){
                    $arr_grid['desc18']  = $p51['desc18'];
                }
                
                $new_arr = $p51['desc07'] . '_' .$p51['desc05'];
            }
            
            $desc07        = $p51['desc07'];
            $desc05        = $p51['desc05']; 
            $desc16 	   = $p51['desc16'];
            
          
    
            $tmpVal = null;
            if ($p51['code']==1){
                if(empty($p51['par_val'])){
                    $tmpVal = '';
                }else{
//                     print_r($p51);
                    try {
                        $tmpVal = @eval($p51['par_val']);
                        if( $tmpVal === false && ($error = error_get_last()) ) {
                            var_dump($error);
                            die( print_r($p51, true));
                        }
                    } catch (\Throwable $th) {//PHP7
                        var_dump($th->getMessage());
                        die( print_r($p51, true));
                    }

                }
            }else{
                $tmpVal = $p51['par_val'];
            }
            
            $tmpVal = self::validatePropertyy($p51['par_nm'], $tmpVal);
           
            
            if($p51['par_nm']=='browse_title'){
                if(!empty($tmpVal)){
                    $arr_grid['name'] = $tmpVal ;
                }
            }elseif ($p51['par_nm']=='browse_flex'){
                $arr_grid['flex'] = $tmpVal;
                $arr_grid['browse_flex'] = $tmpVal;
            }else{
                $arr_grid[$p51['par_nm']] = $tmpVal;
            }
             
            
            
        }
        
        if(!empty($new_arr)){ 
            Peg002_Grid::addColumn($desc07, $title_array, $arr_grid);
        }
        $layout = array();
        foreach ($title_array as $name => $arr) {
            if(isset($arr['browse_jn_table']) && !empty($arr['browse_jn_table']) && !pegasus_mysql_table_exists( $arr['browse_jn_table'] )){
                continue;
            }
            $db_type = array(
                'header' => str_replace('\'', '\\\'' , $arr['name'] ),
                'peg_grid_name' => $gridValues['name'],
                'name' => $arr['field'] ,
                'tax' => $arr['tax'],
                'tax_mob' => $arr['tax_mob']
            ); 
            /*  peg_grid_name is set in constructor for comboboxV2 grid columns
                We removed it from stucture so that it doesn't get cached */
            if($_REQUEST['display_type'] =='_comboboxV2_grid' ){
                unset($db_type['peg_grid_name']);
            }
            if($arr['col_width']>0){
                $db_type['width']=$arr['col_width']+0;
                $db_type['flex'] =0;
            }else{
                $db_type['flex'] =0;
                if(!empty($arr['browse_flex'])){
                    $db_type['flex'] = $arr['browse_flex'];
                }else{
                    if( !empty($arr['browse_width']) ){
                        $db_type['width'] = $arr['browse_width']+0;
                    }else{
                        if(   $db_type['flex'] == 0 && $arr['type'] != 'comboboxV2'){
                            if(($arr['desc17'] * 13)>300){
                                $db_type['width'] = 300;
                            }elseif(($arr['desc17'] * 13)<50){
                                $db_type['width'] = 50;
                            }else{
                                $db_type['width'] = (($arr['desc17']+0) * 13) ;
                            }
                        }
                    }
                }
            }

            if($arr['browse_locked'] == 1){ 
                $db_type['locked'] = true;
            }

            if($arr['browse_sortable'] == '0' ){ 
                $db_type['sortable'] = false;
            }
            
            if($arr['browse_edit'] == 1){
                $db_type['editor'] = 'def';
            }else{
                $db_type['editor'] = null;
            }
            
            if( !empty($arr['allowBlank']) ){
                $db_type['allowBlank'] = $arr['allowBlank'];
            }
            
            
            if($arr['db_type']=='L'){ 
                $db_type['xtype'] = 'pegasusBooleanColumn';
                $db_type['align'] = 'center'; 
            }elseif ($arr['db_type'] == 'D' || ( $arr['db_type'] == 'V' &&  $arr['type']=='datebox' )){
                $db_type['xtype'] = 'pegasusDateColumn';
                $db_type['align'] = 'center'; 
            }elseif(!empty($arr['browse_tpl']) && $arr['browse_tpl']!=false){
                $db_type['xtype'] = 'pegasusTemplateColumn';
                // $db_type['width'] = $arr['width'];   
                $db_type['tpl'] =  trim( $arr['browse_tpl']);
            }else{
                //Start Display by type
                if ($arr['type'] == 'textbox'){
                    $db_type['xtype'] = 'pegasusTextBoxColumn';
                    $db_type['align'] = 'left'; 
                    
                }elseif ($arr['type'] == 'textarea'){
                    $db_type['xtype'] = 'pegasusTextAreaColumn';
                    $db_type['align'] = 'left'; 
                    
                }elseif ($arr['type'] == 'codemirror'){
                    $db_type['xtype'] = 'pegasusCodeMirrorColumn';
                    $db_type['align'] = 'left';
                    
                }elseif ($arr['type'] == 'numberbox'){
                    $db_type['xtype'] = 'pegasusNumberColumn';
                    $db_type['align'] = 'right';
                    
                    $db_type['format']   =   0;
                    if($arr['decimalPrecision']!=NULL){
                        $db_type['format']  =  '0.'. str_repeat(0 , (int)$arr['decimalPrecision']) ; 
                        $db_type['decimalPrecision']  =  $arr['decimalPrecision'];

                    }else{
                        if($arr['desc18']>0){
                            $db_type['format']  =  '0.'. str_repeat(0 , (int)$arr['desc18']) ; 
                            $db_type['decimalPrecision']  =  $arr['desc18'];
                        } 
                    }
                     
                    
                    if($arr['step']>0){
                        $db_type['step']  =  $arr['step'];
                    }
                    
                 
                    if(!empty($arr['minValue'])){
                        $db_type['minValue']  =  $arr['minValue'];
                    }
                    if(!empty($arr['maxValue'])){
                        $db_type['maxValue']  =  $arr['maxValue'];
                    }
                     
                }elseif ($arr['type'] == 'timefield'){ 
                    $db_type['xtype'] = 'pegasusTimeColumn';
                    $db_type['size'] = $arr['desc17'];
                }elseif ($arr['type'] == 'colorpicker'){
                    $db_type['xtype'] = 'pegasusColorPickColumn';
                }elseif ($arr['type'] == 'checkbox'){
                    $db_type['xtype'] = 'pegasusBooleanColumn';
                    $db_type['align'] = 'center'; 
                }elseif ($arr['type'] == 'combobox'){ 
                    $db_type['xtype'] = 'pegasusComboBoxColumn';
                    
                    $extradata  = array(); 
                    $ls_data = $arr['ls_data'];

                    if(!empty($ls_data )){
                        $extradata['ls_data'] = $ls_data;
                    }
                    
                    
                    $extradata['displayField'] = $arr['displayField'];
                    $extradata['valueField'] =  $arr['valueField'];
                    
                    $db_type = array_merge($db_type, $extradata);
                }elseif( $arr['type']=='selectbox' || $arr['type']=='comboboxV2' ){
                    
                    if($arr['type']=='selectbox'){
                        $db_type['xtype'] = 'pegasusSelectBoxColumn';
                    }else{
                        $db_type['xtype'] = 'pegasusComboBoxV2Column';
                    }
                    $db_type['browse_selectbox_type'] = $arr['browse_selectbox_type'];
                    
                    $extradata  = array(); 
                    $ls_data = $arr['ls_data'];
                    $table = $arr['table'];
                    
                    
                    $db_type['peg_module'] =  $gridValues['module'];
                    $db_type['peg__d']     =  $gridValues['_d'];
                    $db_type['peg_table']  =  $gridValues['table'];
                    $db_type['displayField'] = $arr['displayField'];
                    $db_type['valueField'] =  $arr['valueField'];
                    
                    if(!empty($ls_data )){
                        $db_type['ls_data'] = $ls_data;
                    }
                     
                    
                    if(!empty($table)){
                        $db_type['table'] = $table; 
                        $db_type['module'] = $arr['module'];
                        $db_type['_d'] = $arr['_d'];
                        
                    }
                    
                    if(!empty($arr['hidden_cd'])){
                        $db_type['hidden_cd'] = $arr['hidden_cd'];
                    }
                    
                    if(!empty($arr['hidden_var'])){
                        $db_type['hidden_var'] = $arr['hidden_var'];
                    } 
                    if(!empty($arr['default_search_field'])){
                        $db_type['default_search_field'] = $arr['default_search_field'];
                    }
                    if(!empty($arr['browse_jn_table'])){
                        $db_type['browse_jn_table'] = $arr['browse_jn_table'];
                    }
                    if(!empty($arr['browse_jn_as_table'])){
                        $db_type['browse_jn_as_table'] = $arr['browse_jn_as_table'];
                    }
                }elseif ( $arr['type']=='actioncolumn'){
                    $db_type['xtype'] = 'pegasuActionColumn';
                    
                    // $browse_icon =  $arr_grid['browse_icon'];  
                    $browse_icon = $arr['browse_icon'];
                    $browse_tooltip = $arr['browse_tooltip'];
                    $browse_handler = $arr['browse_handler'];
                    $browse_isDisabled = $arr['browse_isDisabled'];
                    
                    
                    
                    $itemAr =  array();
                    if(!empty($browse_icon)){
                        $itemAr['icon'] =     $browse_icon;
                    }
                    if(!empty($browse_tooltip)){
                        $itemAr['tooltip'] = $browse_tooltip;
                    }
                    if(!empty($browse_handler)){
                        $itemAr['peg_handler'] =  $browse_handler ;
                    }
                    
                    if(!empty($browse_isDisabled)){
                        $itemAr['pegIsActionDisabled'] =   $browse_isDisabled ;
                    }
                    
                     
                    
                    
                    $db_type['items'] = array($itemAr);
                    // $db_type['items']=$itemAr;
                    
                }
            }
              
            if(!empty($arr['browse_summaryType'])){ 
              

                switch ($arr['browse_summaryType']) {
                    case 'sum':
                        if($gridValues['summary_en'] == 1){
                            $db_type['summaryType'] = $arr['browse_summaryType'];
                            $db_type['summary'] = 'Ext.data.summary.Sum';
                        }

                    break;
                    
                    default:
                        $db_type['summaryType'] = $arr['browse_summaryType'];
                    break;
                } 
            }
            
            if(empty($db_type['xtype'] )){
                $db_type['xtype'] = 'pegasusColumn';
            } 
            if(!empty($arr['type'])){
                $db_type['desc07'] = $arr['type'];
                $db_type['desc16'] = $arr['db_type'];

            }
            if($arr['type']=='numberbox'){
                $db_type['thousand_format'] = 0;
                if($arr['thousand_format']>0){
                    $db_type['thousand_format']=$arr['thousand_format'];
                }
            }
            $layout[] = $db_type;
                 
            
        }
        
        
        return $layout;
    }

    public static function makeFields($gridValues,$isMobie=false){ 
        $grid_fields = array();
         
       
        if(empty($gridValues['_d'])  ){
            return $grid_fields;
        }
        if($isMobie){
            $query = peg_read_file('../peg002_sql/peg002_grid_make_fields/get_fields_underprofile_mob.sql');

        }else{
            $query = peg_read_file('../peg002_sql/peg002_grid_make_fields/get_fields_underprofile.sql');
        } 
        $query = str_replace(
            array('##LANG##' ),
            array($GLOBALS['userCookie']->getLang() ),
            $query);
         
        $res = Peg002_MySQL::pegasus_query(
            $query,
            array(
                'user_profile' => $_SESSION['user_profile'], 
                '_d' => $gridValues['_d'],
                'module' => $gridValues['module']
            )
        );
 
        /**
         * Return the fields of a grid
         * To create the model of sencha store
         */
        while ($p51=pegasus_fetch_assoc($res)) { 
            //TODO Add module permitions
            $arr = array();
            $arr2 = array();
            
			/* προσθέσαμε και τα V / NumberBox για να μπορουν να παιζουν σωστα τα συνολα και σε αυτά τα πεδια */ 
            if($p51['desc16']=='N' or ( $p51['desc16']=='V' and $p51['desc07']=='numberbox') ){
                $type='number';
                if($p51['desc18']>0){
                    $arr['format'] = '0' .$_SESSION['cor000_decimal_char']. str_repeat(0 , $p51['desc18']) ; 
                }
            }else if( ( $p51['desc16']=='C' && $p51['desc07']!='timefield') || $p51['desc16']=='M' ){
                $type='string'; 
            }else if( $p51['desc16']=='L'   ){
                $type='boolean';
            }else if( $p51['desc16']=='D' ||  $p51['desc07']=='timefield' || (  $p51['desc16']=='V' && $p51['desc07']=='datebox' ) ){
                $type='date';
                if( $p51['desc07']=='timefield' ){
                    if(  $p51['desc17']> 5){
                        $arr['dateFormat'] = 'H:i:s';
                    }else{
                        $arr['dateFormat'] = 'H:i';
                    }

                }else{
                    $arr['dateFormat'] = 'Y-m-d';
                }
            }else{
                $type='';
            }
            if(($p51['desc07']!='selectbox' and $p51['desc07']!='comboboxV2') or (!empty($p51['par_val'])) ){
                
                
                $arr['name'] = $p51['desc05'];
                if(!empty($type)){
                    $arr['type'] = $type;
                }
                
            }else{
                
                $arr['name'] = $p51['desc05'];
                
                if(!empty($type)){
                    $arr['type'] = $type;
                }
                
                
                $arr2['name'] = 'v_selectbox_'. $p51['desc05'] ;
                $arr2['type'] = 'string';
                
            }
            if($arr['name'] == 'nr01'){
                $arr['critical'] = true;
            }
            
            $grid_fields[] =  $arr ;
            if(count($arr2)>0){
                $grid_fields[] = $arr2;
            }
        }
        return $grid_fields; 
    } 
    /**
     * Return the docked items of a grid
     * @param array $gridValues
     * @return string[][] 
     */
    public static function makeDockedItems($gridValues){
        $pegasusToolBarAr = array(); 
        $menu = array();
        $pos = 'top';
        
        $table = trim($gridValues['table']);
        if(
            (!empty($gridValues['record_insert'])) or
            (!empty($gridValues['record_change'])) or
            (!empty($gridValues['record_copy'])) or
            (!empty($gridValues['record_delete'])) or
            (!empty($gridValues['record_clear_filters'])) or
            (!empty($gridValues['record_search'])) 	or
            (!empty($gridValues['record_refresh'])) or
            (!empty($gridValues['record_panafores'])) 	or
            (!empty($gridValues['record_print_forms'])) or
            (!empty($gridValues['record_mng_col']))  or
           
            
            (!empty($gridValues['record_custom_actions']))
            ){
               
                $pegasusToolBarAr[$pos] = array(
                    'xtype' => 'pegasusToolBar',
                    'dock'=> $pos, 
                    'peg_desc' => 'pegasusTop',
                    'items' => array()
                );
                
                $tableInsert    = pegasus_profile_check_data_permission($table , 'INSERT' ,  $_SESSION['user_profile'] ) ;
                $tableDelete    = pegasus_profile_check_data_permission($table , 'DELETE' ,  $_SESSION['user_profile'] );
                $tableShow      =  pegasus_profile_check_data_permission($table , 'SHOW' , $_SESSION['user_profile']);
                
                
                
                $profileMailEn = pegasus_profile_check_module_permission('mail');
                $profileQueryEn = pegasus_profile_check_module_permission('query');
                $profileMassexportEn = pegasus_profile_check_module_permission('massexport');
                $profileSms000En = pegasus_profile_check_module_permission('sms00');
                
                
                if( !empty($gridValues['record_insert']) && $tableInsert ){
                    $toolbar_item =    array(
                        'xtype' => 'pegasusToolBarGridInsert',
                        'iconCls'=> 'icon-insert', 
                        'text'=>  $_SESSION['peg_dic_core_insert'] . " (Ins) " 
                    ); 
                    $pegasusToolBarAr[$pos]['items'][] = $toolbar_item; 
                    $toolbar_item['xtype'] = 'pegasusToolBarGridItemInsert' ;
                    $menu[] = $toolbar_item;
                }
                if(!empty($gridValues['record_change']) && $tableShow){
                    $extTitle = ' (Ctrl+E)';
                    $toolbar_item =    array(
                        'xtype' => 'pegasusToolBarGridEdit',
                        'iconCls'=> 'icon-edit',
                        'text'=>  $_SESSION['peg_dic_core_change'] .  $extTitle
                    );
                    $pegasusToolBarAr[$pos]['items'][] = $toolbar_item;
                    $toolbar_item['xtype'] = 'pegasusToolBarGridItemEdit' ;
                    $menu[] = $toolbar_item;
                }

                 
                if(!empty($gridValues['record_copy']) &&  $tableInsert ){
                    $extTitle = ' (Ctrl+C)'; 
                    
                    $toolbar_item =  array(
                        'xtype' => 'pegasusToolBarGridCopy',
                        'iconCls'=> 'icon-copy',
                        'text'=>  $_SESSION['peg_dic_core_copy'] . $extTitle
                        
                    );
                    $pegasusToolBarAr[$pos]['items'][] = $toolbar_item;
                    $toolbar_item['xtype'] = 'pegasusToolBarItemCopy' ;
                    $menu[] = $toolbar_item;
                    
                }
                 
                if(!empty($gridValues['record_delete']) &&  $tableDelete  ){
                    $toolbar_item = array(
                        'xtype' => 'pegasusToolBarGridDeleteRec',
                        'iconCls'=> 'icon-delete',
                        'text'=>  $_SESSION['peg_dic_core_delete'] .  " (Del) "
                        
                    ); 
                    $pegasusToolBarAr[$pos]['items'][] = $toolbar_item;
                    $toolbar_item['xtype'] = 'pegasusToolBarGridItemDeleteRec' ;
                    $menu[] = $toolbar_item;
                }  
                if(!empty($gridValues['record_clear_filters'])){
                    $toolbar_item =    array(
                        'xtype' => 'pegasusToolBarGridClearFilters',
                        'icon'=>   "core_images/clean.png",
                        'text'=>  $_SESSION['peg_dic_core_clear_filters'] .  " (F3) "
                        
                    );
                    $pegasusToolBarAr[$pos]['items'][] = $toolbar_item;
                    $toolbar_item['xtype'] = 'pegasusToolBarGridItemFilters' ;
                    $menu[] = $toolbar_item;
                }

                     
                if(!empty($gridValues['record_search'])){
                    $toolbar_item =    array(
                        'xtype' => 'pegasusToolBarGridSearch',
                        'iconCls'=> 'icon-search',
                        'text'=>  $_SESSION['peg_dic_core_search'] .  " (F2) " 
                    ); 
                     $pegasusToolBarAr[$pos]['items'][]  = $toolbar_item;
                     $toolbar_item['xtype'] = 'pegasusToolBarGridItemSearch' ;
                     $menu[] = $toolbar_item;
                }
                
                if(!empty($gridValues['record_refresh'])){
                     $toolbar_item =    array(
                        'xtype' => 'pegasusToolBarGridRefresh',
                        'iconCls'=> 'icon-refresh',
                        'text'=>  $_SESSION['peg_dic_core_refresh']  
                    ); 
                     $pegasusToolBarAr[$pos]['items'][] = $toolbar_item;
                     $toolbar_item['xtype'] = 'pegasusToolBarGridItemRefresh' ;
                     $menu[] = $toolbar_item;
                }
                
                if(!empty($gridValues['record_mng_col'])){
                    $toolbar_item =    array(
                        'xtype' => 'pegasusToolBarGridMngCol',
                        'iconCls'=> 'icon-config',
                        'text'=>  $_SESSION['peg_dic_core_grid_conf_cols']
                    );
                    $pegasusToolBarAr[$pos]['items'][] = $toolbar_item;
                    $toolbar_item['xtype'] = 'pegasusToolBarGridItemMngCol' ;
                    $menu[] = $toolbar_item;
                }
                 
                if(!empty($gridValues['record_panafores']) && $profileQueryEn){
                     $toolbar_item  =    array(
                        'xtype' => 'pegasusToolBarGridQueryPAnafores',
                        'iconCls'=> 'icon-query',
                        'text'=>  $_SESSION['peg_dic_query_panafores']
                    ); 
                    $pegasusToolBarAr[$pos]['items'][] = $toolbar_item;
                    $toolbar_item['xtype'] = 'pegasusToolBarGridItemQueryPAnafores' ;
                    $menu[] = $toolbar_item;
                }
                
                if(!empty($gridValues['record_print_forms'])){
                    $toolbar_item  =    array(
                        'xtype' => 'pegasusToolBarGridPrintForms',
                        'iconCls'=> 'icon-prints',
                        'text'=>  $_SESSION['peg_dic_core_print_forms']
                    );
                    $pegasusToolBarAr[$pos]['items'][] = $toolbar_item;
                    $toolbar_item['xtype'] = 'pegasusToolBarGridItemPrintForms' ;
                    $menu[] = $toolbar_item;
               }
                
               if(!empty($gridValues['record_send_mail']) &&   $profileMailEn){
                    $toolbar_item =    array(
                        'xtype' => 'pegasusToolBarGridMailSend',
                        'iconCls'=> 'icon-mail',
                        'text'=>  $_SESSION['peg_dic_mail_sent']
                    );
                    $pegasusToolBarAr[$pos]['items'][] = $toolbar_item;
                    $toolbar_item['xtype'] = 'pegasusToolBarGridItemMailSend' ;
                    $menu[] = $toolbar_item;
               }
            //    die(var_dump(!empty($gridValues['record_send_sms']), $profileSms000En));
               if(!empty($gridValues['record_send_sms']) &&   $profileSms000En){
                    $toolbar_item =    array(
                        'xtype' => 'pegasusToolBarGridSmsSend',
                        'iconCls'=> 'fas fa-sms',
                        'text'=>  $_SESSION['peg_dic_sms_sent']
                    );
                    $pegasusToolBarAr[$pos]['items'][] = $toolbar_item;
                    $toolbar_item['xtype'] = 'pegasusToolBarGridItemSmsSend' ;
                    $menu[] = $toolbar_item;
               }
                
               if(!empty($gridValues['record_export'])  && $profileMassexportEn){
                    $toolbar_item  =    array(
                        'xtype' => 'pegasusToolBarGridMassExport',
                        'iconCls'=> 'icon-massexport',
                        'text'=>  $_SESSION['peg_dic_massexport_title']
                    );  
                    $pegasusToolBarAr[$pos]['items'][] = $toolbar_item;
                    $toolbar_item['xtype'] = 'pegasusToolBarGridItemMassExport' ;
                    $menu[] = $toolbar_item;
               }
                if(!empty($gridValues['record_custom_actions']) ){
                    if(is_array($gridValues['record_custom_actions']) && count($gridValues['record_custom_actions'])>0 ){ 
                        foreach ($gridValues['record_custom_actions'] as $item){
                            $pegasusToolBarAr[$pos]['items'][]  =    $item;
                            $item['xtype'] = 'pegasusToolBarGridItemAction' ;
                            $menu[] = $item;
                        } 
                    }
                }
 
        
        }
        if(count($pegasusToolBarAr)> 0 and empty($pegasusToolBarAr['top'] )  ){
            $pegasusToolBarAr['top'] = array(
                'xtype' => 'pegasusToolBar',
                'dock'=> 'top',
                'items' => array()
            ); 
        }
        if(count($menu)>0 ){ 
                array_unshift(
                    $pegasusToolBarAr['top']['items'],
                    array(
                        'xtype' => 'pegasusToolBarMenu',
                        'text' => $_SESSION['peg_dic_core_actions'] ,
                        'icon' =>   "core_images/menu_16x16.png" ,
                        'peg_pos' => $gridValues['name'].'_top', 
                        'menu' => $menu
                    )
                 ); 
        }
        
        $retAr = array();
        foreach($pegasusToolBarAr as $value){ 
            if(count( $value['items'] ) == 0){
                continue;
            }
            $retAr[] = $value;
        }
        return $retAr; 
    } 

}

