<?php
function peg002_fileManager_validMIMEType($mimeType, $text = true, $images = true, $audio = true, $video = true, $application = true  ){
    $mimeTypeAr = explode('/', $mimeType);
    
    switch ($mimeTypeAr[0]) {
        case 'text':
            if($mimeTypeAr[1] == 'plain'){
                return true;
            }
        break;
        case 'image':
            return in_array($mimeTypeAr[1], array('gif', 'png', 'jpeg', 'webp'));
        break;
        case 'audio':
            return in_array($mimeTypeAr[1], array('midi', 'mpeg', 'webm', 'ogg', 'wav'));
        break;
        case 'video':
            return in_array($mimeTypeAr[1], array(  'webm', 'ogg'));
        break;
        case 'application':
            return in_array($mimeTypeAr[1], array(  'vnd.openxmlformats-officedocument.wordprocessingml.document','vnd.mspowerpoint', 'pdf','zip'));
        break;
        default:
            return false;
        break;
    }
    return false;
    
    
}

function peg002_fileManager_uploadFile($_file_path){
    $retArray = array(
        'ok' => 0,
        'msg' => ''
    );
    
    $rootFileDir = '../../images/';
    $images_path='../../images/';
    
    $_file_path_real=realpath($_file_path);
    $images_path_real=realpath( $images_path);
    if(substr($_file_path_real,0,strlen($images_path_real))!==$images_path_real){
        $retArray['msg']=str_replace('##folder##',$_file_path,$_SESSION['peg_dic_peg002_filemanager_folder_perm_deny']);
        return $retArray;
    }
    if(!file_exists($rootFileDir)){
        $ret = @mkdir($rootFileDir);
        if(!$ret){ 
            $retArray['msg']  = 'Check the folder permissions ('.$rootFileDir.')';
            return $retArray;
        }
    }
    
    if(empty( $_file_path ) || strpos( $_file_path , $rootFileDir)!==0){
        $retArray['msg']  = 'Wrong file path ("'. $data['_file_path'].'")';
        return $retArray;
    }
    
    $filedir = '../../images';
    $fileDirArray = explode('/', str_replace($rootFileDir, '', $_file_path ) );
    if(is_array($fileDirArray) && count($fileDirArray)>0 ){
        $filedir.='/';
    }
    foreach ($fileDirArray as $value) {
        if(!empty($value)){
            $filedir .= $value .'/';
        }
        
        if(!file_exists($filedir)){
            $ret = @mkdir($filedir);
            if(!$ret){
                $retArray['msg']  = 'Check the folder permissions ('.$rootFileDir.')';
                return $retArray;
                
            }
            
        }
    }
    
    if ($_FILES['vph']["error"]==0) {
        if(!(peg002_fileManager_validMIMEType($_FILES['vph']['type']))){
            $retArray['msg']  = 'Not valid file type ("'.$_FILES['vph']['type'].'")';
            return $retArray;
        }
        
        pegasusSetGlobalVar('peg002__peg002_upload_d_name'.session_id() ,$_FILES['vph']["name"] );
        pegasusSetGlobalVar(
            'peg002__peg002_upload_d__file_path'.session_id() ,
            str_replace('../..', '' , $filedir)
            );
        
        move_uploaded_file($_FILES['vph']["tmp_name"] , $filedir . $_FILES['vph']["name"]);
    }else{ 
        $retArray['msg']  = core_upload_file_error_to_msg($_FILES['vph']["error"]);
        return $retArray;
    }
    
    $retArray['ok'] = 1;
    return $retArray;
}
?>