function prints01_prints01_01_d_afterDraw_listeners(container_id){	
	var screen   = pegGetCmp(container_id);
	var button00 = pegGetCmp(container_id, 'button00');
	var button01 = pegGetCmp(container_id, 'button01');

	button00.setPeg_handler(function (me) {
		var ip   = pegGetVal('ip', container_id);
		var port = pegGetVal('port', container_id);
		prints01_websocket_connect(ip, port, container_id, {'type':'check'});
	});
	
	button01.setPeg_handler(function (me) {
		var ip   = pegGetVal('ip', container_id);
		var port = pegGetVal('port', container_id);
		prints01_websocket_connect(ip, port, container_id, {'type':'fetch_printers'});
	});
}

function prints01_websocket_connect(ip, port, container_id, params) {
	var wsUri 	= "ws://" + ip + ":" + port;

	try {
		peg002_mask();
		var websocket = new WebSocket(wsUri);

		websocket.onopen = function (evt) { 
			prints01_websocket_on_open(evt, params, container_id);
		};

		websocket.onerror = function (evt) { 
			prints01_websocket_on_error(evt, container_id); 
		};
		
		websocket.onclose = function (evt) { 
			prints01_websocket_on_close(evt, container_id); 
		};

		websocket.onmessage = function (evt) { 
			prints01_websocket_on_message(evt, container_id);
		};
											
	} catch (error) {
		peg002_unmask();
		pegAlert(error);
	}
}

function prints01_websocket_on_open(evt, params, container_id) {
	//console.log('on_open');

	var websocket = evt.target;
	if(params==undefined || params.type=='check'){
		websocket.close();
		pegGetDic('prints01_check_ws_connection_succesful', function (desc) {
			peg002_unmask();
			pegAlert(desc);
		});
	}else{
		prints01_websocket_send(evt, params, container_id);
	}	
}


function prints01_websocket_on_error(evt, container_id) {
	//console.log('on_error');
	//console.log(evt);
	peg002_unmask();
}


function prints01_websocket_on_close(evt, container_id) {
	//console.log('on_close');
	//console.log(evt);
	peg002_unmask();
	if (evt.code == 1006) {//https://developer.mozilla.org/en-US/docs/Web/API/Closeevt
		pegGetDic('prints01_check_ws_connection_failed', function (desc) {
			pegAlert(desc);
		});
	}
}

function prints01_websocket_send(evt, params, container_id){
	var websocket = evt.target;
	websocket.send(JSON.stringify(params));
}

function prints01_websocket_on_message(evt, container_id){
	//console.log('on_message');
	console.log(evt);
	var websocket = evt.target;
	var data = JSON.parse(evt.data);
	
	if(data.type=="fetch_printers"){
		prints01_set_active_printers(websocket, container_id, data);
	}else if(data.type=="print_document"){
		if(data.response.ErrorCode!="OK"){
			//pegAlert(data.response.Message + ' ['+ data.response.ErrorCode +']');
			pegGetDic('prints01_ws_error_'+data.response.ErrorCode.toLowerCase(), function (desc) {
				pegAlert(desc);
			});	
		}
		peg002_unmask();
		websocket.close();
	}
}

var prints01_set_active_printers_ajax = '';
function prints01_set_active_printers(websocket, container_id, data){

	if (prints01_set_active_printers_ajax) {
		if (prints01_set_active_printers_ajax.id>0) {
			Ext.ux.AjaxDefer.abort(prints01_set_active_printers_ajax);
		}
	}	
	
	var url    = '/'+ main_path +'/prints01_01/set_active_printers.php';
	var params = {};
	params.container_id = container_id;
	params.prints01_01  = pegGetVal('nr01', container_id);
	params.type 		= data.type;
	params.printers     = data.printers.toString();

	prints01_set_active_printers_ajax = pegAjaxDefer(url, params, 
												function(jsonData) {	
													if(jsonData['ok']==1){
														pegGridRefresh(container_id, "grid", -1);
													}else{																		
														pegAlert(jsonData.msg);														       	 
													}
													peg002_unmask();
													websocket.close();														
											  });
}

var prints01_check_printer_availability_ajax = '';
function prints01_check_printer_availability(p85_nr01, params){

	if (prints01_check_printer_availability_ajax) {
		if (prints01_check_printer_availability_ajax.id>0) {
			Ext.ux.AjaxDefer.abort(prints01_check_printer_availability_ajax);
		}
	}	
	
	var url = '/'+ main_path +'/prints01_01/check_printer_availability.php';
	params.p85_nr01 = p85_nr01;

	peg002_mask();
	prints01_check_printer_availability_ajax = pegAjaxDefer(url, params, function(jsondata){
		peg002_unmask();
		if(jsondata.ok!=0 && jsondata.data.nr01!=undefined){
			//console.log(jsondata);
			var ip 		= jsondata.data.prints01_01_ip;
			var port 	= jsondata.data.prints01_01_port;
			var printer = jsondata.data.prints01_02_printer;
			
			prints01_websocket_connect(ip, port, params.dias_container_id, {'type':'print_document','printer':printer,'id':jsondata.id});
		}else{
			prints_printToPDF(p85_nr01, params);
		}
	});
}