<?php
    require_once '../prints01_00/header.php'; 
    global $PegInput; 
    
    $payload  = array();
    $response = array('ok'=>1, 'msg'=>'');

    $payload_fields = ["container_id","prints01_01","type","printers"];             
    foreach($payload_fields as $fld) {
        $PegInput->addVar(new peg_input_alphanumeric($fld));
        $payload[$fld] = $PegInput->getRequest($fld);
    }
    
    $values_arr       = array('prints01_01'=>$payload['prints01_01']);
    $prints01_01_nr01 = pegasus_mysql_printfld('prints01_01', 'nr01', 'nr01=:prints01_01', $values_arr);
    if(!($prints01_01_nr01>0)){
        $response['ok']  = 0;
        $response['msg'] = $_SESSION['peg_dic_prints01_fetch_printers_ws_not_exist'];
        echo json_encode($response);
        return;
    }
    
    $printers_arr = explode(',', $payload['printers']);
    foreach ($printers_arr as $printer) {
        $values_arr['printer'] = $printer;

        $prints01_02_nr01 = pegasus_mysql_printfld('prints01_02', 'nr01', 'prints01_01=:prints01_01 and printer=:printer', $values_arr);
        if(!($prints01_02_nr01>0)){
            $arr1 = array();                    $arr2 = array();
            array_push($arr1, 'nr01');          array_push($arr2, pegasus_mysql_newrec('prints01_02'));
            array_push($arr1, 'prints01_01');   array_push($arr2, $payload['prints01_01']);
            array_push($arr1, 'printer');       array_push($arr2, $printer);

            pegasus_mysql_insert('prints01_02', $arr1, $arr2);
        }
    }

    //Διαγραφω τους Εκτυπωτες που το ονομα τους δεν βρεθηκε κατα την Ευρεση Εκτυπωτων
    if(is_countable($printers_arr) && count($printers_arr)>0){
        $where       = 'prints01_01=:prints01_01';
        $values_arr  = array('prints01_01'=>$payload['prints01_01']);

        $in_printers = pegasus_mysql_create_in($printers_arr, 'printer');
        if(!empty($in_printers['sql'])){
            $where .= ' and printer not in (' . $in_printers['sql'] . ')';
            $values_arr = array_merge($values_arr, $in_printers['sqlParams']);
        }
        $response['ddd'] = pegasus_replace_values_in_sql($where,$values_arr);
        pegasus_mysql_delete('prints01_02', $where, 1, $values_arr);
    }
    
    echo json_encode($response);
    return;