<?php
    require_once '../prints00/header.php';  
     
    $ret_arr = array();
    $ret_arr['ok']  = 1;  
    $ret_arr['msg'] = '';

    $req_array = array();
    $req_keys  = array( 
        'p85_nr01'=>'number',
        'prints_01p00'=>'alphanumeric',
    );

    foreach ($req_keys as $key => $value){
        switch ($value) {
            case 'number':
                $PegInput->addVar(new peg_input_number($key)); 
                break;
            
            case 'alphanumeric':
                $PegInput->addVar(new peg_input_alphanumeric($key)); 
                break;
                
            case 'HTML':
                $PegInput->addVar(new peg_input_HTML($key)); 
                break;
        }
        $req_array[$key] = $PegInput->getRequest($key);
    }

    $printsData = new PrintsData($req_array['p85_nr01'], session_id());
    $expressions_arr = $printsData->getStandardExpressions($req_array['prints_01p00']);
    

    $ret_arr['descr_readonly'] = 0;
    $ret_arr['p30_disabled']   = 0;
    if(count($expressions_arr)==1){
        $descr_arr = explode('->', $expressions_arr[0]['p01']);
        $descr = trim(end($descr_arr));
        if(count($descr_arr)>1){
            $descr .= ' [' . $expressions_arr[0]['p01'] . ']';
        }

        $ret_arr['descr']   = $descr;        
        $ret_arr['tp']      = $expressions_arr[0]['p05'];        
        $ret_arr['p30']     = $expressions_arr[0]['p30'];
        if($expressions_arr[0]['p05']=='exp'){
            $ret_arr['size'] = ($expressions_arr[0]['p02']=='L') ? 3 : $expressions_arr[0]['p03'];
        }

        if($expressions_arr[0]['p100']==1){
            $ret_arr['pos'] = 2;
        }

        $ret_arr['descr_readonly'] = 1;
        $ret_arr['p30_disabled']   = 1; 
    }
    
    $ret_arr['expressions_arr'] = $expressions_arr;
    $ret_arr['dbg'] = $req_array;
            
    
    echo json_encode($ret_arr);
    return;
?>