<?php

	if(file_exists('../../pegasus_cloud_app/prints_libs/TCPDF/tcpdf.php')){
		require('../../pegasus_cloud_app/prints_libs/TCPDF/tcpdf.php');
	}else{
		if(!file_exists('../../pegasus_cloud_app/core_libs/tcpdf/tcpdf.php')){
			die('File core_libs/tcpdf/tcpdf.php not found');
		}	
		require('../../pegasus_cloud_app/core_libs/tcpdf/tcpdf.php');
	}
    
    class pegTCPDF extends TCPDF { 
    	private static $tmpPath = '../../tmp/_tcpdf_print/';
    	
    	/**
    	 * Boolean metavliti opoi tha kanei brake to body
    	 * anejartita tou 
    	 * @var bool
    	 */
    	public $bodyBreak  = FALSE;
    	
    	/**
    	 * Sthn allagi selidaw h aritmisi twn grmmwn prepei na jekinaei apo to 0
    	 * @var int
    	 */
    	public $minusGrammes;
    	/**
    	 * To offset se grammes (se kathe nea selida midenizetai)
    	 * @var double
    	 */
    	public $offset_y;
    	 
    	public $custom_offset_y;
    	/**
    	 * To offset se stiles (se kathe nea selida midenizetai)
    	 * @var double
    	 */
    	public $offset_x;
    	 
    	public $custom_offset_x;
    	
    	/**
    	 * To upsos toy header (se kathe nea selida midenizetai)
    	 * @var double
    	 */
		public $max_head_row;	
		
		/**
		 * extra_height_on_top Το χρησιμοποιώ για να κατεβάζω το header πιο κάτω 
		 * αν το τελευταίο στοιχείο εκτυπώθηκε και στη νέα σελίδα
		 * Παίρνει τιμή μόνο όταν εκτυπώνεται το header μόνο μία φορά
		 * Το χρησιμοποιώ μόνο για το header. Αλλιώς η εκτύπωση έχει κατέβει προς τα κάτω λόγω του max_head_row 
		 * @var double
		 */
		public $extra_header_height_on_top_header_once;

    	/**
    	 * To upsos toy body (se kathe nea selida midenizetai) kai arxikopoieite apo to pp85
    	 * @var double
    	 */
    	public $bodyheight;
    	
    	 
    	
    	/**
    	 * H panafora apo diavazw ta dedomena
    	 * @var number
    	 */
    	private $dataDourceQ10;
    	/**
    	 * O p;inakas pou diavazw ta dedomena
    	 * @var string
    	 */
    	private $dataDourceP50;
    	
    	private $width;
    	private $height;
    	
    	/**
    	 * Toplithis ton grammvn tis ektypwsis
    	 * @var int
    	 */
    	private $grammes;
    	/**
    	 * To plitos twn stilwn ths ektiposis
    	 * @var int
    	 */
    	private $stiles;
    	/**
    	 * Sintelestis anamesa sto upsos ths forma me to plithos ton grammvn
    	 * ($this->h /$this->grammes)
    	 * @var float
    	 */
    	private $g_height;
    	/**
    	 * Sintelestis anamesa sto platos ths forma me to plithos twnstilwn
    	 * ($this->w )/$this->stiles;
    	 * @var float
    	 */
    	private $s_width;
    	
    	
    	
    	
    	/**
    	 * To top margin se grammes
    	 * @var int
    	 */
    	private $top_margin;
    	/**
    	 * To right margin se stiles
    	 * @var int
    	 */
    	private $right_margin;
    	/**
    	 * To bottom margin se grammes
    	 * @var int
    	 */
    	private $bottom_margin;
    	/**
    	 * To left margin se stiles
    	 * @var int
    	 */
    	private $left_margin;
    	
    	/**
    	 * Ean tha ektypvnete to header mia fora
    	 * to xreiazome gia na mhn epireazw to bodyheight
    	 * @var boolean
    	 */
    	private $printHeaderOnce;
    	/**
    	 * Poio einai to plithos ton dedomenwn poy exoyn ektypothei sto body of this page
    	 * @var int
    	 */
    	private $body_rows_i;
    	/**
    	 * To path gia thn bg eikona
    	 * @var string 
    	 * 
    	 * @example 
    	 *     ../../imagename
    	 */
    	private $bgImage;
    	
    	/**
    	 * To teleytaio upsos poy epsestrepse h _getHeight
    	 * @var double
    	 */
    	private $peg_tmp_lasth;
    	/**
    	 * Ti tiposai gia teleytaia fora
    	 * @var string
    	 *     enum {
    	 * 		  line	=> Grammi
    	 * 		  exp		=> ektipwnei keli (ekfrasi)
    	 * 		  exp_memo=> keimeno me anadiplwsi
    	 * 		  exp_html=> Ektipwnei html
    	 * 		  image	=> eikona
    	 *     }
    	 */
    	private $peg_tmp_lastPrintType;
    	/**
    	 * Pou tioposai gia teleutaia fora
    	 * @var enum{1=> header,2 => body,3 => footer}
    	 */
    	private $peg_tmp_lastPosition;
    	/**
    	 * Ean tha prepei na mhdenistoun oi grammes giati exw allagi selidas
    	 * @var boolean
    	 */
    	private $updMinusTrigger;
    	/**
    	 * To trigger pou mou leei otu prepei na ekrelesv to add body i
    	 * Diladi exei prostethei ena neo eidos sthn ektipwsei
    	 * @var boolean $triggerAddBodyRow
    	 */
    	private $triggerAddBodyRow;
    	
    	
    	
    	/**
    	 * H i eggrafi poy ektypwnw sthn selida
    	 * @var int
    	 */
    	private $body_tmp_i;
    	/**
    	 * Poio einai to plithos ton dedomenwn poy exoyn ektypothei sto body
    	 * @var array{};
    	 */
    	private $body_row_i_data;
    	/**
    	 * Einai true otan ekteleite to flush data gia na ektypvenei dedomena sto body
    	 * @var boolean
    	 */
    	private $bodyFlush	= FALSE;
    	/**
    	 * Poia einai h megaliteri grammi pou typwsai gia teleytaia
    	 * fora sto body
    	 */
		private $peg_tmp_last_bodyrow;
		





		private $peg_tmp_last_body_rowstart;     		
		private $peg_tmp_last_body_rowend  ;

    	/**
    	 * Thelw na jerw poia einai h megaliteri grammi apo thn trecousa ektipwsi
    	 */
    	private $peg_tmp_last_body_current_row;
    	/**
    	 * Ean tha einai disable h ektupwsi toy footer
    	 * @var boolean $vdisft
    	 */
    	private $vdisft = false;
    	
    	private $cashingAddFont = array();
    	
    	private $fillColorAr;
    	private $drawColorAr;
    	private $textColorAr;
    	//XXX Start metavlites poy ektipwnonte apo th forma 
    	private $formPage;
    	
    	/**
    	 * 
    	 * @param string $var
    	 * @param string $string
    	 */
    	
    	private function _writeLogFile($var='', $string=''){
    		return;
    		$mode = 'a';
    		/* if($this->execForTime==0){
    			$mode = 'w';
    			} */
    	
    		$fp = fopen(pegTCPDF::$tmpPath.'/tcpdf.log', $mode );
    		if($fp === false){
    			die('Error ' . pegTCPDF::$tmpPath.'/tcpdf.log');
    		}
    		if(!empty($var)){
    			fprintf($fp, 
    					"Export Var:\n %s \n\n ###\n\n",
    					var_export($var,true) );
    		}
    		if(!empty($string)){
    // 			$string
    			fprintf($fp,
    					" \n ###\n Export Var: %s \n ###\n",
    					$string );
    		
    			
    		}
    		
    		fclose($fp);
    	}
    	
    	public function __construct(
    					$grammes , $stiles , $total_width , $total_height , 
    					$orientation='P', $unit='mm', $size='A4' ,  $top_margin=0 ,
    					$left_margin=0 , $bottom_margin=0 , $right_margin=0 ,
    					$printHeaderOnce = false
    			){
    		parent::__construct($orientation,$unit,$size);
    		
    		$this->width = $total_width;
    		$this->height = $total_height;
    		
    		
    		$this->updMinusTrigger	= false;
    		$this->minusGrammes		= 0;
    		$this->offset_y			= 0;
    		$this->offset_x			= 0;
    		$this->custom_offset_y = 0;
    		$this->custom_offset_x = 0;
    		 
			$this->max_head_row		= 0;
			$this->extra_header_height_on_top_header_once = 0;
    		$this->bodyheight		= 0;
    		/* $thkis->body_rows_i		= 0; */
    		$this->lastRow			= 0;
    		$this->peg_tmp_lastPosition = 0;
    		$this->peg_tmp_last_bodyrow = 0;
			$this->peg_tmp_last_body_current_row = 0;
			
			$this->peg_tmp_last_body_rowstart = 0;     		
			 $this->peg_tmp_last_body_rowend   = 0;  
			 
    		$this->printHeaderOnce = $printHeaderOnce;
    		$this->url = "";
    		$this->peg_color = array(
    				'maincolor' =>
    				array('r' => '', 'g' => '', 'b' => '') ,
    				'linkcolor' =>
    				array('r' => '', 'g' => '', 'b' => '')
    		);
    		
    		$this->triggerAddBodyRow = false;
    		
    		$this->_setGrammes($grammes);
    		$this->_setStiles($stiles);
    		
    		
    		
    		
    		/* $this->_setTotalWidth($total_width);
    		$this->_setTotalHeight($total_height);*/
    		$this->_setLeftMargin($left_margin);
    		$this->_setTopMargin($top_margin);
    		$this->_setRightMargin($right_margin);
    		if($bottom_margin<4){
    			$bottom_margin = 4;
    		} 
    		$this->bottom_margin  = $bottom_margin; 
    		
    		$this->SetAutoPageBreak(true, $this->_getTCPDFYFromGrammi(0));
    		$this->SetFooterMargin($this->bottom_margin);
    		$this->setFooterFont(Array('helvetica', '', 8));
    		/* $this->setFooterData(array(0,64,0));
    		$this->setFooterFont(Array('helvetica', '', 8)); */
    		$this->dataDourceQ10 ="";
    		$this->dataDourceP50 ="";
    	
    		$this->bodyFlush = false;
    		
    		$this->resetForm();
    		$this->vdisft = false;
    		
    		$this->cashingAddFont = array();
    		
    		// if($this->width < 85 && $this->printHeaderOnce == true){ 
    		//     $this->setPrintFooter(false);
    		// }
    	}
    	
    	public function setDataDource($p50,$q10){
    		if(!empty($q10)){
    			$this->dataDourceQ10 = $q10;
    			return ;
    		}
    		$this->dataDourceP50 = $p50;
    		
    	}
    	
    	public function set_triggerAddBodyRow($val){
    		if(gettype($val) == 'boolean'){
    			$this->triggerAddBodyRow = $val;
    		}
    	}
    		
    	public function setBackgroundImage($filename){
    	    if(file_exists($filename)){
    	        $this->bgImage = $filename;
    	    }
    	} 
    	
    	public function resetBodyRows(){
    		$this->body_rows_i = 0;
    	} 
    	public function resetFormPage(){
    	    $this->formPage = 0;
    	} 
    	public function addFormPage(){
    	    ++$this->formPage;
    	}
    	public function getFormPage(){
    	    return $this->formPage;
    	}
    	
    	public function resetForm(){
    	    
    	    $this->resetBodyRows();
    	    $this->resetFormPage();
    	    $this->resetLastH();
    	    
    	   
    	    
    	    $this->updMinusTrigger	= false;
    	    $this->minusGrammes		= 0;
    	    $this->offset_y			= 0;
    	    $this->offset_x			= 0;
    	    $this->custom_offset_y = 0;
    	    $this->custom_offset_x = 0;
			$this->max_head_row		= 0;
			$this->extra_header_height_on_top_header_once = 0;
    	    $this->bodyheight		= 0;
    	    $this->lastRow			= 0;
    	    $this->peg_tmp_lastPosition = 0;
    	    $this->peg_tmp_last_bodyrow = 0;
			$this->peg_tmp_last_body_current_row = 0;
			
			$this->peg_tmp_last_body_rowstart = 0;     		
     		$this->peg_tmp_last_body_rowend   = 0;  
    	    $this->triggerAddBodyRow = false;
    	    
    	    $this->bodyFlush = false;
    	    
    	    $this->body_row_i_data             = array();
    	    $this->body_row_i_data['elem']     = array();
    	    $this->body_row_i_data['rowstart'] = NULL;
    	    $this->body_row_i_data['rowend']   = NULL;
    	} 
    
    	/**
    	 * Sthn prosthiki neas selidas thelw na energopoio to trigger tou midenismoy
    	 * @see TCPDF::AddPage()
    	 */
    	public function AddPage($orientation='', $format='', $keepmargins=false, $tocpage=false){
    		$this->updMinusTrigger = true;
    		parent::AddPage($orientation, $format, $keepmargins, $tocpage);
    		
    		if(!empty($this->bgImage)){
    			// get the current page break margin
    			$bMargin = $this->getBreakMargin();
    			// get current auto-page-break mode
    			$auto_page_break = $this->getAutoPageBreak();
    			// disable auto-page-break
    			$this->SetAutoPageBreak(false, 0);
    			$this->Image($this->bgImage, 0, 0, $this->width, $this->height, '', '', '', false, 300, '', false, false, 0);
    			// restore auto-page-break status
    			$this->SetAutoPageBreak($auto_page_break, $bMargin);
    			// set the starting point for the page content
    			$this->setPageMark();
    		}
    		
    	}
    	
    	/**
    	 * Kanei add Ta font. kai elegxei ean exoun idi ginei add
    	 * @see TCPDF::AddFont()
    	 */
    	public function AddFontFamily($family, $style='', $fontfile='', $subset='', $id=0){
    		 
    		if($id>0 and isset($this->cashingAddFont[$id] )
    				){
    					//Font Allready Added
    					/* print_r($this->cashingAddFont); */
    					return ;
    						
    		}
    	
    		if($id>0)
    			$this->cashingAddFont[$id] = array('style' => $style, 'fontfile' => $fontfile, 'subset' => $subset);
    	
    		return $this->AddFont($family, $style, $fontfile, $subset);
    	}
    	/**
    	 * Kanei add Ta font. Thn kanw extend 
    	 * 		1. gia n mhn exw fatal error sta arialgreek
    	 * 		2. Na kanw add font ean yparxei eidi
    	 * @see TCPDF::AddFont()
    	 */
    	public function AddFont($family, $style='', $fontfile='', $subset=''){
    		if(strtolower($family) == "arialgreek" || empty($family)){
    			//$family = 'dejavusans';
    			$family = 'freesans'; //Αλλαγη για μαρκοζαννες ΠΠΥ 2020048 
    // 			$file = '';
    		}
    		
    // 		$p87_00['font'] , '' , $p87_00['font'] . '.php' )
    		return parent::AddFont($family, $style , $fontfile , $subset);
    	}
    	/**
    	 * Kanei set Ta font. Thn kanw extern gia n mhn exw fatal error sta arialgreek
    	 * @see TCPDF::SetFont()
    	 */
    	public function SetFont($family, $style='', $size=null, $fontfile='', $subset='default', $out=true){
    		if(strtolower($family) == "arialgreek"  || empty($family)){
    			//$family = 'dejavusans';
    			$family = 'freesans'; //Αλλαγη για μαρκοζαννες ΠΠΥ 2020048 
    // 			$file = '';
    		}
    		
    		return parent::SetFont($family, $style, $size, $fontfile, $subset, $out);
    	}
    	
    	
    	public function SetFillColor($col1=0, $col2=-1, $col3=-1, $col4=-1, $ret=false, $name=''){
    			$this->fillColorAr = array(
    					col1	=> $col1, 
    					col2	=> $col2, 
    					col3	=> $col3, 
    					col4	=> $col4, 
    					ret		=> $ret, 
    					name	=> $name
    					
    			);		
    		return parent::SetFillColor($col1, $col2, $col3, $col4, $ret, $name);
    	}
    	
    	public function SetDrawColor($col1=0, $col2=-1, $col3=-1, $col4=-1, $ret=false, $name=''){
    		$this->drawColorAr = array(
    				col1	=> $col1,
    				col2	=> $col2,
    				col3	=> $col3,
    				col4	=> $col4,
    				ret		=> $ret,
    				name	=> $name
    					
    		);
    		return parent::SetDrawColor($col1, $col2, $col3, $col4, $ret, $name);
    	}
    	public function SetTextColor($col1=0, $col2=-1, $col3=-1, $col4=-1, $ret=false, $name=''){
    		$this->textColorAr = array(
    				col1	=> $col1,
    				col2	=> $col2,
    				col3	=> $col3,
    				col4	=> $col4,
    				ret		=> $ret,
    				name	=> $name
    					
    		);
    		parent::SetTextColor($col1, $col2, $col3, $col4, $ret, $name);
    	}
    	
    	
    	
    	public function Footer(){ 
    	    
    	    if($this->width < 85 && $this->printHeaderOnce == true){
    
    	        if($this->peg_tmp_lastPosition == 3){
    	            $tmp_grammi = $this->offset_y + $this->lastRow + 2 + $this->max_head_row + $this->bodyheight;
    	            $footer_y = $this->_getTCPDFYFromGrammi( $this->offset_y + $this->lastRow + 2 + $this->max_head_row + $this->bodyheight);
    	            
    	            $this->SetTextColorArray($this->footer_text_color);
    	            $this->peg_print_line($tmp_grammi , 0 , $tmp_grammi ,  ($this->stiles- $this->right_margin - $this->left_margin)   );
    	            
    	            if ($this->getRTL()) {
    	                $this->SetXY($this->original_rMargin-1, $footer_y);
    	                
    	               
    	                $this->Cell(0, 0,"Powered by Pegasus Technology ©", 0, 0, 'R');
    	            } else {
    	                $this->SetXY($this->original_lMargin +1, $footer_y);
    	                
    	               
    	                
    	                $this->Cell(0, 0, "Powered by Pegasus Technology ©" , 0, 0, 'L');
    	            }
    	             
    	        }
    	        return "";
    	    }
    	    if(
    	        $this->dataDourceP50 != 'a55' &&
    	        $this->dataDourceP50 != 'courier05_00' &&
    	        $this->dataDourceP50 != 'r18' &&
    	        $this->vdisft == false){
    			parent::Footer();
    			
  			
    			
    			if (!$this->getRTL()) {
    				$this->SetX(($this->original_rMargin + 1));
    				$this->Cell(0, 0, "Powered by Pegasus Technology ©" , 0, 0, 'L');
    				
    			} else {
    				$this->SetX(($this->original_lMargin - 1));
    				$this->Cell(0, 0,"Powered by Pegasus Technology ©", 0, 0, 'R');
    				
    			}
    		}
    	}
    	
    
    	/**
    	 * H sunartisi epistrefei true oso uparxoyn dedomena pou den ektypwthei sto body 
		 * Elwgxei to synolo ton record poy prepei an ektypothoyn me ayt apoy ektipothikan
    	 * @param int $body_rows
    	 * @param int $body_rows_i
    	 * @return boolean
    	 */
    	public function hasMoreRows($body_rows, $body_rows_i=0){ 
    		//XXX Den Xriazete h isotita metraei apo to 0 .
    	    return ($body_rows > $this->body_rows_i  );
		}
		
    	/**
    	 * H synartisi epistrefei true oso xwrane eggrafes sto body.
    	 * Episeis epiraszete apo thn metavliti 
    	 * @param float $i
    	 * @param float $bodyheight
    	 * @return boolean
    	 * @see this->bodyBreak
    	 */
    	public function hasMoreSpace($i, $bodyheight){
    		if($this->bodyBreak == true){ 
    			$this->bodyBreak = false; 
    			return false;
    		}

    		return ( $i	< $this->bodyheight );
    	} 
    	
    	/**
    	 * Epistefei poio dedomeno (to i dedomeno) exw ektypwsei
    	 * @return number
    	 */
    	public function get_body_rows_i(){
    		return $this->body_rows_i;
    	}
    	
    	public function set_vdisft($var = FALSE){
    		if(gettype($var) == "boolean"){
    			$this->vdisft = $var ;
    		}
    	}
    	
    	public function setGrammiStili($stili,$grammi){
    	    $x_tmp = $this->_getTCPDFXFromStili($stili);
    	    $y_tmp = $this->_getTCPDFYFromGrammi($grammi);
    	    
    	    return $this->SetXY($x_tmp, $y_tmp);
		}
		
    	/**
    	 * Aujani ton metriti twn dedomenvn einai methodos giati den thelw na pirazete mesa apo thn forma
    	 */
    	public function addBodyRow(){
    		if($this->triggerAddBodyRow ){
    			$this->body_rows_i++;
    			$this->set_triggerAddBodyRow(false);
    		}
    	}
    	/**
    	 * Aujani ton metriti twn dedomenvn einai methodos to tcpdf paizei swsta
    	 */
    	public function addBodyI(){


    		$tmp_var=0;
			$tmp_var_plush =0;
			
			//Αν εχει elements για εκττυπωση
    		if(count($this->body_row_i_data['elem'])>0 ){
    		    
    			//edw mpenei mono ean sthn prohgoumeni selida emine sto cash
    			//Efoson to position exw apo to cash
    			//den thelw sto update na mou kanei minus grammes
				$this->peg_tmp_lastPosition = 2;
				
    			//pernei to hrader afou einai prwto element
    			$this->offset_y = $this->custom_offset_y;
    			
    			$this->updMinusTrigger = true;
    			$this->lastRow = 0;
				
				//Comment to fix row Break
    			//$this->updateMaxHeaderRow();
				 
	 


    			if( ($this->body_row_i_data['rowstart'] +1 )> ($this->max_head_row)){ 
    			    $this->_updateBodyElement(($this->offset_y + $this->max_head_row - $this->body_row_i_data['rowstart']  ));	
    			}
 
				$this->peg_tmp_last_bodyrow=$this->body_row_i_data['rowstart'];
    			$this->flushBodyI();

				
    			$this->updMinusTrigger = false;
    			$this->set_triggerAddBodyRow(true);
    			if($this->bodyBreak === true){
    				return 1;
				}


				//$this->peg_tmp_last_body_current_row +=10;
    			//Gia na diorthwsw to minus grammes toy body
    			//$tmp_var_plush = 1;
    		} 
    		
			
			// thimios remark for offers (1)
    	//	if(!$this->printHeaderOnce){

				if($_REQUEST['debug___']==1){
					echo '<pre>peg_tmp_last_bodyrow:' . $this->peg_tmp_last_bodyrow . '</pre>' ;
					echo '<pre>peg_tmp_last_body_current_row:' . $this->peg_tmp_last_body_current_row . '</pre>';
				}

				
				$tmp_var += $this->_getHeight($this->peg_tmp_last_body_rowstart, $this->peg_tmp_last_body_rowend );			

				//$tmp_var += $this->_getHeight($this->body_row_i_data['rowstart'], $this->body_row_i_data['rowend'] );			
				
		//	}
    		
    		
	
			// Eδω θελω να βγαλω μια διορθωσει για αν παιζουν όσα δεν εχουν upi=true και να αλλαζουν γραμμή αλλ μονο αυτα.  Αν εχει εκτυπωθει με upi δεν θελουμε την το +1 επισεις δεν θελω το body να ξεκειναει ουσιασικα απο το i=1.
			//if($peg_tmp_last_bodyrow!=$this->body_row_i_data['rowstart']){
			if(!$this->printHeaderOnce){
				if($tmp_var<1){
			 		$tmp_var = 	1;
			 	}	
			 }
			
    		$this->body_row_i_data             = array();
    		$this->body_row_i_data['elem']     = array();
    		$this->body_row_i_data['rowstart'] = NULL;
			$this->body_row_i_data['rowend']   = NULL;
		 
    		return $tmp_var + $tmp_var_plush;
    	}
    	
    	private function _bodyBreakeEmptySpace(){
    		if($this->printHeaderOnce==false){
    			if(($this->max_head_row+$this->bodyheight + $this->custom_offset_y) <= ($this->body_row_i_data['rowend'] +1) and $this->body_tmp_i != 0){
    				$this->bodyBreak = true;
    				return true;
    			}
			}
 
		 
			
    		return false;
    	}
    	
    	/**
    	 * Ayth h methodos kaleite mono apo to while ths (print_to_pdf00.php) kai thn addBodyI
    	 * Ayto simvenei gt mono tote theloume na ekteleite h addBodyRow() wste
    	 * otan ena body row exei update i epoudeni na mhn min moy ayjanei to body_row_i
    	 */
    	public function flushBodyI(){

			// Θα επιστεψει true αν πρεει αν αλλαξει σελιδα λογο τπυ οτι δρν χωραει το row και θα κανει το $this->bodyBreak ==  true
    		if($this->_bodyBreakeEmptySpace()){
    			return;
			}
			
			//Προσθετει +1 στον μετρητη των εκτυπωμενων record to kanei μονο αν εχει $this->triggerAddBodyRow = true
			$this->addBodyRow();
			
    		$this->_flushBodyI();
    	}
    	
     	private function _flushBodyI(){ 

     	    // Θα επιστεψει true αν πρε[ει αν αλλαξει σελιδα λογο τπυ οτι δρν χωραει το row και θα κανει το $this->bodyBreak ==  true
     		if($this->_bodyBreakeEmptySpace()){ 
    			return;
			}
			 
     		$fontAr =  array('family' => $this->FontFamily, 'style' => $this->FontStyle, 'sizept' => $this->FontSizePt);
     		$this->bodyFlush = true; 
     		
     		//XXX Thelw na einai diktis se element gt to element tropopoieite apo th sinarthsh _updateBodyElement
     		foreach ($this->body_row_i_data['elem'] as &$elem){
     			if($this->printHeaderOnce){ 
     			    $current_page = $this->page;
     			}
     			
     			$this->SetFont($elem['font']['family'], $elem['font']['style'],$elem['font']['sizept']);  			
     			$this->SetFillColor( $elem['fillColorAr']['col1'], $elem['fillColorAr']['col2'], $elem['fillColorAr']['col3'], $elem['fillColorAr']['col4'], $elem['fillColorAr']['ret'], $elem['fillColorAr']['name']);
     			$this->SetDrawColor( $elem['drawColorAr']['col1'], $elem['drawColorAr']['col2'], $elem['drawColorAr']['col3'], $elem['drawColorAr']['col4'], $elem['drawColorAr']['ret'], $elem['drawColorAr']['name']);
     			$this->SetTextColor( $elem['textColorAr']['col1'], $elem['textColorAr']['col2'], $elem['textColorAr']['col3'], $elem['textColorAr']['col4'], $elem['textColorAr']['ret'], $elem['textColorAr']['name']);
				 

				 if($_REQUEST['debug__']==1){
				 	echo '<pre>fname' . $elem['fname']                  . '</pre>';
				 	echo '<pre>text'  . $elem['args']['text']           . '</pre>';
				 	echo '<pre>grami' . $elem['args']['param']['grami'] . '</pre>';
				 	echo '<pre>stili' . $elem['args']['param']['stili'] . '</pre>';
				 }
				
				switch ($elem['fname']) {
     				case 'peg_print_line':	
     					$this->peg_print_line(
     						$elem['args']['grami_top'], 
     						$elem['args']['stili_top'], 
     						$elem['args']['grami_bottom'], 
     						$elem['args']['stili_bottom']
     					);
     					break;
     				case 'peg_print_text':
     					$this->peg_print_text(
     						$elem['args']['grami'], 
     						$elem['args']['stili'],
     						$elem['args']['text']
     					);
     					break;
     				default:
     					$elem['args']['grami0'] = $this->body_row_i_data['rowend'];
     					if( method_exists($this, $f=$elem['fname']) ){
     						$this->{$f}($elem['args']['param'], $elem['args']['text']);
     					}
     					break;
     			}
     			
     			
     			if($this->printHeaderOnce and $current_page != $this->page){
     			    $this->_updateBodyElement( ($this->_getRowFromY($this->y) - $this->body_row_i_data['rowstart']) );
     			}
     		
    
     		}
     		$this->bodyFlush = false;
     		$this->peg_tmp_last_body_current_row = $this->body_row_i_data['rowend'];     		

			$this->peg_tmp_last_body_rowstart = $this->body_row_i_data['rowstart'];     		
     		$this->peg_tmp_last_body_rowend   = $this->body_row_i_data['rowend'];     		

			 $this->body_row_i_data['rowstart']   = NULL;
     		$this->body_row_i_data['rowend']     = NULL; 
     		$this->body_row_i_data['elem']       = array();
     		$this->SetFont($fontAr['family'], $fontAr['style'],$fontAr['sizept']);
     		
     		return ;
     	}
     	
    	
    	/**
    	 * Arxikopoiei ta rows
    	 * @param enum{1=> header,2 => body,3 => footer} $pos
    	 * @param number $row grammi apo
    	 * @param number $col stili apo
    	 * @param number $row0 grammi eos
    	 * @param number $col0 stili eos
    	 * @param number $i metavliti gia thn thesi ths kathe grammis sto body
    	 * @return array($row,$col,$row0,$col0 )
    	 */
    	public function peg_get_position($pos , $row = 0, $col = 0, $row0 = 0, $col0 = 0, $i = 0){
    		$this->body_tmp_i = 0;
    		if($pos != $this->peg_tmp_lastPosition){
    			if($pos==2){
    				$this->updateMaxHeaderRow();
    			}
    		 
    			//Morei se mia dorma na exw 2 header
    			//Old Den exw thema gia to header giati to arxikopoio me header ston constuctor
        		$this->updMinusTrigger = true;
    	       	$this->lastRow = 0;
    		     
    			$this->peg_tmp_lastPosition = $pos;
    			$this->offset_y=$this->custom_offset_y;
    		}
    		if($this->peg_tmp_lastPosition==2){
    			$this->_updMinusGrammes($i);
    		}else{
    			$this->_updMinusGrammes();
    		}
    		$this->lastRow = $row;
    		
     		$row = $row - $this->minusGrammes;
    		$row0 = $row0 - $this->minusGrammes; 
    		switch ($pos) {
				case 1:
    				$col  = $this->offset_x+$col;
					$col0 = $this->offset_x+$col0;
					$row  = $this->offset_y+$row + $this->extra_header_height_on_top_header_once;
					$row0 = $this->offset_y+$row0 + $this->extra_header_height_on_top_header_once;			
    				break;
				case 2:
    				$this->body_tmp_i = $i;
    				$row  = $this->offset_y+$row+$i+$this->max_head_row;
    				$col  = $this->offset_x+$col;
    				$row0 = $this->offset_y+$row0+$i+$this->max_head_row;
    				$col0 = $this->offset_x+$col0;
    				break;
    			case 3:
    				$row  = $this->offset_y+$row + $this->max_head_row + $this->bodyheight;
    				$col  = $this->offset_x+$col;
    				$row0 = $this->offset_y+$row0 + $this->max_head_row +  $this->bodyheight;
    				$col0 = $this->offset_x+$col0;
    				break;
    			default:
    				die("Underfinted position $pos ");
    			break;
    		}
    	
    		if($row0<$row){
    			$row0 = 0;
    		}
    		if($col0<$col){
    			$col0 = 0;
    		}
    		return array($row,$col,$row0,$col0 );
    	}
    	
    	
    	/**
    	 * Ektiponimia grammi
    	 * @param float $grami_top (apo poia grammi tha jekinisei ba tupwnei)
    	 * @param float $stili_top (apo poia stili tha jekinisei ba tupwnei)
    	 * @param float $grami_bottom (eos poia grammi tha tupwnei)
    	 * @param float $stili_bottom (eos poia stli tha tupwnei)
    	 * @param float $width (poio tha einai to fardos ths grammis)
    	 */
    	public function peg_print_line($grami_top , $stili_top , $grami_bottom , $stili_bottom,$width=0 ){
    		if($this->peg_tmp_lastPosition==2 and !$this->bodyFlush ){
    			$this->_pushBodyElement(array(
    					'fname'		=> 'peg_print_line',
    					'rowstart'	=>$grami_top,
    					'args'	=> array(
    							'grami_top' => $grami_top,
    							'stili_top' => $stili_top,
    							'grami_bottom' => $grami_bottom,
    							'stili_bottom' => $stili_bottom,
    							'width' => $width
    					)
    			));
    			return ;
    		}
    		
    		$this->peg_tmp_lastPrintType = 'line';
    		if(!empty($width)){
    			$lineWidthTmp = $this->LineWidth;
    			$this->SetLineWidth($width);
    				
			}
			
    		if($stili_bottom > ($this->stiles-$this->right_margin) ){
    			$stili_bottom = ($this->stiles-$this->right_margin);
    		}
    		
    		$x_top_tmp    = $this->_getTCPDFXFromStili($stili_top);
    		$y_top_tmp    = $this->_getTCPDFYFromGrammi($grami_top);
    		$x_bottom_tmp = $this->_getTCPDFXFromStili($stili_bottom);
    		$y_bottom_tmp = $this->_getTCPDFYFromGrammi($grami_bottom);
    		
    		$this->Line($x_top_tmp, $y_top_tmp, $x_bottom_tmp, $y_bottom_tmp);
    		if(!empty($width)){
    			$this->SetLineWidth($lineWidthTmp);
    		}
    	}
    	
    	/**
    	 * Ektyponei ena keimeno miaw grammis 
    	 * 2del @see peg_print_cell
    	 * @param float $grami se poia grammi
    	 * @param float $stili se poia stili
    	 * @param string $text
    	 */
    	public function peg_print_text($grami , $stili  , $text){
    		if($this->peg_tmp_lastPosition==2 and !$this->bodyFlush ){
    			$this->_pushBodyElement(array(
    					'fname' => 'peg_print_text',
    					'rowstart'	=>$grami,
    					'args'	=> array(
    							'grami' => $grami,
    							'stili' => $stili,
    							'text' => $text
    					)
    			));
    			return ;
    		}
    		if(empty($text)){
    			return ;
    		}
    	
    		if(pegasus_lock_check_app()==1){
    			$text = '.' . substr($text ,1);
    		}
    		$x_tmp = $this->_getTCPDFXFromStili($stili);
    		$y_tmp = $this->_getTCPDFYFromGrammi($grami);
    		$this->text($x_tmp  , $y_tmp , $text);
    	
    	}
    
    	/**
    	 *  Ektypvnei ena keli
    	 * @param array(
    	 * 	grami
    	 *  stili
    	 *  grami0
    	 *  stili0
    	 *  border
    	 *  size
    	 *  align
    	 *  fill
    	 *  url
    	 * ) $param
    	 * @param string $text
    	 */
    	public function peg_print_cell($param = array(), $text){
    		$this->peg_tmp_lastPrintType = 'exp';
    		
    
    		$width	= 0;
    		$height = 0;
    		$heightRet = 1;
    		
    		
    		$grami	= $param['grami'] ;
    		$stili	= $param['stili'] ;
    		
    		
    		$grami0	= (!empty( $param['grami0']))?$param['grami0'] : 0;
    		$stili0	= (!empty( $param['stili0']))?$param['stili0'] : 0;
    		
    		$border	= (!empty( $param['border']))?$param['border'] : '';
    		$size	= (!empty( $param['size']))?$param['size'] : 0;
    		$align	= (!empty( $param['align']))?$param['align'] : 'L';
    		$fill	= (!empty( $param['fill']))?$param['fill'] : false;
    		$url	= (!empty( $param['url']))?$param['url'] : '';
    		$upi		= (isset($param['upi']) and $param['upi']===true)?$param['upi'] : false;
    		if($size>0){
    			$width = $this->s_width*$size;
    		}elseif ($stili0>0){
    			$width = $this->_getTCPDFWidth($stili, $stili0);
			}

            if($_REQUEST['debug___']==1){
                echo '<pre> peg_print_cell start</pre>';
				echo '<pre>  grami'  . $grami. ' </pre>';
				echo '<pre>  grami0' . $grami0. ' </pre>';
				echo '<pre>  peg_tmp_lasth' . $this->peg_tmp_lasth. ' </pre>';
				echo '<pre>  grami0 calc..' . ($this->_getNumOfRowsFromTCPDFHeight($this->getStringHeight($width, $text)) +$grami). ' </pre>';
				echo '<pre>  text ' . $text. ' </pre>';
                echo '<pre> peg_print_cell end</pre>';

            }

			// if(!($grami0>0)){
			// 	$grami0 = ($grami + $this->_getNumOfRowsFromTCPDFHeight($this->getCellHeight($this->FontSize)) );
			// }

			if( $width>0 and !($grami0>0) ){
			 	$grami0 = ($this->_getNumOfRowsFromTCPDFHeight($this->getStringHeight($width, $text )) +$grami);
			}

    		if($grami0>0){
    			$height = $this->_getTCPDFHeight($grami, $grami0);
    			$heightRet =$this->_getHeight($grami, $grami0) ;
			}
			// else{
			//  	$this->peg_tmp_lasth=0;
			//  }
			
    		if($this->peg_tmp_lastPosition==2 and !$this->bodyFlush ){
    			$rowEndTmp = $grami0;
    			if($rowEndTmp==0 || $rowEndTmp == $grami ){
					$rowEndTmp = ($grami + $this->_getNumOfRowsFromTCPDFHeight($this->getCellHeight($this->FontSize)) );
					//$rowEndTmp =$this->getStringHeight($width, $text)+$grami;
    			}
    			
    			$this->_pushBodyElement(array(
    					'fname' => 'peg_print_cell',
    					'rowstart'	=> $grami,
    					'rowend'	=> $rowEndTmp,
    					'upi'		=> $upi,
    					'args'    	=> array(
    							'param' => $param,
    							'text' => $text
    					)
    			));
    			return ;
    		}
    		
    		
    		$x_tmp = $this->_getTCPDFXFromStili($stili);
    		$y_tmp = $this->_getTCPDFYFromGrammi($grami);
    		
 
    		$this->SetXY($x_tmp  ,   $y_tmp);
    		$this->Cell($width , $height  ,   $text , $border  , 0 , $align , $fill, $url);
    		
    		return array('height' => $heightRet);
    	
    	}
    	
		//$returnHeightMultiCell = $this->MultiCell($width, $height, $text, $border,$align, $fill, 0, $x_tmp, $y_tmp,true,0,false, false, $maxHeight , $valign);
		

		public function getMultiCellHeight($w, $h, $txt, $border=0, $align='J', $fill=false, $ln=1, $x='', $y='', $reseth=true, $stretch=0, $ishtml=false, $autopadding=true, $maxh=0, $valign='T', $fitcell=false) {

			if($ishtml){
				return $this->getHTMLCellHeight($w, $h, $x, $y, $html='', $border, $ln, $fill, $reseth, $align, $autopadding);
			}

			$this->startTransaction();
			// store starting values
			$height = $this->MultiCell($w, $h, $txt, $border, $align, $fill, $ln, $x, $y, $reseth, $stretch, $ishtml, $autopadding, $maxh, $valign, $fitcell);
			//restore previous object
			$this->rollbackTransaction(true);

			return $height ;
		}		



		public function getHTMLCellHeight($w, $h, $x, $y, $html='', $border=0, $ln=0, $fill=false, $reseth=true, $align='', $autopadding=true){

			// $pdf= new pegTCPDF($this->grammes, $this->stiles, $this->width, $this->height);


			// $pdf->AddPage();
			$this->startTransaction();
			// store starting values
			$start_y = $this->GetY();
			$start_page = $this->getPage();
			
			// call your printing functions with your parameters
			// - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
			//writeHTMLCell($width, $height, $x_tmp, $y_tmp, $text, $border,2, $fill, true, $align, true)
			$this->writeHTMLCell($w, $h, $x, $y, $html, $border, $ln, $fill, $reseth, $align, $autopadding);

		
			//- - - - - - - - - - - - - - - - - - - - - - - - - - - - -
			// get the new Y
			$end_y = $this->GetY();
			$end_page = $this->getPage();
			// calculate height
			$height = 0;
			if ($end_page == $start_page) {
				$height = $end_y - $start_y;
			} else {




				
				for ($page=$start_page; $page <= $end_page; ++$page) {
					$this->setPage($page);
					if ($page == $start_page) {
						// first page
						$height += $this->getPageHeight() - $start_y - $this->getBreakMargin();
					} elseif ($page == $end_page) {
						// last page
						$__margins = $this->getMargins();
						$height += $end_y - $__margins['top'] ;
					} else {
						$__margins = $this->getMargins();
						$height += $this->getPageHeight() - $__margins['top'] - $this->getBreakMargin();
					}
				}
			}

			//restore previous object
			$this->rollbackTransaction(true);
			//unset($pdf);

			//return 1;
			 return $height ;
		}		
    	/**
    	 * Ektipwnei ena memo se polles grammes.
    	 * To plithos twn grammwn einai grami0 - grami
    	 * To megethos einai elemsize h stili0 -stili
    	 * @param  array() $param array(
    			 'grami' => $grami,
    			 'stili' => $stili,
    			 'grami0' => $grami0,
    			 'stili0' => $stili0,
    			 'elemsize' => $elemsize,
    			 'synLineHeight' =>me ti tha polaplasiastei to line height
    		 )
    	 * @param string $text
    	 */
    	public function peg_print_memo_array($param = array(), $text ){


    		$this->peg_tmp_lastPrintType = 'exp_memo';
    		$width		= 0;
    		$height		= 0;
			$maxHeight	= 0 ;
			$print_again = false;
    		
    		
    
    		$this->url ="";
    		$grami	= $param['grami'] ; 
    		$stili	= $param['stili'] ;
    		$grami0	= $param['grami0'] ;
    		$stili0	= $param['stili0'] ;
    		
    		//την δευτερη φορα που εκτυπωνεται ειναι παντα false
    		$onOverflowChangePage	= (!empty( $param['onOverflowChangePage'])) ? $param['onOverflowChangePage'] : false;
    		$border	= (!empty( $param['border'])) ? $param['border'] : '';
    		$align	= (!empty( $param['align']))  ? $param['align']  : 'L';
    		$fill	= (!empty( $param['fill']))   ? $param['fill']   : false;
    		$url	= (!empty( $param['url']))    ? $param['url']    : '';
    		$upi	= (isset($param['upi']) and $param['upi']===true) ? $param['upi'] : false;
    		$valign	= (!empty( $param['valign']) and (strtoupper($param['valign'])=='T' || strtoupper($param['valign'])=='B' || strtoupper($param['valign'])=='M') ) ? strtoupper($param['valign']) : 'B';
    		
    		//die($valign);
    		//$valign = 'B';
    		/* T: TOP , M: middle , : bottom */
    		
    		$elemsize = (!empty( $param['elemsize']) and $param['elemsize']>0) ? $param['elemsize'] : 0;
    		//$syntelesthsLineHeight = (!empty( $param['synLineHeight']) and $param['synLineHeight']>0)?$param['synLineHeight'] : 1;
    		
    		
    		if($elemsize>0){
    			$width = $this->s_width*$elemsize;
    		}elseif ($stili0>0){
    			$width = $this->_getTCPDFWidth($stili, $stili0);
			}
			

			if(!($grami0>0)){
				
				//$height = $this->getStringHeight($width, $text);
				//$grami0 = ($this->_getNumOfRowsFromTCPDFHeight($height) +$grami);
				$x_tmp = $this->_getTCPDFXFromStili($stili);
				$y_tmp = $this->_getTCPDFYFromGrammi($grami);				 
				$height = $this->getMultiCellHeight($width, $height, $text, $border,$align, $fill, 0, $x_tmp, $y_tmp,true,0,false, false, $maxHeight , $valign);
				$grami0 = $height +$grami;
			}

    		if($grami0>0){
				if($valign=='B' || $valign=='M'){
					$height = $this->_getTCPDFHeight($grami, $grami0);
    				$maxHeight	= $height;
    			}
			}
			

		 

    		if($this->peg_tmp_lastPosition==2 and !$this->bodyFlush ){
    			$rowEndTmp = $grami0;

    			$this->_pushBodyElement(array(
    					'fname' => 'peg_print_memo_array',
    					'rowstart'	=> $grami,
    					'rowend'	=> $rowEndTmp,
    					'upi'		=> $upi,
    					'args'	=> array(
    							'param' => $param,
    							'text' => $text
    					)
    			));
    			return ;
			} 

			// Aν η γραμη ειναι μεγαλυτερη απο τις γραμμες τις σελιδας , εχει σεταριστει το onOverflowChangePage true και δεν ειναι στο body.
			if($grami0+$this->bottom_margin  >= $this->grammes and $onOverflowChangePage and $this->peg_tmp_lastPosition!=2){
				$this->addPage();
				return array('height' => 0 , 'print_again' => true);
			}

    		
    		/*   */   
    		$x_tmp = $this->_getTCPDFXFromStili($stili);
			$y_tmp = $this->_getTCPDFYFromGrammi($grami);
			
    		 $returnHeightMultiCell = $this->MultiCell($width, $height, $text, $border,$align, $fill, 0, $x_tmp, $y_tmp,true,0,false, false, $maxHeight , $valign);
			//  $this->lastPage();
			//  $this->tmp_grammes = $grami;
			//  $gramiEnd = $this->getTCPDFLastRow();
			
			
			//  $returnHeight = $this->_getHeight($this->tmp_grammes, $gramiEnd);
			
		
    		if($_REQUEST['debug']==1){
				echo '<pre>==================================</pre>'; 
				echo '<pre>text:' . $text . '</pre>'; 
				
				echo '<pre>getStringHeight:' . $this->_getNumOfRowsFromTCPDFHeight($this->getStringHeight($width, $text)) . '</pre>'; 
				echo '<pre>returnHeightMultiCell:' . $returnHeightMultiCell . '</pre>'; 
				echo '<pre>returnHeightMultiCell:' . $this->_getNumOfRowsFromTCPDFHeight($returnHeightMultiCell) . '</pre>'; 
				echo '<pre>returnHeight:' . $returnHeight . '</pre>'; 
				echo '<pre>==================================</pre>'; 
				
			}
			
    		return array('height' => $returnHeightMultiCell, 'print_again' => $print_again);
    	
    	}
    	
    	
    	public function peg_print_html_array($param = array(), $text ){
			
 			

    		$this->peg_tmp_lastPrintType = 'exp_html';
    		$grami	= $param['grami'] ;
    		$stili	= $param['stili'] ;
    		$grami0	= $param['grami0'] ;
    		$stili0	= $param['stili0'] ;
    		
    		$width = 0;
    		$height =0;
    		
    		$align	  = (!empty( $param['align']))?$param['align'] : '';
    		$fill	  = (!empty( $param['fill']))?$param['fill'] : false;
    		$border	  = (!empty( $param['border']))?$param['border'] : '';
    		$elemsize = (!empty( $param['elemsize']) and $param['elemsize']>0)?$param['elemsize'] :0;
    		// $syntelesthsLineHeight = (!empty( $param['synLineHeight']) and $param['synLineHeight']>0)?$param['synLineHeight'] : 1;
    		$upi		= (isset($param['upi']) and $param['upi']===true)?$param['upi'] : false;
    		
    		if($elemsize>0){
    			$width = $this->s_width * $elemsize;
    		}elseif ($stili0>0){
    			$width = $this->_getTCPDFWidth($stili, $stili0);
			}
			
    		if($grami0>0){
    			$height = $this->_getTCPDFHeight($grami, $grami0);
    		}
			    	
    		$x_tmp = $this->_getTCPDFXFromStili($stili);
			$y_tmp = $this->_getTCPDFYFromGrammi($grami);
			
    		if($this->peg_tmp_lastPosition==2 and !$this->bodyFlush ){
    			$rowEndTmp = $grami0;
    			if($rowEndTmp==0 ){
    				if(!empty($text)){
						$height = $this->getHTMLCellHeight($width, $height, $x_tmp, $y_tmp, $text, $border ,2, $fill, true, $align, true);
						$rowEndTmp = ( $this->_getNumOfRowsFromTCPDFHeight($height) + $grami );
    				}else{ 
    					$rowEndTmp = $grami;
    				}
    			}

				$param['heightinrows']=$this->_getNumOfRowsFromTCPDFHeight($height) ;
    			$this->_pushBodyElement(array(
    					'fname' => 'peg_print_html_array',
    					'rowstart'	=> $grami,
						'rowend'	=> $rowEndTmp,
						'upi'		=> $upi,
    					'args'	=> array(
    							'param' => $param,
								'text'  => $text 
    					)
    			));
    			return ;
    		}

    		$this->SetXY($x_tmp, $y_tmp);    		
			$this->tmp_grammes = $grami;
			

    		$this->writeHTMLCell($width, $height, $x_tmp, $y_tmp, $text, $border, 2, $fill, true, $align, true) ;
    		$this->lastPage();
    		$gramiEnd = $this->getTCPDFLastRow();
    
    		$returnHeight = $this->_getHeight($this->tmp_grammes, $gramiEnd);
    		return array('height' => $returnHeight );
    	}
    	
    	
    	/**
    	 * H synarthsh ayth ektypvnei mia eikona.
    	 * Ean den exoume orisi grami0, stili0 kai elemsize doyleyei opws douleue
    	 * @param array $param array( 'grami' => $grami, 'stili' => $stili, 'grami0' => $grami_h, 'stili0' => $stili_w, 'link' => $link )
    	 * @param string $file image path
    	 */
    	public function peg_print_image_array($param = array(), $file){
    		
    		
    		
    		$this->peg_tmp_lastPrintType = 'image';
    		$width = 0;
    		$height = 0;
    		$align	= 'L';
    		$palign = '';
    		$resize = false;
    		$ismask = false;
    		$border = 0;
    		$fitbox = 'LT';
    		$hidden = false;
    		$fitonpage = false;
    		
    		
    		$grami	= $param['grami'] ;
    		$stili	= $param['stili'] ;
    		$grami0	= $param['grami0'] ;
    		$stili0	= $param['stili0'] ;
    		
    		$link		= (isset($param['link']))?$param['link'] : '';
    		$upi		= (isset($param['upi']))?$param['upi'] : false;
    		
    		if($this->peg_tmp_lastPosition==2 and !$this->bodyFlush ){
    			$rowEndTmp = $grami0;
    			/* if($rowEndTmp==0){
    				$rowEndTmp = ($this->_getNumOfRowsFromTCPDFHeight($this->getStringHeight($width, $text)) +$grami);
    			} */
    			
    		
    			$this->_pushBodyElement(array(
    					'fname' => 'peg_print_image_array',
    					'rowstart'	=> $grami,
    					'rowend'	=> $rowEndTmp,
    					'upi'		=> $upi,
    					'args'	=> array(
    							'param' => $param,
    							'text' => $text
    					)
    			));
    			return ;
    		}
    		
    		$x_tmp = $this->_getTCPDFXFromStili($stili);
    		$y_tmp = $this->_getTCPDFYFromGrammi($grami);
    		
    		if(!file_exists($file)){
    			return;
    		}
    		
    		
    		$width = $this->_getTCPDFWidth($stili,$stili0); // The width to print in user unit
    		$height =  $this->_getTCPDFHeight($grami,$grami0);// The height to print in user unit
    		
    		
    		list($image_width, $image_height, $image_type, $image_attr) = getimagesize($file);
    		
    		if($image_width<($width*$this->k) ){
    			$width = 0;
    		}
    		if($image_height<($height*$this->k) ){
    			$height = 0;
    		}
    		/*
    		$this->SetXY($x_tmp  ,   $y_tmp);
     		$text = ' grami=' . $grami. ', grami0=' . $grami0 . ' stili=' . $stili .' , stili0='. $stili0 . ' width=' . $width . ' height=' . $height;
    		$this->Cell($width , 0  , $text , 0  , 0 , $align , false, ''); */
    		
    		
    		$this->Image($file, $x_tmp, $y_tmp, $width, $height, '', $link,$align, $resize, 0, $palign, $ismask,$ismask, $border, $fitbox, 	$hidden, $fitonpage, false); 		
		}
		
    	/**
    	 * 1d
    	 *  'C39':  // CODE 39 - ANSI MH10.8M-1983 - USD-3 - 3 of 9.
    	 *  'C39+': // CODE 39 with checksum
    	 *  'C39E': // CODE 39 EXTENDED
    	 *  'C39E+': // CODE 39 EXTENDED + CHECKSUM
    	 *  'C93': // CODE 93 - USS-93
    	 *  'S25': // Standard 2 of 5
    	 *  'S25+': // Standard 2 of 5 + CHECKSUM
    	 *  'I25': // Interleaved 2 of 5
    	 *  'I25+': // Interleaved 2 of 5 + CHECKSUM
    	 *  'C128': // CODE 128
    	 *  'C128A': // CODE 128 A
    	 *  'C128B': // CODE 128 B
    	 *  'C128C': // CODE 128 C
    	 *  'EAN2': // 2-Digits UPC-Based Extension
    	 *  'EAN5': // 5-Digits UPC-Based Extension
    	 *  'EAN8': // EAN 8
    	 *  'EAN13': // EAN 13
    	 *  'UPCA': // UPC-A
    	 *  'UPCE': // UPC-E
    	 *  'MSI': // MSI (Variation of Plessey code)
    	 *  'MSI+': // MSI + CHECKSUM (modulo 11)
    	 *  'POSTNET': // POSTNET
    	 *  'PLANET': // PLANET
    	 *  'RMS4CC': // RMS4CC (Royal Mail 4-state Customer Code) - CBC (Customer Bar Code)
    	 *  'KIX': // KIX (Klant index - Customer index)
    	 *  'IMB': // IMB - Intelligent Mail Barcode - Onecode - USPS-B-3200
    	 *  'IMBPRE': // IMB - Intelligent Mail Barcode - Onecode - USPS-B-3200- pre-processed
    	 *  'CODABAR': // CODABAR
    	 *  'CODE11': // CODE 11
    	 *  'PHARMA': // PHARMACODE
    	 *  'PHARMA2T': // PHARMACODE TWO-TRACKS
    	 
    	 * DATAMATRIX : Datamatrix (ISO/IEC 16022)
    	 * PDF417 : PDF417 (ISO/IEC 15438:2006) PDF417,a,e,t,s,f,o0,o1,o2,o3,o4,o5,o6 :
    	 * QRCODE
    	 * RAW
    	 * RAW2
    	 *
    	 
    	 
    	 * @param array $param
    	 * @param number $value
    	 */
    	public function peg_print_barcode_array($param = array(), $value){
    	    $this->peg_tmp_lastPrintType = 'barcode';
    	    
    	    $width = 0;
    	    $height = 0;
    	    //T: top-right for LTR or top-left for RTL
    	    //M: middle-right for LTR or middle-left for RTL
    	    //B: bottom-right for LTR or bottom-left for RTL
    	    //N: next line
    	    $align	= 'L';
    	    //if true distort the barcode to fit width and height, otherwise preserve aspect ratio
    	    //only 2D
    	    $distort = false;
    	    $style = array(
    	        'position' => '',
    	        'align' => 'C',
    	        'stretch' => false,
    	        'fitwidth' => true,
    	        'cellfitalign' => '',
    	        'border' => false,
    	        'hpadding' => 'auto',
    	        'vpadding' => 'auto',
    	        'fgcolor' => array(0,0,0),
    	        'bgcolor' => false, //array(255,255,255),
    	        'text' => true,
    	        'font' => 'helvetica',
    	        'fontsize' => 8,
    	        'stretchtext' => 4
    	    );
    	    
    	    //(float) width of the smallest bar in user units (empty string = default value = 0.4mm)
    	    //Only 1D
    	    $xres = null;
    	    
    	    
    	    
    	    $grami	= $param['grami'] ;
    	    $stili	= $param['stili'] ;
    	    $grami0	= $param['grami0'] ;
    	    $stili0	= $param['stili0'] ;
    	    
    	    $type        = (isset($param['type']))?$param['type'] : 'C39'; 
            $orientation = (isset($param['orientation']))?$param['orientation'] : 'H'; 
    	    $upi		 = (isset($param['upi']))?$param['upi'] : false;
    	    
    	    if(empty($value) && isset($param['args']) && isset($param['args']['text'])){
    	        $value = $param['args']['text'];
    	    }
    	    
    	    if($this->peg_tmp_lastPosition==2 and !$this->bodyFlush ){
    	        $rowEndTmp = $grami0;
				/* 
				if($rowEndTmp==0){
    	        	$rowEndTmp = ($this->_getNumOfRowsFromTCPDFHeight($this->getStringHeight($width, $text)) +$grami);
				} 
				*/
    	        
    	        
    	        $this->_pushBodyElement(array(
    	            'fname' => 'peg_print_barcode_array',
    	            'rowstart'	=> $grami,
    	            'rowend'	=> $rowEndTmp,
    	            'upi'		=> $upi,
    	            'args'	=> array(
    	                'param' => $param,
    	                'text' => $value
    	            )
    	        ));
    	        return ;
    	    }
    	    
    	    $x_tmp = $this->_getTCPDFXFromStili($stili);
    	    $y_tmp = $this->_getTCPDFYFromGrammi($grami);
    	    
    	    if(empty($value)){
    	        return;
    	    }
    	    
    	    $width  = $this->_getTCPDFWidth($stili,$stili0); // The width to print in user unit
    	    $height = $this->_getTCPDFHeight($grami,$grami0);// The height to print in user unit
 
    	    if( in_array($type, array('DATAMATRIX', 'PDF417', 'QRCODE', 'RAW', 'RAW2'))){
    	        $this->write2DBarcode($value, $type, $x_tmp, $y_tmp,$width, $height, $style , $align , $distort);
    	    }else{
    	        if($orientation=='H'){
    	           $this->write1DBarcode($value, $type, $x_tmp, $y_tmp, $width, $height, $xres , $style , $align);    
    	        }elseif($orientation=='V'){
                    $this->StartTransform();
                    $this->Rotate(90, $x_tmp+$width, $y_tmp+$height);
                    $this->write1DBarcode($value, $type, $x_tmp+$width, $y_tmp+$height-$width, $height, $width, $xres, $style , $align);
                    $this->StopTransform();    
    	        }
    	    }
    	} 
    
    	/**
    	 * Kanei set ta margins
    	 * Pros to paron to bottom to agnwei
    	 * @param number $top_margin
    	 * @param number $left_margin
    	 * @param number $bottom_margin
    	 * @param number $right_margin
    	 */
    	public function peg_set_margins($top_margin=0 ,$left_margin=0 , $bottom_margin=0 , $right_margin=0 ){
    		$this->_setTopMargin($top_margin);
    		$this->_setRightMargin($right_margin);
    		$this->_setLeftMargin($left_margin);
    	
    	}
    	
    	/**
    	 * Epstrefi thn grammi poy tipwsai teleytaia fora
    	 * @return number
    	 */
    	public function getTCPDFLastRow(){
    	    return ($this->_getRowFromY($this->y) -  $this->custom_offset_y );
    	}
    	
    	/**
    	 * Arxikopoiei poses grammes tha exei to PDF
    	 * @param double $grammes
    	 */
    	private function _setGrammes($grammes){
    		if(empty($this->grammes )){
    			if(!empty($grammes)){
    				$this->grammes = $grammes;
    				$this->g_height = ($this->h /$this->grammes);
    			}
    		}
    	}
    	/**
    	 * Arxikopoiei poses steiles tha exei to PDF
    	 * @param double $stiles
    	 */
    	private function _setStiles($stiles){
    		if(empty($this->stiles )){
    			if(!empty($stiles)){
    				$this->stiles = $stiles;
    				$this->s_width = ($this->w )/$this->stiles;
    			}
    		}
    	}
    	/**
    	 * To margin apo aristera
    	 * @param double $margin
    	 */
    	private function _setLeftMargin($margin){
    		if(!empty($margin) or $margin===0){
    			$this->left_margin = $margin;
    			parent::SetLeftMargin(($this->left_margin * $this->s_width ));
    		}
    	}
    	 /**
    	  * To margin apo pano
    	  * @param double $margin
    	  */
    	private function _setTopMargin($margin) {
    		if(!empty($margin) or $margin===0){
    			$this->top_margin = $margin;
    			parent::SetTopMargin(($this->top_margin*$this->g_height));
    		}
    	}
    	 /**
    	  * To deji margin
    	  * @param double $margin
    	  */
    	private function _setRightMargin($margin){
    		if(!empty($margin) or $margin===0){
    			$this->right_margin = $margin;
    			parent::SetRightMargin(($this->right_margin * $this->s_width));
    		}
    	}
    	/**
    	 * Epistrefei to upsos se grammes
    	 * Ean to end == 0 || $end == $start epistrefei to 1
    	 * Ean to end < start epistrefei to absolute end
    	 * Diaforetika epistrefei thn diafora tous
    	 * @param float $start grammi apo
    	 * @param float $end grammi eos
    	 * @return number
    	 */
     	private function _getHeight($start,$end){
     		$start = floatval($start);
     		$end = floatval($end);
     		
     		if($end == 0 || $end == $start){
     			$this->peg_tmp_lasth = 1;
     		}elseif ($end > $start){
     			$this->peg_tmp_lasth = $end - $start;
     		}else{
     			$this->peg_tmp_lasth = abs($end);
     		}
    		/*if($this->peg_tmp_lasth<1){
    			$this->peg_tmp_lasth=1;
    		}*/
    		
     		return $this->peg_tmp_lasth;
     	}  
    	
    	/**
    	 * Epistrefei to x position sto PDF
    	 * @param double $stili
    	 * @return float
    	 */
    	private function _getTCPDFXFromStili($stili){
    		return (($stili*$this->s_width)+($this->left_margin*$this->s_width) );
    	}
    	/**
    	 * Epistrefei to Y sto PDF
    	 * @param double $grami
    	 * @return float
    	 */
    	private function _getTCPDFYFromGrammi($grami){
    		return  ( (($grami) *$this->g_height) + ($this->top_margin*$this->g_height ) );
    	}
    	/**
    	 * Orizoume to stili apo , stili eos kai mas epistrefei to width gia to TCPDF
    	 * @param double $start
    	 * @param double $end
    	 * @return number
    	 */
    	private function _getTCPDFWidth($start,$end){
    		return (($end-$start)*$this->s_width);
    	}
    	/**
    	 * Orizoume to grammi apo , grammi eos kai mas epistrefei to height gia to TCPDF
    	 * @param double $start
    	 * @param double $end
    	 * @return number
    	 */
    	private function _getTCPDFHeight($start,$end){
    		return (float) (($this->_getHeight($start, $end))*$this->g_height);
    	}
    	
    	/**
    	 * Epistrefei thn grammi apo to y toy TCPDF
    	 * @param float $y //Current vertical position in user unit for cell positioning.
    	 * @return number
    	 */
    	private function _getRowFromY($y){
    		return  (($y /$this->g_height) - $this->top_margin);
    	}
    	
    	private function _getNumOfRowsFromTCPDFHeight($height){
    		return  ($height /$this->g_height) ;
    	}
    	/**
    	 * Sthn allagi selidas midenizei ta Upsoi
    	 */
    	private function _updMinusGrammes($i=0){
    		if($this->updMinusTrigger){
    			 
    			if($i>0){$i--;}// To i jekinaei apo 1
    			// oi grammes pou dilwnw stp p87
    			$this->minusGrammes = $this->lastRow+ $i ;
    		
    			if($this->printHeaderOnce){
    				//To $this->max_head_row kai to bodyheight ensomatonontai sto minusGrammes					
    				$this->updateMaxHeaderRow();
					
    				$this->offset_y			= 0;
    				$this->bodyheight		= 0;				
    			}
    			
				$this->peg_tmp_last_body_current_row = 0;
				
			$this->peg_tmp_last_body_rowstart = 0;     		
			$this->peg_tmp_last_body_rowend   = 0;  

    			$this->updMinusTrigger	= false;	
    		}
    	} 
    	
    	private function updateMaxHeaderRow(){
			//Η συνάρτηση αυτή καλείται στην αλλαγή σελίδας  if($this->printHeaderOnce ) 
			// και στο πρώτο στοιχείο το body

			/*σετάρω το max_head_row = με την τελευταία γραμμή που εκτυπώθηκε */
			$this->max_head_row		= $this->getTCPDFLastRow();
			
			if($this->printHeaderOnce ){
				$this->extra_header_height_on_top_header_once = $this->max_head_row;
			}

    		if($this->peg_tmp_lastPrintType=='exp'){ 
				//To do -> ίσως χρειάζεται να σετάρω και το extra_header_height_on_top_header_once
				$this->max_head_row += $this->peg_tmp_lasth;
			} 		

			if($_REQUEST['debug___']==1){
                echo '<pre> updateMaxHeaderRow start</pre>';
                echo '<pre> getTCPDFLastRow: ' . $this->getTCPDFLastRow(). ' </pre>';
                echo '<pre> extra_header_height_on_top_header_once: ' . $this->extra_header_height_on_top_header_once. ' </pre>';
				echo '<pre> peg_tmp_lasth: ' . $this->peg_tmp_lasth. ' </pre>';
				echo '<pre> max_head_row: ' . $this->max_head_row. ' </pre>';
				echo '<pre> updateMaxHeaderRow end</pre>';
			}


    	}
    	
    	/**
    	 * Kanei pish ena ellement tou body ean to height tou enia mealitero ap;o ta alla tote
    	 * kanei pdate to max row tis grammis
    	 * @param array $elem
    	 * @method peg_print_line -- Den allazei to upsos
    	 * @method peg_print_text -- Den allazei to upsos
    	 * @method peg_print_cell -- Mporei na allajei to upsos
    	 * @method peg_print_memo_array -- Mporei na allajei to upsos
    	 * @method peg_print_html_array -- Mporei na allajei to upsos
    	 * @method peg_print_image_array -- Mporei na allajei to upsos
    	 */
    	private function _pushBodyElement( $elem = array()){
    	   
    	    
			$this->body_row_i_data['grammistart'] =  $this->body_tmp_i;
			
    		//TODO Otan allazei h grammi top na kanw flush to body kai na kalw to addbosy
    		$tmpStartRow = null;
    		$tmpEndRow = null;
    		switch ($elem['fnameaddBodyI']) {
    			case 'peg_print_line':
    				$tmpStartRow = $elem['rowstart'];
    				break;
    			case 'peg_print_text':
    				$tmpStartRow = $elem['rowstart'];
    				if(!empty($elem['args']['text'])){
    					$tmpEndRow = ($tmpStartRow + $this->_getNumOfRowsFromTCPDFHeight($this->getCellHeight($this->FontSize)) );
    				}else{
    					$tmpEndRow  = $elem['rowend'];
    				}
    				break;
    			default:
    				$tmpStartRow = $elem['rowstart'];
    				$tmpEndRow  = $elem['rowend'];
    				break;
			}
			
			
    		$elem['font'] = array('family' => $this->FontFamily, 'style' => $this->FontStyle, 'sizept' => $this->FontSizePt);
    		$elem['fillColorAr'] = $this->fillColorAr;
    		$elem['drawColorAr'] = $this->drawColorAr;
    		$elem['textColorAr'] = $this->textColorAr;
			$this->SetFont($elem['font']['family'], $elem['font']['style'],$elem['font']['sizept']);  		    	
    		if($tmpStartRow!==NULL and   ( $this->body_row_i_data['rowstart']<$tmpStartRow || $this->body_row_i_data['rowstart']===NULL)  ){
    			/* echo "Ean exw allagi grammis se ena rec ths mias grammis tou body"; */
    			// Ean exw allagi grammis se ena rec ths mias grammis tou body
    			if($this->body_row_i_data['rowstart']!==NULL){
	
					//$tmpVarFloat = $this->_getHeight( $this->body_row_i_data['rowstart'], $this->body_row_i_data['rowend']);
					$this->_flushBodyI();
					//$this->offset_y+=$tmpVarFloat ;
					///$this->_flushBodyI();
    			}else{
    				$this->peg_tmp_last_bodyrow = $tmpStartRow;
    			}
    		
    			if($this->body_row_i_data['rowstart']===NULL ){
    				//Prepei na einai jexwristo giati to  $this->_flushBodyI(); mporei na to kanei null
    				$this->body_row_i_data['rowstart']=$tmpStartRow;
    			}
    			$this->body_row_i_data['elem'][] = $elem;
    			
    		}else{
    			$this->body_row_i_data['elem'][] = $elem;    			
    		}
    		
    		
    		
    		if($elem['upi']){
    			//$this->body_row_i_data['elem'][] = $elem;
    			//array_push($this->body_row_i_data['elem'], $elem);
    			if($tmpEndRow!==NULL  and $this->body_row_i_data['rowend']<$tmpEndRow ){
    				$this->body_row_i_data['rowend']=$tmpEndRow;
					if($_REQUEST['debug___']==1){
						echo  '<pre>mpike sto upi </pre>';
						echo  '<pre>--->' . $this->body_row_i_data['rowend'] . '  </pre>';
						echo  '<pre>--->' . $tmpEndRow . '  </pre>';
						
					}
					}
    			
    			
				$this->_flushBodyI();
				
				// $tmpVarFloat = $this->_getHeight( $elem['rowstart'], $elem['rowend']);
				// $this->offset_y+=$tmpVarFloat ;
			}
			
			
    		//Sta arxidia mou poy ekteleite panta sto telos
    		if($tmpEndRow!==NULL  and $this->body_row_i_data['rowend']<$tmpEndRow ){
				//see ppy 2035180
				if($_REQUEST['debug___']==1){
					echo  '<pre>mpike sto apo kato </pre>';
					echo  '<pre>--->' . $this->body_row_i_data['rowend'] . '  </pre>';
					echo  '<pre>--->' . $tmpEndRow . '  </pre>';
					
				}
    			$this->body_row_i_data['rowend']=$tmpEndRow;
    		}

		
			

			if($_REQUEST['debug___']==1){
				echo  '<pre>this->body_row_i_data rowend ' . $this->body_row_i_data['rowend'] . '</pre>';
				echo  '<pre>elem ' . print_r($elem,true) . '</pre>';
			}
    	}
    	
    	/**
    	 * Kanei minus to row twn body element
    	 */
    	private function _updateBodyElement( $i ){
    	   
    		//Efoson to position exw apo to cash
    		//den thelw sto update na mou kanei minus grammes
    		$this->peg_tmp_lastPosition = 2;
    		$this->body_row_i_data['rowstart']		= $this->body_row_i_data['rowstart']+$i;
    		$this->body_row_i_data['rowend']		= $this->body_row_i_data['rowend'] + $i;
    		
    		
    		
    		//$i
    		foreach ($this->body_row_i_data['elem']  as &$elem ){
				//$this->_updateBodyElementData($elem ,$i, $this->body_row_i_data['rowstart'], $this->body_row_i_data['rowend']); -- den xreiazontai kapou i metablites..
				$this->_updateBodyElementData($elem ,$i);
    		}
    	}
    
    	private function _updateBodyElementData(&$elem,$i ,$rowstart = 0,$rowend = 0){
    		
    			switch ($elem['fname']) {
    				case 'peg_print_line':
    					$elem['args']['grami_top']=$elem['args']['grami_top']+$i;
    					$elem['args']['grami_bottom']=$elem['args']['grami_bottom']+$i;
    			
    					break;
    				case 'peg_print_text':
    					$elem['args']['grami']=$elem['args']['grami']+$i;
    					break;
    				default:
    					if (is_array($elem['args']['param'])){
    						if($elem['args']['param']['grami0']>0){
    							$elem['args']['param']['grami0']=$elem['args']['param']['grami0']+$i;
    						}
    						if($elem['args']['param']['grami']>0){
    							$elem['args']['param']['grami'] = $elem['args']['param']['grami']+$i;
    						}
    					}
    					if (is_array($elem['args'])){
    					    $elem['args']['grami0'] = $elem['args']['grami0'] +$i;
    					}
    					break;
    			}
    			$elem['rowstart']	= $elem['rowstart'] + $i;
    			$elem['rowend']		= $elem['rowend'] + $i;
    		
    	}
    	
    	
    	/**
    	 * Einai upo katargisi
    	 * @deprecated
    	 * @see peg_print_memo_array()
    	 */
    	public function peg_print_memo($grami , $stili ,$grami0 , $stili0  , $text){
    	
    		if(empty($text)){
    			return ;
    		}
    	
    		return $this->peg_print_memo_array(
    				array(
    						'grami' => $grami,
    						'stili' => $stili,
    						'grami0' => $grami0,
    						'stili0' => $stili0
    				) ,$text
    		);
    	
		}
		
    	/**
    	 * Einai upo katargisi
    	 * @deprecated
    	 * @see peg_print_image_array()
    	 */
    	public function peg_print_image($file , $grami , $stili , $grami_h , $stili_w   ){
    	
    		$this->peg_print_image_array(
    				array(
    						'grami' => $grami,
    						'stili' => $stili,
    						'grami0' => $grami_h,
    						'stili0' => $stili_w
    				) ,$file
    		);
    	}
    	
    }	
    
?>
