<?php

    class PrintsData {

        public $p85_input;
        
        protected $sid;
        protected $p85_nr01;
        protected $p85_arr;

        protected $body_sql;
        protected $multiple_input_mode;

        protected $global_data;
        protected $body_data;        
        protected $body_data_index;
        protected $body_num_of_rows;


        public function __construct($p85nr01=0, $sid=0, $p85_input=array()){

            $this->sid = ($sid==0) ? session_id() : $sid;
            $this->p85_nr01  = $p85nr01;
            $this->p85_input = $p85_input;
            
            pegasus_mysql_use('select * from p85 where nr01=:p85_nr01', $this->p85_arr, array('p85_nr01'=>$this->p85_nr01));

            
            $this->setBodySql();
            $this->setMultipleInputMode(1);   
            $this->body_data_index = 0;          
        }
        
        /**
         * Initialize Standard Expressions
         * Populate prints_01 Temporary Table (peg_tmp_prints_01)
         */
        public function initializeStandardExpressions(){
            
            $global_exps = $this->getGlobalExpressions();
            $body_exps   = $this->getBodyExpressions();

            $exps = array_merge($global_exps, $body_exps);
            
            $standard_exps = array();
            foreach($exps as $exp){
                $this->pushStandardExpression($standard_exps, $exp);
            }
            $this->updateStandardExpressions($standard_exps);

            
            //echo "<pre>". print_r($standard_exps,1) . "</pre>";
        }

        /**
         * Get Global Expressions (Expressions for any Position)
         * @return array prints_01 fields 
         */
        protected function getGlobalExpressions(){
           
            $core_titles_exps = $this->getCoreTitlesExpressions();
            $image_exps       = $this->getImagesExpressions();
            $pdf_exps         = $this->getPdfExpressions();
            $q10_exps         = $this->getQ10GlobalExpressions();

            $global_exps = array();
            $global_exps = array_merge($core_titles_exps, $image_exps, $pdf_exps, $q10_exps);
            return $global_exps;
        }

        protected function getCoreTitlesExpressions(){
            $core_titles_exps = array();

            for($i=1; $i<=8; $i++){ 
                $p00 = 'cor000_tit_line'.$i;    $p01 = $i.'η Γραμμή Τίτλου';
                $p30 = 'return array("text"=>$pdf->printsData->getData("'.$p00.'"), "autoSizing"=>true);';
                $core_titles_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p03'=>60); 
            }
            
            for($i=1; $i<=8; $i++){ 
                $p00 = 'cor000_eng_tit_line'.$i;    $p01 = $i.'η Γραμμή Τίτλου (EN)';
                $p30 = 'return array("text"=>$pdf->printsData->getData("'.$p00.'"), "autoSizing"=>true);';
                $core_titles_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p03'=>60); 
            }

            return $core_titles_exps;
        }

        protected function getPdfExpressions(){

            $pdf_exps = array();           
            
            
            //Page Number
            $p00 = 'pdf_page_number';   $p01 = 'Αριθμός Σελίδας';
            $p30 = 'return array("text"=>$pdf->getPage());'; 
            $pdf_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C');  

            //String alias used for the page number
            $p00 = 'pdf_alias_num_page';    $p01 = 'Αριθμός Σελίδας (alias)';
            $p30 = 'return array("text"=>$pdf->getAliasNumPage());';  
            $pdf_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C'); 

            //String alias used for the total number of pages
            $p00 = 'pdf_alias_nb_pages';    $p01 = 'Συνολικό Πλήθος Σελίδων (alias)';
            $p30 = 'return array("text"=>$pdf->getAliasNbPages());'; 
            $pdf_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C'); 
            
            return $pdf_exps;
        }

        protected function getImagesExpressions(){

            $image_exps = array();    
            
            $query = 'select * from prints_02 where p85=:p85nr01;';
            $res   = pegasus_query($query, array('p85nr01'=>$this->p85_nr01));
            
            
            while ($prints_02 = pegasus_fetch_assoc($res)) {
                $p00 =  "prints_02_p00_" . $prints_02['p00'];
                $p01 =  $prints_02['p01']. " " . str_replace('##p00##', $prints_02['p00'], $_SESSION['peg_dic_prints_prints_02_expr_descr']);
                $p30 = 'return array("img"=>$pdf->printsData->getImage("'.$p00 .'"));'; 
                
                $image_exps[] = array('p00'=>$p00 , 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p05'=>'image'); 
            }
            
            return $image_exps;
        }

        protected function getQ10GlobalExpressions(){

            $q10_exps = array();            
            
            if(!empty($this->p85_arr['q10'])){          
                $values_arr = array('q10nr01'=>$this->p85_arr['q10']);
                
                $q10_tbl_exps = self::getTableExpressions('q10');
                foreach ($q10_tbl_exps as $exp) {
                    if(in_array($exp['p00'], array('q10_nr01_q10_nr01_nr01','q10_nr01_q10_nr01_p01','q10_nr01_q10_nr01_ep01'))){
                        $q10_exps[] = $exp;
                    }
                }

                $query = 'select * from q13 where p00=:q10nr01 order by p05;';
                $res   = pegasus_query($query, $values_arr);
                
                while ($q13 = pegasus_fetch_assoc($res)) {
                    $q10_exps[] = array('p00'=>$q13['p02'],         'p01'=>$q13['p01'], 'p30'=>'getData', 'p02'=>$q13['p03'], 'p04'=>$q13['p03_1']); 
                    $q10_exps[] = array('p00'=>$q13['p02'].'_p01',  'p01'=>$q13['p01']  .' (Τίτλος Μεταβλητής el)', 'p30'=>'getData', 'p02'=>'C', 'p04'=>30); 
                    $q10_exps[] = array('p00'=>$q13['p02'].'_ep01', 'p01'=>$q13['ep01'] .' (Τίτλος Μεταβλητής en)', 'p30'=>'getData', 'p02'=>'C', 'p04'=>30); 
                }

                $query = 'select * from q12 where p00=:q10nr01 order by p05;';
                $res   = pegasus_query($query, $values_arr);
                
                while ($q12 = pegasus_fetch_assoc($res)) {
                    $q10_exps[] = array('p00'=>$q12['p03'].'_p01',  'p01'=>$q12['p01']  .' (Τίτλος Πεδίου el)', 'p30'=>'getData', 'p02'=>'C', 'p04'=>30); 
                    $q10_exps[] = array('p00'=>$q12['p03'].'_ep01', 'p01'=>$q12['ep01'] .' (Τίτλος Πεδίου en)', 'p30'=>'getData', 'p02'=>'C', 'p04'=>30); 
                }
            }
            
            //echo "<pre>". print_r($q10_exps,1) . "</pre>";
            return $q10_exps;
        }

        /**
         * Get Body Expressions (Expressions for Body Position)
         * Get Columns from the Body SQL Query or the Report (q10) or the Main Table
         * @return array prints_01 fields 
         */
        protected function getBodyExpressions(){

            $body_exps = array();   
            
            $body_sql = $this->getBodySql(); 
            if(is_array($body_sql) && !empty($body_sql['sql'])){
                return $body_exps;
            }
            
            if(!empty($this->p85_arr['q10'])){                
                $body_exps = $this->getQ10Expressions();
            }else{                
                $body_exps = self::getTableExpressions($this->p85_arr['p50'], true);
            }

            //echo "<pre>". print_r($body_exps,1) . "</pre>";
            return $body_exps;
        }

        protected function getQ10Expressions(){

            $q10_exps = array();
            $p30 = 'getBodyData';

            $query = 'select * from q12 where p00=:q10nr01 order by p05;';
            $res   = pegasus_query($query, array('q10nr01'=>$this->p85_arr['q10']));
            
            while ($q12 = pegasus_fetch_assoc($res)) {
                $q10_exps[] = array('p00'=>$q12['p03'], 'p01'=>$q12['p01'], 'p30'=>$p30, 'p100'=>1, 'p02'=>$q12['p06'], 'p03'=>$q12['p07'], 'p04'=>$q12['p08']); 
            }
            
            return $q10_exps;
        }

        protected static function sanitizeExpressionField($field_name){
            return $field_name;
        }

        protected static function getExpressionType($view_type){

            if($view_type=='textarea'){
                return 'exp_memo';
            }elseif($view_type=='tinymce'){
                return 'exp_html';
            }else{
                return 'exp';
            }

        }

        protected function pushStandardExpression(&$expressions_arr, $prints_01){
            
            if(in_array($prints_01['p30'], array('getData', 'getBodyData'))){
                $method = str_replace('Data', '', $prints_01['p30']);
                switch (true) {
                    case ($prints_01['p02']=='N' && !empty($prints_01['p04'])):
                        $method = $method.'Number("'.$prints_01['p00'].'", '.$prints_01['p04'].')';
                        break;

                    case ($prints_01['p02']=='D'):
                        $method = $method.'Date("'.$prints_01['p00'].'")';
                        break;
                        
                    case ($prints_01['p02']=='L'):
                        $method = $method.'Logic("'.$prints_01['p00'].'")';
                        break;  
                    
                    default:
                        $method = $method.'Data("'.$prints_01['p00'].'")';
                        break;
                }

                $prints_01['p30'] = 'return array("text"=>$pdf->printsData->'.$method.');';
            } 
            
            if(!empty($prints_01['p01'])){
                $prints_01['p30'] .= "\n" . '/* ' . $prints_01['p01'] . ' */';
            }

            if(empty($prints_01['p05'])){
                $prints_01['p05'] = 'exp';
            }
            
            
            $expressions_arr[$prints_01['p00']] = $prints_01;
        }

        protected function updateStandardExpressions($standard_exps){
            
            //Delete Previous Standard Expressions of "p85"
            self::removeStandardExpressions($this->p85_nr01);

            //Insert Standard Expressions to "prints_01" Table
            foreach ($standard_exps as $exp) {

                $arr1 = array();    $arr2 = array();
                array_push($arr1, 'peg_flag');  array_push($arr2, 1);
                array_push($arr1, 'nr01');          array_push($arr2, pegasus_mysql_newrec('peg_tmp_prints_01'));
                array_push($arr1, 'peg_sess_id');   array_push($arr2, $this->sid);
                array_push($arr1, 'peg_mmnr01');    array_push($arr2, "p85_d-".$this->p85_nr01);
                array_push($arr1, 'peg_mnr01');     array_push($arr2, $this->p85_nr01);
                
                foreach ($exp as $key => $value) {
                    array_push($arr1, $key);   array_push($arr2, $value);
                }
                
                pegasus_mysql_insert('peg_tmp_prints_01', $arr1, $arr2);
                          
            }
        }        

        public function getStandardExpressions($prints_01_p00=''){


            $values = array(  
                "mnr01"   => $this->p85_nr01,
                "mmnr01"  => "p85_d-".$this->p85_nr01
            );

            $where = '';
            if($prints_01_p00!=''){
                $where .= ' and p00=:p00 ';
                $values['p00'] = $prints_01_p00;
            }

            $query  = 'select * ';
            $query .= 'from peg_tmp_prints_01 ';
            $query .= 'where peg_flag!=9 and peg_mmnr01=:mmnr01 and peg_mnr01=:mnr01 '. $where .';';

            $result = pegasus_query($query, $values);
            $standard_exps = pegasus_fetchall($result);

            return $standard_exps;
        }

        public static function removeStandardExpressions($p85_nr01){

            $where = ' peg_flag!=9 and peg_mmnr01=:mmnr01 and peg_mnr01=:mnr01 ';
            $values_array = array(  
                "mnr01"   => $p85_nr01,
                "mmnr01"  => "p85_d-".$p85_nr01
            ); 
            pegasus_mysql_delete('peg_tmp_prints_01', $where, 0, $values_array);

        } 

        /**
         * Make Standard Expressions Data
         * $this->global_data & $this->body_data
         */
        public function makeExpressionsData(){            
            $this->global_data = $this->makeGlobalData();
            $this->body_data   = $this->makeBodyData(); 
            //echo "<pre>". print_r($this->global_data,1) . "</pre>";
            //echo "<pre>". print_r($this->body_data,1) . "</pre>";
        }

        /**
         * Make Global Data (Data for any Position)
         * @return array Global Data
         */
        protected function makeGlobalData(){
            $global_data = array();
            $core_titles_data = $this->makeCoreTitlesData();
            $q10_global_data  = $this->makeQ10GlobalData();
            

            $global_data = array_merge($global_data, $core_titles_data, $q10_global_data);
            return $global_data;
        }
        
        protected function makeCoreTitlesData(){

            $core_titles_data  = array();

            if(function_exists('core_get_store_titles')){
                $core_store_titles = core_get_store_titles();
            }else{
                for($i=1; $i<=8; $i++){
                    $core_store_titles[$i-1] = $_SESSION['cor000_tit_line'.$i];
                    $core_store_titles[$i+7] = $_SESSION['cor000_eng_tit_line'.$i];
                }
            }

            for($i=1; $i<=8; $i++){ 
                $core_titles_data['cor000_tit_line'.$i]     = $core_store_titles[$i-1];
                $core_titles_data['cor000_eng_tit_line'.$i] = $core_store_titles[$i+7];
            }

            return $core_titles_data;    
        }

        protected function makeQ10GlobalData(){

            $q10_global_data = array(); 
            
            if(!empty($this->p85_arr['q10'])){   
                $values_arr = array('q10nr01'=>$this->p85_arr['q10']);

                $q10_data = self::makeTableData('q10', $this->p85_arr['q10']);
                foreach ($q10_data[0] as $key => $value) {
                    if(in_array($key, array('q10_nr01_q10_nr01_nr01','q10_nr01_q10_nr01_p01','q10_nr01_q10_nr01_ep01'))){
                        $q10_global_data[$key] = $value;
                    }
                }

                //Μεταβλητές π-αναφορας
                $query = 'select * from q13 where p00=:q10nr01 order by p05;';
                $res   = pegasus_query($query, $values_arr);
                
                while ($q13 = pegasus_fetch_assoc($res)) {
                    $q10_global_data[$q13['p02'].'_p01']  = $q13['p01']; 
                    $q10_global_data[$q13['p02'].'_ep01'] = $q13['ep01']; 

                    if(!empty($q13['p07'])){                        
                        $field = (!empty($q13['p09'])) ? $q13['p09'] : $q13['p08'];

                        $separator      = '#';
                        $q13_p02_tmp    = trim($this->p85_input[$q13['p02']], $separator);
                        $q13_values_arr = explode($separator, trim($q13_p02_tmp, $separator));
                        $in_stmt_arr    = pegasus_mysql_create_in($q13_values_arr, $q13['p08']);

                        if(pegasus_mysql_table_exists($q13['p07'])){
                            pegasus_mysql_use('select group_concat(distinct '.$field.') as descr, group_concat(distinct '.$q13['p08'].') as value from '.$q13['p07'].' where '.$q13['p08'].' in ('.$in_stmt_arr['sql'].')', $q13_tmp, $in_stmt_arr['sqlParams']);
                            $q10_global_data[$q13['p02']] = $q13_tmp['descr'];
                            $q10_global_data[$q13['p02'].'_value'] = $q13_tmp['value'];
                        }
                    }else{
                        $q10_global_data[$q13['p02']] = $this->p85_input[$q13['p02']]; 
                    }
                }

                //Πεδία π-αναφορας
                $query = 'select * from q12 where p00=:q10nr01 order by p05;';
                $res   = pegasus_query($query, $values_arr);
                
                while ($q12 = pegasus_fetch_assoc($res)) {
                    $q10_global_data[$q12['p03'].'_p01']  = $q12['p01']; 
                    $q10_global_data[$q12['p03'].'_ep01'] = $q12['ep01']; 
                }
            }

            //echo "<pre>". print_r($q10_global_data,1) . "</pre>";
            
            return $q10_global_data;
        }

        /**
         * Make Body Data (Data for Body Position)
         * Make Data from the Body SQL Query or the Report (q10) or the Main Table
         * @return array Body Data 
         */
        protected function makeBodyData(){  
            
            $body_data = array();
            $body_sql  = $this->getBodySql(); 
            
            if(is_array($body_sql) && !empty($body_sql['sql'])){

                if($this->p85_input['q10_nr01']>0){
                    query_makeQuery00ArrOfReport_replace_q13($this->p85_input['q10_nr01'], $this->p85_input, 1);
                }
                 
                //echo pegasus_replace_values_in_sql($body_sql['sql'], $body_sql['sqlParams']); 
                $result = pegasus_query($body_sql['sql'], $body_sql['sqlParams']); 
                $body_data = pegasus_fetchall($result);

            }elseif(!empty($this->p85_arr['q10'])){                
                $body_data = $this->makeQ10Data();
            }else{
                $body_data = self::makeTableData($this->p85_arr['p50'], $this->p85_input['dias_main_nr01']);
            }

            return  $body_data;
        }

        protected function makeQ10Data(){  

            //Find Q10 Data
            query_makeQuery00ArrOfReport_replace_q13($this->p85_arr['q10'], $this->p85_input, 1);
            $q10_arr = array();
            if(!empty($this->p85_input['dias_container_id'])){
                $q10_arr['sql'] = pegasusGetGlobalVar('gridData_' . $this->p85_input['dias_container_id'] . '_grid01_query');
                $q10_arr['sqlParams'] = pegasusGetGlobalVar('gridData_' . $this->p85_input['dias_container_id'] . '_grid01_query_whereParams'  );
            }   
            
            if(empty($q10_arr['sql'])){
                $q10_query = query_make_select($this->p85_arr['q10']);
                $q10_arr   = query_replace_q13_from_array($this->p85_arr['q10'], $q10_query, $this->p85_input);
            }
            
            //echo pegasus_replace_values_in_sql($q10_arr['sql'], $q10_arr['sqlParams']); 
            $result   = pegasus_query($q10_arr['sql'], $q10_arr['sqlParams']);
            $q10_data = pegasus_fetchall($result);
            
            return $q10_data; 
        }

        protected function makeGridData(){
            return false;

            //toDO Grid Data
            $body_sql = $this->getBodySql();

            if((is_array($body_sql) && empty($body_sql['sql'])) && empty($this->p85_arr['q10'])){                
                
                $grid_query             = pegasusGetGlobalVar('gridData_' . $this->p85_input['dias_container_id'] . '_grid_query');
                $grid_query_whereParams = pegasusGetGlobalVar('gridData_' . $this->p85_input['dias_container_id'] . '_grid_query_whereParams');    
                $grid_query_table       = pegasusGetGlobalVar('gridData_' . $this->p85_input['dias_container_id'] . '_grid_query_table');
                $grid_queryfield_arr    = pegasusGetGlobalVar('gridData_' . $this->p85_input['dias_container_id'] . '_grid_field_arr');
                //echo "<pre>". print_r($grid_queryfield_arr,1) . "</pre>";
                // echo "<pre>br_query_table= ". $grid_query_table . "</pre>";
                // echo pegasus_replace_values_in_sql($grid_query, $grid_query_whereParams); 

                //Find Grid Field/Type
                $fields_type = array();
                foreach ($grid_queryfield_arr as $fields) {
                    $fields_type[$fields['name']] = array('tp'=>$fields['db_type'], 'sz'=>$fields['desc17'], 'dec'=>$fields['desc18']);
                    if($fields['type']=='comboboxV2' && !empty($fields['br_table'])){
                        $fields_type['v_selectbox_'.$fields['name']] = array('tp'=>'C', 'sz'=>0, 'dec'=>0);
                    }
                }
                
                
                //Find Grid Data
                $result = pegasus_query($grid_query, $grid_query_whereParams);                
                $grid_data = array(); 
                while ($grid=pegasus_fetch_assoc($result)) {
                    $grid_data_tmp = array();
                    foreach ($grid as $key => $value) {
                        $grid_data_tmp[$key] = array_merge(array('value'=>$value), $fields_type[$key]);
                    }
                    $grid_data[] = $grid_data_tmp;
                }
                
                //echo "<pre>". print_r($grid_data,1) . "</pre>";
                return $grid_data;
            }

        }  

        public static function getTableFields($table){

            if(empty($table)){
                return false;
            }
            
            $sql = peg_read_file('../../pegasus_cloud_app/prints_sql/get_table_fields.sql');
            $sql = str_replace('##table##', $table, $sql);
            $sql = str_replace('##table_field##', $_SESSION['peg_dic_prints_table_field'], $sql);
            $sql = str_replace('##table_description##', $_SESSION['peg_dic_prints_table_description'], $sql);
            
            //echo pegasus_replace_values_in_sql($sql, array('tbl'=>$table));
            return array('sql'=>$sql, 'sqlParams'=>array('tbl'=>$table));
        } 

        /**
         * Get Table Expressions
         * Get Columns from a Table and its Related Tables
         * @param string $table
         * @param boolean $is_body
         * @return array $table_exps
         */
        protected static function getTableExpressions($table, $is_body=false){

            $p30 = ($is_body) ? 'getBodyData' : 'getData';

            $table_exps = array();
            $query = self::getTableFields($table);
            if($query!==false){                
                $res = pegasus_query($query['sql'], $query['sqlParams']);

                while ($table_fld = pegasus_fetch_assoc($res)) {
                    $p00 = static::sanitizeExpressionField($table_fld['tag']);
                    //$p01 = $table_fld['tbl2_name'] .' -> '. $table_fld['fld2_title'];
                    $p01 = $table_fld['tbl_rel_desc'] .' -> '. $table_fld['fld2_title'];
                    $p05 = static::getExpressionType($table_fld['desc07']);
                    $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>$is_body, 'p02'=>$table_fld['desc16'], 'p03'=>$table_fld['desc17'], 'p04'=>$table_fld['desc18'], 'p05'=>$p05); 
                }
            }

            return $table_exps;
        }     

        /**
         * Make Table Data
         * Make Data from a Table and its Related Tables
         * @param string $table
         * @param mixed $table_nr01
         * @return array $table_data 
         */
        protected static function makeTableData($table, $table_nr01){
            $table_nr01_arr = (is_array($table_nr01)) ? $table_nr01 : array($table_nr01);
            $in_stmt_arr    = pegasus_mysql_create_in($table_nr01_arr, 'nr01');
            $values = $in_stmt_arr['sqlParams'];

            $table_data = array(); 
            $table_fld_data = array();

            $fields = '';
            $from   = '';
            $joins  = '';

            $query = self::getTableFields($table);
            // print_r( $query );
            // die();
            if($query!==false){                
                $res = pegasus_query($query['sql'], $query['sqlParams']);
                
                //echo pegasus_replace_values_in_sql($query['sql'], $query['sqlParams']);
                $table_flds_arr = pegasus_fetchall($res);

                $tbl1 = ''; 
                $tbl2 = ''; 
                $fld1 = ''; 
                $fld2 = ''; 

                $table_flds_more_arr = array();
                foreach ($table_flds_arr as $table_fld) {

                    $tag = $table_fld['tag']; 
                    $tbl_name_tag = $table_fld['tbl_name_tag'];
                    
                    if(!in_array($table_fld['tp'], array(1,2))){
                        //Selectboxes from Related Tables
                        $table_flds_more_arr[] = $table_fld;   

                    }else{   
                        
                        $fields_tmp  = $tbl_name_tag.'.'. $table_fld['desc05'];
                        $fields_tmp .= " as ";
                        $fields_tmp .= $tag;

                        $fields .= (!empty($fields)) ? ', ' : '';
                        $fields .= "\n" . $fields_tmp;
                        
                        $fields_arr[$tbl_name_tag][] = $fields_tmp;

                        if( 
                            $tbl1!= $table_fld['tbl1'] or 
                            $tbl2!= $table_fld['tbl2'] or
                            $fld1!= $table_fld['fld1'] or 
                            $fld2!= $table_fld['fld2']  
                            ){
                                
                            $tbl1 =  $table_fld['tbl1']; 
                            $tbl2 =  $table_fld['tbl2'];
                            $fld1 =  $table_fld['fld1']; 
                            $fld2 =  $table_fld['fld2'];
                            $fld3 =  $table_fld['fld3'];
                            $fld4 =  $table_fld['fld4'];
                            $fld5 =  $table_fld['fld5'];
                            $fld6 =  $table_fld['fld6'];
    
                            if($tbl1==$tbl2 and $fld1==$fld2){                                
                                $from =  " (select * from " . $tbl2 . " where nr01 in (".$in_stmt_arr['sql'].") ) as " . $tbl_name_tag . " ";
                                $tbls_array[$tbl2] = $tbl_name_tag;  
                            }else{
    
                                if(!empty($tbls_array[$tbl1])){
                                    $from_tbl_name_tag = $tbls_array[$tbl1];
                                }else{
                                    $from_tbl_name_tag = $tbl1;
                                }                                
    
                                //toDo Views
                                $joins_tmp  = "\n left join " . $tbl2 . " as " . $tbl_name_tag;
                                $joins_tmp .= " on ";
                               

                                if(!empty($fld1)){
                                    if(strpos($fld1, '!:')!==0){
                                        $fld1 = $from_tbl_name_tag.'.'. $fld1;
                                    }
                                    else{
                                        $fld1 = mb_substr($fld1, 2);
                                        $fld1 = "'$fld1'";
                                    }
                                }

                                if(!empty($fld3)){
                                    if(strpos($fld3, '!:')!==0){
                                        $fld3 = $from_tbl_name_tag.'.'. $fld3;
                                    }
                                    else{
                                        $fld3 = mb_substr($fld3, 2);
                                        $fld3 = "'$fld3'";
                                    }
                                }

                                if(!empty($fld5)){
                                    if(strpos($fld5, '!:')!==0){
                                        $fld5 = $from_tbl_name_tag.'.'. $fld5;
                                    }
                                    else{
                                        $fld5 = mb_substr($fld5, 2);
                                        $fld5 = "'$fld5'";
                                    }
                                }

                                if(!empty($fld2)){
                                    if(strpos($fld2, '!:')!==0){
                                        $fld2 = $tbl_name_tag.'.'. $fld2;
                                    }
                                    else{
                                        $fld2 = mb_substr($fld2, 2);
                                        $fld2 = "'$fld2'";
                                    }
                                }

                                if(!empty($fld4)){
                                    if(strpos($fld4, '!:')!==0){
                                        $fld4 = $tbl_name_tag.'.'. $fld4;
                                    }
                                    else{
                                        $fld4 = mb_substr($fld4, 2);
                                        $fld4 = "'$fld4'";
                                    }
                                }

                                if(!empty($fld6)){
                                    if(strpos($fld6, '!:')!==0){
                                        $fld6 = $tbl_name_tag.'.'. $fld6;
                                    }
                                    else{
                                        $fld6 = mb_substr($fld6, 2);
                                        $fld6 = "'$fld6'";
                                    }
                                }
                                
                                $joins_tmp .= $fld2 . "=" . $fld1;
                               
                                if(!empty($fld3) && !empty($fld4)){
                                    $joins_tmp .= " and " . $fld4 . "=" .$fld3;
                                }                            
                                if(!empty($fld5) && !empty($fld6)){
                                    $joins_tmp .= " and " .$fld6 . "=" .$fld5;
                                }
                                
                                $joins_arr[$tbl_name_tag] = $joins_tmp;
                                $joins .= $joins_tmp;
                            }
    
                        }
                    }
                    
                }
            }

            
            $group_tbl_name_tag = $table.'_nr01_'.$table.'_nr01';
            //$select = 'select ' .  $fields . ' from ' . $from . $joins . " group by " . $group_tbl_name_tag.".nr01;";	
                 
            
            //Main & Related Tables (type=1,2)
            foreach ($fields_arr as $tbl_name_tag => $flds) {
                $select  = "select " .  implode(", \n", $fields_arr[$tbl_name_tag]);
                $select .= "\n" . "from " . $from . $joins_arr[$tbl_name_tag];
                $select .= "\n" . "group by " . $group_tbl_name_tag.".nr01 ";	
                $select .= "\n"."order by field(".$group_tbl_name_tag.".nr01,".$in_stmt_arr['sql'].");";
                
                // echo "<pre>". pegasus_replace_values_in_sql($select, $values) . "</pre>";
                // echo "<pre>". $select. "</pre>";
                // echo "<pre>". print_r($values, 1). "\n\n---\n</pre>";
                

                $result = pegasus_query($select, $values);
                $tbl_data_tmp = pegasus_fetchall($result);

                foreach ($tbl_data_tmp as $i => $data_tmp) {
                    foreach ($data_tmp as $key => $value) {
                        $table_data[$i][static::sanitizeExpressionField($key)] = $value;
                    }
                }
            }
            


            //Selectboxes from Related Tables (type=3,4)
            foreach ($table_flds_more_arr as  $table_fld) {
                $select  = "select " .   $table_fld["tbl_name_tag"].".". $table_fld["desc05"] . " as " . $table_fld["tag"];
                $select .= "\n" . "from (SELECT * FROM ". $table_fld["tbl0"] ." WHERE nr01 in (".$in_stmt_arr['sql'].") ) AS ". $tbls_array[$table_fld["tbl0"]];
                $select .= $joins_arr[ $table_fld["tbl1"]]; 
                $select .= "\n" . "left join " . $table_fld["tbl2"] . " as " .  $table_fld["tbl_name_tag"] . " on " .  $table_fld["tbl_name_tag"].".". $table_fld["fld2"] . "=" . $table_fld["tbl1"].".". $table_fld["fld1"] . " ";
                $select .= "\n"."group by ".$group_tbl_name_tag.".nr01 ";
                $select .= "\n"."order by field(".$group_tbl_name_tag.".nr01,".$in_stmt_arr['sql'].");";
                
                //echo "<pre>". pegasus_replace_values_in_sql($select, $values) . "</pre>";
                
                $result = pegasus_query($select, $values);
                $tbl_data_tmp = pegasus_fetchall($result);
                
                foreach ($tbl_data_tmp as $i => $data_tmp) {
                    foreach ($data_tmp as $key => $value) {
                        $table_data[$i][static::sanitizeExpressionField($key)] = $value;
                    }
                }
            }

            //echo pegasus_replace_values_in_sql($query['sql'], $query['sqlParams']); 
            //echo "<pre>". print_r($table_data,1) . "</pre>";

            
            return  $table_data;
        }

        public function getMultipleInputMode(){
            return $this->multiple_input_mode;
        }

        /**
         * Set Multiple Forms Print Mode
         * @param int $mode 
         * $mode = 0 : Multiple Input Data are printed as Body Data (List of Body Data)
         * $mode = 1 : Multiple Input Data are printed in separate Multiple Forms (Multiple Position Layout)
         */
        public function setMultipleInputMode($mode=1){
            $this->multiple_input_mode = $mode;
        }

        public function getBodySql(){
            return $this->body_sql;
        }


        /**
    	 * Sets Body Data SQL Query
         * $this->body_sql
    	 */
        protected function setBodySql(){

            $sql_code = array();
            if(!empty($this->p85_arr['body_sql_code'])){
                $pdf_printsData = $this;

                $p85 = array();
                foreach ($this->p85_arr as $key => $value){
                    $p85[$key] = $value;
                }

                $sql_code = eval($this->p85_arr['body_sql_code']);

                unset($pdf_printsData);
                unset($p85);
            }
            $this->body_sql = (is_array($sql_code)) ? $sql_code : array('sql'=>$sql_code, 'sqlParams'=>array());
        }       

        /**
         * Get Global Data
         * @param string $field: Expression Code
         * @return mixed 
         */
        public function getData($field=''){
            if($field==''){                
                return $this->global_data;
            }

            return (isset($this->global_data[$field])) ? $this->global_data[$field] : false;
        }
        
        /**
         * Get Numeric Global Data (Formatted Value)
         * @param string $field: Expression Code
         * @param int $decimals
         * @return mixed 
         */
        public function getNumber($field='', $decimals=0){
            $data = $this->getData($field);
            return ($data!==false) ? peg002_format_number($data, $decimals) : false;   
        }

        /**
         * Get Date Global Data (Formatted Value)
         * @param string $field: Expression Code
         * @param string $format
         * @return string 
         */
		public function getDate($field='', $format=''){
            $data = $this->getData($field);
            return ($data!==false) ? peg_dateToStr($data, $format) : false; 
        }

        /**
         * Get Logic Global Data (Formatted Value)
         * @param string $field: Expression Code
         * @return string 
         */
		public function getLogic($field=''){
            if($this->getData($field)==0){
                return $_SESSION['peg_dic_core_no'];
            }else{
                return $_SESSION['peg_dic_core_yes'];
            }
        }

        public function getImage($field=''){
            if(substr($field, 0, 14)=='prints_02_p00_'){
                $field = substr($field, 14);
            }
            $image = prints_get_forms_image_fpath(0, $this->p85_nr01, $field);

            return $image;    
        }

        /**
         * Get Body Data
         * @param string    $field: Expression Code
         * @param int       $index: Body Data array Index
         * @return mixed 
         */
        public function getBodyData($field='', $index=-1){

            //if negative, get the current body data index
            if($index<0){
                $index = $this->body_data_index;
            }

            if($field==''){                
                return $this->body_data[$index];
            }
            
            return (isset($this->body_data[$index][$field])) ? $this->body_data[$index][$field] : false;
        }

        public function getBodyNumber($field='', $decimals=0){
            $data = $this->getBodyData($field);
            return ($data!==false) ? peg002_format_number($data, $decimals) : false;  
        }

		public function getBodyDate($field='', $format=''){
            $data = $this->getBodyData($field);
            return ($data!==false) ? peg_dateToStr($data, $format) : false;
        }

		public function getBodyLogic($field=''){
            if($this->getBodyData($field)==0){
                return $_SESSION['peg_dic_core_no'];
            }else{
                return $_SESSION['peg_dic_core_yes'];
            }
        }

        public function getBodyDataArray(){
            return $this->body_data;
        }

        /**
         * Set Data
         * @param mixed $data (array,string,number)
         * @param string $field: Expression Code
         */
        public function setData($data, $field=''){
            if($field==''){                
                $this->global_data = $data;
            }else{
                $this->global_data[$field] = $data;    
            }
        }

        /**
         * Set Body Data
         * @param array $data
         */
        public function setBodyData($data){
            $this->body_data = $data;
        }


        /**
         * Get Current Body Data Index
         */
        public function getBodyDataIndex(){
            return $this->body_data_index;
        }

        /**
         * Go to Next Body Data Results Row (Index)
         */
        public function goToNextBodyRow(){
            return ++$this->body_data_index;
        }        

        /**
         * Find Num of Body Data Results
         */
        public function getBodyNumOfRows(){
            return count($this->body_data);
        }

        /**
         * Check for Body Data Left
         */
        public function hasMoreBodyData(){
            if($this->body_data_index<$this->getBodyNumOfRows()){
                return true;
            }

            return false;
        }

        public function isFirstBodyData(){
            if($this->body_data_index!=0){
                return false;
            }
            return true;
        }

        public function isLastBodyData(){
            if($this->getBodyNumOfRows()-$this->body_data_index>1){
                return false;
            }
            return true;
        }
    }


    
    /** 
     *  PrintsData List Mode
     *  Multiple Input Data are printed as Body Data (List of Body Data) 
    */
    class PrintsDataList extends PrintsData { 
        
        public function __construct($p85nr01=0, $sid=0, $p85_input=array()){        
            parent::__construct($p85nr01, $sid, $p85_input);
            
            $this->setMultipleInputMode(0);
        }

    }
   
?>