<?php


function prints_create_ascii_file_from_pdf($document_configuration, $text_elements, $txt_path = "./test_txt.txt")
{
    $PrintsPDFToText = new PrintsPDFToText($document_configuration, $text_elements, $txt_path);
    $PrintsPDFToText->print_to_file();
}

/**
 * ΠΑΡΑΔΟΧΕΣ
 * 1. Παίζει μόνο για φόρμες TCPDF
 * 2. Δεν λαμβάνω υπόψιν center και right align καθώς και middle και bottom valign, font-spacing, font-stretching
 * 3. Εάν ένα string δεν χωράει να εκτυπωθεί στο Α4, εγώ δεν το λαμβάνω υπόψιν και το εκτυπώνω ολόκληρο.
 * 4. Δεν έχουμε λάβει υπόψιν Λευκές PageRegions, fitcell, right to left.. Αν ποτέ ενεργοποιηθούν στο pdf πρέπει μάλλον να το δούμε
 */
class PrintsPDFToText
{
    /*
    private $_page_height;
    private $_stiles;*/

    private $_page_width;

    private $_right_margin;
    private $_left_margin;
    private $_top_margin;
    private $_bottom_margin;

    private $_header_margin;
    private $_footer_margin;
    
    private $_print_header;
    private $_print_footer;

    private $_grammes;
    private $_max_print_lines_per_page;
    private $_cell_padding;
    private $_input_text_elements_array;
    private $_strings_array;
    private $_txt_path;


    public function __construct($document_configuration, $text_elements_array, $txt_path){
        /*
        $this->_page_height = $document_configuration['page_height'];
        $this->_stiles  = $document_configuration['stiles'];*/

        $this->_page_width    = $document_configuration['page_width'];
        $this->_cell_padding  = $document_configuration['cell_paddings'];

        $this->_print_header = $document_configuration['print_header'];
        $this->_print_footer = $document_configuration['print_footer'];        

        $this->_header_margin = $document_configuration['header_margin'];
        $this->_footer_margin = $document_configuration['footer_margin'];

        $this->_right_margin  = $document_configuration['right_margin'];
        $this->_left_margin   = $document_configuration['left_margin'];
        $this->_top_margin    = $document_configuration['top_margin'];
        $this->_bottom_margin = $document_configuration['bottom_margin'];

        if($this->_print_header==true){
            $this->_top_margin = $this->_header_margin;
        }

        if($this->_print_footer==true){
            $this->_bottom_margin = $this->_footer_margin;
        }

        $this->_grammes  = $document_configuration['grammes'];
        $this->_max_print_lines_per_page  = $this->_grammes -  $this->_top_margin -  $this->_bottom_margin;
        $this->_input_text_elements_array = $text_elements_array;

        $this->_txt_path = $txt_path;
    }

    private function create_strings_array()
    {
        foreach ($this->_input_text_elements_array as $num_of_page => $page_arr) {
            foreach ($page_arr as $num_of_line => $line_arr) {
                foreach ($line_arr as $text_element_arr) {
                    try {
                        $this->extract_to_texts($text_element_arr);
                    } catch (Exception $th) {
                        throw $th;
                    }
                }
            }
        }
    }

    public function print_to_file()
    {

        if (file_exists($this->_txt_path)) {
            unlink($this->_txt_path);
        }

        $this->create_strings_array();
        //var_dump($this->_strings_array);

        ksort($this->_strings_array);
        foreach ($this->_strings_array as $page => $page_strings) {
            
            ksort($page_strings);
            
            $last_printed_line = -$this->_top_margin - 1;
            foreach ($page_strings as $line => $line_strings) {

                //Εκτυπώνω κενή γραμμή μέχρι την γραμμή που θέλω να εκτυπώσω...
                //Δεν είναι απόλυτο αυτό το print γιατί παίζουν και float τιμές
                //αλλά δεν με πειράζει, το βλέπω στο περίπου
                // for ($i = ($last_printed_line + 1); $i < round((float)$line); $i++) {
                //     $this->write_line();
                // }
                for ($i=($last_printed_line + 1); $i<(float)$line; $i++) {
                    $this->write_line();
                }
                $line_text = "";
               
                ksort($line_strings);
                $last_printed_column = -$this->_left_margin - 1;
                foreach ($line_strings as $column_counter => $columns) { //Για όλα τα στοιχεία της γραμμής         

                    // echo "\n-------\n";
                    // echo $columns['0']['text'] . "\n";
                    // echo 'last_printed_column: ' . $last_printed_column . "\n";
                    // echo 'printing spaces: ' . ($column_counter - $last_printed_column) . "\n";

                    for ($i = 0; $i < $column_counter - 1 - $last_printed_column; $i++) {
                        $line_text .= " ";
                    }
                    $last_printed_column = $column_counter - 1;

                    // echo 'column_to_print: ' . $column_counter;
                    // echo "\n-------\n";

                    //var_dump($column_counter - $last_printed_column);
                    //echo $text_element;
                    foreach ($columns as $text_element) { //Όλα τα στοιχεία της στήλης ΤΑΔΕ. Μπορεί από λάθος να ξεκινάνε 2 στην ίδια στηλη
                        $text_element = $this->putpages($text_element, $page, count($this->_strings_array));
                        $line_text .= $text_element;
                        $last_printed_column = $last_printed_column + mb_strlen($text_element, 'utf8');
                    }
                }
                $this->write_line($line_text); //Print lines content
                $last_printed_line = $line;
            }
            //Εκτυπώνω κενή γραμμή μέχρι την _max_print_lines_per_page
            //Δεν είναι απόλυτο αυτό το print γιατί παίζουν και float τιμές
            //αλλά δεν με πειράζει, το βλέπω στο περίπου
            for ($i = ($last_printed_line + 1); $i < ($this->_max_print_lines_per_page + $this->_bottom_margin); $i++) {
                $this->write_line();
            }
            $this->change_page();
        }       

        //echo "<pre>". print_r($this->_strings_array,1) . "</pre>";
    }

    /**
     * @param element_arr: the input array 
     * It transforms the input element array to texts to be print in the txt 
     * If memo_array, it devides the text in smaller texts one for each line 
     * It computes the position to start if the string has a Middle or Left alignment
     */
    private function extract_to_texts($element_arr)
    {
        if (!is_array($element_arr) || !array_key_exists("returned_nl", $element_arr)) {
            throw new Exception("Malformed textElement");
        }
        $num_of_lines = $element_arr['returned_nl']; //Το πλήθος γραμμών που εκτυπώνει η έκφραση με αναδίπλωση

        if ($num_of_lines > 1) { //Έκφραση με αναδίπλωση
            $this->extract_to_texts_memo_array($element_arr);
        }
        if ($num_of_lines == 1) {
            $text = $element_arr['text'];
            $page = $element_arr['page_start'];
            $line = $element_arr['pegasus_grammi_start'];
            $pegasus_stili_start = $element_arr['pegasus_stili_start'];

            $this->insert_to_string_array($page, $line, $pegasus_stili_start, $text);
        }
    }

    private function extract_to_texts_memo_array($element_arr){
        

        if($element_arr['fname']=='peg_print_html_array'){
            //Convert HTML to Plain Text
            $html2TextConverter = new Html2Text($element_arr['text']);
			$element_arr['text'] = $html2TextConverter->getText();

            $special_char_replace_arr = array(
				"\n\t\t"	=>	"   ",
				"\t\t"		=>	"  ",
				"\n\n"		=>	"\n",
			);
			$element_arr['text'] = str_replace(array_keys($special_char_replace_arr), array_values($special_char_replace_arr), $element_arr['text']);
        }

        $page_start = $element_arr['page_start']; //Η πρώτη σελίδα όπου εκτυπώνεται η έκφραση με αναδίπλωση
        $page_end   = $element_arr['page_end']; //Η τελευταία σελίδα όπου εκτυπώνεται η έκφραση με αναδίπλωση
        //Η grammi_start όπως υπολογίζεται από την peg_get_position της PDFTCPDF, για αυτό παίζει και στο body
        $pegasus_grammi_start = $element_arr['pegasus_grammi_start'];
        //Η pegasus_stili_start όπως υπολογίζεται από την peg_get_position της PDFTCPDF, για αυτό παίζει και στο body
        $pegasus_stili_start = $element_arr['pegasus_stili_start'];
        $num_of_lines = $element_arr['returned_nl']; //Το πλήθος γραμμών που εκτυπώνει η έκφραση με αναδίπλωση. Αυτό επιστρέφεται από την TCPDF
        $text = $element_arr['text'];

        $re_spaces = '/[^\S\xa0]/'; //Αυτά είναι τα κενά όπως είναι δηλωμένα στην κλάση της TCPDF.


        $max_width_per_line = $element_arr["pegasus_width"]; //max width as set from col-col0, size      
        if($max_width_per_line <=0){ //Αν δεν έχει width επειδή δεν ΄χει συμπληρωμένο το εως στήλη - size, δίνω τα όρια της σελίδας οπως η MultiCell
            $max_width_per_line = $this->_page_width - $this->_right_margin;
        }
        
        //Only cellPadding in Pegasus forms... (το είδα από παράδειγμα ότι το margin είναι 0 - Αν το σετάρουμε μελλοντικά ή σε άλλη φόρμα - θα πρέπει αν το δω)    
        $max_width_per_line = $max_width_per_line - $this->_cell_padding["L"]  - $this->_cell_padding["R"];
        $letter_widths_arr  = $element_arr["letter_widths"];

        //Split string by a regular expression. : //u: Unicode 
        $chars = TCPDF_STATIC::pregSplit('//', 'u', $text, -1, PREG_SPLIT_NO_EMPTY);
        //Converts UTF-8 character to integer value - Καλείται η TCPDF_FONTS για κάθε στοιχείο του πίνακα $chars
        $letters = array_map(array('TCPDF_FONTS', 'uniord'), $chars);
        $letters_count = count($letters);

        $lines = array();

        $i = 0;
        $j = $pegasus_grammi_start;
        $num_of_lines_counter = 0;
        $current_page = $page_start;
        //Αφαιρετικά, ακολουθώ τα βήματα την write της TCPDF
        /**
         * Σε ένα while, βλέπω 1-1 τους χαρακτήρες και υπολογίζω αν χωράνε στην γραμμή μου. 
         * Αν δεν χωράνε αλλάζω γραμμη
         * Αν βρω τον \n χαρακτήρα αλλάζω γραμμή
         * Προσπαθώ να μην κόβω λέξεις.
         * */

         $debug_expr = false;
        // if(strpos( $text, "Καταστήματος Γραμμή 2") !== false){
        //     $debug_expr = true;
        //     var_dump($element_arr);
        // }

        //TODO:Ίσως θα πρέπει να ελέγξω ότι το trim του string να μην ειναι κενο...
        while ($i < $letters_count) {

            //echo "num_of_lines: " . $num_of_lines . " num_of_lines_counter: " . $num_of_lines_counter .  "\n";
            if ($num_of_lines - 1 < $num_of_lines_counter) {
                break;
            }
            if (($page_end > $page_start) && ($this->_max_print_lines_per_page < $j)) {
                $j = 0; //TODO:Να δω αν πρέπει να αρχικοποιηθεί στο 0 ή στο 1
                $current_page++;
            }


            if (!array_key_exists($current_page,  $lines)) {
                $lines[$current_page] = array();
            }

            //echo $j."\n";
            $width_rest = $max_width_per_line;
            $prevChar = -1;
            $last_word_end = -1;

            while (preg_match($re_spaces, TCPDF_FONTS::unichr($letters[$i], true))) { //Τρώω όλα τα κενα 
                $i++;
                if ($i == $letters_count) {
                    break;
                }
            }

            $start_new_string_from = $i; //Που τελείωσε η προηγούμενη επανάληψή μου
            while ($width_rest > 0 && ($i < $letters_count)) { //Characters of line

                if (preg_match($re_spaces, TCPDF_FONTS::unichr($letters[$i], true))) {
                    $last_word_end =  $prevChar;
                }
                //Keep me for debug
                //echo "\ni:$i".TCPDF_FONTS::unichr($letters[$i], true) ." - ".$letters[$i]." letter_width: ".$letter_widths_arr[$i]." - ".$width_rest;
                $width_rest -= $letter_widths_arr[$i];
                if ($width_rest < 0) {
                    break;
                }
                if ($letters[$i] == 10) { //\n
                    $i++;
                    break;
                }
                $prevChar =  $i;
                $i++;
            }
            if (
                $i > 0 &&
                $i != $letters_count &&
                $last_word_end > -1 &&
                !preg_match($re_spaces, TCPDF_FONTS::unichr($letters[$i], true)) &&
                !preg_match($re_spaces, TCPDF_FONTS::unichr($letters[$i - 1], true)) &&
                $letters[$i] != 10 &&  $letters[$i - 1] != 10
            ) { //Χωρίστηκε η λέξη στην αλλαγή γραμμης


                //Αν η λέξη δεν χωράει δεν θα πρέπει να αλλάξω αλλα θα πρέπει να εκτυπωθεί η λέξη μιση - μιση
                //Ελέγχω την μεταβλητή word_bigger_than_line
                $k = $last_word_end + 2; //Πηδάω το κενό και ξεκινάω από το πρώτο γράμμα της λέξης
                if ($k >= $letters_count) { //Δεν πρέπει να μπορεί να μπει ποτέ εδω
                    continue;
                }
                $word_bigger_than_line = false;
                $words_width = 0;
                while (!preg_match($re_spaces, TCPDF_FONTS::unichr($letters[$k], true))) {

                    if ($letters[$k] == 10) { //\n 
                        break;
                    }
                    $words_width += $letter_widths_arr[$k];
                    if ($words_width > $max_width_per_line) {
                        $word_bigger_than_line = true;
                        break;
                    }
                    $k++;
                    if ($k == $letters_count) { //Η τελευταία λέξη
                        break;
                    }
                }

                if (!$word_bigger_than_line) {
                    $i = $last_word_end + 1;
                }
            }
            $final_txt = peg_substr($text, $start_new_string_from, $i - $start_new_string_from, 'UTF-8');
            $final_txt = str_replace("\n", "", $final_txt);

            //$pegasus_stili_start: Θα πρέπει να την φτιάξω ανάλογα με το απο που θα ξεκινησει - αν ειναι δεξιά στοιχιση κοκ, ομοίως και την stili_end
            //$lines[$current_page][$j] = array('stili_start' => $pegasus_stili_start,'stili_start' => $pegasus_stili_start, 'text' => $final_txt);
            $j_formatted =  number_format((float)$j, 2, '.', '');
            $lines[$current_page][$j_formatted] = array('stili_start' => $pegasus_stili_start,'stili_start' => $pegasus_stili_start, 'text' => $final_txt);
            $j++;
            $num_of_lines_counter++;
        }

        if($debug_expr == 1){
            var_dump($lines);
        }

        foreach ($lines as $page => $lines_arr) {
            if (!array_key_exists($page,  $this->_strings_array)) {
                $this->_strings_array[$page] = array();
            }
            foreach ($lines_arr as $line => $value) {
                $this->insert_to_string_array($page, $line, $value['stili_start'], $value['text']);
            }
        }

        //echo "<pre>". print_r($lines,1) . "</pre>";
    }

    private function insert_to_string_array($page, $line, $stili_start, $text)
    {
        //SOS: Τα array keys μου πρέπει να είναι string για να μπορώ 
        //να παίζω με float values, για αυτό έχω βάλει το "0"
        //Τα indexes πρέπει να εχουν σωστο format για να παίξει σωστα το ksort πάνω στα strings
        $line_formatted =  number_format((float)$line, 2, '.', '');
        $pegasus_stili_start_formatted = number_format((float)$stili_start, 2, '.', '');

        $line_formatted = pegasus_leading_zeros($line_formatted, 10);
        $pegasus_stili_start_formatted = pegasus_leading_zeros($pegasus_stili_start_formatted, 10);


        if (!array_key_exists($line_formatted,  $this->_strings_array[$page])) {
            $this->_strings_array[$page][$line_formatted] = array();
        }
        if (!array_key_exists($pegasus_stili_start_formatted,  $this->_strings_array[$page][$line_formatted])) {
            $this->_strings_array[$page][$line_formatted][$pegasus_stili_start_formatted] = array();
        }
        if(!is_array($this->_strings_array[$page][$line_formatted][$pegasus_stili_start_formatted])){
            $this->_strings_array[$page][$line_formatted][$pegasus_stili_start_formatted] = array();
        }
        $this->_strings_array[$page][$line_formatted][$pegasus_stili_start_formatted][] = $text;
    }

    private function write_line($output_string = "")
    {
        $fp = fopen($this->_txt_path, "a+b");


        $output_string = preg_replace('/\xC2\xA0/', ' ', $output_string); //it is an illegal character for the EAFDSS

        if ($output_string != "") {
            $isoConvertedTxt = iconv(mb_detect_encoding($output_string), "iso-8859-7//IGNORE", $output_string);
        } else {
            $isoConvertedTxt = "";
        }

        // $chars = TCPDF_STATIC::pregSplit('//', 'u', $isoConvertedTxt, -1, PREG_SPLIT_NO_EMPTY);
        // $letters = array_map(array('TCPDF_FONTS', 'uniord'), $chars);
        // var_dump($letters);
        
        
        fwrite($fp, $isoConvertedTxt . chr(13) . chr(10));


        fclose($fp);
    }

    //TODO: Verify
    private function change_page()
    {
        $fp = fopen($this->_txt_path, "a+b");
        fwrite($fp, chr(12));
        fclose($fp);
    }

    /**
     * Replace page number aliases with number.
     */
    private function putpages($text, $page, $pages_count){
        //echo "<pre>->". $page ."  /  ". $pages_count."</br></pre>";
        $text = str_replace('{{:pnp:}}', $page, $text);
        $text = str_replace('{{:ptp:}}', $pages_count, $text);

        return $text;
    }
}
