<?php 
	
	require_once('../prints00/header.php');
	
	/**
	 * Η συνάρτηση αυτή κάνει append ένα Child sto element
	 * σε συνδιασμό του  $datarow
	 * @param DOMDocument $dom
	 * @param DOMElement $element
	 * @param array $structData array(array('fldtype', 'xmltag'))
	 * @param array $data array($structData['xmltag'])
	 */
	function pegasus_xml_dom_appendChild(&$dom,&$element, &$structData, &$datarow){
		foreach ($structData as $data){
			if($data['fldtype']=='L' || $data['fldtype']=='N'){
				if($data['xmltag']=='nr01'){
					$element->setAttribute('id', $datarow[$data['xmltag']] );
				}
				$datatmp = $dom->createElement($data['xmltag'],$datarow[$data['xmltag']]);
			}else if($data['fldtype']=='C' || $data['fldtype']=='D' ||  $data['fldtype']=='M'){
				$datatmp = $dom->createElement($data['xmltag']);
				$newnode = $dom->createCDATASection($datarow[$data['xmltag']]);
				$datatmp->appendChild($newnode);
			}else{
		
				continue;
			}
			if($datatmp instanceof DOMNode)
				$element->appendChild($datatmp);
		}
	}
	//MK ths formas
	$p85nr01	=	$_REQUEST['mnr01'];
	
	$p85mainstyle = '';//Thelw to main style gia na to kanw export
	$p85Structure = array();
	$p86Structure = array();
	$p87Structure = array();
	
	$ret_data = array();
	$ret_data['ok']   = 1;
	$ret_data['msg']  = '';
	$ret_data['data'] =  $p85nr01;

	//Start query to get fields (p85_d)
	$queryP51_p85_d = 	" select ". 
						" p51.desc05 as xmltag, p51.desc16 as fldtype " .
						" from p51 ".
						" join p60 on p60.p00 = p51.desc16 and isdbfld=1 ". 
						" where p51.p02='p85_d' ".
						" order by desc06 ";

	$resP51_p85_d = pegasus_query($queryP51_p85_d);
	while ($row=pegasus_fetch_assoc($resP51_p85_d)) {
		$p85Structure[] = $row;
	}

	
	//Start query to get fields (p87_d)
	$queryP51_p87_d = 	" select ". 
						" p51.desc05 as xmltag, p51.desc16 as fldtype " .
						" from p51 ".
						" join p60 on p60.p00 = p51.desc16 and isdbfld=1 ". 
						" where p02='p87_d'  ".
						" order by desc06 ";

	$resP51_p87_d = pegasus_query($queryP51_p87_d);
	while ($row=pegasus_fetch_assoc($resP51_p87_d)) {
		$p87Structure[] = $row;
	}
	
	
	//Start query to get fields (p86_d)
	$queryP51_p86_d = 	" select ". 
						" p51.desc05 as xmltag, p51.desc16 as fldtype " .
						" from p51 ".
						" join p60 on p60.p00 = p51.desc16 and isdbfld=1 ". 
						" where p02='p86_d'  ".
						" order by desc06 ";

	$resP51_p86_d = pegasus_query($queryP51_p86_d);
	while ($row=pegasus_fetch_assoc($resP51_p86_d)) {
		$p86Structure[] = $row;
	}


	//Start query to get fields (prints_02_d)
	$queryP51_prints_02_d =	" select ". 
							" p51.desc05 as xmltag, p51.desc16 as fldtype " .
							" from p51 ".
							" join p60 on p60.p00 = p51.desc16 and isdbfld=1 ". 
							" where p02='prints_02_d'  ".
							" order by desc06 ";

	$resP51_prints_02_d = pegasus_query($queryP51_prints_02_d);
	while ($row=pegasus_fetch_assoc($resP51_prints_02_d)) {
		$prints_02Structure[] = $row;
	}
	//Add Image Base64 Attribute
	$prints_02Structure[] = array('xmltag'=>'base64', 'fldtype'=>'C');

	//END Query To get Fields


	//Load data tmp
	$xmlToWrite = new DomDocument('1.0', 'UTF-8');
	$xmlToWrite->formatOutput = true;
	
	//Set The admin verion
	//$p85->setAttribute('version', "addAdminVerison");
	
	//Fill with p85 data (main form)
	$queryP85	= " select * from p85 where nr01=?;";
	$resP85		= pegasus_query($queryP85, array($p85nr01));

	if(pegasus_num_rows($resP85)!=1){
		$ret_data['ok']  = 0;
		$ret_data['msg'] = $_SESSION['peg_dic_prints_export_p85_not_found'];
		echo json_encode($ret_data);
		require_once('../core00/footer.php');
		return ;
	}

	$p85 = $xmlToWrite->createElement('p85');
	while ($p85row = pegasus_fetch_assoc($resP85)) {
		pegasus_xml_dom_appendChild($xmlToWrite, $p85, $p85Structure, $p85row);
		$p85mainstyle	= $p85row['main_style'];
	}

	//Fill with p86 data (fields)
	$queryP86	= " select * from p86 where p85=?;";
	$resP86		= pegasus_query($queryP86, array($p85nr01));
	if(pegasus_num_rows($resP86)>0){
		$p86 = $xmlToWrite->createElement('p86');
		while ($p86row = pegasus_fetch_assoc($resP86)) {
			$p86_records = $xmlToWrite->createElement('record');
			pegasus_xml_dom_appendChild($xmlToWrite, $p86_records, $p86Structure, $p86row);
			$p86->appendChild($p86_records);
		}
		$p85->appendChild($p86);
	}
	
	//Fill with p87 data (style)
	$queryP87 = " select * ".
				" from p87 ". 
				" where p87.p85=:p85 or p87.nr01 in (select p86.p87 from p86 where p86.p87!='' and p86.p85=:p85) ";
	if(!empty($p85mainstyle)){
		$queryP87 .= "or p87.nr01=:nr01 ";
	}
	$queryP87 .= "group by p87.nr01";

	$values_arr = array('p85' => $p85nr01, 'nr01' => $p85mainstyle);
	$resP87     = pegasus_query($queryP87, $values_arr);

	if(pegasus_num_rows($resP87)>0){
		$p87=$xmlToWrite->createElement('p87');
		while ($p87row=pegasus_fetch_assoc($resP87)) {
			$p87_records = $xmlToWrite->createElement('record');
			pegasus_xml_dom_appendChild($xmlToWrite, $p87_records, $p87Structure, $p87row);
			$p87->appendChild($p87_records);
		}
		$p85->appendChild($p87);
	}


	//Fill with prints_02 data (form images)
	$queryPrints_02	= " select * from prints_02 where p85=?;";
	$resPrints_02	= pegasus_query($queryPrints_02, array($p85nr01));
	if(pegasus_num_rows($resPrints_02)>0){
		$prints_02 = $xmlToWrite->createElement('prints_02');
		while ($prints_02row = pegasus_fetch_assoc($resPrints_02)) {
			//Add Image Base64 Attribute
			$fpath = prints_get_forms_image_fpath($prints_02row['nr01']);
			$img   = file_get_contents($fpath);
			$prints_02row['base64'] = base64_encode($img);
			
			$prints_02_records = $xmlToWrite->createElement('record');
			pegasus_xml_dom_appendChild($xmlToWrite, $prints_02_records, $prints_02Structure, $prints_02row);
			$prints_02->appendChild($prints_02_records);
		}
		$p85->appendChild($prints_02);
	}
	
	$xmlToWrite->appendChild($p85);

	//Set Global Var
	if($ret_data['ok']==1){
		$var_value = $xmlToWrite->saveXML();
		pegasusSetGlobalVar("exportXMLP85_$p85nr01" , $var_value);
	
	}
	
	echo json_encode($ret_data);
	require_once('../core00/footer.php');
	return ;
?>