<?php

require('../query00/classes.php');


function query_q10_d901_make_grid_query_replace_q13($q10_nr01, $q13_values = array()){
  
    $query = query_make_select($q10_nr01);
    $query_arr = query_replace_q13_from_array($q10_nr01, $query, $q13_values);
    $query_arr['sql'] = trim($query_arr['sql']);
	if (peg_substr($query_arr['sql'], -1, 1) == ';') {
		$query_arr['sql']  = peg_substr($query_arr['sql'], 0, -1);
    }
    return $query_arr;
}


/**
 * - General function
 * - PDF Functions
 * - Start Screen functions
 */
//XXX General function
function query_getExtraFieldsQuery($module = '##module##', $_d = '##_d##', $isview = '##isview##')
{
    $query = peg_read_file('../query_sql/extra_fields.sql');
    $query  = str_replace(
        array(
            "##dic_query_remdate_gr##", "##dic_query_remdate_en##",
            "##dic_query_remtime_gr##", "##dic_query_remtime_en##",
            "##dic_query_remuser_gr##", "##dic_query_remuser_en##",
            "##dic_query_remfdate_gr##", "##dic_query_remfdate_en##",
            "##dic_query_remftime_gr##", "##dic_query_remftime_en##",
            "##dic_query_remfuser_gr##", "##dic_query_remfuser_en##",
            "##dic_query_remguc_gr##", "##dic_query_remguc_en##",
            '##module##', '##_d##', '##isview##'
        ),
        array(
            $_SESSION['peg_dic_query_remdate_gr'],  $_SESSION['peg_dic_query_remdate_en'],
            $_SESSION['peg_dic_query_remtime_gr'], $_SESSION['peg_dic_query_remtime_en'],
            $_SESSION['peg_dic_query_remuser_gr'], $_SESSION['peg_dic_query_remuser_en'],
            $_SESSION['peg_dic_query_remfdate_gr'], $_SESSION['peg_dic_query_remfdate_en'],
            $_SESSION['peg_dic_query_remftime_gr'], $_SESSION['peg_dic_query_remftime_en'],
            $_SESSION['peg_dic_query_remfuser_gr'], $_SESSION['peg_dic_query_remfuser_en'],
            $_SESSION['peg_dic_query_remguc_gr'], $_SESSION['peg_dic_query_remguc_en'],
            $module, $_d, $isview
        ),
        $query
    );
    return $query;
}

function query_generatePReportHtml($q10nr01)
{

    require_once '../query_classes/Query_HTMLTemplate.php';

    $columns = array();
    //     $fields=array();
    $q12_select = "select * from q12 where p00=? and  p023=0 order by p05;";
    $q12_res = pegasus_query($q12_select, array($q10nr01));
    while ($q12 = pegasus_fetch_assoc($q12_res)) {
        if ($q12['p023'] == 1) {
            //Ean einai krifo to pedio
            continue;
        }
        $peg_tmp_q12title = $q12['p01'];
        if ($_SESSION['lang'] == 'EN' and !empty($q12['ep01'])) {
            $peg_tmp_q12title = $q12['ep01'];
        }
        $columns[$q12['p03']] = array(
            'name' => $q12['p03'],
            'type' => $q12['p06'],
            'title' => $peg_tmp_q12title,
            'p022' => $q12['p022'],
            'p07' => $q12['p07'],
            'p08' => $q12['p08']
        );
    }

    $query = query_make_select($q10nr01);
    $query = query_replace_q13_from_array($q10nr01, $query, query_q13_getValuesFromRequest($q10nr01));
    $htmlCode = new Query_HTMLTemplate();

    return $htmlCode->printReportToHtml($q10nr01, $columns, $query);
}


/** Επιστρέφει τα δεδομένα της π-Αναφοράς σε excel
 * @param int $q10nr01 , Ο κωδικός της π-Αναφοράς
 * @param string $_d , (Χρησιμοποιείται για το export π-Αναφοράς)
 * @param string $container_id ,(Χρησιμοποιείται για το export π-Αναφοράς)
 * @param array q13_values_arr Είναι ο πίνακας με τις παραμέτρους
 * @param isGroupedTab: Η παράμετρος αυτή δείχνει αν είμαι σε tab με grouped αποτελέσματα με βάση την καινούρια λογική όπου κάθε report έχει το δικό του _d
 * @return \PhpOffice\PhpSpreadsheet\Spreadsheet , Τα δεδομένα της π-Αναφοράς σε excel
 */
function query_getPReportExcelData($q10nr01, $_d, $container_id, $q13_values_arr, $isGroupedTab = false)
{
    if(file_exists('../query_libs/vendor/autoload.php')){
        require_once '../query_libs/vendor/autoload.php';
    }

    pegasus_mysql_use("select * from q10 where nr01 = ?", $q10Ar, array($q10nr01));
    if (empty($q10Ar['nr01'])) {
        die('Undefined Report');
    }

    $title = $q10Ar['p01'];
    $desc =  $q10Ar['p32'];
    if ($_SESSION['lang'] == 'EN') {
        $title = $q10Ar['ep01'];
        $desc =  $q10Ar['ep32'];
    }

    $fields = array();
    $fields_arr = array();
    $query = '';

    if ( ($_d == 'q10_d902') || $isGroupedTab) {
        $retAr = query_q10_d902_grid01_store($q10Ar['nr01'], $container_id, $q13_values_arr);

        foreach ($retAr[0] as $value) {
            array_push($fields, $value['name']);
            $fields_arr[$value['name']] = $value;
        }
        $query_arr = pegasusGetGlobalVar($container_id . '_q10_d902_grid_query');
    } else {
        $q12_select = "select * from q12 where p00=? and p023=0 order by p05;";
        $q12_res = pegasus_query($q12_select, array($q10nr01));
        while ($q12 = pegasus_fetch_assoc($q12_res)) {
            array_push($fields,  $q12["p03"]);
            $fields_arr[$q12["p03"]] = query_makeColumn($q12);
        }
        $query = query_make_select($q10nr01);
        $query_arr = query_replace_q13_from_array($q10nr01, $query, $q13_values_arr);
    }
    $q10_p34 = pegasus_mysql_printfld('q10','p34','nr01=:q10nr01',array('q10nr01'=>$q10nr01));
    if(!empty($q10_p34)){
        pegasus_query($q10_p34);
    }
    query_makeQuery00ArrOfReport_replace_q13($q10_nr01, $q13_values_arr, 1,$container_id );

    $body_res = pegasus_query($query_arr['sql'], $query_arr['sqlParams']);

    
    $q10_p35 = pegasus_mysql_printfld('q10','p35','nr01=:q10nr01',array('q10nr01'=>$q10nr01));
    if(!empty($q10_p35)){
        pegasus_query($q10_p35);
    }
    query_makeQueryAfterArrOfReport_replace_q13($q10_nr01, $q13_values_arr, 1,$container_id );

    $xml = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
    $xml->getProperties()->setCreator("Pegasus Web App")
        ->setLastModifiedBy(pegasusSessionGetVar('username'))
        ->setTitle($title)
        ->setDescription($desc);
    $xml->setActiveSheetIndex(0);
    $xml->getActiveSheet()->setTitle('Pegasus');

    list($startColumn, $startRow) = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::coordinateFromString("A1");

    $currentColumn = $startColumn;
    foreach ($fields_arr as $q12p03 => $q12Rec) {
        $fieldDesc = $q12Rec['header'];
        $xml->getActiveSheet()->setTitle('Pegasus')->getCell($currentColumn . $startRow)->setValueExplicit((string)  $fieldDesc, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
        $currentColumn++;
    }
    ++$startRow;
    $currentColumn = $startColumn;
    foreach ($fields_arr as $q12p03 => $q12Rec) {
        $fieldDesc = $q12Rec['name'];
        $xml->getActiveSheet()->setTitle('Pegasus')->getCell($currentColumn . $startRow)->setValueExplicit((string)  $fieldDesc, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
        $currentColumn++;
    }
    ++$startRow;

    while ($body = pegasus_fetch_assoc($body_res)) {
        //echo '<pre>'. print_r($body, 1),'</pre>';
        $currentColumn = $startColumn;
        foreach ($fields as $val) {
            $j++;
            $value = $body[$val];


            if ($fields_arr[$val]['xtype'] == 'pegasusNumberColumn') {
                $objWorksheet = $xml->getActiveSheet()->getCell($currentColumn . $startRow)->setValueExplicit($value, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_NUMERIC);
            } elseif ($fields_arr[$val]['xtype'] == 'pegasusBooleanColumn') {
                $objWorksheet = $xml->getActiveSheet()->getCell($currentColumn . $startRow)->setValueExplicit($value, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_BOOL);
            } elseif ($fields_arr[$val]['xtype'] == 'pegasusDateColumn') {
                $objWorksheet = $xml->getActiveSheet()->getCell($currentColumn . $startRow)->setValueExplicit($value, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING2);
                $xml->getActiveSheet()->getStyle($currentColumn . $startRow)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDD);
            } else {
                //memo cha, binary
                //  M, C  X 
                $objWorksheet = $xml->getActiveSheet()->getCell($currentColumn . $startRow)->setValueExplicit($value, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
            }

            ++$currentColumn;
        }
        ++$startRow;
    }

    $currentColumn = $startColumn;
    foreach ($fields as $val) {
        if ($fields_arr[$val]['summaryType'] == 'sum') {
            $objWorksheet = $xml->getActiveSheet()->getCell($currentColumn . $startRow)->setValue('=SUM(' . $currentColumn . '2:' . $currentColumn . ($startRow - 1) . ')');
        }
        $xml->getActiveSheet()->getColumnDimension($currentColumn)->setAutoSize(true);
        ++$currentColumn;
    }
    return $xml;
}

function query_generatePReportExcel($q10nr01)
{
    $xml = query_getPReportExcelData($q10nr01,'','',query_q13_getValuesFromRequest($q10nr01));
    $objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($xml, 'Xls');
    $out = '../../tmp/Report_' . $q10nr01 . '.xls';
    $objWriter->save($out);
    return $out;
}

function query_makeGroupedColumnTitle($q12, $title)
{
    if ($q12['p06'] == 'D') {
        return peg_dateToStr($title, $_SESSION['cor000_dt_format']);
    } elseif ($q12['p06'] == 'L') {
        if ($title == '1') {
            return  $_SESSION['peg_dic_core_yes'];
        } else {
            return  $_SESSION['peg_dic_core_no'];
        }
    } elseif ($q12['p06'] == 'N') {
        return number_format($title, $q12['p08'], $_SESSION['cor000_decimal_char'], '');
    }
    return $title;
}

function query_makeFields($q12)
{
    $tax = -1;

    if ($q12["p023"] == 0) {
        $tax = $q12["p05"];
        $tax_mob = $q12["p05"];
    }

    if (strtoupper($q12['p06']) == 'D') {
        return array('name' => $q12['p03'], 'type' =>  'date', 'xtype' => 'pegasusColumn',  'tax' => $tax , 'tax_mob'=>$tax_mob);
    } else if (strtoupper($q12['p06']) != 'N' and strtoupper($q12['p06']) != 'L') {
        return  array('name' => $q12['p03'], 'type' =>  'string', 'xtype' => 'pegasusColumn',  'tax' => $tax, 'tax_mob'=>$tax_mob);
    } else {
        //$grid_array .= "{name:'".$q12['p03']."', type: 'number' }";
        return  array('name' => $q12['p03'], 'type' =>  'number', 'xtype' => 'pegasusColumn',  'tax' => $tax, 'tax_mob'=>$tax_mob);
    }
}

function query_makeFieldsOfReport($nr01)
{
    //Φέρνω και τα κρυφά πεδία. Στο παλιό admin , δεν τα έφερνα στο grid_fields του q10_d901
    $query_q12 = 'select * from q12 where p00=:nr01 order by p05;'; //Όλα τα πεδία της π-Αναφοράς
    $res_q12 = pegasus_query($query_q12, array('nr01' => $nr01));
    $q10_d901_grid_fields = array();
    while ($q12 = pegasus_fetch($res_q12, PEG_FETCH_ASSOC)) {
        $q10_d901_grid_fields[] = query_makeFields($q12);
    }
    return $q10_d901_grid_fields;
}

function query_makeTitleArrayOfReport($nr01, $name = 'grid01')
{
    //Φέρνω και τα κρυφά πεδία. Στο παλιό admin , δεν τα έφερνα στο title_array του q10_d901
    $query_q12 = 'select * from q12 where p00=:nr01 order by p05;';
    $res_q12 = pegasus_query($query_q12, array('nr01' => $nr01));
    $title_array = array();
    while ($q12 = pegasus_fetch($res_q12, PEG_FETCH_ASSOC)) {
        $title_array[]  = query_makeColumn($q12, $name);
    }
    return $title_array;
}

/**
 * @deprecated
 */
function query_makeQuery00OfReport($nr01)
{
    $q13_values_arr = query_q13_getValuesFromRequest($nr01);  
    return query_makeQuery00OfReport_replace_q13($nr01, $q13_values_arr);
}

/**
 * @deprecated @see query_makeQuery00ArrOfReport_replace_q13
 * @param mixed $nr01 
 * @param mixed $q13_values_arr 
 * @return string 
 */
function query_makeQuery00OfReport_replace_q13($nr01, $q13_values_arr){

    $query00_str = pegasus_mysql_printfld('q10', 'p34', 'nr01=:nr01', array('nr01' => $nr01));
    $ret = '';
    if (!empty($query00_str)) {
        $query00 = explode(';', $query00_str);
        for ($i = 0; $i < count($query00); $i++) {
            if (!empty($ret)) {
                $ret .= " /*peg_end*/ ";
            }
            if(trim($query00[$i]) != ''){
                $ret .= trim($query00[$i]) . ";";
            }
        }
    }
    $query_q13 = 'select * from q13 where p00=:q10_nr01 order by p05;';
    $res_q13 = pegasus_query($query_q13, array('q10_nr01' => $nr01));
    while ($q13 = pegasus_fetch_assoc($res_q13)) {
        $ret = str_replace('{' . $q13['p02'] . '}' , pegasus_mysql_real_escape_string($q13_values_arr[$q13['p02']]) , $ret);  
    }

    return $ret;
}

/**
 *  
 * @param arra() $q12
 * @return array()
 */
function query_makeColumn($q12, $peg_grid_name = 'grid01')
{
    $peg_tmp_q12title = $q12['p01'];
    if ($_SESSION['lang'] == 'EN' and !empty($q12['ep01'])) {
        $peg_tmp_q12title = $q12['ep01'];
    }
    $name = $q12['p03'];
    if (!empty($q12['dataindex'])) {
        $name = $q12['dataindex'];
    }

    $tax = -1;

    if ($q12["p023"] == 0) {
        $tax = $q12["p05"];
        $tax_mob = $q12["p05"];
    }
    if (strtoupper($q12['p06']) == 'L') {
        return array(
            'peg_grid_name' => $peg_grid_name,
            'header' => $peg_tmp_q12title,
            'name' => $name,
            'locked' => ($q12['lockedcolumn']) ? true : false,
            'xtype' => 'pegasusBooleanColumn',
            'align' => 'center',
            'tax' => $tax,
            'tax_mob' => $tax_mob,
            'length' => $q12['p07']
        );
    } elseif (strtoupper($q12['p06']) == 'D') {

        return array(
            'peg_grid_name' => $peg_grid_name,
            'header' => $peg_tmp_q12title,
            'name' => $name,
            'locked' => ($q12['lockedcolumn']) ? true : false,
            'xtype' => 'pegasusDateColumn',
            'align' => 'center',
            'tax' => $tax,
            'tax_mob' => $tax_mob,
            'length' => $q12['p07']
        );
    } elseif (strtoupper($q12['p06']) == 'N') {

        $tmp_title_arrayrec = array(
            'peg_grid_name' => $peg_grid_name,
            'xtype' => 'pegasusNumberColumn',
            'header' => $peg_tmp_q12title,
            'name' => $name,
            'locked' => ($q12['lockedcolumn']) ? true : false,
            'format' =>   0,
            'tax' => $tax,
            'tax_mob' => $tax_mob,
            'length' => $q12['p07']
        );
        if ($q12['p08'] > 0) {
            $tmp_title_arrayrec['format'] =  '0.' . str_repeat(0, $q12['p08']);
            $tmp_title_arrayrec['decimalPrecision']  = $q12['p08'];
        }


        if ($q12['p022'] == 1) {
            $tmp_title_arrayrec['summaryType'] = 'sum';
        }
        return $tmp_title_arrayrec;
    } else {
        return array(
            'peg_grid_name' => $peg_grid_name,
            'header' => $peg_tmp_q12title,
            'name' => $name,
            'locked' => ($q12['lockedcolumn']) ? true : false,
            'flex' => 1,
            'xtype' => 'pegasusTextBoxColumn',
            'align' => 'left',
            'tax' => $tax,
            'tax_mob' => $tax_mob,
            'length' => $q12['p07']
        );
    }
}
function peg_query_generateProfilePermissionWhere()
{
    $profile = 0;
    if ($GLOBALS['userCookie'] instanceof Peg002_Cookie) {
        $profile = $GLOBALS['userCookie']->getUser_profile();
    }

    if (empty($profile)) {
        $profile = $_SESSION['user_profile'];
    }

    $en_q10_perm = pegasus_mysql_printfld(
        'p95',
        'en_q10_perm',
        'nr01=:nr01',
        array('nr01' =>  $profile)
    );
    if (empty($en_q10_perm)) {
        return "";
    }

    $where = " p95q10.p95=$profile && p95q10.q10=:p95q10 ";
    return $where;
}
/**
 * Check If user profile has permission for p-Report
 * @param number $q10nr01 The id of report
 * @return bool
 */
function peg_query_canProfileRead($q10nr01 = 0, $profile = 0)
{
    if ($profile == 0 && $GLOBALS['userCookie'] instanceof Peg002_Cookie) {
        $profile = $GLOBALS['userCookie']->getUser_profile();
    }

    if (!(pegasus_mysql_printfld('q10', 'nr01', 'nr01=?', array($q10nr01)) > 0)) {
        return false;
    }

    if (empty($profile)) {
        $profile = $_SESSION['user_profile'];
    }

    $en_q10_perm = pegasus_mysql_printfld(
        'p95',
        'en_q10_perm',
        'nr01=:nr01',
        array('nr01' =>  $profile)
    );
    if (empty($en_q10_perm)) {
        return true;
    }

    if (empty($q10nr01)) {
        return false;
    }
    $en = pegasus_mysql_printfld(
        'p95q10',
        'en',
        'p95=:nr01 && q10=:q10nr01',
        array(
            'nr01' =>  $profile,
            'q10nr01' =>  $q10nr01
        )
    );
    return ($en == 1) ? true : false;
}
/**
 * Check If all p-Report tables exist
 * @param number $q10nr01 The id of report
 * @return bool
 */
function peg_query_allReportTablesExist($q10nr01)
{
    if (!(pegasus_mysql_printfld('q10', 'nr01', 'nr01=?', array($q10nr01)) > 0)) {
        return false;
    }
    $peg_tmp_tablesOfQ10Res = pegasus_query(" select p01 from q11 where q11.p00 = ? ", array($q10nr01));

    while ($peg_tmp_row = pegasus_fetch($peg_tmp_tablesOfQ10Res, PEG_FETCH_ASSOC)) {
        if (!(pegasus_mysql_table_exists($peg_tmp_row['p01']))) {
            return false;
        }
    }
    return true;
}
/**
 * This function returns if a field is readonly
 * @param array $data  the data array of the screen
 * @param string $_d current _d display
 * @param string $fieldName the of dield
 * @return (0, 1, 2)
 */
function peg_query_q10_d_fieldReadOnly(&$data, $_d, $fieldName)
{
    if (empty($_d)) {
        return 0;
    }
    if (empty($fieldName)) {
        return 0;
    }

    return  $data['standard_readonly'];
}

/**
 * This function returns an array of columns, fields and columnsSums of grouped grid.
 * Also sets the global var $container_id . '_q10_d902_grid_query'  and the  $container_id . '_q10_d902_grid_fields'
 * @param number $q10nr01 The id of the query
 * @param string $container_id // The container ID
 * @param array q13_values_arr
 * @return array(
       $q10_d902_grid_title,
       $q10_d902_grid_fields,
       $columnsSums
  )
 * 
 */
function query_q10_d902_grid01_store($q10nr01, $container_id, $q13_values_arr)
{
    if (empty($q10nr01)) {
        return array();
    }
    if (empty($container_id)) {
        return array();
    }
    $q10Ar = null;
    pegasus_mysql_use(" select * from q10 where nr01 = :nr01 ", $q10Ar, array('nr01' => $q10nr01));
    if (empty($q10Ar['valuefield']) || empty($q10Ar['titlefield'])) {
        return array();
    }

    list($q10_d902_grid_title, $q10_d902_grid_fields, $columnsSums) = query_q10_d902_find_titles_fields_sums($q10nr01, 'grid01', $q13_values_arr);

    $q10_d902_grid_query = query_q10_d902_find_query($q10nr01, $q10_d902_grid_fields);
    $q10_d902_grid_query = query_replace_q13_from_array($q10nr01, $q10_d902_grid_query, $q13_values_arr);
    
    pegasusSetGlobalVar(
        $container_id . '_q10_d902_grid_fields',
        $q10_d902_grid_fields
    );
    pegasusSetGlobalVar(
        $container_id . '_q10_d902_grid_query',
        $q10_d902_grid_query
    );
    pegasusSetGlobalVar(
        $container_id . '_q10_d902_grid_titles',
        $q10_d902_grid_title
    );

    //peg_write_file('../../tmp/grouped_query.sql', pegasus_replace_values_in_sql($q10_d902_grid_query['sql'],$q10_d902_grid_query['sqlParams']));
    //echo "<pre>". print_r(array($q10_d902_grid_title, $q10_d902_grid_fields, $columnsSums),1) . "</pre>";
    
    return array($q10_d902_grid_title, $q10_d902_grid_fields, $columnsSums);
}
/**
 * Αυτή η συνάρτηση φτιάχνει το query για τα ομαδοποιημένα αποτελέσματα.
 */
function query_q10_d902_find_query($q10nr01, $q10_d902_grid_fields)
{

    pegasus_mysql_use(" select * from q10 where nr01 = ? ", $q10Ar, array($q10nr01));

    if (empty($q10Ar['valuefield']) || empty($q10Ar['titlefield'])) {
        return array();
    }

    $titleField = $q10Ar['titlefield'];
    $valueField = $q10Ar['valuefield'];
    $groupField = $q10Ar['groupfield'];

    $q10_query00_def = query_make_select($q10Ar['nr01']);

    $q10_d902_grid_query = "select ";

    foreach ($q10_d902_grid_fields as $value) {
        $dataindex = $value['name'];
        if (!empty($value['dataindex'])) {
            $dataindex = $value['dataindex'];
        }
        if ($value['peg_fromjoin'] == 1) { //Ο τίτλος της αναφοράς
            if ($value['db_type'] == 'C') {
                $q10_d902_grid_query .= "group_concat(IF( $titleField = '" . $value['name'] . "'  , `$valueField` , null ) ) AS `" . $dataindex . "`, ";
            } elseif ($value['db_type'] == 'N') {
                $q10_d902_grid_query .= " sum(if( $titleField = '" . $value['name'] . "'  , `$valueField` , 0 )) as `" . $dataindex . "`, ";
            } else {
                $q10_d902_grid_query .= " if( $titleField = '" . $value['name'] . "'  , `$valueField` , 0 ) as `" . $dataindex . "`, ";
            }
        } else {
            $q10_d902_grid_query .= "maintbl." . $value['name'] . " as `" . $dataindex . "`, ";
        }
    }

    $q10_d902_grid_query = substr($q10_d902_grid_query, 0, -2);

    $q10_d902_grid_query .= " from ( $q10_query00_def ) as maintbl";
    if (!empty($groupField)) {
        $q10_d902_grid_query .= " group by $groupField";
    }
    return $q10_d902_grid_query;
}
/**
 * @param q10nr01
 * @param peg_grid_name
 * @param q13_values_arr
 * This function returns an array of columns, fields and columnsSums of grouped grid.
 */
function query_q10_d902_find_titles_fields_sums($q10nr01, $peg_grid_name = 'grid01', $q13_values_arr = array())
{

    //Ελέγχουμε τα δικαιώματα γιατί η συνάρτηση αυτήη χρησιμοποιείτααι π.χ. και στο initialize του dashboard
    $error = query_check_tables_and_priviledges($q10nr01);
    if(!empty($error)){
        return array();
    }
    //TODO: Να το αλλάξω στο dashboard και να μην χρειάζομαι εδώ το if
    if(empty($q13_values_arr)){ //αν η συνάρτηση καλείται από το dashboard - εδώ έρχεται κενό
        $q13_values_arr = query_g13_getInitialValues($q10nr01);
    }

    pegasus_mysql_use(" select * from q10 where nr01 = ? ", $q10Ar, array($q10nr01));

    $titleField = $q10Ar['titlefield']; //Οι στήλες του grid
    $valueField = $q10Ar['valuefield']; //Πεδίο τιμών


    $q10_query00_def = query_make_select($q10Ar['nr01']);
    $q10_query00 = trim($q10_query00_def);
    if (peg_substr($q10_query00, -1, null) == ';') {
        $q10_query00  = peg_substr($q10_query00, 0, -1);
    }
    $q10_query00 = query_replace_q13_from_array($q10nr01, $q10_query00, $q13_values_arr);
   
    $q10_res = pegasus_query(
        "select distinct(" . $titleField . ") as fld from ( ". $q10_query00['sql'] ." ) as tmptbl order by " . $titleField,
        $q10_query00['sqlParams']
    ); //Βρίσkει τις στήλες του grid

    
    $q10_p35 = pegasus_mysql_printfld('q10','p35','nr01=:q10nr01',array('q10nr01'=>$q10nr01));
    if(!empty($q10_p35)){
        pegasus_query($q10_p35);
    }
    query_makeQueryAfterArrOfReport_replace_q13($q10nr01, $q13_values_arr, 1);

    // echo pegasus_replace_values_in_sql("select distinct(" . $titleField . ") as fld from ( ". $q10_query00['sql'] ." ) as tmptbl order by " . $titleField,
    // $q10_query00['sqlParams']);

    //peg_write_file('../../tmp/grouped_query_fields.sql', "select distinct(" . $titleField . ") as fld from ( $q10_query00 ) as tmptbl order by " . $titleField);

    $extra_grid_fields = array();
    while ($rec = pegasus_fetch($q10_res, PEG_FETCH_ASSOC)) {
        $fld = $rec['fld'];
        $extra_grid_fields[] = array('name' => $fld, 'type' =>  'number', 'xtype' => 'pegasusNumberColumn', 'peg_fromjoin' => 1); //Όλες οι distinct τιμές των στηλών από το group by
    }

    $query_q12 = 'select * from q12 where p023=0 and p00=:q10_nr01 order by p05;'; //Τα πεδία της π-Αναφοράς
    $res_q12 = pegasus_query($query_q12, array('q10_nr01' => $q10Ar['nr01']));
    $q10_d902_grid_fields = array();
    $q10_d902_grid_title = array();
    $valueFieldColumn = 0;
    $columnsSums = 0;
    $counter = 0;
    while ($q12 = pegasus_fetch($res_q12, PEG_FETCH_ASSOC)) {

        if ($q12['p03'] == $valueField) {
            $valueFieldColumn = ($q12["p07"] + $q12["p08"]);
            continue;
        }

        if ($q12['p03'] == $titleField) { //Το πεδίο με το οποίο γίνεται group by
            pegasus_mysql_use(
                "select * from q12 where p00 = :q10_nr01 and p03 = :p03 ",
                $valueFieldAr,
                array('q10_nr01' => $q10nr01, 'p03' => $valueField)
            );

            foreach ($extra_grid_fields as $value) { //Όλες οι distinct τιμές των στηλών από το group by
                $tmpAr  = $valueFieldAr;

                $tmpAr['p01'] = query_makeGroupedColumnTitle($q12, $value['name']);
                $tmpAr['ep01'] = '';
                $tmpAr['p03'] = $value['name'];

                $tmpAr['dataindex'] = $titleField . '-' . $valueField . '-' . ++$counter;
                //TODO Add valu column for column x type.
                //TODO render column title from column x type
                $q10_d902_grid_fields[] = array('name' => $value['name'], 'db_type' => $tmpAr['p06'], /*'type' =>  'string', */ 'dataindex' =>  $tmpAr['dataindex'],  'type' =>  'number', 'peg_fromjoin' => 1);
                $q10_d902_grid_title[] = query_makeColumn($tmpAr, $peg_grid_name);
            }
        } else {
            //TODO λογικα εδω θελει αλλαγη της πρώτης συνθηκης για να παιζει και με D, ... 
            if (strtoupper($q12['p06']) != 'N') {
                $columnsSums += ($q12["p07"]);
                $q10_d902_grid_fields[] = array('name' => $q12['p03'], 'type' =>  'string', 'db_type' => $q12['p06']);
            } elseif (strtoupper($q12['p06']) == 'D') {
                $columnsSums += ($q12["p07"] + 2);
                $q10_d902_grid_fields[] = array('name' => $q12['p03'], 'type' =>  'string', 'db_type' => $q12['p06']);
            } elseif (strtoupper($q12['p06']) == 'L') {
                $columnsSums += (3);
                $q10_d902_grid_fields[] = array('name' => $q12['p03'], 'type' =>  'string', 'db_type' => $q12['p06']);
            } else {
                $columnsSums += ($q12["p07"] + $q12["p08"]);
                $q10_d902_grid_fields[] = array('name' => $q12['p03'], 'type' =>  'number', 'db_type' => $q12['p06']);
            }
            $q10_d902_grid_title[] = query_makeColumn($q12, $peg_grid_name);
        }
    }

    $columnsSums += count($extra_grid_fields) * $valueFieldColumn;
    // var_dump($q10_d902_grid_fields);
    return array($q10_d902_grid_title, $q10_d902_grid_fields, $columnsSums);
}

/**
 *  Η συνάρτηση αυτή καλείται από τις φόρμες εκτύπωσης των αναφορών
 */
function query_q10_d90_to_pdf_code()
{
    $q10_nr01 = $_REQUEST['q10_nr01'];
    if (!is_numeric($q10_nr01)) { die('Undefined Report'); }


    $_d = 'q10_d901';
    if ( 
        //20201221 ΦΨ - Πλέον δεν παίζω μόνο με q10_d901, q10_d902
        //!empty($_REQUEST['_d']) && ($_REQUEST['_d'] === 'q10_d901' || $_REQUEST['_d'] === 'q10_d902')
        isset($_REQUEST['_d'])
    ) {
        $_d =  $_REQUEST['_d'];
    }
    
     //Περνάει σαν παράμετρος στην καινούρια λογική που δεν παίζω μόνο με q10_d901, q10_d902
    $isGroupedTab = $_REQUEST['isGroupedTab'];

    pegasus_mysql_use("select * from q10 where nr01 = ?", $q10Ar, array($q10_nr01));
    if (empty($q10Ar['nr01'])) { die('Undefined Report');}

    if ($_d == 'q10_d902' || $isGroupedTab == "true") {
      $title_array = query_q10_d90_to_pdf_code_find_grouped_title_array($q10_nr01);
    } else {
        $title_array = query_q10_d90_to_pdf_code_find_title_array($q10_nr01);
    }
    $variable_array = query_q10_d90_to_pdf_code_find_variable_array($q10_nr01);
    
    return array($title_array, $variable_array);
}

function query_q10_d90_to_pdf_code_find_variable_array($q10_nr01){

    $q13_values_arr = query_q13_getValuesFromRequest($q10_nr01);
    $variable_array = array();
	$query_q13 = 'select * from q13 where p00=:q10_nr01 order by p05 ';
	$res_q13 = pegasus_query($query_q13, array('q10_nr01' => $q10_nr01));
	while ($q13 = pegasus_fetch($res_q13, PEG_FETCH_ASSOC)) {
		$variable_array[$q13['p02']] = array_merge( $q13 ,array( 'value' => $q13_values_arr[$q13['p02']]));
	}
    return $variable_array;
}

function query_q10_d90_format_variables_string($variable_array)
{
    if (is_null($variable_array) || empty($variable_array)) {
        return '';
    }
    $str = '';
    foreach ($variable_array as $var) {
        $value = $var['value'];
        //Βρίσκει το label του value του συγκεκριμενου q131 
        pegasus_mysql_use(
            "SELECT value,evalue FROM q131 WHERE q13=:q13_nr01 AND code=:q13_value",
            $q131,
            array(
                "q13_nr01" => $var['nr01'],
                'q13_value' => $value
            )
        );
        $p01 = str_replace(" ", "&nbsp;", $var['p01']);
        $label = $q131 !== false ? $q131['value'] : $value;
        if ($var['p03'] == 'D') {
            $label =  peg_dateToStr($value);
        } else if ($var['p03'] == 'L') {
            $label =  ($value == '0') ? "ΟΧΙ" : "ΝΑΙ";
        }
        $str .= '<b>' . $p01 . "</b>:&nbsp;" . $label . "  "; //Δεν πρέπει να έχουν κενό γιατί εκτυπώνονται σε έκφραση μ αναδίπλωση
    }
    return $str;
}

/**
 * Βρίσκει ένα array με τους τίτλους των στηλών για την εκτύπωση του pdf.
 * @param mixed $q10_nr01 
 * @return array 
 */
function query_q10_d90_to_pdf_code_find_title_array($q10_nr01){
    $title_array = array();
    $q12_select = "select * from q12 where p00=? and p023=0 order by p05;";
    $q12_res = pegasus_query($q12_select, array($q10_nr01));
    while ($q12 = pegasus_fetch($q12_res, PEG_FETCH_ASSOC)) {
        $align = 'L';
        $tax = $q12["p05"];
        if (strtoupper($q12["p06"]) == 'D' || $q12["p06"] == 'd') {
            $cols = ($q12["p07"] + $q12["p08"] + 2);
        } else {
            $cols = ($q12["p07"] + $q12["p08"]);
            if (strtoupper($q12["p06"]) == 'N') {
                $align = 'R';
            }
        }

        $q12_field_val = $q12["p01"];
        if ($_SESSION['lang'] == 'EN' && !empty($q12["ep01"])) {
            $q12_field_val = $q12["ep01"];
        }
        array_push(
            $title_array,
            array(
                "cols" => $cols,
                "title" => $q12_field_val,
                "name" => $q12["p03"],
                "sum" => $q12["p022"],
                "tax" => $tax,
                "type" => $q12["p06"],
                "align" => $align,
                "p08" =>  $q12["p08"]
            )
        );
    }
    return $title_array;
}

/**
 * Βρίσκει ένα array με τους τίτλους των στηλών για την εκτύπωση του pdf. Είναι για τα ομαδοποιημένα αποτελέσματα.
 * @param mixed $q10_nr01 
 * @return array 
 */
function query_q10_d90_to_pdf_code_find_grouped_title_array($q10_nr01){
    $title_array = array();
    pegasus_mysql_use("select * from q10 where nr01 = ?", $q10Ar, array($q10_nr01));
    $titleField = $q10Ar['titlefield'];
    $valueField = $q10Ar['valuefield'];
    $extra_grid_fields = array();


    $q10_query00 = query_make_select($q10Ar['nr01']);
    $q13_values_arr = query_q13_getValuesFromRequest($q10_nr01);
    $q10_query00 = query_replace_q13_from_array($q10_nr01, $q10_query00, $q13_values_arr);
    
    $q10_res = pegasus_query( 
                    "select distinct(" . $titleField . ") as fld from ( ".$q10_query00['sql']." ) as tmptbl order by " . $titleField, 
                    $q10_query00['sqlParams']
                );

    $counter = 0;
    while ($rec = pegasus_fetch($q10_res, PEG_FETCH_ASSOC)) {
        $fld = $rec['fld'];
        $extra_grid_fields[] = array('name' => $fld, 'type' =>  'number',   'xtype' => 'pegasusNumberColumn', 'peg_fromjoin' => 1);
    }

    $query_q12 = 'select * from q12 where p023=0 and p00=? order by p05;';
    $res_q12 = pegasus_query($query_q12, array($q10Ar['nr01']));
    $q10_d902_grid_fields = array();
    $varValueFieldColumns = 0;
    $varValueFieldDecimal = 0;
    $varValueFieldP022 = 0;

    $counter = 0;
    while ($q12 = pegasus_fetch($res_q12, PEG_FETCH_ASSOC)) {
       
        if ($q12['p03'] == $valueField) {
            $varValueFieldColumns = ($q12["p07"] + $q12["p08"]);//Μέγεθος και Δεκαδικά
            $varValueFieldDecimal = $q12["p08"]; //Δεκαδικά
            $varValueFieldP022 = $q12["p022"]; //Να εμφανίζει το άθροισμα
            continue;
        }

        if ($q12['p03'] == $titleField) {
            pegasus_mysql_use(
                "select * from q12 where  p023=0 and p00 = :q10nr01 and p03 = :valueField ", 
                $valueFieldAr, 
                array('q10nr01' => $q10_nr01, 'valueField' =>$valueField)
            );

            foreach ($extra_grid_fields as $value) {
                $tmpAr  = $valueFieldAr;

                $tmpAr['p01'] = query_makeGroupedColumnTitle($q12, $value['name']);

                $tmpAr['ep01'] = '';
                $tmpAr['p03'] = $value['name'];

                $tmpAr['dataindex'] = $titleField . '-' . $valueField . '-' . ++$counter;

                $q10_d902_grid_fields[] = array(
                    'title' => $tmpAr['p01'],
                    'name' => $value['name'],
                    'db_type' => $tmpAr['p06'],
                    'dataindex' =>  $tmpAr['dataindex'],
                    'type' =>  'N',
                    'cols' => ($q12["p07"] + $q12["p08"]),
                    'peg_fromjoin' => 1,
                    'tax' => $q12["p05"]
                );
            }
            continue;
        } 

        $desc = $q12['p01'];
        if ($_SESSION['lang'] == 'EN' && !empty($q12["ep01"])) {
            $desc = $q12["ep01"];
        }
        if (strtoupper($q12['p06']) != 'N' && strtoupper($q12['p06']) != 'D') {
            $q10_d902_grid_fields[] = array(
                'name' => $q12['p03'],
                'title' => $desc,
                'db_type' => $q12['p06'],
                'type' =>  'S',
                'cols' => ($q12["p07"] + $q12["p08"]),
                'tax' => $q12["p05"]
            );
        } elseif (strtoupper($q12['p06']) == 'D') {
            $q10_d902_grid_fields[] = array(
                'name' => $q12['p03'],
                'title' => $desc,
                'db_type' => $q12['p06'],
                'type' =>  'D',
                'cols' => ($q12["p07"] + $q12["p08"] + 2),
                'decimal' => $q12["p08"],
                'p022' => $q12["p022"],
                'tax' => $q12["p05"]

            );
        }  else {
            $q10_d902_grid_fields[] = array(
                'name' => $q12['p03'],
                'title' => $desc,
                'db_type' => $q12['p06'],
                'type' =>  'N',
                'cols' => ($q12["p07"] + $q12["p08"]),
                'tax' => $q12["p05"]
            );
        }
        
    }
    
    foreach ($q10_d902_grid_fields as $rec) {
        $align = 'L';
        $cols = $rec['cols'];
        $decimal = 0;
        $sum = 0;


        if ($rec['decimal'] > 0) {
            $decimal = $rec['decimal'];
        }
        if ($rec['p022']) { //Να εμφανίζει άθροισμα
            $sum = 1;
        }

        if ($rec['peg_fromjoin'] == 1) {
            if ($varValueFieldColumns > 0) {
                $cols = $varValueFieldColumns;
            }
            if ($varValueFieldDecimal > 0) {
                $decimal = $varValueFieldDecimal;
            }
            if ($varValueFieldP022) {
                $sum = $varValueFieldP022;
            }
        }

        if ($rec['type'] == 'N') {
            $align = 'R';
        }

        $dataindex = $rec['name'];
        if (!empty($rec['dataindex'])) {
            $dataindex = $rec['dataindex'];
        }

        array_push(
            $title_array,
            array(
                "cols" => $cols,
                "title" => $rec['title'],
                "name" =>  $dataindex,
                "sum" => $sum,
                "tax" => $rec['tax'],
                "type" => $rec["type"],
                "align" => $align,
                "p08" =>  $decimal //decimal
            )
        );
    }
    return $title_array;
}



/**
 * Return the sql query for the print form
 * @return string sqlquery
 */
function query_q10_d90_to_pdf_body_sql_code(){  
    
    if (!empty($_REQUEST['sub_container_id'])) {
        $query = pegasusGetGlobalVar('gridData_' . $_REQUEST['sub_container_id'] . '_grid01_query');
        $query_whereParams = pegasusGetGlobalVar('gridData_' . $_REQUEST['sub_container_id'] . '_grid01_query_whereParams');
        if(empty($query)){
            $query = pegasusGetGlobalVar( $_REQUEST['sub_container_id'] . '_q10_d902_grid_query');
        }
        return array('sql'=>$query, 'sqlParams'=>$query_whereParams);
    }
    $query = pegasusGetGlobalVar('gridData_' . $_REQUEST['q10_d901_container_id'] . '_grid01_query');
    $query_whereParams = pegasusGetGlobalVar('gridData_' . $_REQUEST['q10_d901_container_id'] . '_grid01_query_whereParams');
    
    return array('sql'=>$query, 'sqlParams'=>$query_whereParams);
}
//XXX Start Screen functions
/**
 * Edit p-Report
 * @param array $data
 * @param string $mmnr01
 * @param string $mnr01
 * @param string $_d
 * @param string $container_id
 * @return array
 */
function peg_query_q10_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
     //Αν υπάρχει το module dias not_auto_nr01 == 1
    $pegasus_mudule_exist_dias = pegasus_module_exists('dias');
    $peg_is_newrec = 0;

    //Θέλω να δημιουργείται ΜΚ στην περίπτωση που είμαι σε αντιγραφή για να φτιάχνονται σωστά τα tmp 
    //Αν η αντιγραμμένη αναφορά ειναι για standard module, διορθώνω τα ΜΚ στο save του q10
    if ( !($data['nr01'] > 0) and (  $_REQUEST['rec_copy_nr01']>0 ) ) {
        $data['nr01'] = pegasus_mysql_newrec('q10');
        $peg_is_newrec = 1;
    }

    $data['nr01'] = intval($data['nr01']);

    $data['standard_readonly'] = 0;
    if (!$pegasus_mudule_exist_dias && !($_REQUEST['rec_copy_nr01'] > 0) && $data['is_std'] == 1) {
        //Ean den uparxei o dias kai den einai antigrafi kai einai standar
        $data['standard_readonly'] = 1;
    }
    if ($_d == 'q10_d') {

        //Σετάρει το query για την variable της Κατηγορίας->Υποκατηγορίας
        pegasusSetGlobalVar(
            $container_id . '_p04_query',
            'select '."\n".
            '    concat(q09.p01, " (", q08.p01, ")") as p01,  '."\n".
            '    concat(q09.ep01, " (", q08.ep01, ")") as ep01,  '."\n".
            '    q09.nr01, '."\n".
            '    q09.p02, '."\n".
            '    q09.q08, '."\n".
            '    q09.in_menu, '."\n". 
            '    q09.module, '."\n".
            '    q09.is_std, '."\n".
            '    q09.p32 '."\n".
            '    from q09 '."\n".
            '    left join q08 on q09.q08 = q08.nr01'
        );

        if ($data['nr01'] > 0) {

            $whereTmpTbl = ' peg_flag!=9 and ' .
            ' peg_sess_id=:session_id  and ' .
            ' peg_mmnr01=:peg_mmnr01 and  ' .
            ' peg_mnr01=:nr01 ';

            $whereTmpTblVars = array(
                'session_id' => session_id(),
                'peg_mmnr01' => "q10_d-" . $data['nr01'],
                'nr01' => $data['nr01']
            );

            pegasus_make_all_tmp_recs(
                'q10',
                $data,
                $data['nr01'],
                $_REQUEST['rec_copy_nr01'],
                'q10_d-' . $data['nr01']
            );
            
            pegasusSetGlobalVar(
                $container_id . '_where_q11',
                array(
                    'sql' => " peg_tmp_q11.p00=:nr01 and $whereTmpTbl ", 
                    'sqlParams' => $whereTmpTblVars)
            );
            pegasusSetGlobalVar(
                $container_id . '_where_q12',
                array(
                    'sql' => " peg_tmp_q12.p00=:nr01 and $whereTmpTbl ", 
                    'sqlParams' => $whereTmpTblVars)
            );
            pegasusSetGlobalVar(
                $container_id . '_where_q13',
                array(
                    'sql' => " peg_tmp_q13.p00=:nr01 and $whereTmpTbl ", 
                    'sqlParams' => $whereTmpTblVars)
            );
            pegasusSetGlobalVar(
                $container_id . '_where_q14',
                array(
                    'sql' => " peg_tmp_q14.p00=:nr01 and $whereTmpTbl ", 
                    'sqlParams' => $whereTmpTblVars)
            );
            pegasusSetGlobalVar(
                $container_id . '_where_q15',
                array(
                    'sql' => " peg_tmp_q15.p00=:nr01 and $whereTmpTbl ", 
                    'sqlParams' => $whereTmpTblVars)
            );
            pegasusSetGlobalVar(
                $container_id . '_where_q16',
                array(
                    'sql' => " peg_tmp_q16.p00=:nr01 and $whereTmpTbl ", 
                    'sqlParams' => $whereTmpTblVars)
            );

            pegasusSetGlobalVar(
                $container_id . '_where_valuefield_query',
                array(
                    'sql' => " select * from peg_tmp_q12 where  p06 in ('C', 'N' ) and peg_tmp_q12.p00=:nr01 and $whereTmpTbl ", 
                    'sqlParams' => $whereTmpTblVars)
            );

            pegasusSetGlobalVar(
                $container_id . '_where_groupfield_query',
                array(
                    'sql' => " select * from peg_tmp_q12 where p06 in ('C', 'D',  'N', 'L') and peg_tmp_q12.p00=:nr01 and $whereTmpTbl ", 
                    'sqlParams' => $whereTmpTblVars)
            );

            pegasusSetGlobalVar(
                $container_id . '_where_titlefield_query',
                array(
                    'sql' => " select * from peg_tmp_q12 where p06 in ('C', 'D', 'L', 'N') and $whereTmpTbl ", 
                    'sqlParams' => $whereTmpTblVars)
            );

            if (pegasus_module_exists('query00')) {
                pegasusSetGlobalVar(
                    $container_id . '_where_query00_q13',
                    array(
                        'sql' => " peg_tmp_query00_q13.p00=:nr01 and $whereTmpTbl ", 
                        'sqlParams' => $whereTmpTblVars)
                );
                $query00_q10_ar = null;
                pegasus_mysql_use(
                    " select  query00_q10.* from query00_q10 where query00_q10.q10=:nr01  ", 
                    $query00_q10_ar,
                    array('nr01' => $data['nr01'])
                );
                $data['q10'] = $data['nr01'];
                if ($query00_q10_ar['nr01'] > 0) {
                    $data['p303'] = $query00_q10_ar['p303'];
                    $data['p300'] = $query00_q10_ar['p300'];
                }
            }
            if (pegasus_module_exists('charts')) {
                pegasusSetGlobalVar(
                    $container_id . '_where_q10_d00',
                    array(
                        'sql' =>" peg_tmp_charts_q10.q10=:nr01 and $whereTmpTbl ", 
                        'sqlParams' => $whereTmpTblVars
                    )
                );
            }

            peg_query_q10_d_set_globals_affected_by_q10_p02($container_id, $data['nr01'], $data['p02']);
            peg_query_q10_d_set_globals_affected_by_selected_q11($container_id, $data['nr01'], $data['p02'], '');


            if ($peg_is_newrec == 0 && peg_query_canProfileRead($data['nr01']) === false) {
                $data['readonly']  = 1;
            }
        }
    }
    return $data;
}

function peg_query_q10_d_set_globals_affected_by_q10_p02($container_id, $q10_nr01, $q10_p02){
    
    $whereTmpTbl = ' peg_flag!=9 and ' .
    ' peg_sess_id=:session_id  and ' .
    ' peg_mmnr01=:peg_mmnr01 and  ' .
    ' peg_mnr01=:nr01 ';

    $query00Params = array(
        'session_id' => session_id(),
        'peg_mmnr01' => "q10_d-" . $q10_nr01,
        'nr01' => $q10_nr01,
        'db_table' => $q10_p02
    );
    $query01 = query_getExtraFieldsQuery('', '',0); //TODO: Check PDO
    
    $query00 = peg_read_file('../query_sql/q10_d/q10_d01_grid01.sql' );
    $query00 = str_replace('##_where_q11##', " peg_tmp_q11.p00=:nr01 and ".$whereTmpTbl, $query00);
    pegasusSetGlobalVar(
        $container_id . '_where_q10_d01_grid01_query',
        array(
            'sql' => $query00,
            'sqlParams' => $query00Params
        )
    );
    
    $query00 = peg_read_file('../query_sql/q10_d/q10_d02.sql' );
    $query00 = str_replace( '##extra_fields##', $query01 ,  $query00);
    $query00 = str_replace('##_where_q11##', " peg_tmp_q11.p00=:nr01 and ".$whereTmpTbl, $query00);
    pegasusSetGlobalVar(
        $container_id . '_where_q10_d02_grid02_query',
        array(
            'sql' => $query00,
            'sqlParams' => $query00Params
        )
    ); 

    $query00 = peg_read_file('../query_sql/q10_d/q10_d03.sql' );
    $query00 = str_replace( '##extra_fields##', $query01 ,  $query00);
    $query00 = str_replace('##_where_q11##', " peg_tmp_q11.p00=:nr01 and ".$whereTmpTbl, $query00);
    pegasusSetGlobalVar(
        $container_id . '_where_q10_d03_grid02_query',
        array(
            'sql' => $query00,
            'sqlParams' => $query00Params
        )
    );

    $query00 = peg_read_file('../query_sql/q10_d/q10_d04.sql' );
    $query00 = str_replace( '##extra_fields##', $query01 ,  $query00);
    $query00 = str_replace('##_where_q11##', " peg_tmp_q11.p00=:nr01 and ".$whereTmpTbl, $query00);
    pegasusSetGlobalVar(
        $container_id . '_where_q10_d04_grid02_query',
        array(
            'sql' => $query00,
            'sqlParams' => $query00Params
        )
    );


    $query00 = peg_read_file('../query_sql/q10_d/q10_d06.sql' );
    $query00 = str_replace( '##extra_fields##', $query01 ,  $query00);
    $query00 = str_replace('##_where_q11##', " peg_tmp_q11.p00=:nr01 and ".$whereTmpTbl, $query00);
    pegasusSetGlobalVar(
        $container_id . '_where_q10_d06_grid02_query',
        array(
            'sql' => $query00,
            'sqlParams' => $query00Params
        )
    );

}

function peg_query_q10_d_set_globals_affected_by_selected_q11($container_id, $q10_nr01, $selected_table, $selected_table_alias = ''){
    
    if($selected_table_alias == ''){
        $selected_table_alias = $selected_table;
    }

    $whereTmpTbl = ' peg_flag!=9 and ' .
    ' peg_sess_id=:session_id  and ' .
    ' peg_mmnr01=:peg_mmnr01 and  ' .
    ' peg_mnr01=:nr01 ';

    $whereTmpTblVars = array(
        'session_id' => session_id(),
        'peg_mmnr01' => "q10_d-" . $q10_nr01,
        'nr01' => $q10_nr01
    );

    $p03 = pegasus_mysql_printfld(
        'peg_tmp_q11' , 
        'max(p03)' , 
        " peg_tmp_q11.p00=:nr01 and ".$whereTmpTbl, 
        $whereTmpTblVars
    );
    
    $query00 = peg_read_file('../query_sql/q10_d/q10_d01.sql' );
    
    $query00Params = array(
                        'p03' => (str2int($p03)+50) , 
                        'first_table_alias' => $selected_table_alias,
                        'var1' => $selected_table
                    );
                     
    pegasusSetGlobalVar(
        $container_id . '_where_q10_d01_grid02_query',
        array(
            'sql' => $query00,
            'sqlParams' => $query00Params
        )
    );   
}


/**
 * Πινακες ανα π-Αναφορά
 * @param array $data
 * @param string $mmnr01
 * @param string $mnr01
 * @param string $_d
 * @param string $container_id
 * @return array
 */
function peg_query_q11_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
    $data['p00'] = $mnr01;

    return $data;
}
/**
 * Μεταβλητές Aπο χρήστη ανά π-Αναφορά
 * @param array $data
 * @param string $mmnr01
 * @param string $mnr01
 * @param string $_d
 * @param string $container_id
 * @return array
 */
function query_q12_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
 
    if ($_d == 'q12_d') {

        if (pegasus_module_exists('dias')) {
            pegasus_mysql_use("select * from q10 where nr01=?;", $q10, array($mnr01));
            if ($q10['is_std'] == 1 && !empty($q10['module_00']) && empty($data['nr01'])) {
                $data['nr01'] = pegasus_mysql_module_newrec('q12', $q10['module_00']);
            }
        }
        
        if (empty($data['nr01'])) {
            $data['nr01'] = pegasus_mysql_newrec('q12');
        }
        pegasus_make_all_tmp_recs('q12', $data, $data['nr01'], $_REQUEST['rec_copy_nr01'], 'q12_d-' . $data['nr01']);
        if (empty($data['p00'])) {
            $data['p00'] = $mnr01;
        }
    }
    return $data;
}
/**
 * Μεταβλητές Aπο χρήστη ανά π-Αναφορά
 * @param array $data
 * @param string $mmnr01
 * @param string $mnr01
 * @param string $_d
 * @param string $container_id
 * @return array
 */
function peg_query_q13_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
 
    if ($_d == 'q13_d') {

        if (pegasus_module_exists('dias')) {
            $peg_mmodule = pegasus_mysql_printfld('q10', 'module_00', 'nr01=?', array($mnr01) );
            if (empty($data['nr01']) and  !empty($peg_mmodule)) {
                $data['nr01'] = pegasus_mysql_module_newrec('q13',  $peg_mmodule);
            }
        }

        if (empty($data['nr01'])) {
            $data['nr01'] = pegasus_mysql_newrec("q13");
        }

        $data['nr01'] = $data['nr01'];

        if($data['p012'] == 1){
            $data['fldset02_hidden'] = true;
        }
        if($data['p03']!='N'){
            $data['p03_1_hidden']=1;
        }

        pegasus_make_all_tmp_recs('q13', $data, $data['nr01'], $_REQUEST['rec_copy_nr01'], 'q13_d-' . $data['nr01']);
        if (empty($data['p00'])) {
            $data['p00'] = $mnr01;
        }
        pegasusSetGlobalVar(
            $container_id . '_where_q131',
            array(
                "sql" => 
                " peg_tmp_q131.q13=:nr01 and peg_flag!=9 and ".
                "peg_sess_id=:session_id and peg_mmnr01=:mmnr01 and peg_mnr01=:nr01",
                "sqlParams" => 
                array(
                    'nr01' => $data['nr01'],
                    'session_id' => session_id(),
                    'mmnr01' => "q10_d-" . $mnr01  
                    )   
            )   
        );
    }
    return $data;
}
/**
 * Λίστα Αναφορών (button απο το browse του πίνακα)
 * @param array $data
 * @param string $mmnr01
 * @param string $mnr01
 * @param string $_d
 * @param string $container_id
 * @return array
 */
function query_q10_d85_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{

    if ($_d == 'q10_d85') {

        $data['query_q10_d85_grid_favourite_reports_hidden'] = false;
        /*$where = peg_query_generateProfilePermissionWhere();
        if (!empty($where)) {
            $where = " and en=1";
        }

        pegasusSetGlobalVar(
            $container_id . '_where_grid_q10_d85',
            array(
                'sql'       =>  " q10.p02= :q10_p02 and q10.p06=1  $where ",
                'sqlParams' =>  array('q10_p02' => $_REQUEST['dias_main_table'])
            )
        );*/


        pegasus_mysql_use(
            "SELECT count(nr01) as cnt FROM q10 where fav LIKE :fav and q10.p02 = :v_table",
            $q10_fav,
            array(
                'fav'   => "%#".$_SESSION['username']."#%", 'v_table' => $_REQUEST['dias_main_table'])
        );
        
        $fav='0';
        if($q10_fav['cnt']>0){
            $fav='1';
        }
        $data['fav_val']=$fav;
        query_q10_d95_set_gridQuery($container_id,$fav);



        $data['grid_change_hidden'] = true;
    }

    return $data;
}
/**
 * Λίστα Αναφορών  
 * @param array $data
 * @param string $mmnr01
 * @param string $mnr01
 * @param string $_d
 * @param string $container_id
 * @return array
 */
function query_q10_d95_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{

    if ($_d == 'q10_d95') {
        pegasus_mysql_use(
            "SELECT count(nr01) as cnt FROM q10 where fav LIKE :fav",
            $q10_fav,
            array(
                'fav'   => "%#".$_SESSION['username']."#%"
            )
        );
        $fav='0';
        if($q10_fav['cnt']>0){
            $fav='1';
        }
        $data['fav_val']=$fav;
        query_q10_d95_set_gridQuery($container_id,$fav);
        $data['query_q10_d95_grid_favourite_reports_hidden'] = false;

    }
    $data['query_q10_d95_grid_favourite_reports_hidden'] = false;

    return $data;
}
function query_q10_d95_set_gridQuery($container_id,$fav=1){
    $where = peg_query_generateProfilePermissionWhere();
    $sqlParams = array();
    if (!empty($where)) {
        $where = " and en=1";
    }
    $fav_where = '';
    $fav_params = array();
    if($fav==1){

        $fav_where .= "AND fav LIKE :fav";
        $user = $_SESSION['username'];
        $fav_params['fav']="%#$user#%";
    }

    if(!empty($_REQUEST['q10.module_00'])){
        pegasusSetGlobalVar(
            $container_id . '_where_grid_q10_d95',
            array(
                "sql" => " q08.in_menu=1 AND q09.in_menu=1 AND 1 = peg_module_exists(q10.module_00)  $where $fav_where ",
                "sqlParams" => array_merge($sqlParams,$fav_params)
            )
        );
    }else{
        pegasusSetGlobalVar(
            $container_id . '_where_grid_q10_d95',
            array(
                "sql" => " q08.in_menu=1 AND q09.in_menu=1 $where $fav_where ",
                "sqlParams" => array_merge($sqlParams,$fav_params)
            )
        );
    }
    // ----------------------------------------------------------
    $where = peg_query_generateProfilePermissionWhere();
    if (!empty($where)) {
        $where = " and en=1";
    }

    $sqlParams = array(
        'q10_p02'   => $_REQUEST['dias_main_table']
    );
    $global_var=pegasusGetGlobalVar( $container_id . '_where_grid_q10_d85');
    if(!isset($_REQUEST['dias_main_table']) && !empty($global_var['sqlParams']['q10_p02'])) {
        $sqlParams['q10_p02'] = $global_var['sqlParams']['q10_p02'];
    }
    pegasusSetGlobalVar(
        $container_id . '_where_grid_q10_d85',
        array(
            'sql'       =>  " q10.p02= :q10_p02 and q10.p06=1  $where $fav_where ",
            "sqlParams" => array_merge($sqlParams,$fav_params)
        )
    );

}

function query_check_tables_and_priviledges($q10nr01){
    $msg = '';
    if ($q10nr01 > 0) {
        $peg_tmp_tbl_al = array();
        $peg_tmp_tablesOfQ10Res = pegasus_query(" select p01 from q11 where q11.p00 = ? ", array($q10nr01));

        while ($peg_tmp_row = pegasus_fetch($peg_tmp_tablesOfQ10Res, PEG_FETCH_ASSOC)) {
            if (!(pegasus_mysql_table_exists($peg_tmp_row['p01']))) {
                $peg_tmp_tbl_al[] = $peg_tmp_row['p01'];
            }
        }
        if (count($peg_tmp_tbl_al) > 0) {
            $peg_tmp_str = $_SESSION['peg_dic_query_table_not_exist'];
            $peg_tmp_str = str_replace("##tables##", implode(", ",  $peg_tmp_tbl_al),   $peg_tmp_str);
            $msg = $peg_tmp_str ;
        }

        if (peg_query_canProfileRead($q10nr01) === false) {

            pegasus_mysql_use(
                'select nr01, p01, ep01 from q10 where nr01=:nr01 ',
                $q10Ar,
                array(
                    'nr01' => $q10nr01,
                )
            );
            $peg_tmp_q10p01 =  $q10Ar['p01'];
            if ($_SESSION['lang'] == 'EN' && !empty($q10Ar['ep01'])) {
                $peg_tmp_q10p01 = $q10Ar['ep01'];
            }
            $peg_tmp_str = $_SESSION['peg_dic_query_perm_deny_show_query'];
            $peg_tmp_str = str_replace(
                array('##q10_nr01##', '##q10_p01##'),
                array($q10Ar['nr01'], $peg_tmp_q10p01),
                $peg_tmp_str
            );
            $msg = $peg_tmp_str ;
        }
    }
    return $msg;
}

function query_q16_d01_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
    if ($_d == 'q16_d01') {
        $whereTmpTbl = ' 	peg_tmp_q13.p00=:mnr01  and  
						peg_tmp_q13.peg_mnr01=:mnr01 and 
		                peg_tmp_q13.peg_mmnr01=:mmnr01 and 
		                peg_tmp_q13.peg_sess_id=:session_id and 
		                peg_tmp_q13.peg_flag!=9 ';
        pegasusSetGlobalVar(
            $container_id . '_where',
            array(
                'sql' => $whereTmpTbl,
                'sqlParams' => array('mnr01' => $mnr01, 'mmnr01' => $mmnr01, 'session_id' =>session_id())
            )
        );
    }
    return $data;
}

function query_q16_d02_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{

    //ΦΨ: Παλιά είχαμε peg_tmp_q97 ... Δεν καταλαβαίνω γιατί
    if ($_d == 'q16_d02') {
        pegasusSetGlobalVar(
            $container_id . '_where',
            "q97.wh=1"
        );
    }
    return $data;
}

function peg_query_q10_d97_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
    pegasusSetGlobalVar(
        $container_id . '_where',
        array(
            'sql' => " q10 = :nr01",
            'sqlParams' => array('nr01' => $mnr01)
        )
    );
    return $data;
}

function query_q10_update_fav(
    $nr01 = 0,
    $vfav = 0
) {
    $q10_fav = pegasus_mysql_printfld(
        'q10',
        'fav',
        'nr01 = :nr01',
        array('nr01'=>$nr01)
    );
    $fav = explode('#',trim($q10_fav,'#'));
    $user = $_SESSION['username'];
    if(
        $vfav == 1
        && !in_array($user,$fav)
    ) {
        $q10_fav.="#$user#";
        pegasus_mysql_update(
            'q10',
            array('fav'),
            array($q10_fav),
            'nr01 = :nr01',
            0,1,1,
            array('nr01'=>$nr01)
        );
    }elseif(
        $vfav == 0
        && in_array($user,$fav)
    ) {
        $q10_fav = str_replace(
            "#$user#",
            "",
            $q10_fav
        );
        pegasus_mysql_update(
            'q10',
            array('fav'),
            array($q10_fav),
            'nr01 = :nr01',
            0,1,1,
            array('nr01'=>$nr01)
        );
    }
    return array(
        'ok'    => 1,
        'msg'   => 'Success'
    );
}
//ΧΧΧ Start On save 
/**
 * $mmnr01 = το mmnr01
 * $checkOnlyPerm = 1 , απλά ελέγχει τα δικαιώματα και δεν καταχωρεί κάτι.
 * $data = array() τα δεδομένα που θα αποθηκευτούν
 *  $permDeny = array(
 array(
 'type'=> (deny ή CONFIRM ) ,
 'message'=> το μήνυμα που θα εμφανίσει.
 )
 
 )
 */

function query_q10_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm)
{
    if(!empty($data['p04'])){
        $data['q08'] = pegasus_mysql_printfld('q09', 'q08', 'nr01=?', array($data['p04'])); //σετάρω την κατηγορία από την υποκατηγορία
    }
    if(!empty($data['p02'])){
        $data['p55'] = pegasus_mysql_printfld('p50', 'module', 'p01=?', array($data['p02'])); //σετάρω το module από τον πίνακα
    }
    
    if ($checkOnlyPerm == 1) {
        if ($data['is_std'] == 1 and !pegasus_module_exists('dias') && !pegasus_module_exists('query00')) {
            array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_query_is_standard']));
            return;
        }

        if ((pegasus_mysql_printfld(
            'peg_tmp_q12',
            'count(*)',
            ' peg_sess_id=:sess_id and peg_mmnr01=:mmnr01 and  mail="1" and peg_flag!=9',
            array('sess_id' => session_id(), 'mmnr01' => $mmnr01)
        ) > 1)) {
            array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_query_unique_mail_check']));
        }

        if (empty($data['titlefield']) && !empty($data['valuefield'])) {
            array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_query_grouped_emptytitle']));
        } elseif (!empty($data['titlefield']) && empty($data['valuefield'])) {
            array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_query_grouped_emptyvaluefield']));
        }
    } else {
        $data['p02'] = strtolower($data['p02']);

        if (pegasus_module_exists('query00')) {
            $query00_q10_ar = array();
            $query00_q10_ar['p300'] = $_REQUEST['p300'];
            $query00_q10_ar['p303'] = $_REQUEST['p303'];
            $data['nr01'] = intval($data['nr01']);//Για PDO
            if (pegasus_mysql_printfld('query00_q10', 'count(*)', 'q10=' . $data['nr01']) > 0) {
                pegasus_mysql_update('query00_q10', array_keys($query00_q10_ar), array_values($query00_q10_ar), 'q10=' . $data['nr01']);
            } else {
                $query00_q10_ar['q10'] = $data['nr01'];
                $query00_q10_ar['nr01'] =  pegasus_mysql_newrec('query00_q10');
                pegasus_mysql_insert('query00_q10', array_keys($query00_q10_ar), array_values($query00_q10_ar));
            }
        }

        if($data['is_std'] == 1 && !empty($data['module_00']) && pegasus_module_exists('dias')){

            pegasus_mysql_use( "select * from p55 where p00 = :module ", 
                                $p55Ar,
                                 array('module' => $data['module_00']) );
             
            //Αν δεν έχει το σωστό Μ.Κ. το διορθώνει και                
            if( ! ( $p55Ar['minnr01'] <= $data['nr01'] && $p55Ar['maxnr01'] >$data['nr01'] ) ){

                //Εδώ θα μπει μόνο στην περίπτωη αντιγραφής γιατί ισχύει ότι το πεδίο
                //module_00 είναι readonly=2 άρα μπορεί να αλλάξει μόνο στην νεα οθόνη     
                //Επίσης, στην νέα καταχώρηση, το ΜΚ ειναι 0 και φτιάχνεται στο before_save 

                $oldNr01 = $data['nr01'];
                $data['nr01'] = pegasus_mysql_module_newrec('q10'  , $data['module_00']);

                $tmpSelectWhere = 
                    ' p00=:q10Nr01 and'.
                    ' peg_flag!=9 and'.
                    ' peg_mnr01=:q10Nr01'.
                    ' and peg_mmnr01=:peg_mmnr01'.
                    ' and peg_sess_id=:peg_sess_id';

                $tmpSelectWhereArr = array(
                                        'q10Nr01' => $oldNr01, 
                                        'peg_mmnr01' => $mmnr01, 
                                        'peg_sess_id' => session_id()
                                    );
                //Μπορώ να βάλω όλους τους πίνακες σε ένα while γιατί όλες
                //οι συσχετίσεις γίνονται στο table.p00 = q10.nr01                    
                $table_arr = array('q11', 'q12', 'q13', 'q14', 'q15', 'q16');

                //Δεν θα ενημερώσω το query00_q13 γιατί έχει διπλή σύνδεση με q13&q10
                foreach ($table_arr as $table) {
                    query_q10_d_onsave_update_tmp_nr01( $data, 
                                                        $table, 
                                                        'p00', 
                                                        $tmpSelectWhere, 
                                                        $tmpSelectWhereArr);
                }
                
                if(pegasus_module_exists('charts')){
                    //charts_q10.q10 = q10.nr01
                    $table = "charts_q10";
                    $tmpSelectWhere = 
                    ' q10=:q10Nr01 and'.
                    ' peg_flag!=9 and'.
                    ' peg_mnr01=:q10Nr01'.
                    ' and peg_mmnr01=:peg_mmnr01'.
                    ' and peg_sess_id=:peg_sess_id';

                    $tmpSelectWhereArr = array(
                                        'q10Nr01' => $oldNr01, 
                                        'peg_mmnr01' => $mmnr01, 
                                        'peg_sess_id' => session_id()
                    );
                    query_q10_d_onsave_update_tmp_nr01( $data, 
                                                        $table, 
                                                        'q10', 
                                                        $tmpSelectWhere, 
                                                        $tmpSelectWhereArr);
                }
            }

        }
       

    }
    return array($data, $permDeny);
}
/**
 * Η συνάρτηση αυτή θα ενημερώσει το ΜΚ των tmp με βάση το module της αναφοράς
 */
function query_q10_d_onsave_update_tmp_nr01($data, $table, $p20Fld, $tmpSelectWhere, $tmpSelectWhereArr){
    $tmpTable = "peg_tmp_". $table;
    $tmpQuery = " select * from ".$tmpTable. " where ".$tmpSelectWhere;
    //echo pegasus_replace_values_in_sql($tmpQuery, $tmpSelectWhereArr); 

    $tmpRes = pegasus_query($tmpQuery, $tmpSelectWhereArr); 
    $tmpNr01 = pegasus_mysql_module_newrec($table , $data['module_00']); 
    while ($tmpRow = pegasus_fetch_assoc($tmpRes)) {
        pegasus_mysql_update(
            $tmpTable, 
            array('nr01', $p20Fld,  'peg_flag'), 
            array($tmpNr01++, $data['nr01'],  1), 
            $tmpSelectWhere . " and nr01 = :tempRowNr01 ", 
            0, 1, 1, 
            array_merge(array('tempRowNr01' => $tmpRow['nr01']), $tmpSelectWhereArr));
    }
}

function query_q13_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm)
{
    if($data['p02'] === 'def_sql'){
        array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_query_def_sql_deny'])); 
    }
    if(substr($data['p02'], 0 , 14) != 'peg_query_var_'){
        $data['p02'] =  'peg_query_var_' . $data['p02'];
    }
    if(trim($data['p06'])!=false){
        if(substr($data['p06'] , 0 , 1)!='=' and substr($data['p06'] , 0 , 1)!='\'' ){
            array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_query_initial_value_not_valid'])); 
        }
    }

    if($data['p012'] == 1)
    {
        if(empty($data['p07']) || empty($data['p08'])){
            array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_query_multi_without_selection'])); 
        }    
    }

    return array($data, $permDeny);
}


function query_q12_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm)
{
    if($data['p03'] == "nr01"){
        array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_query_nr01_invalid_name'])); 
    }    

    // check if this p03 already exists
    if(pegasus_mysql_printfld(  'q12', 
                                'nr01', 
                                'p00=:p00 AND p03=:p03 AND nr01<>:nr01', 
                                array('p00'=>$data['p00'], 'p03'=>$data['p03'], 'nr01'=>$data['nr01']))>0){
        array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_query_nr01_name_already_exists'])); 
    }

    return array($data, $permDeny);
}

function query_create_q10_d90_screen($q10Nr01, $debug = 0){

    $ok = 1;
    try {
        $q10_d90_handler = new Q10_d90($q10Nr01);
        $q10_d90_handler->create();  
        if($debug){
            //$message =  "Open screen from console: pegAddTab_d('' , '' , 'q10_d90_".$q10Nr01."_d' , 'query', '', '".$q10Nr01."')\n";
            $message = $q10_d90_handler;
        }
    } catch (Exception $ex) {
        //Θα κάνει throw αν π.χ. το nr01 που δόθηκε δεν είναι σωστό.
       $ok = 0;
       $message = $ex->getMessage();
    }
    return  array('ok' => $ok, 'msg' => $message) ;
}

/**
 * @param module Αν δοθεί, φτιάχνονται οι οθόνες μόνο για το συγκεκριμένο module
 */
function query_create_q10_d90_screens($module_00 = '', $query_limit_start = -1, $logfile=''){

    $message = '';
    $ok = 1;
    $has_record = 0;
    if($query_limit_start >= 0 ){
        $query_limit = "limit ". $query_limit_start.", 10";
    }

    if($module_00 == ''){
        $query = "select nr01 from q10 order by nr01 ".$query_limit;
        $res = pegasus_query($query);    
    }
    else{
        $query = "select nr01 from q10 where module_00 = ? order by nr01 ".$query_limit;
        $res = pegasus_query($query, array($module_00));    
    }

	while ($q10 = pegasus_fetch($res)) {  
        $has_record = 1;
        try {
            $q10_d90_handler = new Q10_d90($q10['nr01']);
            $q10_d90_handler->create();  
            $message .= "Created ".$q10_d90_handler->main_screen_name."\n";
            if($logfile != ''){
                $log0 = "Οθόνη Αναφοράς \"".$q10_d90_handler->title."\"";
                peg_write_file( $logfile , $log0);
            }

        } catch (Exception $ex) {

           $message .= $ex->getMessage()."\n";
           if($logfile != ''){
            $log0 = $ex->getMessage();
            peg_write_file( $logfile , $log0); 
           }
           $ok = 0;
        }  
        unset($q10_d90_handler);  
    }

    return  array('ok' => $ok, 'msg' => $message, 'has_record' => $has_record) ;
}

function query_delete_q10_d90_screens($logfile=''){

    $module = 'query';
    $_d = 'q10_d90#_%';

    if($logfile != ''){
        $log0 = "Διαγραφή παραμέτρων πεδίων οθονών αναφοράς</br>";
        peg_write_file( $logfile , $log0);
    }
    pegasus_mysql_delete('p52', 'p02 like ? ESCAPE "#" and module=?', 0, array($_d, $module));
    if($logfile != ''){
        $log0 = "Διαγραφή πεδίων οθονών αναφοράς </br>";
        peg_write_file( $logfile , $log0);
    }
    pegasus_mysql_delete('p51', 'p02 like ? ESCAPE "#" and module=?', 0, array($_d, $module));
    if($logfile != ''){
        $log0 = "Διαγραφή πινάκων οθονών αναφοράς </br>";
        peg_write_file( $logfile , $log0);
    }
    pegasus_mysql_delete('p50', 'p02 like ? ESCAPE "#" and module=?', 0, array($_d, $module));
    
    if($logfile != ''){
        $log0 = "Διαγραφή διακιωμάτων προφιλ οθονών αναφοράς </br>";
        peg_write_file( $logfile , $log0);
    }
    pegasus_mysql_delete('p95p81', 'p81 in (select nr01 from p81 where _d like ? ESCAPE "#" and module=?)', 0, array($_d, $module));
    if($logfile != ''){
        $log0 = "Διαγραφή Toolbar Items οθονών αναφοράς </br>";
        peg_write_file( $logfile , $log0);
    }
    pegasus_mysql_delete('p81', '_d like ? ESCAPE "#" and module=?', 0, array($_d, $module));

}

function query_delete_q10_d90_screen($module, $_d){
    pegasus_mysql_delete('p52', 'p02=? and module=?', 0, array($_d, $module));
    pegasus_mysql_delete('p51', 'p02=? and module=?', 0, array($_d, $module));
    pegasus_mysql_delete('p50', 'p02=? and module=?', 0, array($_d, $module));
    
    pegasus_mysql_delete('p95p81', 'p81 in (select nr01 from p81 where _d=? and module=?)', 0, array($_d, $module));
    pegasus_mysql_delete('p81', '_d=? and module=?', 0, array($_d, $module));
}

function query_remake_q10_d90_nr01(){
    pegasus_mysql_remake_p75('p50');
    pegasus_mysql_remake_p75('p51');
    pegasus_mysql_remake_p75('p52');
    pegasus_mysql_remake_p75('p81');
    pegasus_mysql_remake_p75('p95p81');
}

//Η μεταβλητή constants έχει τις διάφορες σταθερες παραμέτρους για την κάθε οθόνη. 
//Επίτηδες δεν τις περνάω στο data για να έρω ακριβώς τι έχω στο data χωρις να χρειάζεται να δω την κλαση
function query_q10_d90_q10Nr01_initialize(
            $data, 
            $mmnr01 = '', 
            $mnr01 = '', 
            $_d = '', 
            $container_id = '',
            $constants = array()
            ){

    $data['nr01'] = $constants['nr01'];
    $error_msg = query_check_tables_and_priviledges($data['nr01']);
    if(!empty($error_msg)){
        $data['permDeny'] = 1;
        $data['permDenyMessage'] = $error_msg;
        return $data;
    }   

    $data['peg002_q12fld_p07sum'] = $constants['peg002_q12fld_p07sum'];

    $results_tab_name = $constants['results_tab_name'];
    $grouped_results_tab_name = $constants['grouped_results_tab_name'];

    $data['query_'. $results_tab_name.'_grid01_export_pdf_hidden'] = false;
    $data['query_'. $grouped_results_tab_name.'_grid01_export_pdf_hidden'] = false;

    $data['peg002_q10_d90_p85'] = pegasus_mysql_printfld('p85', 'count(nr01)', 'q10=:nr01 ', array('nr01' => $data['nr01']));
    $data['query_'. $results_tab_name.'_grid01_print_report_form_hidden'] = true;
    if ($data['peg002_q10_d90_p85'] >= 1) {
        $data['query_'. $results_tab_name.'_grid01_print_report_form_hidden'] = false;
    }
    $data['query_'. $results_tab_name.'_grid01_export_excel_hidden'] = false;
    $data['query_'. $grouped_results_tab_name.'_grid01_export_excel_hidden'] = false;

    $data['query_'. $results_tab_name.'_grid01_export_csv_hidden'] = false;
    $data['query_'. $grouped_results_tab_name.'_grid01_export_csv_hidden'] = false;

    $data['query_'. $results_tab_name.'_grid01_echo_sql_query_hidden'] = false;
    $data['query_'. $grouped_results_tab_name.'_grid01_echo_sql_query_hidden'] = false;


    $initial_values_global = pegasusGetSuperGlobalVar( 'query_initial_q13_values_'.$data['nr01'].'_'.$_SESSION['username']);
    if(!empty($initial_values_global)){
        $q13_values_arr = $initial_values_global;
    }else{
        $q13_values_arr = query_g13_getInitialValues($data['nr01']);
    }

    $q13_values_arr['dias_main_table'] = '';
     //Είναι η παράμετρος που έρχεται συμπληρωμένη αν ανοίξει π.χ. από τη λίστα κρατήσεων η Αναλυτική καρτέλα κράτησης
    $q13_values_arr['dias_main_nr01'] = 0;
    foreach ($q13_values_arr as $key => $value) {
        if(isset($_REQUEST[$key])){
            $q13_values_arr[$key] = $_REQUEST[$key];
        }
    }
    //Η παράμετρος που είναι το dias_man_nr01
    if(!empty($q13_values_arr['dias_main_table']) && !empty($q13_values_arr['dias_main_nr01'])){
        
        $query = 'SELECT p02 FROM q13 WHERE p00=:p00 and p07=:p07';
        $query_res = pegasus_query($query,array('p00' =>$data['nr01'], 'p07' =>$q13_values_arr['dias_main_table']));

        while($res = pegasus_fetch($query_res)){
            $q13_values_arr[$res['p02']] = $q13_values_arr['dias_main_nr01'];
        }
    }
    else{
        unset($q13_values_arr['dias_main_table']);
        unset($q13_values_arr['dias_main_nr01']);
    }

    foreach ($q13_values_arr as $key => $value) {
        $data[$key] = $value;
    }

    q10_d90_set_global_vars_initialize($container_id, $data['nr01'],  $q13_values_arr);
    return $data;
}

function query_q10_d90_nr01_d100_or_d200_custom_actions($grouped_results_tab_name){
    
    $retArray = array();

    //Removed because of Automatic Creation of Q10 Printing Forms
    // $peg_handler = 'query_q10_d90_export_pdf_handler(screen.getContainer_ID(), "'.$grouped_results_tab_name.'");';
    // $retArray[] = array(
    //     'xtype' => 'pegasusToolBarGridAction',
    //     'peg_custom_id' => 'export_pdf',
    //     'viewModel'     => array(
    //         'type'      => 'GridButtonModel',
    //         'isToolBar' => 1,
    //         'data'      => array(
    //             'toolBarButton' => 'export_pdf'
    //         )
    //     ) ,
    //     'icon' => 'core_images/pdf_16x16.png',
    //     'text' =>$_SESSION['peg_dic_query_export_to_pdf'],
    //     'peghandler' => $peg_handler
    // ); 

    $peg_handler = 'query_q10_d90_print_report_form_pdf_handler(screen.getContainer_ID());';
    $retArray[] = array(
        'xtype' => 'pegasusToolBarGridAction',
        'peg_custom_id' => 'print_report_form',
        'viewModel'     => array(
            'type'      => 'GridButtonModel',
            'isToolBar' => 1,
            'data'      => array(
                'toolBarButton' => 'print_report_form'
            )
        ) ,
        'icon' => 'core_images/prints_16x16.png',
        'text' =>$_SESSION['peg_dic_core_print_forms'],
        'peghandler' => $peg_handler
    ); 

    $peg_handler = 'query_q10_d90_echo_sql_query(screen.getContainer_ID());';
    $retArray[] = array(
        'xtype' => 'pegasusToolBarGridAction',
        'peg_custom_id' => 'echo_sql_query',
        'viewModel'     => array(
            'type'      => 'GridButtonModel',
            'isToolBar' => 1,
            'data'      => array(
                'toolBarButton' => 'echo_sql_query'
            )
        ) ,
        'iconCls' => 'fa-regular fa-file-code',
        'text' => $_SESSION['peg_dic_query_echo_sql_query'],
        'peghandler' => $peg_handler
    ); 

    // $peg_handler = 'query_q10_d90_export_excel_handler(screen.getContainer_ID(), "'.$grouped_results_tab_name.'");';
    // $retArray[] = array(
    //     'xtype' => 'pegasusToolBarGridAction',
    //     'peg_custom_id' => 'export_excel',
    //     'viewModel'     => array(
    //         'type'      => 'GridButtonModel',
    //         'isToolBar' => 1,
    //         'data'      => array(
    //             'toolBarButton' => 'export_excel'
    //         )
    //     ) ,
    //     'icon'=> 'core_images/xls_16x16.png',
    //     'text'=>	$_SESSION['peg_dic_query_export_to_excel'] ,
    //     'peghandler' => $peg_handler
    // ); 

    // $peg_handler = 'query_q10_d90_export_csv_handler(screen.getContainer_ID(), "'.$grouped_results_tab_name.'");';
    // $retArray[] = array(
    //     'xtype' => 'pegasusToolBarGridAction',
    //     'peg_custom_id' => 'export_csv',
    //     'viewModel'     => array(
    //         'type'      => 'GridButtonModel',
    //         'isToolBar' => 1,
    //         'data'      => array(
    //             'toolBarButton' => 'export_csv'
    //         )
    //     ) ,
    //     'icon' => 'core_images/csv_16x16.png',
    //     'text' => $_SESSION['peg_dic_query_export_to_csv']  ,
    //     'peghandler' => $peg_handler
    // ); 

    return $retArray ;
}

/**
 * Η συνάρτηση αυτή σετάρει τις global μεταβλητές
 * π.χ. με τα where των grid που πρέπει
 * α. Να αρχικοποιηθούν
 * β. Να γίνουν refresh με την αναζήτηση
 */
function q10_d90_set_global_vars_initialize($container_id, $nr01, $q13_values_arr)
{
    //Οι αρχικές παράμετροι.
    pegasusSetGlobalVar(
        $container_id . '_initial_q13_values',
            $q13_values_arr
    );
    //Set στα where του multiselectbox
    $query = "select * from q13 where p010 <> '' and p00=?"; 
    $res = pegasus_query($query, array($nr01));
    while ($q13_with_where = pegasus_fetch($res)) {   
        $where= $q13_with_where['p010'];
        $where=trim($where);
        if(strpos($where,'=')===0){
            $where=substr($where,1);
            $where=eval("return $where ;");
        }
        $sql = query_replace_var_brackets($nr01, $where);
        pegasusSetGlobalVar(
            $container_id . '_' . $q13_with_where['nr01'] . '_multi_sql',
            $sql
        );    
    }

    //Set τα fields των charts
    $query = "select * from charts_q10 where q10 = ?";
    $res = pegasus_query($query, array($nr01));
	while ($charts = pegasus_fetch($res)) {
		if ($charts['type'] != 'pie') {
            list($cartesianchart_fields, $cartesianchart_query) = 
            charts__charts_display_cartesian_d_find_fields_and_query($charts['nr01'], $nr01, $q13_values_arr);
            
			pegasusSetGlobalVar(
				$container_id . '_' . $charts['nr01'] . '_fields',
				$cartesianchart_fields
			);
		} else {
			$pie_fields = charts_get_fields($charts);

			pegasusSetGlobalVar(
				$container_id . '_' . $charts['nr01'] . '_fields',
				$pie_fields
			);
		}
	}
}

/**
 * Η συνάρτηση αυτή σετάρει τις global μεταβλητές
 * π.χ. με τα where του grid των αποτελεσμάτων και των charts 
 * που πρέπει να αλλάζουν σε κάθε αναζήτηση
 * Δεν γίνεται εδώ set τo global var για το q10_d902 - αυτό γίνεται set σε ξεχωριστό ajax
 */
function q10_d90_set_global_vars_refresh($container_id, $results_tab_container_id, $nr01, $q13_values_arr)
{    
    $main_grid_query = query_q10_d901_make_grid_query_replace_q13($nr01, $q13_values_arr);
    pegasusSetGlobalVar(
        $results_tab_container_id."_grid01_query",
        $main_grid_query
    );    

    $main_grid_query00 = query_makeQuery00ArrOfReport_replace_q13($nr01, $q13_values_arr,1,$container_id);
    pegasusSetGlobalVar(
        $container_id . '_' . $nr01 . '_query00',
        $main_grid_query00
    );

    $main_grid_query_after = query_makeQueryAfterArrOfReport_replace_q13($nr01, $q13_values_arr,1,$container_id);
    pegasusSetGlobalVar(
        $container_id . '_' . $nr01 . '_query_after',
        $main_grid_query_after
    );
    // echo '<pre>' .print_r(pegasusGetGlobalVar($results_tab_container_id."_grid01_query"), 1). '</pre>';
    // echo '<pre>' .pegasus_replace_values_in_sql($main_grid_query['sql'], $main_grid_query['sqlParams']). '</pre>';
    if(pegasus_displayErrors()){
        // $content = peg_read_file('../../tmp/last_query.sql');
        peg_write_file('../../tmp/last_query.sql',  pegasus_replace_values_in_sql($main_grid_query['sql'], $main_grid_query['sqlParams']) );
    }

    $query = "select * from charts_q10 where q10 = ?";
    $res = pegasus_query($query, array($nr01));
	while ($charts = pegasus_fetch($res)) {
		if ($charts['type'] != 'pie') {
            list($cartesianchart_fields, $cartesianchart_query) = 
            charts__charts_display_cartesian_d_find_fields_and_query($charts['nr01'], $nr01, $q13_values_arr);
			pegasusSetGlobalVar(
				$container_id . '_' . $charts['nr01'] . '_query',
				$cartesianchart_query
			);
		} else {
			$pie_query = charts_get_query($charts);
            $pie_query = query_replace_q13_from_array($nr01, $pie_query, $q13_values_arr);

			pegasusSetGlobalVar(
				$container_id . '_' . $charts['nr01'] . '_query',
				$pie_query
			);
		}
	}
}

function query_q10_d95_custom_actions($retArray = array())
{

    $peg_handler = 'query_q10_d95_fav_reports(screen.getContainer_ID());';
    $retArray[] = array(
        'xtype' => 'pegasusToolBarGridAction',
        'peg_custom_id' => 'favourite_reports',
        'iconCls' => 'fas fa-heart',
        'text' => $_SESSION['peg_dic_query_fav_report'],
        'peghandler' => $peg_handler
    );

    return  $retArray;
}

function query_after_update(){

    pegasus_mysql_use('select rel, ver from p55 where p00="query"', $version);

    if($version['ver']==2 && $version['rel']<=234) {
        $sql = "UPDATE q12 SET p026=p023, remuser='after-update', remdate=curdate(), remtime=curtime();";
        pegasus_query($sql);        

        if(strpos($_SERVER['HTTP_HOST'], 'pegcloud.io')!==false){
            if(function_exists('query_create_q10_d90_screens')){ 
                query_create_q10_d90_screens();
            }
            if(function_exists('query_q10_p85_create')){
                query_q10_p85_create();
            }
        }
    }


    if($version['ver']==2 && $version['rel']<=225) {
        $sql = "    UPDATE q10 
                    SET fav = :fav
                    WHERE fav = '1'
        ";
        $values = array(
            'fav' => pegasus_mysql_printfld('us0',"CONCAT('#',GROUP_CONCAT(DISTINCT p01 SEPARATOR '#'),'#')","p300 = 1")
        );
        pegasus_query($sql,$values);
        $sql = "    UPDATE q10 
                    SET fav = ''
                    WHERE fav = '0'
        ";
        pegasus_query($sql);
    }
    if($version['ver']==2 && $version['rel']<=216){ 
        if(function_exists('query_q10_p85_create')){
            query_q10_p85_create();
        }
    }
    if($version['ver'] == 2 && $version['rel'] <= 146) { 
        //Διαγράφω τα δικαιώματα προφιλ-toolbar item γιατί δεν τα διέγραφα μεχρι τωρα σωστα στη δημιουργία της οθόνης
        pegasus_query('
            DELETE p95p81
            FROM p95p81 
            LEFT JOIN p81 on p81.nr01 = p95p81.p81
            WHERE p81.nr01 is null'
        );	 
    }
    if($version['ver'] == 2 && $version['rel'] <= 172) { 
        if(function_exists('query_create_q10_d90_screens')){ 
            query_create_q10_d90_screens();
        }	 
        if(function_exists('dashboard00_remake_all_dashboard_screens')){
             //Έγιναν κάποιες αλλαγές στο query και πρέπει να ξαναφτιάξω όλες τις dashboard οθόνες
            dashboard00_remake_all_dashboard_screens();
        }
    }
	if (file_exists('../../pegasus_cloud_app/query01/q10_0000.php')) {
		unlink('../../pegasus_cloud_app/query01/q10_0000.php');
	}
    if (file_exists('../../pegasus_cloud_app/query01/q10_0001.php')) {
		unlink('../../pegasus_cloud_app/query01/q10_0001.php');
    }
    if (file_exists('../../pegasus_cloud_app/query01/q10_0002.php')) {
		unlink('../../pegasus_cloud_app/query01/q10_0002.php');
    }
    if (file_exists('../../pegasus_cloud_app/query01/q10_0003.php')) {
		unlink('../../pegasus_cloud_app/query01/q10_0003.php');
    }   
    if (file_exists('../../pegasus_cloud_app/query01/create_pdf.php')) {
		unlink('../../pegasus_cloud_app/query01/create_pdf.php');
    }      
    if (file_exists('../../pegasus_cloud_app/query01/q10_exec_0000.php')) {
		unlink('../../pegasus_cloud_app/query01/q10_exec_0000.php');
    }
    if (is_dir('../../pegasus_cloud_app/query_libs/PHPExcel')){
        query_delete_directory('../../pegasus_cloud_app/query_libs/PHPExcel');
    }
    if (file_exists('../../pegasus_cloud_app/query_libs/PHPExcel.php')) {
		unlink('../../pegasus_cloud_app/query_libs/PHPExcel.php');
    }

}

function query_q10_p85_sql($q10Nr01=-1, $module='', $limit=-1){

    $query_limit = '';
    if($limit>=0){
        $query_limit = " limit ". $limit.", 10";
    }    

    $where      = '1=1';
    $values_arr = array();

    if($q10Nr01>=0){
        $where .= ' and nr01=:nr01 ';  
        $values_arr['nr01'] = $q10Nr01; 
    }

    if(!empty($module)){
        $where .= ' and module_00=:module ';  
        $values_arr['module'] = $module;  
    }
    
    $query = "select * from q10 where " . $where ." order by nr01 " . $query_limit;
    
    return array('sql'=>$query, 'sqlParams'=>$values_arr);
}

function query_q10_p85_create($q10Nr01=-1, $module='', $limit=-1, $logfile=''){
    
    $response = array('ok'=>0, 'msg'=>'', 'has_record'=>false);

    if(!pegasus_module_exists('prints') || !class_exists('PrintsQ10P85')){
        return $response;
    }

    $stm = query_q10_p85_sql($q10Nr01, $module, $limit);
    $res = pegasus_query($stm['sql'], $stm['sqlParams']);


    while ($q10=pegasus_fetch_assoc($res)) {
        $response['has_record'] = true;

        $prints_p85_handler = new PrintsQ10P85($q10['nr01']);
        try {
            $prints_p85_handler->create();
            $response['ok'] = 1;

            $replace_arr = array();
            foreach ($q10 as $key => $value) {
                $replace_arr['##q10_'.$key.'##'] = $value;
            }
            $log0 = $_SESSION['peg_dic_query_q10_p85_create'];
            $log0 = str_replace(array_keys($replace_arr), array_values($replace_arr), $log0);
        }catch(Exception $ex){
            $log0 = $ex->getMessage();
            $response['msg'] .= $ex->getMessage() . "<br>";
        }
    }

    if($response['has_record']==false && !($limit>=0)){
        $response['ok']   = 1;
        $response['msg']  = $_SESSION['peg_dic_query_q10_p85_empty_nr01'];
    }
    
    if($logfile!=''){
        peg_write_file($logfile, $log0);
    }

    return $response;       
}

function query_q10_p85_delete($q10Nr01=-1, $module='', $limit=-1, $logfile=''){

    $response = array('ok'=>0, 'msg'=>'');

    if(!pegasus_module_exists('prints') || !class_exists('PrintsQ10P85')){
        return $response;
    }

    $stm = query_q10_p85_sql($q10Nr01, $module, $limit);
    $res = pegasus_query($stm['sql'], $stm['sqlParams']);

    $p85_nr01_arr = array();
    while ($q10=pegasus_fetch_assoc($res)) {
        $prints_p85_handler = new PrintsQ10P85($q10['nr01']);
        $p85_nr01 = $prints_p85_handler->getP85Nr01();

        if($p85_nr01>0){
            $p85_nr01_arr[] = $p85_nr01;
        }
    }

    if(count($p85_nr01_arr)>0){
        $log0 = $_SESSION['peg_dic_query_q10_p85_delete_all'];

        $in_stmt = pegasus_mysql_create_in($p85_nr01_arr,'nr01');
        pegasus_mysql_delete('p85', 'nr01 in ('.$in_stmt['sql'].')',  0, $in_stmt['sqlParams']);   
        pegasus_mysql_delete('p86', 'p85  in ('.$in_stmt['sql'].')',  0, $in_stmt['sqlParams']);
          
        pegasus_mysql_remake_p75('p85'); 
        pegasus_mysql_remake_p75('p86');
        pegasus_mysql_remake_p75('prints_02');  
    }
    
    if($logfile!=''){
        peg_write_file( $logfile , $log0);
    }

    return $response;
}

function query_q12_get_fields_total_size($q10Nr01, $check=true){

    $values_arr = array('q10nr01'=>$q10Nr01);   
    $query = 'select * from q12 where p00=:q10nr01 and p026=0 order by p05;';
    $res   = pegasus_query($query, $values_arr);

    $total_size = 0;
    while ($q12=pegasus_fetch_assoc($res)) {        
        $total_size += query_q12_get_fields_size($q12, $check);
    }

    return $total_size;
}

function query_q12_get_fields_size($q12, $check=true){
    
    if(strtoupper($q12['p06'])=='L' && $q12['p07']<4 && $check==false){
        $size = 4;
    }elseif(strtoupper($q12['p06'])=='D' && $q12['p07']<10 && $check==false){
        $size = 10;  
    }else{
        $size = $q12['p07'];
    } 

    return $size;
}

function query_delete_directory($dir) {
    if (is_dir($dir)) {
       $files = scandir($dir);
       foreach ($files as $file) {
          if ($file !== '.' && $file !== '..') {
             $filePath = $dir . '/' . $file;
             if (is_dir($filePath)) {
                query_delete_directory($filePath);
             } else {
                unlink($filePath);
             }
          }
       }
       rmdir($dir);
    }
 }
