<?php


/**
 * Δημιουργεί το SQL query απο μια π-Αναφορά
 *
 * @param integer[ 15 ] $nr01			= 0 μανδικός κωδικός της π-Αναφοράς 
 * @param enum {0,1} $tmp			=1 Αν τα δεδομενα θα τα βρεί στους temporary πίνακες 
 * @param integer[ 15 ] $mmnr01		= Αν τα δεδομενα θα τα βρεί στους temporary πίνακες συμπληρώνο εδω το mmnr01
 * @param string $table				= O κεντρικός πίνακας της π-Αναφοράς το αφήνω κενό για να το διαβάσει μέσα απο την π-αναφορά
 * @param enum {0,1} $from_web_site = 1 αν εκτελείται απο το web site. 
 * @param enum {0,1} $from_builder	= 1 αν δεν θα κάνει replace τα tag των πρώτυπων εκφράσεων.
 * @param enum {0,1} $get_main_sql	= 1 αν θέλω να παρω την μη-τροποποιημένη SQL εντολή 
 * @return string Επιστρέφει το query που θα εκετελεστεί στην βάση για την συγκεκριμένη π-Αναφορά.
 * 
 */
function query_make_select($nr01 , $tmp=0 , $mmnr01='' , $table='', $from_web_site=0, $from_builder = 0,$get_main_sql=0 ){
	if(empty($nr01)){
		return '';
	}

	pegasus_mysql_use("select * from q10 where nr01=:nr01 " , $q10, array('nr01'=>$nr01));
	
	$q10_p31 = trim($q10['p31']);
	
	if(!empty($q10_p31) and $from_builder==0 and $get_main_sql==0){	
		$sql = $q10_p31;
		if(function_exists('pegasus_replace_modules_exists_tags')){
			$sql = pegasus_replace_modules_exists_tags($sql);
		}
		$sql = query_replace_def_exeptions($sql, $from_web_site , $from_builder );
		$sql = query_replace_php_where($sql, $nr01, $from_builder);
		$sql = query_replace_view($sql, $nr01);
		/*Καλώ ξανά την query_make_select με $get_main_sql=1 για να πάρω την μη-τροποποιημένη SQL εντολή*/
		$sql = str_replace("{def_sql}",query_make_select($nr01,$tmp,$mmnr01,$table,$from_web_site,$from_builder,1) , $sql);
		$sql = query_replace_lang_tag($sql);
		return $sql;
	}
	
	if(empty($table)){
		$table = $q10['p02'];
		//$table = pegasus_mysql_printfld('q10' , 'p02' , 'nr01=' . $nr01);
	}


	$query_values = array(); //Ο πίνακας αυτός χρησιμοποιείται από όλα τα queries, έχει το nr01 και πιθανόν τα peg_tmp_where
	$query_values['nr01'] = $nr01;
	
	$where_tmp='';
	if($tmp==1){
		$where_tmp = 'and peg_sess_id=:peg_sess_id and peg_flag!=9 and peg_mmnr01=:peg_mmnr01';
		$table_tmp = 'peg_tmp_';
		$query_values['peg_sess_id'] = session_id();
		$query_values['peg_mmnr01'] = $mmnr01;
	}
	

	$sql = '';
	$sql .= "\n select ";

	$query_q12 = 'select q97.exp as q97_exp , '
			.$table_tmp.'q12.* '.
			'from '.$table_tmp.'q12 '.
			'left join q97 on q97.p00='.$table_tmp.'q12.q97 '.
			'where '.$table_tmp.'q12.p00=:nr01 ' .$where_tmp. 
			' order by '.$table_tmp.'q12.p05;';
	

	$res_q12 = pegasus_query($query_q12, $query_values);
	$q12_i=0;
	while ($q12 =pegasus_fetch($res_q12, PEG_FETCH_ASSOC)) {
		$fld = $q12['p02'];
		if(!empty($q12['q97_exp'])){
			$fld = str_replace('{fld}', $fld ,  $q12['q97_exp']  );
		}	
		$q12_i++;
		if($q12_i>1){
			$sql .= ",";		
		}
		$sql .= "\n";
		$sql .= "\t" .$fld . ' as ' .  $q12['p03'] . ' /*' . $q12['p01'] . '*/ ' ;		
		
	}

	
	$sql .= "\n\n from " . $table;
	
	$query_q11 = 'select * from '.$table_tmp.'q11 where p00=:nr01 ' .$where_tmp. ' order by p03;';
	$res_q11 = pegasus_query($query_q11, $query_values);
	$q11_i=0;
	while ($q11 = pegasus_fetch($res_q11, PEG_FETCH_ASSOC)) {
		$q11_i++;
		//	Αν το table name ανήκει view και όχι σε table τότε ΔΕΝ κάνουμε join το view αλλά το SQL του (MySQL performance).
		$is_view = pegasus_mysql_printfld(
			'p50',
			'is_view',
			"p01 = :p01",
			array('p01' => $q11['p01'])
		);
		if($is_view == 1) {
			$view_sql = pegasus_get_view_sql_code($q11['p01']);
			$sql .= "\n";
			$sql .= "\t left join ( $view_sql ) ";

			if(!empty($q11['p04'] )){
				$sql .= ' as ' .  $q11['p04'] ;
			} else {
				$sql .= ' as ' .  $q11['p01'] ;
			}
			

		} else {
			$sql .= "\n";
			$sql .= "\t left join " .$q11['p01'] ;
			if(!empty($q11['p04'] )){
				$sql .= ' as ' .  $q11['p04'] ;
			}
		}
		$sql .= ' on ' . $q11['p02'] .' ' . $q11['p05']  ;		
	}

	$where='';
	
	$query_q16 = 'select * from '.$table_tmp.'q16 where p00=:nr01 ' .$where_tmp. ' order by p05;';
	$res_q16 = pegasus_query($query_q16, $query_values);
	$q16_i=0;
	while ($q16 = pegasus_fetch($res_q16, PEG_FETCH_ASSOC)) {
		$q16_i++;
		if($q16_i>1){
			$where .= ' and ';
		}
		
		$where .= "\n";
		$where .= "\t" .$q16['p01'] . ' ' .  $q16['p02'];
		if($q16['p07']==0){
			if(strtoupper($q16['p02'])=='LIKE'){
				$where .= ' "%' . $q16['p03'] .'%" ' ;		
			}else if(strtoupper($q16['p02'])=='IN' || strtoupper($q16['p02'])=='NOT IN'){
				$q16['p03']  = query_make_select_extra_in_variable($nr01, $q16['p03'] );
				$where .= ' (' . $q16['p03'] .') ' ;	
			}else{
				$where .= ' "' . $q16['p03'] .'" ' ;		
			}
		}elseif ($q16['p07']==1){
			$where .= ' '. $q16['p03'] ;
		}else{
			$where .= ' "##PHPCODE_'.$q16['nr01'].'##" ' ;
		}
	}
	

	if(!empty($where)){
		$sql .= "\n\n where " . $where;
	}
	

	$groupby='';
	
	$query_q15 = 'select * from '.$table_tmp.'q15 where p00=:nr01 ' .$where_tmp. ' order by p05;';
	$res_q15 = pegasus_query($query_q15, $query_values);
	$q15_i=0;
	while ($q15 = pegasus_fetch($res_q15, PEG_FETCH_ASSOC)) {
		$q15_i++;
		if($q15_i>1){
			$groupby .= ' , ';
		}
		
		$groupby .= "\n";
		$groupby .= "\t" .$q15['p02'] . ' '   ;
		
		if(strtoupper($q15['p03'])==2){
			$groupby .= ' desc ' ;		
		}
		$groupby .= ' /*' . $q15['p01'] . '*/ ';
	}
	
	
	if(!empty($groupby)){
		$sql .= "\n\n group by " . $groupby;
	}
	
	
	$orderby='';
	$query_q14 = 'select * from '.$table_tmp.'q14 where p00=:nr01 ' .$where_tmp. ' order by p05;';
	$res_q14 = pegasus_query($query_q14, $query_values);
	$q14_i=0;
	while ($q14 = pegasus_fetch($res_q14, PEG_FETCH_ASSOC)) {
		$q14_i++;
		if($q14_i>1){
			$orderby .= ' , ';
		}
		
		$orderby .= "\n";
		$orderby .= "\t" .$q14['p02'] . ' '   ;
		
		if(strtoupper($q14['p03'])==2){
			$orderby .= ' desc ' ;		
		}
		$orderby .= ' /*' . $q14['p01'] . '*/ ';
	}
	
	
	if(!empty($orderby)){
		$sql .= "\n\n order by " . $orderby;
	}

	 
	$sql = query_replace_php_where($sql , $nr01, $from_builder);
	$sql = query_replace_def_exeptions($sql, $from_web_site, $from_builder );
	$sql = query_replace_lang_tag($sql);
	//die($sql);
	return $sql  ;
}

 /**
  * Με την συνάρτηση αυτή, προσθέτουμε το πρόθεμα in_ πριν από το όνομα 
  * των peg_query_var* Οι μεταβλητές αυτές, θα γίνουν prepare ως in για το pdo 
  * θεωρώντας ότι έχουν χωρισμένες τις τιμές του in μέσα σε # οπως το multiselectbox 
  * π.χ. #1#2#
  * @param mixed $q10_nr01 
  * @param mixed $query_in 
  * @return string|string[] 
  */
function query_make_select_extra_in_variable($q10_nr01, $query_in){

	$query_q13 = 'select * from q13 where p00=:q10_nr01 /*where p012 = 1*/';
    $res_q13 = pegasus_query($query_q13, array('q10_nr01' => $q10_nr01));
    while ($q13 = pegasus_fetch($res_q13)) {
		$query_in = str_replace("{".$q13['p02']."}", "{in_".$q13['p02']."}", $query_in);
	}
	return $query_in;
 }


function query_replace_def_exeptions($sql , $from_web_site=0, $from_builder = 0){
	$array_fields = array();
	$array_values = array();

	if($from_builder == 0){
		$us0_fields = " p01 as us0_p01, p400 as us0_p400, p401 as us0_p401, p402 as us0_p402 ";
		if($from_web_site==0){
			pegasus_mysql_use("select $us0_fields from us0 where us0.p01 = ? ", $us0_tmp_array, array($_SESSION['username']));
			//array_push($array_fields, '{us0_p01}');array_push($_SESSION['username'], '{us0_p01}');
			array_push($array_fields, '{d00_nr01}');array_push($array_values , $_SESSION['user_d00nr01']);
		}else{
			if($_SESSION['z30nr']>0){
				pegasus_mysql_use("select $us0_fields from us0 where us0.p302 = ? ", $us0_tmp_array, array($_SESSION['z30nr']));
				//$sql = str_replace('{us0_p01}'  , pegasus_mysql_printfld('us0' , 'p01' , 'p302=' . $_SESSION['z30nr'])  , $sql);
				$sql = str_replace('{d00_nr01}' , $_SESSION['z30nr']     , $sql);
			}
		}
		//Kanei replaceola ta pedia toy xristi
		foreach ($us0_tmp_array as $key => $value) {
			array_push($array_fields, '{'.$key.'}');array_push($array_values , $value);
		}
		
		array_push($array_fields, '{pegasus_client_uid}'); array_push($array_values,$_SESSION['pegasus_client_uid']);
		array_push($array_fields, '{user_profile}'); 		array_push($array_values,$_SESSION['user_profile']);
		array_push($array_fields, '{lang}');array_push($array_values , $_SESSION['lang']);
	}
	
	return str_replace($array_fields  , $array_values, $sql);
}

function query_replace_php_where($sql , $nr01, $from_builder = 0){
	$array_fields = array();
	$array_values = array();
	if($from_builder == 0){
		//Panta ta dedomena einai ston q16 gt ekteleite mono otan den eimai ston builder
		$query_q16 = 'select * from q16 where p00=:nr01 and p07=2 order by p05;';
		$res_q16 = pegasus_query($query_q16, array('nr01' => $nr01));
		
		while ($q16 = pegasus_fetch($res_q16, PEG_FETCH_ASSOC)) {
			array_push($array_fields, "##PHPCODE_".$q16['nr01']."##");
			array_push($array_values , eval( $q16['p03'] ));
		}
	}
	
	return str_replace($array_fields  , $array_values, $sql);
}

function query_replace_view($sql, $nr01){

	$array_fields = array();
	$array_values = array();

	//Εύρεση όλων των views
	$query   = "select p01, p02 from p50 where is_view=1 and p32!='';";
	$result  = pegasus_query($query);
	$p50_arr = pegasus_fetchall($result);

	foreach ($p50_arr as $p50) {
		if(strpos($sql, '{view_query_'.$p50['p01'].'}')!==false){
			$view_sql = pegasus_get_view_sql_code($p50['p01']);

			array_push($array_fields, '{view_query_'.$p50['p01'].'}');
			array_push($array_values, $view_sql);
		}
	}
	
	return str_replace($array_fields, $array_values, $sql);
}
	
/**
 * Η συνάρτηση αυτή κάνει append ένα Child sto element
 * σε συνδιασμό του  $datarow
 * @param DOMDocument $dom
 * @param DOMElement $element
 * @param array $structData array(array('fldtype', 'xmltag'))
 * @param array $data array($structData['xmltag'])
 */
function query_xml_dom_appendChild(&$dom,&$element, &$structData, &$datarow){
	if(function_exists("pegasus_xml_dom_appendChild")){
		return pegasus_xml_dom_appendChild($dom,$element, $structData, $datarow);
	}
	foreach ($structData as  $data){
		if($data['fldtype']=='L' || $data['fldtype']=='N'){
			if($data['xmltag']=='nr01'){
				$element->setAttribute('id', $datarow[$data['xmltag']] );
			}
			$datatmp = $dom->createElement($data['xmltag'],$datarow[$data['xmltag']]);
		}else if($data['fldtype']=='C' || strtoupper($data['fldtype'])=='D' ||  $data['fldtype']=='M'){
			$datatmp = $dom->createElement($data['xmltag']);
			$newnode = $dom->createCDATASection($datarow[$data['xmltag']]);
			$datatmp->appendChild($newnode);
		}else{

			continue;
		}
		if($datatmp instanceof DOMNode)
			$element->appendChild($datatmp);
	}
}
/**
 * Ennhmervwnei to pedio toy table me to stuct toy pinaka poy einai sto kleidi
 * @param array $tablesStructure
 */
function query_getStructure(&$tablesStructure){
	foreach ($tablesStructure as $key => &$value){
		$queryP51_d = " select ".
				" p51.desc05 as xmltag, p51.desc16 as fldtype " .
				" from p51 ".
				" join p60 on p60.p00 = p51.desc16 and isdbfld=1 ".
				" where ".
				" p51.p02 = :tab_d  ".
				" order by desc06 ";
		//echo $queryP51_d;
		$resP51_d = pegasus_query($queryP51_d, array('tab_d' => $key."_d") );
		while ($row = pegasus_fetch_assoc($resP51_d)) {
			$value['strct'][] = $row;
		}
		if(is_array($value['relations'])){
			query_getStructure($value['relations']);
		}
	}
}

/**
 * @return string query
 */
function query_replace_q13_from_array($q10_nr01, $query, $q13_values = array()){

    $query_q13 = 'select * from q13 where p00=:q10_nr01 order by p05;';
    $res_q13 = pegasus_query($query_q13, array('q10_nr01' => $q10_nr01));
	$init_q13=query_g13_getInitialValues($q10_nr01);
    while ($q13 = pegasus_fetch($res_q13)) {
        $varType = $q13['p03'];
		$varName = $q13['p02'];

		/**Format values*/
		if(!isset($q13_values[$varName])){
			$q13_values[$varName]=$init_q13[$varName];
		}
		if ($varType == 'D') { 
			$q13_values[$varName] = substr($q13_values[$varName], 0, 10);
		} 
		else if ($varType == 'L') {
            if ($q13_values[$varName] == 'true') {
				$q13_values[$varName] = 1;
            } elseif ($q13_values[$varName] == 'false') {
                $q13_values[$varName] = 0;
            } 
		}
		if(strpos($query, '{in_' . $varName . '}')!== false){
			$temp_value = trim($q13_values[$varName], '#');
			// var_dump($temp_value);
			if($temp_value === '0' || !empty($temp_value)){
				$temp_value_arr = explode("#", $temp_value);
				$temp_in_arr = pegasus_mysql_create_in($temp_value_arr, "_".$varName);
				$query = str_replace('{in_' . $varName . '}', $temp_in_arr['sql'] , $query);
				$q13_values = array_merge($q13_values, $temp_in_arr['sqlParams']);
			}
			else{
				$query = str_replace('{in_' . $varName . '}', 'NULL' , $query);
			}
		
		}

		$count = null;
		/**Replace in query*/
		$query = str_replace('"%{' . $varName . '}%"',  ':' . "_like_1_".$varName , $query, $count);
		if($count > 0 ){
			$q13_values["_like_1_".$varName] = "%" . $q13_values[$varName] ."%";
		}
		$count = null;
		$query = str_replace('\'%{' . $varName . '}%\'',  ':' . "_like_2_" . $varName , $query, $count);	
		if($count > 0 ){
			$q13_values["_like_2_".$varName] = "%" . $q13_values[$varName] ."%";
		}
		$count = null;
		$query = str_replace('"%{' . $varName . '}"',  ':' . "_like_3_".$varName , $query, $count);
		if($count > 0 ){
			$q13_values["_like_3_".$varName] = "%" . $q13_values[$varName];
		}
		$count = null;
		$query = str_replace('\'%{' . $varName . '}\'',  ':' . "_like_4_" . $varName , $query, $count);	
		if($count > 0 ){
			$q13_values["_like_4_".$varName] = "%" . $q13_values[$varName] ;
		}
		$count = null;
		$query = str_replace('"{' . $varName . '}%"',  ':' . "_like_5_".$varName , $query, $count);
		if($count > 0 ){
			$q13_values["_like_5_".$varName] =  $q13_values[$varName] ."%";
		}
		$count = null;
		$query = str_replace('\'{' . $varName . '}%\'',  ':' . "_like_6_" . $varName , $query, $count);	
		if($count > 0 ){
			$q13_values["_like_6_".$varName] =  $q13_values[$varName] ."%";
		}


		$varInQuery = false;
		//If not in query, I will have to unset it from the array 
		//Else -> PDO Exception -> Invalid parameter number: number of bound variables does not match number of tokens 
		$count = null;
		$query = str_replace('"{' . $varName . '}"',  ':' . $varName , $query, $count);
		if($count > 0 ){
			$varInQuery = true;
		}
		$count = null;
		$query = str_replace('\'{' . $varName . '}\'',  ':' . $varName , $query, $count);
		if($count > 0 ){
			$varInQuery = true;
		}
		$count = null;
		$query = str_replace('{' . $varName . '}',  ':' . $varName , $query, $count);
		if($count > 0 ){
			$varInQuery = true;
		}
		if(!$varInQuery){
			unset($q13_values[$varName]);
		}

	}

	return array('sql' => $query, 'sqlParams' => $q13_values);
}



//TODO: Την έβααλ προς το παρον για το where με τα $data στο combobox
//όταν φτιάξω την query_replace_q13_from_array να την σβησω
function query_replace_var_brackets($q10_nr01, $query){

	$query_q13 = 'select * from q13 where p00=:q10_nr01 order by p05;';
    $res_q13 = pegasus_query($query_q13, array('q10_nr01' => $q10_nr01));
    while ($q13 = pegasus_fetch($res_q13)) {
		$varName = $q13['p02'];
		$query = str_replace('"{' . $varName . '}"',  ':' . $varName , $query);
		$query = str_replace('\'{' . $varName . '}\'',  ':' . $varName , $query);
		$query = str_replace('{' . $varName . '}',  ':' . $varName , $query);

	}
	return $query;
}


/**
 *	@param q10_nr01 
 *  @return array with the initial values of the params after evaluation
 */
function query_g13_getInitialValues($q10_nr01)
{
	$q13_values_array = array();
	$query_q13 = 'select * from q13 where p00=:q10_nr01 order by p05 ';
    $res_q13 = pegasus_query($query_q13, array('q10_nr01' => $q10_nr01));
    while ($q13 = pegasus_fetch($res_q13, PEG_FETCH_ASSOC)) {
		$varType = $q13['p03'];
		if ($varType == 'L' && empty($q13['p06'])) {
			$q13_values_array[$q13['p02']] = '0';
		}
		else{
			$q13_values_array[$q13['p02']] = query_g13_getValFromExpression($q13['p06']);
		}
		
    }
	return $q13_values_array;
}

/**
 * 
 * @param mixed $q10_nr01 
 * @param bool $if_not_set_get_initial 
 * @return array 
 */
function query_q13_getValuesFromRequest($q10_nr01, $if_not_set_get_initial = false){

	if($if_not_set_get_initial){
		$initialValues = query_g13_getInitialValues($q10_nr01);
	}

	$q13_values_arr = array();
	$query_q13 = 'select * from q13 where p00=:q10_nr01 order by p05 ';
	$res_q13 = pegasus_query($query_q13, array('q10_nr01' => $q10_nr01));
	while ($q13 = pegasus_fetch($res_q13, PEG_FETCH_ASSOC)) {
		$q13_values_arr[$q13['p02']] = $_REQUEST[$q13['p02']];
		if($if_not_set_get_initial && !isset($_REQUEST[$q13['p02']])){
			$q13_values_arr[$q13['p02']] = $initialValues[$q13['p02']];
		}
		if(strtoupper($q13['p03'])=='D' ){
			if(empty($q13_values_arr[$q13['p02']])){
				$q13_values_arr[$q13['p02']] = '0100-01-01';
			}
		}

	}
	return $q13_values_arr;
}

/**
 * Η συνάρτηση αυτή, γυρνάει ένα array από array('sql', 'sqlParams') για όλα τα queries που πρέπει να εκτελεστούν 
 * πριν από το κεντρικό query. Η μορφή αυτή, είναι και αυτή που διαβάζει το griddata
 * @param mixed $nr01 
 * @param mixed $q13_values_arr 
 * @return array 
 */
function query_makeQuery00ArrOfReport_replace_q13($nr01, $q13_values_arr=array(), $execute=1,$container_id=''){

    $query00_str = pegasus_mysql_printfld('q10', 'p34', 'nr01=:nr01', array('nr01' => $nr01));
    $query00_arr = array();

	
    if (!empty($query00_str)) {
        $query00 = explode(';', $query00_str);
        for ($i = 0; $i < count($query00); $i++) {
            if(trim($query00[$i]) != ''){
                //Θέλει και το ; για να τρέξει από το grddata
                $query00_tmp = query_replace_q13_from_array($nr01, $query00[$i].";", $q13_values_arr);
				$query00_tmp = query_replace_lang_tag($query00_tmp);
				$query00_tmp = query_replace_container_id_tag($query00_tmp,$container_id);
                $query00_arr[] = $query00_tmp;
                if($execute){
                    pegasus_query($query00_tmp['sql'], $query00_tmp['sqlParams']);
                }
            }
        }
    }

    return $query00_arr;
}

/**
 * Η συνάρτηση αυτή, γυρνάει ένα array από array('sql', 'sqlParams') για όλα τα queries που πρέπει να εκτελεστούν 
 * μετά από το κεντρικό query. Η μορφή αυτή, είναι και αυτή που διαβάζει το griddata
 * @param mixed $nr01 
 * @param mixed $q13_values_arr 
 * @return array 
 */
function query_makeQueryAfterArrOfReport_replace_q13($nr01, $q13_values_arr=array(), $execute=1,$container_id=''){

    $query_after_str = pegasus_mysql_printfld('q10', 'p35', 'nr01=:nr01', array('nr01' => $nr01));
    $query_after_arr = array();

	
    if (!empty($query_after_str)) {
        $query_after = explode(';', $query_after_str);
		// var_dump($query_after);
        for ($i = 0; $i < count($query_after); $i++) {
            if(trim($query_after[$i]) != ''){
                //Θέλει και το ; για να τρέξει από το grddata
                $query_after_tmp = query_replace_q13_from_array($nr01, $query_after[$i].";", $q13_values_arr);
				$query_after_tmp = query_replace_lang_tag($query_after_tmp);
				$query_after_tmp = query_replace_container_id_tag($query_after_tmp,$container_id);
                $query_after_arr[] = $query_after_tmp;
                if($execute){
                    pegasus_query($query_after_tmp['sql'], $query_after_tmp['sqlParams']);
                }
            }
        }
    }

    return $query_after_arr;
}
/** Φέρνει όλα τα Stores εφόσον ειναι το module ενεργο
 * 
 */
function query_get_all_stores_multi()
{
	if (pegasus_module_exists("stores")) {
		return peg_stores_get_all_stores_multi();
	} 
	return "##";

}
//TODO PDO
/**
 * @deprecated
 */
function query_g13_getVal($varName, $varValue){ 
    if(isset($_REQUEST[$varName])){
        return $_REQUEST[$varName];
    }
	return query_g13_getValFromExpression($varValue);
}
function query_g13_getValFromExpression($varValue){ 
	$peg_vval = null;
    if(substr($varValue , 0 , 1)==='='){
		try {
			eval('$peg_vval = ' . substr($varValue,1) . ';');
		} catch (\Throwable $th) {
			$error = "Expression: " . $varValue . "\n" . $th->getMessage();
			pegasus_make_log_file($error);	
		}
       
    }else{
        if(substr($varValue, 0,1) === "'" ){
			try {
				eval('$peg_vval = ' . $varValue . ' ;');
			} catch (\Throwable $th) {
				$error = "Expression: " . $varValue . "\n" . $th->getMessage();
				pegasus_make_log_file($error);	
			}
            
        }else{
            $peg_vval  = $varValue;
        }
    }
    return $peg_vval;
}
// Replace to {session_lang}
function query_replace_lang_tag($query00_tmp){

	if(is_string($query00_tmp) && strpos($query00_tmp,'{session_lang}')!==false){
		$query00_tmp = str_replace('{session_lang}',$_SESSION['lang00'],$query00_tmp);
	}
//var_dump($query00_tmp);
	return $query00_tmp;
}
// Replace to {container_id}
function query_replace_container_id_tag($query00_tmp,$container_id){

	if(is_string($query00_tmp) && strpos($query00_tmp,'{container_id}')!==false){
		$query00_tmp = str_replace('{container_id}',$container_id,$query00_tmp);
	}
//var_dump($query00_tmp);
	return $query00_tmp;
}
