<?php

class Q10_d90
{
    public $nr01;
    public $title;
    public $module_00;
    public $screens_arr;
    public $toolbar_items;
    public $profiles_that_can_read;

    public $main_screen_name;
    public $results_tab_name;
    public $results_screen_name;
    public $grouped_results_tab_name;
    public $charts_prefix_name;

    //Το άθροισμα των χαρακτήρων των στηλών
    public $peg002_q12fld_p07sum = 0;
    public $has_grouped_results = false;
    public $has_charts = false;


    public function __construct($q10_n01)
    {

        $this->nr01 = $q10_n01;
        $this->screens_arr = array();
        $this->toolbar_items = array();
        $this->profiles_that_can_read = array();

        $this->initilialize_params();

        //Από τον q12 - Αποτελέσματα αναφοράς
        $this->newResultsScreen();

        //Η σειρά έχει σημασία, θέλω 1.charts, 2.Ομαδοποιημένα, 3.Αποτελέσματα.
        //Οθόνες charts
        if ($this->has_charts) {
            $this->newChartsScreens();
        }

        //Ομαδοποιημένα αποτελέσματα
        if ($this->has_grouped_results) {
            $this->newGroupedResultsGrid();
        }

        //Το grid των αποτελεσμάτων
        $this->newResultsGrid();

        //Η βασική οθόνη
        $main_screen = $this->newMainScreen();

        $tab = $this->newResultsTabs();
        $main_screen->addElement($tab); //Το tab είναι element της main_screen

        $this->addSmeToolbarItems();
    }

    public function create()
    {
        foreach ($this->screens_arr as $type => $el) {
            $el->create();
        }

        foreach ($this->toolbar_items as $type => $item) {
            $item->create();
        }
    }

    public function delete(){
        foreach ($this->screens_arr as $type => $el) {
            $el->deleteOldScreen();
        }      
    }

    /**
     * Η συνάρτηση αυτή υπολογίζει τις παραμέτρυς που θα χρειαστούν για την αρχικοποίηση των οθονων 
     * π.χ. υπολογίζει το άθροισμα των χαρακτήρων των στηλών για να ξερει ποια φόρμα θα χρησιμοποιήσει στο PDF
     */
    private function initilialize_params()
    {
        $this->main_screen_name = "q10_d90_" . $this->nr01 . "_d";

        $this->results_tab_name = "q10_d90_" . $this->nr01 . "_d100";
        $this->grouped_results_tab_name = "q10_d90_" . $this->nr01 . "_d200";

        $this->results_screen_name = "q10_d90_" . $this->nr01 . "_d101";

        $this->charts_prefix_name =  "q10_d90_" . $this->nr01 . "_d5";

        pegasus_mysql_use('select * from q10 where nr01 = ?', $q10, array($this->nr01));
        if (!($q10['nr01'] > 0)) {
            throw new Exception('nr01 check failed');
        }

        $this->title = $q10['p01'];
        $this->module_00 = $q10['module_00'];

        $this->peg002_q12fld_p07sum = pegasus_mysql_printfld(
            'q12',
            'sum(p07)',
            ' p023=0 and p00=:nr01 ',
            array('nr01' => $this->nr01)
        );

        if ($q10['groupfield'] != '') {
            $this->has_grouped_results = true;
        }

        $charts_count = pegasus_mysql_printfld('charts_q10', 'count(*)', 'q10=?', array($this->nr01));
        if ($charts_count > 0) {
            $this->has_charts = true;
        }

        $query = 'select * from p95';
        $res = pegasus_query($query);
        while ($p95 = pegasus_fetch($res, PEG_FETCH_ASSOC)) {
           if(peg_query_canProfileRead($this->nr01, $p95['nr01'])){
                array_push($this->profiles_that_can_read, $p95['nr01']);
           }
        }

    }


    private function addScreen($element, $type)
    {
        $this->screens_arr[$type] = $element;
    }

    private function newMainScreen()
    {
        $mainScreenHandler =  new Q10_d90MainScreen($this);
        $screen = $mainScreenHandler->create_main_screen_object();
        $this->addScreen($screen, $this->main_screen_name);
        return $screen;
    }

    private function newResultsTabs()
    {
        $tab = new Core00Tab(
            "tab",
            "tab",
            "tab"
        );

        $items_array_php = '$disabled = false;' . "\n";
        $items_array_php .= '$arr1 = array();' . "\n";

        foreach ($this->screens_arr as $name => $value) {
            //Στο tab δεν θα πρέπει να προστεθούν οι οθόνες του τελικού αποτελέσματος και η main screen
            if ($name == $this->main_screen_name || $name == $this->results_screen_name) {
                continue;
            }
            $items_array_php .= 'array_push($arr1, array("_d" => "' . $name . '", "disabled" => $disabled, "load_on_render" => 1));' . "\n";
        }
        $items_array_php .= 'return peg002_create_tab_items_array($arr1, $container_id, $module, $_d, $table, $nr01);' . "\n";

        $tab->addP52(
            "items_array",
            array(
                "code" => 1,
                'par_val' => $items_array_php
            )
        );
        $tab->addP52("flex", array('par_val' =>  "1"));
        return $tab;
    }

    private function newChartsScreens()
    {
        $charts_query = " select * from charts_q10 where q10 = :q10_nr01 order by tax ";
        $charts_res = pegasus_query($charts_query, array('q10_nr01' => $this->nr01));
        $i = 0;
        while ($charts_row = pegasus_fetch($charts_res, PEG_FETCH_ASSOC)) {

            $name = $this->charts_prefix_name . $i++;
            $screen = new Core00Screen(
                $name,
                "query",
                $charts_row['p01'],
                $charts_row['ep01']
            );

            if ($charts_row['type'] == 'pie') {
                $element = new Core00Pie(
                    $charts_row['p01'],
                    $charts_row['ep01'],
                    'pie'
                );
                $element->addP52(
                    "angularaxis",
                    array('par_val' =>  $charts_row['angularaxis'])
                );
                $element->addP52(
                    "seriesLabel",
                    array('par_val' =>  $charts_row['label'])
                );
            } else {
                $element = new Core00Cartesian(
                    $charts_row['p01'],
                    $charts_row['ep01'],
                    'cartesianchart'
                );

                $axes =
                    'list($axes, $series) = charts__charts_display_cartesian_d_find_series_and_axes(\'' . $charts_row['nr01'] . '\', \'' . $this->nr01 . '\');' . "\n" .
                    'return $axes;';
                $series =
                    'list($axes, $series) = charts__charts_display_cartesian_d_find_series_and_axes(\'' . $charts_row['nr01'] . '\', \'' . $this->nr01 . '\');' . "\n" .
                    'return $series;';
                $element->addP52("axes", array('par_val' =>  $axes, 'code' => 1));
                $element->addP52("series", array('par_val' =>   $series, 'code' => 1));
            }

            $fields = 'return pegasusGetGlobalVar( pegasus_container_id_get_parentBy_d($container_id , \'' . $this->main_screen_name . '\') . \'_' . $charts_row['nr01'] . '_fields\');';
            $query = 'return pegasusGetGlobalVar( pegasus_container_id_get_parentBy_d($container_id , \'' . $this->main_screen_name . '\') . \'_' . $charts_row['nr01'] . '_query\');';
            $element->addP52("fields", array('par_val' => $fields, 'code' => 1));
            $element->addP52("query", array('par_val' => $query, 'code' => 1));

            $element->addP52("disable_auto_load_store", array('par_val' =>  'true'));

            $screen->addElement($element);

            $this->addScreen($screen, $name);
        }
    }


    private function newResultsGrid()
    {
        pegasus_mysql_use("select * from p82 where p00='query_panafores_results'", $p82);
        $screen = new Core00Screen(
            $this->results_tab_name,
            "query",
            $p82['p01'],
            $p82['ep01']
        );
        pegasus_mysql_use("select * from q10 where nr01 = ? ", $q10, array($this->nr01));
        $element = new Core00Grid('Aποτελέσματα', 'Results', 'grid01');
        $element->addP52("_d", array('par_val' => $this->results_screen_name));
        $element->addP52("module", array('par_val' =>  "query"));
        $element->addP52("summary_en", array('par_val' =>  "1"));
        $element->addP52("table", array('par_val' =>  $q10['p02']));
        $element->addP52("record_search", array('par_val' =>  'def'));
        $element->addP52("disable_auto_load_store", array('par_val' =>  "true"));

        $element->addP52(
            "query",
            array(
                'code' => 1,
                'par_val' =>
                'return pegasusGetGlobalVar( $container_id."_grid01_query" );'
            )
        );

        $element->addP52(
            "query00",
            array(
                'code' => 1,
                'par_val' =>
                'return pegasusGetGlobalVar( pegasus_container_id_get_parentBy_d($container_id , \'' . $this->main_screen_name . '\').\'_' . $this->nr01 . '_query00\' );'
            )
        );

        $element->addP52(
            "query_after",
            array(
                'code' => 1,
                'par_val' =>
                'return pegasusGetGlobalVar( pegasus_container_id_get_parentBy_d($container_id , \'' . $this->main_screen_name . '\').\'_' . $this->nr01 . '_query_after\' );'
            )
        );

        $element->addP52(
            "record_custom_actions",
            array(
                'code' => 1,
                'par_val' =>
                'return query_q10_d90_nr01_d100_or_d200_custom_actions("' . $this->grouped_results_tab_name . '");'
            )
        );
        //$element->addP52("preventHeader",  array('par_val' => 'true'));
        $element->addP52("record_refresh",  array('par_val' => 'def'));
        $element->addP52("record_export",   array('par_val' => 'def_tablet'));
        // $element->addP52("record_mng_col",  array('par_val' => 'def'));



        $screen->addElement($element);

        $this->addScreen($screen, $this->results_tab_name);
    }

    private function newGroupedResultsGrid()
    {
        pegasus_mysql_use("select * from p82 where p00='query_panafores_grouped_results'", $p82);
        $screen = new Core00Screen(
            $this->grouped_results_tab_name,
            "query",
            $p82['p01'],
            $p82['ep01']
        );

        $grouped_chars_sum = new Core00Numberbox('Άθροισμα Στηλών', 'Column Sum', 'grouped_q12_sum');
        $grouped_chars_sum->addP52("hidden", array('par_val' =>  "2"));
        $screen->addElement($grouped_chars_sum);

        $element = new Core00Grid('Aποτελέσματα', 'Results', 'grid01');
        $element->addP52("module", array('par_val' =>  "query"));
        $element->addP52("disable_auto_load_store", array('par_val' =>  "true"));
        $element->addP52("summary_en", array('par_val' =>  "1"));

        $element->addP52(
            "grid_fields",
            array(
                'code' => 1,
                'par_val' =>
                'return pegasusGetGlobalVar($container_id.\'_q10_d902_grid_fields\' );'
            )
        );
        $element->addP52(
            "query",
            array(
                'code' => 1,
                'par_val' =>
                'return pegasusGetGlobalVar( $container_id.\'_q10_d902_grid_query\' );'
            )
        );
        $element->addP52(
            "query00",
            array(
                'code' => 1,
                'par_val' =>
                'return pegasusGetGlobalVar( pegasus_container_id_get_parentBy_d($container_id , \'' . $this->main_screen_name . '\').\'_' . $this->nr01 . '_query00\' );'
            )
        );
        $element->addP52(
            "query_after",
            array(
                'code' => 1,
                'par_val' =>
                'return pegasusGetGlobalVar( pegasus_container_id_get_parentBy_d($container_id , \'' . $this->main_screen_name . '\').\'_' . $this->nr01 . '_query_after\' );'
            )
        );
        $element->addP52(
            "title_array",
            array(
                'code' => 1,
                'par_val' =>
                'return pegasusGetGlobalVar( pegasus_container_id_get_parentBy_d($container_id , \'' . $this->main_screen_name . '\').\'_q10_d902_grid_titles\' );'
            )
        );

        $element->addP52(
            "record_custom_actions",
            array(
                'code' => 1,
                'par_val' =>
                'return query_q10_d90_nr01_d100_or_d200_custom_actions("' . $this->grouped_results_tab_name . '");'
            )
        );

        $element->addP52("record_refresh",  array('par_val' => 'def'));
        $element->addP52("record_export",   array('par_val' => 'def_tablet'));

        $screen->addElement($element);

        $this->addScreen($screen, $this->grouped_results_tab_name);
    }
    private function newResultsScreen()
    {
        $name = $this->results_screen_name;
        pegasus_mysql_use("select * from p82 where p00='query_panafores_results'", $p82);
        $screen = new Core00Screen(
            $name,
            "query",
            $p82['p01'],
            $p82['ep01']
        );

        $query_q12 = 'select * from q12 where p00=:nr01 order by p05;'; //Όλα τα πεδία της π-Αναφοράς
        $res_q12 = pegasus_query($query_q12, array('nr01' => $this->nr01));
        while ($q12 = pegasus_fetch($res_q12, PEG_FETCH_ASSOC)) {
            $browseIndex = ($q12['p023'] == 1) ? -1 : $q12['p05'];
            switch (strtoupper($q12['p06'])) {
                case 'N':
                   // die('373');
                    $element = new Core00Numberbox(
                        $q12['p01'], //Τίτλος
                        $q12['ep01'], //Αγγλικός τίτλος
                        $q12['p03'],  //Όνομα πεδίου
                        $browseIndex, //Διαδοχή
                        $q12['p07'], //Μέγεθος
                        $q12['p08'],  //Δεκαδικά
                        false, //variable
                        $browseIndex //propertyBrowseIndex

                    );
                    break;
                case 'C':
                    $element = new Core00Textbox(
                        $q12['p01'], //Τίτλος
                        $q12['ep01'], //Αγγλικός τίτλος
                        $q12['p03'],  //Όνομα πεδίου
                        $browseIndex, //Διαδοχή
                        $q12['p07'], //Μέγεθος
                        0,
                        false,
                        $browseIndex
                    );
                    break;
                case 'M':
                    $element = new Core00Textbox(
                        $q12['p01'], //Τίτλος
                        $q12['ep01'], //Αγγλικός τίτλος
                        $q12['p03'],  //Όνομα πεδίου
                        $browseIndex, //Διαδοχή
                        $q12['p07'], //Μέγεθος
                        0,
                        false,
                        $browseIndex
                    );
                    break;
                case 'L':
                    $element = new Core00Checkbox(
                        $q12['p01'], //Τίτλος
                        $q12['ep01'], //Αγγλικός τίτλος
                        $q12['p03'],  //Όνομα πεδίου
                        $browseIndex, //Διαδοχή
                        1, //Μέγεθος
                        0,
                        false,
                        $browseIndex

                    );
                    break;
                case 'D':
                    $element = new Core00Datebox(
                        $q12['p01'], //Τίτλος
                        $q12['ep01'], //Αγγλικός τίτλος
                        $q12['p03'],  //Όνομα πεδίου
                        $browseIndex, //Διαδοχή
                        $q12['p07'], //Μέγεθος
                        0,
                        false,
                        $browseIndex
                    );
                    break;
                default:
                    break;
            }
            if ($element) {
                if ($q12['lockedcolumn'] == 1) {
                    $element->addP52("browse_locked",  array('par_val' => "1"));
                }
                if ($q12['p022'] == 1) {
                    $element->addP52("browse_summaryType",  array('par_val' => "sum"));
                }
                if ($q12['p023'] == 1) {
                    $element->addP52("browse_summaryType",  array('par_val' => "sum"));
                }
                $screen->addElement($element);
                unset($element);
            }
        }
        $this->addScreen($screen, $name);
    }

    private function addSmeToolbarItems()
    {
        $fn  = 'sme_q10_d90_' . $this->nr01 . '_add_toolbars';
        if (function_exists($fn)) {
            $toolbars_arr = $fn();
        }

        foreach ($toolbars_arr as $item) {
            if (!is_array($item)) {
                return;
            }
            $this->addToolbarItem($item);
        }
    }
    public function addToolbarItem($item)
    {

        $item['_d'] = $this->main_screen_name;
        $item['module'] = 'query';
        $toolbar = new Core00Toolbar($item);
        $toolbar->setProfilesWithPrivilege($this->profiles_that_can_read);
        array_push($this->toolbar_items, $toolbar);
    }
}


/**
 * Η συνάρτηση αυτή απλά φτιάχνει το 
 * object της main Screen και το γυρνάει πίσω
 * Παίρνει σαν όρισμα την Q10_D90
 */
class Q10_d90MainScreen
{

    private $q10_d90;
    private $screen;
    public function __construct($Q10_D90)
    {
        $this->q10_d90 = $Q10_D90;
    }
    public function create_main_screen_object()
    {
        //Η βασική οθόνη
        $name = $this->q10_d90->main_screen_name;
        pegasus_mysql_use("select * from p82 where p00='query_screen_title'", $p82);
        pegasus_mysql_use("select p01, ep01 from q10 where nr01 = ?", $q10, array($this->q10_d90->nr01));
        $this->screen = new Core00Screen(
            $name,
            "query",
            $p82['p01'] . ':' . $q10['p01'],
            $p82['ep01'] . ':' . $q10['ep01']
        );
        $this->screen->addP52('bodyPadding', array('par_val' => '5'));
        $this->screen->addP52('width', array('par_val' => '1000'));
        $this->screen->addP52('height', array('par_val' => '800'));

        $this->addHelp_dString(); //το p52 για τις βοήθειες των οθονών
        $this->addInit();
        $this->addNr01();
        $this->addModule();
        $this->addDiasMain();
        $this->addParams();
        $this->addHelpOfReport();
        
        return $this->screen;
    }

    /**
     * Η συνάρτηση αυτή προσθέτει το help string query#q10_d90_results_grid_140000011000003_d
     * ώστε για τις δοκιμές μ στην οθόνη να μην χρειάζεται να κάνω save και στην κεντρική
     */
    private function addHelp_dString()
    {
        $help_d_string = '';
        foreach ($this->q10_d90->screens_arr as $name => $value) {
            if ($name == $this->q10_d90->main_screen_name || $name == $this->q10_d90->results_screen_name) {
                continue;
            }
            if (!empty($help_d_string)) {
                $help_d_string .= ',';
            }
            $help_d_string .= 'query#' . $name;
        }
        $this->screen->addP52('help_d_string', array('par_val' => $help_d_string));
    }

    /**
     * Αυτή η συνάρτηση σετάρει τον κώδικα για το 
     * initialize της οθόνης -> p50.p44
     */
    private function addInit()
    {
        $init_str =
            '$constants = array();' . "\n" .
            '$constants["nr01"] = "' . $this->q10_d90->nr01 . '";' . "\n" .
            '$constants["results_tab_name"] = "' . $this->q10_d90->results_tab_name . '";' . "\n";
        if ($this->q10_d90->has_grouped_results) {
            $init_str .=
                '$constants["grouped_results_tab_name"] = "' . $this->q10_d90->grouped_results_tab_name . '";' . "\n";
        }
        $init_str .=
            '$constants["peg002_q12fld_p07sum"] = "' . $this->q10_d90->peg002_q12fld_p07sum . '";' . "\n" .
            '$data = query_q10_d90_q10Nr01_initialize($data,$mmnr01,$mnr01,$_d,$container_id, $constants);' . "\n";

        //Το initialize της οθόνης
        $this->screen->appendInitPHP($init_str);
    }

    /**
     * Είναι το ΜΚ της π-Αναφοράς που υπάρχει ως πεδίο στην οθόνη
     */
    private function addNr01()
    {
        //ΜΚ
        $nr01 = new Core00Numberbox(
            'Μ.Κ.', //Τίτλος
            'ID', //Αγγλικός τίτλος
            'nr01',  //Όνομα πεδίου
            0, //Διαδοχή
            15, //Μέγεθος
            0  //Δεκαδικά
        );
        $nr01->addP52("value",  array('par_val' => $this->q10_d90->nr01));
        $nr01->addP52("readonly",  array('par_val' => '1'));
        $nr01->addP52("hidden",  array('par_val' => '2'));
        $this->screen->addElement($nr01);
    }


    private function addModule(){
        //Module π-Αναφοράς για update
        $table = new Core00Textbox(
            'Module για Update', //Τίτλος
            'Update Module', //Αγγλικός τίτλος
            'module_00',  //Όνομα πεδίου
            0, //Διαδοχή
            40, //Μέγεθος
            0  //Δεκαδικά
        );
        $table->addP52("hidden",  array('par_val' => '2'));
        $table->addP52("value",  array('par_val' => empty($this->q10_d90->module_00)?'sme':$this->q10_d90->module_00));
        $this->screen->addElement($table);
    }
    /**
     * Η συνάρτηση αυτή θα προσθέσει τα πεδία dias_main_table, dias_main_nr01
     * Αυτά θα είναι κρυφά και θα αρχικοποιούνται στο άνοιγμα της οθόνης 
     * από το REQUEST π.χ. αν ανοίξει η αναφορά από τη λίστα κρατήσεων 
     * θα περάσει στο dias_main_table = hota04 και στο dias_main_nr01 το ΜΚ της κράτησης
     */
    private function addDiasMain()
    {
        //ΔΙΑΣ ΜΚ
        $nr01 = new Core00Numberbox(
            'ΔΙΑΣ Μ.Κ.', //Τίτλος
            'DIAS ID', //Αγγλικός τίτλος
            'dias_main_nr01',  //Όνομα πεδίου
            0, //Διαδοχή
            15, //Μέγεθος
            0  //Δεκαδικά
        );
        $nr01->addP52("hidden",  array('par_val' => '2'));
        $this->screen->addElement($nr01);

        //ΔΙΑΣ ΜΚ
        $table = new Core00Textbox(
            'ΔΙΑΣ Πίνακας.', //Τίτλος
            'DIAS Table', //Αγγλικός τίτλος
            'dias_main_table',  //Όνομα πεδίου
            0, //Διαδοχή
            40, //Μέγεθος
            0  //Δεκαδικά
        );
        $table->addP52("hidden",  array('par_val' => '2'));
        $this->screen->addElement($table);
    }


    /**
     * Η συνάρτηση αυτή θα εκτυπώσει το fldset των παραμέτρων 
     * εφόσον υπάρχουν
     */
    private function addParams()
    {

        $params_count = pegasus_mysql_printfld('q13', 'count(*)', 'p00=?', array($this->q10_d90->nr01));
        if ($params_count == 0) {
            return;
        }
        //Το fieldset των παραμετρων
        pegasus_mysql_use("select * from p82 where p00='query_search_criteria'", $p82);
        $fset_name = 'fieldset';
        $fset = new Core00PanelFieldset($p82['p01'], $p82['ep01'], $fset_name); 
        $fset->addP52("labelWidth",  array('par_val' => '200'));
        $fset->addP52("collapsed",  array('par_val' => 'peg_responsive'));
        $fset->addP52("collapsible",  array('par_val' => 'true'));
        $fset->addP52("bodyPadding",  array('par_val' => '5'));
        $fset->addP52("style",  array('par_val' => 'marginBottom: "5px"'));
        $fsetIndex = $this->screen->addElement($fset);

        $fcont00_name = 'fieldcontainer';
        $fcont = new Core00FieldContainer('', '', $fcont00_name);
        $fcont->addP52("fieldset",  array('par_val' => $fset_name));
        $fcont->addResponsiveConfig();
        $fcontIndex =$this->screen->addElement($fcont);

        //Τα fieldcontainer των παραμετρων
        $fcont_name0 = 'fieldcontainer_0';
        $fcont = new Core00FieldContainer('', '', $fcont_name0);
        $fcont->addP52("fieldset",  array('par_val' => $fcont00_name));
        $fcont->addP52("flex",  array('par_val' => '1'));
        $fcont1Index =$this->screen->addElement($fcont);

        $fcont_name1 = 'fieldcontainer_1';
        $fcont = new Core00FieldContainer('', '', $fcont_name1);
        $fcont->addP52("fieldset",  array('par_val' => $fcont00_name));
        $fcont->addP52("flex",  array('par_val' => '1'));
        $fcont2Index =$this->screen->addElement($fcont);

        //Οι παράμετροι
        //select_from_values: Είναι 1 αν η μεταβλητή παίρνει συγκεκριμένες τιμές
        $query_q13 =
            'select q13.*, if( group_concat(q131.nr01) is null, 0, 1) as select_from_values
            from q13 
            left join q131 on q131.q13 = q13.nr01
            where p00= :q10_nr01
            group by q13.nr01
            order by q13.p05;';
        $res_q13 = pegasus_query($query_q13, array('q10_nr01' => $this->q10_d90->nr01));

        $hiddenFieldsCount = 0;
        $element_arr = array();
        while ($q13 = pegasus_fetch($res_q13)) {
            $is_hidden = false;
            if ($q13['select_from_values'] == 1) {

                $ls_data = array();
                $ls_data_eng = array();
                $q131_query = "select * from q131 where q13=?";
                $res_q131 = pegasus_query($q131_query, array($q13['nr01']));
                while ($q131 = pegasus_fetch($res_q131)) {
                    $ls_data[] = array("code" => $q131['code'], "value" => $q131['value']);
                    $ls_data_eng[] = array("code" => $q131['code'], "value" => $q131['evalue']);
                }
                $element = new Core00Combobox(
                    $q13['p01'], //Τίτλος
                    $q13['ep01'], //Αγγλικός τίτλος
                    $q13['p02'],  //Όνομα πεδίου 
                    "code",
                    "value",
                    json_encode($ls_data),
                    json_encode($ls_data_eng)
                );
            }
            //Επιλογή από πίνακα
            else if ($q13['p07'] != '' && $q13['p08'] != '' ) {

                pegasus_mysql_use("select * from p50 where p01=?", $p50, array($q13['p07']));   
                if(pegasus_module_exists($p50['module']) && pegasus_mysql_table_exists($q13['p07'])){

                    $extra_where_params_execute_before_php = '';
                    $extra_where_php = '';
                    $extra_where_params_php = '';
                    $order_by = $q13['p011'];
                    /**Καταστήματα*/
                    if($q13['p07'] == "t07"){
                        $extra_where_params_execute_before_php = 
                        '$stores_where = array();'."\n".
                        '$stores_where[\'sql\'] = "1=1";'."\n".
                        '$stores_where[\'sqlParams\'] = array();'."\n".
                        'if(function_exists(\'peg_stores_get_stores_where_array\')){'."\n".
                        '    $stores_where = peg_stores_get_stores_where_array(\'t07\', \'p01\');'."\n". 
                        '}'."\n";
                        $extra_where_php = '$stores_where[\'sql\']';
                        $extra_where_params_php = '$stores_where[\'sqlParams\']';
                        $order_by = ' t07.ptax';
                        $q13['p011']=' t07.ptax';
                    }
                    /**Χρηστης*/
                    if($q13['p07'] == "us0"){
                        // επιστρέφω πάντα sql code - δεν χρειάζεται να έχω PHP code=1
                        
                        // αν υπάρχει ήδη κάτι πρέπει να αποφύγουμε επικάλυψη
                        if(!empty($order_by)){
                            $order_by .= ' , ';         
                        }

                        if (pegasus_module_exists("crm003")) {                    
                            $order_by .= ' selectbox_p412_d80.p03,p412,us0.p301';
                        } else {
                            $order_by .= ' us0.p301';
                        }
                        
                    }

                    $where_params_execute_before_php = '';
                    $where_php = '';
                    $where_params_php = '';
                    if(!empty($q13['p010'])){
                        $where_params_execute_before_php = '$sqlParams = array();'."\n";
    
                        $multi_query_q13 = 'select * from q13 where p00=:q10_nr01 order by p05 ';
                        $multi_res_q13 = pegasus_query($multi_query_q13, array('q10_nr01' => $this->q10_d90->nr01));
                        while ($multi_q13 = pegasus_fetch($multi_res_q13, PEG_FETCH_ASSOC)) {
                            if($q13['p012'] == 1){
                                //Εαν είναι multiselctbox θα περνάμε τις παραμέτρους μέσα από REQUEST 
                                //ώστε να μπορούμε να τις διαβάζουμε από άλλα πεδία
                                $where_params_execute_before_php .= '$sqlParams[\''.$multi_q13['p02'].'\'] = $_REQUEST[\'dias_q10_d90_'.$q13['p00'].'_d_fld_'.$multi_q13['p02'].'\'];'."\n";
                            }else{
                                $where_params_execute_before_php .= '$sqlParams[\''.$multi_q13['p02'].'\'] = $data[\''.$multi_q13['p02'].'\'];'."\n";
                            }
                        }
                        $where_php = 'pegasusGetGlobalVar( $container_id.\'_' . $q13['nr01'] . '_multi_sql\')';
                        $where_params_php = '$sqlParams';
                    }

                    /*
                    Εάν είναι συμπληρωμένο το where
                    τότε αυτό υπερισχύει του extra stores where
                    */
                    $where_multi = '';
                    if(!empty($where_php)){
                        $where_multi = $where_params_execute_before_php;

                        $where_multi .= 
                        'return array('."\n".
                        '               "sql" => '. $where_php . ' , '."\n".
                        '               "sqlParams" => '. $where_params_php."\n".
                        ');';
                    }
                    else if(!empty($extra_where_php)){
                        $where_multi = $extra_where_params_execute_before_php;

                        $where_multi .= 
                        'return array('."\n".
                        '               "sql" => '. $extra_where_php . ' , '."\n".
                        '               "sqlParams" => '. $extra_where_params_php."\n".
                        ');';
                    }

                    if($q13['p012'] == 1){ //Αν είναι multiselectbox
                         $element = new Core00MultiSelectBox(
                            $q13['p01'], //Τίτλος
                            $q13['ep01'], //Αγγλικός τίτλος
                            $q13['p02'],  //Όνομα πεδίου
                            $p50['module'], //module
                            $p50['p01'], //πίνακας
                            $p50['p02'], //_d
                            $q13['p08'], //valuefield
                            $q13['p09'], //displayfield
                            $q13['p011'], //orderby
                            $where_multi,
                            $q13['p00'] //κωδικός π-αναφοράς
                        );  
                    }
                    else{
                        $element = new Core00SelectBox(
                            $q13['p01'], //Τίτλος
                            $q13['ep01'], //Αγγλικός τίτλος
                            $q13['p02'],  //Όνομα πεδίου
                            $q13['p03'], //fieldtype
                            $p50['module'], //module
                            $p50['p01'], //πίνακας
                            $p50['p02'], //_d
                            $q13['p08'], //valuefield
                            $q13['p09'], //displayfield
                            $order_by, //orderby
                            $where_multi
                        );        
                        $element->addP52('display_value_field', array('par_val' => 1));
                    }
                }
                else{
                    //π.χ. αν δεν υπάρχει το module καταστηματα να μην φέρνει το combobox
                    $element = new Core00Textbox(
                        $q13['p01'], //Τίτλος
                        $q13['ep01'], //Αγγλικός τίτλος
                        $q13['p02']  //Όνομα πεδίου
                    );
                    $is_hidden = true;
                    $element->addP52('hidden', array('par_val' => 2));
                    $hiddenFieldsCount++;
                }           
            } else {
                switch (strtoupper($q13['p03'])) {
                    case 'N':
                        $element = new Core00Numberbox(
                            $q13['p01'], //Τίτλος
                            $q13['ep01'], //Αγγλικός τίτλος
                            $q13['p02'],  //Όνομα πεδίου
                            0,
                            15, 
                            $q13['p03_1']
                        );
                        break;
                    case 'C':
                        $element = new Core00Textbox(
                            $q13['p01'], //Τίτλος
                            $q13['ep01'], //Αγγλικός τίτλος
                            $q13['p02']  //Όνομα πεδίου
                        );
                        break;
                    case 'M':
                        $element = new Core00Memo(
                            $q13['p01'], //Τίτλος
                            $q13['ep01'], //Αγγλικός τίτλος
                            $q13['p02']  //Όνομα πεδίου
                        );
                        break;
                    case 'L':
                        $element = new Core00Checkbox(
                            $q13['p01'], //Τίτλος
                            $q13['ep01'], //Αγγλικός τίτλος
                            $q13['p02']  //Όνομα πεδίου
                        );
                        break;
                    case 'D':
                        $element = new Core00Datebox(
                            $q13['p01'], //Τίτλος
                            $q13['ep01'], //Αγγλικός τίτλος
                            $q13['p02']  //Όνομα πεδίου
                        );
                        break;

                    default:
                        break;
                }
            }
            if ($element) {
                $element_index = $this->screen->addElement($element);
                //Ο element_indexes_arr επιστρέφει τον index που παίρνει κάθε element στο $this->screen->elements array
                $element_arr[] = array('index' => $element_index, 'hidden' => $is_hidden);
                unset($element);

            }
        }

        if($hiddenFieldsCount == $params_count){//Αν όλα είναι hidden δεν φτιαχνω fset - fcont
            unset($this->screen->elements[$fsetIndex]);
            unset($this->screen->elements[$fcontIndex]);
            unset($this->screen->elements[$fcont1Index]);
            unset($this->screen->elements[$fcont2Index]);
        }
        else{//Αν εμφανίζεται έστω και ένα, θα βάλω refresh button
            $this->addRefreshButton($fset_name);
        }

        if($params_count - $hiddenFieldsCount == 1){//Αν έχω μόνο ένα πεδίο, δεν θέλω να εμφανιστεί δεύτερο fldcontainer
            unset($this->screen->elements[$fcont2Index]);
        }

        for ($i=0; $i < $params_count;  $i++) { 
            if($element_arr[$i]['hidden'] == true){
                continue;
            }
            if($i<ceil(($params_count - $hiddenFieldsCount)/2)){
                $this->screen->elements[$element_arr[$i]['index']]->addP52("fieldset",  array('par_val' => $fcont_name0));
            }
            else{
                $this->screen->elements[$element_arr[$i]['index']]->addP52("fieldset",  array('par_val' => $fcont_name1));
            }
        }


    }

    private function addRefreshButton($fset_name){
        $element = new Core00Button('Αναζήτηση', 'Refresh', 'refresh_button');
        $element->addP52("fieldset",  array('par_val' => $fset_name));
        $element->addP52("iconCls",  array('par_val' => 'x-fa fa-sync'));
        
        $this->screen->addElement($element);
    }


    private function addHelpOfReport()
    {
        pegasus_mysql_use("select p32, ep32 from q10 where nr01 = ?", $q10, array($this->q10_d90->nr01));
        if ($q10['p32'] != '' || $q10['ep32'] != '') {
            $this->screen->addHelp($q10['p32'], $q10['ep32'] );         
        }
    }
}
