<?php

class Q10_d90Field extends Q10_d90Element
{

}
class Q10_d90Numberbox extends Q10_d90Field
{
    public function __construct($title, $eTitle, $name, $browseIndex=0, $size=15, $decimals=0,$is_variable = false)
    {
        parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);
        $this->field_type = "N";
        if($is_variable) {
            $this->field_type = "V";
        }
        $this->view_type = "numberbox";
    }
}

class Q10_d90Datebox extends Q10_d90Field
{
    public function __construct($title, $eTitle, $name, $browseIndex=0, $size=10, $decimals=0,$is_variable = false)
    {
        parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

        $this->field_type = "D";
        if($is_variable) {
            $this->field_type = "V";
        }
        $this->view_type = "datebox";
    }
}

class Q10_d90Checkbox extends Q10_d90Field
{
    public function __construct($title, $eTitle, $name, $browseIndex=0, $size=1, $decimals=0,$is_variable = false)
    {
        parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

        $this->field_type = "L";
        if($is_variable) {
            $this->field_type = "V";
        }
        $this->view_type = "checkbox";
    }
}

class Q10_d90Textbox extends Q10_d90Field
{
    public function __construct($title, $eTitle, $name, $browseIndex=0, $size=40, $decimals=0,$is_variable = false)
    {
        parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

        $this->field_type = "C";
        if($is_variable) {
            $this->field_type = "V";
        }
        $this->view_type = "textbox";
    }
}
class Q10_d90Textarea extends Q10_d90Field
{
    public function __construct($title, $eTitle, $name, $browseIndex=0, $size=40, $decimals=0,$is_variable = false)
    {
        parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

        $this->field_type = "M";
        if($is_variable) {
            $this->field_type = "V";
        }
        $this->view_type = "textarea";
    }
}
class Q10_d90Memo extends Q10_d90Field
{
    public function __construct($title, $eTitle, $name, $browseIndex=0, $size=10, $decimals=0,$is_variable = false)
    {
        parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

        $this->field_type = "M";
        if($is_variable) {
            $this->field_type = "V";
        }
        $this->view_type = "textbox";
    }
}

class Q10_d90Tinymce extends Q10_d90Field
{
    public function __construct($title, $eTitle, $name, $browseIndex=0, $size=0, $decimals=0,$is_variable = false)
    {
        parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

        $this->field_type = "M";
        if($is_variable) {
            $this->field_type = "V";
        }
        $this->view_type = "tinymce";
    }
}

class Q10_d90Pie extends Q10_d90Field
{
    public function __construct($title, $eTitle, $name, $browseIndex=0, $size=0, $decimals=0)
    {
        parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

        $this->field_type = "V";
        $this->view_type = "polarchart";
    }
}


class Q10_d90Cartesian extends Q10_d90Field
{
    public function __construct($title, $eTitle, $name, $browseIndex=0, $size=0, $decimals=0)
    {
        parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

        $this->field_type = "V";
        $this->view_type = 'cartesianchart';
    }
}
class Q10_d90FileUpload extends Q10_d90Field
{
    public function __construct($title, $eTitle, $name, $browseIndex=0, $size=0, $decimals=0,$is_variable = false)
    {
        parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

        $this->field_type = "X";
        if($is_variable) {
            $this->field_type = "V";
        }
        $this->view_type = 'fileUpload';
    }
}

class Q10_d90FieldSet extends Q10_d90Element
{
    public function __construct($title, $eTitle, $name, $browseIndex=0, $size=0, $decimals=0)
    {
        parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

        $this->field_type = "";
        $this->view_type = 'fieldSet';
    }
    public function addResponsiveConfig(){
        $respConfig = 
        '{  "small" : {
            "layout" :{
            "type" : "box",
            "vertical": true,
                "align":"stretch"
            }
        },
        "medium || large" : { 
            "layout" :{
            "type" : "box",
            "vertical": false
            }
        }
    }';
    $this->addP52('responsiveConfig', array('par_val' => $respConfig));
    }
}

class Q10_d90PanelFieldset extends Q10_d90Element
{
    public function __construct($title, $eTitle, $name, $browseIndex=0, $size=0, $decimals=0)
    {
        parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

        $this->field_type = "";
        $this->view_type = 'PanelFieldset';
    }
    public function addResponsiveConfig(){
        $respConfig = 
            '{  "small" : {
                "layout" :{
                "type" : "box",
                "vertical": true,
                    "align":"stretch"
                }
            },
            "medium || large" : { 
                "layout" :{
                "type" : "box",
                "vertical": false
                }
            }
        }';
        $this->addP52('responsiveConfig', array('par_val' => $respConfig));
    }
}

class Q10_d90FieldContainer extends Q10_d90Element
{
    public function __construct($title, $eTitle, $name, $browseIndex=0, $size=0, $decimals=0)
    {
        parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

        $this->field_type = "";
        $this->view_type = 'fieldcontainer';
    }
    public function addResponsiveConfig(){
        $respConfig = 
            '{  "small" : {
                "layout" :{
                "type" : "box",
                "vertical": true,
                    "align":"stretch"
                }
            },
            "medium || large" : { 
                "layout" :{
                "type" : "box",
                "vertical": false
                }
            }
        }';
        $this->addP52('responsiveConfig', array('par_val' => $respConfig));
    }
}

class Q10_d90Combobox extends Q10_d90Element
{
    public function __construct($title, $eTitle, $name, $valueField, $displayField, $ls_data, $ls_data_eng,$field_type='', $browseIndex=0, $size=0, $decimals=0)
    {
        parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

        $this->field_type = $field_type;
        $this->view_type = 'combobox';

        $this->addP52('ls_data', array('par_val_js' => $ls_data, 'epar_val_js' => $ls_data_eng));
        $this->addP52('displayField', array('par_val_js' => $displayField));
        $this->addP52('valueField', array('par_val_js' => $valueField));
    }
}

class Q10_d90SelectBox extends Q10_d90Element
{
    public function __construct($title, $eTitle,  $name, $type, $module, $table, $_d, $valueField, $displayField, $orderby, $wherePHP)
    {
        parent::__construct($title, $eTitle, $name, 0, 0, 0);
        $this->field_type = $type;
        $this->view_type = 'comboboxV2';

        if(empty($displayField)){
            $displayField = $valueField;
        }

        $this->addP52('where', array('par_val_js' => $wherePHP, 'code' => 1));
        $this->addP52('table', array('par_val_js' => $table));
        $this->addP52('module', array('par_val_js' => $module));
        $this->addP52('_d', array('par_val_js' => $_d));
        $this->addP52('displayField', array('par_val_js' => $displayField));
        $this->addP52('valueField', array('par_val_js' => $valueField));
        $this->addP52('orderby', array('par_val_js' => $orderby));

    }
}
class Q10_d90MultiSelectBox extends Q10_d90Element
{
    public function __construct($title, $eTitle, $name, $module, $table, $_d, $valueField, $displayField, $orderby, $wherePHP)
    {
        parent::__construct($title, $eTitle, $name, 0, 0, 0);
        $this->field_type = "M";
        $this->view_type = 'multi_selectbox';

        if(empty($displayField)){
            $displayField = $valueField;
        }

        $this->addP52('where', array('par_val_js' => $wherePHP, 'code' => 1));
        $this->addP52('table', array('par_val_js' => $table));
        $this->addP52('module', array('par_val_js' => $module));
        $this->addP52('_d', array('par_val_js' => $_d));
        $this->addP52('multi_selectbox_displayField', array('par_val_js' => $displayField));
        $this->addP52('multi_selectbox_valueField', array('par_val_js' => $valueField));
        $this->addP52('orderby', array('par_val_js' => $orderby));

    }
}



