<?php

class Q10_d90Screen extends Q10_d90Element
{
    public $elements;

    private $lastElementIndex;
    public function __construct($_d, $module, $title, $eTitle)
    {

        parent::__construct($title, $eTitle, "screen");

        $this->_d = $_d;
        $this->module = $module;
        $this->field_type = "";
        $this->view_type = "screen";
        $this->screenIndex = 1;
        $this->lastElementIndex = $this->index;
        $this->elements = array();
    }

    public function create()
    {
        $this->deleteOldScreen();
        $this->createp50();
        parent::create();

        foreach ($this->elements as $el) {
            $el->create();
        }

    }

    public function addElement(Q10_d90Element $element)
    {
        $this->lastElementIndex += 10;
        
        $element->init(
            $this->module,
            $this->_d,
            $this->lastElementIndex
        );
        $this->elements[$this->lastElementIndex] = $element;
        return $this->lastElementIndex;
    }

    public function appendInitPHP($code){
        $this->initPHP .= $code;
    }

    public function addHelp($help, $help_eng){
        $this->addP52('help', array('par_val' => $help, 'epar_val'=>$help_eng));
    }

    private function createp50()
    {
        $nr01 = pegasus_mysql_newrec('p50');
        $arr =  array();
        $arr['nr01'] = $nr01;
        $arr['p02'] = $this->_d;
        $arr['module'] = $this->module;
        $arr['p03'] = $this->title; //Περιγραφή
        $arr['cor006'] = 1; //Κατηγορία Πίνακα = Πίνακας εφαρμογής
        $arr['p01'] = ''; //Όνομα πίνακα στη βάση δεδομένων
        $arr['p102'] = 0; //Copy to database
        $arr['p100'] = 0; //Reports 
        $arr['p101'] = 0; //New module installation
        $arr['p103'] = 0; //Copy data to module Update
        $arr['p104'] = 0; //Copy to local  
        $arr['p05'] = 0; //Συμμετέχει στη διαγραφή κινήσεων
        $arr['p501'] = 0; //Διαδοχή παραλαβής PIM
        $arr['p502'] = 0; //Διαδοχή αποστολής PIM
      
        $arr['p44'] = $this->initPHP; //initialize
      
        pegasus_mysql_insert('p50', array_keys($arr), array_values($arr));
    }

    public function deleteOldScreen()
    {
        //Πρέπει να τηρώ αυτην την σειρα γιατι η cleanCache ελέγχει αν υπάρχει το p50
        pegasus_delete_directory('../../tmp/' . $this->module . '/' . $this->_d . '/');
        peg002_clean_dCache($this->_d);

        query_delete_q10_d90_screen($this->module, $this->_d);    }
}



