<?php 
class Query_HTMLTemplate{
    private $q10nr01;
    private $q10;
    
    public function setQ10Nr01($val){
        pegasus_mysql_use("select * from q10 where nr01 = ? ", $q10, array($val));
        $this->q10nr01 = $q10['nr01'];
        $this->q10 = $q10;
    }
    
    public function printReportToHtml($q10nr01,  $columns, $query){
        // echo '<pre>';
        // print_r($columns);
        // echo "\n";
        // echo "$query \n";
        // echo '</pre>';
        $replaceArray = array(
            '##query_variable_title##' => $_SESSION['peg_dic_query_variable_title'],
            '##query_variable_value##' => $_SESSION['peg_dic_query_variable_value'],
        );
        
        $this->setQ10Nr01($q10nr01);
        foreach ($this->q10 as $key => $value){
            $replaceArray['##q10_'.$key.'##'] = $value;
        }

        $peg_tmp_q10title = $this->q10['p01'];
        if($_SESSION['lang'] == 'EN' and !empty($this->q10['ep01'])){
            $peg_tmp_q10title = $this->q10['ep01'];
        }
        
        $replaceArray['##q10##'] = $peg_tmp_q10title;
        
        $template = $this->_getTemplate('query.php');
        
        if(strpos($template, "##searchconditions##")!==false){
            $template = str_replace("##searchconditions##", $this->_getTemplate('searchconditions.php'), $template);
        }
        if(strpos($template, "##querydata##")!==false){ 
            $template = str_replace("##querydata##", $this->_getTemplate('querydata.php'), $template);
        }
        if(strpos($template, "##cols##")!==false || strpos($template, "##fields##")!==false){
            $colsTemplate = '';
            $fieldTemplate = '';
            foreach ($columns as $key => $col){
                $colsTemplate .= '<th style="font-family:\'Lato\', Tahoma, Verdana, Segoe, sans-serif;">##'.$key.'##</th>';
                $fieldTemplate .= '<td title="##'.$key.'##" class=" col " style="font-family:\'Lato\', Tahoma, Verdana, Segoe, sans-serif;">'.
                 '<span class=" pegbefore ">##'.$key.'##: </span>'.   
                '##rec_'.$key.'##</td>';
            }
          
            $template = str_replace(array("##cols##","##fields##" ),array($colsTemplate, $fieldTemplate), $template);
        }
       
       
        $template = $this->_replaceSearchConditions($template);
        $template = $this->_replaceQuery($columns, $query, $template);
        
    
        $template = str_replace(array_keys($replaceArray), array_values($replaceArray), $template);
        //echo $template;
        return $template;
        
    }
        
    protected function _replaceSearchConditions($template){
        $searchconditionsclass = ''; 
        $retStr = '';
        $rowTmp = $this->_print_getLine($template, '##startsearchconditions##', '##endsearchconditions##');
        
        $query_q13 = 'select * from q13 where p00=? order by p05;';

        $res_q13 = pegasus_query($query_q13, array($this->q10nr01));
        
        $i=0;        
        while ($q13 = pegasus_fetch_assoc($res_q13)) {
            //echo '<pre>'.print_r($q13, 1).'</pre>';
            $i++; 
            $q13Val = query_g13_getValFromExpression($q13['p06']);
            $q13Val = $this->_getValue(
                array(
                    'name' => $q13['p02'], 
                    'type' => strtoupper($q13['p03']), 
                    'title'=> '' ,
                    'p022' => 0, 
                    'p07' =>999,
                    'p08' => 2), 
                $q13Val
            );
            $tmpAr = array('##q13p01##' => $q13['p01'],'##q13value##' => $q13Val);
            $tmpAr['##browse_search_item##'] = 'browse_search_item'. ($i%2);
            $retStr .= str_replace(array_keys($tmpAr), array_values($tmpAr), $rowTmp );
        }
        if($i == 0){
            //Ean den exei conditions
            $searchconditionsclass = 'hidden';
        }
        
        $template = str_replace(
            array($rowTmp,'##startsearchconditions##', '##endsearchconditions##', '##searchconditionsclass##'), 
            array($retStr,'','', $searchconditionsclass), 
            $template);
        return $template;
    }
    
    protected function _replaceQuery($columns, $query, $template){
        $retStr = '';
        $replaceAr = array();
        $rowTmp = $this->_print_getLine($template, '##startrow##', '##endrow##');
        $sumAr = array();
//         echo $query;
        
        $i=0;
       
        $res = pegasus_query($query['sql'], $query['sqlParams']);
        if(pegasus_num_rows($res)==0){
            return "";
        }
        while ($row = pegasus_fetch_assoc($res)){
            ++$i;
            $tmpAr = array();
            
            
            
            foreach ($columns as $key => $value){
                $tmpAr['##rec_'.$key.'##'] = $this->_getValue($value, $row[$key]);
                if($value['p022']){
                    $sumAr[$key] +=  $row[$key];
                }
               
            }
            $tmpAr['##browse_item##'] = 'browse_item'. ($i%2);
//             print_r($row);
            $retStr .= str_replace(array_keys($tmpAr), array_values($tmpAr), $rowTmp);
        }
        $tmpAr = array();
        foreach ($columns as $key => $value){
           
            $replaceAr['##'.$key.'##'] = $value['title'];
           
            if($value['p022']){
                $tmpAr['##rec_'.$key.'##'] = $this->_getValue($value, $sumAr[$key]) ;
            }else{
                $tmpAr['##rec_'.$key.'##'] = '' ;
            }
        }
        $tmpAr['##browse_item##'] = 'browse_sum';
        $retStr .= str_replace(array_keys($tmpAr), array_values($tmpAr), $rowTmp);
        $template = str_replace(
            array($rowTmp,'##startrow##', '##endrow##', '##numofcol##'),
            array($retStr,'','', $i),
            $template);
        $template = str_replace(
            array_keys($replaceAr),
            array_values($replaceAr),
            $template);
        return $template;
    }
    
    /**
     * Epistrefei to periexomeno toy template
     * @param unknown $fileName
     */
    protected function _getTemplate($fileName){
        $fileName = $this->_getTemplateFile($fileName);
        if(!(file_exists($fileName))){
            return '';
        }
        return peg_read_file($fileName);
    }
    /**
     * Epistrefei to filepath toy template toy filename poy zitaw
     * @param String $fileName
     * @return relative filepath
     */
    protected function _getTemplateFile($fileName){
        if(empty($fileName)){
            return '';
        }
        
        if(file_exists($fileName)){
            return $fileName;
        }elseif (file_exists('../query_templates_sme/'.$this->q10nr01.'/'.$fileName)){
            return '../query_templates_sme/'.$fileName;
        }elseif (file_exists('../query_templates_sme/'.$fileName)){
            return '../query_templates_sme/'.$fileName;
        }else{
            return  '../query_templates/'.$fileName;
        }
    }
    
    /**
     * Epistrefei to string apo to template poy einai anamesa apo to string $startLine kai $endLine
     * @param string $data_contents
     * @param string $startLine
     * @param string $endLine
     */
    protected function _print_getLine($data_contents, $startLine, $endLine){
        if(strrpos($data_contents, $startLine) !== false ){
            $start 		= mb_strripos($data_contents , $startLine,0, 'UTF-8') + mb_strlen($startLine, 'UTF-8'); //find_last_pos($data_contents , $productStart);
            $end   		= mb_strripos($data_contents , $endLine,0, 'UTF-8');// find_last_pos($data_contents , $productEnd);
            return mb_substr($data_contents, $start, $end-$start , 'UTF-8');
        }
        return '';
    }	
    /**
     * 
     * @param array() $column
     *          'name' => $q12['p03'], //Onoma pedioyu
     *          'type' => $q12['p06'], //Typos 'C', 'D', 'N', 'L','M'

     *          'title'=> $peg_tmp_q12title ,//Title
     *          'p022' => $q12['p022'], //Ean emfanizei to athisma
     *          'p07' => $q12['p07'], // megethos
     *          'p08' => $q12['p08']    //dekadika
     * @param string $value
     */
    protected function _getValue($column, $value){
        switch ($column['type']) {
            case 'D':
                return peg_dateToStr($value);
            break;
            case 'N':
//                 print_r($column);
//                 var_dump($value);
                $decimal = 0;
                if($column['p08']>0){
                    $decimal = $column['p08'];
                }
//                 var_dump($_SESSION['cor000_decimal_char']);
//                 var_dump(number_format(floatval($value), null, '.',  ' '));
                return number_format($value,$decimal,$_SESSION['cor000_decimal_char'], '');
            break;
            case 'L':
                return ($value)?$_SESSION['peg_dic_core_yes']:$_SESSION['peg_dic_core_no'];
            break;
            case 'M':
                $text = html_entity_decode ( $value, ENT_COMPAT, "UTF-8" );
                $ttt = new html2text( $text );
                $text = $ttt->get_text ();
                return $text;
                break;
            default:
                return $value;
            break;
        }
    }
}
?>