<?php
    if(class_exists('PrintsData')===false){
        if(file_exists('../../pegasus_cloud_app/prints_classes/prints_data.php')){
            require_once('../../pegasus_cloud_app/prints_classes/prints_data.php');
        }else{
            return;
        }
    }
    class ReceiptsT08PrintsData extends PrintsData { 

        protected function setBodySql(){

            if(!empty($this->p85_arr['body_sql_code'])){
                $sql_code = eval($this->p85_arr['body_sql_code']);
            }

            $dias_main_nr01 = (is_array($this->p85_input["dias_main_nr01"])) ? $this->p85_input["dias_main_nr01"][0] : $this->p85_input["dias_main_nr01"];
                        
            if(empty($sql_code)){

                $sql_fields = "'' as t03_p0101, '' as t03_p04, '' as t42_p02 ";
                $sql_join   = "";
                if(pegasus_mysql_table_exists('t03')){
                    $sql_fields = "t03.p0101 as t03_p0101, t03.p04 as t03_p04, t42.p02 as t42_p02 ";
                    $sql_join  .= "left join t03 on t09.p04=t03.nr01 ";
                    $sql_join  .= "left join t42 on t42.p01=t03.p0103 ";
                }

                
                $sql_code['sql']  = 'select t09.*, ';
                $sql_code['sql'] .= $sql_fields;
                $sql_code['sql'] .= "from t09 ";
                $sql_code['sql'] .= $sql_join;
                $sql_code['sql'] .= "where t09.p00=:t08nr01;";

                $sql_code['sqlParams'] = array('t08nr01'=>$dias_main_nr01);
            }

            $this->body_sql = (is_array($sql_code)) ? $sql_code : array('sql'=>$sql_code, 'sqlParams'=>array());
        }  

        protected function makeGlobalData(){
            $global_data = parent::makeGlobalData();
            
            $lang = (isset($this->p85_input["lang"])) ? $this->p85_input["lang"] : "GR"; 
            $dias_main_nr01 = (is_array($this->p85_input["dias_main_nr01"])) ? $this->p85_input["dias_main_nr01"][0] : $this->p85_input["dias_main_nr01"];
            
            
            //Store Titles
            $t08_p0121 = pegasus_mysql_printfld('t08', 'p0121', 'nr01=:t08nr01', array('t08nr01'=>$dias_main_nr01));
            $core_titles_data = invoices_get_store_titles($t08_p0121);

            for($i=1; $i<=8; $i++){ 
                $global_data['cor000_tit_line'.$i] = $core_titles_data[$i-1];
            }
            for($i=1; $i<=8; $i++){ 
                $global_data['cor000_eng_tit_line'.$i] = $core_titles_data[$i+7];
                if(empty($global_data['cor000_eng_tit_line'.$i])){
                    $global_data['cor000_eng_tit_line'.$i] = $core_titles_data[$i-1];
                }
            }


            //Footer Titles
            $core_footer_data = invoices_get_store_footer($t08_p0121);
            for($i=1; $i<=5; $i++){ 
                $global_data['f02_ftr00'.$i] = $core_footer_data[$i-1];
            }
            for($i=1; $i<=5; $i++){ 
                $global_data['f02_eftr00'.$i] = $core_footer_data[$i+4];
                if(empty($global_data['f02_eftr00'.$i])){
                    $global_data['f02_eftr00'.$i] = $core_footer_data[$i-1];
                }
            }


            //Table Data
            $main_table_data = static::makeTableData($this->p85_arr['p50'], $dias_main_nr01);
            $counter = count($main_table_data);

            //Extra Table Data
            $copy = isset($this->p85_input['inv_copy']) ? $this->p85_input['inv_copy'] : 0;

            for ($j=0; $j<$counter; $j++) { 

                //Logo
                $logo_path = invoices_get_store_logo_path($main_table_data[$j]['t08_nr01_t08_nr01_p0121']);
                $main_table_data[$j]['invoices_logo'] = $logo_path;

                //Watermark Logo
                $watermark_logo_path = invoices_get_store_watermark_logo_path($main_table_data[$j]['t08_nr01_t08_nr01_p0121']);
                $main_table_data[$j]['invoices_watermark_logo'] = $watermark_logo_path;

                //Authenticity
                $main_table_data[$j]['orig_copy_dic'] = '';
                if(isset($this->p85_input['inv_copy'])){
                    $main_table_data[$j]['orig_copy_dic'] = invoices_print_orig_copy_dic($copy, $lang);
                } 
            }

            
            $global_data = array_merge($global_data, $main_table_data[0]);
            //echo "<pre>". print_r($global_data,1) . "</pre>"; 
            return  $global_data;
        }

        protected function getGlobalExpressions(){
            $global_exps = parent::getGlobalExpressions(); 
            
            //Footer Titles
            $f02_fields = array('ftr001','ftr002','ftr003','ftr004','ftr005','eftr001','eftr002','eftr003','eftr004','eftr005');
            foreach ($f02_fields as $fld) {
                if(peg_substr($fld, 0, 3)=='ftr'){   
                    $p01 = (int)peg_substr($fld, -1, 1).'η Γραμμή Footer';
                }elseif(peg_substr($fld, 0, 4)=='eftr'){
                    $p01 = (int)peg_substr($fld, -1, 1).'η Γραμμή Footer (EN)';
                }
                $p00  = 'f02_' . $fld;
                $p30  = 'return array("text"=>$pdf->printsData->getData("'.$p00.'"), "autoSizing"=>true);';
                $global_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p03'=>60); 
            }
            

            //Table Expressions
            $table_exps = static::getTableExpressions($this->p85_arr['p50']);
            //Extra Table Expressions
            $p30_fn = 'getData';

            //Logo
            $p00  = 'invoices_logo';    $p01 = 'Λογότυπο';
            $p30  = '$logo_path = $pdf->printsData->'.$p30_fn.'("'.$p00 .'");';
            $p30 .= "\n" . 'return invoices_logo_print(1140, 360, $logo_path);';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p05'=>'image'); 

            //Watermark Logo
            $p00  = 'invoices_watermark_logo';    $p01 = 'Λογότυπο Φόντου';
            $p30  = '$watermark_logo_path = $pdf->printsData->'.$p30_fn.'("'.$p00 .'");';
            $p30 .= "\n" . 'return invoices_logo_print(600, 390, $watermark_logo_path);';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p05'=>'image'); 

            //Authenticity
            $p00 = 'orig_copy_dic';     $p01 = 'Authenticity';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C'); 

            $global_exps = array_merge($global_exps, $table_exps);
            return $global_exps;
        }

        protected function getBodyExpressions(){

            $body_exps   = array();
            $p30_default = 'getBodyData';

            //Body Fields t09+
            $body_fields = array(
                "t03_p0101"	=> "t03_p0101",
                "t03_p04"	=> "t03_p04",
                "t42_p02"	=> "t42_p02",
            );

            $fields_query  = "select p50.p01 as p50_p01, p50.p03 as p50_p03, p51.* from p51 ";
            $fields_query .= "join p50 on p50.p02=p51.p02 ";
            $fields_query .= "join p60 on p60.p00=p51.desc16 ";
            $fields_query .= "where p50.p01 in ('t09','t03','t42') and p50.p102=1 and p60.isdbfld=1 ";
            $fields_query .= "order by field(p50.p01,'t09','t03','t42'), p51.desc06,p51.nr01;";
            
            $result = pegasus_query($fields_query);
            while ($p51=pegasus_fetch_assoc($result)) {

                if(in_array($p51['p50_p01'], array('t03','t42'))){
                    if(in_array($p51['p50_p01'].'_'.$p51['desc05'], array_keys($body_fields))){
                        $p00 = $body_fields[$p51['p50_p01'].'_'.$p51['desc05']];  
                    }else{
                        continue;
                    }
                }else{
                    $p00 = $p51['desc05']; 
                }

                $p01 = $p51['p50_p03'] . ' -> ' . $p51['desc02'];   
                $p05 = static::getExpressionType($p51['desc07']);

                $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>$p51['desc16'], 'p03'=>$p51['desc17'], 'p04'=>$p51['desc18'], 'p05'=>$p05); 
            } 
            
            return $body_exps;
        }

    }

?>