<?php

function retail00_after_update()
{
    // Renamed to "retail00_check_aneisprakto.php"
	if(file_exists('../../pegasus_cloud_app/retail00_01/retail00_check_remainder.php')) {
		unlink('../../pegasus_cloud_app/retail00_01/retail00_check_remainder.php');
	}
    // Μεταφέρθηκε η λειτουργικότητα στο module shifts
	if(file_exists('../../pegasus_cloud_app/retail00_01/retail00_print_x_sales_report.php')) {
		unlink('../../pegasus_cloud_app/retail00_01/retail00_print_x_sales_report.php');
	}

    pegasus_mysql_use('select rel, ver from p55 where p00 = "retail00"', $version);

    if ($version['ver'] == 1 && $version['rel'] <= 36) {
        pegasus_mysql_use('SELECT * FROM retail00_00 WHERE nr01 = 1', $retail00_00);
    
        if(empty($retail00_00['p01'] && empty($retail00_00['p02']))) {
            $arr1 = array();                $arr2 = array();
            array_push($arr1, 'nr01');      array_push($arr2, 1);
            array_push($arr1, 'p01');       array_push($arr2, 100);
            array_push($arr1, 'p02');       array_push($arr2, 100);
            pegasus_mysql_insert('retail00_00', $arr1, $arr2, 1);
        }
        
        if(empty($retail00_00['a55p015'])) {
            // Αν το Επί Πιστώσει υπάρχει και δεν έχει ΚΚ Λογιστηρίου, ορίζω αυτο.
            pegasus_mysql_use('SELECT * FROM a14 WHERE nr01 = 99', $a14);
            if(!empty($a14) && $a14['p02'] == 0) {
                pegasus_mysql_update('retail00_00', array('a55p015'), array(99), 'nr01 = 1');
            }
        }
    
        //Buttons Ενεργειών
    
        $std_actions_to_insert = array(
            140000146000000, //Fullscreen
            140000146000001, //Αλλαγή Καθεστώτος (μόνο mobile)
            140000146000002, //Επανευρεση Τιμών
            140000146000003, //Καθαρισμός Παραστατικού
            140000147000000, //Άνοιγμα Βάρδιας
            140000147000001  //Κλείσιμο βάρδιας
        );
        foreach($std_actions_to_insert as $value) {
            // Αν υπάρχει άλλη εγγραφή ήδη στον retail00_05 με αυτό το Button Ενέργειας χωρίς τερματικό.
            $exists = pegasus_mysql_printfld('retail00_05', 'nr01', 'retail00_03 = :value AND cor003p01 = "" ', array('value' => $value));
            if(!$exists) {
                $display = 0;
                if($value == 140000146000001) {
                    $display = 2;
                }
                $arr1 = array();    $arr2 =         array();
                array_push($arr1, 'nr01');          array_push($arr2, pegasus_mysql_newrec('retail00_05'));
                array_push($arr1, 'cor003p01');     array_push($arr2, '');
                array_push($arr1, 'retail00_03');   array_push($arr2, $value);
                array_push($arr1, 'p01');           array_push($arr2, '');
                array_push($arr1, 'p02');           array_push($arr2, '');
                array_push($arr1, 'p03');           array_push($arr2, $display);
                pegasus_mysql_insert('retail00_05', $arr1, $arr2);
            }
        }
    }
    if ($version['ver'] == 1 && $version['rel'] <= 58) {
        // Προσθήκη του "Όλες οι Ενέργειες" στις Βασικές Παραμέτρους.
        // Αν υπάρχει άλλη εγγραφή ήδη στον retail00_05 με αυτό το Button Ενέργειας χωρίς τερματικό.
        $exists = pegasus_mysql_printfld('retail00_05', 'nr01', 'retail00_03 = :value AND cor003p01 = "" ', array('value' => 140000146000009));
        if(!$exists) {
            $arr1 = array();    $arr2 =         array();
            array_push($arr1, 'nr01');          array_push($arr2, pegasus_mysql_newrec('retail00_05'));
            array_push($arr1, 'cor003p01');     array_push($arr2, '');
            array_push($arr1, 'retail00_03');   array_push($arr2, 140000146000009);
            array_push($arr1, 'p01');           array_push($arr2, '');
            array_push($arr1, 'p02');           array_push($arr2, '');
            array_push($arr1, 'p03');           array_push($arr2, 1);
            array_push($arr1, 'tax');           array_push($arr2, 99999);
            pegasus_mysql_insert('retail00_05', $arr1, $arr2);
        }
    }

    if ($version['ver'] == 1 && $version['rel'] <= 102) {
        if(function_exists('inventory_hide_fields')){
            inventory_hide_fields();
        }
    }

    if ($version['ver'] == 1 && $version['rel'] <= 108) {
        pegasus_mysql_use(
            "SELECT nr01 FROM p95p50 WHERE p50 = 'retail00_03' AND p95 = '140000000000002' AND nr01 = '140000136000001'", 
            $p95p50, 
            array('p50' => 'retail00_03', 'p95' => '140000000000002', 'nr01' => '140000136000001')
        );
        if(empty($p95p50['nr01'])) {
            $arr1 = array();    $arr2 = array();
            array_push($arr1, 'p50');          array_push($arr2, 'retail00_03');
            array_push($arr1, 'p95');          array_push($arr2, 140000000000002);
            array_push($arr1, 'ins');          array_push($arr2, 1);
            array_push($arr1, 'del');          array_push($arr2, 1);
            array_push($arr1, 'chan');         array_push($arr2, 1);
            array_push($arr1, 'sh');           array_push($arr2, 1);
            array_push($arr1, 'nr01');         array_push($arr2, 140000136000001);
            array_push($arr1, 'remdate');      array_push($arr2, '2023-09-06');
            array_push($arr1, 'remtime');      array_push($arr2, '13:49:52');
            array_push($arr1, 'remuser');      array_push($arr2, '');
            array_push($arr1, 'remfdate');     array_push($arr2, '0100-01-01');
            array_push($arr1, 'remftime');     array_push($arr2, '');
            array_push($arr1, 'remfuser');     array_push($arr2, '');
            array_push($arr1, 'remguc');       array_push($arr2, '');
            pegasus_mysql_insert('p95p50', $arr1, $arr2, 0, 1);
        }
    }
}

/**
 * Initialize οθόνης Home (Desktop)
 *
 * @param  array   $data
 * @param  string  $mmnr01
 * @param  integer $mnr01
 * @param  string  $_d
 * @param  string  $container_id
 * @return array
 */
function peg_retail00_retail00_01_d00_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {

    return $data;
}

function peg_retail00_retail00_01_d03_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {
    $data['but_add_i48_hidden'] = true;     // Colorsize
    $data['but_add_i32_hidden'] = true;     // Serial
    $data['but_add_new_sn_hidden'] = true;  // Καταχώρηση Νέων Serial Numbers
    $data['but_add_auto_sn_hidden'] = true; // Αυτόματη Δημιουργία Serial Numbers
    $data['but_add_i38_hidden'] = true;     // Lot
    $data['fldcont_i18_hidden'] = true;     // Συνταγή Είδος (fieldContainer)
    // $data['i48_records'] = '';
    // $data['i32_records'] = '';
    // $data['i38_records'] = '';
    $data['v_msg'] = '<div class="peg_alert_warning_plain">' . $_SESSION['peg_dic_retail00_no_item_selected'] . '</div>';
    return $data;
}

function peg_retail00_retail00_01_d02_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {

    if($_SESSION['retail00_00_a01pd10_en'] == 0) {
        $data['a01pd10_hidden'] = 2;
    }
    if($_SESSION['retail00_00_a01pd11_en'] == 0) {
        $data['a01pd11_hidden'] = 2;
    }
    if($_SESSION['retail00_00_a01pd12_en'] == 0) {
        $data['a01pd12_hidden'] = 2;
    }
    if($_SESSION['retail00_00_a01pd13_en'] == 0) {
        $data['a01pd13_hidden'] = 2;
    }

    return $data;
}

function peg_retail00_retail00_00_d_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {

    pegasusSetGlobalVar($container_id . '_a55p015_where', array('sql' => "a14.p02 = 0"));

    return $data;
}


function peg_retail00_retail00_01_d_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {
    $data['retail00_retail00_01_d_items_grid_items_grid_add_hidden'] = false;
    // $data['a55nr01'] = pegasus_mysql_newrec('a55');
    //TODO DELETE retail00_set_grid_where_and_delete_tmp. Ό,τι σέταρε, το σετάρουμε πλέον μέσα στην retail00_a55_d_initialize
    // retail00_set_grid_where_and_delete_tmp($container_id, $data['a55nr01']);
    //* --------------- INITIALIZE ΠΕΛΑΤΗ ΚΑΙ ΠΑΡΑΣΤΑΤΙΚΟ -------------------- *//

    $def_customer = $_SESSION['customers_000_retail_a01'];

    //* Αν δεν έχει ορισμένο Πελάτη Λιανικής, κοιτάζει αν το τερματικό έχει προεπιλεγμένο παραστατικό και αν αυτό το παραστατικό έχει Αρχικό Πελάτη.
    //* Πρώτα βλέπει για το τερματικό και μετά από τις Βασικές Retail.
    // if(empty($def_customer)) {
    //     $a10p01 = pegasus_mysql_printfld("retail00_04", "a10p01", "cor003p01 = ?", array($_SESSION['pegasus_client_uid']));

    //     $a10p01 = !empty($a10p01) ? $a10p01 : $_SESSION['retail00_00_a10p01'];
    //     if(!empty($a10p01)) {
    //         $def_customer = pegasus_mysql_printfld("a10", "a01", "p01 = ?", array($a10p01));
    //     }
    // }

    //* Αλλαγή της παραπάνω λογικής. Πρώτα κοιτάζει αν έχει ορισμένο "Προεπιλεγμένο Παραστατικό" και αν αυτό έχει Αρχικό Πελάτη, παίρνει αυτόν.
    //* Αν έχει προεπιλεγμένο παραστατικό και δεν έχει Αρχικό Πελάτη, ορίζει τον Πελάτη Λιανικής και το Προεπιλεγμένο Παραστατικό.
    //* Αν δεν έχει προεπιλεγμένο παραστατικό, τα πάντα ορίζονται από τον Πελάτη Λιανικής.
    $a10p01 = pegasus_mysql_printfld("retail00_04", "a10p01", "cor003p01 = ?", array($_SESSION['pegasus_client_uid']));
    $a10p01 = !empty($a10p01) ? $a10p01 : $_SESSION['retail00_00_a10p01'];

    if(!empty($a10p01)) {
        $a10a01 = pegasus_mysql_printfld("a10", "a01", "p01 = ?", array($a10p01));
        if(!empty($a10a01)) {
            $def_customer = $a10a01;
        }
    }
    
    
    if(!empty($def_customer)) {
        // Τα σχολιασμένα τα επιστρέφει η retail00_a55_d_initialize. Τα κρατάω σε σχόλια για να το θυμάμαι.
        pegasus_mysql_use("SELECT * FROM a01 WHERE nr01 = ?", $a01, array($def_customer));
        $data['a01nr01']  = $a01['nr01'];
        // $data['a01p45']   = $a01['p45'] ;
        $data['a01p48']   = $a01['p48'] ;
        $data['a01p06']   = $a01['p06'] ;
        $data['a01p52']   = $a01['p52'] ;
        $data['a01p52a']  = $a01['p52a'];
        $data['a01p523']  = $a01['p523'];
        $data['a01p19']   = $a01['p19'];
        $data['a01p2']    = $a01['p2'];
        $data['a01p3']    = $a01['p3'];
        $data['a01p9']    = $a01['p9'];
        $data['a01p8']    = $a01['p8'];
        $data['a01p01']   = $a01['p01'];
        $data['a01p20']   = $a01['p20'];
        $data['a01pc22']  = $a01['pc22'];
        $data['a01p4']    = $a01['p4'];
        $data['a01p5']    = $a01['p5'];
        $data['a01p7']    = $a01['p7'];
        // $data['a01p803c'] = $a01['p803c'];
        // $data['a01p27']   = $a01['p27'];
        // Παραμετρικά
        $data['a01pd10']  = $a01['pd10'];
        $data['a01pd11']  = $a01['pd11'];
        $data['a01pd12']  = $a01['pd12'];
        $data['a01pd13']  = $a01['pd13'];
        $data['a01p23']   = $a01['p23']; // Επάγγελμα
        // Το βάλαμε για οταν καλείται απο την clear_invoice
        $data['a01nr01_display'] = pegasus_mysql_printfld('a01', 'p19', 'nr01 = ?', array($data['a01nr01']));
        $data['a01p48_display']  = pegasus_mysql_printfld('i23', 'p02', 'p01 = ?',  array($data['a01p48']));
        $data['a01p06_display']  = pegasus_mysql_printfld('i14', 'p02', 'p01 = ?',  array($data['a01p06']));
        $data['a01pc22_display'] = pegasus_mysql_printfld('d40', 'p01', 'p02 = ?',  array($data['a01pc22']));

        //OIL Αν ο πελάτης έχει υποκατάστημα ελεγχο για εγραφες στον oila10 
        if(pegasus_module_exists('oil')){
            if(!empty($data['a01a71'])){
                pegasus_mysql_use("SELECT p01, p02 FROM oila10 WHERE p00 = ?", $oila04, array($data['a01a71']));
                $data['a01dipethe'] = $oila04['p01'];
                $data['a01dei']     = $oila04['p02'];
                //Αν έχει υποκαταστημα αλλα δεν εχει εγγραφη στον oila10 τοτε βαζουμε κενο η κοιταμε τον oila4?
            }else{
                pegasus_mysql_use("SELECT p01, p02 FROM oila04 WHERE p00 = ?", $oila10, array($data['a01nr01']));
                $data['a01dipethe'] = $oila10['p01'];
                $data['a01dei']     = $oila10['p02'];
            }
        }
    }

    // Καλώ την custom a55_d_initialize που έχουμε για το Retail
    $data = retail00_a55_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id);
    
    // Βάζω το data σε global var για να πάρω κάποια από τα στοιχεία στο init του Home από Ajax
    pegasusSetGlobalVar($container_id. '_retail00_01_d_a55_d_init_data', $data);
    
    //* 26/07/2023 - Μετέφερα το initialize του memo για το Home Screen στο Ajax του retail00_navigation
    //* Πλέον το εκτελούμε στην afterdraw του Home για να έχουμε τα πλάτος και ύψος.
    //* Δεν υπήρχε λόγος να εκτελούνται και εδώ. Κρατήσαμε μόνο το initialize του history globalVar.
    pegasusSetGlobalVar($container_id. '_retail00_01_d_history' , array());

    return $data;
}

function peg_retail00_retail00_01_d09_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {
	global $PegInput;
	$PegInput->addVar(new peg_input_alphanumeric('a55_msg'));
    $PegInput->addVar(new peg_input_alphanumeric('device'));    

    $a55_msg = $PegInput->getRequest('a55_msg');   
    $device = $PegInput->getRequest('device');

    $a55_msg = ltrim($a55_msg, '<br />'); // Remove break line from First Message.
    $data['message'] = '<div class="peg_alert_info_plain">' .$a55_msg. '</div>';
    
    if(pegasus_module_exists('imin00') && in_array($device, array('mobile'))){
        $data['but_print_imin_hidden'] = false;
    }

    if(pegasus_module_exists('epson00')){
        $data['but_print_epson_hidden'] = false;
    }
 
    return $data;
}

function peg_retail00_retail00_02_d_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {
    // retail00_set_grid_where_and_delete_tmp($container_id);
    $data = peg_retail00_retail00_01_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id);

    return $data;
}

function peg_retail00_retail00_02_d00_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {
    // retail00_set_grid_where_and_delete_tmp($container_id);
    // $data = peg_retail00_retail00_01_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id);
    
    return $data;
}

function peg_retail00_retail00_02_d03_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {

    // Για mobile δίνω το parent_container_id στα std actions λόγω των tabs.
    $data['mob_actions'] = retail00_draw_mob_std_actions($_REQUEST['peg_screen_parent_container_id'], $container_id);
    return $data;
}

/**
 * Σχεδιάζει το memo για τα Buttons Ενεργειών στη mobile οθόνη
 */
function retail00_draw_mob_std_actions($parent_container_id, $mobile_container_id){
    $std_actions_queryParams = array('termatiko' => $_SESSION['pegasus_client_uid']);
    pegasus_mysql_use('SELECT count(*) as cnt FROM retail00_05 WHERE cor003p01 = :termatiko', $ana_termatiko, $std_actions_queryParams);
    if($ana_termatiko['cnt'] == 0) {
        //* Αν δεν βρω εγγραφές στο retail00_05 για το ενεργό τερματικό μου, κάνω την παράμετρο '' για να διαβάσω από τις γενικές Βασικές Παραμέτρους
        $std_actions_queryParams['termatiko'] = '';
    }

    $std_actions_query = "  SELECT 
                                retail00_05.p01 as font,
                                retail00_05.p02 as bg,
                                retail00_05.p04 as p04,
                                retail00_05.i00pno as i00pno,
                                retail00_05.a10 as a10,
                                retail00_05.p85 as p85,

                                retail00_03.p00 as p00,
                                retail00_03.p01 as p01,
                                if(retail00_05.p06<>'', retail00_05.p06, retail00_03.p02) as p02,
                                if(retail00_05.p07<>'', retail00_05.p07, retail00_03.p03) as p03,
                                if(retail00_05.p05<>'', retail00_05.p05, retail00_03.p05) as icon,
                                retail00_03.nr01 as retail00_03
                            FROM retail00_05
                            LEFT JOIN retail00_03 on retail00_05.retail00_03 = retail00_03.nr01
                            WHERE 
                                cor003p01 = :termatiko
                                -- (cor003p01 = :termatiko 
                                -- OR (    cor003p01 = '' AND 
                                --         retail00_03 NOT IN (SELECT retail00_03 FROM retail00_05 WHERE cor003p01 = :termatiko))
                                -- )
                                AND (retail00_05.p03 = 0 OR retail00_05.p03 = 2)
                            ORDER by retail00_05.tax, retail00_05.nr01"
    ;

    $style = '
        <style>
            .retail00_mob_actions {
                width: 100%;
                display: flex;
                flex-direction: column;
                flex-wrap: wrap;
            }
            .retail00_mob_actions_buttons {
                background-color: #efefef;
                color: #4c4c4c;
                width: 100%;
                
                box-sizing: border-box;
                margin-bottom: 8px;
                text-align: center;
                padding: 7px 5px 9px 5px;
                font-weight: normal;
                font-size: 16px;
                cursor: pointer;
                
                
                display: flex;
                flex-direction: column;
                justify-content: space-evenly;
            }
            .retail00_mob_actions_buttons > i {
                margin-bottom: 5px;
            }
        </style>
    ';
    $html = '<div class="retail00_mob_actions">';
    $res = pegasus_query($std_actions_query, $std_actions_queryParams);
    $rows = '';
    while($row = pegasus_fetch_assoc($res)) {

        $button_style = '';
        if(!empty($row['font'])) {
            $button_style .= "color: #" . $row['font'] . ";";
        }
        if(!empty($row['bg'])) {
            $button_style .= " background-color: #" . $row['bg'] . ";";
        }
        $text = $row['p02'];
        if($_SESSION['lang'] != 'GR') {
            $text = $row['p03'];
        }
        $handler = "retail00_std_action('". $parent_container_id ."', ". $row['p00'] .", '" . $row['p01'] . "', '',  '" . $mobile_container_id . "')";
        if(!empty($row['a10'])) {
            // Αν έχει τυπο παραστατικού
            pegasus_mysql_use('SELECT p02, ep02 FROM a10 WHERE p01 = :a10_nr01', $a10, array('a10_nr01' => $row['a10']));
            if($_SESSION['lang'] == 'GR') {
                $text .= '<br>' . $a10['p02'];
            }else{
                $text .= '<br>' . $a10['ep02'];
            }
            $handler = "retail00_std_action('". $parent_container_id ."', ". $row['p00'] .", '" . $row['p01'] . "', '',  '" . $mobile_container_id . "', '', '" . $row['a10'] . "')";
        }
        if(!empty($row['p85'])) {
            // Αν έχει τυπο παραστατικού
            pegasus_mysql_use('SELECT p01, ep01 FROM p85 WHERE nr01 = :p85_nr01', $p85, array('p85_nr01' => $row['p85']));
            if($_SESSION['lang'] == 'GR') {
                $text .= '<br>' . $p85['p01'];
            }else{
                $text .= '<br>' . $p85['ep01'];
            }
            $handler = "retail00_std_action('". $parent_container_id ."', ". $row['p00'] .", '" . $row['p01'] . "', '',  '" . $mobile_container_id . "', '', '', '" . $row['p85'] . "')";
        }
        if(!empty($row['p04'])) {
            // Αν έχει π-Αναφορά
            pegasus_mysql_use('SELECT p01, ep01 FROM q10 WHERE nr01 = :q10_nr01', $q10, array('q10_nr01' => $row['p04']));
            if($_SESSION['lang'] == 'GR') {
                $text .= '<br>' . $q10['p01'];
            }else{
                $text .= '<br>' . $q10['ep01'];
            }
            $handler = "retail00_std_action('". $parent_container_id ."', ". $row['p00'] .", '" . $row['p01'] . "', '" . $row['p04'] . "',  '" . $mobile_container_id . "')";
        }
        if(!empty($row['i00pno'])) {
            // Αν έχει προσθήκη είδους
            pegasus_mysql_use('SELECT name, ename FROM i00 WHERE pno = :i00pno', $i00, array('i00pno' => $row['i00pno']));
            if($_SESSION['lang'] == 'GR') {
                $text = $i00['name'];
            }else{
                $text = $i00['ename'];
            }
            $handler = "retail00_std_action('". $parent_container_id ."', ". $row['p00'] .", '" . $row['p01'] . "', '', '" . $mobile_container_id . "', '" . $row['i00pno'] . "')";
        }
        $icon = '';
        if(!empty($row['icon'])) {
            $icon = '<i class="'.$row['icon'].'" style="font-size: 20px;"></i>';
        }
        $rows .= '<div class="retail00_mob_actions_buttons" style="'.$button_style.'" onclick="'.$handler.'">' . $icon . $text . '</div>';

    }
    $html .= $rows;
    $html .= '</div>';

    $html = $style . $html;

    return $html;
}

/**
 * Standard Actions
 */
function peg_retail00_retail00_03_d_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {
    $new_rec = 0;
    if (!($data['nr01'] > 0)) {
        $new_rec = 1;
    }

    // Τα νέα records χωρίς Δία, ΣΜΕ. Edit χωρίς Δια και όχι ΣΜΕ = readonly
    if(!pegasus_module_exists('dias')){
        $data['p01_readonly'] = 1;
        if ($new_rec == 1) {
            $data['nr01']         = pegasus_mysql_newrec('retail00_03');
            $data['p01']          = 'sme';
        }else{
            if($data['p01'] != 'sme') {
                $data['readonly'] = 1;   
            } 
        }  
    }

    return $data;
}

/**
 * Βασικές Παράμετροι Retail ανά Τερματικό
 */
function peg_retail00_retail00_04_d_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {

    //* Αν είναι νέα εγγραφή
    $peg_is_newrec = 0;
    if (empty($data['nr01'])) {
        $peg_is_newrec = 1;
    }
    if($peg_is_newrec) {
        $data['grid00_hidden'] = 1;
    }
    
    //* Για να φέρει στο grid των Standard Actions μόνο εγγραφές με το επιλεγμένο τερματικό.
    pegasusSetGlobalVar(
        $container_id. '_where_cor003p01' ,    
        array(
            'sql'       =>  ' cor003p01 = :cor003p01',
            'sqlParams' =>  array(
                'cor003p01' => $data['cor003p01']
        )
    ));

    return $data;
}

function peg_retail00_retail00_05_d_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {
    $parent_d = explode('-', $mmnr01)[0];
    if($parent_d == 'retail00_00_d') {
        $data['cor003p01_hidden'] = 1; 
    }

    if(!$data['nr01'] && $parent_d != 'retail00_00_d') {
        $cor003p01 = pegasus_mysql_printfld('retail00_04', 'cor003p01', 'nr01 = ?', array($mnr01));
        $data['cor003p01'] = $cor003p01;
    }

    if($data['retail00_03'] > 0) {
        pegasus_mysql_use('SELECT * FROM retail00_03 WHERE nr01 = :retail00_03', $retail00_03, array('retail00_03' => $data['retail00_03']));
        if($retail00_03['p04'] == 1) {
            $data['p04_hidden'] = 0;
            $data['p06_readonly'] = 1;
            $data['p07_readonly'] = 1;
        }
        elseif($retail00_03['p04'] == 2) {
            $data['i00pno_hidden'] = 0;
            $data['p06_readonly'] = 1;
            $data['p07_readonly'] = 1;
        }
        elseif($retail00_03['p04'] == 3) {
            $data['a10_hidden'] = 0;
            $data['p06_readonly'] = 1;
            $data['p07_readonly'] = 1;
        }
        elseif($retail00_03['p04'] == 4) {
            $data['p85_hidden'] = 0;
            $data['p06_readonly'] = 1;
            $data['p07_readonly'] = 1;
        }
    }

    return $data;
}

function peg_retail00_retail00_01_d06_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {

    $remainder = invoices_calc_a55_aneisprakto($mnr01, 'retail00_01', true, true);
    // $data['payment'] = 1;
    $data['amount'] = $remainder;
    // $data['uncollected'] = $remainder;
    // $data['payment_memo'] = retail00_draw_payment_memo($container_id, $mnr01);
    // $data['fsetpanel01_hidden'] = true;
    $data['collected_hidden'] = true;
    $data['change_hidden'] = true;
    $data['cash_memo_hidden'] = true;
    $data['a55nr01'] = $mnr01;
    $data['fldcont01_hidden'] = true;
    // $data['cash_memo'] = retail00_draw_cash_memo($container_id);

    $t01_grid_where = ' t01.p302 = :a55nr01 ';
    pegasusSetGlobalVar(
        $container_id. '_where_grid_retail00_01_d061',    
        array(
            'sql' => $t01_grid_where,
            'sqlParams' => array('a55nr01' => $data['a55nr01'])
         )
    );
    

    return $data;
}

function peg_retail00_retail00_01_d060_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {
    global $PegInput;
    $PegInput->addVar(new peg_input_alphanumeric('device'));    
    $device = $PegInput->getRequest('device');

    // echo '<pre>' .print_r($data, 1). '</pre>';
    $data['payment_memo']       = retail00_draw_payment_memo($container_id, $data['a55nr01']);
    $data['collected_hidden']   = true;
    $data['change_hidden']      = true;
    $data['cash_memo_hidden']   = true;

    $data['cash_memo']  = retail00_draw_cash_memo($container_id);
    $data['msg_submit'] = '<div class="peg_alert_warning_plain" style="text-align:center;">' .$_SESSION['peg_dic_retail00_01_d06_msg_submit']. '</div>';


    if(pegasus_module_exists('imin00') && in_array($device, array('mobile'))){
        $data['but_print_imin_hidden'] = false;
    }

    if(pegasus_module_exists('epson00')){
        $data['but_print_epson_hidden'] = false;
    }
    
    return $data;
}

function peg_retail00_retail00_std_action_1004_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
    global $PegInput;
    $PegInput->addVar(new peg_input_number('mnr01'));
    $PegInput->addVar(new peg_input_alphanumeric('peg_screen_parent_container_id'));
    $mnr01 = $PegInput->getRequest('mnr01');
    $peg_screen_parent_container_id = $PegInput->getRequest('peg_screen_parent_container_id');
    $data['a55nr01'] = $mnr01;
    $where_p05 = pegasusGetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_where_p05');
    pegasusSetGlobalVar($peg_screen_parent_container_id.'_where_p05__retail00_std_action_1004', $where_p05);
}

//καλείται απο το where του a10_grid της οθόνης _retail00_std_action_1004_d
function peg_retail00_invoices_where(){
    global $PegInput;
    $PegInput->addVar(new peg_input_alphanumeric('peg_screen_parent_container_id'));
    $peg_screen_parent_container_id = $PegInput->getRequest('peg_screen_parent_container_id');
    // var_dump(pegasusGetGlobalVar($peg_screen_parent_container_id. '_where_p05__retail00_std_action_1004'));
    return pegasusGetGlobalVar($peg_screen_parent_container_id. '_where_p05__retail00_std_action_1004');
    
}

//καλείται απο το where του a55_grid της οθόνης _retail00_std_action_1019_d
function peg_retail00_1019_a55_where(){
    global $PegInput;
    $PegInput->addVar(new peg_input_alphanumeric('peg_screen_parent_container_id'));
    $peg_screen_parent_container_id = $PegInput->getRequest('peg_screen_parent_container_id');

    return pegasusGetGlobalVar($peg_screen_parent_container_id. '_retail00_1019_a55_where');

    
}

function peg_retail00_retail00_std_action_1012_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
    global $PegInput;
    $PegInput->addVar(new peg_input_number('retail00_01_d02_a01nr01'));
    $PegInput->addVar(new peg_input_alphanumeric('parent_id'));
    $retail00_01_d02_a01nr01 = $PegInput->getRequest('retail00_01_d02_a01nr01');
    $parent_id = $PegInput->getRequest('parent_id');
    $data['a01nr01'] = $retail00_01_d02_a01nr01;
    pegasusSetGlobalVar(
        $parent_id . '_retail00_1012_customer_where',
        array(
            'sql'      =>'if (0 = :var_a55_p03 , 1 = 1  ,a55.p03 = :var_a55_p03) 
                          and a55.pweb01 = 1 ',
	        'sqlParams'=>array('var_a55_p03'=>$data['a01nr01'])
        )
        
    );
    return $data;
}

/**
 * Θα προσθέτει κίνηση με σχετικό ΜΚ το a55nr01 και θα επιστρέφει το υπόλοιπο
 * Θα υπολογίζουμε τη διαφορά συνολικού ποσού και υπολοίπου και αν είναι 0 θα προχωράμε και σε καταχώρηση του παρ/κου
 * $data = array δεδομένων που έχω στο ajax (όλο το παραστατικό και το a01nr01) TODO: Να δω τι θα καταλήξω να χρειάζομαι από αυτά
 */
function retail00_add_t01($data = array()) {
    // $data['a55p05'] -> Επιλεχθέν Παραστατικό
    // $data['a55nr01'] -> ΜΚ Παραστατικού (δεν έχει καταχωρηθεί ακόμα, θα το θέλω σαν σχετική κίνηση)
    // $data['a55p0109'] -> Σύνολο Παραστατικού
    $a55p05 = $data['a55p05'];
    $a55nr01 = $data['a55nr01'];
    $payment = $data['payment'];

    // Στοιχεία Ορισμού Παραστατικού
    pegasus_mysql_use('SELECT * FROM a10 WHERE p01 = ?', $a10, array($a55p05));
    // Στοιχεία Ορισμού Τρόπου Είσπραξης
    pegasus_mysql_use('SELECT * FROM a14 WHERE nr01 = ?', $a14, array($payment));
    $p_kklo = $a14['p02']; // Κωδικός Κίνησης Λογιστηρίου (Σε αυτές τις κινήσεις θα παίρνω του Τρόπου Είσπραξης)

    // Στοιχεία Κωδικού Κίνησης Λογιστηρίου (του επιλεγμένου παραστατικού)
    pegasus_mysql_use('SELECT * FROM t02 WHERE p01 = ? ', $t02, array($p_kklo));
    $p_kkxr = $t02['p03']; // Συντελεστής Χρέωσης
    $p_kkpi = $t02['p04']; // Συντελεστής Πίστωσης

    $p_asyn = 1; // Λογικά εδώ πάντα θα είναι 1, γίνεται -1 όταν αφορά ακύρωση.

    /* START ADD t01 */
    $p303 = '9';
    
    if ($data['a55pn01'] == '' or $data['a55pn02'] <= 0) {
        $data['a55pn02'] = '1';
    }
    $a55p02 = date('H:i');
    if(!empty($data['a55p02'])) {
        $a55p02 = $data['a55p02'];
    }

    pegasus_mysql_use('SELECT * FROM a01 WHERE nr01 = ?', $a01, array($data['a01nr01']));

    $peg_arr1 = array();            $peg_arr2 = array();
    array_push($peg_arr1, 'p01');   array_push($peg_arr2,  $a01['p21']);
    array_push($peg_arr1, 'p02');   array_push($peg_arr2,  $data['a55p01']); //YES
    array_push($peg_arr1, 'p02t');  array_push($peg_arr2,  $a55p02); //NO

    //23/10/2023 -- Το ποσό έρχεται πλέον σε €, αφαίρεση τη διαίρεση και έβαλα πολλαπλασιασμό στο Ξένο
    array_push($peg_arr1, 'p03');   array_push($peg_arr2,  $data['amount'] * $p_asyn * $p_kkxr); //NO
    array_push($peg_arr1, 'p04');   array_push($peg_arr2,  $data['amount'] * $p_asyn * $p_kkpi); //NO

    array_push($peg_arr1, 'pn03');  array_push($peg_arr2,  $data['amount'] * $p_asyn * $p_kkxr * $data['a55pn02']);
    array_push($peg_arr1, 'pn04');  array_push($peg_arr2,  $data['amount'] * $p_asyn * $p_kkpi * $data['a55pn02']);

    array_push($peg_arr1, 'pn01');  array_push($peg_arr2,  $data['a55pn01']); //NO
    array_push($peg_arr1, 'pn02');  array_push($peg_arr2,  $data['a55pn02']); //NO


    $t01_p05 = '';
    if (!empty($data['p705'])) {
        $t01_p05 .= $data['a55p705'] . ' '; //NO
    }
    $a14_p01 = pegasus_mysql_printfld('a14', 'p01', 'p02= ?', array($p_kklo));
    if (!empty($a14_p01)) {
        $t01_p05 .= $a14_p01 . ' ';
    }
    $t01_p05 .= $data['p010'];
    array_push($peg_arr1, 'p05');   array_push($peg_arr2, $t01_p05);
    array_push($peg_arr1, 'p06');   array_push($peg_arr2,  $a10['p00'] . ' ' . $data['a55p701'] . ' ' . $data['a55p06']); //NO //NO

    array_push($peg_arr1, 'p07');   array_push($peg_arr2,  $p_kklo);
    array_push($peg_arr1, 'p09');   array_push($peg_arr2,  $data['a55p0121']); //NO

    // array_push($peg_arr1, 'p900');  array_push($peg_arr2,  $data['a55p04']); //YES
    array_push($peg_arr1, 'p900');  array_push($peg_arr2,  $data['a01a71']);
    // array_push($peg_arr1, 'p101');  array_push($peg_arr2,  $data['p0105']);
    // array_push($peg_arr1, 'p201');  array_push($peg_arr2, ($data['p0100'] - $data['p0102']));

    array_push($peg_arr1, 'p503');  array_push($peg_arr2,  $data['a55p503']); //NO
    array_push($peg_arr1, 'p504');  array_push($peg_arr2,  $data['a55p504']); //NO
    array_push($peg_arr1, 'p401');  array_push($peg_arr2,  $data['a55p016']); //NO

    if (pegasus_mysql_printfld('t01', 'count(*)', 'p302=? and p303=4', array($data['nr01'])) > 0) {
        pegasus_mysql_update('t01', $peg_arr1, $peg_arr2, 'p302=? and p303=4 ', 0, 1, 1, array($data['nr01']));
    } else {
        array_push($peg_arr1, 'nr01');  array_push($peg_arr2,  pegasus_mysql_newrec('t01'));
        array_push($peg_arr1, 'p302');  array_push($peg_arr2,  $data['a55nr01']);
        array_push($peg_arr1, 'p303');  array_push($peg_arr2,  $p303);
        array_push($peg_arr1, 'pd101');  array_push($peg_arr2,  'a14');
        array_push($peg_arr1, 'pd102');  array_push($peg_arr2,  $a14['nr01']);
        // array_push($peg_arr1, 'remguc');  array_push($peg_arr2,  $a14['nr01']);
        pegasus_mysql_insert('t01', $peg_arr1, $peg_arr2);
    }
    /* END ADD t01 */

    //* Από εδώ και κάτω υπολογίζω το υπόλοιπο όλων των κινήσεων για αυτό το σχετικό ΜΚ και το επιστρέφω.

    // // Σύνολα Χρεώσεων και Πιστώσεων για αυτό το ΜΚ Σχετικής Κίνησης
    // pegasus_mysql_use('SELECT sum(p03) AS xreosi, sum(p04) AS pistosi FROM t01 WHERE p302 = :a55nr01', $t01_sum, array('a55nr01' => $a55nr01));
    // $t01_total = 0;
    // // $t01_sum['xreosi'] = 30; //For Debug
    // if(!empty($t01_sum['xreosi']) || !empty($t01_sum['pistosi'])) {
    //     // Χρεώσεις μείον Πιστώσεις
    //     $t01_total = ($t01_sum['xreosi']) - ($t01_sum['pistosi'] );
    // }
    $remainder = invoices_calc_a55_aneisprakto($data['a55nr01'], 'retail00_01', true, true);
    

    return $remainder;
}

/**
 * TODO DELETE. Ό,τι σέταρε, το σετάρουμε πλέον μέσα στην retail00_a55_d_initialize
 * Διαγράφει τις tmp εγγραφές και σετάρει το where του grid των ειδών
 * @param string $container_id
 */
function retail00_set_grid_where_and_delete_tmp($container_id = '', $a55nr01 = 0) {

    //TODO: Check if this is ok. Χρησιμοποιώ την συνάρτηση του invoices για consistency

    // pegasus_mysql_delete(
    //     'peg_tmp_i01',
    //     'peg_mmnr01 = :mmnr01 AND peg_sess_id= :peg_sess_id',
    //     0,
    //     array(
    //         'mmnr01' => 'a55_d-'.$a55nr01,
    //         'peg_sess_id' => session_id()
    //     )
    // );
    // pegasus_mysql_delete(
    //     'peg_tmp_i48',
    //     'peg_mmnr01 = :mmnr01 AND peg_sess_id= :peg_sess_id',
    //     0,
    //     array(
    //         'mmnr01' => 'a55_d-'.$a55nr01,
    //         'peg_sess_id' => session_id()
    //     )
    // );
    // pegasus_mysql_delete(
    //     'peg_tmp_i32',
    //     'peg_mmnr01 = :mmnr01 AND peg_sess_id= :peg_sess_id',
    //     0,
    //     array(
    //         'mmnr01' => 'a55_d-'.$a55nr01,
    //         'peg_sess_id' => session_id()
    //     )
    // );
    // pegasus_mysql_delete(
    //     'peg_tmp_i38',
    //     'peg_mmnr01 LIKE :mmnr01 AND peg_sess_id= :peg_sess_id',
    //     0,
    //     array(
    //         'mmnr01' => 'a55_d-'.$a55nr01,
    //         'peg_sess_id' => session_id()
    //     )
    // );
    
    //* Δύο global var, ένα με container_id, ένα με peg_a55_d- /// Έτσι το κάνει και στο invcust.
    $sql_a55 = array(
        'sql'       =>  ' peg_mmnr01= :mmnr01 AND peg_sess_id= :peg_sess_id AND peg_flag<>9',
        'sqlParams' =>  array(
            'mmnr01' => 'a55_d-'.$a55nr01,
            'peg_sess_id' => session_id()
        )
    );
    //! ΔΕΝ ΔΙΑΒΆΖΕΙ PDO ARRAY ΣΤΟ INVCUST. ΤΟ ΒΑΖΩ ΩΣ 'WHERE' ΠΡΟΣΩΡΙΝΑ
    $where = ' 
        peg_flag!=9 
        and peg_tmp_i01.peg_sess_id="' . session_id() . '" 
        and peg_tmp_i01.peg_mmnr01="a55_d-'  . $a55nr01 . '" 
        and peg_tmp_i01.peg_mnr01="'   . $a55nr01 . '" ';
    pegasusSetGlobalVar(
        $container_id. '_where_eidi' ,    
        $where
    );

    pegasusSetGlobalVar(
        'peg_a55_d-' . $a55nr01 . '_where_eidi', 
        $where
    );

    // Set _where_i71_d00 globalVar
    invoices_make_i71_d00_whereVar('a55', $container_id, array('nr01' => $a55nr01)); // a55 γιατί παίζουμε με a55-d tmp.
}
/**
 * Βασικές Παράμετροι ανά Τερματικό (on save/change)
 */
function retail00_retail00_04_d_change($data , $permDeny , $mmnr01 , $checkOnlyPerm) {

    //* Αν είναι νέα εγγραφή
    $peg_is_newrec = 0;
	if (empty($data['nr01'])) {
		$peg_is_newrec = 1;
	}
    //* Αν έχω άλλη εγγραφή με το επιλεγμένο τερματικό
    $query = 'SELECT nr01 FROM retail00_04 WHERE cor003p01 = :cor003p01';
    $queryParams = array();
    $queryParams['cor003p01'] = $data['cor003p01'];
    if($peg_is_newrec == 0) {
        //* Αν δεν είναι νέα εγγραφή, ελέγχω και το ΜΚ.
        $query .= ' AND nr01 <> :nr01';
        $queryParams['nr01'] = $data['nr01'];
    }

    pegasus_mysql_use($query, $record, $queryParams);

    if (!empty($record['nr01'])) {
		array_push($permDeny, array('type' => 'deny', 'message' => 'Υπάρχει ήδη εγγραφή για αυτό το Τερματικό'));
	}

    return array($data, $permDeny);
}


//* Temporary function. Καλείται από το memo κουμπί καρφωτά με code και από την αναζήτηση είδους με μερικές παραμέτρους.
function retail00_insert_item($code, $params = array()) {
    
    $arr1 = array();							$arr2 = array();
    array_push($arr1, 'nr01');					array_push($arr2, pegasus_mysql_newrec('i01'));
    if(!empty($params['v101'])) {
        array_push($arr1, 'p01');					array_push($arr2, $params['v101']);
        array_push($arr1, 'p02');					array_push($arr2, $params['v102']);
        array_push($arr1, 'p03');					array_push($arr2, $params['v103']);
        array_push($arr1, 'p04');					array_push($arr2, $params['timh1']);  
    }else{
        array_push($arr1, 'p01');					array_push($arr2, $code);
    }
    // array_push($arr1, 'peg_mmnr01');			array_push($arr2, 'retail00_01_d-0');
    array_push($arr1, 'peg_mmnr01');			array_push($arr2, $params['mmnr01']);
    array_push($arr1, 'peg_mnr01');			    array_push($arr2, $params['mnr01']);
    array_push($arr1, 'peg_sess_id');			array_push($arr2, session_id());

    pegasus_mysql_insert('peg_tmp_i01', $arr1, $arr2);

    $ret = array();
    $ret['ok'] = 1;

    return $ret;
}

function retail00_retail01_d_select_customer($a01nr01, $data = array()) {
    pegasus_mysql_use("SELECT * FROM a01 WHERE nr01 = ?", $a01, array($a01nr01));
        
    $ret['customer_title'] = $a01['p19'];  //Επωνυμία

    $ret['total_points'] = '';
    if (pegasus_module_exists('giftcards')) {
        $total_points =  giftcards_find_total_points($a01['nr01']);
        if(empty($total_points)) {
            $total_points = 0;
        }
        $total_points = number_format($total_points, 2, $_SESSION['cor000_decimal_char'], '');
        $ret['total_points'] = "Σύνολο Πόντων: " . $total_points;  //Σύνολο Πόντων
    }
    
    $balance = account_find_balance($a01['p21']);
    $balance = number_format($balance, 2, $_SESSION['cor000_decimal_char'], '');
    $ret['balance'] = "Υπόλοιπο: "           . $balance;     //Υπόλοιπο

    $last_purchase = pegasus_mysql_printfld('t01', 'MAX(p02)', 'p03 > 0 AND p01 = ?', array($a01['p21']));
    $ret['last_purchase'] = '';  //Ημερομηνία Τελευταίας Αγοράς
    if(!empty($last_purchase)) {
        $last_purchase = date('d/m/Y', strtotime($last_purchase));
        $ret['last_purchase'] = "Τελευταία Αγορά: "    . $last_purchase;  //Ημερομηνία Τελευταίας Αγοράς
    }


    $ret['a01nr01']  = $a01['nr01']; // ΜΚ Πελάτη
    // $ret['a01p45']   = $a01['p45'] ; // Καθεστώς ΦΠΑ
    $ret['a01p48']   = $a01['p48'] ; // Β. Τιμοκατάλογος
    $ret['a01p06']   = $a01['p06'] ; // Ε. Τιμοκατάλογος
    $ret['a01p52']   = $a01['p52'] ; // Έκπτωση % 1
    $ret['a01p52a']  = $a01['p52a']; // Έκπτωση % 2
    $ret['a01p523']  = $a01['p523']; // Επιβάρυνση %
    $ret['a01p19']   = $a01['p19'];  // Επωνυμία
    $ret['a01p2']    = $a01['p2'];   // Επώνυμο
    $ret['a01p3']    = $a01['p3'];   // Όνομα
    $ret['a01p9']    = $a01['p9'];   // Τηλέφωνο 2
    $ret['a01p8']    = $a01['p8'];   // Τηλέφωνο 1
    $ret['a01p4']    = $a01['p4'];   // Διεύθυνση
    $ret['a01p5']    = $a01['p5'];   // Περιοχή
    $ret['a01p7']    = $a01['p7'];   // ΤΚ
    $ret['a01p01']   = $a01['p01'];  // e-mail
    $ret['a01p20']   = $a01['p20'];  // ΑΦΜ
    $ret['a01pc22']  = $a01['pc22']; // ΔΟΥ
    $ret['a01pd10']  = $a01['pd10']; // Λεκτικό 1
    $ret['a01pd11']  = $a01['pd11']; // Λεκτικό 2
    $ret['a01pd12']  = $a01['pd12']; // Λεκτικό 3
    $ret['a01pd13']  = $a01['pd13']; // Λεκτικό 4
    $ret['a01p23']   = $a01['p23'];  // Επάγγελμα
    //$ret['a01p803c'] = $a01['p803c'];// Διάταξη Απαλλαγής ΦΠΑ
    //$ret['a01p27']   = $a01['p27'];  // Πιστωτικό Όριο
    // Find display values for pegSetVal
    $ret['a01nr01_display'] = pegasus_mysql_printfld('a01', 'p19', 'nr01 = ?', array($ret['a01nr01']));
    // $ret['a01p45_display']  = pegasus_mysql_printfld('a26', 'p02', 'p01 = ?',  array($ret['a01p45']));
    $ret['a01p48_display']  = pegasus_mysql_printfld('i23', 'p02', 'p01 = ?',  array($ret['a01p48']));
    $ret['a01p06_display']  = pegasus_mysql_printfld('i14', 'p02', 'p01 = ?',  array($ret['a01p06']));
    $ret['a01pc22_display'] = pegasus_mysql_printfld('d40', 'p01', 'p02 = ?',  array($ret['a01pc22']));
    // $ret['a01p803c_display']= pegasus_mysql_printfld('a77', 'p01', 'nr01 = ?', array($ret['a01p803c']));

    //OIL Αν ο πελάτης έχει υποκατάστημα ελεγχο για εγραφες στον oila10 
    if(pegasus_module_exists('oil')){
        if(!empty($data['p04'])){
            pegasus_mysql_use("SELECT p01, p02 FROM oila10 WHERE p00 = ?", $oila10, array($data['p04']));
            $ret['a01dipethe'] = $oila10['p01'];
            $ret['a01dei']     = $oila10['p02'];
           // var_dump($ret['a01dipethe'].'--'.$ret['a01dei'].'--'.$data['p04']);
    
            //Αν έχει υποκαταστημα αλλα δεν εχει εγγραφη στον oila10 τοτε βαζουμε κενο η κοιταμε τον oila4?
        }else{
            pegasus_mysql_use("SELECT p01, p02 FROM oila04 WHERE p00 = ?", $oila04, array($a01nr01));
            $ret['a01dipethe'] = $oila04['p01'];
            $ret['a01dei']     = $oila04['p02'];
        }
    }
    //*Συμπληρώνω τα στοιχεία από την find_p03_data.

    //RETAIL: Φτιάχνουμε το array $request_arr και το γεμίζουμε με όλες τις πληροφορίες που χρειάζεται η συνάρτηση 
	$request_arr = array(); 
    $request_arr['p03']  = $a01nr01;  // ΜΚ Πελάτη
	$request_arr['p01']  = $data['p01'];   // Ώρα
	$request_arr['p02']  = $data['p02'];   // Ημερομηνία
	$request_arr['p04']  = $data['p04'];   // Υποκατάστημα
	$request_arr['p415'] = $data['p415']; // Κατάστημα (Από)
	$request_arr['p416'] = $data['p416']; // Κατάστημα (Έως)
	$request_arr['nr01'] = $data['nr01']; // ΜΚ Παραστατικού
	$request_arr['p506'] = $data['p506']; // Δωροεπιταγή
	$request_arr['p05']  = $data['p05']; // Τύπος Παραστατικού
	$request_arr['container_id'] = $data['container_id'];

	$response_arr = invoices_find_p03_data($request_arr, 'retail00_01');
	// echo '<pre>qqqq' .print_r($response_arr, 1). '</pre>';
    $ret_data = array();

    //Κανω query στον a55 για να δώ αν το παραστατικό είναι σε αναμονή, ποιον πελάτη και πωλήτη εχει
    pegasus_mysql_use("SELECT p03, p016, pweb01 FROM a55 WHERE a55.nr01 = :var_nr01", $a55 ,array('var_nr01'=>$data['nr01']));
    $p016_display   = pegasus_mysql_printfld('us0','p100','p01 = :p01',array('p01' => $a55['p016']));

    foreach ($response_arr as $key => $value) {
		//ok Εξαιρούμε με if το καθεστώς  (Το έχουμε αρχικοποιήσει με το query στον a01)
		//ok Εξαιρούμε με if το διάταξη απαλλαγης ΦΠΑ  (Το έχουμε αρχικοποιήσει με το query στον a01)
		//ok Εξαιρούμε με if το πιστωτικό όριο  (Το έχουμε αρχικοποιήσει με το query στον a01) - TODO: SOS να μην ξεχάσουμε το onsave και την αρχιοποίηση
		
		//Θεωρώ στο initialize δεν θα μου φέρει ποτέ υποκατάστημα, στην onchange του πελάτη θα πρέπει α το ξαναδουμε.Αποφασίζουμε ότι το υποκατάστημα θα μπει κάτω από τον πελάτη
		//TODO: Θα πρέπει να δουμε στο onchange του πελάτη και τις αλλαγες από το υποκατάστημα π.χ. καθεστώς και τρόπος μεταφοράς. 
	
		//Το υποκατάστημα θα το κάνουμε a01a71 (αντί για p04). Από την invoices_find_p03_data θα μας γυρνάει το p04_hidden, 
		//θα το μετατρέπουμε σε a01a71_hidden
		//Εξαιρούμε με if τον τρόπο είσπραξης (Το καταργούμε σαν πεδίο)

        if(
               $key != 'p015'   && $key != 'p015_display'   // Τρ. Είσπραξης
            && $key != 'p03'    // Πελάτης (τον έχω ήδη από πάνω)
            && $key != 'p707'   // Αρ. Φορολογικής Κάρτας (δεν τον έχουμε στο retail)
            && $key != 'a01p40' // Έχω ενημερωμένα τα p013/p014, δεν το χρειάζομαι.
            && $key != 'container_id' // Επιστρέφει και container_id
        ) {
            // Παίρνω και τα p09 cases γιατί ελέγχω για επιτρεπτά καθεστώτα ΦΠΑ από το Παραστατικό στη find_p03_data
            switch ($key) {
                case "p04_hidden":
                    $ret_data['a01a71_hidden'] = $value;
                    break;
                case "clear_p04":
                    $ret_data[$key] = $value;
                    break;
                case "a01p40":
                    $ret_data['placeholder_a01p40'] = $value;
                    break;
                case "p09":
                    $ret_data['a01p45'] = $value;
                    break;
                case "p09_display":
                    $ret_data['a01p45_display'] = $value;
                    break;
                case "p412":
                    $ret_data['a01p27'] = $value;
                    break;
                case "p706c":
                    $ret_data['a01p803c'] = $value;
                    break;
                case "p706c_display":
                    $ret_data['a01p803c_display'] = $value;
                    break;
                default:
                    $ret_data['a55'.$key] = $value;
            }
        }
	}

    if($a55['p03'] == $a01['nr01'] && $a55['pweb01'] == 1){
        $ret_data['a55p016'] = $a55['p016'];
        $ret_data['a55p016_display'] = $p016_display;
    }

    $ret_data['a55p415_display'] = '';
    $ret_data['a55p416_display'] = '';
    $ret_data['a55p0121_display'] = '';
    if(pegasus_module_exists('stores')) {
        $ret_data['a55p415_display']  = pegasus_mysql_printfld('t07', 'p02', 'p01 = :a55p415', array('a55p415' => $ret_data['a55p415']));
        $ret_data['a55p416_display']  = pegasus_mysql_printfld('t07', 'p02', 'p01 = :a55p416', array('a55p416' => $ret_data['a55p416']));
        $ret_data['a55p0121_display'] = pegasus_mysql_printfld('t07', 'p02', 'p01 = :a55p0121', array('a55p0121' => $ret_data['a55p0121']));
    }
    // echo '<pre>' .print_r($response_arr, 1). '</pre>';
    // echo '<pre>' .print_r($ret_data, 1). '</pre>';
    $ret = array_merge($ret, $ret_data);

    return $ret;
}

function retail00_save_a01_screen($data, $no_confirm = 0)
{
	$ret_array = array();
    $new_record = 0;

    if(!$data['a01nr01'] > 0) {
        $new_record = 1;
        $a01_nr01 =  pegasus_mysql_newrec('a01');
    }else{
        $a01_nr01 = $data['a01nr01'];
    }

	$screen = new screen();
	$screen->container_id = pegasus_container_id_create(0, session_id(), 'a01_d');
	$screen->module       = 'customers';
	$screen->_d           = 'a01_d';
	$screen->table        = 'a01';
	$screen->nr01          = $a01_nr01;
	$screen->read_data_from_db();
	$screen->read_params_from_db();


	/* ΕΙΣΑΓΩΓΗ ΔΕΔΟΜΕΝΩΝ */
    $screen->data['nr01']  = $a01_nr01        ; // ΜΚ
    $screen->data['p45']   = $data['a01p45']  ; // Καθεστώς ΦΠΑ
    $screen->data['p48']   = $data['a01p48']  ; // Βασικός Τιμοκατάλογος
    $screen->data['p06']   = $data['a01p06']  ; // Ειδικός Τιμοκατάλογος
    $screen->data['p52']   = $data['a01p52']  ; // Έκπτωση 1
    $screen->data['p52a']  = $data['a01p52a'] ; // Έκπτωση 2
    $screen->data['p523']  = $data['a01p523'] ; // Επιβαρύνσεις
    $screen->data['p19']   = $data['a01p19']  ; // Επωνυμία
    $screen->data['p2']    = $data['a01p2']   ; // Επώνυμο
    $screen->data['p3']    = $data['a01p3']   ; // Όνομα
    $screen->data['p9']    = $data['a01p9']   ; // Τηλέφωνο 2
    $screen->data['p8']    = $data['a01p8']   ; // Τηλέφωνο 1
    $screen->data['p4']    = $data['a01p4']   ; // Διευθυνση
    $screen->data['p5']    = $data['a01p5']   ; // Περιοχή
    $screen->data['p7']    = $data['a01p7']   ; // ΤΚ
    $screen->data['p01']   = $data['a01p01']  ; // e-mail
    $screen->data['p20']   = $data['a01p20']  ; // ΑΦΜ
    $screen->data['pc22']  = $data['a01pc22'] ; // Δ.Ο.Υ (Κωδικός)
    $screen->data['p803c'] = $data['a01p803c']; // Διάταξη Απαλλαγής ΦΠΑ.
    $screen->data['p27']   = $data['a01p27']  ; // Πιστωτικό Όριο
    $screen->data['pd10']  = $data['a01pd10'] ; // Παραμετρικό Λεκτικό 1
    $screen->data['pd11']  = $data['a01pd11'] ; // Παραμετρικό Λεκτικό 2
    $screen->data['pd12']  = $data['a01pd12'] ; // Παραμετρικό Λεκτικό 3
    $screen->data['pd13']  = $data['a01pd13'] ; // Παραμετρικό Λεκτικό 4
    $screen->data['p23']   = $data['a01p23']  ; // Eπάγγελμα

    $default_values = peg_customers_a01_get_default_values();
    // Τα παρακάτω πεδία μου συμπληρώνονται από την default values. Τα σημειωμένα με '--' τα έχω ήδη από τη φόρμα
    // Συμπληρώνω και τα υπόλοιπα.
    //! Να ρωτήσω αν αυτό είναι οκ!

    if($new_record == 1) {
        $screen->data['p02']    = $default_values['p02'] ; // Tρόπος Είσπραξης
        $screen->data['p05']    = $default_values['p05'] ; // Συμμετέχει στη Συγκεντρωτική Τιμολογίων
        $screen->data['p010']   = $default_values['p010']; // Κωδικός Λογιστικής
        $screen->data['pl20']   = $default_values['pl20']; // Δεν ελέγχουμε ΑΦΜ
        $screen->data['p4_1']   = $default_values['p4_1']; // Χώρα
        $screen->data['p4_2']   = $default_values['p4_2']; // Νομός
        $screen->data['p4_3']   = $default_values['p4_3']; // Πόλη
    }

    // var_dump($screen->data);

	$_REQUEST = $screen->data;
	$_REQUEST['no_confirm'] = $no_confirm;
	$ret = $screen->save_data();

	peg_close_d($screen->container_id);

    //Κάνω insert ή update στον πίνακα oila04 ή τον oila10
    if(pegasus_module_exists('oil')){
        //Ελεγχω αν θα πρεπει να ενημερώσω τον πίνακα oila04 ή oila10 αναλογα με το αν εχει επιλεξει καταστημα
        $oil_table = 'oila04';
        $oil_p00  = $a01_nr01;
        if(!empty($data['a01a71'])){
            $oil_table = 'oila10';
            $oil_p00  = $data['a01a71'];
        }
        $oila_update = false;
        $oila_nr01 = pegasus_mysql_printfld($oil_table, 'nr01', 'p00 = ?', array($oil_p00));
        if($new_record == 1 || ($new_record != 1 && empty($oila_nr01))){
            $oila_nr01 = pegasus_mysql_newrec($oil_table);
        }else{
            $oila_update = true;
        }

        $arr1 = array();					$arr2 = array();
            
        array_push($arr1, 'nr01');          array_push($arr2, $oila_nr01);
        array_push($arr1, 'p00');           array_push($arr2, $oil_p00);
        array_push($arr1, 'p01');           array_push($arr2, $data['a01dipethe']);
        array_push($arr1, 'p02');           array_push($arr2, $data['a01dei']);
        if($oila_update){
            pegasus_mysql_update($oil_table, $arr1,  $arr2, 'p00 = ?', 0, 1, 1, array($oil_p00));
        }else{
            pegasus_mysql_insert($oil_table, $arr1,  $arr2);
        }
    }
   
    //ret[0] == false ---> Deny
    //ret[0] == true ----> ΟΚ
    //ret[0] == true ΚΑΙ ret[1] == "μήνυμα" ---> Confirm
	if ($ret[0] == false) {
		$ret_array['ok'] = 0;
		$ret_array['msg'] = $ret[1];
		return $ret_array;
	}

    $ret_array['ok'] = 1;
    $ret_array['data'] = $screen->data;
    if($ret[0] == true && !empty($ret[1])) {
        $ret_array['msg'] = $ret[1];
    }

	return $ret_array;
}

function retail00_save_a55_screen($data, $no_confirm = 0, $account00 = 0)
{
	$ret_array = array();
    $new_record = 0;

    //TODO Εδώ πάντα πρέπει/θα να έρχομαι με γεμάτο a55nr01
    // if(!$data['a55nr01'] > 0) {
    //     $new_record = 1;
    //     $a55_nr01 =  pegasus_mysql_newrec('a55');
    // }else{
    $a55_nr01 = $data['a55nr01'];
    // }

	$screen = new screen();
	$screen->container_id = pegasus_container_id_create(0, session_id(), 'a55_d');
	$screen->module       = 'invcust';
	$screen->_d           = 'a55_d';
	$screen->table        = 'a55';
	$screen->nr01         = $a55_nr01;
	$screen->mnr01        = $a55_nr01;
	$screen->mmnr01       = 'a55_d-' . $a55_nr01;
    // $screen->read_data_from_db(); // Δεν τη θέλω, τρέχει initialize και μου κόβει Nr01.
	$screen->read_params_from_db();
    // $screen->mmnr01       = 'a55_d-' . $a55_nr01;

    if($account00 == 1) {
        $screen->data['y_ekd'] = 1;
    }

	/* ΕΙΣΑΓΩΓΗ ΔΕΔΟΜΕΝΩΝ */
    $screen->data['nr01']   = $a55_nr01;
    $screen->data['p03']    = $data['a01nr01'];
    // $screen->data['p015']   = $data['a55p015'];
    // $screen->data['p015']   = 99; // Καρφωτό "Επί Πιστώσει" για να μην έχει Κωδ. Κιν. Λογιστηρίου
    // $screen->data['p015']   = $_SESSION['retail00_00_a55p015']; // Βασικές Παράμετροι Retail
    if(!empty($data['a55p015'])) {
        $screen->data['p015']   = $data['a55p015']; //* Εδώ θα έχω είτε τον επί πιστώσει από την οθόνη της είσπραξης, είτε των Βασικών Παραμέτρων.
    }else{
        $screen->data['p015']   = $_SESSION['retail00_00_a55p015']; // Βασικές Παράμετροι Retail
    }
    if(!pegasus_check_permission('invcust_old_date_invoice')){
        $data['a55p01'] = date('Y-m-d');
    }

    $screen->data['p01']    = $data['a55p01'];
    $screen->data['p04']    = $data['a01a71'];
    $screen->data['p05']    = $data['a55p05'];
    $screen->data['p07']    = $data['a55p07'];
    // $screen->data['p09']    = $data['a55p09'];
    $screen->data['p09']    = $data['a01p45'];
    $screen->data['p706c']  = $data['a01p803c'];
    $screen->data['p412']   = $data['a01p27'];
    $screen->data['p0100']  = $data['a55p0100'];
    $screen->data['p0101']  = $data['a55p0101'];
    $screen->data['p0102']  = $data['a55p0102'];
    $screen->data['p0102_1']= $data['a55p0102_1'];
    $screen->data['p0102_2']= $data['a55p0102_2'];
    $screen->data['p0105']  = $data['a55p0105'];
    $screen->data['p0108']  = $data['a55p0108'];
    $screen->data['p0109']  = $data['a55p0109'];
    $screen->data['p0112']  = $data['a55p0112'];
    $screen->data['p0113']  = $data['a55p0113'];
    $screen->data['p201']   = $data['a55p201'];
    $screen->data['p202']   = $data['a55p202'];
    $screen->data['p203']   = $data['a55p203'];
    $screen->data['p204']   = $data['a55p204'];
    $screen->data['p205']   = $data['a55p205'];
    $screen->data['p206']   = $data['a55p206'];
    $screen->data['p207']   = $data['a55p207'];
    $screen->data['p208']   = $data['a55p208'];
    $screen->data['p209']   = $data['a55p209'];
    $screen->data['p301']   = $data['a55p301'];
    $screen->data['p302']   = $data['a55p302'];
    $screen->data['p303']   = $data['a55p303'];
    $screen->data['p304']   = $data['a55p304'];
    $screen->data['p305']   = $data['a55p305'];
    $screen->data['p306']   = $data['a55p306'];
    $screen->data['p307']   = $data['a55p307'];
    $screen->data['p308']   = $data['a55p308'];
    $screen->data['p309']   = $data['a55p309'];
    $screen->data['p410']   = $data['a55p410'];
    $screen->data['p420']   = $data['a55p420'];
    $screen->data['p506']   = $data['a55p506'];
    $screen->data['p0600']  = $data['a55p0600'];
    $screen->data['p0601']  = $data['a55p0601'];
    $screen->data['p703']   = $data['a55p703'];
    $screen->data['vp0112'] = $data['a55vp0112'];
    $screen->data['vp0113'] = $data['a55vp0113'];
    
    $a55p02 = date('H:i');
    if(!empty($data['a55p02'])) {
        $a55p02 = $data['a55p02'];
    }

    $screen->data['p02']   = $a55p02;
    $screen->data['pn02']  = $data['a55pn02'];
    $screen->data['pn01']  = $data['a55pn01'];
    $screen->data['p705']  = $data['a55p705'];
    $screen->data['p701']  = $data['a55p701']; 
    $screen->data['p06']   = $data['a55p06'];  
    $screen->data['p0121'] = $data['a55p0121'];
    $screen->data['p503']  = $data['a55p503'];
    $screen->data['p504']  = $data['a55p504'];
    $screen->data['p016']  = $data['a55p016'];
    // $screen->data['p30']   = $data['a55p30'];
    // var_dump($screen->data);

    $screen->data['p017'] = $data['a55p017'];
    $screen->data['p08']  = $data['a55p08'];
    $screen->data['p704'] = $data['a55p704'];
    $screen->data['p411'] = $data['a55p411'];
    $screen->data['p413'] = $data['a55p413'];
    $screen->data['p415'] = $data['a55p415'];
    $screen->data['p416'] = $data['a55p416'];
    $screen->data['p417'] = $data['a55p417'];
    $screen->data['p418'] = $data['a55p418'];

    $screen->data['p010']   = $data['a55p010'];
    $screen->data['p011']   = $data['a55p011'];
    $screen->data['p012']   = $data['a55p012'];
    $screen->data['p013']   = $data['a55p013'];
    $screen->data['p014']   = $data['a55p014'];
    $screen->data['p702']   = $data['a55p702'];
    $screen->data['p016a']  = $data['a55p016a'];
    $screen->data['p507']   = $data['a55p507'];
    $screen->data['p806']   = $data['a55p806'];
    $screen->data['p807']   = $data['a55p807'];
    $screen->data['p501']   = $data['a55p501'];
    $screen->data['p502']   = $data['a55p502'];
    $screen->data['p0109_1']= $data['a55p0109_1'];
    $screen->data['pweb01'] = $data['a55pweb01'];

    $screen->data['d_p01']  = $data['a55d_p01'];
    $screen->data['d_p02']  = $data['a55d_p02'];

    $screen->data['ldstreet']   = $data['a55ldstreet'];
    $screen->data['ldnumber']   = $data['a55ldnumber'];
    $screen->data['ldzip']      = $data['a55ldzip'];
    $screen->data['ldcity']     = $data['a55ldcity'];
    $screen->data['ss_branch']  = $data['a55ss_branch'];

    $screen->data['dlvstreet']  = $data['a55dlvstreet'];
    $screen->data['dlvnumber']  = $data['a55dlvnumber'];
    $screen->data['dlvzip']     = $data['a55dlvzip'];
    $screen->data['dlvcity']    = $data['a55dlvcity'];
    $screen->data['cs_branch']  = $data['a55cs_branch'];


    $a55p30 = $data['a55p30'];
    if($no_confirm == 1 && $account00 == false) {
        $t01_query = 'SELECT * FROM t01 WHERE p302 = :a55nr01 AND p303 = 9';
        $t01_res = pegasus_query($t01_query, array('a55nr01' => $a55_nr01));
        //* Αν έχω μόνο μια κίνηση με όλο το ποσό για το παραστατικό, αλλάζω τον Τρόπο Είσπραξης του παραστατικού σε αυτόν της κίνησης.
        //* Κρατάω τον Τρόπο Είσπραξης στο t01.remguc ----> αλλαξε σε t01.pd102
        if(pegasus_num_rows($t01_res) == 1) {
            while($row = pegasus_fetch($t01_res, PEG_FETCH_ASSOC)) {
                if (abs($row['pn03'] + $row['pn04']) == 0) {
                    $t01_total = abs($row['p03'] + $row['p04']);
                } else {
                    $t01_total = abs($row['pn03'] + $row['pn04']);
                }
                //* Επιπλέον failsafe αν η κίνηση έχει όλο το ποσό του παραστατικού
                if($data['a55p0109'] - $t01_total == 0) {
                    $screen->data['p015'] = $row['pd102'];
                    $is_pos = 0;
                    if(pegasus_module_exists('pos00')) {
                        $pos00_02 = pos00_find_pos00_02($row['pd102'], $_SESSION["cor003_p01"]);
                        if(!empty($pos00_02)) {
                            $is_pos = 1;
                        }
                    }
                    //* Αν η κίνηση αφορά πληρωμή από POS, τότε κρατάμε την κατηγορία της σε 9.
                    if($is_pos == 0) {
                        pegasus_mysql_update('t01', array('p303'), array(4), 'nr01 = ?', 0, 1, 1, array($row['nr01']));
                    }
                }
            }
        }else{
            //* Σημειώσεις για την κάθε κίνηση πρσθέτουμε μόνο όταν είναι παραπάνω από μία.
            while($row = pegasus_fetch($t01_res, PEG_FETCH_ASSOC)) {
                if(!empty($a55p30)) {
                    $a55p30 .= "\n";
                }
                $a55p30 .= $row['p05'] . ": " . $row['p04'];
            }
        }
    }

    $screen->data['p30']   = $a55p30;

	$_REQUEST = $screen->data;
	$_REQUEST['no_confirm'] = $no_confirm;
	$ret = $screen->save_data();

	peg_close_d($screen->container_id);

    //ret[0] == false ---> Deny
    //ret[0] == true ----> ΟΚ
    //ret[0] == true ΚΑΙ ret[1] == "μήνυμα" ---> Confirm
	if ($ret[0] == false) {
		$ret_array['ok'] = 0;
		$ret_array['msg'] = $ret[1];
		return $ret_array;
	}

    $ret_array['ok'] = 1;
    $ret_array['data'] = $screen->data;
    if($ret[0] == true && !empty($ret[1])) {
        $ret_array['msg'] = $ret[1];
    }

	return $ret_array;
}

/**
 * Αν χρειαστεί να προστεθεί αυτόματη καταχώρηση είδους από την find_product_data
 * σε παραστατικά κ.ο.κ με X-M, Serial ή Παρτίδα
 * θα πρέπει να μεταφέρουμε/τροποποιήσουμε την παρακάτω function από το retail στο invoices
 */
function retail00_after_find_save_product_data($result_arr, $retail00_01_a55_nr01, $mode, $v172 = '', $v173 = '', $v161 = '', $ser = '') {
    // Στο Retail το έχω πάντα κενό το i01_nr01 γιατί δεν μπορώ να κάνω αλλαγή είδους όπως στα παραστατικά.
    $update_i01_p03 = 0;
    // echo '<pre>' .print_r($result_arr, 1). '</pre>'; 
    $result_arr['retail00_show_price_window'] = 1;

    if(pegasus_module_exists('retail01')) {
        pegasus_mysql_use('SELECT nr01 FROM retail01_01 WHERE i00pno = :v101', $retail01_01, array("v101" => $result_arr['v101']));
    }
    // 25/01/2024 - Προσθεσαμε στο if αν έχει ποσότητα συσκευασίας να το βάζει πάντα σε νέα γραμμή
    // διότι δεν μπορούμε να ελέγξουμε με σιγουριά, από ποιον κωδικό ήρθε.
    // Προσθέσαμε και στο select να ψάχνει για ίδιο κωδικό ΚΑΙ ποσότητα συσκευασίας = 0
    // ώστε να μην πάει να προσθέσει στην ίδια γραμμή κάποιου καταχωρημένου είδους με ποσ. συσκευασίας.
    // -----
    // 14/03/2024 - Αν το είδος που προσθέτω το έχω αντιστοιχίσει σε Τμήμα Ταμειακής, τότε το προσθέτω πάντα σε νέα γραμμή
    if($_SESSION['retail00_00_p03'] == 0 && empty($result_arr['v1030_1']) && empty($retail01_01['nr01'])) {
        pegasus_mysql_use(
            'SELECT * FROM peg_tmp_i01 WHERE p01 = :v101 AND p030_1 = 0 AND peg_sess_id = :peg_sess_id AND peg_mnr01 = :peg_mnr01 AND peg_mmnr01 = :peg_mmnr01 AND peg_flag <> 9', 
            $existing_record_i01, 
            array(
                "v101" => $result_arr['v101'],
                "peg_sess_id" => session_id(),
                "peg_mnr01" => $retail00_01_a55_nr01,
                "peg_mmnr01" => "a55_d-".$retail00_01_a55_nr01
            )
        );
    }


    if(empty($result_arr['i01_nr01'])) {
        //* Αν βρω ίδιο κωδικό στο καλάθι, σετάρω το $update_i01_p03 = 1 για να αυξήσω ποσότητα
        //* Συμφωνήσαμε ότι το μόνο που θα κοιτάμε είναι ο κωδικός
        if($existing_record_i01['nr01'] > 0) {
            $update_i01_p03 = 1;
            $i01_nr01 = $existing_record_i01['nr01'];
        }else{
            $i01_nr01 = pegasus_mysql_newrec('i01');
        }
        $result_arr['i01_nr01'] = $i01_nr01;
    }else{
        $i01_nr01 = $result_arr['i01_nr01'];
    }
    
    if(!empty($v172) && !empty($v173)) { // Αν έχω χρώμα (v172) και μέγεθος (v173)
        $update_i48_p04 = 0;
        //* Μόνο αν έχω flag για αύξηση ποσότητας στο i01, ελέγχω αν το Χ-Μ υπάρχει στον i48 για να αυξήσω ποσότητα αν είναι ίδιο.
        if($update_i01_p03 == 1) {
            pegasus_mysql_use(
                'SELECT * FROM peg_tmp_i48 WHERE 
                    i01p01 = :v101 AND p02 = :v172 AND p03 = :v173
                    AND peg_sess_id = :peg_sess_id AND peg_mnr01 = :peg_mnr01 AND peg_mmnr01 = :peg_mmnr01 AND peg_flag <> 9', 
                $existing_record_i48, 
                array(
                    "v101" => $result_arr['v101'],
                    "v172" => $v172,
                    "v173" => $v173,
                    "peg_sess_id" => session_id(),
                    "peg_mnr01" => $existing_record_i01['nr01'],
                    "peg_mmnr01" => "a55_d-".$retail00_01_a55_nr01
                )
            );
            //* Αν βρω ίδιο Χ-Μ στο καλάθι, σετάρω το $update_i48_p04 = 1 για να αυξήσω ποσότητα στον i48
            if($existing_record_i48['nr01'] > 0) {
                $update_i48_p04 = 1;
            }
        }

        if($update_i48_p04 == 1) {
            $new_i48_p04 = $existing_record_i48['p04'] + 1; //i01.p03
            $where = ' i01p01 = :v101 AND p02 = :v172 AND p03 = :v173 AND peg_sess_id = :peg_sess_id AND peg_mnr01 = :peg_mnr01 AND peg_mmnr01 = :peg_mmnr01 AND peg_flag <> 9 ';
            $whereValues = array(
                "v101" => $result_arr['v101'],
                "v172" => $v172,
                "v173" => $v173,
                "peg_sess_id" => session_id(),
                "peg_mnr01" => $existing_record_i01['nr01'],
                "peg_mmnr01" => "a55_d-".$retail00_01_a55_nr01
            );
            pegasus_mysql_update('peg_tmp_i48', array('p04'), array($new_i48_p04), $where, 0, 1, 1, $whereValues);
        }else{
            $i48_nr01 = pegasus_mysql_newrec('i48');
            $arr1 = array();					$arr2 = array();
            
            array_push($arr1, 'nr01');            array_push($arr2, $i48_nr01);
            array_push($arr1, 'p01');             array_push($arr2, $i01_nr01);
            array_push($arr1, 'i01p01');          array_push($arr2, $result_arr['v101']);
            array_push($arr1, 'p02');             array_push($arr2, $v172);
            array_push($arr1, 'p03');             array_push($arr2, $v173);
            array_push($arr1, 'p04');             array_push($arr2, 1);
    
            array_push($arr1, 'peg_mmnr01');      array_push($arr2, 'a55_d-'.$retail00_01_a55_nr01);
            array_push($arr1, 'peg_mnr01');       array_push($arr2, $i01_nr01); // mnr01 το μκ της κίνησης
            array_push($arr1, 'peg_sess_id');     array_push($arr2, session_id());
            array_push($arr1, 'peg_flag');        array_push($arr2, 1);
    
            pegasus_mysql_insert('peg_tmp_i48', $arr1, $arr2);
        }
        //Αν έχω Χ-Μ, τότε το i01.v103 έχει έρθει 0. Εφόσον πρόσθεσα 1 στην κίνηση Χ-Μ, κάνω 1 το v103
        $result_arr['v103'] = 1;
    }elseif(!empty($ser)) { //Αν έχω Serial Number
        $i32_nr01 = pegasus_mysql_newrec('i32');
        $arr1 = array();			$arr2 = array();
        array_push($arr1, 'nr01'); 	array_push($arr2, $i32_nr01);
        array_push($arr1, 'p01');	array_push($arr2, $result_arr['v101']);
        array_push($arr1, 'p02');	array_push($arr2, $ser);
        array_push($arr1, 'p00');	array_push($arr2, $i01_nr01);
        //! Κωδικός κατηγόρίας κίνησης 'p010' ???
        array_push($arr1, 'p010');	array_push($arr2, '1');

        array_push($arr1, 'peg_mmnr01');    array_push($arr2, 'a55_d-'.$retail00_01_a55_nr01);//retail 15/05 na allaxe se a55_d-
        array_push($arr1, 'peg_mnr01');     array_push($arr2, $i01_nr01); //! mnr01 το μκ της κίνησης;
        array_push($arr1, 'peg_sess_id');   array_push($arr2, session_id());
        array_push($arr1, 'peg_flag');      array_push($arr2, 1);

        pegasus_mysql_insert('peg_tmp_i32', $arr1, $arr2);
        //Αυξανω την ποσότητα
        $result_arr['v103']++;
    }elseif(!empty($v161)) { // Αν έχω Παρτίδα
        //* Ιδια λογικη Χ-Μ για την αυξηση ποσότητας
        //* Μόνο αν έχω flag για αύξηση ποσότητας στο i01, ελέγχω αν η παρτίδα υπάρχει στον i38 για να αυξήσω ποσότητα αν είναι ίδιο.
        $update_i38_p04 = 0;
        if($update_i01_p03 == 1) {
            pegasus_mysql_use(
                'SELECT * FROM peg_tmp_i38 WHERE 
                    p01 =:i01_nr01 AND p02 = :v161
                    AND peg_sess_id = :peg_sess_id AND peg_mnr01 = :peg_mnr01 AND peg_mmnr01 = :peg_mmnr01 AND peg_flag <> 9', 
                $existing_record_i38, 
                array(
                    "i01_nr01" => $existing_record_i01['nr01'],
                    "v161" => $v161,
                    "peg_sess_id" => session_id(),
                    "peg_mnr01" => $existing_record_i01['nr01'],
                    "peg_mmnr01" => "a55_d-".$retail00_01_a55_nr01
                )
            );
            //* Αν βρω ίδια παρτίδα στο καλάθι, σετάρω το $update_i48_p04 = 1 για να αυξήσω ποσότητα στον i48
            if($existing_record_i38['nr01'] > 0) {
                $update_i38_p04 = 1;
            }
        }
        if($update_i38_p04 == 1) {
            $new_i38_p04 = $existing_record_i38['p04'] + 1; //i01.p03
            $where = ' p01 =:i01_nr01 AND p02 = :v161 AND peg_sess_id = :peg_sess_id AND peg_mnr01 = :peg_mnr01 AND peg_mmnr01 = :peg_mmnr01 AND peg_flag <> 9 ';
            $whereValues = array(
                "i01_nr01" => $existing_record_i01['nr01'],
                "v161" => $v161,
                "peg_sess_id" => session_id(),
                "peg_mnr01" => $existing_record_i01['nr01'],
                "peg_mmnr01" => "a55_d-".$retail00_01_a55_nr01
            );
            pegasus_mysql_update('peg_tmp_i38', array('p04'), array($new_i38_p04), $where, 0, 1, 1, $whereValues);
        }else{
            $i38_nr01 = pegasus_mysql_newrec('i38');
            $arr1 = array();                    $arr2 = array();
            array_push($arr1, 'nr01');          array_push($arr2, $i38_nr01);
    
            array_push($arr1, 'p01');           array_push($arr2, $i01_nr01); //MK Κίνησης
            array_push($arr1, 'p02');           array_push($arr2, $v161);   // Παρτίδα
            array_push($arr1, 'p010');          array_push($arr2, 1);       // Είδος κίνησης (1/2/3/4)
            array_push($arr1, 'p04');           array_push($arr2, 1);	    // Ποσότητα
            array_push($arr1, 'p05');           array_push($arr2, 1);	    // Τεμάχια
    
            array_push($arr1, 'peg_mmnr01');    array_push($arr2, 'a55_d-'.$retail00_01_a55_nr01);
            array_push($arr1, 'peg_mnr01');     array_push($arr2, $i01_nr01); // mnr01 το μκ της κίνησης
            array_push($arr1, 'peg_sess_id');   array_push($arr2, session_id());
            array_push($arr1, 'peg_flag');      array_push($arr2, 1);
            
            pegasus_mysql_insert('peg_tmp_i38', $arr1, $arr2);
        }

        //Αν έχω v161, τότε το i01.v103 έχει έρθει 0. Εφόσον πρόσθεσα 1 στην κίνηση παρτίδας, κάνω 1 το v103
        $result_arr['v103'] = 1;
    }

    if($update_i01_p03 == 1) {
        $new_i01_p03 = $existing_record_i01['p03'] + $result_arr['v103'];
        $where = ' nr01 = :nr01 AND p01 = :v101 AND peg_sess_id = :peg_sess_id AND peg_mnr01 = :peg_mnr01 AND peg_mmnr01 = :peg_mmnr01 AND peg_flag <> 9 ';
        $whereValues = array(
            "nr01" => $existing_record_i01['nr01'], // Για να ενημερώσει μόνο την τρέχουσα αν εχει 2 εγγραφές στο καλάθι του
            "v101" => $result_arr['v101'],
            "peg_sess_id" => session_id(),
            "peg_mnr01" => $retail00_01_a55_nr01,
            "peg_mmnr01" => "a55_d-".$retail00_01_a55_nr01
        );
        pegasus_mysql_update('peg_tmp_i01', array('p03'), array($new_i01_p03), $where, 0, 1, 1, $whereValues);
    }else{
        $arr1 = array();                            $arr2 = array();
        array_push($arr1, 'nr01');					array_push($arr2, $i01_nr01);

        array_push($arr1, 'p01'  );                 array_push($arr2, $result_arr['v101']);
        array_push($arr1, 'p02'  );                 array_push($arr2, $result_arr['v102']);
        array_push($arr1, 'p0601');                 array_push($arr2, $result_arr['v160']);
        array_push($arr1, 'p030' );                 array_push($arr2, $result_arr['v120']);
        array_push($arr1, 'p301' );                 array_push($arr2, $result_arr['v301']);
        array_push($arr1, 'p302' );                 array_push($arr2, $result_arr['v302']);
        array_push($arr1, 'p303' );                 array_push($arr2, $result_arr['v303']);
        array_push($arr1, 'p304' );                 array_push($arr2, $result_arr['v304']);
        array_push($arr1, 'p306' );                 array_push($arr2, $result_arr['v306']);
        array_push($arr1, 'p307' );                 array_push($arr2, $result_arr['v307']);
        array_push($arr1, 'p04'  );                 array_push($arr2, $result_arr['v104']);
        array_push($arr1, 'p08'  );                 array_push($arr2, $result_arr['fpa']);
        array_push($arr1, 'p081' );                 array_push($arr2, $result_arr['kfpa']);
        array_push($arr1, 'p010' );                 array_push($arr2, $result_arr['v106']);
        array_push($arr1, 'p010a');                 array_push($arr2, $result_arr['v106a']);
        array_push($arr1, 'p041' );                 array_push($arr2, $result_arr['v1041']);
        array_push($arr1, 'p616' );                 array_push($arr2, $result_arr['v616']);
        array_push($arr1, 'p616p');                 array_push($arr2, $result_arr['p616p']);
        array_push($arr1, 'p309' );                 array_push($arr2, $result_arr['v309']);
        array_push($arr1, 'p308' );                 array_push($arr2, $result_arr['v308']);
        array_push($arr1, 'p614' );                 array_push($arr2, $result_arr['v614']);
        array_push($arr1, 'p03'  );                 array_push($arr2, $result_arr['v103']);
        array_push($arr1, 'p030_1');                array_push($arr2, $result_arr['v1030_1']);
        array_push($arr1, 'p04_1' );                array_push($arr2, $result_arr['v104_1']);

        array_push($arr1, 'timh1' );                 array_push($arr2, $result_arr['timh1']);
        array_push($arr1, 'timh2' );                 array_push($arr2, $result_arr['timh2']);
        array_push($arr1, 'timh3' );                 array_push($arr2, $result_arr['timh3']);
        array_push($arr1, 'timh4' );                 array_push($arr2, $result_arr['timh4']);

        array_push($arr1, 'p06');			        array_push($arr2, $retail00_01_a55_nr01);
        array_push($arr1, 'p07');			        array_push($arr2, '2');

        array_push($arr1, 'p09');			        array_push($arr2, pegasusGetGlobalVar('peg_a55_d-' .  $retail00_01_a55_nr01 .'_p07'));

        array_push($arr1, 'p013');			        array_push($arr2, date('Y-m-d')); // Ημερομηνία
        array_push($arr1, 'p05');			        array_push($arr2, 300); //Κωδικός Κίνησης Αποθήκης
        
        array_push($arr1, 'peg_mmnr01');			array_push($arr2, 'a55_d-'.$retail00_01_a55_nr01);
        array_push($arr1, 'peg_mnr01');			    array_push($arr2, $retail00_01_a55_nr01);
        array_push($arr1, 'peg_sess_id');			array_push($arr2, session_id());
        array_push($arr1, 'peg_flag');              array_push($arr2, 1);

        pegasus_mysql_insert('peg_tmp_i01', $arr1, $arr2);

        //* Προσθέτω και τις σημειώσεις του είδους αν υπάρχουν
        if(!empty($result_arr['v_a90_p30'])) {
            $a90_nr01 = pegasus_mysql_newrec('i38');
            $arr1 = array();                            $arr2 = array();
            array_push($arr1, 'nr01');					array_push($arr2, $a90_nr01);
            array_push($arr1, 'p30');					array_push($arr2, $result_arr['v_a90_p30']);
            array_push($arr1, 'tbl');					array_push($arr2, 'i01');
            array_push($arr1, 'tbl_nr01');				array_push($arr2, $i01_nr01);
            array_push($arr1, 'peg_mmnr01');			array_push($arr2, 'a55_d-'.$retail00_01_a55_nr01);
            array_push($arr1, 'peg_mnr01');			    array_push($arr2, $i01_nr01);
            array_push($arr1, 'peg_sess_id');			array_push($arr2, session_id());
            array_push($arr1, 'peg_flag');              array_push($arr2, 1);
    
            pegasus_mysql_insert('peg_tmp_a90', $arr1, $arr2);
        }
    }
    //Στην περίπτωση που έχουμε ήδη προσθέσει το είδος οταν το ξαναεπιλέξουμε δεν θέλουμε να ανοιξει η οθονη τελευταίας τιμής πώλησης 
    //γι αυτό κανουμε return το flag retail00_i01_d2 = 0
    if($update_i01_p03 == 1) {
        $result_arr['retail00_show_price_window'] = 0;
    }

    //* Εδώ θα βρω το stock_screen και θα έρθω να το γυρίσω σε μηνυμα για toast.


    return $result_arr;
}

function retail00_get_i01_data($i01_nr01, $a55nr01, $container_id) {
    $data = array();
    $mmnr01 = 'a55_d-' . $a55nr01; //retail 15/05 na allaxei
    $mnr01  = $a55nr01;
    pegasus_mysql_use('SELECT * FROM peg_tmp_i01 WHERE nr01 = ? ', $data, array($i01_nr01));

    //To '1' στο τέλος είναι το $is_retail.
    if($i01_nr01 == -1) {
        // -1 Του δίνω όταν η getSelectedRow του grid επιστρέψει false.
        // Για να μην κοψει ΜΚ η Initialize
        $data['nr01'] = -1;
    }
    $data = peg_invoices_i01_d10_initialize($data, $mmnr01, $mnr01, 'retail00_01_d03', $container_id, 1);

    if(!empty($data['p01'])) {
        pegasusSetGlobalVar(
            $container_id.'_i01_p01',
            $data['p01']
        );
    }

    $data['i01nr01'] = $data['nr01']; //for obvious reasons.
    // Λεκτικά Ομάδων
    $data['retail00_06'] = '';
    $data['retail00_06_hidden'] = 2;
    if(!empty($data['p01'])) {
        $retail00_06 = retail00_draw_retail00_06($container_id, $data['p01']);
        if(!empty($retail00_06)) {
            $data['retail00_06'] = $retail00_06;
            $data['retail00_06_hidden'] = 0;
        }
    }
    
    $data['i48_records'] = '';
    if($data['has_color_size'] == 1) {
        //TODO Να μπουν και τα υπολοιπα πχ peg_mnr01 .....
        $query = '  SELECT * FROM peg_tmp_i48 
                    WHERE 
                        p01 = :i01_nr01 
                        AND peg_mnr01 = :peg_mnr01
                        AND peg_mmnr01 = :peg_mmnr01
                        AND peg_sess_id = :peg_sess_id
                        AND peg_flag <> 9';
        $queryParams = array(
            'i01_nr01' => $i01_nr01,
            'peg_mnr01' => $i01_nr01,
            'peg_mmnr01' => $mmnr01,
            'peg_sess_id' => session_id()
        );
        $i = 1;
        $res = pegasus_query($query, $queryParams);
        if(pegasus_num_rows($res) > 0) {
            $data['i48_records'] = array();
            $i48_array = array();
            while($row = pegasus_fetch($res, PEG_FETCH_ASSOC)) {
                $i47nr01 = pegasus_mysql_printfld('i47', 'nr01', 'p01 = :p01 and p02 = :p02 and p03 = :p03', array('p01' => $data['p01'], 'p02' => $row['p02'], 'p03' => $row['p03']));
                // $i48_array[] = $row;
                $i48_array['i48_rec_nr01_'.$i]  = $row['nr01'];
                $i48_array['i48_rec_p02_' .$i]  = $row['p02'];
                $i48_array['i48_rec_p03_' .$i]  = $row['p03'];
                $i48_array['i48_rec_v_p02p03_' .$i]  = pegasus_mysql_printfld('i40', 'p02', 'p01 = ?', array($row['p02'])) . ' - ' . pegasus_mysql_printfld('i43', 'p02', 'p01 = ?', array($row['p03']));
                $i48_array['i48_rec_i47nr01_' .$i] = $i47nr01;
                $i48_array['i48_rec_quan_' .$i] = $row['p04'];
                $i++;
            }
            $data['i48_records'] = $i48_array;
        }
    }

    $data['i32_records'] = '';

    if($data['has_serial'] == 1) {
        $query = '  SELECT * FROM peg_tmp_i32 
                    WHERE 
                        p00 = :i01_nr01 
                        AND peg_mnr01 = :peg_mnr01
                        AND peg_mmnr01 = :peg_mmnr01
                        AND peg_sess_id = :peg_sess_id
                        AND peg_flag <> 9';
        $queryParams = array(
            'i01_nr01' => $i01_nr01,
            'peg_mnr01' => $i01_nr01,
            'peg_mmnr01' => $mmnr01,
            'peg_sess_id' => session_id()
        );
        $i = 1;
        $res = pegasus_query($query, $queryParams);
        if(pegasus_num_rows($res) > 0) {
            $data['i32_records'] = array();
            $i32_array = array();
            while($row = pegasus_fetch($res, PEG_FETCH_ASSOC)) {
                $i32_array['i32_rec_nr01_'.$i]  = $row['nr01'];
                $i32_array['i32_rec_p01_'.$i]   = $row['p02'];
                $i++;
            }
            $data['i32_records'] = $i32_array;
        }
    }

    $data['i38_records'] = '';
    if($data['has_lot'] == 1) {
        $query = '  SELECT * FROM peg_tmp_i38 
                    WHERE 
                        p01 = :i01_nr01 
                        AND peg_mnr01 = :peg_mnr01
                        AND peg_mmnr01 = :peg_mmnr01
                        AND peg_sess_id = :peg_sess_id
                        AND peg_flag <> 9';
        $queryParams = array(
            'i01_nr01' => $i01_nr01,
            'peg_mnr01' => $i01_nr01,
            'peg_mmnr01' => $mmnr01,
            'peg_sess_id' => session_id()
        );
        $i = 1;
        $res = pegasus_query($query, $queryParams);
        if(pegasus_num_rows($res) > 0) {
            $data['i38_records'] = array();
            $i38_array = array();
            while($row = pegasus_fetch($res, PEG_FETCH_ASSOC)) {
                $i38_array['i38_rec_nr01_'.$i]  = $row['nr01'];
                $i38_array['i38_rec_p02_'.$i]   = $row['p02'];
                $i38_array['i38_rec_quan_' .$i] = $row['p04'];
                $i++;
            }
            $data['i38_records'] = $i38_array;
        }
    }

    $data['retail00_01_d03_weigh_btn_hidden'] = true;
    $data['retail00_01_d03_weigh_btn_p030_hidden'] = true;

    $retail00_00_i24p01_arr = explode('#', $_SESSION['retail00_00_i24p01']);
    
    $retail00_00_i24p01 = pegasus_mysql_printfld("retail00_04", "i24p01", "cor003p01 = ?", array($_SESSION['pegasus_client_uid']));
    if(!empty($retail00_00_i24p01)){
        $retail00_00_i24p01_arr = explode('#', $retail00_00_i24p01);
    }

    if(in_array($data['v_i00_ths'], $retail00_00_i24p01_arr) && $data['has_color_size'] == 0 && $data['has_serial'] != 1){
        // η Ζυγαριά θα εμφανιστεί αν η ΜΜ δεν έχει τσεκαρισμένο κανένα ή μόνο ένα "στις κινήσεις δίνουμε"
        pegasus_mysql_use("SELECT p101, p102, p103, p104, p106, p107, p108, p109, p110 FROM i24 WHERE i24.p01 = ? ",$i24, array($data['v_i00_ths']));
        if(is_array($i24) && count(array_filter($i24))<2){
            $data['retail00_01_d03_weigh_btn_hidden'] = false;
        }
        if($_SESSION['f02_p637'] == 1 && $data['has_lot']){
            $data['retail00_01_d03_weigh_btn_hidden'] = true;
        }
    }
    if(in_array($data['v_i00_p200'], $retail00_00_i24p01_arr) && $data['has_color_size'] == 0 && $data['has_serial'] != 1){
        // η Ζυγαριά θα εμφανιστεί αν η ΜΜ δεν έχει τσεκαρισμένο κανένα ή μόνο ένα "στις κινήσεις δίνουμε"
        pegasus_mysql_use("SELECT p101, p102, p103, p104, p106, p107, p108, p109, p110 FROM i24 WHERE i24.p01 = ? ",$i24, array($data['v_i00_p200']));
        if(is_array($i24) && count(array_filter($i24))<2){
            if($data['retail00_01_d03_p030_hidden'] == 0 ){
                $data['retail00_01_d03_weigh_btn_p030_hidden'] = false;
            }
        }

        if($_SESSION['f02_p637'] == 1 && $data['has_lot']){
            $data['retail00_01_d03_weigh_btn_hidden'] = true;
        }
        
    }

    if(empty($i01_nr01) || $i01_nr01 == -1) {
        //* Τα βάζω εδώ να γίνονται hidden γιατί στην peg_invoices_i01_d10_initialize αρχικοποιούν το hidden πάντα με 0 αν έχει invspcodes 
        //* με αποτέλεσμα να μην μπορεί να παίξει όπως τα υπόλοιπα.
        $data['retail00_01_d03_p04_1_hidden'] = true;
        $data['retail00_01_d03_p030_1_hidden'] = true;
        $data['retail00_01_d03_weigh_btn_hidden'] = true;
        $data['retail00_01_d03_weigh_btn_p030_hidden'] = true;
        
        $data['retail00_01_d03_p042_hidden'] = true;
        $data['retail00_01_d03_p616_hidden'] = true;
        $data['retail00_01_d03_p041_hidden'] = true;
    }
    // echo '<pre>' .print_r($data, 1). '</pre>';
    return $data;
}

function retail00_update_i01($data) {
	$ret_array = array();

	$screen = new screen();
	$screen->container_id = pegasus_container_id_create(0, session_id(), 'i01_d');
	$screen->module       = 'invtrans';
	$screen->_d           = 'i01_d';
	$screen->table        = 'peg_tmp_i01';
	$screen->nr01         = $data['i01nr01'];
	$screen->mnr01        = $data['a55nr01'];
	$screen->mmnr01       = 'a55_d-' . $data['a55nr01'];
    // $screen->read_data_from_db(); 
	$screen->read_params_from_db();

	/* ΕΙΣΑΓΩΓΗ ΔΕΔΟΜΕΝΩΝ */
    $screen->data = $data;
    $screen->data['nr01']   = $data['i01nr01'];
    $screen->data['peg_tmp_var_v172'] = $data['v172'];
    $screen->data['peg_tmp_var_v173'] = $data['v173'];
    
    // var_dump($screen->data);

	$_REQUEST = $screen->data;
	// $_REQUEST['no_confirm'] = $no_confirm;
	$ret = $screen->save_data();

	peg_close_d($screen->container_id);

    //ret[0] == false ---> Deny
    //ret[0] == true ----> ΟΚ
    //ret[0] == true ΚΑΙ ret[1] == "μήνυμα" ---> Confirm
	if ($ret[0] == false) {
		$ret_array['ok'] = 0;
		$ret_array['msg'] = $ret[1];
		return $ret_array;
	}

    $ret_array['ok'] = 1;
    $ret_array['data'] = $screen->data;
    if($ret[0] == true && !empty($ret[1])) {
        $ret_array['msg'] = $ret[1];
    }

	return $ret_array;
}

function retail00_update_sub_tmps($data) {

    if($data['v_cs_en'] == 1) {
        $pattern_i48_nr01  = '/^i48_rec_nr01_(\d+)$/';
        $pattern_i48_p01   = '/^i48_rec_p01_(\d+)$/';   
        $pattern_i48_quan  = '/^i48_rec_quan_(\d+)$/';   
        $i48_records = array();
        foreach ($data as $key => $value) {
            if (preg_match($pattern_i48_nr01, $key, $matches)) {
                $index = $matches[1];
                $i48_records[$index]['nr01'] = $value;
            } elseif (preg_match($pattern_i48_p01, $key, $matches)) {
                $index = $matches[1];
                $i48_records[$index]['p01'] = $value;
            } elseif (preg_match($pattern_i48_quan, $key, $matches)) {
                $index = $matches[1];
                $i48_records[$index]['quan'] = $value;
            }
        }
        // Update peg_tmp_i48 records of this invoice to peg_flag = 9
        pegasus_mysql_update(
            'peg_tmp_i48', 
            array('peg_flag'), 
            array(9), 
            'peg_mnr01 = :mnr01 AND peg_mmnr01 = :mmnr01 and peg_sess_id = :sid',
            0,
            1,
            1,
            array('mnr01' => $data['i01nr01'], 'mmnr01' => 'a55_d-'.$data['a55nr01'], 'sid' => session_id())
        );
        foreach ($i48_records as $value) {
            // echo '<pre>' .print_r($value, 1). '</pre>';
            pegasus_mysql_use('SELECT p02, p03 FROM i47 WHERE nr01 = ?', $i47, array($value['p01']));
            $peg_flag = 0;
            if(!empty($value['nr01'])) {
                $peg_flag = 2;
                $i48_nr01 = $value['nr01'];
    
                $arr1 = array();					  $arr2 = array();
                
                array_push($arr1, 'p01');             array_push($arr2, $data['i01nr01']); // Κωδικός i01 Κίνησης
                array_push($arr1, 'i01p01');          array_push($arr2, $data['p01']); // Κωδικός Είδους
                array_push($arr1, 'p02');             array_push($arr2, $i47['p02']); // Χρώμα
                array_push($arr1, 'p03');             array_push($arr2, $i47['p03']); // Μέγεθος
                array_push($arr1, 'p04');             array_push($arr2, $value['quan']); //Ποσότητα
    
                array_push($arr1, 'peg_flag');        array_push($arr2, $peg_flag); //Flag για update
    
                pegasus_mysql_update(
                    'peg_tmp_i48', 
                    $arr1, 
                    $arr2, 
                    'nr01 = :nr01 AND peg_mnr01 = :mnr01 AND peg_mmnr01 = :mmnr01 and peg_sess_id = :sid', 
                    0,
                    1,
                    1,
                    array('nr01' => $i48_nr01, 'mnr01' => $data['i01nr01'], 'mmnr01' => 'a55_d-'.$data['a55nr01'], 'sid' => session_id())
                );
            }elseif(empty($value['nr01']) && !empty($value['p01'])){
                $peg_flag = 1;
                $i48_nr01 = pegasus_mysql_newrec('i48');
                $arr1 = array();					  $arr2 = array();
                
                array_push($arr1, 'nr01');            array_push($arr2, $i48_nr01); // MK
                array_push($arr1, 'p01');             array_push($arr2, $data['i01nr01']); // Κωδικός i01 Κίνησης
                array_push($arr1, 'i01p01');          array_push($arr2, $data['p01']); // Κωδικός Είδους
                array_push($arr1, 'p02');             array_push($arr2, $i47['p02']); // Χρώμα
                array_push($arr1, 'p03');             array_push($arr2, $i47['p03']); // Μέγεθος
                array_push($arr1, 'p04');             array_push($arr2, $value['quan']); //Ποσότητα
        
                array_push($arr1, 'peg_mmnr01');      array_push($arr2, 'a55_d-'.$data['a55nr01']);//retail 15/05 na allaxe se a55_d-
                array_push($arr1, 'peg_mnr01');       array_push($arr2, $data['i01nr01']); //! mnr01 το μκ της κίνησης;
                array_push($arr1, 'peg_sess_id');     array_push($arr2, session_id());
                array_push($arr1, 'peg_flag');        array_push($arr2, $peg_flag);
        
                pegasus_mysql_insert('peg_tmp_i48', $arr1, $arr2);
            }
        }
    }

    if($data['v_sn_en'] == 1) {
        $pattern_i32_nr01 = '/^i32_rec_nr01_(\d+)$/';
        $pattern_i32_p01  = '/^i32_rec_p01_(\d+)$/';
        $i32_records = array();
        foreach ($data as $key => $value) {
            if (preg_match($pattern_i32_nr01, $key, $matches)) {
                $index = $matches[1];
                $i32_records[$index]['nr01'] = $value;
            } elseif (preg_match($pattern_i32_p01, $key, $matches)) {
                $index = $matches[1];
                $i32_records[$index]['p01'] = $value;
            }
        }
        // Update peg_tmp_i38 records of this invoice to peg_flag = 9
        pegasus_mysql_update(
            'peg_tmp_i32', 
            array('peg_flag'), 
            array(9), 
            'peg_mnr01 = :mnr01 AND peg_mmnr01 = :mmnr01 and peg_sess_id = :sid',
            0,
            1,
            1,
            array('mnr01' => $data['i01nr01'], 'mmnr01' => 'a55_d-'.$data['a55nr01'], 'sid' => session_id())
        );
        foreach ($i32_records as $value) {
            // echo '<pre>' .print_r($value, 1). '</pre>';
            $peg_flag = 0;
            if(!empty($value['nr01'])) {
                $peg_flag = 2;
                $i32_nr01 = $value['nr01'];
    
                $arr1 = array();					    $arr2 = array();
                
                array_push($arr1, 'p01');	            array_push($arr2, $data['p01']);
                array_push($arr1, 'p02');	            array_push($arr2, $value['p01']);
                array_push($arr1, 'p00');	            array_push($arr2, $data['i01nr01']);
                array_push($arr1, 'p010');	            array_push($arr2, '1');
    
                array_push($arr1, 'peg_flag');          array_push($arr2, $peg_flag); //Flag για update
    
                pegasus_mysql_update(
                    'peg_tmp_i32', 
                    $arr1, 
                    $arr2, 
                    'nr01 = :nr01 AND peg_mnr01 = :mnr01 AND peg_mmnr01 = :mmnr01 and peg_sess_id = :sid', 
                    0,
                    1,
                    1,
                    array('nr01' => $i32_nr01, 'mnr01' => $data['i01nr01'], 'mmnr01' => 'a55_d-'.$data['a55nr01'], 'sid' => session_id())
                );
            }elseif(empty($value['nr01']) && !empty($value['p01'])){
                $peg_flag = 1;
                $i32_nr01 = pegasus_mysql_newrec('i32');
                $arr1 = array();			$arr2 = array();
                array_push($arr1, 'nr01'); 	array_push($arr2, $i32_nr01);
                array_push($arr1, 'p01');	array_push($arr2, $data['p01']);
                array_push($arr1, 'p02');	array_push($arr2, $value['p01']);
                array_push($arr1, 'p00');	array_push($arr2, $data['i01nr01']);
                array_push($arr1, 'p010');	array_push($arr2, '1');
        
                array_push($arr1, 'peg_mmnr01');    array_push($arr2, 'a55_d-'.$data['a55nr01']);//retail 15/05 na allaxe se a55_d-
                array_push($arr1, 'peg_mnr01');     array_push($arr2, $data['i01nr01']); //! mnr01 το μκ της κίνησης;
                array_push($arr1, 'peg_sess_id');   array_push($arr2, session_id());
                array_push($arr1, 'peg_flag');      array_push($arr2, $peg_flag);

                pegasus_mysql_insert('peg_tmp_i32', $arr1, $arr2);
            }
        }
    }

    if($data['v_lot_en'] == 1) {
        $pattern_i38_nr01 = '/^i38_rec_nr01_(\d+)$/';
        $pattern_i38_p01  = '/^i38_rec_p01_(\d+)$/';
        $pattern_i38_quan = '/^i38_rec_quan_(\d+)$/';
        $i38_records = array();
        foreach ($data as $key => $value) {
            if (preg_match($pattern_i38_nr01, $key, $matches)) {
                $index = $matches[1];
                $i38_records[$index]['nr01'] = $value;
            } elseif (preg_match($pattern_i38_p01, $key, $matches)) {
                $index = $matches[1];
                $i38_records[$index]['p01'] = $value;
            } elseif (preg_match($pattern_i38_quan, $key, $matches)) {
                $index = $matches[1];
                $i38_records[$index]['quan'] = $value;
            }
        }
        // Update peg_tmp_i32 records of this invoice to peg_flag = 9
        pegasus_mysql_update(
            'peg_tmp_i38', 
            array('peg_flag'), 
            array(9), 
            'peg_mnr01 = :mnr01 AND peg_mmnr01 = :mmnr01 and peg_sess_id = :sid',
            0,
            1,
            1,
            array('mnr01' => $data['i01nr01'], 'mmnr01' => 'a55_d-'.$data['a55nr01'], 'sid' => session_id())
        );
        foreach ($i38_records as $value) {
            // echo '<pre>' .print_r($value, 1). '</pre>';
            $peg_flag = 0;
            if(!empty($value['nr01'])) {
                $peg_flag = 2;
                $i38_nr01 = $value['nr01'];
    
                $arr1 = array();					    $arr2 = array();
                
                array_push($arr1, 'p02');           array_push($arr2, $value['p01']);   // Παρτίδα
                array_push($arr1, 'p010');          array_push($arr2, 1);       // Είδος κίνησης (na dw parastatiko)
                array_push($arr1, 'p04');           array_push($arr2, $value['quan']);	    // Ποσότητα
                array_push($arr1, 'p05');           array_push($arr2, 1);	    // Τεμάχια (na dw thn kataxwhsh apo to parastatiko)
    
                array_push($arr1, 'peg_flag');      array_push($arr2, $peg_flag); //Flag για update
    
                pegasus_mysql_update(
                    'peg_tmp_i38', 
                    $arr1, 
                    $arr2, 
                    'nr01 = :nr01 AND peg_mnr01 = :mnr01 AND peg_mmnr01 = :mmnr01 and peg_sess_id = :sid', 
                    0,
                    1,
                    1,
                    array('nr01' => $i38_nr01, 'mnr01' => $data['i01nr01'], 'mmnr01' => 'a55_d-'.$data['a55nr01'], 'sid' => session_id())
                );
            }elseif(empty($value['nr01']) && !empty($value['p01'])){
                $peg_flag = 1;
                $i38_nr01 = pegasus_mysql_newrec('i38');
                $arr1 = array();                    $arr2 = array();
                array_push($arr1, 'nr01');          array_push($arr2, $i38_nr01);
        
                array_push($arr1, 'p01');           array_push($arr2, $data['i01nr01']); //MK Κίνησης
                array_push($arr1, 'p02');           array_push($arr2, $value['p01']);   // Παρτίδα
                array_push($arr1, 'p010');          array_push($arr2, 1);       // Είδος κίνησης (na dw parastatiko)
                array_push($arr1, 'p04');           array_push($arr2, $value['quan']);	    // Ποσότητα
                array_push($arr1, 'p05');           array_push($arr2, 1);	    // Τεμάχια (na dw thn kataxwhsh apo to parastatiko)
        
                array_push($arr1, 'peg_mmnr01');    array_push($arr2, 'a55_d-'.$data['a55nr01']);//retail 15/05 na allaxe se a55_d-
                array_push($arr1, 'peg_mnr01');     array_push($arr2, $data['i01nr01']); //! mnr01 το μκ της κίνησης;
                array_push($arr1, 'peg_sess_id');   array_push($arr2, session_id());
                array_push($arr1, 'peg_flag');      array_push($arr2, $peg_flag);

                pegasus_mysql_insert('peg_tmp_i38', $arr1, $arr2);
            }
        }
    }
    $ret_arr = $i48_records;
    return $ret_arr;
}

function retail00_retail00_01_d03_comboboxV2_dynamic_fields_where($field_name, $container_id){ 

    if (substr($field_name, 0, 12) == 'i48_rec_p01_') {
        $ret_arr = array(
            'sql' => 'i47.p01 = :var_p01',
            'sqlParams' => array(
                'var_p01' => pegasusGetGlobalVar($container_id.'_i01_p01')
            )
        );
    }
    if (substr($field_name, 0, 12) == 'i32_rec_p01_') {
        $ret_arr = array(
            'sql' => 'i31.p01 = :var_p01',
            'sqlParams' => array(
                'var_p01' => pegasusGetGlobalVar($container_id.'_i01_p01')
            )
        );
    }
    if (substr($field_name, 0, 12) == 'i38_rec_p01_') {
        $ret_arr = array(
            'sql' => 'i11.p01 = :var_p01',
            'sqlParams' => array(
                'var_p01' => pegasusGetGlobalVar($container_id.'_i01_p01')
            )
        );
    }

    return $ret_arr;
}

function retail00_change_timokatalogos($a01p48, $a01p06) {
    $ret = array();
    //Timokatalogos
    if ($a01p48 > 0) {
        pegasus_mysql_use(' SELECT * FROM i23 WHERE p01=? ', $i23, array($a01p48));
        $preview_wthfpa = $i23['p05'];
    }
    //Eidikos Timokatalogos
    if ($a01p06 > 0 and pegasus_module_exists('invprices')) {
        pegasus_mysql_use(' SELECT * FROM i14 WHERE p01=? ', $i14, array($a01p06));
        $preview_wthfpa = $i14['p05'];
    }
    $ret['p07'] = $preview_wthfpa;

    return $ret;  //times me FPA
}

function retail00_a55_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
    if($data['no_new_nr01'] != 1) {
        $data['a55nr01'] = pegasus_mysql_newrec('a55');
    }
    
	$data['a55p01'] = date('Y-m-d');
    // 27/07/2023 - Δεν κάνουμε πλέον initialize την ώρα, από το πεδίο θα την παίρνει μόνο αν τη δώσει ο χρήστης. (θέμα με transmission_failure στην ηλεκτρονικη)
	// $data['a55p02'] = date('H:i');
	

	//Σειρά παραστατικου
	$data['a55p701'] = $_SESSION['cor003_p101'];
	// Αρ.Κυκλοφορίας
    if(!empty($_SESSION['cor003_p106'])){ 
        $data['a55p702'] = $_SESSION['cor003_p106']; // Από τερματικό
    }else{
        $data['a55p702'] = pegasus_mysql_printfld('a20', 'p01', 'p03=1'); // Από τσεκ "προεπιλεγμένο στα παραστατικά
    }
    // Όχημα Πελάτη
    $data['a55p705'] = 0;
	// Ποσό Ενός Πόντου
	$data['a55p507'] = $_SESSION['f02_pg906'];
	//	Αρχικοποίηση Ισοτιμίας
    $data['a55pn01'] = ''; // Αρχικό και το νόμισμα σε € (κενό = €)
	if (function_exists('peg_account_get_exchange_rate')) {
		$data['a55pn02'] = peg_account_get_exchange_rate(
			$data['a55p01'],
			$data['a55pn01'],
			$data['a55pn02']
		);
	}
    // Το ΦΠΑ Υπολογίζεται ανά Είδος
	$data['a55p420'] = $_SESSION['f02_pg17'];

    //Σε αναμονή
    $data['a55pweb01'] = 0;

    //Αιτιολογία
    $data['a55p010'] = '';

    // Παρατηρήσεις
    $data['a55p011'] = '';

    // ΜΚ Παρ. Μετασχηματισμού
    $data['a55p601'] = 0;
    $data['a55p601_display'] = '';

    //Ισοτιμία
	if ($data['a55pn01'] == '' or $data['a55pn02'] <= 0) {
		$data['a55pn02'] = '1';
	}

    //Δεν περιέχει Δημοτικό Φόρο
    $data['a55p806']  = 0;
    //Αναστολή Καταβολής ΦΠΑ
    $data['a55p807']  = 0;

    // Το θέλω γιατί δεν ενημερώνεται το display του comboboxv2 αν το value είναι ''.
    $data['a55pn01_display'] = pegasus_mysql_printfld('t12', 'p02', 'p01 = ?', array($data['a55pn01']));
    if($_SESSION['lang'] != 'GR') {
        $data['a55pn01_display'] = pegasus_mysql_printfld('t12', 'ep02', 'p01 = ?', array($data['a55pn01']));
    }
    
    if(empty($data['a55pn01'])) {
        $data['retail00_retail00_01_d04_a55pn02_readonly'] = 1;
    }

    $data['a55d_p01'] = '0000-00-00';
    $data['a55d_p02'] = '';

	//Κατάστημα από ΤΕΡΜΑΤΙΚΟ
	$data['a55p0121'] = $_SESSION['cor003_p104'];
	//Αποθηκευτικός Χώρος
	$data['a55p703'] = $_SESSION['cor003_p105'];
	///Από-Εώς κατάστημα
	if (pegasus_module_exists('stores')) {
		$data['a55p415'] = $_SESSION['cor003_p301'];
		$data['a55p416'] = $_SESSION['cor003_p302'];
	} else {
		//Θέλουμε από 0 έως 99999999 γιατί υπήρχαν περιπτώσεις που π.χ. έρχονταν από το τοπικό
		//και είχαν κινήσεις σε άλλα καταστηματα, χωρίς να έχουν το module
		$data['a55p415'] = 0;
		$data['a55p416'] = 9999999999;
	}

	$where = ' peg_tmp_i01.peg_flag   != 9                            and 
               peg_tmp_i01.p06         = "'.$data['a55nr01'].'"       and 
               peg_tmp_i01.p07         = 2                            and 
               peg_tmp_i01.peg_sess_id = "'.session_id().'"           and 
               peg_tmp_i01.peg_mmnr01  = "a55_d-'.$data['a55nr01'].'" and 
               peg_tmp_i01.peg_mnr01   = "'.$data['a55nr01'].'" ';

	pegasusSetGlobalVar($container_id . '_where_eidi',   $where);
	pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_where_eidi', $where);

    $v_a90_p30_where = '    peg_tmp_a90.peg_mmnr01 = "a55_d-'.$data['a55nr01'].'"
                        AND peg_tmp_a90.peg_mnr01 = peg_tmp_i01.nr01
                        AND peg_tmp_a90.peg_sess_id = "'.session_id().'"
                        AND peg_tmp_a90.peg_flag != 9
                        AND peg_tmp_a90.tbl = "i01"
                        AND peg_tmp_a90.tbl_nr01 = peg_tmp_i01.nr01';
    pegasusSetGlobalVar($container_id . '_where_v_a90_p30', $v_a90_p30_where);
    pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_where_v_a90_p30', $v_a90_p30_where);

    //RETAIL: Φτιάχνουμε το array $request_arr και το γεμίζουμε με όλες τις πληροφορίες που χρειάζεται η συνάρτηση 
    $request_arr = array(); 
    $request_arr['p03']  = $data['a01nr01'];  // ΜΚ Πελάτη
	$request_arr['p01']  = $data['a55p01'];   // Ώρα
	$request_arr['p02']  = $data['a55p02'];   // Ημερομηνία
	$request_arr['p04']  = $data['a01a71'];   // Υποκατάστημα
	$request_arr['p415'] = $data['a55p415']; // Κατάστημα (Από)
	$request_arr['p416'] = $data['a55p416']; // Κατάστημα (Έως)
	$request_arr['nr01'] = $data['a55nr01']; // ΜΚ Παραστατικού
	$request_arr['p506'] = $data['a55p506']; // Δωροεπιταγή ---- Κι εδώ λογικά είμαι κενός
	// $request_arr['p05']  = $data['p05']; // Τύπος Παραστατικού ---- Δεν έχω παραστατικό εδώ ακόμα 99% λογικά
	$request_arr['container_id'] = $container_id;

	$response_arr = invoices_find_p03_data($request_arr, 'retail00_01');
	// echo '<pre>qqqq' .print_r($response_arr, 1). '</pre>';
    $ret_data = array();
	foreach ($response_arr as $key => $value) {
        //? Ίσως πρέπει να δούμε αν και πως θέλουμε να σετάρουμε επιλεγμένο υποκατάστημα? Δεν το κάνει μόνο του αυτή τη στιγμή
        //? Είτε εδώ, είτε στην find_p05_data
		//ok Εξαιρούμε με if το καθεστώς  (Το έχουμε αρχικοποιήσει με το query στον a01)
		//ok Εξαιρούμε με if το διάταξη απαλλαγης ΦΠΑ  (Το έχουμε αρχικοποιήσει με το query στον a01)
		//ok Εξαιρούμε με if το πιστωτικό όριο  (Το έχουμε αρχικοποιήσει με το query στον a01) - TODO: SOS να μην ξεχάσουμε το onsave και την αρχιοποίηση
		
		//Θεωρώ στο initialize δεν θα μου φέρει ποτέ υποκατάστημα, στην onchange του πελάτη θα πρέπει α το ξαναδουμε.Αποφασίζουμε ότι το υποκατάστημα θα μπει κάτω από τον πελάτη
		//TODO: Θα πρέπει να δουμε στο onchange του πελάτη και τις αλλαγες από το υποκατάστημα π.χ. καθεστώς και τρόπος μεταφοράς. 
	
		//Το υποκατάστημα θα το κάνουμε a01a71 (αντί για p04). Από την invoices_find_p03_data θα μας γυρνάει το p04_hidden, 
		//θα το μετατρέπουμε σε a01a71_hidden
		//Εξαιρούμε με if τον τρόπο είσπραξης (Το καταργούμε σαν πεδίο)

        if(
               $key != 'p015'   && $key != 'p015_display'   // Τρ. Είσπραξης
            && $key != 'p03'    // Πελάτης (τον έχω ήδη από πάνω)
            && $key != 'p04'    // Υποκατάστημα, το χρησιμοποιεί στα Από - Προς, το βγάζω από το return να μην με μπερδευει
            && $key != 'p707'   // Αρ. Φορολογικής Κάρτας (δεν τον έχουμε στο retail)
            && $key != 'a01p40' // Έχω ενημερωμένα τα p013/p014, δεν το χρειάζομαι.
            && $key != 'container_id' // Επιστρέφει και container_id
        ) {
            // Παίρνω και τα p09 cases γιατί ελέγχω για επιτρεπτά καθεστώτα ΦΠΑ από το Παραστατικό στη find_p03_data
            switch ($key) {
                case "p04_hidden":
                    $data['a01a71_hidden'] = $value;
                    break;
                case "clear_p04":
                    $data[$key] = $value;
                    break;
                case "a01p40":
                    $data['placeholder_a01p40'] = $value;
                    break;
                case "p09":
                    $data['a01p45'] = $value;
                    break;
                case "p09_display":
                    $data['a01p45_display'] = $value;
                    break;
                case "p412":
                    $data['a01p27'] = $value;
                    break;
                case "p706c":
                    $data['a01p803c'] = $value;
                    break;
                case "p706c_display":
                    $data['a01p803c_display'] = $value;
                    break;
                default:
                    $data['a55'.$key] = $value;
            }
        }
	}
    $a10p01 = pegasus_mysql_printfld("retail00_04", "a10p01", "cor003p01 = ?", array($_SESSION['pegasus_client_uid']));
    $a10p01 = !empty($a10p01) ? $a10p01 : $_SESSION['retail00_00_a10p01'];
    //* Αν εχω προεπιλεγμένο παραστατικό, το βάζω στο a55p05, αν όχι κρατάει αυτό που βρήκε από τον πελάτη
    if(!empty($a10p01)) {
        $data['a55p05'] = $a10p01;
    }
    if(empty($data['a55p05'] )){ //Αν δεν είναι κενό, τότε το έχει συμπληρώσει από τον πελάτη ή το προεπιλεγμένο παραστατικό
        $data['a55p05'] = retail00_find_a55p05($data['a55p0121'], $data['a55p703']);
    }

    //RETAIL: Θα πρέπει όταν τα σετάρουμε στο retail να έχουμε φροντίσει να έχουν αρχικοποιηθεί πρώτα. 
	//RETAIL: Έχει νόημα να τα έχουμε στο initialize (να δούμε που γίνονται τώρα στο retail)
    //* RETAIL: 24/10/2023 - Τις μετέφερα πιο πάνω γιατί τις χρησιμοποιεί στην invoices_find_p05_data για τα προεπιλεγμένα είδη, δεν είχε σετάρει ακόμα το p07.
	// Κωδικός Πελάτη (το έχω ως a01nr01 στο retail)
	pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_p03', $data['a01nr01']);
	// Κωδικός Παραστατικού
	pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_p05', $data['a55p05']);
	// Τιμές με ΦΠΑ
	pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_p07', $data['a55p07']);
	// Μικρότερη Βαθμίδα Παραστατικού
	pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_a10_p200', 0);

    $request_arr = array(); 
    $request_arr['p03'] = $data['a01nr01'];
    $request_arr['p04'] = $data['a01a71'];
    $request_arr['p05'] = $data['a55p05'];
    $request_arr['nr01'] = $data['a55nr01'];	
    if (empty($data['a01nr01'])) {
		$response_arr =  invoices_find_p05_data($request_arr, 'a55', true);
	} else {
		$response_arr =  invoices_find_p05_data($request_arr, 'a55', false);
	}
    foreach ($response_arr as $key => $value) {
		//? Ίσως πρέπει να δούμε αν και πως θέλουμε να σετάρουμε επιλεγμένο υποκατάστημα? Δεν το κάνει μόνο του αυτή τη στιγμή
        //? Είτε εδώ, είτε στην find_p03_data
        if(
            $key != 'p015'   && $key != 'p015_display'   // Τρ. Είσπραξης
         && $key != 'p03'    // Πελάτης (τον έχω ήδη από πάνω)
         && $key != 'p04'    // Υποκατάστημα, το χρησιμοποιεί στα Από - Προς, το βγάζω από το return να μην με μπερδευει
         && $key != 'refresh_grid' // Επιστρέφει και container_id
     ) {
        switch ($key) {
            case "p09":
                $data['a01p45'] = $value;
                break;
            case "p09_display":
                $data['a01p45_display'] = $value;
                break;
            default:
                $data['a55'.$key] = $value;
        }
     }
    }
    // echo '<pre>Response Array: ' .print_r($data, 1). '</pre>';
	
    
	if (empty($data['a55p016a'])) {
		$data['a55p016a'] = $_SESSION['username'];
	}

	if ($data['a01nr01'] > 0) {
		/* Aν εχω πελατη βρισκω τους πόντους του*/
		if (pegasus_module_exists('giftcards')) {
			$data['a55vp506_2'] =  giftcards_find_total_points($data['a01nr01']);
		}
	}

	invoices_make_i71_d00_whereVar('a55', $container_id, array('nr01' => $data['a55nr01'])); //Αβραάμ: mode 'a55' και 'nr01', όχι όλο το data.
	
    retail00_set_query_eidi_global_var($container_id, $data['a55nr01'], $where);

	$data = invoices_get_f02_readonly_flds($data, 'retail00_01');

	pegasusSetGlobalVar('peg_a55_d_p05_where', '');

    // echo '<pre>Data after set global vars and readonly fields: ' .print_r($data, 1). '</pre>';

    $product_table = 'peg_tmp_i01';
	$product_where = "
        peg_mnr01='" .  $data['a55nr01'] . "' 
        and peg_mmnr01='a55_d-" . $data['a55nr01'] . "' 
        and peg_sess_id='" . session_id() . "' 
        and peg_flag!=9 and 
        p06='" .  $data['a55nr01'] . "' 
        and p07=2
    ";

	$p0101   = $data['a55p0101'];
	$p0102_1 = $data['a55p0102_1'];
	$p0102_2 = $data['a55p0102_2'];

    if(!isset($data['a55p410'])) {
        //Τα σύνολα δεν υπολογίζονται αυτόματα. Το αρχικοποιώ αν δεν υπάρχει γιατί δεν το επιστρέφει η calc totals
        $data['a55p410'] = 0;
    }

	$p0112   = $data['a55p0112'];
	$p0113   = $data['a55p0113'];
	$p0103   = $data['a55p0103'];
	$p0108   = $data['a55p0108'];
	$p410    = $data['a55p410'];
	$p420    = $data['a55p420'];
	$a01_p09 = $data['a01p45'];
	$preview_with_vat = $data['a55p07'];

	$_totals['p201'] = $data['a55p201'];
	$_totals['p202'] = $data['a55p202'];
	$_totals['p203'] = $data['a55p203'];
	$_totals['p204'] = $data['a55p204'];
	$_totals['p205'] = $data['a55p205'];
	$_totals['p206'] = $data['a55p206'];
	$_totals['p207'] = $data['a55p207'];
	$_totals['p208'] = $data['a55p208'];
	$_totals['p209'] = $data['a55p209'];

	$_totals['p301'] = $data['a55p301'];
	$_totals['p302'] = $data['a55p302'];
	$_totals['p303'] = $data['a55p303'];
	$_totals['p304'] = $data['a55p304'];
	$_totals['p305'] = $data['a55p305'];
	$_totals['p306'] = $data['a55p306'];
	$_totals['p307'] = $data['a55p307'];
	$_totals['p308'] = $data['a55p308'];
	$_totals['p309'] = $data['a55p309'];

	$p506    = $data['a55p506'];

	$return_array = invoices_calculate_total(
		$product_table,
		$product_where,
		$p0101,
		$p0112,
		$p0113,
		$p0103,
		$p0108,
		$a01_p09,
		$preview_with_vat,
		$p410,
		$_totals,
		$p506,
		$p0102_1,
		$p0102_2,
		0,
		"a55",
		"",
		$data['a55nr01'],
		$data['a55pn02'],
        $p420
	);
	// Παραμετροποίηση στα κλειδια για τα σωστα πεδια πχ a55p101
	foreach ($return_array as $key => $value) {
		$data['a55'.$key] = $value;
	}
    // echo '<pre>Data after calculate totals: ' .print_r($data, 1). '</pre>';

    $data['i13_arr'] = array();

	$peg_i13_query = "SELECT * FROM i13;";
	$peg_res = pegasus_query($peg_i13_query);

	while ($peg_i13 = pegasus_fetch($peg_res)) {
		$data['i13_arr'][$peg_i13['p01']] = '(' . $peg_i13['p02'] . ')';
	}
	if ($data['is_invoice_cancel'] == 1) {
		$data['invcust_a55_d6_readonly'] = 1;
	}
	if (($data['a55p410'] != 1)) {
		$data['a55p201_readonly'] = 1;
		$data['a55p202_readonly'] = 1;
		$data['a55p203_readonly'] = 1;
		$data['a55p204_readonly'] = 1;
		$data['a55p205_readonly'] = 1;
		$data['a55p206_readonly'] = 1;
		$data['a55p207_readonly'] = 1;
		$data['a55p208_readonly'] = 1;
		$data['a55p209_readonly'] = 1;

		$data['a55p301_readonly'] = 1;
		$data['a55p302_readonly'] = 1;
		$data['a55p303_readonly'] = 1;
		$data['a55p304_readonly'] = 1;
		$data['a55p305_readonly'] = 1;
		$data['a55p306_readonly'] = 1;
		$data['a55p307_readonly'] = 1;
		$data['a55p308_readonly'] = 1;
		$data['a55p309_readonly'] = 1;
	}

    // RETAIL: Αν τα υπόλοιπα τα έχει φτιάξει από τον πελάτη, ίσως αυτό μπορει α βγει (αν δεν αλλάει κατάστημα, ημερομηνια και ώρα )
	// Λογικά τα εχω ηδη απο την _p03_data, τσεκάρω το flow και αν ειναι σβήνω.
    // Αβραάμ: Ναι τα έχω, σχολιάζω για να θυμάμαι ότι τα υπολόγιζε εδώ αν πάει κάτι στραβά
	// pegasus_mysql_use("select * from a01 where nr01=? ", $tbl_p03, array($data['p03']));
	// $data['p411'] = customers_find_balance($tbl_p03['p21'], 0,  9999999999, $data['p01'], $data['p02']); //Proigoymeno ypoloipo
	// $data['p417'] = customers_find_balance($tbl_p03['p21'], $data['p415'],  $data['p416'], $data['p01'], $data['p02']); //Topiko ypoloipo


	$invoice_num_arr = invoices_refresh_invoice_num(
		'retail00_01',
		$data['a55nr01'],
		$data['a55p05'],
		$data['a55p701'],
		$data['a55p0121'],
		$data['a55p08']
	);

    //Η συνάρτηση κάνει όλους τους ελέγχους αν ειναι χειρόγραφο, νέο παραστατικό κοκ
	//και αν πρέπει να αλλάξει, ενημερώνει το change_value
	//Πρέπει να γίνεται στο τέλος γιατί θέλω να έχει αρχικοποιηθεί σωστά π.χ. το παραστατικό από την τιμολόγηση του Hotel
	if ($invoice_num_arr['change_value'] == 1) {
		$data['a55p06'] = $invoice_num_arr['p06'];
	}

    //ΑΠό τα data, όχι intval!
	// $p0121 = intval($_REQUEST['dias_a55_d3_fld_p0121']);
	// $p703  = intval($_REQUEST['dias_a55_d3_fld_p703']);
    $p0121 = $data['a55p0121'];
	$p703  = $data['a55p703'];
	$nr01  = $data['a55nr01'];
    // Αβραάμ: Επιτρεπτά Καταστήματα και Επιτρεπτοί Αποθηκευτικοί Χώροι
	if (!empty($p0121) or !empty($p703)) {
		$p200  = pegasusGetGlobalVar('peg_a55_d-' . $nr01 . '_a10_p200');
		if (empty($p200)) {
			$p200 = 0;
		}
		$where_p05 = " 
			((a10.p30='' or a10.p30 IS NULL or locate( '#" . $p0121 . "#', a10.p30)<>0 ) and 
			(a10.p31='' or a10.p31 IS NULL or locate( '#" . $p703 . "#',  a10.p31)<>0))
			 and a10.p200>='" . $p200 . "' and a10.ptax>=0 ";

		$peg_a55_d_p05_where = pegasusGetGlobalVar('peg_a55_d_p05_where');
		if ($peg_a55_d_p05_where) {
			$where_p05 .= ' and ' . $peg_a55_d_p05_where;
		}
	} else {
		$where_p05 = " a10.ptax>=0 ";
	}
    pegasusSetGlobalVar($container_id . '_where_p05', $where_p05);
    pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_where_p05', $where_p05);

    // Κωδικός Πελάτη
	pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_p03', $data['a01nr01']);

	// Κωδικός Παραστατικού
	pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_p05', $data['a55p05']);

	// Τιμές με ΦΠΑ
	pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_p07', $data['a55p07']);

	// invoices_make_total_var
	invoices_set_total_var('retail00_01', $data['a55nr01'], $data);

    if ($data['a55p08'] == 0 and !pegasus_check_permission('invcust_master')) {
		$data['a55p01_readonly'] = 1;
		$data['a55p02_readonly'] = 1;
		$data['a55p06_readonly'] = 1;
	}
    if(!pegasus_check_permission('invcust_old_date_invoice')){
        $data['a55p01_readonly'] = 1;
    }

	// $data['invcust_a55_d_p04_hidden'] = true;
	$data['retail00_01_d02_a01a71_hidden'] = true;
	if ($data['a01nr01'] > 0) {
		// Hide υποκαταστημα
		$query = "SELECT count(*) AS cnt FROM a71 JOIN a01 ON a71.p601=a01.nr01 AND a01.nr01=:nr01 ;";
		pegasus_mysql_use($query, $has_store, array('nr01' => $data['a01nr01']));
		if ($has_store['cnt'] > 0) {
			$data['retail00_01_d02_a01a71_hidden'] = false;
		}
	}

	if ($data['a55p705'] > 0) {
        $where_p705 = array(
            'sql'=> '((erpa02.p03 = :var_p03  and erpa02.p010=0) OR erpa02.nr01= :var_p705) ',
            'sqlParams'=> array('var_p03' => $data['a01nr01'], 'var_p705'=>$data['a55p705'])
        );
    }else{
        $where_p705 = array(
            'sql'=> ' erpa02.p03 = :var_p03 and  erpa02.p010=0',
            'sqlParams'=> array('var_p03' => $data['a01nr01'])
        );
    }
    pegasusSetGlobalVar($container_id . '_where_p705', $where_p705);

    $data['a55p415_display'] = '';
    $data['a55p416_display'] = '';
    $data['a55p0121_display'] = '';
    if(pegasus_module_exists('stores')) {
        $data['a55p415_display']  = pegasus_mysql_printfld('t07', 'p02', 'p01 = :a55p415', array('a55p415' => $data['a55p415']));
        $data['a55p416_display']  = pegasus_mysql_printfld('t07', 'p02', 'p01 = :a55p416', array('a55p416' => $data['a55p416']));
        $data['a55p0121_display'] = pegasus_mysql_printfld('t07', 'p02', 'p01 = :a55p0121', array('a55p0121' => $data['a55p0121']));
    }


    // Αβραάμ: Προσθέτω και εδώ το where που σετάρω για τους Τρόπους Είσπραξης στην οθόνη Είσπραξης στο onchange a55p05.
    // Ανάλογα αν το παραστατικό που έχω επιλέξει έχει θετική ή αρνητική χρέωση, θέλω να φέρω ως τρόπους είσπραξης επιλογές
    // που έχουν μόνο θετική ή αρνητική πίστωση. Στην περίπτωση της θετικής χρέωσης, φέρνω και αυτούς με κενό ΚΚ Λογιστηρίου.
    $data['a55p05_display'] = '';
    if (!empty($data['a55p05'])) {
        $kklo_p05 = pegasus_mysql_printfld('a10', 'p04', 'p01 = :a55p05', array('a55p05' => $data['a55p05']));
        $kkxr_p05 = pegasus_mysql_printfld('t02', 'p03', 'p01 = :kklo_p05', array('kklo_p05' => $kklo_p05));
        $data['a55p05_display'] = pegasus_mysql_printfld('a10', 'p02', 'p01 = :a55p05', array('a55p05' => $data['a55p05']));
        if($kkxr_p05 > 0) {
            $query = "SELECT GROUP_CONCAT(p01 SEPARATOR ',') AS p02_in FROM t02 WHERE p04 > 0";
            pegasus_mysql_use($query, $val);
            $p02_in_arr = explode(',' , $val['p02_in']);
            

            $p02_in      = pegasus_mysql_create_in($p02_in_arr, 'p02');
            $all_params  = $p02_in['sqlParams'];
            $a14_where_sql = "a14.p02 IN (" . $p02_in['sql'] . ")";
            if(pegasus_module_exists('pos00')) {
                // Και τα pos00_02 με τρόπο είσπραξης και ΚΚ.Λογ όπου το t02.p04 > 0
                $query_2 = "SELECT 
                                GROUP_CONCAT(a14 SEPARATOR ',') AS pos00_02_in 
                            FROM pos00_02 
                            JOIN t02 ON pos00_02.t02p01 = t02.p01
                            WHERE 
                                pos00_02.a14 > 0 
                                AND pos00_02.t02p01 > 0
                                AND t02.p04 > 0 ";
                pegasus_mysql_use($query_2, $val_2);
                $pos00_02_in_arr = explode(',', $val_2['pos00_02_in']);
                
                $pos00_02_in = pegasus_mysql_create_in($pos00_02_in_arr, 'pos00_02');
                $all_params = array_merge($p02_in['sqlParams'], $pos00_02_in['sqlParams']);
                $a14_where_sql = "a14.p02 IN (" . $p02_in['sql'] . ") OR a14.nr01 IN (" . $pos00_02_in['sql'] . ")";
            }
        }elseif($kkxr_p05 < 0) {
            $query = "SELECT GROUP_CONCAT(p01 SEPARATOR ',') AS p02_in FROM t02 WHERE p04 < 0";
            pegasus_mysql_use($query, $val);
            $p02_in_arr = explode(',' , $val['p02_in']);

            $p02_in      = pegasus_mysql_create_in($p02_in_arr, 'p02');
            $all_params = $p02_in['sqlParams'];
            $a14_where_sql = "a14.p02 IN (" . $p02_in['sql'] . ")";
            if(pegasus_module_exists('pos00')) {
                // Και τα pos00_02 με τρόπο είσπραξης και ΚΚ.Λογ όπου το t02.p04 < 0
                $query_2 = "SELECT 
                                GROUP_CONCAT(a14 SEPARATOR ',') AS pos00_02_in 
                            FROM pos00_02 
                            JOIN t02 ON pos00_02.t02p01 = t02.p01
                            WHERE 
                                pos00_02.a14 > 0 
                                AND pos00_02.t02p01 > 0
                                AND t02.p04 < 0 ";
                pegasus_mysql_use($query_2, $val_2);
                $pos00_02_in_arr = explode(',', $val_2['pos00_02_in']);

                $pos00_02_in = pegasus_mysql_create_in($pos00_02_in_arr, 'pos00_02');
                $all_params = array_merge($p02_in['sqlParams'], $pos00_02_in['sqlParams']);
                $a14_where_sql = "a14.p02 IN (" . $p02_in['sql'] . ") OR a14.nr01 IN (" . $pos00_02_in['sql'] . ")";
            }
        }
        //* Αν έχει το δικαίωμα retail00_001 - Τότε εμφανίζω και τους Τρ. Είσπραξης χωρίς ΚΚ. Λογιστηρίου.
        //* Αν έχει και module POS, εξαιρώ από αυτό το IN τους Τρ. Είσπραξης χωρίς ΚΚ. Λογιστηρίου με σύνδεση σε Ρυθμίσεις POS.
        if(pegasus_check_permission('retail00_001') == 1) {
            if(pegasus_module_exists('pos00')) {
                $query_3 = "SELECT 
                                GROUP_CONCAT(a14.nr01 SEPARATOR ',') AS a14_nr01_in
                            FROM a14
                            LEFT JOIN pos00_02 ON pos00_02.a14 = a14.nr01
                            WHERE 
                                pos00_02.a14 IS NULL
                                AND a14.p02 = 0";
                pegasus_mysql_use($query_3, $val_3);
                $a14_nr01_in_arr = explode(',', $val_3['a14_nr01_in']);

                $a14_nr01_in = pegasus_mysql_create_in($a14_nr01_in_arr, 'a14_nr01');
                $all_params = array_merge($p02_in['sqlParams'], $pos00_02_in['sqlParams'], $a14_nr01_in['sqlParams']);
                $a14_where_sql .= " OR a14.nr01 IN (" . $a14_nr01_in['sql'] . ")";
            }else{
                $a14_where_sql .= " OR a14.p02 = 0";
            }
        }
        pegasusSetGlobalVar(
            $container_id . '_a14_where',
            array(	'sql'		=> $a14_where_sql,
                    'sqlParams'	=> $all_params
            )
        );
        pegasusSetGlobalVar(
            'peg_'. $data['a55nr01'] . '_a14_where',
            array(	'sql'		=> $a14_where_sql,
                    'sqlParams'	=> $all_params
            )
        );
    }
	return $data;
}

function retail00_a55_d_restore_values($data, $container_id = '', $copy = 0)
{
    //* Αν συμπληρωθεί $copy 
    //* = 1, τότε λειτουργεί ως αντιγραφή του $data['a55nr01'] (06/2025)
    //* = 2, τότε λειτουργεί ως μετασχηματισμός του $data['a55nr01'] (06/2025)

    //ΑΡΧΙΚΟΠΟΙΗΣΗ ΤΩΝ ΤΙΜΏΝ ΤΟΥ ΠΑΡΑΣΤΑΤΙΚΟΥ
    pegasus_mysql_use('SELECT * FROM a55 where a55.nr01 = :var_a55p01',$a55 ,array('var_a55p01'=>$data['a55nr01']));
    if($copy > 0) {
        $new_a55nr01 = pegasus_mysql_newrec('a55');
    }
    if(!empty($new_a55nr01)) {
        pegasus_make_all_tmp_recs('a55', array('nr01'=>$new_a55nr01), $new_a55nr01, $data['a55nr01'], 'a55_d-' . $new_a55nr01);
        $copied_nr01 = $data['a55nr01'];
        $data['a55nr01'] = $new_a55nr01;
    }else{
        pegasus_make_all_tmp_recs('a55', array('nr01'=>$data['a55nr01']), $data['a55nr01'], 0, 'a55_d-' . $data['a55nr01']);
    }
    
    //Ημερομηνία 
	$data['a55p01'] = $a55['p01'];
    //Πελάτης
    $data['a55p03'] = $a55['p03'];
    // Παραστατικό
    $data['a55p05'] = $a55['p05'];
    //Υποκατάστημα
    $data['a55p04'] = $a55['p04'];
	//Σειρά παραστατικου
	$data['a55p701'] = $a55['p701'];
	// Αρ.Κυκλοφορίας
	$data['a55p702'] = $a55['p702'];
	// Ποσό Ενός Πόντου
	$data['a55p507'] = $_SESSION['f02_pg906'];
	//	Αρχικοποίηση Ισοτιμίας
    $data['a55pn01'] = $a55['pn01']; // Αρχικό και το νόμισμα σε € (κενό = €)
	$data['a55pn02'] = $a55['pn02'];
    //Σε αναμονή
    $data['a55pweb01'] = $a55['pweb01'];
    //Χειρόγραφο 
    $data['a55p08'] = $a55['p08'];
    //Είσπραξη
    $data['a55p015'] = $a55['p015'];
    //Κωδικος καθ. ΦΠΑ
    $data['a55p09'] = $a55['p09'];
    //Αιτιολογία
    $data['a55p010'] = $a55['p010'];
    //Παρατηρήσεις
    $data['a55p011'] = $a55['p011'];
    //Σκοπός διακίνησης
    $data['a55p012'] = $a55['p012'];
    //Απο
    $data['a55p013'] = $a55['p013'];
    //Προς
    $data['a55p014'] = $a55['p014'];
    //Καθαρά
    $data['a55p201'] = $a55['p201'];
    $data['a55p202'] = $a55['p202'];
    $data['a55p203'] = $a55['p203'];
    $data['a55p204'] = $a55['p204'];
    $data['a55p205'] = $a55['p205'];
    $data['a55p206'] = $a55['p206'];
    $data['a55p207'] = $a55['p207'];
    $data['a55p208'] = $a55['p208'];
    $data['a55p209'] = $a55['p209'];

    //ΦΠΑ
    $data['a55p301'] = $a55['p301'];
    $data['a55p302'] = $a55['p302'];
    $data['a55p303'] = $a55['p303'];
    $data['a55p304'] = $a55['p304'];
    $data['a55p305'] = $a55['p305'];
    $data['a55p306'] = $a55['p306'];
    $data['a55p307'] = $a55['p307'];
    $data['a55p308'] = $a55['p308'];
    $data['a55p309'] = $a55['p309'];

    //Τα σύνολα δεν υπολογίζονται αυτόματα
    $data['a55p410'] = $a55['p410'];
    //Το ΦΠΑ Υπολογίζεται ανά Είδος
    $data['a55p420'] = $a55['p420'];
    //Πιστοτικό όριο πελάτη
    $data['a55p412'] = $a55['p412'];
    //Νέο υπόλοιπο πελάτη
     $data['a55p413']= $a55['p413'];
    //Αποστολέας
    $data['a55p501'] = $a55['p501'];
     //Παραλήπτης
     $data['a55p502']= $a55['p502'];
    // Κωδικός έργου
    $data['a55p503'] = $a55['p503'];
    // Κωδικός έργασιας
    $data['a55p504'] = $a55['p504'];
    //Κωδικός οχήματος
    $data['a55p705'] = $a55['p705'];
    //ΜΚ Δωροεπιταγής
    $data['a55p506'] = $a55['p506'];
    //Διαταξη απαλαγης ΦΠΑ
    $data['a55p706'] = $a55['p706'];
    $data['a55p706c']= $a55['p706c'];
    //Τιμές με ΦΠΑ
    $data['a55p07']  =$a55['p07'];
    //Δεν περιέχει Δημοτικό Φόρο
    $data['a55p806']  =$a55['p806'];
    //Αναστολή Καταβολής ΦΠΑ
    $data['a55p807']  =$a55['p807'];
    //Δεν ενημερωνει ποντους
    $data['a55p704']  =$a55['p704'];
    // Το θέλω γιατί δεν ενημερώνεται το display του comboboxv2 αν το value είναι ''.
    $data['a55pn01_display'] = pegasus_mysql_printfld('t12', 'p02', 'p01 = ?', array($data['a55pn01']));
    if($_SESSION['lang'] != 'GR') {
        $data['a55pn01_display'] = pegasus_mysql_printfld('t12', 'ep02', 'p01 = ?', array($data['a55pn01']));
    }
    
    if(empty($data['a55pn01'])) {
        $data['retail00_retail00_01_d04_a55pn02_readonly'] = 1;
    }
	//Κατάστημα από ΤΕΡΜΑΤΙΚΟ
	$data['a55p0121'] = $a55['p0121'];
	//Αποθηκευτικός Χώρος
	$data['a55p703'] = $a55['p703'];
	///Από-Εώς κατάστημα
    $data['a55p415'] =  $a55['p415'];
    $data['a55p416'] =  $a55['p416'];

    // Στοιχεία Διακίνησης
    $data['a55d_p01']  = $a55['d_p01'];
    $data['a55d_p02']  = $a55['d_p02'];

    $data['a55ldstreet']   = $a55['ldstreet'];
    $data['a55ldnumber']   = $a55['ldnumber'];
    $data['a55ldzip']      = $a55['ldzip'];
    $data['a55ldcity']     = $a55['ldcity'];
    $data['a55ss_branch']  = $a55['ss_branch'];

    $data['a55dlvstreet']  = $a55['dlvstreet'];
    $data['a55dlvnumber']  = $a55['dlvnumber'];
    $data['a55dlvzip']     = $a55['dlvzip'];
    $data['a55dlvcity']    = $a55['dlvcity'];
    $data['a55cs_branch']  = $a55['cs_branch'];

    //Σημειώσεις Παραστατικού
    $data['a55p30'] = $a55['p30'];

    //ΑΡΧΙΚΟΠΟΙΗΣΗ ΤΩΝ ΤΙΜΩΝ ΤΟΥ ΠΕΛΑΤΗ
    pegasus_mysql_use("SELECT * FROM a01 WHERE nr01 = ?", $a01, array($data['a55p03']));
    $data['a01nr01']  = $a01['nr01'];
    // $data['a01p45']   = $a01['p45'] ;
    $data['a01p48']   = $a01['p48'] ;
    $data['a01p06']   = $a01['p06'] ;
    $data['a01p52']   = $a01['p52'] ;
    $data['a01p52a']  = $a01['p52a'];
    $data['a01p523']  = $a01['p523'];
    $data['a01p19']   = $a01['p19'];
    $data['a01p2']    = $a01['p2'];
    $data['a01p3']    = $a01['p3'];
    $data['a01p9']    = $a01['p9'];
    $data['a01p8']    = $a01['p8'];
    $data['a01p01']   = $a01['p01'];
    $data['a01p20']   = $a01['p20'];
    $data['a01pc22']  = $a01['pc22'];
    $data['a01p4']    = $a01['p4'];
    $data['a01p5']    = $a01['p5'];
    $data['a01p7']    = $a01['p7'];
    // $data['a01p803c'] = $a01['p803c'];
    // $data['a01p27']   = $a01['p27'];
    // Παραμετρικά
    $data['a01pd10']  = $a01['pd10'];
    $data['a01pd11']  = $a01['pd11'];
    $data['a01pd12']  = $a01['pd12'];
    $data['a01pd13']  = $a01['pd13'];
    $data['a01p23']   = $a01['p23'];

   // $num = invoices_refresh_invoice_num('retail00_01', $data['a55nr01'], $data['a55p05'], $data['a55p701'], $data['a55p0121'],$data['a55p08']); 
   // $data['a55p06'] = $num['p06'];
    //RETAIL: Φτιάχνουμε το array $request_arr και το γεμίζουμε με όλες τις πληροφορίες που χρειάζεται η συνάρτηση 
    //* Αν αφορά αντιγραφή/μετασχηματισμό, δεν μπαίνουμε εδώ. Συμπληρώνονται τα σχετικά πεδία του πελάτη από το a55.
    if($copy == 0) {
        $request_arr = array(); 
        $request_arr['p03']  = $a55['p03'];  // ΜΚ Πελάτη
        $request_arr['p01']  = $a55['p01'];   // Ημερομηνία
        $request_arr['p02']  = $a55['p02'];    // Ώρα
        $request_arr['p04']  = $a55['p04'];   // Υποκατάστημα
        $request_arr['p415'] = $a55['p415']; // Κατάστημα (Από)
        $request_arr['p416'] = $a55['p416']; // Κατάστημα (Έως)
        $request_arr['nr01'] = $data['a55nr01']; // ΜΚ Παραστατικού
        $request_arr['p506'] = $a55['p506']; // Δωροεπιταγή ---- Κι εδώ λογικά είμαι κενός
        // $request_arr['p05']  = $data['p05']; // Τύπος Παραστατικού ---- Δεν έχω παραστατικό εδώ ακόμα 99% λογικά
        $request_arr['container_id'] = $container_id;

        
        $response_arr = invoices_find_p03_data($request_arr, 'retail00_01');
        
        
        // echo '<pre>qqqq' .print_r($response_arr, 1). '</pre>';
        $ret_data = array();
        foreach ($response_arr as $key => $value) {
            //? Ίσως πρέπει να δούμε αν και πως θέλουμε να σετάρουμε επιλεγμένο υποκατάστημα? Δεν το κάνει μόνο του αυτή τη στιγμή
            //? Είτε εδώ, είτε στην find_p05_data
            //ok Εξαιρούμε με if το καθεστώς  (Το έχουμε αρχικοποιήσει με το query στον a01)
            //ok Εξαιρούμε με if το διάταξη απαλλαγης ΦΠΑ  (Το έχουμε αρχικοποιήσει με το query στον a01)
            //ok Εξαιρούμε με if το πιστωτικό όριο  (Το έχουμε αρχικοποιήσει με το query στον a01) - TODO: SOS να μην ξεχάσουμε το onsave και την αρχιοποίηση
            
            //Θεωρώ στο initialize δεν θα μου φέρει ποτέ υποκατάστημα, στην onchange του πελάτη θα πρέπει α το ξαναδουμε.Αποφασίζουμε ότι το υποκατάστημα θα μπει κάτω από τον πελάτη
            //TODO: Θα πρέπει να δουμε στο onchange του πελάτη και τις αλλαγες από το υποκατάστημα π.χ. καθεστώς και τρόπος μεταφοράς. 
        
            //Το υποκατάστημα θα το κάνουμε a01a71 (αντί για p04). Από την invoices_find_p03_data θα μας γυρνάει το p04_hidden, 
            //θα το μετατρέπουμε σε a01a71_hidden
            //Εξαιρούμε με if τον τρόπο είσπραξης (Το καταργούμε σαν πεδίο)

            if(
                $key != 'p015'   && $key != 'p015_display'   // Τρ. Είσπραξης
                && $key != 'p03'    // Πελάτης (τον έχω ήδη από πάνω)
                && $key != 'p04'    // Υποκατάστημα, το χρησιμοποιεί στα Από - Προς, το βγάζω από το return να μην με μπερδευει
                && $key != 'p707'   // Αρ. Φορολογικής Κάρτας (δεν τον έχουμε στο retail)
                && $key != 'a01p40' // Έχω ενημερωμένα τα p013/p014, δεν το χρειάζομαι.
                && $key != 'container_id' // Επιστρέφει και container_id
                && $key != 'p0121' // Δεν θέλω να μου φέρει αρχικό κατάστημα. | hotfix invoices r752-755
                && $key != 'p703' // Δεν θέλω να μου φέρει αρχική αποθήκη. | hotfix invoices r752-755
                && $key != 'p30' // Δεν θέλω να μου φέρει τις σημειώσεις τιμολογικής όταν είναι από restore // Και δεν είναι αντιγραφή.
                //TODO ΣΤΗΝ ΑΝΤΙΓΡΑΦΗ/ΜΕΤΑΣΧΗΜΑΤΙΣΜΟ -- ΠΡΕΠΕΙ ΝΑ ΕΞΑΙΡΕΣΩ ΟΛΑ ΤΑ ΠΕΔΙΑ ΤΟΥ ΠΑΡΑΣΤΑΤΙΚΟΥ ΠΟΥ ΕΡΧΟΝΤΑΙ ΑΠΟ ΤΟΝ ΠΕΛΑΤΗ -- ΠΡΩΤΟ ΚΑΙ ΚΑΛΥΤΕΡΟ ΤΟ p05....
            ) {
                // Παίρνω και τα p09 cases γιατί ελέγχω για επιτρεπτά καθεστώτα ΦΠΑ από το Παραστατικό στη find_p03_data
                switch ($key) {
                    case "p04_hidden":
                        $data['a01a71_hidden'] = $value;
                        break;
                    case "clear_p04":
                        $data[$key] = $value;
                        break;
                    case "a01p40":
                        $data['placeholder_a01p40'] = $value;
                        break;
                    case "p09":
                        $data['a01p45'] = $value;
                        break;
                    case "p09_display":
                        $data['a01p45_display'] = $value;
                        break;
                    case "p412":
                        $data['a01p27'] = $value;
                        break;
                    case "p706c":
                        $data['a01p803c'] = $value;
                        break;
                    case "p706c_display":
                        $data['a01p803c_display'] = $value;
                        break;
                    default:
                        $data['a55'.$key] = $value;
                        // echo 'retail00_a55_d_restore_values: a55' . $key . ' = ' . $value . '<br>';
                }
            }
            
        }
    }else{
        $data['a01p45'] = $a55['p09']; // Κωδικός Καθεστώτος ΦΠΑ
        $data['a01p45_display'] = pegasus_mysql_printfld('a26', 'p02', 'p01 = ?', array($a55['p09']));
        $data['a01p803c'] = $a55['p706c']; // Διάταξη απαλλαγής ΦΠΑ
        $data['a01p803c_display'] = pegasus_mysql_printfld('a77', 'p01', 'nr01 = ?', array($a55['p706c']));
        $data['a01a71'] = $a55['p04']; // Υποκατάστημα
        if(!empty($a55['p04'])) {
            $data['a01a71_hidden'] = false;
        }
        $data['a01p27'] = $a55['p412']; // Πιστωτικό όριο πελάτη
    }

    $p200  = 0;

    //RETAIL: Θα πρέπει όταν τα σετάρουμε στο retail να έχουμε φροντίσει να έχουν αρχικοποιηθεί πρώτα. 
	//RETAIL: Έχει νόημα να τα έχουμε στο initialize (να δούμε που γίνονται τώρα στο retail)
    //* RETAIL: 24/10/2023 - Τις μετέφερα πιο πάνω γιατί τις χρησιμοποιεί στην invoices_find_p05_data για τα προεπιλεγμένα είδη, δεν είχε σετάρει ακόμα το p07.
	// Κωδικός Πελάτη (το έχω ως a01nr01 στο retail)
	pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_p03', $data['a01nr01']);
	// Κωδικός Παραστατικού
	pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_p05', $data['a55p05']);
	// Τιμές με ΦΠΑ
	pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_p07', $data['a55p07']);
	// Μικρότερη Βαθμίδα Παραστατικού
	pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_a10_p200', 0);
    //Πωλητης
    $data['a55p016'] = $a55['p016'];
    $data['a55p016_display'] = pegasus_mysql_printfld('us0','p100','p01 = :p01',array('p01' => $a55['p016']));
    //κωδ.χρηστη καταχ
	$data['a55p016a'] = $a55['p016a'];
    //Τροπος μεταφορας
    $data['a55p017'] = $a55['p017'];
    //Τιμές με ΦΠΑ
    $data['a55p07']  =$a55['p07'];
    //Δεν ενημερωνει ποντους
    $data['a55p704']  =$a55['p704'];
    
	if ($data['a01nr01'] > 0) {
		/* Aν εχω πελατη βρισκω τους πόντους του*/
		if (pegasus_module_exists('giftcards')) {
			$data['a55vp506_2'] =  giftcards_find_total_points($data['a01nr01']);
		}
	}

	$where = ' 
        peg_flag!=9 
        and peg_tmp_i01.p06="' . $data['a55nr01'] . '" 
        and peg_tmp_i01.p07=2 
        and peg_tmp_i01.peg_sess_id="' . session_id() . '" 
        and peg_tmp_i01.peg_mmnr01="a55_d-'  . $data['a55nr01'] . '" 
        and peg_tmp_i01.peg_mnr01="'   . $data['a55nr01'] . '" ';
	pegasusSetGlobalVar($container_id . '_where_eidi',   $where);
	pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_where_eidi', $where); //CHECK
	invoices_make_i71_d00_whereVar('a55', $container_id, array('nr01' => $data['a55nr01']));; //Αβραάμ: mode 'a55' και 'nr01', όχι όλο το data.

    $v_a90_p30_where = '    peg_tmp_a90.peg_mmnr01 = "a55_d-'.$data['a55nr01'].'"
                        AND peg_tmp_a90.peg_mnr01 = peg_tmp_i01.nr01
                        AND peg_tmp_a90.peg_sess_id = "'.session_id().'"
                        AND peg_tmp_a90.peg_flag != 9
                        AND peg_tmp_a90.tbl = "i01"
                        AND peg_tmp_a90.tbl_nr01 = peg_tmp_i01.nr01';
    pegasusSetGlobalVar($container_id . '_where_v_a90_p30', $v_a90_p30_where);
    pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_where_v_a90_p30', $v_a90_p30_where);

    pegasusSetGlobalVar($data['ecr_sim_container_id'] . '_ecr_sim_a55nr01', $data['a55nr01']); 

    retail00_set_query_eidi_global_var($container_id, $data['a55nr01'], $where);
	
	$data = invoices_get_f02_readonly_flds($data, 'retail00_01');

	pegasusSetGlobalVar('peg_a55_d_p05_where', '');

    // Aν Προκειται για μετασχηματισμό παρασταικού
	if ($copy == 2) {
		$data = invcust_transform_invoice($copied_nr01, $data, 'retail00_01');

        if ($data['a55p601'] > 0) {
            $p601_a55_p05 = pegasus_mysql_printfld('a55', 'p05', 'nr01=? ', array($data['a55p601']));
            $p200 = pegasus_mysql_printfld('a10', 'p200', 'p01=?', array($p601_a55_p05));
            pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_a10_p200', $p200);
        }
	}

    // echo '<pre>Data after set global vars and readonly fields: ' .print_r($data, 1). '</pre>';

    $product_table = 'peg_tmp_i01';
	$product_where = "
        peg_mnr01='" .  $data['a55nr01'] . "' 
        and peg_mmnr01='a55_d-" . $data['a55nr01'] . "' 
        and peg_sess_id='" . session_id() . "' 
        and peg_flag!=9 and 
        p06='" .  $data['a55nr01'] . "' 
        and p07=2
    ";

	//ΕΔΩ ΕΧΩ ΑΦΑΙΡΕΣΕΙ ΤΗΝ invoices_calculate_total και περναω τα συνολα απο την βάση
    $data['a55p0100']   = $a55['p0100'];
    $data['a55p0102']   = $a55['p0102'];
    $data['a55p0105']   = $a55['p0105'];
    $data['a55p0109']   = $a55['p0109'];
    $data['a55p0101']   = $a55['p0101'];
    $data['a55p0112']   = $a55['p0112'];
    $data['a55vp0112']  = $a55['vp0112'];
    $data['a55p0113']   = $a55['p0113'];
    $data['a55vp0113']  = $a55['vp0113'];
    $data['a55p0600']   = $a55['p0600'];
    $data['a55p0601']   = $a55['p0601'];
    $data['a55p0108']   = $a55['p0108'];
    $data['a55p0102_1'] = $a55['p0102_1'];
    $data['a55p0102_2'] = $a55['p0102_2'];


    $data['i13_arr'] = array();

	$peg_i13_query = "SELECT * FROM i13;";
	$peg_res = pegasus_query($peg_i13_query);

	while ($peg_i13 = pegasus_fetch($peg_res)) {
		$data['i13_arr'][$peg_i13['p01']] = '(' . $peg_i13['p02'] . ')';
	}
	if ($data['is_invoice_cancel'] == 1) {
		$data['invcust_a55_d6_readonly'] = 1;
	}
	if (($data['a55p410'] != 1)) {
		$data['a55p201_readonly'] = 1;
		$data['a55p202_readonly'] = 1;
		$data['a55p203_readonly'] = 1;
		$data['a55p204_readonly'] = 1;
		$data['a55p205_readonly'] = 1;
		$data['a55p206_readonly'] = 1;
		$data['a55p207_readonly'] = 1;
		$data['a55p208_readonly'] = 1;
		$data['a55p209_readonly'] = 1;

		$data['a55p301_readonly'] = 1;
		$data['a55p302_readonly'] = 1;
		$data['a55p303_readonly'] = 1;
		$data['a55p304_readonly'] = 1;
		$data['a55p305_readonly'] = 1;
		$data['a55p306_readonly'] = 1;
		$data['a55p307_readonly'] = 1;
		$data['a55p308_readonly'] = 1;
		$data['a55p309_readonly'] = 1;
	}

    // Εδω φτιάχνουμε τον νεο αριθμο 
	$invoice_num_arr = invoices_refresh_invoice_num(
		'retail00_01',
		$data['a55nr01'],
		$data['a55p05'],
		$data['a55p701'],
		$data['a55p0121'],
		$data['a55p08']
	);

	if ($invoice_num_arr['change_value'] == 1) {
		$data['a55p06'] = $invoice_num_arr['p06'];
    }

    //ΑΠό τα data, όχι intval!
	// $p0121 = intval($_REQUEST['dias_a55_d3_fld_p0121']);
	// $p703  = intval($_REQUEST['dias_a55_d3_fld_p703']);
    $p0121 = $data['a55p0121'];
	$p703  = $data['a55p703'];
	$nr01  = $data['a55nr01'];

    // echo '<pre>' .$p0121. '</pre>';
    // echo '<pre>' .$p703. '</pre>';
    // echo '<pre>' .$nr01. '</pre>';
    // echo '<pre>' .$p200. '</pre>';
    // ΔΕΝ ΞΕΡΩ ΑΝ ΠΡΕΠΕΙ ΝΑ ΤΟ ΚΡΑΤΗΣΟΥΜΕ
	if (!empty($p0121) or !empty($p703)) {
		$p200  = pegasusGetGlobalVar('peg_a55_d-' . $nr01 . '_a10_p200');
		if (empty($p200)) {
			$p200 = 0;
		}
		$where_p05 = " 
			((a10.p30='' or a10.p30 IS NULL or locate( '#" . $p0121 . "#', a10.p30)<>0 ) and 
			(a10.p31='' or a10.p31 IS NULL or locate( '#" . $p703 . "#',  a10.p31)<>0))
			 and a10.p200>='" . $p200 . "' and a10.ptax>=0 ";

		$peg_a55_d_p05_where = pegasusGetGlobalVar('peg_a55_d_p05_where');
		if ($peg_a55_d_p05_where) {
			$where_p05 .= ' and ' . $peg_a55_d_p05_where;
		}
        // echo $where_p05;
	} else {
		$where_p05 = " a10.ptax>=0 and a10.p200>=". $p200. " ";
	}
    pegasusSetGlobalVar($container_id . '_where_p05', $where_p05);
    pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_where_p05', $where_p05);

    // echo '<pre>Where P05: ' .$where_p05. '</pre>';

    // Κωδικός Πελάτη
	pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_p03', $data['a01nr01']);

	// Κωδικός Παραστατικού
	pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_p05', $data['a55p05']);

	// Τιμές με ΦΠΑ
	pegasusSetGlobalVar('peg_a55_d-' . $data['a55nr01'] . '_p07', $data['a55p07']);

	// invoices_make_total_var
	invoices_set_total_var('retail00_01', $data['a55nr01'], $data);

    if ($data['a55p08'] == 0 and !pegasus_check_permission('invcust_master')) {
		$data['a55p01_readonly'] = 1;
		$data['a55p02_readonly'] = 1;
		$data['a55p06_readonly'] = 1;
	}
    if(!pegasus_check_permission('invcust_old_date_invoice')){
        $data['a55p01_readonly'] = 1;
    }

	// $data['invcust_a55_d_p04_hidden'] = true;
	$data['retail00_01_d02_a01a71_hidden'] = true;
	if ($data['a01nr01'] > 0) {
		// Hide υποκαταστημα
		$query = "SELECT count(*) AS cnt FROM a71 JOIN a01 ON a71.p601=a01.nr01 AND a01.nr01=:nr01 ;";
		pegasus_mysql_use($query, $has_store, array('nr01' => $data['a01nr01']));
		if ($has_store['cnt'] > 0) {
			$data['retail00_01_d02_a01a71_hidden'] = false;
		}
	}

	$where_p705 = "erpa02.p03 = :var_p03" ;
	pegasusSetGlobalVar($container_id . '_where_p705', array(
	   'sql' => $where_p705,
	   'sqlParams' => array('var_p03' => $data['a01nr01'])
    ));

    $data['a55p415_display'] = '';
    $data['a55p416_display'] = '';
    $data['a55p0121_display'] = '';
    if(pegasus_module_exists('stores')) {
        $data['a55p415_display']  = pegasus_mysql_printfld('t07', 'p02', 'p01 = :a55p415', array('a55p415' => $data['a55p415']));
        $data['a55p416_display']  = pegasus_mysql_printfld('t07', 'p02', 'p01 = :a55p416', array('a55p416' => $data['a55p416']));
        $data['a55p0121_display'] = pegasus_mysql_printfld('t07', 'p02', 'p01 = :a55p0121', array('a55p0121' => $data['a55p0121']));
    }


    // Αβραάμ: Προσθέτω και εδώ το where που σετάρω για τους Τρόπους Είσπραξης στην οθόνη Είσπραξης στο onchange a55p05.
    // Ανάλογα αν το παραστατικό που έχω επιλέξει έχει θετική ή αρνητική χρέωση, θέλω να φέρω ως τρόπους είσπραξης επιλογές
    // που έχουν μόνο θετική ή αρνητική πίστωση. Στην περίπτωση της θετικής χρέωσης, φέρνω και αυτούς με κενό ΚΚ Λογιστηρίου.
    $data['a55p05_display'] = '';
    if (!empty($data['a55p05'])) {
        $kklo_p05 = pegasus_mysql_printfld('a10', 'p04', 'p01 = :a55p05', array('a55p05' => $data['a55p05']));
        $kkxr_p05 = pegasus_mysql_printfld('t02', 'p03', 'p01 = :kklo_p05', array('kklo_p05' => $kklo_p05));
        $data['a55p05_display'] = pegasus_mysql_printfld('a10', 'p02', 'p01 = :a55p05', array('a55p05' => $data['a55p05']));
        if($kkxr_p05 > 0) {
            $query = "SELECT GROUP_CONCAT(p01 SEPARATOR ',') AS p02_in FROM t02 WHERE p04 > 0";
            pegasus_mysql_use($query, $val);
            $p02_in_arr = explode(',' , $val['p02_in']);
            

            $p02_in      = pegasus_mysql_create_in($p02_in_arr, 'p02');
            $all_params  = $p02_in['sqlParams'];
            $a14_where_sql = "a14.p02 IN (" . $p02_in['sql'] . ")";
            if(pegasus_module_exists('pos00')) {
                // Και τα pos00_02 με τρόπο είσπραξης και ΚΚ.Λογ όπου το t02.p04 > 0
                $query_2 = "SELECT 
                                GROUP_CONCAT(a14 SEPARATOR ',') AS pos00_02_in 
                            FROM pos00_02 
                            JOIN t02 ON pos00_02.t02p01 = t02.p01
                            WHERE 
                                pos00_02.a14 > 0 
                                AND pos00_02.t02p01 > 0
                                AND t02.p04 > 0 ";
                pegasus_mysql_use($query_2, $val_2);
                $pos00_02_in_arr = explode(',', $val_2['pos00_02_in']);
                
                $pos00_02_in = pegasus_mysql_create_in($pos00_02_in_arr, 'pos00_02');
                $all_params = array_merge($p02_in['sqlParams'], $pos00_02_in['sqlParams']);
                $a14_where_sql = "a14.p02 IN (" . $p02_in['sql'] . ") OR a14.nr01 IN (" . $pos00_02_in['sql'] . ")";
            }
        }elseif($kkxr_p05 < 0) {
            $query = "SELECT GROUP_CONCAT(p01 SEPARATOR ',') AS p02_in FROM t02 WHERE p04 < 0";
            pegasus_mysql_use($query, $val);
            $p02_in_arr = explode(',' , $val['p02_in']);

            $p02_in      = pegasus_mysql_create_in($p02_in_arr, 'p02');
            $all_params = $p02_in['sqlParams'];
            $a14_where_sql = "a14.p02 IN (" . $p02_in['sql'] . ")";
            if(pegasus_module_exists('pos00')) {
                // Και τα pos00_02 με τρόπο είσπραξης και ΚΚ.Λογ όπου το t02.p04 < 0
                $query_2 = "SELECT 
                                GROUP_CONCAT(a14 SEPARATOR ',') AS pos00_02_in 
                            FROM pos00_02 
                            JOIN t02 ON pos00_02.t02p01 = t02.p01
                            WHERE 
                                pos00_02.a14 > 0 
                                AND pos00_02.t02p01 > 0
                                AND t02.p04 < 0 ";
                pegasus_mysql_use($query_2, $val_2);
                $pos00_02_in_arr = explode(',', $val_2['pos00_02_in']);

                $pos00_02_in = pegasus_mysql_create_in($pos00_02_in_arr, 'pos00_02');
                $all_params = array_merge($p02_in['sqlParams'], $pos00_02_in['sqlParams']);
                $a14_where_sql = "a14.p02 IN (" . $p02_in['sql'] . ") OR a14.nr01 IN (" . $pos00_02_in['sql'] . ")";
            }
        }
        pegasusSetGlobalVar(
            $container_id . '_a14_where',
            array(	'sql'		=> $a14_where_sql,
                    'sqlParams'	=> $all_params
            )
        );
        pegasusSetGlobalVar(
            'peg_'. $data['a55nr01'] . '_a14_where',
            array(	'sql'		=> $a14_where_sql,
                    'sqlParams'	=> $all_params
            )
        );
    }
	return $data;
}

function retail00_draw_payment_memo($container_id, $a55nr01) {

    $style = '
        <style>
            .retail00_01_d06_pay_methods_container {
                text-align: left;
            }
            .retail00_01_d06_pay_methods_rows {
                display: flex;
                align-content: center;
                flex-wrap: wrap;
                justify-content: flex-start;
            }

            .retail00_01_d06_pay_methods_buttons {
                display: inline-block;
                background-color: #b6e9fb;
                width: 33%;
                box-sizing: border-box;
                border: 2px solid white;
                text-align: center;
                padding: 15px 0;
                font-weight: bold;
                cursor: pointer;
                
                display: flex;
                height: 55px;
                align-content: center;
                flex-wrap: wrap;
                justify-content: space-evenly;
                
                &.active {
                    color: #ffffff;
                    background-color: #00d26d;
                }
            }

        </style>
    ';

    // $a14_where = pegasusGetGlobalVar(pegasus_container_id_get_parentBy_d($container_id, 'retail00_01_d') . '_a14_where');
    $a14_where = pegasusGetGlobalVar('peg_'. $a55nr01 .'_a14_where');
    $a14_query = 'SELECT * FROM a14 WHERE ' . $a14_where['sql'];
    $res = pegasus_query($a14_query, $a14_where['sqlParams']);

    $html = '<div class="retail00_01_d06_pay_methods_container">';
    $rows = '<div class="retail00_01_d06_pay_methods_rows">';
    while($a14 = pegasus_fetch($res, PEG_FETCH_ASSOC)) {
        $is_metrita = pegasus_mysql_printfld('t02', 'p05', 'p01 = ?', array($a14['p02'])); // KK Λογιστηρίου - Ταμείο (όλο το ποσό)
        if(empty($is_metrita)) {
            $is_metrita = 0;
        }

        $is_epi_pistosi = retail00_is_epi_pistosi_a14($a14['nr01']);

        $pos_settings = 0;
        if(pegasus_module_exists('pos00')) {
            $pos00_02 = pos00_find_pos00_02($a14['nr01'], $_SESSION["cor003_p01"]);
            if(!empty($pos00_02)) {
                $pos_settings = $pos00_02['nr01'];
            }
        }

        $rows .= '<div 
            class="retail00_01_d06_pay_methods_buttons" 
            onclick="retail00_01_d06_change_payment(\''.$container_id.'\', '.$a14['nr01'].', '.$is_metrita.', \''.$a14['p01'].'\', '.$pos_settings.', this, '.$is_epi_pistosi.')"
        >';
        $rows .= $a14['p01'];
        $rows .= '</div>';
    }
    $rows .= '</div>';
    $html .= $rows;
    $html .= '</div>';

    $payment_memo = $style . $html;
    return $payment_memo;
}

function retail00_draw_cash_memo($container_id) {

    $decimal_sep = $_SESSION['cor000_decimal_char'];
    $values = array(
        "200",
        "100",
        "50",
        "20",
        "10",
        "5",
        "2",
        "1",
        "0".$decimal_sep."50",
        "0".$decimal_sep."20",
        "0".$decimal_sep."10",
        "0".$decimal_sep."05",
        "0".$decimal_sep."02",
        "0".$decimal_sep."01",
        "C"
    );

    $style = '
        <style>
            .retail00_01_d06_cash_memo_container {
                text-align: left;
            }
            .retail00_01_d06_cash_memo_rows {
                display: flex;
                align-content: center;
                flex-wrap: wrap;
                justify-content: flex-start;
            }

            .retail00_01_d06_cash_memo_buttons {
                display: inline-block;
                background-color: #e9e9e9;
                width: 33%;
                box-sizing: border-box;
                border: 2px solid white;
                text-align: center;
                font-weight: bold;
                cursor: pointer;
                
                display: flex;
                height: 55px;
                align-content: center;
                flex-wrap: wrap;
                justify-content: space-evenly;
                align-items: center;
                font-size: 16px;
            }
            .retail00_01_d06_cash_memo_button_c {
                background-color: #f23a3a;
                color: #ffffff;
            }
        </style>
    ';
    $html = '<div class="retail00_01_d06_cash_memo_container">';
    $rows = '<div class="retail00_01_d06_cash_memo_rows">';
    foreach($values as $value) {
        $extra_class = '';
        $js_value = $value;
        if($value == 'C') {
            $extra_class = 'retail00_01_d06_cash_memo_button_c';
        }else{
            // Αν έχω κόμμα ως decimal separator, το αλλάζω σε τελεία στην onclick. Το κάνω εδώ για να μην μπλέξω σε JS μετατροπή.
            $js_value = str_replace(',', '.', $value);
        }
        $rows .= '<div class="retail00_01_d06_cash_memo_buttons '.$extra_class.'" onclick="retail00_01_d06_change_cash(\''.$js_value.'\', \''.$container_id.'\')">';
        $rows .= $value;
        $rows .= '</div>';
    }
    $rows .= '</div>';
    $html .= $rows;
    $html .= '</div>';

    $cash_memo = $style . $html;
    return $cash_memo;
}

/**
 * Ελέγχει για αλλαγές στα στοιχεία του πελάτη στη φόρμα συγκριτικά με τη βάση και επιστρέφει μήνυμα.
 * @param $a01nr01 - ΜΚ Πελάτη
 * @param $data - array με τα στοιχεία του πελάτη στο tab
 */
function retail00_check_a01_changes($a01nr01, $data) {
    pegasus_mysql_use('SELECT * FROM a01 WHERE nr01 = :a01nr01', $a01, array('a01nr01' => $a01nr01));
    $differences = array();

    foreach ($data as $key => $value) {
        $no_prefix_key = substr($key, 3); // Remove the 'a01' prefix from keys
        if ((is_numeric($value) && is_numeric($a01[$no_prefix_key])) || ($value === $a01[$no_prefix_key])) {
            if ((floatval($value) != floatval($a01[$no_prefix_key]))) {
                $differences[$key] = array($value, $a01[$no_prefix_key]);
            }
        } else {
            $differences[$key] = array($value, $a01[$no_prefix_key]);
        }
    }
    if (empty($differences)) {
        $ret['msg'] = "";
    } else {
        $ret['msg'] = "Βρέθηκαν αλλαγές στα στοιχεία του πελάτη. Θέλετε να ενημερωθούν τα στοιχεία του πελάτη με τις παρακάτω αλλαγές: <br>";
        foreach ($differences as $key => $values) {
            $fld_name = pegasus_mysql_printfld('p51', 'desc02', 'p02 = "retail00_01_d02" and desc05 = :key ', array('key' => $key));
            $ret['msg'] .= "<b>" . $fld_name.":</b> ".$values[1]." -> ".$values[0]."<br>";
        }
        $ret['msg'] .= "Αν δεν αποθηκεύσετε τις αλλαγές, τότε το παραστατικό θα αποθηκευθεί με τις υπάρχουσες τιμές του πελάτη στη βαση. ";
    }
    return $ret;
}

function peg_retail00_retail00_01_d010_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {
    $user = pegasus_mysql_printfld('us0', 'p01', 'nr01 = ?', array($_SESSION['user']));
    
    $data['erpa82p01'] = $user; // Χρήστης
    $data['erpa82p02'] = date('Y-m-d'); // Ημ/νια Ανοίγματος
    $data['erpa82p03'] = date('H:i'); // Ώρα Ανοίγματος
    
    // Σετάρεται μόνο όταν η οθόνη έχει ανοίξει από το κουμπί του συνόλου, χρησιμοποιείται για να ξανακάνει check shift.
    global $PegInput;
    $PegInput->addVar(new peg_input_number('eispraksi'));
    $req_eispraksi = $PegInput->getRequest('eispraksi');
    if(isset($req_eispraksi) && !empty($req_eispraksi)) {
        $data['eispraksi'] = 1;
    }

    return $data;
}

function peg_retail00_retail00_01_d011_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {
    $erpa82 = shifts_find_open_shift();
    
    $data['erpa82p01'] = $erpa82['p01']; // Χρήστης
    $data['erpa82p02'] = $erpa82['p02']; // Ημ/νια Ανοίγματος
    $data['erpa82p03'] = $erpa82['p03']; // Ώρα Ανοίγματος
    $data['erpa82p06'] = $erpa82['p06']; // Ποσό Ανοίγματος

    $data['erpa82p04'] = date('Y-m-d');
    $data['erpa82p05'] = date('H:i');
    $data['msg_hidden'] = true;
    
    // Σετάρεται μόνο όταν η οθόνη έχει ανοίξει από το κουμπί του συνόλου, χρησιμοποιείται για να ξανακάνει check shift.
    global $PegInput;
    $PegInput->addVar(new peg_input_number('eispraksi'));
    $req_eispraksi = $PegInput->getRequest('eispraksi');
    if(isset($req_eispraksi) && !empty($req_eispraksi)) {
        $data['eispraksi'] = 1;
        $data['msg'] = '<div class="peg_alert_warning_plain" style="text-align: center;">' . $_SESSION['peg_dic_retail00_check_shift_prompt_disable'] . '</div>';
        $data['msg_hidden'] = false;
    }

    return $data;
}

/**
 * Διαγράφει τα δεδομένα στους temporary πίνακες που έχουν δημιουργηθεί για το συγκεκριμένο παραστατικό
 * με βάση το mmnr01 και το session_id
 * @param int $a55nr01 - MK Παραστατικού στην οθόνη.
 */
function retail00_delete_tmp($a55nr01, $delete_t01 = 0) {
    $tmp_tables = array(
        'i01', // Κινήσεις Ειδών
        'i71'  // Φόροι - Κρατήσεις ανά παραστατικό
    );
    if(pegasus_module_exists('colorsize')) {
        $tmp_tables[] = 'i48'; // Κινήσεις Χ-Μ
    }
    if(pegasus_module_exists('serial')) {
        $tmp_tables[] = 'i32'; // Κινήσεις Serial
    }
    if(pegasus_module_exists('lot')) {
        $tmp_tables[] = 'i38'; // Κινήσεις Παρτιδών
    }

    if(pegasus_module_exists('dc00') &&  pegasus_mysql_table_exists('dc0003')) {
        $tmp_tables[] = 'dc0003'; // Κινήσεις Παρτιδών
    }

    $where = ' 
        WHERE
                ##tbl##.peg_mmnr01="a55_d-'  . $a55nr01 . '" 
            AND ##tbl##.peg_sess_id="' . session_id() . '" '
    ;

    foreach($tmp_tables as $table) {
        $query = "  DELETE 
                    FROM peg_tmp_" .$table. " " . 
                    str_replace( '##tbl##' ,  'peg_tmp_' . $table, $where) . 
                    ";" 
        ;
        $res = pegasus_query($query);
    }

    if($delete_t01 == 1) {
        //* $delete_t01 έχω από καθαρισμο παραστατικού ή καταχώρηση παραγγελίας.
        $where = 'p302 = :a55nr01 AND pd101 = "a14" ';
        $whereParams = array(
            'a55nr01' => $a55nr01
        );
        if(pegasus_module_exists('pos00')) {
            //Αν έχω POS βρίσκω τις τους Τρ. Είσπραξης που αφορούν POS και ορίζουν να μην διαγραφούν κινήσεις με αυτούς.
            $where_pos00 = "SELECT 
                        GROUP_CONCAT(a14 SEPARATOR ',') AS pos00_02_in 
                    FROM pos00_02 
                    JOIN t02 ON pos00_02.t02p01 = t02.p01
                    WHERE 
                        pos00_02.a14 > 0 
                        AND pos00_02.t02p01 > 0
                        AND t02.p04 > 0 ";
            pegasus_mysql_use($where_pos00, $val_pos00);
            $pos00_02_in_arr = explode(',', $val_pos00['pos00_02_in']);
            
            $pos00_02_in = pegasus_mysql_create_in($pos00_02_in_arr, 'pos00_02');
            $whereParams = array_merge($whereParams, $pos00_02_in['sqlParams']);
            $where .= ' AND pd102 NOT IN (' . $pos00_02_in['sql'] . ')';
        }
        pegasus_mysql_delete(
            't01',
            $where,
            0,
            $whereParams
        );
    }
}

function retail00_clear_invoice($a55nr01, $container_id, $no_new_nr01 = 0, $ecr_sim_container_id = '') {
    //* $no_new_nr01 έχω από καθαρισμό παραστατικού ή καταχώρηση παραγγελίας. Είναι παράμετρος στο ajax της clear_invoice.
    $delete_t01 = 0;
    if($no_new_nr01 == 1) {
        $delete_t01 = 1;
    }
    retail00_delete_tmp($a55nr01, $delete_t01);
    $data = array();
    $mmnr01 = '';
    $mnr01 = '';
    $_d = 'retail00_01_d';
    // $container_id = '';
    $data['no_new_nr01'] = $no_new_nr01;
    if($no_new_nr01 > 0) {
        // Έλεγχος αν το a55nr01 δεν υπάρχει. Αν υπάρχει σημαίνει ότι έκανα καθαρισμό παραστατικού που είχα φορτώσει από Αναμονή
        $pending_a55 = pegasus_mysql_printfld('a55', 'nr01', 'nr01 = :var_a55nr01', array('var_a55nr01'=>$a55nr01));
        if(!empty($pending_a55)){
            $data['no_new_nr01'] = 0;
        }
        $data['a55nr01'] = $a55nr01;
    }
    $data = peg_retail00_retail00_01_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id);

    if(pegasus_module_exists('retail01')) {
        //* To χρησιμοποιώ για να βρω το _where_eidi στη mobile ταμειακή.
        if(!empty($ecr_sim_container_id)) {
            pegasusSetGlobalVar($ecr_sim_container_id . '_ecr_sim_a55nr01',   $data['a55nr01']);
            // echo '<pre>' .print_r($data, 1). '<pre>';
            // echo '<pre>' .$data['a55nr01']. '<pre>';
            // echo '<pre>' .pegasusGetGlobalVar($ecr_sim_container_id . '_ecr_sim_a55nr01'). '<pre>';
        }
    }

    return $data;
}

function retail00_refresh_all_i71($tbl, $tbl_nr, $tbl_p07, $tbl_pn02, $total_p0100, $p0102) {

    $query = "  SELECT 
                * 
                FROM peg_tmp_i71 
                WHERE
                    peg_sess_id =:peg_sess_id AND
                    peg_mmnr01  =:peg_mmnr01 AND
                    peg_mnr01   =:peg_mnr01 AND
                    peg_flag   !=9 AND
                    tbl     =:tbl AND
                    tbl_nr  =:tbl_nr 
    ";
    $values = array(
        "peg_sess_id"   => session_id(),
        "peg_mmnr01"    => $tbl . "_d-" . $tbl_nr,
        "peg_mnr01"     => $tbl_nr,
        "tbl"           => $tbl,
        "tbl_nr"        => $tbl_nr
    );

    $data['i71_records'] = array();
    $vp0109 = $total_p0100 - $p0102;

    $i71_res = pegasus_query($query, $values);
    if(pegasus_num_rows($i71_res) > 0) {
        $i = 1;
        $data['i71_records'] = array();
        while ($i71 = pegasus_fetch_assoc($i71_res)) {
            $i71['tbl_p07'] = $tbl_p07	;
            $i71['tbl_pn02'] = $tbl_pn02;
            $i71_data = invoices_i71_d_refresh($i71, $vp0109);

            $i71_array['i71_rec_nr01_'.$i]          = $i71_data['nr01'];
            $i71_array['i71_rec_i70_'.$i]           = $i71_data['i70'];
            $i71_array['i71_rec_i70p02_'.$i]        = $i71_data['i70p02'];
            $i71_array['i71_rec_p04_'.$i]           = $i71_data['p04'];
            $i71_array['i71_rec_p04_hidden_'.$i]    = $i71_data['p04_hidden'];
            $i71_array['i71_rec_p04_readonly_'.$i]  = $i71_data['p04_readonly'];
            $i71_array['i71_rec_p05_'.$i]           = $i71_data['p05'];
            $i71_array['i71_rec_p05_hidden_'.$i]    = $i71_data['p05_hidden'];
            $i71_array['i71_rec_p05_readonly_'.$i]  = $i71_data['p05_readonly'];
            $i71_array['i71_rec_p100_'.$i]          = $i71_data['p100'];
            $i71_array['i71_rec_tax_'.$i]           = $i71_data['tax'];
            $i71_array['i71_rec_tbl_'.$i]           = $i71_data['tbl'];
            $i71_array['i71_rec_tbl_nr_'.$i]        = $i71_data['tbl_nr'];
            $i71_array['i71_rec_tbl_p07_'.$i]       = $i71_data['tbl_p07'];
            $i71_array['i71_rec_tbl_pn02_'.$i]      = $i71_data['tbl_pn02'];
            $i71_array['i71_rec_message_'.$i]       = $i71_data['message'];
            $i71_array['i71_rec_v_selectbox_i70_'.$i]  = $i71_data['v_selectbox_i70'];

            $i++;
        }
        $data['i71_records'] = $i71_array;
    }
    return $data;
}

// i71_refresh PAYLOAD
// ============================================================
// nr01: 10000089               -- MK Φόρου Κράτησης
// i70: 0                       -- Φόρος κράτηση
// i70p02: 2                    -- Τύπος
// p04: 0                       -- Ποσοστό Υπολογισμού
// p05: 0                       -- Αξία Υπολογισμού
// tax: 0                       -- Διαδοχή
// total_p0100: 80.65           -- Αρχική Αξία Παραστατικού
// p0102: 0                     -- Έκπτωση Παραστατικού (Ποσό προ ΦΠΑ)
// tbl: a55                     -- tbl
// tbl_nr: 10001683             -- MK Παραστατικού
// tbl_p07: 1                   -- Οι τιμές περιέχουν φπα
// is_i70_change: 0             -- Όρισμα στην κλήση της JS συνάρτησης που κάνει το ajax
// tbl_pn02: 1                  -- Ισοτιμία (Παραστατικού)
function retail00_i71_d_refresh($data, $vp0109, $is_i70_change = false, $is_new = false) {

    $ret = invoices_i71_d_refresh($data, $vp0109, $is_i70_change, $is_new);
    retail00_i71_update_tmp($ret);

    return $ret;
}

function retail00_i71_update_tmp($data) {

    $is_new = true;
	if(pegasus_mysql_printfld('peg_tmp_i71','nr01','nr01=:nr01',array('nr01'=>$data['nr01']))>0) {
		$is_new = false;
	}
    // Αν $is_new = true θα κάνω insert, αλλιώς update

    $arr1 = array();    $arr2 = array();
    array_push($arr1, 'nr01');      array_push($arr2,  $data['nr01']);
    array_push($arr1, 'tbl');       array_push($arr2,  $data['tbl']);
    array_push($arr1, 'tbl_nr');    array_push($arr2,  $data['tbl_nr']);
    array_push($arr1, 'i70p02');    array_push($arr2,  $data['i70p02']);
    array_push($arr1, 'i70');       array_push($arr2,  $data['i70']);
    
    array_push($arr1, 'p04');       array_push($arr2,  $data['p04']);
    array_push($arr1, 'p05');       array_push($arr2,  $data['p05']);
    array_push($arr1, 'p100');      array_push($arr2,  $data['p100']);
    array_push($arr1, 'i70p07');    array_push($arr2,  $data['i70p07']);
    /** Στο a55_d_onchange τρέχει το :
     * i71 ενημερωση  Κ.Κ. και  συντελεστη -1 Ακυρα 
     * invoices_update_i71_d00_onsave($mmnr01, $p_kkapo, $p_asyn); 
     * 
     * Λογικά θα ενημερώνεται σωστά από εκεί (t02p01, p012) με την καταχώρηση του παραστατικού. ΝΑ ΤΟ ΕΛΈΓΞΩ!!!!
    */
    // array_push($arr1, 't02p01');    array_push($arr2,  0); // Δεν το έχω στο data, να δω πως παίρνει τιμή
    // array_push($arr1, 'p012');      array_push($arr2,  0); // Δεν το έχω στο data, να δω πως παίρνει τιμή
    array_push($arr1, 'tax');       array_push($arr2,  $data['tax']);
    
    array_push($arr1, 'peg_mmnr01');    array_push($arr2,  'a55_d-'.$data['tbl_nr']);
    array_push($arr1, 'peg_mnr01');     array_push($arr2,  $data['tbl_nr']);
    array_push($arr1, 'peg_sess_id');   array_push($arr2,  session_id());
    if($is_new == true) {
        array_push($arr1, 'peg_flag');      array_push($arr2,  1);
        pegasus_mysql_insert('peg_tmp_i71', $arr1, $arr2);
    }else{
        array_push($arr1, 'peg_flag');      array_push($arr2,  2);
        pegasus_mysql_update(
            'peg_tmp_i71', 
            $arr1, 
            $arr2, 
            'nr01 = :nr01 AND peg_mnr01 = :mnr01 AND peg_mmnr01 = :mmnr01 and peg_sess_id = :sid', 
            0,
            1,
            1,
            array('nr01' => $data['nr01'], 'mnr01' => $data['tbl_nr'], 'mmnr01' => 'a55_d-'.$data['tbl_nr'], 'sid' => session_id())
        );
    }

}

function retail00_delete_i71($i71_nr01, $tbl, $tbl_nr) {
    pegasus_mysql_update(
        'peg_tmp_i71',
        array('peg_flag'), 
        array(9), 
        'peg_mmnr01 = :peg_mmnr01 
         AND peg_mnr01 = :peg_mnr01
         AND peg_sess_id = :peg_sess_id
         AND tbl = :tbl
         AND tbl_nr = :tbl_nr
         AND nr01 = :i71_nr01
        ',
        0, 1, 1,
        array(
            "peg_mmnr01"  => $tbl . '_d-' . $tbl_nr,
            "peg_mnr01"   => $tbl_nr,
            "peg_sess_id" => session_id(),
            "tbl"         => $tbl,
            "tbl_nr"      => $tbl_nr,
            "i71_nr01"    => $i71_nr01
        )
    );
}

function retail00_retail00_01_d08_comboboxV2_dynamic_fields_where($field_name, $container_id){ 
    if (substr($field_name, 0, 12) == 'i71_rec_i70_') {
        $index = str_replace('i71_rec_i70_', '', $field_name);
        // $ret_arr = array(
        //     'sql' => 'i70.p02=:i70p02 and i70.p300=1' ,
        //     'sqlParams' => array('i70p02' => 2) // $data['i70p02']
        // );
        $ret_arr = pegasusGetGlobalVar($container_id . '_i71_rec_i70_'.$index.'_where');
    }

    return $ret_arr;
}

/**
 * Καλείται μέσω AJAX για την συμπλήρωση του Websocket URI για την εκκίνηση του Barcode Scanner από την οθόνη Retail
 * @return string
 */
function retail00_get_ws_uri()
{
	pegasus_mysql_use("SELECT ip, port FROM retail00_00 WHERE nr01 = 1", $res);

	if (empty(trim($res['ip']) || empty(trim($res['port'])))) {
		return array(
			'ok'	=> 0,
			'msg'	=> $_SESSION['peg_dic_retail00_01_d_ws_check_error_1']
		);
	} 
	$uri = "ws://" . trim($res['ip']) . ":" . trim($res['port']);
	return array(
		'ok'	=> 1,
		'data'	=> array('uri' => $uri)
	);
}
function retail00_retail00_05_d_onchange($data, $permDeny, $mmnr01, $checkOnlyPerm) {

    pegasus_mysql_use('SELECT * FROM retail00_03 WHERE nr01 = :retail00_03', $retail00_03, array('retail00_03' => $data['retail00_03']));

    // Αν τύπος = π-αναφορα και κενή π-αναφορά
    if(empty($data['p04']) && $retail00_03['p04'] == 1) {
        array_push($permDeny, array('type' => 'deny', 'message' => 'Πρέπει να επιλέξετε π-Αναφορά'));
    }

    if($data['retail00_03'] == 140000146000009 && $data['p03'] != 1) {
        //To "Όλες οι Ενέργειες" δεν μπορεί να εμφανίζεται στο mobile.
        array_push($permDeny, array('type' => 'deny', 'message' => 'Το επιλεγμένο Button Ενέργειας μπορεί να εμφανιστεί μόνο σε Desktop οθόνες.'));
    }

    return array($data, $permDeny);

}


function retail00_draw_retail00_06($container_id, $pno) {

    $style = '
        <style>
            .retail00_01_d03_retail00_06_container {
                text-align: left;
            }
            .retail00_01_d03_retail00_06_rows {
                display: flex;
                align-content: center;
                flex-wrap: wrap;
                justify-content: flex-start;
            }

            .retail00_01_d03_retail00_06_buttons {
                display: inline-block;
                background-color: #b6e9fb;
                width: 33%;
                box-sizing: border-box;
                border: 2px solid white;
                text-align: center;
                padding: 15px 0;
                font-weight: bold;
                cursor: pointer;
                
                display: flex;
                height: 55px;
                align-content: center;
                flex-wrap: wrap;
                justify-content: space-evenly;
                
                &.active {
                    color: #ffffff;
                    background-color: #00d26d;
                }
            }

            @media (max-width: 549px) {
                .retail00_01_d03_retail00_06_buttons {
                    width: 100%;
                }
            }
        </style>
    ';
    
    pegasus_mysql_use('SELECT * FROM i00 WHERE pno = ?', $i00, array($pno));

    $where = '';
    $whereValues = array();
    if(!empty($i00['p9901'])) {
        $where .= ' AND (p9901 = :p9901 OR p9901 = 0) ';
        $whereValues['p9901'] = $i00['p9901'];
    }
    if(!empty($i00['p9902'])) {
        $where .= ' AND (p9902 = :p9902 OR p9902 = 0) ';
        $whereValues['p9902'] = $i00['p9902'];
    }
    if(!empty($i00['p910'])) {
        $where .= ' AND (p910 = :p910 OR p910 = 0) ';
        $whereValues['p910'] = $i00['p910'];
    }
    if(!empty($i00['p911'])) {
        $where .= ' AND (p911 = :p911 OR p911 = 0) ';
        $whereValues['p911'] = $i00['p911'];
    }
    $retail00_06_query = 'SELECT * FROM retail00_06 WHERE 1=1 ' . $where . ' ORDER BY tax, p00';

    $res = pegasus_query($retail00_06_query, $whereValues);
    // echo '<pre>' .pegasus_replace_values_in_sql($retail00_06_query, $whereValues). '</pre>';

    $retail00_06_memo = '';
    if(pegasus_num_rows($res) > 0) {
        $html = '<div class="retail00_01_d03_retail00_06_container">';
        $rows = '<div class="retail00_01_d03_retail00_06_rows">';
        while($retail00_06 = pegasus_fetch($res, PEG_FETCH_ASSOC)) {
            $text = $retail00_06['p00'];
            if($_SESSION['lang'] != 'GR') {
                $text = $retail00_06['ep00'];
            }
    
            $rows .= '<div 
                class="retail00_01_d03_retail00_06_buttons" 
                onclick="retail00_01_d03_add_retail00_06(\''.$text.'\', \''.$container_id.'\')"
            >';
            $rows .= $text;
            $rows .= '</div>';
        }
        $rows .= '</div>';
        $html .= $rows;
        $html .= '</div>';
    
        $retail00_06_memo = $style . $html;
    }

    return $retail00_06_memo;
}

function retail00_retail00_00_p03_toggle_change() {
    if($_SESSION['retail00_00_p03'] == 1) {
        pegasus_mysql_update('retail00_00', array('p03'), array(0), 'nr01 = 1');
        $msg = $_SESSION['peg_dic_retail00_retail00_00_p03_change_msg_0'];
    }else{
        pegasus_mysql_update('retail00_00', array('p03'), array(1), 'nr01 = 1');
        $msg = $_SESSION['peg_dic_retail00_retail00_00_p03_change_msg_1'];
    }
    pegasusWriteSession('retail00_00');
    pegasusReadSession('retail00_00');

    return $msg;
}

function retail00_is_epi_pistosi_a14($a14_nr01) {
    pegasus_mysql_use('SELECT nr01, p02 FROM a14 WHERE nr01 = ? ', $a14, array($a14_nr01));;
    
    $is_epi_pistosi = 0;
    //* Αν βρήκα a14 με το παραπάνω ΜΚ και αυτό το a14 δεν έχει ΚΚ Λογιστηρίου
    if(!empty($a14['nr01']) && empty($a14['p02'])) {
        //* Σημαίνω τους Τρ. Είσπραξης που είναι Επί Πιστώσει, χωρίς σύνδεση με Ρυθμίσεις POS
        $has_pos00_02 = 0;
        if(pegasus_module_exists('pos00')) {
            $has_pos00_02 = pegasus_mysql_printfld('pos00_02', 'nr01', 'a14 = ?', array($a14_nr01));
        }
        if(empty($has_pos00_02)) {
            $is_epi_pistosi = 1;
        }
    }

    return $is_epi_pistosi;
}


function retail00_find_quantity_field($p01 = ''){

pegasus_mysql_use("SELECT p101, p102, p103, p104, p106, p107, p108, p109, p110 FROM i24 WHERE i24.p01 = ? ",$i24, array($p01));

if(count(array_filter($i24)) == 0){
        $quantity = 'p03';
    }else if(count(array_filter($i24)) == 1){
        $quan = implode(array_keys(array_filter($i24)));
        switch ($quan) {
            case 'p101':
                $quantity = 'p301';
                break;
            case 'p102':
                $quantity = 'p302';
                break;
            case 'p103':
                $quantity = 'p303';
                break;
            case 'p104':
                $quantity = 'p304';
                break;
            case 'p106':
                $quantity = 'p306';
                break;
            case 'p107':
                $quantity = 'p307';
                break;
            case 'p108':
                $quantity = 'p308';
                break;
            case 'p109':
                $quantity = 'p309';
                break;
            case 'p110':
                $quantity = 'p310';
                break;
            default:
                $quantity = 'p03';
                break;
        }          
    }

    return $quantity;
}

function retail00_set_query_eidi_global_var($container_id, $a55_nr01, $where) {
    $query_eidh_cs = '""';
    if(pegasus_module_exists('colorsize')){
        $query_eidh_cs = ' ( SELECT if (group_concat(DISTINCT i40.p02, i43.p02)= "", null, group_concat(DISTINCT "<br>", i40.p02, " - ", i43.p02))
                            FROM  peg_tmp_i01 as peg_tmp_i01_2
                            LEFT JOIN peg_tmp_i48
                                    ON peg_tmp_i48.p01 = peg_tmp_i01.nr01
                            LEFT JOIN i40
                                    ON i40.p01 = peg_tmp_i48.p02
                            LEFT JOIN i43
                                    ON i43.p01 = peg_tmp_i48.p03
                            WHERE  
                            peg_tmp_i01_2.p01 = peg_tmp_i01.p01) ' ;
    }
    $query_eidh_lot = '""';
    if(pegasus_module_exists('lot')){
        $query_eidh_lot = ' ( SELECT if (group_concat(DISTINCT peg_tmp_i38.p02)= "", null, group_concat(DISTINCT "<br>", peg_tmp_i38.p02))
                            FROM  peg_tmp_i01 as peg_tmp_i01_2
                            LEFT JOIN peg_tmp_i38
                                ON peg_tmp_i38.p01 = peg_tmp_i01.nr01
                            WHERE  
                            peg_tmp_i01_2.p01 = peg_tmp_i01.p01) ' ;
    }
    $query_eidh_serial = '""';
    if(pegasus_module_exists('serial')){
        $query_eidh_serial = ' ( SELECT if (group_concat(DISTINCT peg_tmp_i32.p02)= "", null, group_concat(DISTINCT "<br>", peg_tmp_i32.p02))
                              FROM  peg_tmp_i01 as peg_tmp_i01_2
                              LEFT JOIN peg_tmp_i32
                                ON peg_tmp_i32.p00 = peg_tmp_i01.nr01
                              WHERE  
                                peg_tmp_i01_2.p01 = peg_tmp_i01.p01) ' ;
    }

    $query_eidh= 'SELECT peg_tmp_i01.*,
                    '.$query_eidh_cs.'  AS v_cs_desc,
                    '.$query_eidh_lot.' AS v_lots_desc,
                    '.$query_eidh_serial.' AS v_serial_desc,
                    '.intval($_SESSION['retail00_00_p08']).' AS v_a90_p30_grid
                    FROM   peg_tmp_i01
                    WHERE'.$where;
    pegasusSetGlobalVar( $container_id. '_query_eidi', $query_eidh);
    pegasusSetGlobalVar('peg_a55_d-' . $a55_nr01 . '_query_eidi', $query_eidh);
}

function peg002__retail00_change_num_value_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id){
    global $PegInput;        
    $PegInput->addVar(new peg_input_alphanumeric('input_field_name'));
    $PegInput->addVar(new peg_input_alphanumeric('input_field_value'));
    $PegInput->addVar(new peg_input_alphanumeric('peg_screenTitle'));

    $data['bt_decimal_text']=$_SESSION['cor000_decimal_char'];
    $data['input_field']=str_replace(array(',','.'),$_SESSION['cor000_decimal_char'],$PegInput->getRequest('input_field_value'));
    $data['peg_screenTitle']=$PegInput->getRequest('peg_screenTitle'); 

    $data['v_input_field_name'] = $PegInput->getRequest('input_field_name');
    return $data;
}

function peg_retail00_retail00_01_d05_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {

    $sql = ' a01.p0400 = 0 ';

    pegasusSetGlobalVar(
        $container_id . '_retail00_01_d05_a01_search_where',
        array(
            'sql'		=>	$sql,
            'sqlParams'	=>	array()
        )
    );
}

function peg_retail00_retail00_std_action_1022_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
    global $PegInput;
    //$PegInput->addVar(new peg_input_alphanumeric('parent_id'));
    $PegInput->addVar(new peg_input_number('retail00_01_d02_a01nr01'));
    //$parent_id = $PegInput->getRequest('parent_id');
    $retail00_01_d02_a01nr01 = $PegInput->getRequest('retail00_01_d02_a01nr01');


    $data['dt_from'] = date('Y-01-01');
    $data['dt_to']   = date('Y-m-d');
    $data['a01nr01'] = $retail00_01_d02_a01nr01;
    invtrans_i01_d1022_set_grid_query($data, $container_id);

    return $data;
}

function retail00_find_a55p05($p0121, $p703) {
    // Αν εχουμε ορισει παραστατικο στις βασικες παραμετρους τερματικών (retail00_04) πρώτα κοιτάμε αυτό και μετά στις βασικές παραμέτρους 
    // Το data[p05] μπορεί να εχει γίνει set απο τις υπηρεσίες ή τον πελάτη

    $a10p01 = pegasus_mysql_printfld("retail00_04", "a10p01", "cor003p01 = ?", array($_SESSION['pegasus_client_uid']));
    $a10p01 = !empty($a10p01) ? $a10p01 : $_SESSION['retail00_00_a10p01'];

    if(empty($a10p01)) {
		$data['a55p05'] = pegasus_mysql_printfld(
			pegasus_get_grid_table('a10'),
			'p01',
			"p110 = 1 AND
            (	
                ( 
                    a10.p30 = '' OR
                    a10.p30 IS NULL OR
                    locate(:locate_00, a10.p30) <> 0
                ) AND 
                ( 
                    a10.p31 = '' OR
                    a10.p31 IS NULL OR
                    locate(:locate_01, a10.p31) <> 0
                )
            ) AND 
            a10.p200 >= 0 AND 
            a10.ptax >= 0
            ORDER BY ptax",
			array(
				'locate_00'	=>	"#" . $p0121 . "#", // Κατάστημα
				'locate_01'	=>	"#" . $p703  . "#"  // Αποθήκη
			)
		);
	} else {
        $data['a55p05'] = $a10p01;
    }

    return $data['a55p05'];
}

function retail00__retail00_std_action_1025_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id) {
    retail00_search_vehicle($container_id);
    
    return $data;
}

function retail00_search_vehicle($container_id, $erpa02_search="") {
     $query = "SELECT erpa02.* FROM erpa02
               LEFT JOIN a01 ON a01.nr01 = erpa02.p03
               WHERE erpa02.p05 LIKE :erpa02_search AND a01.p0400 = 0 AND erpa02.p010 = 0";

    $queryParams = array("erpa02_search" => '%'.peg_core_abschr($erpa02_search).'%');

    pegasusSetGlobalVar(
        $container_id . '_retail00_std_action_erpa02_search_tbl_query',
        array(
            'sql'		=>	$query,
            'sqlParams'	=>	$queryParams
        )
    );   
}

function retail00__retail00_std_action_1026_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id) {
    global $PegInput;

    $PegInput->addVar(new peg_input_number('a01nr01'));
    $a01nr01 = $PegInput->getRequest('a01nr01');

    pegasusSetGlobalVar(
        $container_id . '1026_retail00_std_action_where',
        array(
            'sql'	    => "p601 = :a01nr01",
            'sqlParams' => array("a01nr01" => $a01nr01)
        )
    );

    return $data;
}
