<?php
require_once('../retail00_00/header.php');

$PegInput->addVar(new peg_input_alphanumeric('v101'));
$PegInput->addVar(new peg_input_number('v103'));
$PegInput->addVar(new peg_input_number('mnr01'));
$PegInput->addVar(new peg_input_alphanumeric('mmnr01'));
$PegInput->addVar(new peg_input_alphanumeric('new_serial_memo'));
$PegInput->addVar(new peg_input_alphanumeric('i32_screen_records'));
$v101 = $PegInput->getRequest('v101');
$v103 = $PegInput->getRequest('v103');
$mnr01 = $PegInput->getRequest('mnr01');
$mmnr01 = $PegInput->getRequest('mmnr01');
$new_serial_memo = $PegInput->getRequest('new_serial_memo');
$i32_screen_records = $PegInput->getRequest('i32_screen_records');

$ret_arr = array();
$ret_arr['i32_screen_records'] = json_decode($i32_screen_records, true);
$msg = '';

//! Στο mmnr01 εδώ έχω retail00_01 αντί για a55 για να το ξεχωρίζει η JS συνάρτηση επειδή κάνει τον διαχωρισμό από αυτό και όχι από mode
//! Στη βάση στα tmp γράφω πάντα με a55_d- στα tmp, οπότε το αλλάζω εδώ.
if(substr($mmnr01, 0, 11) == 'retail00_01') {
	$mmnr01 = str_replace('retail00_01', 'a55', $mmnr01);
}
$i32_p01 = '1'; //sera04 - 1 = Αποθήκη

// Παράμετρος αν επιτρέπεται ή όχι η καταχώρηση serial από αγορά.
if ($_SESSION['f02_pg903']) {
	$msg = $_SESSION["peg_dic_serial_no_new_sn"];
}
if (!empty($msg)) {
	$ret_arr['ok']  = 0;
	$ret_arr['msg'] = $msg;
	echo json_encode($ret_arr);
	return;
}
$i32_screen_records = json_decode($i32_screen_records, true);

$new_serials_array = array();
$new_serials_array = $i32_screen_records;
$last_key = array_key_last($new_serials_array);

//* Αν $new_serial_memo γεμάτο, έχω έρθει από καταχώρηση νέου serial χωρισμένα με κόμμα
if(!empty($new_serial_memo)){
	// $sn_array = explode(',', $new_serial_memo);
	//* Αλλαγή να διαβάζει και την αλλαγή γραμμής.
	$sn_array = preg_split("/[,\n]+/", $new_serial_memo);
	$sn_array = array_filter($sn_array);

	$res_i31 = array();

	$i31_p02_in = pegasus_mysql_create_in($sn_array, 'i31_p02');

	$query_i31 = "SELECT GROUP_CONCAT(p02 SEPARATOR ',')  AS i31_p02s FROM i31 WHERE p01 = :v101 AND p02 in ( ". $i31_p02_in['sql'] . ")";

	pegasus_mysql_use($query_i31, $res_i31, array_merge(array("v101"=>$v101), $i31_p02_in['sqlParams']));

	if(!empty($res_i31['i31_p02s'])) {
		$i31_p02 = explode(',', $res_i31['i31_p02s']);

		$error_msg = $_SESSION["peg_dic_serial_already_submitted"]."</br>";

		$error_msg .= "<ul>";

		foreach($i31_p02 as $p02) {
			$error_msg .= "<li>".$p02."</li>";
		}

		$error_msg .= "</ul>";

		$ret_arr['ok']  = 0;
		$ret_arr['msg'] = $error_msg;
		echo json_encode($ret_arr);
		return;
	}

	$last_key = $last_key + 1; // Για να πάρω το επόμενο.
	foreach($sn_array as $sn){
		if(!empty($sn)){
			$new_sn = array();
			$new_sn['i32_rec_nr01_'.$last_key] = ""; // Ό,τι καινούριο μπαίνει, θα έχει κενό ΜΚ.
			$new_sn['i32_rec_p01_'.$last_key] = trim($sn); //trim για το spacebar

			// Προσθήκη του νέου SN στο array που θα επιστρέψω.
			$new_serials_array[] = $new_sn;
			$last_key++;
		}
	}
//* Αν $new_serial_memo κενό, έχω έρθει από αυτόματη δημιουργία serial σύμφωνα με το πρότυπο
} else {
	$count = count($new_serials_array); // Πόσες εγγραφές έχω. Προσοχή, δεν είναι απαραίτητα ίδιος αριθμός με το $last_key.
	$i_add_sn = $v103 - $count; // Ποσότητα - πόσα έχω στην οθόνη (το $count έχει και κενά)

	if ($i_add_sn > 0) {
		$exept = false;
		$last_key = $last_key + 1; // Για να πάρω το επόμενο.
		while ($i_add_sn > 0 and $exept == false) {

			$p02 = serial_new_sn($v101);
			if (!$p02) {
				$exept = true;
			} else {

				$new_sn = array();
				$new_sn['i32_rec_nr01_'.$last_key] = ""; // Ό,τι καινούριο μπαίνει, θα έχει κενό ΜΚ.
				$new_sn['i32_rec_p01_'.$last_key] = $p02; //Το serial
	
				// Προσθήκη του νέου SN στο array που θα επιστρέψω.
				$new_serials_array[] = $new_sn;
				$last_key++;
				$i_add_sn--;
			}
		}

		if ($exept) {
			$ret_arr['ok']  = 0;
			$ret_arr['msg'] = $_SESSION['peg_dic_serial_new_sn_failure'];
			echo json_encode($ret_arr);
			return;
		}
	}

}
$i32_records = array();
//Θέλω να το γυρίσω ως μονοεπίπεδο array.
foreach ($new_serials_array as $element) {
	$i32_records = array_merge($i32_records, $element);
}

$ret_arr['ok']  = 1;
$ret_arr['i32_records'] = $i32_records;
echo json_encode($ret_arr);
return;