<?php
    require_once("../retail00_00/header.php");

    global $PegInput;

    $PegInput->addVar(new peg_input_number('a01nr01'));
    $PegInput->addVar(new peg_input_number('a55p703'));
    $PegInput->addVar(new peg_input_number('a55p0121'));

    $a01_nr01 = $PegInput->getRequest('a01nr01');  // Πελάτης
    $p703     = $PegInput->getRequest('a55p703');  // Αποθήκη
    $p0121    = $PegInput->getRequest('a55p0121'); // Κατάστημα

    $ret_array = array();
    $ret_array['ok']   = 1;
    $ret_array['type'] = "success";
    $ret_array['msg']  = $_SESSION['peg_dic_retail00_chosen_invoice'];

    //? Από ότι έψαξα στο init του a55 μπαίνει εδώ [invoices_find_p03_data] και ελέγχει για το default παραστατικό από πελάτη/προμηθευτή
    //? Άρα κάπως έτσι καλύπτεται και αυτή την περίπτωση.
    // Επομένως για την ενέργεια του αρχικού παραστατικού θα πρέπει να κάνω τον έλεγχο έξω από την [retail00_find_a55p05]

    $ret_array['a55p05'] = pegasus_mysql_printfld("a01", "p101", "nr01 = :a01_nr01", array("a01_nr01"=>$a01_nr01));

    if(empty($ret_array['a55p05'])) {
        $ret_array['a55p05'] = retail00_find_a55p05($p0121, $p703);

        if(empty($ret_array['a55p05'])) {
            $ret_array['ok']   = 0;
            $ret_array['type'] = "alert";
            $ret_array['msg']  = $_SESSION['peg_dic_retail00_not_found_initial_invoice'];
        }
    }

    echo json_encode($ret_array);
    return;