var _retail01_ecr_sim_container_id = '';
function retail01_set_ecr_sim_container_id(value) {
	_retail01_ecr_sim_container_id = value;
}
function retail01_get_ecr_sim_container_id() {
	return _retail01_ecr_sim_container_id;
}


// Retail Standard Action: ECR Simulation
function retail01_1000_retail00_std_action(container_id) {
	let is_mobile = 0;
	var parent_d = 'retail00_01_d';
	let responsive = '';
	var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , 0 , parent_d );
	var retail00_01_d00_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d00'   , 0 , parent_d ); // Desktop only: Αλλάζω σε αυτο το container_id για να πιάνει μόνο τη δεξιά πλευρά στο full screen.
	if(!retail00_01_d_container_id) {
		parent_d = 'retail00_02_d';
		is_mobile = 1;
		responsive = 'tablet';
		retail00_01_d00_container_id = container_id;
	}

	if(parent_d == 'retail00_02_d' && is_mobile == 1) {
		pegGetCmp(pegGetContainer_id_d(container_id , parent_d, 0, parent_d ) + '_tabs_1').setActiveTab(Ext.getCmp(retail01_get_ecr_sim_container_id()).up().id);
		return;
	}
	
    peg_windowShow_d(
		'', '_retail01_ecr_sim_d', 'retail01', retail00_01_d00_container_id, '', 0 , '', '',  
		{
			peg_screen_parent_container_id: retail00_01_d00_container_id,
			mmnr01: 'a55_d-' + pegGetVal_d('a55nr01', container_id, 'retail00_01_d04', '', parent_d),
			mnr01: pegGetVal_d('a55nr01', container_id, 'retail00_01_d04', '', parent_d),
			is_mobile: is_mobile
		},
		false,true,0,0, responsive
	);
}


function retail01__retail01_ecr_sim_d_afterDraw_listeners(container_id) {
	let screen 	= pegGetCmp(container_id);
    let p00     = pegGetCmp(container_id, 'ecr_p00');
    let p01     = pegGetCmp(container_id, 'ecr_p01');
	let ecr_item_memo = pegGetCmp(container_id, 'ecr_item_memo');
	let but_exit = pegGetCmp(container_id, 'but_exit');
	let but_submit_ecr = pegGetCmp(container_id, 'but_submit_ecr');
	let but_ecr_actions = pegGetCmp(container_id, 'but_ecr_actions');
	let helper  = pegGetCmp(container_id, 'helper');
	let ecr_items_grid = pegGetCmp(container_id, 'ecr_items_grid');

	retail01_set_ecr_sim_container_id(container_id);

	pegGetCmp(container_id, 'but_submit_ecr').setText('<b><big>'+pegGetVal('v_init_tot', container_id)+'€</big></b><br>Πληρωμή & Έκδοση' + ' ' + retail00_get_retail00_01_d__lektiko_par());
	
	// Για να κάνει focus στον helper ό,τι και αν πατήσω στην οθόνη.
	pegGetCmp(container_id).getEl().on('click', function (params) {
		// if(!peg002_IsMobileScreen() || !peg002_IsTabletScreen()){
			helper.focus();
		// }
	});

	let retail00_01_d03_container_id = '';
	let retail00_02_d_container_id = '';
	let retail00_02_d00_container_id = '';

	//TODO Να το δω με Μαρίνα για να παιξει το align από το screen _d ή αλλιώς να το κάνουμε ίσως με setPosition στην afterdraw.
	if(!peg002_IsMobileScreen() && !peg002_IsTabletScreen()){
		pegGetCmp('win_'+screen.peg_screen_parent_container_id+'___retail01_ecr_sim_d_retail01_0').alignTo(pegGetCmp(screen.peg_screen_parent_container_id), 'c-br?');
	}else{
		retail00_02_d_container_id = pegGetContainer_id_d(container_id, 'retail00_02_d', 0, 'retail00_02_d');
		retail00_02_d00_container_id = pegGetContainer_id_d(container_id, 'retail00_02_d00', 0, 'retail00_02_d');
		retail00_01_d03_container_id = pegGetContainer_id_d(container_id, 'retail00_01_d03', 0, 'retail00_02_d');
	}
	// pegGetCmp('helper').alignTo(pegGetCmp(screen.peg_screen_parent_container_id), 'c-br?');

	var decimalSeparator = PEGASUS.GENERAL.NUMBER.decimalSeparator;
	p00.on('change', function(me, newValue, oldValue, eOpts ){
		let tmp_val_p00 = pegGetVal('ecr_p00', container_id);
		let tmp_val_p01 = pegGetVal('ecr_p01', container_id);
		let tmp_val_tot = (tmp_val_p00*tmp_val_p01).toFixed(2);
		if(!tmp_val_p00.includes('.') || !tmp_val_p00.includes(',')){
			tmp_val_p00 = tmp_val_p00.replace(',',decimalSeparator).replace('.',decimalSeparator);
		}
		if(!tmp_val_tot.includes('.') || !tmp_val_tot.includes(',')){
			tmp_val_tot = tmp_val_tot.replace(',',decimalSeparator).replace('.',decimalSeparator);
		}

		Ext.query('._retail01_ecr_sim_d_ecr_item_memo_price')[0].innerHTML = tmp_val_p00;
		Ext.query('._retail01_ecr_sim_d_ecr_item_memo_total')[0].innerHTML = tmp_val_tot;
	});

	p01.on('change', function(me, newValue, oldValue, eOpts ){
		let tmp_val_p00 = pegGetVal('ecr_p00', container_id);
		let tmp_val_p01 = pegGetVal('ecr_p01', container_id).toString(); //Το έχω numberbox για να με βολεύει στους υπολογισμούς, για την προβολή toString για να παίξει η includes
		let tmp_val_tot = (tmp_val_p00*tmp_val_p01).toFixed(2);
		if(!tmp_val_p01.includes('.') || !tmp_val_p01.includes(',')){
			tmp_val_p01 = tmp_val_p01.replace(',',decimalSeparator).replace('.',decimalSeparator);
		}
		if(!tmp_val_tot.includes('.') || !tmp_val_tot.includes(',')){
			tmp_val_tot = tmp_val_tot.replace(',',decimalSeparator).replace('.',decimalSeparator);
		}
		Ext.query('._retail01_ecr_sim_d_ecr_item_memo_quantity')[0].innerHTML = tmp_val_p01;
		Ext.query('._retail01_ecr_sim_d_ecr_item_memo_total')[0].innerHTML = tmp_val_tot;
	});

	helper.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == '') {
			return;
		}
		let tmp_val_helper = newValue;

		const is_number = /\d/;
		const is_eng_char = /[a-zA-Z]/;
		// const is_gr_char = /[α-ωΑ-Ω]/;
		const is_gr_char = /[\w;ΣΕΡΤΥΘΙΟΠΑΣΔΦΓΗΞΚΛΖΧΨΩΒΝΜ]/gi;
		const is_symbol = /[.,*\/]/;

		switch (true) {
			case is_number.test(tmp_val_helper):
				retail01_ecr_set_val(container_id, tmp_val_helper);
				break;
			case is_eng_char.test(tmp_val_helper):
				retail01_find_dept_and_add_item(container_id, tmp_val_helper);
				break;
			case is_gr_char.test(tmp_val_helper):
				retail01_find_dept_and_add_item(container_id, tmp_val_helper);
				break;
			case is_symbol.test(tmp_val_helper):
				retail01_ecr_set_val(container_id, tmp_val_helper);
				break;
		}

		
		pegSetVal('helper', container_id, '');
	});

	helper.on('keydown', function (me, e) {
		if (e.keyCode == 9) {
			// Αυτό δεν παίζει, εκτελεί το tab όπως και να'χει
			pegToast('TAB PRESSED');
			helper.focus();
			return false;
		}
	});
	but_exit.on('click', function(me) {
		if (screen.peg_inWindow == 1) {
			pegWindowClose(container_id);
		} else {
			pegTabClose(pegGetCmp(container_id).peg_tabid);
		}
	});
	but_submit_ecr.on('click', function(me) {

		let parent_container_id = screen.peg_screen_parent_container_id;
		if(!parent_container_id) {
			parent_container_id = retail01_get_ecr_sim_container_id();
		}

		let retail00_01_d_container_id   = pegGetContainer_id_d(parent_container_id , 'retail00_01_d'   , 0 , 'retail00_01_d' );
		let parent_d = 'retail00_01_d';
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
			retail00_01_d_container_id   = pegGetContainer_id_d(parent_container_id , 'retail00_02_d'   , 0 , parent_d );
		}
		let retail00_01_d04_container_id   = pegGetContainer_id_d(parent_container_id , 'retail00_01_d04'   , 0 , parent_d );

		pegSetVal('a55pweb01', retail00_01_d04_container_id, 0);
		retail00_check_shift(parent_container_id, retail00_check_customer, retail00_check_aneisprakto);
	});

	ecr_items_grid.on('select', function (view, record, item, index, e, opts) {
		var row = pegGridGetSelectedRow(container_id,  'ecr_items_grid');
		retail00_set_retail00_01_d03_onchange_pause(true);
		
		pegGetCmp(retail00_02_d00_container_id, 'items_grid').getSelectionModel().deselectAll(true);
		retail00_get_i01_data(row.nr01, retail00_02_d_container_id);
	});

	ecr_items_grid.on('deselect', function (view, record, item, index, e, opts) {
		retail00_set_retail00_01_d03_onchange_pause(true);
		// With -1 we clear Item tab, we need it on the last item delete.
		pegGetCmp(retail00_02_d00_container_id, 'items_grid').getSelectionModel().deselectAll(true);
		retail00_get_i01_data(-1, retail00_02_d_container_id);
	});

	ecr_items_grid.on('itemdblclick', function( view, record, item, index, e, opts){
		pegGetCmp(retail00_02_d_container_id + '_tabs_1').setActiveTab(Ext.getCmp(retail00_01_d03_container_id).up().id);
	});

	but_ecr_actions.setPeg_handler(function(me){
	peg_windowShow_d(
		'',
		'retail00_02_d03' ,
		'retail00',
		container_id,
		'',
			0 ,
		'',
		'',  
		{
			peg_screen_parent_container_id:container_id
		},
		false,true,0,0,'tablet'
	);	
});

}

function retail01_ecr_set_val(container_id, val = '') {
    let p00_val = pegGetVal('ecr_p00', container_id);
    if(val == '*') {
        pegSetVal('ecr_p00', container_id, 0);
        if(p00_val > 0) {
            pegSetVal('ecr_p01', container_id, p00_val);
        }
    }else if(val == '/' || val == '') {
        pegSetVal('ecr_p00', container_id, 0);
        pegSetVal('ecr_p01', container_id, 1);
    }else if(val == '.' || val == ',') {
		if(!p00_val.includes('.')) {
			pegSetVal('ecr_p00', container_id, p00_val + '.');
		}
	}
	else{
		if(p00_val === "0" || isNaN(Number(p00_val))) {
			p00_val = '';
		}
        pegSetVal('ecr_p00', container_id, p00_val + val);
    }

	let p00 = pegGetCmp(container_id, 'ecr_p00');
	p00.focus();
    
    return false;
}

var retail01_find_dept_and_add_item_ajax = '';
function retail01_find_dept_and_add_item(container_id, val = '') {
    if (retail01_find_dept_and_add_item_ajax != '') {
		if (retail01_find_dept_and_add_item_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(retail01_find_dept_and_add_item_ajax);
		}
	}
    var params = {
		val: val,
		container_id: container_id
	}
	
	retail01_find_dept_and_add_item_ajax = pegAjaxDefer('/' + main_path + '/retail01_01/retail01_find_dept_and_add_item.php', params, function (jsondata) {
		let values = {code : jsondata.i00pno, is_ecr : jsondata.is_ecr};
		retail00_add_item_new(container_id, values);
    }, 'json', 1);
}

var retail01_ecr_dept_shift_ajax = '';
function retail01_ecr_dept_shift(container_id, page = 0) {
    if (retail01_ecr_dept_shift_ajax != '') {
		if (retail01_ecr_dept_shift_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(retail01_ecr_dept_shift_ajax);
		}
	}
    var params = {
		page: page,
		container_id: container_id
	}

	retail01_ecr_dept_shift_ajax = pegAjaxDefer('/' + main_path + '/retail01_01/retail01_ecr_dept_shift.php', params, function (jsondata) {
        pegSetVal('ecr_memo', container_id, jsondata.ecr_memo);
    });
}