<?php

function peg_retail01__retail01_ecr_sim_d_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {

    global $PegInput;
	$PegInput->addVar(new peg_input_number('is_mobile')); 
    $is_mobile = $PegInput->getRequest('is_mobile');   

    $data['ecr_memo'] = retail01_draw_ecr_memo($container_id, 0, $is_mobile);
    $data['p01'] = 1; // Ποσότητα
    $data['p00'] = 0; // Τιμή
    $data['ecr_item_memo'] = retail01_draw_ecr_item_memo($data, $container_id);

    // $data["{module}_{_d}_{tab name}_hidden_mobile"] 
    $data["retail01__retail01_ecr_sim_d_ecr_items_grid_hidden_mobile"] = false;
    $data["retail01__retail01_ecr_sim_d_but_submit_ecr_hidden_mobile"] = false;
    $data["retail01__retail01_ecr_sim_d_but_exit_hidden_mobile"] = true;
    $data["retail01__retail01_ecr_sim_d_but_ecr_actions_hidden_mobile"] = false;
    // $data["retail01__retail01_ecr_sim_d_fldcont03_hidden_mobile"] = false;

    $totals = invoices_get_total_var('retail00_01', $mnr01);
    if(empty($totals)) {
        $totals = array();
        $totals['p0109'] = 0;
    }
    $data['v_init_tot'] = peg002_format_number($totals['p0109'], 2, 1);
    //* To χρησιμοποιώ για να βρω το _where_eidi στη mobile ταμειακή.
    pegasusSetGlobalVar($container_id . '_ecr_sim_a55nr01',   $mnr01);

    return $data;
}

function retail01_draw_ecr_item_memo($data, $container_id) {
    $style = 
        '<style>
            ._retail01_ecr_sim_d_ecr_item_memo_container {
                text-align: left;
                display: flex;
                flex-direction: row;
                justify-content: space-between;
                background-color: #f3f3f3;
                color: #333;
                font-size: 18px;
                border-radius: 5px;
                padding: 10px;
            }
            ._retail01_ecr_sim_d_ecr_item_memo_divider {
                font-weight: bold;
            }
            ._retail01_ecr_sim_d_ecr_item_memo_total {
                font-weight: bold;
                color: #00d26d;
            }
        </style>
    ';
    $tmp_total = peg002_format_number(0, 2);
    $html = '
        <div class="_retail01_ecr_sim_d_ecr_item_memo_container">
            <div class="_retail01_ecr_sim_d_ecr_item_memo_price_x_quan">
                <span class="_retail01_ecr_sim_d_ecr_item_memo_quantity"> ' . $data['p01'] . ' </span>
                <span class="_retail01_ecr_sim_d_ecr_item_memo_divider"> x </span>
                <span class="_retail01_ecr_sim_d_ecr_item_memo_price"> ' . $data['p00'] . ' </span>
            </div>
            <div class="_retail01_ecr_sim_d_ecr_item_memo_total"> '.$tmp_total.' </div>
        </div>
    ';

    $memo = $style . $html;
    return $memo;
}

function retail01_draw_ecr_memo($container_id, $page = 0, $is_mobile = 0) {

    $limit = " LIMIT " . $page . " , " . 6;
    $retail01_01_query = 'SELECT * FROM retail01_01 WHERE tax >= 0 ' . $limit;
    $res = pegasus_query($retail01_01_query);
    
    $departments_cnt = pegasus_num_rows($res);
    $departments = '';
    while($row = pegasus_fetch_assoc($res)) {
        $add_item_params = array();
        $add_item_params['code'] = $row['i00pno'];
        $add_item_params['is_ecr'] = $row['en_zeroprc'] == 1 ? 2 : 1; // Αν επιτρέπεται η καταχώρηση με μηδενική τιμή, δίνω 2.
        $i00_name_fld = 'name';
        if($_SESSION['lang'] != 'GR') {
            $i00_name_fld = 'ename';
        }
        $i00_name = pegasus_mysql_printfld('i00', $i00_name_fld, 'pno = ?', array($row['i00pno']));
        //* Βάζω max-length και ... γιατί το justify content δεν παίζει καλά με μεγάλες περιγραφές σε iOS συσκευές.
        $max_length = 50;
        if($is_mobile == 1) {
            $max_length = 25;
        }
        if(mb_strlen($i00_name) >= $max_length) {
            $i00_name = mb_substr($i00_name, 0,  $max_length-3) . "...";
        }

        $departments .= '<div class="_retail01_ecr_sim_d_ecr_memo_container_buttons departments" onclick="retail00_add_item_new(\''.$container_id.'\', '.htmlspecialchars(json_encode($add_item_params)).')">';
        $departments .= '<div class="department_code">' . $row['p00'] . '</div>';
        $departments .= '<div class="department_i00pno">' . $i00_name . '</div>';
        $departments .= '</div>';
    }
    $next_page = $page + $departments_cnt;
    pegasus_mysql_use("SELECT count(*) as cnt FROM retail01_01 WHERE tax >= 0", $departments_total);
    // echo '<pre>' .$departments_total['cnt']. '</pre>';
    if($next_page >= $departments_total['cnt']) {
        $next_page = 0;
    }

    $style = '  <style>
                    ._retail01_ecr_sim_d_ecr_memo_container {
                        text-align: left;
                        display: flex;
                    }
                    ._retail01_ecr_sim_d_ecr_memo_container_left {
                        width: 50%;
                    }
                    ._retail01_ecr_sim_d_ecr_memo_container_right {
                        width: 50%;
                    }
                    ._retail01_ecr_sim_d_ecr_memo_container_rows {
                        display: flex;
                        align-content: center;
                        flex-wrap: wrap;
                        justify-content: flex-start;
                    }
                    ._retail01_ecr_sim_d_ecr_memo_container_buttons {
                        display: inline-block;
                        background-color: #e9e9e9;
                        width: 33%;
                        box-sizing: border-box;
                        border: 2px solid white;
                        text-align: center;
                        font-weight: bold;
                        cursor: pointer;
                        
                        display: flex;
                        height: 55px;
                        align-content: center;
                        flex-wrap: wrap;
                        justify-content: space-evenly;
                        align-items: center;
                        font-size: 25px;
                        color: #333;
                    }
                    ._retail01_ecr_sim_d_ecr_memo_container_right ._retail01_ecr_sim_d_ecr_memo_container_buttons {
                        background-color: #b6e9fb;
                    }
                    ._retail01_ecr_sim_d_ecr_memo_container_buttons.quan {
                        background-color: #333;
                        color: #ffffff;
                    }
                    ._retail01_ecr_sim_d_ecr_memo_container_buttons.clear {
                        background-color: #f23a3a;
                        color: #ffffff;
                        width: 50%;
                    }
                    ._retail01_ecr_sim_d_ecr_memo_container_buttons.dept_shift {
                        background-color: #dfffe2;
                        width: 50%;
                    }
                    ._retail01_ecr_sim_d_ecr_memo_container_buttons.departments {
                        display: flex;
                        flex-direction: column;
                        align-items: center;
                        flex-wrap: nowrap;
                        overflow: hidden;
                        width: 50%;
                        font-weight: normal;
                        font-size: 22px;
                    }

                    ._retail01_ecr_sim_d_ecr_memo_container_buttons.departments .department_i00pno {
                        font-weight: normal;
                        font-size: 13px;
                        word-break: break-all;
                    }
                    ._retail01_ecr_sim_d_ecr_memo_container_buttons.departments_empty {
                        background-color: #c7e2ec;
                        width: 50%;
                        font-weight: normal;
                        font-size: 22px;
                        cursor: not-allowed;
                    }
                    
                </style>';

    $html = '<div class="_retail01_ecr_sim_d_ecr_memo_container">
                <div class="_retail01_ecr_sim_d_ecr_memo_container_left">
                    <div class="_retail01_ecr_sim_d_ecr_memo_container_rows">
                        <div class="_retail01_ecr_sim_d_ecr_memo_container_buttons" onclick="retail01_ecr_set_val(\''.$container_id.'\', \''.'7'.'\')">7</div>
                        <div class="_retail01_ecr_sim_d_ecr_memo_container_buttons" onclick="retail01_ecr_set_val(\''.$container_id.'\', \''.'8'.'\')">8</div>
                        <div class="_retail01_ecr_sim_d_ecr_memo_container_buttons" onclick="retail01_ecr_set_val(\''.$container_id.'\', \''.'9'.'\')">9</div>

                        <div class="_retail01_ecr_sim_d_ecr_memo_container_buttons" onclick="retail01_ecr_set_val(\''.$container_id.'\', \''.'4'.'\')">4</div>
                        <div class="_retail01_ecr_sim_d_ecr_memo_container_buttons" onclick="retail01_ecr_set_val(\''.$container_id.'\', \''.'5'.'\')">5</div>
                        <div class="_retail01_ecr_sim_d_ecr_memo_container_buttons" onclick="retail01_ecr_set_val(\''.$container_id.'\', \''.'6'.'\')">6</div>
                        

                        <div class="_retail01_ecr_sim_d_ecr_memo_container_buttons" onclick="retail01_ecr_set_val(\''.$container_id.'\', \''.'1'.'\')">1</div>
                        <div class="_retail01_ecr_sim_d_ecr_memo_container_buttons" onclick="retail01_ecr_set_val(\''.$container_id.'\', \''.'2'.'\')">2</div>
                        <div class="_retail01_ecr_sim_d_ecr_memo_container_buttons" onclick="retail01_ecr_set_val(\''.$container_id.'\', \''.'3'.'\')">3</div>

                        <div class="_retail01_ecr_sim_d_ecr_memo_container_buttons quan" onclick="retail01_ecr_set_val(\''.$container_id.'\', \''.'*'.'\')">X</div>
                        <div class="_retail01_ecr_sim_d_ecr_memo_container_buttons" onclick="retail01_ecr_set_val(\''.$container_id.'\', \''.'0'.'\')">0</div>
                        <div class="_retail01_ecr_sim_d_ecr_memo_container_buttons" onclick="retail01_ecr_set_val(\''.$container_id.'\', \''.'.'.'\')">.</div>
                    </div>
                </div>
                <div class="_retail01_ecr_sim_d_ecr_memo_container_right">
                    <div class="_retail01_ecr_sim_d_ecr_memo_container_rows">
                        <div class="_retail01_ecr_sim_d_ecr_memo_container_buttons dept_shift" onclick="retail01_ecr_dept_shift(\''.$container_id.'\', \''.$next_page.'\')"><i class="fa fa-retweet"></i></div>
                        <div class="_retail01_ecr_sim_d_ecr_memo_container_buttons clear" onclick="retail01_ecr_set_val(\''.$container_id.'\', \''.''.'\')">C</div>
                        ##departments##
                    </div>
                </div>
            </div>';

    if($departments_cnt < 6) {
        for($i = $departments_cnt; $i < 6; $i++ ) {
            $departments .= '<div class="_retail01_ecr_sim_d_ecr_memo_container_buttons departments_empty"></div>';
        }
    }

    $html = str_replace('##departments##', $departments, $html);

    $memo = $style . $html;
    return $memo;
}

function retail01_translate_dept($val = '') {
    $val = mb_strtolower($val);
    $mapping = array(
        ';' => 'q',
        'ς' => 'w',
        'ε' => 'e',
        'ρ' => 'r',
        'τ' => 't',
        'υ' => 'y',
        'θ' => 'u',
        'ι' => 'i',
        'ο' => 'o',
        'π' => 'p',
        'α' => 'a',
        'σ' => 's',
        'δ' => 'd',
        'φ' => 'f',
        'γ' => 'g',
        'η' => 'h',
        'ξ' => 'j',
        'κ' => 'k',
        'λ' => 'l',
        'ζ' => 'z',
        'χ' => 'x',
        'ψ' => 'c',
        'ω' => 'v',
        'β' => 'b',
        'ν' => 'n',
        'μ' => 'm'
    );
    $ret_val = '';
    // Αν το value ειναι ελληνικα θα το βρει απο το isset, αν είναι αγγλικά, από το in_array
    if(isset($mapping[$val])) {
        $ret_val = $mapping[$val];
        $ret_val = mb_strtoupper($ret_val);
    }
    if(in_array($val, $mapping)) {
        $ret_val = mb_strtoupper($val);
    }
    return $ret_val;
}