<?php

function shifts_erpa82_d_initialize($data, $mmnr01 = '',$mnr01 = '', $_d ='', $container_id = ''){
	$new_rec = 0;
	if (empty($data['nr01'])) {
		$new_rec = 1;
		$data['nr01'] = pegasus_mysql_newrec('erpa82');
	}
	if (empty($data['p02'])) {
		$data['p02'] = date('Y-m-d');
	}
	if (empty($data['p03'])) {
		$data['p03'] = date('H:i');
	}

	if(pegasus_check_permission('shifts.master') && $new_rec == 0){
		$data['message'] = 	 '<div class="warning_message">' . $_SESSION['peg_dic_shifts_has_shifts_master'] . '</div>';
	}else{
		$data['message_hidden'] = 	true;
	}
	

	$data['mmnr01'] = $mmnr01;
	$data['mnr01'] = $mnr01;

	shifts_erpa82_d_set_grid_query($container_id, $data);
	$data['shifts_erpa82_d00_grid_account_view_relation_hidden'] = false;
	$data['shifts_erpa82_d00_grid_account_copy_t01_hidden'] = false;

	if(!pegasus_check_permission('shifts.master') && $new_rec == 0){
		$data['p02_readonly'] = true;
		$data['p03_readonly'] = true;
		$data['p06_readonly'] = true;

		if(!empty($data['p04']) && $data['p04'] != '0000-00-00'){
			$data['p04_readonly'] = true;
		}
	
		if(!empty($data['p05'])){
			$data['p05_readonly'] = true;
			$data['p07_readonly'] = true;

		}

	}

	return $data;
}
function shifts_erpa82_d_set_grid_query($container_id, $data)
{

	$mmnr01 = $data['mmnr01'];
	if(peg_dateIsEmpty($data['p04'])){
		$tmp_dt = date('Y-m-d');
	}else{
		$tmp_dt = $data['p04'];
	}
	
	if(empty($data['p05'])){
		$time_to= date('H:i');
	}else{
		$time_to = $data['p05'];
	} 
	 
	pegasusSetGlobalVar(
		'peg_' . $container_id . '_grid_where',
		array(
			'sql' => ' t01.p401=:tmp_p01 AND (:tmp_df < t01.p02 OR (:tmp_df = t01.p02 AND :time_from <= t01.p02t) ) AND
			(t01.p02 < :tmp_dt OR (:tmp_dt = t01.p02 AND t01.p02t <= :time_to) ) ',
			'sqlParams' => array('tmp_p01' => $data['p01'], 'tmp_df' => $data['p02'], 'tmp_dt' => $tmp_dt, 
							'time_from' => $data['p03'], 'time_to' => $time_to)
		)
	);

	
	$tmp_array = shifts_erpa82_d_find_grid_query($mmnr01, $data, $tmp_dt, $time_to );
	
	pegasusSetGlobalVar(
		'peg_' . $container_id . '_grid_query_2',
		array(
			'sql' => $tmp_array['sql'],
			'sqlParams' => $tmp_array['sqlParams']
		)
	);

}


/**
 * @param string $mmnr01 
 * @param array $data
 */
function shifts_erpa82_d_find_grid_query($mmnr01, $data, $tmp_dt, $time_to)
{
	
	$erpa82_d_params = array();
	$erpa82_d_params['tmp_dt']  = $tmp_dt;
	$erpa82_d_params['time_to']  = $time_to;
	$erpa82_d_params['tmp_df']  = $data['p02'];
	$erpa82_d_params['time_from']  = $data['p03'];
	$erpa82_d_params['tmp_p01']  = $data['p01'];
	 

	$tmp_query = "  SELECT
						p02 as p02,
						sum(p03) as p03,
						sum(p04) as p04,
						sum(p03-p04) as ypol,
						p303 as p303
					FROM
					(       /**************************
							t1=all transactions
						**************************/
						select 
								t02.p02 as p02,
								(t01.p03+t01.p04) * if(t02.p010>0, 1, 0) as p03,
								(t01.p03+t01.p04) * if(t02.p010<0, 1, 0) as p04,
								t06.p02 as p303
						FROM t01
						LEFT JOIN t02 ON t02.p01=t01.p07
						LEFT JOIN us0 ON us0.p01=t01.p401
						LEFT JOIN t06 on t01.p303=t06.p01
						WHERE (:tmp_df < t01.p02 OR (:tmp_df = t01.p02 AND :time_from <= t01.p02t) ) 
							AND (t01.p02 < :tmp_dt OR (:tmp_dt = t01.p02 AND t01.p02t <= :time_to) )
							AND t02.p010<>0
							AND t01.p401=:tmp_p01
					) as t1
					GROUP BY p02 ";

	//  peg_write_file('../../tmp/account_balance.sql',pegasus_replace_values_in_sql($tmp_query,$erpa82_d_params));
	// echo pegasus_replace_values_in_sql($tmp_query, $erpa82_d_params);
	return array(
		'sql' => $tmp_query,
		'sqlParams' => $erpa82_d_params
	);
}

function shifts_erpa82_d03_where($container_id, $data)
{
	if (substr($data['mmnr01'], 0, strlen('este55_d')) == 'este55_d') {
		$data['p01'] = pegasus_mysql_printfld('us0', 'p01', 'nr01=?', array($data['p03']));
	}

	pegasusSetGlobalVar(
		'peg_' . $container_id . '_erpa82_d03_grid_where',
		array(
			'sql' => ' erpa82.p01 =:p01 ',
			'sqlParams' => array('p01' => $data['p01'])
		)
	);
}


function shifts_grid_custom_actions($retArray = array())
{
	$peg_handler = 'shifts_erpa82_d03_new(screen.getContainer_ID());';
	$retArray[]  = array(
		'xtype' => 'pegasusToolBarGridAction',
		'peg_custom_id' => 'shifts_shift_new',
		'viewModel' => array(
			'type' => 'GridButtonModel',
			'isToolBar' => 1,
			'data' => array(
				'toolBarButton' => 'shifts_shift_new',
			)
		),
		'icon' => 'shifts_images/plus_16x16.png',
		'text' =>  $_SESSION['peg_dic_shifts_open_shift'],
		'peghandler' => $peg_handler
	);
	
	$peg_handler = 'shifts_erpa82_d03_close(screen.getContainer_ID());';
	$retArray[]  = array(
		'xtype' => 'pegasusToolBarGridAction',
		'peg_custom_id' => 'shifts_shift_close',
		'viewModel' => array(
			'type' => 'GridButtonModel',
			'isToolBar' => 1,
			'data' => array(
				'toolBarButton' => 'shifts_shift_close',
			)
		),
		'icon' => 'shifts_images/cancel_16x16.png',
		'text' =>  $_SESSION['peg_dic_shifts_close_shift'],
		'peghandler' => $peg_handler
	);

	
	return $retArray;
}

function shifts_erpa82_d03_initialize($data, $mmnr01 = '',$mnr01 = '', $_d ='', $container_id = ''){

	$data['shifts_erpa82_d03_grid_shifts_shift_close_hidden'] = false;
	$data['shifts_erpa82_d03_grid_shifts_shift_new_hidden'] = false;

	//να μπει στο initialize
	shifts_erpa82_d03_where($container_id, $data);
	return $data;
}
function shifts_shifts_01_d_initialize($data, $mmnr01 = '',$mnr01 = '', $_d ='', $container_id = ''){

	$data['shifts_shifts_01_d_grid_shifts_shift_close_hidden'] = false;
	$data['shifts_shifts_01_d_grid_shifts_shift_new_hidden'] = false;

	return $data;
}

function shifts_find_open_shift($user = '') {

	if(empty($user)) {
		$user = pegasus_mysql_printfld('us0', 'p01', 'nr01 = ?', array($_SESSION['user']));
	}
	
    $php_curdate = date('Y-m-d'); // PHP current date
    $php_curtime = date('H:i:s'); // PHP current time

    $query = "SELECT 
                * 
            FROM erpa82 
            WHERE 
                p05 = '' 
                AND STR_TO_DATE(p02, '%Y-%m-%d') <= :php_curdate
                AND (
                    STR_TO_DATE(p02, '%Y-%m-%d') < :php_curdate
                    OR (STR_TO_DATE(p02, '%Y-%m-%d') = :php_curdate AND STR_TO_DATE(p03,'%H:%i:%s') <= :php_curtime)
                )
                AND p01 = :user
    ";
    $queryParams = array(
        "user" => $user,
        "php_curdate" => $php_curdate,
        "php_curtime" => $php_curtime
    );
    pegasus_mysql_use($query, $erpa82, $queryParams);

	if(empty($erpa82)) {
        $erpa82 = array();
    }
    return $erpa82;
}


function shifts_save_shift($data, $mode) {
    $ret = array();
    $ret['msg'] = '';
    if($mode == 'start'){
        $arr1 = array();				$arr2 = array();
        array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('erpa82'));
        array_push($arr1, 'p01');		array_push($arr2, $data['p01']); // Χρήστης 
        array_push($arr1, 'p02');		array_push($arr2, $data['p02']); // Ημ/νια Ανοίγματος
        array_push($arr1, 'p03');		array_push($arr2, $data['p03']); // Ώρα Ανοίγματος
        array_push($arr1, 'p06');		array_push($arr2, $data['p06']); // Ποσό Ανοίγματος

        pegasus_mysql_insert('erpa82', $arr1, $arr2);
        // Βρες τη βάρδια από τη βάση και επίστρεψε τη στο $ret
        $erpa82 = shifts_find_open_shift();
        $ret = array_merge($ret, $erpa82);
    }
    if($mode == 'end'){
        $arr1 = array();				$arr2 = array();
        array_push($arr1, 'p04');		array_push($arr2, $data['p04']); // Ημ/νια Κλεισίματος
        array_push($arr1, 'p05');		array_push($arr2, $data['p05']); // Ώρα Κλεισίματος
        array_push($arr1, 'p07');		array_push($arr2, $data['p07']); // Ποσό Κλεισίματος

        $where = ' p01 = :user AND p02 = :p02 AND p03 = :p03';
        $whereValues = array(
            'user'  => $data['p01'],
            'p02'   => $data['p02'],
            'p03'   => $data['p03']
        );
        pegasus_mysql_update('erpa82', $arr1, $arr2, $where, 0, 1, 1, $whereValues);
    }
    return $ret;
}

function shifts_erpa82_d04_initialize($data, $mmnr01 = '',$mnr01 = '', $_d ='', $container_id = ''){

	global $PegInput;
	       
    $PegInput->addVar(new peg_input_alphanumeric('us0_p01'));
	$PegInput->addVar(new peg_input_number('new'));

    $us0_p01   = $PegInput->getRequest('us0_p01');
    $new  		= $PegInput->getRequest('new');

	if(!empty($us0_p01)){
		$data['p01'] = $us0_p01;
	}

	
	if (empty($data['nr01'])) {
		$data['nr01'] = pegasus_mysql_newrec('erpa82');
	}
	

	if($new == 1){

		$data['p02'] = date('Y-m-d');
		$data['p03'] = date('H:i');
		
		$data['p04_hidden'] = true;
		$data['p05_hidden'] = true;
		$data['p07_hidden'] = true;
		
		
	}else{
		pegasus_mysql_use('SELECT p01, p06, p02, p03 FROM erpa82 WHERE nr01 = ? ', $erpa82 ,array($data['nr01']));

		if(empty($data['p04'])){
			$data['p04'] = date('Y-m-d');
		}
		if(empty($data['p05'])){
			$data['p05'] = date('H:i');
		}

		if(empty($data['p01'])){
			$data['p01'] = $erpa82['p01'];
		}

		$data['p02'] = $erpa82['p02'];
		$data['p03'] = $erpa82['p03'];
		if(empty($data['p06'])){
			$data['p06'] = $erpa82['p06'];
		}
		
		//if(!pegasus_check_permission('shifts.master')){
		$data['p02_readonly'] = true;
		$data['p03_readonly'] = true;
		$data['p06_readonly'] = true;
		//}
	}


	return $data;
}


function shifts_erpa82_onchange($data , $permDeny , $mmnr01 , $checkOnlyPerm, $grid_editing){
	$is_new = 1;
	if ($data['nr01'] > 0) {
		if (pegasus_mysql_printfld('erpa82', 'count(*)', 'nr01=? ', array($data['nr01'])) > 0) {
			$is_new = 0;
		}
	}

	if(empty($data['p02'])){
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_shifts_erpa82_p02_empty']));
	}

	if(empty($data['p03'])){
		array_push($permDeny, array('type' => 'deny', 'message' =>  $_SESSION['peg_dic_shifts_erpa82_p03_empty']));
	}

	if(empty($data['p04']) && $is_new == 0 ){
		array_push($permDeny, array('type' => 'deny', 'message' =>  $_SESSION['peg_dic_shifts_erpa82_p04_empty']));
	}

	if(empty($data['p05'])  && $is_new == 0 ){
		array_push($permDeny, array('type' => 'deny', 'message' =>  $_SESSION['peg_dic_shifts_erpa82_p05_empty']));
	}

	if($data['p06'] == ''){
		array_push($permDeny, array('type' => 'deny', 'message' =>  $_SESSION['peg_dic_shifts_erpa82_p06_empty']));
	}

	if($data['p07'] == '' && $is_new == 0){
		array_push($permDeny, array('type' => 'deny', 'message' =>  $_SESSION['peg_dic_shifts_erpa82_p07_empty']));
	}

	$erpa82 = shifts_find_open_shift($data['p01']);

    if(!empty($erpa82['nr01']) && $is_new == 1) {
		array_push($permDeny, array('type' => 'deny', 'message' =>  $_SESSION['peg_dic_shifts_must_close_shift'].' ('.$erpa82['nr01'].')'));
    }

	return array($data, $permDeny);

}